/*! For license information please see main.bea21571.js.LICENSE.txt */
(()=>{var e={895(e,t,n){"use strict";n.d(t,{MultiWalletManager:()=>l});var r=n(9379),s=n(1276),a=n(190),i=n(2241),o=n(899);class l{static saveWalletTokens(e,t,n){try{if(!e)return(0,o.sd)(i.A.t("multiwallet.error_wallet_id_invalid"),e),{success:!1,error:i.A.t("multiwallet.error_wallet_id_invalid")};if(!n)return(0,o.sd)(i.A.t("multiwallet.error_password_required_encrypt")),{success:!1,error:i.A.t("multiwallet.error_password_required_encrypt")};if(!Array.isArray(t))return(0,o.sd)(i.A.t("multiwallet.error_token_data_format"),t),{success:!1,error:i.A.t("multiwallet.error_token_data_format")};const r=s.SecureStorage.loadEncryptedTokens(n);if(!r.success&&!r.error.includes(i.A.t("multiwallet.error_no_wallets")))return(0,o.sd)(i.A.t("multiwallet.error_load_existing_tokens"),r.error),{success:!1,error:i.A.t("multiwallet.error_load_existing_tokens")};const a=r.data||{},l=t.filter(e=>e&&"object"===typeof e&&e.address&&e.symbol&&"string"===typeof e.address&&"string"===typeof e.symbol&&/^0x[a-fA-F0-9]{40}$/.test(e.address));a[e]=l;const c=s.SecureStorage.saveEncryptedTokens(a,n);return c.success?((0,o.UJ)(i.A.t("multiwallet.success_tokens_saved",{walletId:e,count:l.length})),l.length!==t.length&&(0,o._N)(i.A.t("multiwallet.warning_invalid_tokens_excluded",{count:t.length-l.length})),{success:!0,savedCount:l.length}):((0,o.sd)(i.A.t("multiwallet.error_save_encrypted_tokens"),c.error),c)}catch(r){(0,o.sd)(i.A.t("multiwallet.error_token_save_failed"),r);let e=i.A.t("multiwallet.error_token_save_failed");return"QuotaExceededError"===r.name?e=i.A.t("multiwallet.error_storage_quota"):r.message.includes("JSON")?e=i.A.t("multiwallet.error_token_format"):r.message.includes("password")&&(e=i.A.t("multiwallet.error_password")),{success:!1,error:e}}}static getWalletTokens(e,t){try{if(!t)return(0,o.sd)(i.A.t("multiwallet.error_password_required_decrypt")),[];const n=s.SecureStorage.loadEncryptedTokens(t);if(!n.success)return n.error.includes("password")?(0,o.sd)(i.A.t("multiwallet.error_decrypt_wrong_password")):(0,o._N)(i.A.t("multiwallet.error_token_load_failed"),n.error),[];const l=(n.data||{})[e]||[],c=a.b.getCurrentNetwork(),u=l.map(e=>e.network?e:(0,r.A)((0,r.A)({},e),{},{network:c.name}));return(0,o.UJ)(i.A.t("multiwallet.info_tokens_loaded",{walletId:e,count:u.length})),u}catch(n){return(0,o.sd)(i.A.t("multiwallet.error_token_load_failed"),n),[]}}static getAllWalletTokens(e){try{if(!e)return(0,o.sd)(i.A.t("multiwallet.error_password_required_all_tokens")),{};const t=s.SecureStorage.loadEncryptedTokens(e);return t.success?t.data||{}:((0,o._N)(i.A.t("multiwallet.error_all_tokens_load_failed"),t.error),{})}catch(t){return(0,o.sd)(i.A.t("multiwallet.error_all_tokens_query_failed"),t),{}}}static addTokenToWallet(e,t,n){try{if(!e)return(0,o.sd)(i.A.t("multiwallet.error_wallet_id_invalid")),{success:!1,error:i.A.t("multiwallet.error_wallet_id_invalid")};if(!n)return(0,o.sd)(i.A.t("multiwallet.error_password_required_encrypt")),{success:!1,error:i.A.t("multiwallet.error_password_required_encrypt")};if(!t||"object"!==typeof t)return(0,o.sd)(i.A.t("multiwallet.error_token_invalid"),t),{success:!1,error:i.A.t("multiwallet.error_token_invalid")};if(!t.address||!t.symbol)return(0,o.sd)(i.A.t("multiwallet.error_token_required_fields"),t),{success:!1,error:i.A.t("multiwallet.error_token_required_fields")};if(!/^0x[a-fA-F0-9]{40}$/.test(t.address))return(0,o.sd)(i.A.t("multiwallet.error_token_address_format"),t.address),{success:!1,error:i.A.t("multiwallet.error_token_address_format")};const r=this.getWalletTokens(e,n);if(r.find(e=>e.address&&t.address&&e.address.toLowerCase()===t.address.toLowerCase()))return(0,o.UJ)(i.A.t("multiwallet.warning_token_exists",{symbol:t.symbol})),{success:!1,error:i.A.t("multiwallet.error_token_already_exists")};const a={address:t.address.toLowerCase(),name:s.SecureStorage.sanitizeString(t.name||i.A.t("multiwallet.label_unknown_token")),symbol:s.SecureStorage.sanitizeString(t.symbol),decimals:parseInt(t.decimals)||18,balance:t.balance||"0",balanceRaw:t.balanceRaw||"0",type:t.type||"ERC-20",verified:Boolean(t.verified),homepage:t.homepage?s.SecureStorage.sanitizeString(t.homepage):null,description:t.description?s.SecureStorage.sanitizeString(t.description):null,network:t.network||"Unknown Network",addedAt:Date.now(),lastUpdated:Date.now()};r.push(a);const l=this.saveWalletTokens(e,r,n);return l.success?((0,o.UJ)(i.A.t("multiwallet.success_token_added",{symbol:a.symbol,address:a.address})),{success:!0,token:a}):l}catch(r){return(0,o.sd)(i.A.t("multiwallet.error_token_add_failed"),r),{success:!1,error:i.A.t("multiwallet.error_token_add_failed")+": "+r.message}}}static removeTokenFromWallet(e,t,n){try{if(!n)return(0,o.sd)(i.A.t("multiwallet.error_password_required_remove")),{success:!1,error:i.A.t("multiwallet.error_password_required_remove")};const r=this.getWalletTokens(e,n).filter(e=>e.address.toLowerCase()!==t.toLowerCase()),s=this.saveWalletTokens(e,r,n);return s.success&&(0,o.UJ)(i.A.t("multiwallet.success_token_removed",{address:t})),s}catch(r){return(0,o.sd)(i.A.t("multiwallet.error_token_remove_failed"),r),{success:!1,error:i.A.t("multiwallet.error_token_remove_failed")}}}static updateTokenBalance(e,t,n,s,a){try{if(!a)return(0,o.sd)(i.A.t("multiwallet.error_password_required_balance")),{success:!1,error:i.A.t("multiwallet.error_password_required_balance")};const l=this.getWalletTokens(e,a),c=l.findIndex(e=>e.address.toLowerCase()===t.toLowerCase());return-1!==c?(l[c]=(0,r.A)((0,r.A)({},l[c]),{},{balance:n,balanceRaw:s,lastUpdated:Date.now()}),this.saveWalletTokens(e,l,a)):{success:!1,error:i.A.t("multiwallet.error_token_not_found")}}catch(l){return(0,o.sd)(i.A.t("multiwallet.error_balance_update_failed"),l),{success:!1,error:i.A.t("multiwallet.error_balance_update_failed")}}}static async updateAllTokenBalances(e,t,n){try{if(!n)return(0,o.sd)(i.A.t("multiwallet.error_password_required_balance")),{success:!1,error:i.A.t("multiwallet.error_password_required_balance")};const s=this.getWalletTokens(e,n);if(0===s.length)return{success:!0,updatedCount:0};let l=0;const c=await Promise.all(s.map(async e=>{try{const n=await a.b.getTokenBalance(t,e.address);return n.success?(l++,(0,r.A)((0,r.A)({},e),{},{balance:n.token.balance,balanceRaw:n.token.balanceRaw,lastUpdated:Date.now()})):e}catch(n){return(0,o._N)(i.A.t("multiwallet.warning_token_balance_update_failed",{symbol:e.symbol}),n),e}}));return this.saveWalletTokens(e,c,n),(0,o.UJ)(i.A.t("multiwallet.info_balance_updated",{updated:l,total:s.length})),{success:!0,updatedCount:l,totalTokens:s.length,tokens:c}}catch(s){return(0,o.sd)(i.A.t("multiwallet.error_balance_update_failed"),s),{success:!1,error:i.A.t("multiwallet.error_balance_update_failed")}}}static async getWalletList(e){try{const t=localStorage.getItem(this.WALLETS_KEY);if(!t)return{success:!0,wallets:[],message:i.A.t("multiwallet.error_no_wallets")};const n=s.SecureStorage.decrypt(t,e);return n.success?{success:!0,wallets:n.data||[]}:n}catch(t){return{success:!1,error:i.A.t("multiwallet.error_load_wallet_list")}}}static async addWallet(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"";try{const r=await this.getWalletList(t);if(!r.success&&r.error!==i.A.t("multiwallet.error_no_wallets"))return r;const a=r.wallets||[];if(a.some(t=>t.address.toLowerCase()===e.address.toLowerCase()))return{success:!1,error:i.A.t("multiwallet.error_wallet_already_exists")};const o={id:this.generateWalletId(),address:e.address,privateKey:e.privateKey,mnemonic:e.mnemonic||null,alias:n||i.A.t("multiwallet.label_default_wallet",{number:a.length+1}),createdAt:Date.now(),isImported:!!e.isImported,balance:"0.0000"};a.push(o);const l=s.SecureStorage.encrypt(a,t);return l.success?(localStorage.setItem(this.WALLETS_KEY,l.encrypted),1===a.length&&this.setActiveWallet(o.id),this.saveWalletTokens(o.id,[],t),{success:!0,wallet:o,message:i.A.t("multiwallet.success_wallet_added")}):l}catch(r){return{success:!1,error:i.A.t("multiwallet.error_wallet_add_failed")}}}static async removeWallet(e,t){try{const n=await this.getWalletList(t);if(!n.success)return n;const r=n.wallets.filter(t=>t.id!==e);if(r.length===n.wallets.length)return{success:!1,error:i.A.t("multiwallet.error_wallet_not_found_remove")};this.getActiveWallet()===e&&r.length>0?this.setActiveWallet(r[0].id):0===r.length&&this.clearActiveWallet();const a=s.SecureStorage.encrypt(r,t);if(!a.success)return a;localStorage.setItem(this.WALLETS_KEY,a.encrypted);const o=this.getAllWalletTokens(t);return delete o[e],s.SecureStorage.saveEncryptedTokens(o,t),{success:!0,message:i.A.t("multiwallet.success_wallet_removed")}}catch(n){return{success:!1,error:i.A.t("multiwallet.error_wallet_remove_failed")}}}static async updateWalletAlias(e,t,n){try{const a=await this.getWalletList(n);if(!a.success)return a;const o=a.wallets.map(n=>n.id===e?(0,r.A)((0,r.A)({},n),{},{alias:s.SecureStorage.sanitizeString(t)}):n),l=s.SecureStorage.encrypt(o,n);return l.success?(localStorage.setItem(this.WALLETS_KEY,l.encrypted),{success:!0,message:i.A.t("multiwallet.success_alias_updated")}):l}catch(a){return{success:!1,error:i.A.t("multiwallet.error_alias_update_failed")}}}static async getWallet(e,t){try{const n=await this.getWalletList(t);if(!n.success)return n;const r=n.wallets.find(t=>t.id===e);return r?{success:!0,wallet:r}:{success:!1,error:i.A.t("multiwallet.error_wallet_not_found")}}catch(n){return{success:!1,error:i.A.t("multiwallet.error_wallet_info_load_failed")}}}static async updateAllBalances(e){try{const t=await this.getWalletList(e);if(!t.success)return t;const n=await Promise.all(t.wallets.map(async e=>{try{const t=await a.b.getBalance(e.address);return(0,r.A)((0,r.A)({},e),{},{balance:t.success?t.balance:e.balance,lastUpdated:Date.now()})}catch(t){return(0,o._N)(i.A.t("multiwallet.warning_wallet_balance_update_failed",{address:e.address}),t),e}})),l=s.SecureStorage.encrypt(n,e);return l.success&&localStorage.setItem(this.WALLETS_KEY,l.encrypted),{success:!0,wallets:n}}catch(t){return{success:!1,error:i.A.t("multiwallet.error_balance_update_all_failed")}}}static setActiveWallet(e){try{return localStorage.setItem(this.ACTIVE_WALLET_KEY,e),!0}catch(t){return!1}}static getActiveWallet(){try{return localStorage.getItem(this.ACTIVE_WALLET_KEY)}catch(e){return null}}static async getActiveWalletData(e){const t=this.getActiveWallet();return t?await this.getWallet(t,e):{success:!1,error:i.A.t("multiwallet.error_no_active_wallet")}}static clearActiveWallet(){try{return localStorage.removeItem(this.ACTIVE_WALLET_KEY),!0}catch(e){return!1}}static async clearAllWallets(){try{return localStorage.removeItem(this.WALLETS_KEY),localStorage.removeItem(this.ACTIVE_WALLET_KEY),s.SecureStorage.secureDeleteTokens(),{success:!0,message:i.A.t("multiwallet.success_all_wallets_cleared")}}catch(e){return{success:!1,error:i.A.t("multiwallet.error_clear_wallets_failed")}}}static generateWalletId(){return"wallet_"+Date.now()+"_"+Math.random().toString(36).substr(2,9)}static hasWallets(){return null!==localStorage.getItem(this.WALLETS_KEY)}static async exportWallets(e){try{const t=await this.getWalletList(e);if(!t.success)return t;const n=this.getAllWalletTokens(e);return{success:!0,data:{version:"1.0",exportedAt:(new Date).toISOString(),wallets:t.wallets.map(e=>({id:e.id,address:e.address,privateKey:e.privateKey,mnemonic:e.mnemonic,alias:e.alias,createdAt:e.createdAt,isImported:e.isImported,tokens:n[e.id]||[]}))}}}catch(t){return{success:!1,error:i.A.t("multiwallet.error_export_failed")}}}static async importWallets(e,t){try{if(!e.wallets||!Array.isArray(e.wallets))throw new Error(i.A.t("multiwallet.error_import_format"));const n=await this.getWalletList(t),r=n.success?n.wallets:[];let a=0,o=0;for(const c of e.wallets){if(r.some(e=>e.address.toLowerCase()===c.address.toLowerCase())){o++;continue}const e={id:this.generateWalletId(),address:c.address,privateKey:c.privateKey,mnemonic:c.mnemonic||null,alias:s.SecureStorage.sanitizeString(c.alias||i.A.t("multiwallet.label_imported_wallet",{number:r.length+1})),createdAt:c.createdAt||Date.now(),isImported:!0,balance:"0.0000"};r.push(e),c.tokens&&Array.isArray(c.tokens)&&this.saveWalletTokens(e.id,c.tokens,t),a++}const l=s.SecureStorage.encrypt(r,t);return l.success?(localStorage.setItem(this.WALLETS_KEY,l.encrypted),{success:!0,imported:a,skipped:o,message:i.A.t("multiwallet.success_wallets_imported",{imported:a,skipped:o})}):l}catch(n){return{success:!1,error:i.A.t("multiwallet.error_import_failed")+": "+n.message}}}}l.WALLETS_KEY="worldland_multiple_wallets",l.ACTIVE_WALLET_KEY="worldland_active_wallet",l.WALLET_TOKENS_KEY="worldland_wallet_tokens_encrypted"},2241(e,t,n){"use strict";n.d(t,{A:()=>s});var r=n(899);const s=new class{constructor(){this.currentLanguage="en",this.translations={},this.fallbackLanguage="en",this.storageKey="worldland_language",this.listeners=[]}addLanguageChangeListener(e){this.listeners.push(e)}removeLanguageChangeListener(e){this.listeners=this.listeners.filter(t=>t!==e)}notifyLanguageChange(){this.listeners.forEach(e=>{try{e(this.currentLanguage)}catch(t){(0,r.sd)("\uc5b8\uc5b4 \ubcc0\uacbd \ub9ac\uc2a4\ub108 \uc624\ub958:",t)}})}async setLanguage(e){if(!this.getSupportedLanguages().find(t=>t.code===e))return(0,r._N)("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc5b8\uc5b4: ".concat(e)),!1;if(!this.translations[e]){if(!await this.loadLanguage(e))return(0,r.sd)("\uc5b8\uc5b4 \ub85c\ub4dc \uc2e4\ud328: ".concat(e)),!1}this.currentLanguage=e,localStorage.setItem(this.storageKey,e);try{const{SecureStorage:t}=await Promise.resolve().then(n.bind(n,1276)),s=t.loadSettings()||t.getDefaultSettings();s.language=e,t.saveSettings(s),(0,r.UJ)("\u2705 \uc5b8\uc5b4 \uc124\uc815\uc774 SecureStorage\uc640 \ub3d9\uae30\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4:",e)}catch(t){(0,r._N)("\u26a0\ufe0f SecureStorage \ub3d9\uae30\ud654 \uc2e4\ud328:",t)}return document.documentElement.lang=e,this.notifyLanguageChange(),!0}async preloadAllLanguages(){const e=this.getSupportedLanguages().map(e=>this.loadLanguage(e.code));try{return await Promise.all(e),(0,r.UJ)("\ubaa8\ub4e0 \uc5b8\uc5b4 \ub9ac\uc18c\uc2a4 \ub85c\ub4dc \uc644\ub8cc"),!0}catch(t){return(0,r._N)("\uc77c\ubd80 \uc5b8\uc5b4 \ub9ac\uc18c\uc2a4 \ub85c\ub4dc \uc2e4\ud328:",t),!1}}getSupportedLanguages(){return[{code:"en",name:"English",nativeName:"English"},{code:"ko",name:"Korean",nativeName:"\ud55c\uad6d\uc5b4"},{code:"zh",name:"Chinese",nativeName:"\u4e2d\u6587"},{code:"ru",name:"Russian",nativeName:"\u0420\u0443\u0441\u0441\u043a\u0438\u0439"},{code:"ja",name:"Japanese",nativeName:"\u65e5\u672c\u8a9e"},{code:"es",name:"Spanish",nativeName:"Espa\xf1ol"},{code:"fr",name:"French",nativeName:"Fran\xe7ais"},{code:"ar",name:"Arabic",nativeName:"\u0627\u0644\u0639\u0631\u0628\u064a\u0629"}]}async loadLanguage(e){try{const t=await n(327)("./".concat(e,".json"));return this.translations[e]=t.default,(0,r.UJ)("\uc5b8\uc5b4 \ub85c\ub4dc \uc131\uacf5: ".concat(e)),!0}catch(t){return(0,r._N)("\uc5b8\uc5b4 \ub85c\ub4dc \uc2e4\ud328: ".concat(e),t),!1}}async loadSavedLanguage(){let e=null;try{const{SecureStorage:t}=await Promise.resolve().then(n.bind(n,1276)),s=t.loadSettings();s&&s.language&&(e=s.language,(0,r.UJ)("\ud83d\udd27 SecureStorage\uc5d0\uc11c \uc5b8\uc5b4 \uc124\uc815 \ub85c\ub4dc:",e))}catch(t){(0,r._N)("SecureStorage \uc5b8\uc5b4 \ub85c\ub4dc \uc2e4\ud328:",t)}if(e||(e=localStorage.getItem(this.storageKey),(0,r.UJ)("\ud83d\udcbe localStorage\uc5d0\uc11c \uc5b8\uc5b4 \uc124\uc815 \ub85c\ub4dc:",e)),e)await this.setLanguage(e);else{const e=this.detectBrowserLanguage();(0,r.UJ)("\ud83c\udf0d \ube0c\ub77c\uc6b0\uc800 \uc5b8\uc5b4 \uac10\uc9c0 \uacb0\uacfc:",e),await this.setLanguage(e)}}detectBrowserLanguage(){const e=navigator.language||navigator.languages[0],t=e.split("-")[0],n=this.getSupportedLanguages().find(e=>e.code===t)?t:this.fallbackLanguage;return(0,r.UJ)("\ud83c\udf0d \ube0c\ub77c\uc6b0\uc800 \uc5b8\uc5b4 \uac10\uc9c0:",e,"\u2192",n),n}t(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const n=this.getTranslation(e);return"string"!==typeof n?((0,r._N)("\ubc88\uc5ed\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c: ".concat(e)),e):this.interpolate(n,t)}getTranslation(e){const t=e.split(".");let n=this.translations[this.currentLanguage];for(const r of t){if(!n||"object"!==typeof n||!(r in n)){n=this.translations[this.fallbackLanguage];for(const r of t){if(!n||"object"!==typeof n||!(r in n))return e;n=n[r]}break}n=n[r]}return n}interpolate(e,t){return e.replace(/\{\{(\w+)\}\}/g,(e,n)=>t[n]||e)}getCurrentLanguage(){return this.currentLanguage}getLanguageName(e){const t=this.getSupportedLanguages().find(t=>t.code===e);return t?t.nativeName:e}}},4442(e,t,n){"use strict";n.d(t,{Of:()=>r,gB:()=>a,pI:()=>s});const r={mainnet:{name:"WorldLand Mainnet",rpcUrl:"https://seoul.worldland.foundation",chainId:103,chainIdHex:"0x67",symbol:"WLC",explorer:"https://scan.worldland.foundation",explorerApi:"https://scan.worldland.foundation",decimals:18,emoji:"\ud83c\udfc6"},testnet:{name:"WorldLand Testnet",rpcUrl:"https://gwangju.worldland.foundation",chainId:10395,chainIdHex:"0x289b",symbol:"WLC",explorer:"https://scan.worldland.foundation",explorerApi:"https://scan.worldland.foundation",decimals:18,decimals:18,emoji:"\ud83e\ude84"},ethereum:{name:"Ethereum Mainnet",rpcUrl:"https://ethereum.publicnode.com",chainId:1,chainIdHex:"0x1",symbol:"ETH",explorer:"https://etherscan.io",explorerApi:"https://api.etherscan.io",decimals:18,emoji:"\ud83e\udd47"},bsc:{name:"BNB Smart Chain (BEP20)",rpcUrl:"https://bsc-dataseed1.binance.org",chainId:56,chainIdHex:"0x38",symbol:"BNB",explorer:"https://bscscan.com",explorerApi:"https://api.etherscan.io",decimals:18,emoji:"\ud83d\udcca"}},s={slow:"10",standard:"20",fast:"30"},a={mainnet:[{address:"0xc93f06d582fd6fD7FfEd928ffB57896474abC855",name:"SAPSALDOG",symbol:"Dokdo",decimals:18,verified:!0,description:"SAPSALDOG \ud1a0\ud070",homepage:"https://sapsaldog.com"},{address:"0xDBEDbeB2CD8493AE2d746b7eeD597946F6E7910A",name:"WorldLand Cafe",symbol:"CAFE",decimals:18,verified:!0,description:"WorldLand Cafe \ud1a0\ud070",homepage:"https://cafe.doldari.com"},{address:"0x6f57a06f1eA3c6EB16F742249CBdCB672458337C",name:"WorldLand-Pay",symbol:"WLP",decimals:18,verified:!0,description:"WorldLand Pay \ud1a0\ud070",homepage:"https://wlp.doldari.com"},{address:"0xC0AD918E5CC5930B8D31cc229770f232Dd82187a",name:"Doldari",symbol:"DOL",decimals:18,verified:!0,description:"Doldari \ud1a0\ud070",homepage:"https://www.doldari.com"},{address:"0x12183c232B94a6FB80711037b8A407a03Dd24983",name:"World Vision",symbol:"VISION",decimals:18,verified:!0,description:"World Vision \ud1a0\ud070",homepage:"https://vision.doldari.com"},{address:"0xAEdb0ef87Dad9DAd8f4E8e1a157268bA5F40c6A5",name:"YouronlyJen",symbol:"YOURONLYJEN",decimals:18,verified:!0,description:"YouronlyJen \ud1a0\ud070",homepage:"https://youronlyjen.doldari.com"},{address:"0x0817394Dc95342cd1F9eAF4Eae0d03F4202Bc4e4",name:"YOGO Pay",symbol:"YOGO",decimals:18,verified:!0,description:"YOGO Pay \ud1a0\ud070",homepage:"https://yogo.kr"}],testnet:[{address:"0xabcdef1234567890abcdef1234567890abcdef12",name:"Test USD",symbol:"TUSD",decimals:6,verified:!0,description:"WorldLand Testnet \ud14c\uc2a4\ud2b8 \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0xbcdef1234567890abcdef1234567890abcdef123",name:"Test Token",symbol:"TT",decimals:18,verified:!0,description:"WorldLand Testnet \ud14c\uc2a4\ud2b8 \ud1a0\ud070"}],ethereum:[{address:"0xdAC17F958D2ee523a2206206994597C13D831ec7",name:"Tether USD",symbol:"USDT",decimals:6,verified:!0,description:"USD \ud398\uae45 \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48",name:"USD Coin",symbol:"USDC",decimals:6,verified:!0,description:"Circle\uc758 USD \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0x6B175474E89094C44Da98b954EedeAC495271d0F",name:"Dai Stablecoin",symbol:"DAI",decimals:18,verified:!0,description:"MakerDAO\uc758 \ud0c8\uc911\uc559\ud654 \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0x4Fabb145d64652a948d72533023f6E7A623C7C53",name:"Binance USD",symbol:"BUSD",decimals:18,verified:!0,description:"Binance\uc758 USD \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0x853d955aCEf822Db058eb8505911ED77F175b99e",name:"Frax",symbol:"FRAX",decimals:18,verified:!0,description:"\ubd80\ubd84\uc801 \uc54c\uace0\ub9ac\uc998 \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",name:"Wrapped Ether",symbol:"WETH",decimals:18,verified:!0,description:"ERC-20 \ub798\ud551\ub41c \uc774\ub354\ub9ac\uc6c0"},{address:"0x2260FAC5E5542a773Aa44fBCfeDf7C193bc2C599",name:"Wrapped BTC",symbol:"WBTC",decimals:8,verified:!0,description:"ERC-20 \ub798\ud551\ub41c \ube44\ud2b8\ucf54\uc778"},{address:"0x7f39C581F595B53c5cb19bD0b3f8dA6c935E2Ca0",name:"Wrapped stETH",symbol:"wstETH",decimals:18,verified:!0,description:"Lido\uc758 \uc2a4\ud14c\uc774\ud0b9\ub41c ETH"},{address:"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984",name:"Uniswap",symbol:"UNI",decimals:18,verified:!0,description:"Uniswap DEX \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9",name:"Aave Token",symbol:"AAVE",decimals:18,verified:!0,description:"Aave \ud504\ub85c\ud1a0\ucf5c \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x9f8F72aA9304c8B593d555F12eF6589cC3A579A2",name:"Maker",symbol:"MKR",decimals:18,verified:!0,description:"MakerDAO \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x57e114B691Db790C35207b2e685D4A43181e6061",name:"Ethena",symbol:"ENA",decimals:18,verified:!0,description:"Ethena governance token on Ethereum blockchain"},{address:"0xC18360217D8F7Ab5e7c516566761Ea12Ce7F9D72",name:"Ethereum Name Service",symbol:"ENS",decimals:18,verified:!0,description:"ENS \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x6B3595068778DD592e39A122f4f5a5cF09C90fE2",name:"SushiToken",symbol:"SUSHI",decimals:18,verified:!0,description:"SushiSwap DEX \ud1a0\ud070"},{address:"0xc00e94Cb662C3520282E6f5717214004A7f26888",name:"Compound",symbol:"COMP",decimals:18,verified:!0,description:"Compound \ud504\ub85c\ud1a0\ucf5c \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x0bc529c00C6401aEF6D220BE8C6Ea1667F6Ad93e",name:"yearn.finance",symbol:"YFI",decimals:18,verified:!0,description:"Yearn Finance \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0xba100000625a3754423978a60c9317c58a424e3D",name:"Balancer",symbol:"BAL",decimals:18,verified:!0,description:"Balancer \ud504\ub85c\ud1a0\ucf5c \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0xD533a949740bb3306d119CC777fa900bA034cd52",name:"Curve DAO Token",symbol:"CRV",decimals:18,verified:!0,description:"Curve Finance \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x514910771AF9Ca656af840dff83E8264EcF986CA",name:"ChainLink Token",symbol:"LINK",decimals:18,verified:!0,description:"\ud0c8\uc911\uc559\ud654 \uc624\ub77c\ud074 \ub124\ud2b8\uc6cc\ud06c \ud1a0\ud070"},{address:"0x7D1AfA7B718fb893dB30A3aBc0Cfc608AaCfeBB0",name:"Matic Token",symbol:"MATIC",decimals:18,verified:!0,description:"Polygon \ub124\ud2b8\uc6cc\ud06c \ud1a0\ud070"},{address:"0x4200000000000000000000000000000000000042",name:"Optimism",symbol:"OP",decimals:18,verified:!0,description:"Optimism L2 \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x3845badAde8e6dFF049820680d1F14bD3903a5d0",name:"The Sandbox",symbol:"SAND",decimals:18,verified:!0,description:"\uba54\ud0c0\ubc84\uc2a4 \ud50c\ub7ab\ud3fc \ud1a0\ud070"},{address:"0x95aD61b0a150d79219dCF64E1E6Cc01f0B64C4cE",name:"SHIBA INU",symbol:"SHIB",decimals:18,verified:!0,description:"\ubc08 \ucf54\uc778"},{address:"0x4d224452801ACEd8B2F0aebE155379bb5D594381",name:"ApeCoin",symbol:"APE",decimals:18,verified:!0,description:"Bored Ape Yacht Club \uc0dd\ud0dc\uacc4 \ud1a0\ud070"},{address:"0x50D1c9771902476076eCFc8B2A83Ad6b9355a4c9",name:"FTX Token",symbol:"FTT",decimals:18,verified:!0,description:"FTX \uac70\ub798\uc18c \ud1a0\ud070 (\uc8fc\uc758: FTX \ud30c\uc0b0)"},{address:"0xae7ab96520DE3A18E5e111B5EaAb095312D7fE84",name:"Lido Staked Ether",symbol:"stETH",decimals:18,verified:!0,description:"Lido \uc2a4\ud14c\uc774\ud0b9 ETH"},{address:"0x6810e776880C02933D47DB1b9fc05908e5386b96",name:"Gnosis Token",symbol:"GNO",decimals:18,verified:!0,description:"Gnosis \uc608\uce21 \uc2dc\uc7a5 \ud50c\ub7ab\ud3fc \ud1a0\ud070"},{address:"0x0D8775F648430679A709E98d2b0Cb6250d2887EF",name:"Basic Attention Token",symbol:"BAT",decimals:18,verified:!0,description:"Brave \ube0c\ub77c\uc6b0\uc800 \uad11\uace0 \ud1a0\ud070"},{address:"0xE41d2489571d322189246DaFA5ebDe1F4699F498",name:"0x Protocol Token",symbol:"ZRX",decimals:18,verified:!0,description:"0x \ud504\ub85c\ud1a0\ucf5c \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0x111111111117dC0aa78b770fA6A738034120C302",name:"1inch Token",symbol:"1INCH",decimals:18,verified:!0,description:"1inch DEX \uc560\uadf8\ub9ac\uac8c\uc774\ud130 \ud1a0\ud070"},{address:"0xc944E90C64B2c07662A292be6244BDf05Cda44a7",name:"Graph Token",symbol:"GRT",decimals:18,verified:!0,description:"The Graph \uc778\ub371\uc2f1 \ud504\ub85c\ud1a0\ucf5c \ud1a0\ud070"},{address:"0x0F5D2fB29fb7d3CFeE444a200298f468908cC942",name:"Decentraland",symbol:"MANA",decimals:18,verified:!0,description:"\uac00\uc0c1 \uc138\uacc4 \ud50c\ub7ab\ud3fc \ud1a0\ud070"}],bsc:[{address:"0x55d398326f99059fF775485246999027B3197955",name:"Tether USD",symbol:"USDT",decimals:18,verified:!0,description:"BSC \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0x8AC76a51cc950d9822D68b83fE1Ad97B32Cd580d",name:"USD Coin",symbol:"USDC",decimals:18,verified:!0,description:"BSC \uc2a4\ud14c\uc774\ube14\ucf54\uc778"},{address:"0xe9e7CEA3DedcA5984780BfFADe587242c208E53d",name:"Binance USD",symbol:"BUSD",decimals:18,verified:!0,description:"BSC \uae30\ubc18 BUSD"},{address:"0x2170Ed0880ac9A755fd29B268895FaaD15aD7dC2",name:"Ethereum Token",symbol:"ETH",decimals:18,verified:!0,description:"Wrapped Ethereum on BSC"},{address:"0x0e09fabb73bd3ade0a17ecc321fd13a19e81ce82",name:"PancakeSwap Token",symbol:"CAKE",decimals:18,verified:!0,description:"PancakeSwap \uac70\ubc84\ub10c\uc2a4 \ud1a0\ud070"},{address:"0xc748673057861a797275CD8A068AbB95A902e8de",name:"BabyDoge coin",symbol:"BabyDoge",decimals:18,verified:!0,description:"BabyDoge coin"},{address:"0x840eF7e5f896Be71D46Df234C60898216feFCBe3",name:"BYTE coin",symbol:"BYTE",decimals:18,verified:!0,description:"BYTE coin"},{address:"0xf87332f170E4b3Ea373D4c414434255160E04E5B",name:"Wrapped BNB",symbol:"WBNB",decimals:18,verified:!0,description:"DeFi \uc0ac\uc6a9\uc744 \uc704\ud55c Wrapped BNB"},{address:"0xf8A02f231e33A44990924976450A0B59a43a0491",name:"Chainlink Token",symbol:"LINK",decimals:18,verified:!0,description:"\uc624\ub77c\ud074 \ub124\ud2b8\uc6cc\ud06c"},{address:"0x7083609fCE4d1d8Dc0C979AAb8c88d1d866a15B7",name:"Polkadot",symbol:"DOT",decimals:18,verified:!0,description:"Polkadot on BSC"},{address:"0x3ee2200efb3400fAbB9EceB4a690868fBce2fE85",name:"Cardano",symbol:"ADA",decimals:18,verified:!0,description:"Cardano on BSC"},{address:"0xbA2aE424d960c26247Dd6c32edC70B295c744C43",name:"DogeCoin",symbol:"DOGE",decimals:8,verified:!0,description:"DogeCoin on BSC (Wrapped)"},{address:"0x57008711C91F0d02bA080922C0263c9bF5041447",name:"Solana",symbol:"SOL",decimals:9,verified:!0,description:"Solana on BSC (Wrapped)"}]}},1276(e,t,n){"use strict";n.d(t,{SecureStorage:()=>o});var r=n(730),s=n.n(r),a=n(2241),i=n(899);class o{static encryptTokenData(e,t){try{if(!t)throw new Error(a.A.t("secureStorage.passwordRequiredForEncryption"));const n=this.sanitizeTokenData(e),r=(JSON.stringify(n),{data:n,timestamp:Date.now(),version:"1.0"});return{success:!0,encrypted:s().AES.encrypt(JSON.stringify(r),t).toString()}}catch(n){return(0,i.sd)("\ud1a0\ud070 \ub370\uc774\ud130 \uc554\ud638\ud654 \uc2e4\ud328:",n),{success:!1,error:a.A.t("secureStorage.tokenEncryptionFailed")+": "+n.message}}}static decryptTokenData(e,t){try{if(!e||!t)return{success:!1,error:a.A.t("secureStorage.noEncryptedDataOrPassword")};const n=s().AES.decrypt(e,t).toString(s().enc.Utf8);if(!n)throw new Error(a.A.t("secureStorage.wrongPassword"));const r=JSON.parse(n);if(!r.data||!r.timestamp)throw new Error(a.A.t("secureStorage.invalidTokenFormat"));const o=31536e6;return Date.now()-r.timestamp>o&&(0,i._N)(a.A.t("secureStorage.outdatedTokenDetected")),{success:!0,data:r.data}}catch(n){return(0,i.sd)(a.A.t("secureStorage.tokenDecryptionError"),n),{success:!1,error:n.message.includes("password")?a.A.t("secureStorage.incorrectPassword"):a.A.t("secureStorage.tokenDecryptionFailed")}}}static sanitizeTokenData(e){if(!e||"object"!==typeof e)return{};const t={};return Object.keys(e).forEach(n=>{Array.isArray(e[n])&&(t[n]=e[n].map(e=>this.sanitizeToken(e)))}),t}static sanitizeToken(e){if(!e||"object"!==typeof e)return null;const t={};return["address","name","symbol","decimals","balance","balanceRaw","type","verified","network","homepage","addedAt","lastUpdated","description"].forEach(n=>{if(void 0!==e[n]){let r=e[n];if("string"===typeof r&&(r=this.sanitizeString(r)),["decimals","addedAt","lastUpdated"].includes(n)&&(r=parseInt(r)||0),"verified"===n&&(r=Boolean(r)),"address"===n&&r&&!/^0x[a-fA-F0-9]{40}$/.test(r))return(0,i._N)("Invalid token address format:",r),null;t[n]=r}}),t.address&&t.symbol?t:((0,i._N)("\ud1a0\ud070 \ud544\uc218 \ud544\ub4dc \ub204\ub77d:",t),null)}static sanitizeString(e){return"string"!==typeof e?e:e.replace(/[<>\"']/g,"").replace(/javascript:/gi,"").replace(/on\w+=/gi,"").replace(/data:/gi,"").trim().slice(0,200)}static saveEncryptedTokens(e,t){try{const n=this.encryptTokenData(e,t);return n.success?(localStorage.removeItem("worldland_wallet_tokens"),localStorage.setItem(this.TOKENS_KEY,n.encrypted),(0,i.UJ)("\u2705 \ud1a0\ud070 \ub370\uc774\ud130\uac00 \uc554\ud638\ud654\ub418\uc5b4 \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4"),{success:!0,message:a.A.t("secureStorage.tokenSavedSafely")}):n}catch(n){return(0,i.sd)("\uc554\ud638\ud654\ub41c \ud1a0\ud070 \uc800\uc7a5 \uc2e4\ud328:",n),{success:!1,error:a.A.t("secureStorage.tokenSaveFailed")}}}static loadEncryptedTokens(e){try{const t=localStorage.getItem(this.TOKENS_KEY);if(!t)return this.migrateTokenData(e);const n=this.decryptTokenData(t,e);return n.success?{success:!0,data:n.data||{}}:((0,i.sd)("\ud1a0\ud070 \ub370\uc774\ud130 \ubcf5\ud638\ud654 \uc2e4\ud328:",n.error),{success:!1,error:n.error,data:{}})}catch(t){return(0,i.sd)("\uc554\ud638\ud654\ub41c \ud1a0\ud070 \ub85c\ub4dc \uc2e4\ud328:",t),{success:!1,error:a.A.t("secureStorage.tokenLoadFailed"),data:{}}}}static migrateTokenData(e){try{(0,i.UJ)("\ud83d\udd04 \uae30\uc874 \ud1a0\ud070 \ub370\uc774\ud130 \ub9c8\uc774\uadf8\ub808\uc774\uc158 \uc2dc\uc791...");const t=localStorage.getItem("worldland_wallet_tokens");if(!t)return(0,i.UJ)("\ub9c8\uc774\uadf8\ub808\uc774\uc158\ud560 \ud1a0\ud070 \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4"),{success:!0,data:{},migrated:!1};const n=JSON.parse(t);(0,i.UJ)("\uae30\uc874 \ud1a0\ud070 \ub370\uc774\ud130 \ubc1c\uacac:",Object.keys(n).length,"\uac1c \uc9c0\uac11");const r=this.saveEncryptedTokens(n,e);return r.success?(localStorage.removeItem("worldland_wallet_tokens"),(0,i.UJ)("\u2705 \ud1a0\ud070 \ub370\uc774\ud130 \ub9c8\uc774\uadf8\ub808\uc774\uc158 \uc644\ub8cc"),{success:!0,data:n,migrated:!0}):((0,i.sd)("\ud1a0\ud070 \ub370\uc774\ud130 \ub9c8\uc774\uadf8\ub808\uc774\uc158 \uc2e4\ud328:",r.error),{success:!1,error:a.A.t("secureStorage.tokenMigrationFailed"),data:{}})}catch(t){return(0,i.sd)("\ud1a0\ud070 \ub370\uc774\ud130 \ub9c8\uc774\uadf8\ub808\uc774\uc158 \uc608\uc678:",t),{success:!1,error:a.A.t("secureStorage.tokenMigrationError"),data:{}}}}static clearSensitiveData(e){if(!e||"object"!==typeof e)return;const t=["privateKey","mnemonic","password","seed"];Object.keys(e).forEach(n=>{if(t.includes(n)&&"string"===typeof e[n]){const t=e[n];if(t&&t.length>0){for(let e=0;e<t.length;e++);e[n]=null,delete e[n]}}}),(0,i.UJ)("\ud83e\uddf9 \ubbfc\uac10\ud55c \ub370\uc774\ud130\ub9cc \uc815\ub9ac \uc644\ub8cc")}static clearAllSessionData(){try{return sessionStorage.clear(),window.gc&&window.gc(),(0,i.UJ)("\ud83e\uddf9 \uc138\uc158 \ub370\uc774\ud130 \uc644\uc804 \uc815\ub9ac \uc644\ub8cc"),{success:!0,message:a.A.t("secureStorage.sessionCleared")}}catch(e){return(0,i.sd)("\uc138\uc158 \ub370\uc774\ud130 \uc815\ub9ac \uc2e4\ud328:",e),{success:!1,error:a.A.t("secureStorage.sessionClearFailed")}}}static secureDeleteTokens(){try{return localStorage.removeItem(this.TOKENS_KEY),localStorage.removeItem("worldland_wallet_tokens"),(0,i.UJ)("\ud83d\uddd1\ufe0f \ubaa8\ub4e0 \ud1a0\ud070 \ub370\uc774\ud130\uac00 \uc548\uc804\ud558\uac8c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4"),{success:!0,message:a.A.t("secureStorage.tokenDeletedSafely")}}catch(e){return(0,i.sd)("\ud1a0\ud070 \ub370\uc774\ud130 \uc0ad\uc81c \uc2e4\ud328:",e),{success:!1,error:a.A.t("secureStorage.tokenDeleteFailed")}}}static encrypt(e,t){try{const n=JSON.stringify(e);return{encrypted:s().AES.encrypt(n,t).toString(),success:!0}}catch(n){return{success:!1,error:a.A.t("secureStorage.encryptionFailed")}}}static decrypt(e,t){try{const n=s().AES.decrypt(e,t).toString(s().enc.Utf8);if(!n)throw new Error(a.A.t("secureStorage.wrongPassword"));return{data:JSON.parse(n),success:!0}}catch(n){return{success:!1,error:n.message.includes("password")?a.A.t("secureStorage.incorrectPassword"):a.A.t("secureStorage.invalidInputInfo")}}}static async saveWallet(e,t){try{const n=this.encrypt(e,t);if(!n.success)return n;const r={data:n.encrypted,timestamp:Date.now(),version:"1.0"};return localStorage.setItem(this.STORAGE_KEY,JSON.stringify(r)),{success:!0,message:a.A.t("secureStorage.walletSavedSafely")}}catch(n){return{success:!1,error:a.A.t("secureStorage.walletSaveFailed")}}}static async loadWallet(e){try{const t=localStorage.getItem(this.STORAGE_KEY);if(!t)return{success:!1,error:a.A.t("secureStorage.noSavedWallet")};const n=JSON.parse(t),r=this.decrypt(n.data,e);return r.success?{walletData:r.data,timestamp:n.timestamp,success:!0}:r}catch(t){return{success:!1,error:a.A.t("secureStorage.walletLoadFailed")}}}static hasWallet(){return null!==localStorage.getItem(this.STORAGE_KEY)}static removeWallet(){try{return localStorage.removeItem(this.STORAGE_KEY),this.secureDeleteTokens(),{success:!0,message:a.A.t("secureStorage.walletDeleted")}}catch(e){return{success:!1,error:a.A.t("secureStorage.walletDeleteFailed")}}}static saveSettings(e){try{return localStorage.setItem(this.SETTINGS_KEY,JSON.stringify(e)),{success:!0}}catch(t){return{success:!1,error:a.A.t("secureStorage.settingSaveFailed")}}}static loadSettings(){try{const e=localStorage.getItem(this.SETTINGS_KEY);return e?JSON.parse(e):null}catch(e){return null}}static getDefaultSettings(){return{network:"mainnet",currency:"USD",language:"en",notifications:!0,autoLock:!0,lockTimeout:36e5,gasPrice:"standard"}}static validatePassword(e){const t=/[A-Z]/.test(e),n=/[a-z]/.test(e),r=/\d/.test(e),s=/\W/.test(e),a=[e.length>=8,t,n,r,s].reduce((e,t)=>e+t,0);let i="weak";return a>=4?i="strong":a>=3&&(i="medium"),{isValid:e.length>=8&&a>=3,strength:i,score:a,requirements:{minLength:e.length>=8,hasUpperCase:t,hasLowerCase:n,hasNumbers:r,hasSpecialChar:s}}}static generateSessionToken(){return s().lib.WordArray.random(32).toString()}static setSession(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:3e5;const n={token:e,expires:Date.now()+t};sessionStorage.setItem("wallet_session",JSON.stringify(n))}static getSession(){try{const e=sessionStorage.getItem("wallet_session");if(!e)return null;const t=JSON.parse(e);return Date.now()>t.expires?(sessionStorage.removeItem("wallet_session"),null):t}catch(e){return null}}static clearSession(){sessionStorage.removeItem("wallet_session")}static setSessionWithPassword(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:3e5;try{const n=this.generateSessionToken(),r={token:n,encryptedPassword:s().AES.encrypt(e,n).toString(),expires:Date.now()+t,createdAt:Date.now()};return sessionStorage.setItem("wallet_session",JSON.stringify(r)),(0,i.UJ)("\u2705 \uc138\uc158\uacfc \uc554\ud638\ud654\ub41c \ube44\ubc00\ubc88\ud638 \uc800\uc7a5 \uc644\ub8cc"),!0}catch(n){return(0,i.sd)("\u274c \uc138\uc158 \ube44\ubc00\ubc88\ud638 \uc800\uc7a5 \uc2e4\ud328:",n),!1}}static getSessionPassword(){try{const e=sessionStorage.getItem("wallet_session");if(!e)return(0,i.UJ)("\ud83d\udca1 \uc800\uc7a5\ub41c \uc138\uc158\uc774 \uc5c6\uc2b5\ub2c8\ub2e4"),null;const t=JSON.parse(e);if(Date.now()>t.expires)return(0,i.UJ)("\u23f0 \uc138\uc158\uc774 \ub9cc\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4"),sessionStorage.removeItem("wallet_session"),null;const n=s().AES.decrypt(t.encryptedPassword,t.token).toString(s().enc.Utf8);return n?((0,i.UJ)("\u2705 \uc138\uc158 \ube44\ubc00\ubc88\ud638 \ubcf5\uc6d0 \uc131\uacf5"),n):((0,i.UJ)("\u274c \ube44\ubc00\ubc88\ud638 \ubcf5\ud638\ud654 \uc2e4\ud328"),null)}catch(e){return(0,i.sd)("\u274c \uc138\uc158 \ube44\ubc00\ubc88\ud638 \ubcf5\uc6d0 \uc2e4\ud328:",e),sessionStorage.removeItem("wallet_session"),null}}static getSession(){try{const e=sessionStorage.getItem("wallet_session");if(!e)return null;const t=JSON.parse(e);return Date.now()>t.expires?(sessionStorage.removeItem("wallet_session"),null):{token:t.token,expires:t.expires,createdAt:t.createdAt,isValid:!0}}catch(e){return(0,i.sd)("\uc138\uc158 \ud655\uc778 \uc2e4\ud328:",e),sessionStorage.removeItem("wallet_session"),null}}static clearSession(){try{sessionStorage.removeItem("wallet_session"),(0,i.UJ)("\ud83e\uddf9 \uc138\uc158\uc774 \uc644\uc804\ud788 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4")}catch(e){(0,i.sd)("\uc138\uc158 \uc0ad\uc81c \uc2e4\ud328:",e)}}static extendSession(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:3e5;try{const t=sessionStorage.getItem("wallet_session");if(!t)return!1;const n=JSON.parse(t);return n.expires=Date.now()+e,sessionStorage.setItem("wallet_session",JSON.stringify(n)),(0,i.UJ)("\u23f1\ufe0f \uc138\uc158\uc774 \uc5f0\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4"),!0}catch(t){return(0,i.sd)("\uc138\uc158 \uc5f0\uc7a5 \uc2e4\ud328:",t),!1}}}o.STORAGE_KEY="worldland_wallet_data",o.SETTINGS_KEY="worldland_wallet_settings",o.TOKENS_KEY="worldland_wallet_tokens_encrypted"},190(e,t,n){"use strict";n.d(t,{b:()=>g});var r=n(9379),s=n(2443),a=n(5967),i=n(4661),o=n(1132),l=n(4759),c=n(177),u=n(4442),d=n(899);const h=["function balanceOf(address owner) view returns (uint256)","function transfer(address to, uint256 amount) returns (bool)","function decimals() view returns (uint8)","function symbol() view returns (string)","function name() view returns (string)","function totalSupply() view returns (uint256)"],f=["function safeTransferFrom(address from, address to, uint256 tokenId)","function transferFrom(address from, address to, uint256 tokenId)","function approve(address to, uint256 tokenId)","function getApproved(uint256 tokenId) view returns (address)","function ownerOf(uint256 tokenId) view returns (address)"];class p{constructor(){this.cacheKey="worldland_tx_cache",this.cacheDuration=3e5}getCachedTransactions(e){try{const t=localStorage.getItem("".concat(this.cacheKey,"_").concat(e));if(!t)return null;const n=JSON.parse(t);return Date.now()-n.timestamp>this.cacheDuration?(localStorage.removeItem("".concat(this.cacheKey,"_").concat(e)),null):n.transactions}catch(t){return null}}setCachedTransactions(e,t){try{const n={transactions:t,timestamp:Date.now()};localStorage.setItem("".concat(this.cacheKey,"_").concat(e),JSON.stringify(n))}catch(n){(0,d._N)("\uce90\uc2dc \uc800\uc7a5 \uc2e4\ud328:",n)}}}class m{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"testnet";this.network=e;const t=u.Of[e]||u.Of.mainnet;this.baseUrl=t.explorerApi||t.explorer}async getTokenList(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:50;try{const n="".concat(this.baseUrl,"/api/v2/tokens"),r=new URLSearchParams({page:e.toString(),limit:t.toString()}),s="".concat(n,"?").concat(r);(0,d.UJ)("\ud1a0\ud070 \ubaa9\ub85d API \uc694\uccad:",s);const a=await fetch(s,{method:"GET",headers:{Accept:"application/json","Content-Type":"application/json"},signal:AbortSignal.timeout(15e3)});if(!a.ok)throw new Error("\ud1a0\ud070 \ubaa9\ub85d API \uc694\uccad \uc2e4\ud328: ".concat(a.status," ").concat(a.statusText));const i=await a.json();return{success:!0,tokens:this.formatTokenList(i.items||[]),pagination:{hasMore:null!==i.next_page_params,nextPageParams:i.next_page_params},source:"blockscout-token-list"}}catch(n){return(0,d._N)("\ud1a0\ud070 \ubaa9\ub85d \uc870\ud68c \uc2e4\ud328:",n.message),{success:!1,error:n.message}}}async getPopularTokens(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:20;try{const t="".concat(this.baseUrl,"/api/v2/tokens"),n=new URLSearchParams({limit:e.toString(),sort:"holder_count",order:"desc"}),r="".concat(t,"?").concat(n);(0,d.UJ)("\uc778\uae30 \ud1a0\ud070 API \uc694\uccad:",r);const s=await fetch(r,{method:"GET",headers:{Accept:"application/json"},signal:AbortSignal.timeout(1e4)});if(!s.ok)throw new Error("\uc778\uae30 \ud1a0\ud070 API \uc694\uccad \uc2e4\ud328: ".concat(s.status));const a=await s.json();return{success:!0,tokens:this.formatTokenList(a.items||[]),source:"popular-tokens"}}catch(t){return(0,d._N)("\uc778\uae30 \ud1a0\ud070 \uc870\ud68c \uc2e4\ud328:",t.message),this.getDefaultTokenList()}}async searchTokens(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:20;try{const n="".concat(this.baseUrl,"/api/v2/search"),r=new URLSearchParams({q:e,filter:"token",limit:t.toString()}),s="".concat(n,"?").concat(r);(0,d.UJ)("\ud1a0\ud070 \uac80\uc0c9 API \uc694\uccad:",s);const a=await fetch(s,{method:"GET",headers:{Accept:"application/json"},signal:AbortSignal.timeout(8e3)});if(!a.ok)throw new Error("\ud1a0\ud070 \uac80\uc0c9 API \uc694\uccad \uc2e4\ud328: ".concat(a.status));const i=((await a.json()).items||[]).filter(e=>"token"===e.type||e.token);return{success:!0,tokens:this.formatSearchResults(i),source:"search-results"}}catch(n){return(0,d._N)("\ud1a0\ud070 \uac80\uc0c9 \uc2e4\ud328:",n.message),{success:!1,error:n.message}}}async getAccountTokenBalances(e){try{const t="".concat(this.baseUrl,"/api/v2/addresses/").concat(e,"/token-balances");(0,d.UJ)("\ud1a0\ud070 \uc794\uc561 \uc870\ud68c API \uc694\uccad:",t);const n=await fetch(t,{method:"GET",headers:{Accept:"application/json","Content-Type":"application/json"},signal:AbortSignal.timeout(15e3)});if(!n.ok)throw new Error("\ud1a0\ud070 \uc794\uc561 API \uc694\uccad \uc2e4\ud328: ".concat(n.status," ").concat(n.statusText));const r=(await n.json()||[]).filter(e=>{const t=e.value||e.balance||"0";return"0"!==t&&parseFloat(t)>0});return{success:!0,tokens:this.formatTokenBalances(r),source:"blockscout-balances"}}catch(t){return(0,d._N)("\ud1a0\ud070 \uc794\uc561 \uc870\ud68c \uc2e4\ud328:",t.message),{success:!1,error:t.message}}}async loadTokenConfig(){try{(0,d.UJ)("\ud83d\udccb \uc678\ubd80 \ud1a0\ud070 \uc124\uc815 \ub85c\ub4dc \uc911...");const e=document.createElement("iframe");return e.style.display="none",e.src="/token-config.html",new Promise((t,n)=>{e.onload=()=>{try{const n=this.network,r=u.gB[n];document.body.removeChild(e),r&&Array.isArray(r)?((0,d.UJ)("\u2705 \uc678\ubd80 \ud1a0\ud070 \uc124\uc815 \ub85c\ub4dc \uc131\uacf5: ".concat(r.length,"\uac1c")),t(r)):((0,d._N)("\u26a0\ufe0f \uc678\ubd80 \ud1a0\ud070 \uc124\uc815\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc74c, \uae30\ubcf8\uac12 \uc0ac\uc6a9"),t(this.getFallbackTokenList()))}catch(n){(0,d._N)("\u26a0\ufe0f \uc678\ubd80 \ud1a0\ud070 \uc124\uc815 \ud30c\uc2f1 \uc2e4\ud328, \uae30\ubcf8\uac12 \uc0ac\uc6a9:",n),document.body.removeChild(e),t(this.getFallbackTokenList())}},e.onerror=()=>{(0,d._N)("\u26a0\ufe0f \uc678\ubd80 \ud1a0\ud070 \uc124\uc815 \ub85c\ub4dc \uc2e4\ud328, \uae30\ubcf8\uac12 \uc0ac\uc6a9"),document.body.removeChild(e),t(this.getFallbackTokenList())},document.body.appendChild(e),setTimeout(()=>{e.parentNode&&(document.body.removeChild(e),(0,d._N)("\u26a0\ufe0f \uc678\ubd80 \ud1a0\ud070 \uc124\uc815 \ub85c\ub4dc \ud0c0\uc784\uc544\uc6c3, \uae30\ubcf8\uac12 \uc0ac\uc6a9"),t(this.getFallbackTokenList()))},5e3)})}catch(e){return(0,d._N)("\u26a0\ufe0f \ud1a0\ud070 \uc124\uc815 \ub85c\ub4dc \uc2e4\ud328, \uae30\ubcf8\uac12 \uc0ac\uc6a9:",e),this.getFallbackTokenList()}}getFallbackTokenList(){const e=this.network||"mainnet",t=u.gB[e]||u.gB.mainnet;return(0,d.UJ)("\ud83d\udccb \ub124\ud2b8\uc6cc\ud06c [".concat(e,"] \uae30\ubcf8 \ud1a0\ud070 \ubaa9\ub85d \ubc18\ud658: ").concat(t.length,"\uac1c")),t}async getDefaultTokenList(){try{const e=await this.loadTokenConfig();return{success:!0,tokens:e.map(e=>{var t;return{address:e.address,name:e.name||"Unknown Token",symbol:e.symbol||"UNK",decimals:parseInt(e.decimals||"18"),type:"ERC-20",totalSupply:"0",holderCount:0,description:e.description||"",verified:e.verified||!1,homepage:e.homepage||null,balance:"0",balanceRaw:"0",network:(null===(t=u.Of[this.network])||void 0===t?void 0:t.name)||"Unknown Network"}}),source:"external-config"}}catch(e){(0,d.sd)("\u274c \uc678\ubd80 \ud1a0\ud070 \uc124\uc815 \ub85c\ub4dc \uc2e4\ud328:",e);return{success:!0,tokens:this.getFallbackTokenList().map(e=>({address:e.address,name:e.name,symbol:e.symbol,decimals:e.decimals,type:"ERC-20",totalSupply:"0",holderCount:0,description:"",verified:e.verified,homepage:e.homepage||null,balance:"0",balanceRaw:"0"})),source:"fallback-hardcoded"}}}formatTokenList(e){return e.map(e=>({address:e.address,name:e.name||"Unknown Token",symbol:e.symbol||"UNK",decimals:parseInt(e.decimals||"18"),type:e.type||"ERC-20",totalSupply:e.total_supply||"0",holderCount:e.holders_count||0,description:e.description||"",verified:e.is_verified||!1,homepage:e.homepage||null,balance:"0",balanceRaw:"0"}))}formatSearchResults(e){return e.map(e=>{const t=e.token||e;return{address:t.address,name:t.name||"Unknown Token",symbol:t.symbol||"UNK",decimals:parseInt(t.decimals||"18"),type:t.type||"ERC-20",totalSupply:t.total_supply||"0",holderCount:t.holders_count||0,description:t.description||"",verified:t.is_verified||!1,balance:"0",balanceRaw:"0"}})}formatTokenBalances(e){return e.map(e=>{var t,n,r,s,a,i,o,l;return{address:(null===(t=e.token)||void 0===t?void 0:t.address)||e.address,name:(null===(n=e.token)||void 0===n?void 0:n.name)||e.name||"Unknown Token",symbol:(null===(r=e.token)||void 0===r?void 0:r.symbol)||e.symbol||"UNK",decimals:parseInt((null===(s=e.token)||void 0===s?void 0:s.decimals)||e.decimals||"18"),balance:this.formatTokenAmount(e.value||e.balance||"0",parseInt((null===(a=e.token)||void 0===a?void 0:a.decimals)||e.decimals||"18")),balanceRaw:e.value||e.balance||"0",type:(null===(i=e.token)||void 0===i?void 0:i.type)||"ERC-20",verified:(null===(o=e.token)||void 0===o?void 0:o.is_verified)||!1,network:(null===(l=u.Of[this.network])||void 0===l?void 0:l.name)||"Unknown Network"}})}async getTokenBalance(e,t){try{const n="".concat(this.baseUrl,"/api/v2/addresses/").concat(e,"/tokens/").concat(t),r=await fetch(n,{method:"GET",headers:{Accept:"application/json"},signal:AbortSignal.timeout(5e3)});if(!r.ok)throw new Error("\ud2b9\uc815 \ud1a0\ud070 \uc794\uc561 \uc870\ud68c \uc2e4\ud328: ".concat(r.status));const s=await r.json();return{success:!0,token:this.formatSingleToken(s)}}catch(n){return{success:!1,error:n.message}}}formatSingleToken(e){var t;return{address:e.address,name:e.name||"Unknown Token",symbol:e.symbol||"UNK",decimals:parseInt(e.decimals||"18"),balance:this.formatTokenAmount(e.balance||"0",parseInt(e.decimals||"18")),balanceRaw:e.balance||"0",type:e.type||"ERC-20",verified:e.is_verified||!1,network:(null===(t=u.Of[this.network])||void 0===t?void 0:t.name)||"Unknown Network"}}async getAllTransactions(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};try{var n,r;const{limit:s=20,tokenAddress:a=null}=t;if((0,d.UJ)("\ud83d\udd04 \ud1b5\ud569 \uac70\ub798\ub0b4\uc5ed \uc870\ud68c \uc2dc\uc791:",{address:e,limit:s,tokenAddress:a}),a){(0,d.UJ)("\ud83e\ude99 \ud2b9\uc815 \ud1a0\ud070 \uc804\uc1a1\ub0b4\uc5ed\ub9cc \uc870\ud68c:",a);const t=await this.getTokenTransfers(e,{offset:s,contractaddress:a});return{success:t.success,transactions:t.transfers||[],source:"token-only"}}const[i,o]=await Promise.all([this.getAccountTransactions(e,{offset:Math.ceil(s/2)}),this.getTokenTransfers(e,{offset:Math.ceil(s/2)})]),l=[];return i.success&&i.transactions&&(l.push(...i.transactions),(0,d.UJ)("\ud83d\udcc8 \ub124\uc774\ud2f0\ube0c \uac70\ub798 ".concat(i.transactions.length,"\uac1c \ucd94\uac00"))),o.success&&o.transfers&&(l.push(...o.transfers),(0,d.UJ)("\ud83e\ude99 \ud1a0\ud070 \uc804\uc1a1 ".concat(o.transfers.length,"\uac1c \ucd94\uac00"))),l.sort((e,t)=>(t.timestamp||0)-(e.timestamp||0)),(0,d.UJ)("\ud83c\udfaf \ud1b5\ud569 \uac70\ub798\ub0b4\uc5ed \uc870\ud68c \uc644\ub8cc: \ucd1d ".concat(l.length,"\uac1c")),{success:!0,transactions:l.slice(0,s),source:"combined",nativeCount:i.success&&(null===(n=i.transactions)||void 0===n?void 0:n.length)||0,tokenCount:o.success&&(null===(r=o.transfers)||void 0===r?void 0:r.length)||0}}catch(s){return(0,d.sd)("\u274c \ud1b5\ud569 \uac70\ub798\ub0b4\uc5ed \uc870\ud68c \uc2e4\ud328:",s),{success:!1,error:"\ud1b5\ud569 \uac70\ub798\ub0b4\uc5ed \uc870\ud68c \uc2e4\ud328: ".concat(s.message)}}}async getAccountTransactions(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};try{const{page:n=1,offset:r=20,sort:s="desc",startblock:a=0,endblock:i=99999999}=t,o=new URLSearchParams({module:"account",action:"txlist",address:e,startblock:a.toString(),endblock:i.toString(),page:n.toString(),offset:r.toString(),sort:s});if(this.baseUrl.includes("etherscan.io")){const e=u.Of[this.network];o.append("chainid",e.chainId.toString()),o.append("apikey","SWZB5JWME7SU16ARWYDQVEDKQFZBWKKTC5")}const l="".concat(this.baseUrl,"/api?").concat(o);(0,d.UJ)("\ud83c\udf10 WorldLand API \uc694\uccad:",l);const c=await fetch(l,{method:"GET",headers:{Accept:"application/json","Content-Type":"application/json"},signal:AbortSignal.timeout(15e3)});if(!c.ok)throw new Error("API \uc694\uccad \uc2e4\ud328: ".concat(c.status," ").concat(c.statusText));const h=await c.json();(0,d.UJ)("\ud83d\udcca API \uc751\ub2f5:",h);if(this.baseUrl.includes("etherscan.io")?"1"===h.status&&Array.isArray(h.result):"OK"===h.message&&Array.isArray(h.result)){const e=this.formatWorldLandTransactions(h.result);(0,d.UJ)("\u2705 \uac70\ub798\ub0b4\uc5ed ".concat(e.length,"\uac1c \uc870\ud68c \uc131\uacf5"));const t=this.baseUrl.includes("etherscan.io")?"etherscan-".concat(this.network):"worldland-api";return{success:!0,transactions:e,totalCount:h.result.length,source:t}}return(0,d._N)("\u26a0\ufe0f \uc608\uc0c1\uacfc \ub2e4\ub978 API \uc751\ub2f5 \ud615\uc2dd:",h),{success:!1,error:"\uac70\ub798\ub0b4\uc5ed\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."}}catch(n){return(0,d.sd)("\u274c WorldLand API \uac70\ub798\ub0b4\uc5ed \uc870\ud68c \uc2e4\ud328:",n),{success:!1,error:"\uac70\ub798\ub0b4\uc5ed \uc870\ud68c \uc2e4\ud328: ".concat(n.message)}}}formatWorldLandTransactions(e){return e.map(e=>{const t=e.input&&"0x"!==e.input&&"0"===e.value;return{hash:e.hash,from:e.from,to:e.to,value:this.weiToEther(e.value||"0"),valueRaw:e.value||"0",blockNumber:parseInt(e.blockNumber||0),timestamp:parseInt(e.timeStamp||0),gasUsed:e.gasUsed||"0",gasPrice:e.gasPrice||"0",status:this.parseTransactionStatus(e.txreceipt_status,e.isError),type:t?"contract_call":"transaction",nonce:parseInt(e.nonce||0),input:e.input||"0x",confirmations:parseInt(e.confirmations||0),cumulativeGasUsed:e.cumulativeGasUsed||"0",transactionIndex:parseInt(e.transactionIndex||0)}})}async getTokenTransfers(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};try{const{page:n=1,offset:r=20,sort:s="desc",contractaddress:a=null,startblock:i=0,endblock:o=99999999}=t,l=new URLSearchParams({module:"account",action:"tokentx",address:e,startblock:i.toString(),endblock:o.toString(),page:n.toString(),offset:r.toString(),sort:s});if(a&&l.append("contractaddress",a),this.baseUrl.includes("etherscan.io")){const e=u.Of[this.network];l.append("chainid",e.chainId.toString()),l.append("apikey","SWZB5JWME7SU16ARWYDQVEDKQFZBWKKTC5")}const c="".concat(this.baseUrl,"/api?").concat(l);(0,d.UJ)("\ud83e\ude99 \ud1a0\ud070 \uc804\uc1a1\ub0b4\uc5ed API \uc694\uccad:",c);const h=await fetch(c,{method:"GET",headers:{Accept:"application/json"},signal:AbortSignal.timeout(15e3)});if(!h.ok)throw new Error("\ud1a0\ud070 \uc804\uc1a1\ub0b4\uc5ed API \uc694\uccad \uc2e4\ud328: ".concat(h.status));const f=await h.json();if(this.baseUrl.includes("etherscan.io")?"1"===f.status&&Array.isArray(f.result):"OK"===f.message&&Array.isArray(f.result)){const e=this.formatWorldLandTokenTransfers(f.result);(0,d.UJ)("\u2705 \ud1a0\ud070 \uc804\uc1a1\ub0b4\uc5ed ".concat(e.length,"\uac1c \uc870\ud68c \uc131\uacf5"));const t=this.baseUrl.includes("etherscan.io")?"etherscan-token-".concat(this.network):"worldland-token-api";return{success:!0,transfers:e,totalCount:f.result.length,source:t}}return{success:!0,transfers:[],totalCount:0,source:this.baseUrl.includes("etherscan.io")?"etherscan-token-".concat(this.network):"worldland-token-api"}}catch(n){return(0,d.sd)("\u274c \ud1a0\ud070 \uc804\uc1a1\ub0b4\uc5ed \uc870\ud68c \uc2e4\ud328:",n),{success:!1,error:"\ud1a0\ud070 \uc804\uc1a1\ub0b4\uc5ed \uc870\ud68c \uc2e4\ud328: ".concat(n.message)}}}formatWorldLandTokenTransfers(e){return e.map(e=>({hash:e.hash,from:e.from,to:e.to,value:this.formatTokenAmount(e.value||"0",parseInt(e.tokenDecimal||18)),valueRaw:e.value||"0",blockNumber:parseInt(e.blockNumber||0),timestamp:parseInt(e.timeStamp||0),gasUsed:e.gasUsed||"0",gasPrice:e.gasPrice||"0",status:this.parseTransactionStatus(e.txreceipt_status,e.isError),type:"token_transfer",token:{address:e.contractAddress,name:e.tokenName||"Unknown Token",symbol:e.tokenSymbol||"UNK",decimals:parseInt(e.tokenDecimal||18)},nonce:parseInt(e.nonce||0),confirmations:parseInt(e.confirmations||0),cumulativeGasUsed:e.cumulativeGasUsed||"0",transactionIndex:parseInt(e.transactionIndex||0)}))}parseTransactionStatus(e,t){return"1"===t||1===t?"failed":"1"===e||1===e?"success":"0"===e||0===e?"failed":"pending"}async getAccountBalance(e){try{const t="".concat(this.baseUrl,"/api/v2/addresses/").concat(e),n=await fetch(t,{method:"GET",headers:{Accept:"application/json"},signal:AbortSignal.timeout(5e3)});if(!n.ok)throw new Error("\uc794\uc561 \uc870\ud68c \uc2e4\ud328: ".concat(n.status));const r=await n.json();return{success:!0,balance:this.weiToEther(r.coin_balance||"0"),address:r.hash}}catch(t){return{success:!1,error:t.message}}}formatTokenTransfers(e){return e.map(e=>{var t,n,r,s,a,i,o,l,c,u;return{hash:e.tx_hash,from:(null===(t=e.from)||void 0===t?void 0:t.hash)||e.from,to:(null===(n=e.to)||void 0===n?void 0:n.hash)||e.to,value:this.formatTokenAmount((null===(r=e.total)||void 0===r?void 0:r.value)||e.value||"0",parseInt((null===(s=e.total)||void 0===s?void 0:s.decimals)||(null===(a=e.token)||void 0===a?void 0:a.decimals)||"18")),valueRaw:(null===(i=e.total)||void 0===i?void 0:i.value)||e.value||"0",blockNumber:e.block_number||0,timestamp:e.timestamp?new Date(e.timestamp).getTime()/1e3:Date.now()/1e3,token:{address:null===(o=e.token)||void 0===o?void 0:o.address,name:(null===(l=e.token)||void 0===l?void 0:l.name)||"Unknown Token",symbol:(null===(c=e.token)||void 0===c?void 0:c.symbol)||"UNK",decimals:parseInt((null===(u=e.token)||void 0===u?void 0:u.decimals)||"18")},type:"token_transfer",status:"success"}})}formatBlockScoutTransactions(e){return e.map(e=>{var t,n;return{hash:e.hash,from:(null===(t=e.from)||void 0===t?void 0:t.hash)||e.from,to:(null===(n=e.to)||void 0===n?void 0:n.hash)||e.to,value:e.value?this.weiToEther(e.value):"0",blockNumber:e.block_number||0,timestamp:e.timestamp?new Date(e.timestamp).getTime()/1e3:Date.now()/1e3,gasUsed:e.gas_used||"0",gasPrice:e.gas_price||"0",status:"ok"===e.status?"success":"failed",type:"transaction"}})}formatTokenAmount(e,t){try{return e&&"0"!==e?s.Js(e,t):"0"}catch(n){return"0"}}weiToEther(e){try{return e&&"0"!==e?s.ck(e):"0"}catch(t){return"0"}}}const g=new class{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"mainnet";this.network=e,this.provider=new a.FR(u.Of[e].rpcUrl),this.explorer=new m(e),this.cache=new p}async getAvailableTokens(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:50;return await this.explorer.getTokenList(e,t)}async getPopularTokens(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:20;return await this.explorer.getPopularTokens(e)}async searchTokens(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:20;return!e||e.trim().length<2?{success:!1,error:"\uac80\uc0c9\uc5b4\ub294 2\uae00\uc790 \uc774\uc0c1 \uc785\ub825\ud574\uc8fc\uc138\uc694."}:await this.explorer.searchTokens(e.trim(),t)}createWallet(){try{var e;const t=i.u.createRandom();return{address:t.address,privateKey:t.privateKey,mnemonic:null===(e=t.mnemonic)||void 0===e?void 0:e.phrase,success:!0}}catch(t){return{success:!1,error:t.message}}}importWallet(e){try{e.startsWith("0x")||(e="0x"+e);const t=new i.u(e);return{address:t.address,privateKey:t.privateKey,mnemonic:null,success:!0}}catch(t){return{success:!1,error:"\uc798\ubabb\ub41c \uac1c\uc778\ud0a4 \ud615\uc2dd\uc785\ub2c8\ub2e4."}}}isValidAddress(e){try{return o.PW(e)}catch(t){return!1}}async getAllBalances(e){try{(0,d.UJ)("\ud83d\udd0d getAllBalances \uc2dc\uc791: ".concat(e));const n={native:null,tokens:[],success:!0,errors:[]};try{(0,d.UJ)("1\ufe0f\u20e3 \ub124\uc774\ud2f0\ube0c \uc794\uc561 \uc870\ud68c...");const t=await this.getBalance(e);t.success?(n.native={symbol:"WLC",name:"WorldLand Coin",balance:t.balance,type:"native",decimals:18},(0,d.UJ)("\u2705 \ub124\uc774\ud2f0\ube0c \uc794\uc561 \uc870\ud68c \uc131\uacf5:",t.balance)):((0,d._N)("\u26a0\ufe0f \ub124\uc774\ud2f0\ube0c \uc794\uc561 \uc870\ud68c \uc2e4\ud328:",t.error),n.errors.push("\ub124\uc774\ud2f0\ube0c \ud1a0\ud070 \uc870\ud68c \uc2e4\ud328: "+t.error))}catch(t){(0,d.sd)("\u274c \ub124\uc774\ud2f0\ube0c \uc794\uc561 \uc870\ud68c \uc608\uc678:",t),n.errors.push("\ub124\uc774\ud2f0\ube0c \ud1a0\ud070 \uc870\ud68c \uc608\uc678: "+t.message)}(0,d.UJ)("2\ufe0f\u20e3 \ud1a0\ud070 \uc794\uc561 \uc870\ud68c \uc2dc\uc791...");const r=await this.discoverTokenBalances(e);return r.success&&r.tokens.length>0?(n.tokens=r.tokens,(0,d.UJ)("\u2705 \ud1a0\ud070 \ubc1c\uacac \uc131\uacf5: ".concat(n.tokens.length,"\uac1c"))):((0,d.UJ)("\ud83d\udca1 \ud1a0\ud070\uc744 \ucc3e\uc744 \uc218 \uc5c6\uac70\ub098 \uc870\ud68c \uc2e4\ud328:",r.error),n.errors.push("\ud1a0\ud070 \uc870\ud68c \uc2e4\ud328: "+(r.error||"\uc54c \uc218 \uc5c6\uc74c"))),(0,d.UJ)("\ud83d\udcca getAllBalances \ucd5c\uc885 \uacb0\uacfc:",{native:!!n.native,tokenCount:n.tokens.length,errors:n.errors.length}),n}catch(t){return(0,d.sd)("\u274c getAllBalances \uc804\uccb4 \uc2e4\ud328:",t),{success:!1,error:"\uc804\uccb4 \uc794\uc561 \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: "+t.message}}}async discoverTokenBalances(e){(0,d.UJ)("\ud83e\ude99 \ud1a0\ud070 \ubc1c\uacac \uc2dc\uc791: ".concat(e));try{(0,d.UJ)("\ud83d\udce1 \ubc29\ubc95 1: BlockScout token-balances API \uc2dc\ub3c4...");const t=await this.explorer.getAccountTokenBalances(e);if(t.success&&t.tokens.length>0)return(0,d.UJ)("\u2705 BlockScout\uc5d0\uc11c ".concat(t.tokens.length,"\uac1c \ud1a0\ud070 \ubc1c\uacac")),{success:!0,tokens:t.tokens,source:"blockscout-balances"};(0,d.UJ)("\u26aa BlockScout token-balances\uc5d0\uc11c \ud1a0\ud070 \uc5c6\uc74c")}catch(t){(0,d._N)("\u26a0\ufe0f BlockScout token-balances \uc2e4\ud328:",t.message)}try{(0,d.UJ)("\ud83d\udce1 \ubc29\ubc95 2: BlockScout \uc8fc\uc18c \uc815\ubcf4\uc5d0\uc11c \ud1a0\ud070 \ucd94\ucd9c \uc2dc\ub3c4...");const t=await this.getAddressTokensFromInfo(e);if(t.success&&t.tokens.length>0)return(0,d.UJ)("\u2705 \uc8fc\uc18c \uc815\ubcf4\uc5d0\uc11c ".concat(t.tokens.length,"\uac1c \ud1a0\ud070 \ubc1c\uacac")),t;(0,d.UJ)("\u26aa \uc8fc\uc18c \uc815\ubcf4\uc5d0\uc11c\ub3c4 \ud1a0\ud070 \uc5c6\uc74c")}catch(t){(0,d._N)("\u26a0\ufe0f \uc8fc\uc18c \uc815\ubcf4 \ucd94\ucd9c \uc2e4\ud328:",t.message)}try{(0,d.UJ)("\ud83d\udce1 \ubc29\ubc95 3: \uc54c\ub824\uc9c4 \ud1a0\ud070 \uac1c\ubcc4 \uc870\ud68c \uc2dc\ub3c4...");const t=await this.checkKnownTokens(e);if(t.success&&t.tokens.length>0)return(0,d.UJ)("\u2705 \uc54c\ub824\uc9c4 \ud1a0\ud070\uc5d0\uc11c ".concat(t.tokens.length,"\uac1c \ubc1c\uacac")),t;(0,d.UJ)("\u26aa \uc54c\ub824\uc9c4 \ud1a0\ud070\uc5d0\uc11c\ub3c4 \uc794\uc561 \uc5c6\uc74c")}catch(t){(0,d._N)("\u26a0\ufe0f \uc54c\ub824\uc9c4 \ud1a0\ud070 \uc870\ud68c \uc2e4\ud328:",t.message)}return(0,d.UJ)("\ud83d\udca1 \ubaa8\ub4e0 \ubc29\ubc95\uc73c\ub85c \ud1a0\ud070\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4"),{success:!1,tokens:[],error:"\ubaa8\ub4e0 \ud1a0\ud070 \ubc1c\uacac \ubc29\ubc95\uc774 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4"}}async getAddressTokensFromInfo(e){try{const t="".concat(this.explorer.baseUrl,"/api/v2/addresses/").concat(e);(0,d.UJ)("\ud83c\udf10 \uc8fc\uc18c \uc815\ubcf4 API \ud638\ucd9c:",t);const n=await fetch(t,{method:"GET",headers:{Accept:"application/json"},signal:AbortSignal.timeout(1e4)});if(!n.ok)throw new Error("\uc8fc\uc18c \uc815\ubcf4 API \uc694\uccad \uc2e4\ud328: ".concat(n.status));const r=await n.json();(0,d.UJ)("\ud83d\udcc4 \uc8fc\uc18c \uc815\ubcf4 \uc751\ub2f5:",r);const s=[];return r.token&&r.token.length>0&&s.push(...r.token),{success:!0,tokens:this.explorer.formatTokenBalances(s),source:"address-info"}}catch(t){return(0,d.sd)("\uc8fc\uc18c \uc815\ubcf4 \ucd94\ucd9c \uc2e4\ud328:",t),{success:!1,tokens:[],error:t.message}}}async checkKnownTokens(e){try{(0,d.UJ)("\ud83d\udd0d \uc54c\ub824\uc9c4 \ud1a0\ud070 \uac1c\ubcc4 \uc870\ud68c \uc2dc\uc791...");let n=[];const r=await this.getPopularTokens(10);if(r.success&&r.tokens.length>0)n=r.tokens,(0,d.UJ)("\ud83d\udccb \uc778\uae30 \ud1a0\ud070 ".concat(n.length,"\uac1c \ub85c\ub4dc\ub428"));else{(0,d.UJ)("\ud83d\udccb \uc778\uae30 \ud1a0\ud070 \uc2e4\ud328, \uc124\uc815 \ud1a0\ud070 \ubaa9\ub85d \uc2dc\ub3c4...");const e=await this.getDefaultTokenList();if(!(e.success&&e.tokens.length>0))return(0,d.UJ)("\u26aa \ubaa8\ub4e0 \ud1a0\ud070 \ubaa9\ub85d\uc744 \uac00\uc838\uc62c \uc218 \uc5c6\uc74c"),{success:!1,tokens:[],error:"\ud1a0\ud070 \ubaa9\ub85d \uc870\ud68c \uc2e4\ud328"};n=e.tokens,(0,d.UJ)("\ud83d\udccb \uc124\uc815 \ud1a0\ud070 ".concat(n.length,"\uac1c \ub85c\ub4dc\ub428"))}(0,d.UJ)("\ud83d\udccb ".concat(n.length,"\uac1c \ud1a0\ud070\uc5d0 \ub300\ud574 \uc794\uc561 \uc870\ud68c..."));const s=[];for(const a of n.slice(0,8))try{(0,d.UJ)("\ud83d\udd0d ".concat(a.symbol," \uc794\uc561 \uc870\ud68c..."));const t=await this.getTokenBalance(e,a.address);if(t.success){const e=parseFloat(t.token.balance||"0");e>0?((0,d.UJ)("\ud83d\udcb0 ".concat(a.symbol,": ").concat(e," \ubc1c\uacac!")),s.push(t.token)):(0,d.UJ)("\u26aa ".concat(a.symbol,": \uc794\uc561 0"))}else(0,d.UJ)("\u274c ".concat(a.symbol,": \uc870\ud68c \uc2e4\ud328 - ").concat(t.error))}catch(t){(0,d._N)("\u26a0\ufe0f ".concat(a.symbol," \uac1c\ubcc4 \uc870\ud68c \uc608\uc678:"),t)}return(0,d.UJ)("\ud83c\udfaf \uac1c\ubcc4 \uc870\ud68c \uc644\ub8cc: ".concat(s.length,"\uac1c \ud1a0\ud070\uc5d0\uc11c \uc794\uc561 \ubc1c\uacac")),{success:!0,tokens:s,source:"individual-check"}}catch(n){return(0,d.sd)("\uc54c\ub824\uc9c4 \ud1a0\ud070 \uc870\ud68c \uc2e4\ud328:",n),{success:!1,tokens:[],error:n.message}}}async getBalance(e){try{const t=await this.explorer.getAccountBalance(e);if(t.success)return t;const n=await this.provider.getBalance(e);return{balance:s.ck(n),success:!0}}catch(t){return{success:!1,error:"\uc794\uc561 \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: "+t.message}}}async getTokenBalance(e,t){try{var n;const r=await this.explorer.getTokenBalance(e,t);if(r.success)return r;const a=new l.NZ(t,h,this.provider),[i,o,c,d]=await Promise.all([a.balanceOf(e),a.decimals().catch(()=>18),a.symbol().catch(()=>"UNK"),a.name().catch(()=>"Unknown Token")]);return{success:!0,token:{address:t,name:d,symbol:c,decimals:o,balance:s.Js(i,o),balanceRaw:i.toString(),type:"ERC-20",verified:!1,network:(null===(n=u.Of[this.network])||void 0===n?void 0:n.name)||"Unknown Network"}}}catch(r){return{success:!1,error:"\ud1a0\ud070 \uc794\uc561 \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: "+r.message}}}async getTransactionHistory(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:20,n=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],s=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null;try{if(a&&a.name&&this.network!==a.name){(0,d.UJ)("\ud83d\udd04 \uac70\ub798\ub0b4\uc5ed \uc870\ud68c\ub97c \uc704\ud55c \ub124\ud2b8\uc6cc\ud06c \uc804\ud658: ".concat(this.network," \u2192 ").concat(a.name));const e=Object.keys(u.Of).find(e=>u.Of[e].name===a.name);e&&this.switchNetwork(e)}if(console.log("\ud1b5\ud569 \uac70\ub798\ub0b4\uc5ed \uc870\ud68c \uc2dc\uc791: ".concat(e," (\ub124\ud2b8\uc6cc\ud06c: ").concat(this.network,")")),n){const n=this.cache.getCachedTransactions(e);if(n&&n.length>0){(0,d.UJ)("\uce90\uc2dc\uc5d0\uc11c \uac70\ub798\ub0b4\uc5ed \ubc18\ud658");let e=n;return s&&(e="native"===s.type?n.filter(e=>"transaction"===e.type):n.filter(e=>{var t,n,r;return"token_transfer"===e.type&&(null===(t=e.token)||void 0===t||null===(n=t.address)||void 0===n?void 0:n.toLowerCase())===(null===(r=s.address)||void 0===r?void 0:r.toLowerCase())})),{success:!0,transactions:e.slice(0,t),fromCache:!0}}}let i;if(i=s&&"native"!==s.type?await this.explorer.getAllTransactions(e,{limit:t,tokenAddress:s.address}):await this.explorer.getAllTransactions(e,{limit:t}),i.success&&i.transactions.length>0)return(0,d.UJ)("\ud1b5\ud569 API \uc131\uacf5: ".concat(i.transactions.length,"\uac1c \uac70\ub798")),this.cache.setCachedTransactions(e,i.transactions),(0,r.A)((0,r.A)({},i),{},{source:"integrated"});(0,d.UJ)("\ub124\uc774\ud2f0\ube0c \uac70\ub798\ub9cc \uc870\ud68c \uc911...");const o=await this.explorer.getAccountTransactions(e,{limit:t});return o.success&&o.transactions.length>0?((0,d.UJ)("\ub124\uc774\ud2f0\ube0c \uac70\ub798 \uc131\uacf5: ".concat(o.transactions.length,"\uac1c \uac70\ub798")),this.cache.setCachedTransactions(e,o.transactions),(0,r.A)((0,r.A)({},o),{},{source:"native-only"})):((0,d.UJ)("\uc2e4\uc81c API \uc2e4\ud328, \ub370\ubaa8 \ub370\uc774\ud130 \uc0ac\uc6a9"),await this.getDemoTransactions(e,t))}catch(i){return(0,d.sd)("\ud1b5\ud569 \uac70\ub798 \ub0b4\uc5ed \uc870\ud68c \uc2e4\ud328:",i),{success:!1,error:"\uac70\ub798 \ub0b4\uc5ed \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4."}}}async sendToken(e,t,n,r){let a=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"20";try{if(!this.isValidAddress(n))throw new Error("\uc798\ubabb\ub41c \ubc1b\ub294 \uc8fc\uc18c\uc785\ub2c8\ub2e4.");if(!this.isValidAddress(t))throw new Error("\uc798\ubabb\ub41c \ud1a0\ud070 \uc8fc\uc18c\uc785\ub2c8\ub2e4.");if(parseFloat(r)<=0)throw new Error("\uc804\uc1a1\ub7c9\uc740 0\ubcf4\ub2e4 \ucee4\uc57c \ud569\ub2c8\ub2e4.");const o=new i.u(e,this.provider),c=new l.NZ(t,h,o),[u,d]=await Promise.all([c.decimals(),c.symbol()]),f=await c.balanceOf(o.address),p=s.XS(r,u);if(f<p)throw new Error("\ud1a0\ud070 \uc794\uc561\uc774 \ubd80\uc871\ud569\ub2c8\ub2e4.");const m=await c.transfer(n,p,{gasPrice:s.XS(a,"gwei")}),g=await m.wait();return{hash:m.hash,from:m.from,to:n,value:r,token:{address:t,symbol:d,decimals:u},gasUsed:g.gasUsed.toString(),blockNumber:g.blockNumber,success:!0}}catch(o){return{success:!1,error:o.message}}}async estimateTokenTransactionFee(e,t,n,r){try{const a=new l.NZ(e,h,this.provider),i=await a.decimals(),o=s.XS(n,i),c=await a.transfer.estimateGas(t,o),u=c*s.XS(r,"gwei");return{gasLimit:c.toString(),fee:s.ck(u),success:!0}}catch(a){return{success:!1,error:"\ud1a0\ud070 \uc218\uc218\ub8cc \ucd94\uc815\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4."}}}async estimateGasPrice(){try{const e=await this.provider.getFeeData();return{gasPrice:s.Js(e.gasPrice||0n,"gwei"),success:!0}}catch(e){return{success:!1,error:"\uac00\uc2a4 \uac00\uaca9 \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4."}}}async estimateTransactionFee(e,t,n){try{const r={to:e,value:s.g5(t),gasPrice:s.XS(n,"gwei")},a=await this.provider.estimateGas(r),i=a*s.XS(n,"gwei");return{gasLimit:a.toString(),fee:s.ck(i),success:!0}}catch(r){return{success:!1,error:"\uc218\uc218\ub8cc \ucd94\uc815\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4."}}}async sendTransaction(e,t,n){let r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"20";try{if(!this.isValidAddress(t))throw new Error("\uc798\ubabb\ub41c \ubc1b\ub294 \uc8fc\uc18c\uc785\ub2c8\ub2e4.");if(parseFloat(n)<=0)throw new Error("\uc804\uc1a1\ub7c9\uc740 0\ubcf4\ub2e4 \ucee4\uc57c \ud569\ub2c8\ub2e4.");const a=new i.u(e,this.provider),o=await a.provider.getBalance(a.address),l=s.g5(n);if(o<l)throw new Error("\uc794\uc561\uc774 \ubd80\uc871\ud569\ub2c8\ub2e4.");const c=await a.sendTransaction({to:t,value:l,gasPrice:s.XS(r,"gwei")}),u=await c.wait();return{hash:c.hash,from:c.from,to:c.to,value:s.ck(c.value),gasUsed:u.gasUsed.toString(),blockNumber:u.blockNumber,success:!0}}catch(a){return{success:!1,error:a.message}}}async getTransactionStatus(e){try{const t=await this.provider.getTransaction(e),n=await this.provider.getTransactionReceipt(e);return{transaction:t,receipt:n,status:n?1===n.status?"success":"failed":"pending",success:!0}}catch(t){return{success:!1,error:"\uac70\ub798 \uc0c1\ud0dc \uc870\ud68c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4."}}}switchNetwork(e){if(!u.Of[e])throw new Error("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ub124\ud2b8\uc6cc\ud06c\uc785\ub2c8\ub2e4.");this.network=e,this.provider=new a.FR(u.Of[e].rpcUrl),this.explorer=new m(e)}getCurrentNetwork(){return u.Of[this.network]}async testConnection(){try{return{connected:!0,blockNumber:await this.provider.getBlockNumber(),network:this.getCurrentNetwork(),success:!0}}catch(e){return{connected:!1,success:!1,error:"\ub124\ud2b8\uc6cc\ud06c \uc5f0\uacb0\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4."}}}async getDemoTransactions(e,t){const n=Math.floor(Date.now()/1e3),r=3600;return{success:!0,transactions:[{hash:"0x1234567890abcdef1234567890abcdef1234567890abcdef1234567890abcdef",from:"0x742d35Cc6634C0532925a3b8D0Ea4c07146896F4",to:e,value:"10.5",blockNumber:12345,timestamp:n-r,gasUsed:"21000",gasPrice:"20000000000",status:"success",type:"transaction"},{hash:"0xabcdef1234567890abcdef1234567890abcdef1234567890abcdef1234567890",from:e,to:"0x8ba1f109551bD432803012645Hac136c12345678",value:"100.0000",token:{address:"0x1234567890123456789012345678901234567890",name:"WorldLand USD",symbol:"WUSD",decimals:6},blockNumber:12340,timestamp:n-7200,gasUsed:"65000",gasPrice:"20000000000",status:"success",type:"token_transfer"},{hash:"0x9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba",from:"0x1234567890123456789012345678901234567890",to:e,value:"2.8",blockNumber:12335,timestamp:n-10800,gasUsed:"21000",gasPrice:"18000000000",status:"success",type:"transaction"}].slice(0,t),isDemo:!0,source:"demo"}}async discoverAccountsFromMnemonic(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:10;try{(0,d.UJ)("\ud83d\udd0d \ub2c8\ubaa8\ub2c9\uc5d0\uc11c \uacc4\uc815 \ubc1c\uacac \uc2dc\uc791...",{maxAccounts:t});const r=[];let s=0;const a=3;for(let o=0;o<t;o++)try{const t="m/44'/60'/0'/0/".concat(o),n=c.QX.fromPhrase(e,void 0,t);(0,d.UJ)("\ud83d\udccd \uacc4\uc815 ".concat(o," \ud655\uc778 \uc911: ").concat(n.address));const i=await this.checkAccountActivity(n.address),l={index:o,address:n.address,privateKey:n.privateKey,derivationPath:t,hasActivity:i.hasActivity,balance:i.balance,transactionCount:i.transactionCount};if(r.push(l),i.hasActivity)s=0,(0,d.UJ)("\ud83d\udcb0 \uacc4\uc815 ".concat(o,": \ud65c\ub3d9 \ubc1c\uacac (\uc794\uc561: ").concat(i.balance,")"));else if(s++,(0,d.UJ)("\u26aa \uacc4\uc815 ".concat(o,": \ud65c\ub3d9 \uc5c6\uc74c (\uc5f0\uc18d ").concat(s,"\uac1c)")),s>=a){(0,d.UJ)("\ud83d\uded1 \uc5f0\uc18d \ube44\uc5b4\uc788\ub294 \uacc4\uc815 ".concat(a,"\uac1c \ubc1c\uacac, \uac80\uc0c9 \uc911\ub2e8"));break}}catch(n){(0,d._N)("\u26a0\ufe0f \uacc4\uc815 ".concat(o," \ud655\uc778 \uc2e4\ud328:"),n);break}const i=r.filter(e=>e.hasActivity);return(0,d.UJ)("\u2705 \uacc4\uc815 \ubc1c\uacac \uc644\ub8cc: \ucd1d ".concat(r.length,"\uac1c \ud655\uc778, ").concat(i.length,"\uac1c \ud65c\uc131")),{success:!0,accounts:r,activeAccounts:i,totalChecked:r.length}}catch(n){return(0,d.sd)("\u274c \uacc4\uc815 \ubc1c\uacac \uc2e4\ud328:",n),{success:!1,error:"\uacc4\uc815 \ubc1c\uacac\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: "+n.message}}}async checkAccountActivity(e){try{(0,d.UJ)("\ud83d\udd0d ".concat(e," \ud65c\ub3d9 \ud655\uc778 \uc911..."));const s=await this.getBalance(e),a=s.success?parseFloat(s.balance):0;let i=0;try{var t;const n=await this.explorer.getAccountTransactions(e,{offset:1});i=n.success&&(null===(t=n.transactions)||void 0===t?void 0:t.length)||0}catch(r){(0,d._N)("\uac70\ub798\ub0b4\uc5ed \ud655\uc778 \uc2e4\ud328:",r)}let o=!1;try{var n;const t=await this.explorer.getAccountTokenBalances(e);o=t.success&&((null===(n=t.tokens)||void 0===n?void 0:n.length)||0)>0}catch(r){(0,d._N)("\ud1a0\ud070 \ud655\uc778 \uc2e4\ud328:",r)}const l=a>0||i>0||o;return(0,d.UJ)("\ud83d\udcca ".concat(e,": \uc794\uc561 ").concat(a,", \uac70\ub798 ").concat(i,"\uac1c, \ud1a0\ud070 ").concat(o?"O":"X",", \ud65c\ub3d9 ").concat(l?"O":"X")),{hasActivity:l,balance:a.toString(),transactionCount:i,hasTokens:o}}catch(r){return(0,d.sd)("\uacc4\uc815 \ud65c\ub3d9 \ud655\uc778 \uc2e4\ud328:",r),{hasActivity:!1,balance:"0",transactionCount:0,hasTokens:!1}}}importFromMnemonic(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;try{const n="m/44'/60'/0'/0/".concat(t),r=c.QX.fromPhrase(e,void 0,n);return{address:r.address,privateKey:r.privateKey,mnemonic:e,derivationPath:n,accountIndex:t,success:!0}}catch(n){return{success:!1,error:"\uc798\ubabb\ub41c \ub2c8\ubaa8\ub2c9 \uad6c\ubb38\uc785\ub2c8\ub2e4."}}}async sendNFT(e,t,n,r,a){let o=arguments.length>5&&void 0!==arguments[5]?arguments[5]:"20";try{if(!this.isValidAddress(a))throw new Error("\uc798\ubabb\ub41c \ubc1b\ub294 \uc8fc\uc18c\uc785\ub2c8\ub2e4.");if(!this.isValidAddress(t))throw new Error("\uc798\ubabb\ub41c NFT \ucee8\ud2b8\ub799\ud2b8 \uc8fc\uc18c\uc785\ub2c8\ub2e4.");const c=new i.u(e,this.provider),u=new l.NZ(t,f,c);if((await u.ownerOf(n)).toLowerCase()!==r.toLowerCase())throw new Error("\uc774 NFT\uc758 \uc18c\uc720\uc790\uac00 \uc544\ub2d9\ub2c8\ub2e4.");(0,d.UJ)("NFT \uc804\uc1a1 \uc2dc\uc791: Token ID ".concat(n," \u2192 ").concat(a));const h=await u.safeTransferFrom(r,a,n,{gasPrice:s.XS(o,"gwei")});(0,d.UJ)("\ud2b8\ub79c\uc7ad\uc158 \uc804\uc1a1\ub428:",h.hash);const p=await h.wait();return(0,d.UJ)("NFT \uc804\uc1a1 \uc644\ub8cc:",p),{hash:h.hash,from:r,to:a,tokenId:n.toString(),contractAddress:t,gasUsed:p.gasUsed.toString(),blockNumber:p.blockNumber,success:!0}}catch(c){return(0,d.sd)("NFT \uc804\uc1a1 \uc2e4\ud328:",c),{success:!1,error:c.message}}}async estimateNFTTransferFee(e,t,n,r,a){try{const i=new l.NZ(e,f,this.provider),o=await i.safeTransferFrom.estimateGas(n,r,t),c=o*s.XS(a,"gwei");return{gasLimit:o.toString(),fee:s.ck(c),success:!0}}catch(i){return{success:!1,error:"NFT \uc804\uc1a1 \uc218\uc218\ub8cc \ucd94\uc815\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4."}}}}},899(e,t,n){"use strict";n.d(t,{UJ:()=>s,_N:()=>i,sd:()=>a});const r=!1,s=function(){r},a=function(){},i=function(){}},4801(e,t,n){!function(){var t;e.exports=(t=n(1551),n(6596),n(2454),n(1964),n(283),function(){var e=t,n=e.lib.BlockCipher,r=e.algo,s=[],a=[],i=[],o=[],l=[],c=[],u=[],d=[],h=[],f=[];!function(){for(var e=[],t=0;t<256;t++)e[t]=t<128?t<<1:t<<1^283;var n=0,r=0;for(t=0;t<256;t++){var p=r^r<<1^r<<2^r<<3^r<<4;p=p>>>8^255&p^99,s[n]=p,a[p]=n;var m=e[n],g=e[m],y=e[g],w=257*e[p]^16843008*p;i[n]=w<<24|w>>>8,o[n]=w<<16|w>>>16,l[n]=w<<8|w>>>24,c[n]=w,w=16843009*y^65537*g^257*m^16843008*n,u[p]=w<<24|w>>>8,d[p]=w<<16|w>>>16,h[p]=w<<8|w>>>24,f[p]=w,n?(n=m^e[e[e[y^m]]],r^=e[e[r]]):n=r=1}}();var p=[0,1,2,4,8,16,32,64,128,27,54],m=r.AES=n.extend({_doReset:function(){if(!this._nRounds||this._keyPriorReset!==this._key){for(var e=this._keyPriorReset=this._key,t=e.words,n=e.sigBytes/4,r=4*((this._nRounds=n+6)+1),a=this._keySchedule=[],i=0;i<r;i++)i<n?a[i]=t[i]:(c=a[i-1],i%n?n>6&&i%n==4&&(c=s[c>>>24]<<24|s[c>>>16&255]<<16|s[c>>>8&255]<<8|s[255&c]):(c=s[(c=c<<8|c>>>24)>>>24]<<24|s[c>>>16&255]<<16|s[c>>>8&255]<<8|s[255&c],c^=p[i/n|0]<<24),a[i]=a[i-n]^c);for(var o=this._invKeySchedule=[],l=0;l<r;l++){if(i=r-l,l%4)var c=a[i];else c=a[i-4];o[l]=l<4||i<=4?c:u[s[c>>>24]]^d[s[c>>>16&255]]^h[s[c>>>8&255]]^f[s[255&c]]}}},encryptBlock:function(e,t){this._doCryptBlock(e,t,this._keySchedule,i,o,l,c,s)},decryptBlock:function(e,t){var n=e[t+1];e[t+1]=e[t+3],e[t+3]=n,this._doCryptBlock(e,t,this._invKeySchedule,u,d,h,f,a),n=e[t+1],e[t+1]=e[t+3],e[t+3]=n},_doCryptBlock:function(e,t,n,r,s,a,i,o){for(var l=this._nRounds,c=e[t]^n[0],u=e[t+1]^n[1],d=e[t+2]^n[2],h=e[t+3]^n[3],f=4,p=1;p<l;p++){var m=r[c>>>24]^s[u>>>16&255]^a[d>>>8&255]^i[255&h]^n[f++],g=r[u>>>24]^s[d>>>16&255]^a[h>>>8&255]^i[255&c]^n[f++],y=r[d>>>24]^s[h>>>16&255]^a[c>>>8&255]^i[255&u]^n[f++],w=r[h>>>24]^s[c>>>16&255]^a[u>>>8&255]^i[255&d]^n[f++];c=m,u=g,d=y,h=w}m=(o[c>>>24]<<24|o[u>>>16&255]<<16|o[d>>>8&255]<<8|o[255&h])^n[f++],g=(o[u>>>24]<<24|o[d>>>16&255]<<16|o[h>>>8&255]<<8|o[255&c])^n[f++],y=(o[d>>>24]<<24|o[h>>>16&255]<<16|o[c>>>8&255]<<8|o[255&u])^n[f++],w=(o[h>>>24]<<24|o[c>>>16&255]<<16|o[u>>>8&255]<<8|o[255&d])^n[f++],e[t]=m,e[t+1]=g,e[t+2]=y,e[t+3]=w},keySize:8});e.AES=n._createHelper(m)}(),t.AES)}()},5714(e,t,n){!function(){var t;e.exports=(t=n(1551),n(6596),n(2454),n(1964),n(283),function(){var e=t,n=e.lib.BlockCipher,r=e.algo;const s=16,a=[608135816,2242054355,320440878,57701188,2752067618,698298832,137296536,3964562569,1160258022,953160567,3193202383,887688300,3232508343,3380367581,1065670069,3041331479,2450970073,2306472731],i=[[3509652390,2564797868,805139163,3491422135,3101798381,1780907670,3128725573,4046225305,614570311,3012652279,134345442,2240740374,1667834072,1901547113,2757295779,4103290238,227898511,1921955416,1904987480,2182433518,2069144605,3260701109,2620446009,720527379,3318853667,677414384,3393288472,3101374703,2390351024,1614419982,1822297739,2954791486,3608508353,3174124327,2024746970,1432378464,3864339955,2857741204,1464375394,1676153920,1439316330,715854006,3033291828,289532110,2706671279,2087905683,3018724369,1668267050,732546397,1947742710,3462151702,2609353502,2950085171,1814351708,2050118529,680887927,999245976,1800124847,3300911131,1713906067,1641548236,4213287313,1216130144,1575780402,4018429277,3917837745,3693486850,3949271944,596196993,3549867205,258830323,2213823033,772490370,2760122372,1774776394,2652871518,566650946,4142492826,1728879713,2882767088,1783734482,3629395816,2517608232,2874225571,1861159788,326777828,3124490320,2130389656,2716951837,967770486,1724537150,2185432712,2364442137,1164943284,2105845187,998989502,3765401048,2244026483,1075463327,1455516326,1322494562,910128902,469688178,1117454909,936433444,3490320968,3675253459,1240580251,122909385,2157517691,634681816,4142456567,3825094682,3061402683,2540495037,79693498,3249098678,1084186820,1583128258,426386531,1761308591,1047286709,322548459,995290223,1845252383,2603652396,3431023940,2942221577,3202600964,3727903485,1712269319,422464435,3234572375,1170764815,3523960633,3117677531,1434042557,442511882,3600875718,1076654713,1738483198,4213154764,2393238008,3677496056,1014306527,4251020053,793779912,2902807211,842905082,4246964064,1395751752,1040244610,2656851899,3396308128,445077038,3742853595,3577915638,679411651,2892444358,2354009459,1767581616,3150600392,3791627101,3102740896,284835224,4246832056,1258075500,768725851,2589189241,3069724005,3532540348,1274779536,3789419226,2764799539,1660621633,3471099624,4011903706,913787905,3497959166,737222580,2514213453,2928710040,3937242737,1804850592,3499020752,2949064160,2386320175,2390070455,2415321851,4061277028,2290661394,2416832540,1336762016,1754252060,3520065937,3014181293,791618072,3188594551,3933548030,2332172193,3852520463,3043980520,413987798,3465142937,3030929376,4245938359,2093235073,3534596313,375366246,2157278981,2479649556,555357303,3870105701,2008414854,3344188149,4221384143,3956125452,2067696032,3594591187,2921233993,2428461,544322398,577241275,1471733935,610547355,4027169054,1432588573,1507829418,2025931657,3646575487,545086370,48609733,2200306550,1653985193,298326376,1316178497,3007786442,2064951626,458293330,2589141269,3591329599,3164325604,727753846,2179363840,146436021,1461446943,4069977195,705550613,3059967265,3887724982,4281599278,3313849956,1404054877,2845806497,146425753,1854211946],[1266315497,3048417604,3681880366,3289982499,290971e4,1235738493,2632868024,2414719590,3970600049,1771706367,1449415276,3266420449,422970021,1963543593,2690192192,3826793022,1062508698,1531092325,1804592342,2583117782,2714934279,4024971509,1294809318,4028980673,1289560198,2221992742,1669523910,35572830,157838143,1052438473,1016535060,1802137761,1753167236,1386275462,3080475397,2857371447,1040679964,2145300060,2390574316,1461121720,2956646967,4031777805,4028374788,33600511,2920084762,1018524850,629373528,3691585981,3515945977,2091462646,2486323059,586499841,988145025,935516892,3367335476,2599673255,2839830854,265290510,3972581182,2759138881,3795373465,1005194799,847297441,406762289,1314163512,1332590856,1866599683,4127851711,750260880,613907577,1450815602,3165620655,3734664991,3650291728,3012275730,3704569646,1427272223,778793252,1343938022,2676280711,2052605720,1946737175,3164576444,3914038668,3967478842,3682934266,1661551462,3294938066,4011595847,840292616,3712170807,616741398,312560963,711312465,1351876610,322626781,1910503582,271666773,2175563734,1594956187,70604529,3617834859,1007753275,1495573769,4069517037,2549218298,2663038764,504708206,2263041392,3941167025,2249088522,1514023603,1998579484,1312622330,694541497,2582060303,2151582166,1382467621,776784248,2618340202,3323268794,2497899128,2784771155,503983604,4076293799,907881277,423175695,432175456,1378068232,4145222326,3954048622,3938656102,3820766613,2793130115,2977904593,26017576,3274890735,3194772133,1700274565,1756076034,4006520079,3677328699,720338349,1533947780,354530856,688349552,3973924725,1637815568,332179504,3949051286,53804574,2852348879,3044236432,1282449977,3583942155,3416972820,4006381244,1617046695,2628476075,3002303598,1686838959,431878346,2686675385,1700445008,1080580658,1009431731,832498133,3223435511,2605976345,2271191193,2516031870,1648197032,4164389018,2548247927,300782431,375919233,238389289,3353747414,2531188641,2019080857,1475708069,455242339,2609103871,448939670,3451063019,1395535956,2413381860,1841049896,1491858159,885456874,4264095073,4001119347,1565136089,3898914787,1108368660,540939232,1173283510,2745871338,3681308437,4207628240,3343053890,4016749493,1699691293,1103962373,3625875870,2256883143,3830138730,1031889488,3479347698,1535977030,4236805024,3251091107,2132092099,1774941330,1199868427,1452454533,157007616,2904115357,342012276,595725824,1480756522,206960106,497939518,591360097,863170706,2375253569,3596610801,1814182875,2094937945,3421402208,1082520231,3463918190,2785509508,435703966,3908032597,1641649973,2842273706,3305899714,1510255612,2148256476,2655287854,3276092548,4258621189,236887753,3681803219,274041037,1734335097,3815195456,3317970021,1899903192,1026095262,4050517792,356393447,2410691914,3873677099,3682840055],[3913112168,2491498743,4132185628,2489919796,1091903735,1979897079,3170134830,3567386728,3557303409,857797738,1136121015,1342202287,507115054,2535736646,337727348,3213592640,1301675037,2528481711,1895095763,1721773893,3216771564,62756741,2142006736,835421444,2531993523,1442658625,3659876326,2882144922,676362277,1392781812,170690266,3921047035,1759253602,3611846912,1745797284,664899054,1329594018,3901205900,3045908486,2062866102,2865634940,3543621612,3464012697,1080764994,553557557,3656615353,3996768171,991055499,499776247,1265440854,648242737,3940784050,980351604,3713745714,1749149687,3396870395,4211799374,3640570775,1161844396,3125318951,1431517754,545492359,4268468663,3499529547,1437099964,2702547544,3433638243,2581715763,2787789398,1060185593,1593081372,2418618748,4260947970,69676912,2159744348,86519011,2512459080,3838209314,1220612927,3339683548,133810670,1090789135,1078426020,1569222167,845107691,3583754449,4072456591,1091646820,628848692,1613405280,3757631651,526609435,236106946,48312990,2942717905,3402727701,1797494240,859738849,992217954,4005476642,2243076622,3870952857,3732016268,765654824,3490871365,2511836413,1685915746,3888969200,1414112111,2273134842,3281911079,4080962846,172450625,2569994100,980381355,4109958455,2819808352,2716589560,2568741196,3681446669,3329971472,1835478071,660984891,3704678404,4045999559,3422617507,3040415634,1762651403,1719377915,3470491036,2693910283,3642056355,3138596744,1364962596,2073328063,1983633131,926494387,3423689081,2150032023,4096667949,1749200295,3328846651,309677260,2016342300,1779581495,3079819751,111262694,1274766160,443224088,298511866,1025883608,3806446537,1145181785,168956806,3641502830,3584813610,1689216846,3666258015,3200248200,1692713982,2646376535,4042768518,1618508792,1610833997,3523052358,4130873264,2001055236,3610705100,2202168115,4028541809,2961195399,1006657119,2006996926,3186142756,1430667929,3210227297,1314452623,4074634658,4101304120,2273951170,1399257539,3367210612,3027628629,1190975929,2062231137,2333990788,2221543033,2438960610,1181637006,548689776,2362791313,3372408396,3104550113,3145860560,296247880,1970579870,3078560182,3769228297,1714227617,3291629107,3898220290,166772364,1251581989,493813264,448347421,195405023,2709975567,677966185,3703036547,1463355134,2715995803,1338867538,1343315457,2802222074,2684532164,233230375,2599980071,2000651841,3277868038,1638401717,4028070440,3237316320,6314154,819756386,300326615,590932579,1405279636,3267499572,3150704214,2428286686,3959192993,3461946742,1862657033,1266418056,963775037,2089974820,2263052895,1917689273,448879540,3550394620,3981727096,150775221,3627908307,1303187396,508620638,2975983352,2726630617,1817252668,1876281319,1457606340,908771278,3720792119,3617206836,2455994898,1729034894,1080033504],[976866871,3556439503,2881648439,1522871579,1555064734,1336096578,3548522304,2579274686,3574697629,3205460757,3593280638,3338716283,3079412587,564236357,2993598910,1781952180,1464380207,3163844217,3332601554,1699332808,1393555694,1183702653,3581086237,1288719814,691649499,2847557200,2895455976,3193889540,2717570544,1781354906,1676643554,2592534050,3230253752,1126444790,2770207658,2633158820,2210423226,2615765581,2414155088,3127139286,673620729,2805611233,1269405062,4015350505,3341807571,4149409754,1057255273,2012875353,2162469141,2276492801,2601117357,993977747,3918593370,2654263191,753973209,36408145,2530585658,25011837,3520020182,2088578344,530523599,2918365339,1524020338,1518925132,3760827505,3759777254,1202760957,3985898139,3906192525,674977740,4174734889,2031300136,2019492241,3983892565,4153806404,3822280332,352677332,2297720250,60907813,90501309,3286998549,1016092578,2535922412,2839152426,457141659,509813237,4120667899,652014361,1966332200,2975202805,55981186,2327461051,676427537,3255491064,2882294119,3433927263,1307055953,942726286,933058658,2468411793,3933900994,4215176142,1361170020,2001714738,2830558078,3274259782,1222529897,1679025792,2729314320,3714953764,1770335741,151462246,3013232138,1682292957,1483529935,471910574,1539241949,458788160,3436315007,1807016891,3718408830,978976581,1043663428,3165965781,1927990952,4200891579,2372276910,3208408903,3533431907,1412390302,2931980059,4132332400,1947078029,3881505623,4168226417,2941484381,1077988104,1320477388,886195818,18198404,3786409e3,2509781533,112762804,3463356488,1866414978,891333506,18488651,661792760,1628790961,3885187036,3141171499,876946877,2693282273,1372485963,791857591,2686433993,3759982718,3167212022,3472953795,2716379847,445679433,3561995674,3504004811,3574258232,54117162,3331405415,2381918588,3769707343,4154350007,1140177722,4074052095,668550556,3214352940,367459370,261225585,2610173221,4209349473,3468074219,3265815641,314222801,3066103646,3808782860,282218597,3406013506,3773591054,379116347,1285071038,846784868,2669647154,3771962079,3550491691,2305946142,453669953,1268987020,3317592352,3279303384,3744833421,2610507566,3859509063,266596637,3847019092,517658769,3462560207,3443424879,370717030,4247526661,2224018117,4143653529,4112773975,2788324899,2477274417,1456262402,2901442914,1517677493,1846949527,2295493580,3734397586,2176403920,1280348187,1908823572,3871786941,846861322,1172426758,3287448474,3383383037,1655181056,3139813346,901632758,1897031941,2986607138,3066810236,3447102507,1393639104,373351379,950779232,625454576,3124240540,4148612726,2007998917,544563296,2244738638,2330496472,2058025392,1291430526,424198748,50039436,29584100,3605783033,2429876329,2791104160,1057563949,3255363231,3075367218,3463963227,1469046755,985887462]];var o={pbox:[],sbox:[]};function l(e,t){let n=t>>24&255,r=t>>16&255,s=t>>8&255,a=255&t,i=e.sbox[0][n]+e.sbox[1][r];return i^=e.sbox[2][s],i+=e.sbox[3][a],i}function c(e,t,n){let r,a=t,i=n;for(let o=0;o<s;++o)a^=e.pbox[o],i=l(e,a)^i,r=a,a=i,i=r;return r=a,a=i,i=r,i^=e.pbox[s],a^=e.pbox[s+1],{left:a,right:i}}function u(e,t,n){let r,a=t,i=n;for(let o=s+1;o>1;--o)a^=e.pbox[o],i=l(e,a)^i,r=a,a=i,i=r;return r=a,a=i,i=r,i^=e.pbox[1],a^=e.pbox[0],{left:a,right:i}}function d(e,t,n){for(let s=0;s<4;s++){e.sbox[s]=[];for(let t=0;t<256;t++)e.sbox[s][t]=i[s][t]}let r=0;for(let i=0;i<s+2;i++)e.pbox[i]=a[i]^t[r],r++,r>=n&&(r=0);let o=0,l=0,u=0;for(let a=0;a<s+2;a+=2)u=c(e,o,l),o=u.left,l=u.right,e.pbox[a]=o,e.pbox[a+1]=l;for(let s=0;s<4;s++)for(let t=0;t<256;t+=2)u=c(e,o,l),o=u.left,l=u.right,e.sbox[s][t]=o,e.sbox[s][t+1]=l;return!0}var h=r.Blowfish=n.extend({_doReset:function(){if(this._keyPriorReset!==this._key){var e=this._keyPriorReset=this._key,t=e.words,n=e.sigBytes/4;d(o,t,n)}},encryptBlock:function(e,t){var n=c(o,e[t],e[t+1]);e[t]=n.left,e[t+1]=n.right},decryptBlock:function(e,t){var n=u(o,e[t],e[t+1]);e[t]=n.left,e[t+1]=n.right},blockSize:2,keySize:4,ivSize:2});e.Blowfish=n._createHelper(h)}(),t.Blowfish)}()},283(e,t,n){!function(){var t;e.exports=(t=n(1551),n(1964),void(t.lib.Cipher||function(e){var n=t,r=n.lib,s=r.Base,a=r.WordArray,i=r.BufferedBlockAlgorithm,o=n.enc,l=(o.Utf8,o.Base64),c=n.algo.EvpKDF,u=r.Cipher=i.extend({cfg:s.extend(),createEncryptor:function(e,t){return this.create(this._ENC_XFORM_MODE,e,t)},createDecryptor:function(e,t){return this.create(this._DEC_XFORM_MODE,e,t)},init:function(e,t,n){this.cfg=this.cfg.extend(n),this._xformMode=e,this._key=t,this.reset()},reset:function(){i.reset.call(this),this._doReset()},process:function(e){return this._append(e),this._process()},finalize:function(e){return e&&this._append(e),this._doFinalize()},keySize:4,ivSize:4,_ENC_XFORM_MODE:1,_DEC_XFORM_MODE:2,_createHelper:function(){function e(e){return"string"==typeof e?v:y}return function(t){return{encrypt:function(n,r,s){return e(r).encrypt(t,n,r,s)},decrypt:function(n,r,s){return e(r).decrypt(t,n,r,s)}}}}()}),d=(r.StreamCipher=u.extend({_doFinalize:function(){return this._process(!0)},blockSize:1}),n.mode={}),h=r.BlockCipherMode=s.extend({createEncryptor:function(e,t){return this.Encryptor.create(e,t)},createDecryptor:function(e,t){return this.Decryptor.create(e,t)},init:function(e,t){this._cipher=e,this._iv=t}}),f=d.CBC=function(){var t=h.extend();function n(t,n,r){var s,a=this._iv;a?(s=a,this._iv=e):s=this._prevBlock;for(var i=0;i<r;i++)t[n+i]^=s[i]}return t.Encryptor=t.extend({processBlock:function(e,t){var r=this._cipher,s=r.blockSize;n.call(this,e,t,s),r.encryptBlock(e,t),this._prevBlock=e.slice(t,t+s)}}),t.Decryptor=t.extend({processBlock:function(e,t){var r=this._cipher,s=r.blockSize,a=e.slice(t,t+s);r.decryptBlock(e,t),n.call(this,e,t,s),this._prevBlock=a}}),t}(),p=(n.pad={}).Pkcs7={pad:function(e,t){for(var n=4*t,r=n-e.sigBytes%n,s=r<<24|r<<16|r<<8|r,i=[],o=0;o<r;o+=4)i.push(s);var l=a.create(i,r);e.concat(l)},unpad:function(e){var t=255&e.words[e.sigBytes-1>>>2];e.sigBytes-=t}},m=(r.BlockCipher=u.extend({cfg:u.cfg.extend({mode:f,padding:p}),reset:function(){var e;u.reset.call(this);var t=this.cfg,n=t.iv,r=t.mode;this._xformMode==this._ENC_XFORM_MODE?e=r.createEncryptor:(e=r.createDecryptor,this._minBufferSize=1),this._mode&&this._mode.__creator==e?this._mode.init(this,n&&n.words):(this._mode=e.call(r,this,n&&n.words),this._mode.__creator=e)},_doProcessBlock:function(e,t){this._mode.processBlock(e,t)},_doFinalize:function(){var e,t=this.cfg.padding;return this._xformMode==this._ENC_XFORM_MODE?(t.pad(this._data,this.blockSize),e=this._process(!0)):(e=this._process(!0),t.unpad(e)),e},blockSize:4}),r.CipherParams=s.extend({init:function(e){this.mixIn(e)},toString:function(e){return(e||this.formatter).stringify(this)}})),g=(n.format={}).OpenSSL={stringify:function(e){var t=e.ciphertext,n=e.salt;return(n?a.create([1398893684,1701076831]).concat(n).concat(t):t).toString(l)},parse:function(e){var t,n=l.parse(e),r=n.words;return 1398893684==r[0]&&1701076831==r[1]&&(t=a.create(r.slice(2,4)),r.splice(0,4),n.sigBytes-=16),m.create({ciphertext:n,salt:t})}},y=r.SerializableCipher=s.extend({cfg:s.extend({format:g}),encrypt:function(e,t,n,r){r=this.cfg.extend(r);var s=e.createEncryptor(n,r),a=s.finalize(t),i=s.cfg;return m.create({ciphertext:a,key:n,iv:i.iv,algorithm:e,mode:i.mode,padding:i.padding,blockSize:e.blockSize,formatter:r.format})},decrypt:function(e,t,n,r){return r=this.cfg.extend(r),t=this._parse(t,r.format),e.createDecryptor(n,r).finalize(t.ciphertext)},_parse:function(e,t){return"string"==typeof e?t.parse(e,this):e}}),w=(n.kdf={}).OpenSSL={execute:function(e,t,n,r,s){if(r||(r=a.random(8)),s)i=c.create({keySize:t+n,hasher:s}).compute(e,r);else var i=c.create({keySize:t+n}).compute(e,r);var o=a.create(i.words.slice(t),4*n);return i.sigBytes=4*t,m.create({key:i,iv:o,salt:r})}},v=r.PasswordBasedCipher=y.extend({cfg:y.cfg.extend({kdf:w}),encrypt:function(e,t,n,r){var s=(r=this.cfg.extend(r)).kdf.execute(n,e.keySize,e.ivSize,r.salt,r.hasher);r.iv=s.iv;var a=y.encrypt.call(this,e,t,s.key,r);return a.mixIn(s),a},decrypt:function(e,t,n,r){r=this.cfg.extend(r),t=this._parse(t,r.format);var s=r.kdf.execute(n,e.keySize,e.ivSize,t.salt,r.hasher);return r.iv=s.iv,y.decrypt.call(this,e,t,s.key,r)}})}()))}()},1551(e,t,n){e.exports=function(){var e=e||function(e,t){var r;if("undefined"!==typeof window&&window.crypto&&(r=window.crypto),"undefined"!==typeof self&&self.crypto&&(r=self.crypto),"undefined"!==typeof globalThis&&globalThis.crypto&&(r=globalThis.crypto),!r&&"undefined"!==typeof window&&window.msCrypto&&(r=window.msCrypto),!r&&"undefined"!==typeof n.g&&n.g.crypto&&(r=n.g.crypto),!r)try{r=n(477)}catch(g){}var s=function(){if(r){if("function"===typeof r.getRandomValues)try{return r.getRandomValues(new Uint32Array(1))[0]}catch(g){}if("function"===typeof r.randomBytes)try{return r.randomBytes(4).readInt32LE()}catch(g){}}throw new Error("Native crypto module could not be used to get secure random number.")},a=Object.create||function(){function e(){}return function(t){var n;return e.prototype=t,n=new e,e.prototype=null,n}}(),i={},o=i.lib={},l=o.Base={extend:function(e){var t=a(this);return e&&t.mixIn(e),t.hasOwnProperty("init")&&this.init!==t.init||(t.init=function(){t.$super.init.apply(this,arguments)}),t.init.prototype=t,t.$super=this,t},create:function(){var e=this.extend();return e.init.apply(e,arguments),e},init:function(){},mixIn:function(e){for(var t in e)e.hasOwnProperty(t)&&(this[t]=e[t]);e.hasOwnProperty("toString")&&(this.toString=e.toString)},clone:function(){return this.init.prototype.extend(this)}},c=o.WordArray=l.extend({init:function(e,n){e=this.words=e||[],this.sigBytes=n!=t?n:4*e.length},toString:function(e){return(e||d).stringify(this)},concat:function(e){var t=this.words,n=e.words,r=this.sigBytes,s=e.sigBytes;if(this.clamp(),r%4)for(var a=0;a<s;a++){var i=n[a>>>2]>>>24-a%4*8&255;t[r+a>>>2]|=i<<24-(r+a)%4*8}else for(var o=0;o<s;o+=4)t[r+o>>>2]=n[o>>>2];return this.sigBytes+=s,this},clamp:function(){var t=this.words,n=this.sigBytes;t[n>>>2]&=4294967295<<32-n%4*8,t.length=e.ceil(n/4)},clone:function(){var e=l.clone.call(this);return e.words=this.words.slice(0),e},random:function(e){for(var t=[],n=0;n<e;n+=4)t.push(s());return new c.init(t,e)}}),u=i.enc={},d=u.Hex={stringify:function(e){for(var t=e.words,n=e.sigBytes,r=[],s=0;s<n;s++){var a=t[s>>>2]>>>24-s%4*8&255;r.push((a>>>4).toString(16)),r.push((15&a).toString(16))}return r.join("")},parse:function(e){for(var t=e.length,n=[],r=0;r<t;r+=2)n[r>>>3]|=parseInt(e.substr(r,2),16)<<24-r%8*4;return new c.init(n,t/2)}},h=u.Latin1={stringify:function(e){for(var t=e.words,n=e.sigBytes,r=[],s=0;s<n;s++){var a=t[s>>>2]>>>24-s%4*8&255;r.push(String.fromCharCode(a))}return r.join("")},parse:function(e){for(var t=e.length,n=[],r=0;r<t;r++)n[r>>>2]|=(255&e.charCodeAt(r))<<24-r%4*8;return new c.init(n,t)}},f=u.Utf8={stringify:function(e){try{return decodeURIComponent(escape(h.stringify(e)))}catch(t){throw new Error("Malformed UTF-8 data")}},parse:function(e){return h.parse(unescape(encodeURIComponent(e)))}},p=o.BufferedBlockAlgorithm=l.extend({reset:function(){this._data=new c.init,this._nDataBytes=0},_append:function(e){"string"==typeof e&&(e=f.parse(e)),this._data.concat(e),this._nDataBytes+=e.sigBytes},_process:function(t){var n,r=this._data,s=r.words,a=r.sigBytes,i=this.blockSize,o=a/(4*i),l=(o=t?e.ceil(o):e.max((0|o)-this._minBufferSize,0))*i,u=e.min(4*l,a);if(l){for(var d=0;d<l;d+=i)this._doProcessBlock(s,d);n=s.splice(0,l),r.sigBytes-=u}return new c.init(n,u)},clone:function(){var e=l.clone.call(this);return e._data=this._data.clone(),e},_minBufferSize:0}),m=(o.Hasher=p.extend({cfg:l.extend(),init:function(e){this.cfg=this.cfg.extend(e),this.reset()},reset:function(){p.reset.call(this),this._doReset()},update:function(e){return this._append(e),this._process(),this},finalize:function(e){return e&&this._append(e),this._doFinalize()},blockSize:16,_createHelper:function(e){return function(t,n){return new e.init(n).finalize(t)}},_createHmacHelper:function(e){return function(t,n){return new m.HMAC.init(e,n).finalize(t)}}}),i.algo={});return i}(Math);return e}()},6596(e,t,n){!function(){var t;e.exports=(t=n(1551),function(){var e=t,n=e.lib.WordArray;function r(e,t,r){for(var s=[],a=0,i=0;i<t;i++)if(i%4){var o=r[e.charCodeAt(i-1)]<<i%4*2|r[e.charCodeAt(i)]>>>6-i%4*2;s[a>>>2]|=o<<24-a%4*8,a++}return n.create(s,a)}e.enc.Base64={stringify:function(e){var t=e.words,n=e.sigBytes,r=this._map;e.clamp();for(var s=[],a=0;a<n;a+=3)for(var i=(t[a>>>2]>>>24-a%4*8&255)<<16|(t[a+1>>>2]>>>24-(a+1)%4*8&255)<<8|t[a+2>>>2]>>>24-(a+2)%4*8&255,o=0;o<4&&a+.75*o<n;o++)s.push(r.charAt(i>>>6*(3-o)&63));var l=r.charAt(64);if(l)for(;s.length%4;)s.push(l);return s.join("")},parse:function(e){var t=e.length,n=this._map,s=this._reverseMap;if(!s){s=this._reverseMap=[];for(var a=0;a<n.length;a++)s[n.charCodeAt(a)]=a}var i=n.charAt(64);if(i){var o=e.indexOf(i);-1!==o&&(t=o)}return r(e,t,s)},_map:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="}}(),t.enc.Base64)}()},9959(e,t,n){!function(){var t;e.exports=(t=n(1551),function(){var e=t,n=e.lib.WordArray;function r(e,t,r){for(var s=[],a=0,i=0;i<t;i++)if(i%4){var o=r[e.charCodeAt(i-1)]<<i%4*2|r[e.charCodeAt(i)]>>>6-i%4*2;s[a>>>2]|=o<<24-a%4*8,a++}return n.create(s,a)}e.enc.Base64url={stringify:function(e,t){void 0===t&&(t=!0);var n=e.words,r=e.sigBytes,s=t?this._safe_map:this._map;e.clamp();for(var a=[],i=0;i<r;i+=3)for(var o=(n[i>>>2]>>>24-i%4*8&255)<<16|(n[i+1>>>2]>>>24-(i+1)%4*8&255)<<8|n[i+2>>>2]>>>24-(i+2)%4*8&255,l=0;l<4&&i+.75*l<r;l++)a.push(s.charAt(o>>>6*(3-l)&63));var c=s.charAt(64);if(c)for(;a.length%4;)a.push(c);return a.join("")},parse:function(e,t){void 0===t&&(t=!0);var n=e.length,s=t?this._safe_map:this._map,a=this._reverseMap;if(!a){a=this._reverseMap=[];for(var i=0;i<s.length;i++)a[s.charCodeAt(i)]=i}var o=s.charAt(64);if(o){var l=e.indexOf(o);-1!==l&&(n=l)}return r(e,n,a)},_map:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",_safe_map:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"}}(),t.enc.Base64url)}()},3529(e,t,n){!function(){var t;e.exports=(t=n(1551),function(){var e=t,n=e.lib.WordArray,r=e.enc;function s(e){return e<<8&4278255360|e>>>8&16711935}r.Utf16=r.Utf16BE={stringify:function(e){for(var t=e.words,n=e.sigBytes,r=[],s=0;s<n;s+=2){var a=t[s>>>2]>>>16-s%4*8&65535;r.push(String.fromCharCode(a))}return r.join("")},parse:function(e){for(var t=e.length,r=[],s=0;s<t;s++)r[s>>>1]|=e.charCodeAt(s)<<16-s%2*16;return n.create(r,2*t)}},r.Utf16LE={stringify:function(e){for(var t=e.words,n=e.sigBytes,r=[],a=0;a<n;a+=2){var i=s(t[a>>>2]>>>16-a%4*8&65535);r.push(String.fromCharCode(i))}return r.join("")},parse:function(e){for(var t=e.length,r=[],a=0;a<t;a++)r[a>>>1]|=s(e.charCodeAt(a)<<16-a%2*16);return n.create(r,2*t)}}}(),t.enc.Utf16)}()},1964(e,t,n){!function(){var t;e.exports=(t=n(1551),n(3025),n(2699),function(){var e=t,n=e.lib,r=n.Base,s=n.WordArray,a=e.algo,i=a.MD5,o=a.EvpKDF=r.extend({cfg:r.extend({keySize:4,hasher:i,iterations:1}),init:function(e){this.cfg=this.cfg.extend(e)},compute:function(e,t){for(var n,r=this.cfg,a=r.hasher.create(),i=s.create(),o=i.words,l=r.keySize,c=r.iterations;o.length<l;){n&&a.update(n),n=a.update(e).finalize(t),a.reset();for(var u=1;u<c;u++)n=a.finalize(n),a.reset();i.concat(n)}return i.sigBytes=4*l,i}});e.EvpKDF=function(e,t,n){return o.create(n).compute(e,t)}}(),t.EvpKDF)}()},8587(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),function(){var e=t,n=e.lib.CipherParams,r=e.enc.Hex;e.format.Hex={stringify:function(e){return e.ciphertext.toString(r)},parse:function(e){var t=r.parse(e);return n.create({ciphertext:t})}}}(),t.format.Hex)}()},2699(e,t,n){!function(){var t;e.exports=(t=n(1551),void function(){var e=t,n=e.lib.Base,r=e.enc.Utf8;e.algo.HMAC=n.extend({init:function(e,t){e=this._hasher=new e.init,"string"==typeof t&&(t=r.parse(t));var n=e.blockSize,s=4*n;t.sigBytes>s&&(t=e.finalize(t)),t.clamp();for(var a=this._oKey=t.clone(),i=this._iKey=t.clone(),o=a.words,l=i.words,c=0;c<n;c++)o[c]^=1549556828,l[c]^=909522486;a.sigBytes=i.sigBytes=s,this.reset()},reset:function(){var e=this._hasher;e.reset(),e.update(this._iKey)},update:function(e){return this._hasher.update(e),this},finalize:function(e){var t=this._hasher,n=t.finalize(e);return t.reset(),t.finalize(this._oKey.clone().concat(n))}})}())}()},730(e,t,n){!function(){var t;e.exports=(t=n(1551),n(5790),n(6090),n(3529),n(6596),n(9959),n(2454),n(3025),n(4595),n(7278),n(9378),n(4275),n(5151),n(8562),n(2699),n(6193),n(1964),n(283),n(4599),n(933),n(4558),n(8179),n(4288),n(9775),n(5775),n(776),n(57),n(9446),n(8587),n(4801),n(4710),n(2827),n(4148),n(4614),n(5714),t)}()},6090(e,t,n){!function(){var t;e.exports=(t=n(1551),function(){if("function"==typeof ArrayBuffer){var e=t.lib.WordArray,n=e.init,r=e.init=function(e){if(e instanceof ArrayBuffer&&(e=new Uint8Array(e)),(e instanceof Int8Array||"undefined"!==typeof Uint8ClampedArray&&e instanceof Uint8ClampedArray||e instanceof Int16Array||e instanceof Uint16Array||e instanceof Int32Array||e instanceof Uint32Array||e instanceof Float32Array||e instanceof Float64Array)&&(e=new Uint8Array(e.buffer,e.byteOffset,e.byteLength)),e instanceof Uint8Array){for(var t=e.byteLength,r=[],s=0;s<t;s++)r[s>>>2]|=e[s]<<24-s%4*8;n.call(this,r,t)}else n.apply(this,arguments)};r.prototype=e}}(),t.lib.WordArray)}()},2454(e,t,n){!function(){var t;e.exports=(t=n(1551),function(e){var n=t,r=n.lib,s=r.WordArray,a=r.Hasher,i=n.algo,o=[];!function(){for(var t=0;t<64;t++)o[t]=4294967296*e.abs(e.sin(t+1))|0}();var l=i.MD5=a.extend({_doReset:function(){this._hash=new s.init([1732584193,4023233417,2562383102,271733878])},_doProcessBlock:function(e,t){for(var n=0;n<16;n++){var r=t+n,s=e[r];e[r]=16711935&(s<<8|s>>>24)|4278255360&(s<<24|s>>>8)}var a=this._hash.words,i=e[t+0],l=e[t+1],f=e[t+2],p=e[t+3],m=e[t+4],g=e[t+5],y=e[t+6],w=e[t+7],v=e[t+8],A=e[t+9],b=e[t+10],x=e[t+11],S=e[t+12],C=e[t+13],E=e[t+14],N=e[t+15],k=a[0],T=a[1],I=a[2],_=a[3];k=c(k,T,I,_,i,7,o[0]),_=c(_,k,T,I,l,12,o[1]),I=c(I,_,k,T,f,17,o[2]),T=c(T,I,_,k,p,22,o[3]),k=c(k,T,I,_,m,7,o[4]),_=c(_,k,T,I,g,12,o[5]),I=c(I,_,k,T,y,17,o[6]),T=c(T,I,_,k,w,22,o[7]),k=c(k,T,I,_,v,7,o[8]),_=c(_,k,T,I,A,12,o[9]),I=c(I,_,k,T,b,17,o[10]),T=c(T,I,_,k,x,22,o[11]),k=c(k,T,I,_,S,7,o[12]),_=c(_,k,T,I,C,12,o[13]),I=c(I,_,k,T,E,17,o[14]),k=u(k,T=c(T,I,_,k,N,22,o[15]),I,_,l,5,o[16]),_=u(_,k,T,I,y,9,o[17]),I=u(I,_,k,T,x,14,o[18]),T=u(T,I,_,k,i,20,o[19]),k=u(k,T,I,_,g,5,o[20]),_=u(_,k,T,I,b,9,o[21]),I=u(I,_,k,T,N,14,o[22]),T=u(T,I,_,k,m,20,o[23]),k=u(k,T,I,_,A,5,o[24]),_=u(_,k,T,I,E,9,o[25]),I=u(I,_,k,T,p,14,o[26]),T=u(T,I,_,k,v,20,o[27]),k=u(k,T,I,_,C,5,o[28]),_=u(_,k,T,I,f,9,o[29]),I=u(I,_,k,T,w,14,o[30]),k=d(k,T=u(T,I,_,k,S,20,o[31]),I,_,g,4,o[32]),_=d(_,k,T,I,v,11,o[33]),I=d(I,_,k,T,x,16,o[34]),T=d(T,I,_,k,E,23,o[35]),k=d(k,T,I,_,l,4,o[36]),_=d(_,k,T,I,m,11,o[37]),I=d(I,_,k,T,w,16,o[38]),T=d(T,I,_,k,b,23,o[39]),k=d(k,T,I,_,C,4,o[40]),_=d(_,k,T,I,i,11,o[41]),I=d(I,_,k,T,p,16,o[42]),T=d(T,I,_,k,y,23,o[43]),k=d(k,T,I,_,A,4,o[44]),_=d(_,k,T,I,S,11,o[45]),I=d(I,_,k,T,N,16,o[46]),k=h(k,T=d(T,I,_,k,f,23,o[47]),I,_,i,6,o[48]),_=h(_,k,T,I,w,10,o[49]),I=h(I,_,k,T,E,15,o[50]),T=h(T,I,_,k,g,21,o[51]),k=h(k,T,I,_,S,6,o[52]),_=h(_,k,T,I,p,10,o[53]),I=h(I,_,k,T,b,15,o[54]),T=h(T,I,_,k,l,21,o[55]),k=h(k,T,I,_,v,6,o[56]),_=h(_,k,T,I,N,10,o[57]),I=h(I,_,k,T,y,15,o[58]),T=h(T,I,_,k,C,21,o[59]),k=h(k,T,I,_,m,6,o[60]),_=h(_,k,T,I,x,10,o[61]),I=h(I,_,k,T,f,15,o[62]),T=h(T,I,_,k,A,21,o[63]),a[0]=a[0]+k|0,a[1]=a[1]+T|0,a[2]=a[2]+I|0,a[3]=a[3]+_|0},_doFinalize:function(){var t=this._data,n=t.words,r=8*this._nDataBytes,s=8*t.sigBytes;n[s>>>5]|=128<<24-s%32;var a=e.floor(r/4294967296),i=r;n[15+(s+64>>>9<<4)]=16711935&(a<<8|a>>>24)|4278255360&(a<<24|a>>>8),n[14+(s+64>>>9<<4)]=16711935&(i<<8|i>>>24)|4278255360&(i<<24|i>>>8),t.sigBytes=4*(n.length+1),this._process();for(var o=this._hash,l=o.words,c=0;c<4;c++){var u=l[c];l[c]=16711935&(u<<8|u>>>24)|4278255360&(u<<24|u>>>8)}return o},clone:function(){var e=a.clone.call(this);return e._hash=this._hash.clone(),e}});function c(e,t,n,r,s,a,i){var o=e+(t&n|~t&r)+s+i;return(o<<a|o>>>32-a)+t}function u(e,t,n,r,s,a,i){var o=e+(t&r|n&~r)+s+i;return(o<<a|o>>>32-a)+t}function d(e,t,n,r,s,a,i){var o=e+(t^n^r)+s+i;return(o<<a|o>>>32-a)+t}function h(e,t,n,r,s,a,i){var o=e+(n^(t|~r))+s+i;return(o<<a|o>>>32-a)+t}n.MD5=a._createHelper(l),n.HmacMD5=a._createHmacHelper(l)}(Math),t.MD5)}()},4599(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.mode.CFB=function(){var e=t.lib.BlockCipherMode.extend();function n(e,t,n,r){var s,a=this._iv;a?(s=a.slice(0),this._iv=void 0):s=this._prevBlock,r.encryptBlock(s,0);for(var i=0;i<n;i++)e[t+i]^=s[i]}return e.Encryptor=e.extend({processBlock:function(e,t){var r=this._cipher,s=r.blockSize;n.call(this,e,t,s,r),this._prevBlock=e.slice(t,t+s)}}),e.Decryptor=e.extend({processBlock:function(e,t){var r=this._cipher,s=r.blockSize,a=e.slice(t,t+s);n.call(this,e,t,s,r),this._prevBlock=a}}),e}(),t.mode.CFB)}()},4558(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.mode.CTRGladman=function(){var e=t.lib.BlockCipherMode.extend();function n(e){if(255===(e>>24&255)){var t=e>>16&255,n=e>>8&255,r=255&e;255===t?(t=0,255===n?(n=0,255===r?r=0:++r):++n):++t,e=0,e+=t<<16,e+=n<<8,e+=r}else e+=1<<24;return e}function r(e){return 0===(e[0]=n(e[0]))&&(e[1]=n(e[1])),e}var s=e.Encryptor=e.extend({processBlock:function(e,t){var n=this._cipher,s=n.blockSize,a=this._iv,i=this._counter;a&&(i=this._counter=a.slice(0),this._iv=void 0),r(i);var o=i.slice(0);n.encryptBlock(o,0);for(var l=0;l<s;l++)e[t+l]^=o[l]}});return e.Decryptor=s,e}(),t.mode.CTRGladman)}()},933(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.mode.CTR=function(){var e=t.lib.BlockCipherMode.extend(),n=e.Encryptor=e.extend({processBlock:function(e,t){var n=this._cipher,r=n.blockSize,s=this._iv,a=this._counter;s&&(a=this._counter=s.slice(0),this._iv=void 0);var i=a.slice(0);n.encryptBlock(i,0),a[r-1]=a[r-1]+1|0;for(var o=0;o<r;o++)e[t+o]^=i[o]}});return e.Decryptor=n,e}(),t.mode.CTR)}()},4288(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.mode.ECB=function(){var e=t.lib.BlockCipherMode.extend();return e.Encryptor=e.extend({processBlock:function(e,t){this._cipher.encryptBlock(e,t)}}),e.Decryptor=e.extend({processBlock:function(e,t){this._cipher.decryptBlock(e,t)}}),e}(),t.mode.ECB)}()},8179(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.mode.OFB=function(){var e=t.lib.BlockCipherMode.extend(),n=e.Encryptor=e.extend({processBlock:function(e,t){var n=this._cipher,r=n.blockSize,s=this._iv,a=this._keystream;s&&(a=this._keystream=s.slice(0),this._iv=void 0),n.encryptBlock(a,0);for(var i=0;i<r;i++)e[t+i]^=a[i]}});return e.Decryptor=n,e}(),t.mode.OFB)}()},9775(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.pad.AnsiX923={pad:function(e,t){var n=e.sigBytes,r=4*t,s=r-n%r,a=n+s-1;e.clamp(),e.words[a>>>2]|=s<<24-a%4*8,e.sigBytes+=s},unpad:function(e){var t=255&e.words[e.sigBytes-1>>>2];e.sigBytes-=t}},t.pad.Ansix923)}()},5775(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.pad.Iso10126={pad:function(e,n){var r=4*n,s=r-e.sigBytes%r;e.concat(t.lib.WordArray.random(s-1)).concat(t.lib.WordArray.create([s<<24],1))},unpad:function(e){var t=255&e.words[e.sigBytes-1>>>2];e.sigBytes-=t}},t.pad.Iso10126)}()},776(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.pad.Iso97971={pad:function(e,n){e.concat(t.lib.WordArray.create([2147483648],1)),t.pad.ZeroPadding.pad(e,n)},unpad:function(e){t.pad.ZeroPadding.unpad(e),e.sigBytes--}},t.pad.Iso97971)}()},9446(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.pad.NoPadding={pad:function(){},unpad:function(){}},t.pad.NoPadding)}()},57(e,t,n){!function(){var t;e.exports=(t=n(1551),n(283),t.pad.ZeroPadding={pad:function(e,t){var n=4*t;e.clamp(),e.sigBytes+=n-(e.sigBytes%n||n)},unpad:function(e){var t=e.words,n=e.sigBytes-1;for(n=e.sigBytes-1;n>=0;n--)if(t[n>>>2]>>>24-n%4*8&255){e.sigBytes=n+1;break}}},t.pad.ZeroPadding)}()},6193(e,t,n){!function(){var t;e.exports=(t=n(1551),n(4595),n(2699),function(){var e=t,n=e.lib,r=n.Base,s=n.WordArray,a=e.algo,i=a.SHA256,o=a.HMAC,l=a.PBKDF2=r.extend({cfg:r.extend({keySize:4,hasher:i,iterations:25e4}),init:function(e){this.cfg=this.cfg.extend(e)},compute:function(e,t){for(var n=this.cfg,r=o.create(n.hasher,e),a=s.create(),i=s.create([1]),l=a.words,c=i.words,u=n.keySize,d=n.iterations;l.length<u;){var h=r.update(t).finalize(i);r.reset();for(var f=h.words,p=f.length,m=h,g=1;g<d;g++){m=r.finalize(m),r.reset();for(var y=m.words,w=0;w<p;w++)f[w]^=y[w]}a.concat(h),c[0]++}return a.sigBytes=4*u,a}});e.PBKDF2=function(e,t,n){return l.create(n).compute(e,t)}}(),t.PBKDF2)}()},4614(e,t,n){!function(){var t;e.exports=(t=n(1551),n(6596),n(2454),n(1964),n(283),function(){var e=t,n=e.lib.StreamCipher,r=e.algo,s=[],a=[],i=[],o=r.RabbitLegacy=n.extend({_doReset:function(){var e=this._key.words,t=this.cfg.iv,n=this._X=[e[0],e[3]<<16|e[2]>>>16,e[1],e[0]<<16|e[3]>>>16,e[2],e[1]<<16|e[0]>>>16,e[3],e[2]<<16|e[1]>>>16],r=this._C=[e[2]<<16|e[2]>>>16,4294901760&e[0]|65535&e[1],e[3]<<16|e[3]>>>16,4294901760&e[1]|65535&e[2],e[0]<<16|e[0]>>>16,4294901760&e[2]|65535&e[3],e[1]<<16|e[1]>>>16,4294901760&e[3]|65535&e[0]];this._b=0;for(var s=0;s<4;s++)l.call(this);for(s=0;s<8;s++)r[s]^=n[s+4&7];if(t){var a=t.words,i=a[0],o=a[1],c=16711935&(i<<8|i>>>24)|4278255360&(i<<24|i>>>8),u=16711935&(o<<8|o>>>24)|4278255360&(o<<24|o>>>8),d=c>>>16|4294901760&u,h=u<<16|65535&c;for(r[0]^=c,r[1]^=d,r[2]^=u,r[3]^=h,r[4]^=c,r[5]^=d,r[6]^=u,r[7]^=h,s=0;s<4;s++)l.call(this)}},_doProcessBlock:function(e,t){var n=this._X;l.call(this),s[0]=n[0]^n[5]>>>16^n[3]<<16,s[1]=n[2]^n[7]>>>16^n[5]<<16,s[2]=n[4]^n[1]>>>16^n[7]<<16,s[3]=n[6]^n[3]>>>16^n[1]<<16;for(var r=0;r<4;r++)s[r]=16711935&(s[r]<<8|s[r]>>>24)|4278255360&(s[r]<<24|s[r]>>>8),e[t+r]^=s[r]},blockSize:4,ivSize:2});function l(){for(var e=this._X,t=this._C,n=0;n<8;n++)a[n]=t[n];for(t[0]=t[0]+1295307597+this._b|0,t[1]=t[1]+3545052371+(t[0]>>>0<a[0]>>>0?1:0)|0,t[2]=t[2]+886263092+(t[1]>>>0<a[1]>>>0?1:0)|0,t[3]=t[3]+1295307597+(t[2]>>>0<a[2]>>>0?1:0)|0,t[4]=t[4]+3545052371+(t[3]>>>0<a[3]>>>0?1:0)|0,t[5]=t[5]+886263092+(t[4]>>>0<a[4]>>>0?1:0)|0,t[6]=t[6]+1295307597+(t[5]>>>0<a[5]>>>0?1:0)|0,t[7]=t[7]+3545052371+(t[6]>>>0<a[6]>>>0?1:0)|0,this._b=t[7]>>>0<a[7]>>>0?1:0,n=0;n<8;n++){var r=e[n]+t[n],s=65535&r,o=r>>>16,l=((s*s>>>17)+s*o>>>15)+o*o,c=((4294901760&r)*r|0)+((65535&r)*r|0);i[n]=l^c}e[0]=i[0]+(i[7]<<16|i[7]>>>16)+(i[6]<<16|i[6]>>>16)|0,e[1]=i[1]+(i[0]<<8|i[0]>>>24)+i[7]|0,e[2]=i[2]+(i[1]<<16|i[1]>>>16)+(i[0]<<16|i[0]>>>16)|0,e[3]=i[3]+(i[2]<<8|i[2]>>>24)+i[1]|0,e[4]=i[4]+(i[3]<<16|i[3]>>>16)+(i[2]<<16|i[2]>>>16)|0,e[5]=i[5]+(i[4]<<8|i[4]>>>24)+i[3]|0,e[6]=i[6]+(i[5]<<16|i[5]>>>16)+(i[4]<<16|i[4]>>>16)|0,e[7]=i[7]+(i[6]<<8|i[6]>>>24)+i[5]|0}e.RabbitLegacy=n._createHelper(o)}(),t.RabbitLegacy)}()},4148(e,t,n){!function(){var t;e.exports=(t=n(1551),n(6596),n(2454),n(1964),n(283),function(){var e=t,n=e.lib.StreamCipher,r=e.algo,s=[],a=[],i=[],o=r.Rabbit=n.extend({_doReset:function(){for(var e=this._key.words,t=this.cfg.iv,n=0;n<4;n++)e[n]=16711935&(e[n]<<8|e[n]>>>24)|4278255360&(e[n]<<24|e[n]>>>8);var r=this._X=[e[0],e[3]<<16|e[2]>>>16,e[1],e[0]<<16|e[3]>>>16,e[2],e[1]<<16|e[0]>>>16,e[3],e[2]<<16|e[1]>>>16],s=this._C=[e[2]<<16|e[2]>>>16,4294901760&e[0]|65535&e[1],e[3]<<16|e[3]>>>16,4294901760&e[1]|65535&e[2],e[0]<<16|e[0]>>>16,4294901760&e[2]|65535&e[3],e[1]<<16|e[1]>>>16,4294901760&e[3]|65535&e[0]];for(this._b=0,n=0;n<4;n++)l.call(this);for(n=0;n<8;n++)s[n]^=r[n+4&7];if(t){var a=t.words,i=a[0],o=a[1],c=16711935&(i<<8|i>>>24)|4278255360&(i<<24|i>>>8),u=16711935&(o<<8|o>>>24)|4278255360&(o<<24|o>>>8),d=c>>>16|4294901760&u,h=u<<16|65535&c;for(s[0]^=c,s[1]^=d,s[2]^=u,s[3]^=h,s[4]^=c,s[5]^=d,s[6]^=u,s[7]^=h,n=0;n<4;n++)l.call(this)}},_doProcessBlock:function(e,t){var n=this._X;l.call(this),s[0]=n[0]^n[5]>>>16^n[3]<<16,s[1]=n[2]^n[7]>>>16^n[5]<<16,s[2]=n[4]^n[1]>>>16^n[7]<<16,s[3]=n[6]^n[3]>>>16^n[1]<<16;for(var r=0;r<4;r++)s[r]=16711935&(s[r]<<8|s[r]>>>24)|4278255360&(s[r]<<24|s[r]>>>8),e[t+r]^=s[r]},blockSize:4,ivSize:2});function l(){for(var e=this._X,t=this._C,n=0;n<8;n++)a[n]=t[n];for(t[0]=t[0]+1295307597+this._b|0,t[1]=t[1]+3545052371+(t[0]>>>0<a[0]>>>0?1:0)|0,t[2]=t[2]+886263092+(t[1]>>>0<a[1]>>>0?1:0)|0,t[3]=t[3]+1295307597+(t[2]>>>0<a[2]>>>0?1:0)|0,t[4]=t[4]+3545052371+(t[3]>>>0<a[3]>>>0?1:0)|0,t[5]=t[5]+886263092+(t[4]>>>0<a[4]>>>0?1:0)|0,t[6]=t[6]+1295307597+(t[5]>>>0<a[5]>>>0?1:0)|0,t[7]=t[7]+3545052371+(t[6]>>>0<a[6]>>>0?1:0)|0,this._b=t[7]>>>0<a[7]>>>0?1:0,n=0;n<8;n++){var r=e[n]+t[n],s=65535&r,o=r>>>16,l=((s*s>>>17)+s*o>>>15)+o*o,c=((4294901760&r)*r|0)+((65535&r)*r|0);i[n]=l^c}e[0]=i[0]+(i[7]<<16|i[7]>>>16)+(i[6]<<16|i[6]>>>16)|0,e[1]=i[1]+(i[0]<<8|i[0]>>>24)+i[7]|0,e[2]=i[2]+(i[1]<<16|i[1]>>>16)+(i[0]<<16|i[0]>>>16)|0,e[3]=i[3]+(i[2]<<8|i[2]>>>24)+i[1]|0,e[4]=i[4]+(i[3]<<16|i[3]>>>16)+(i[2]<<16|i[2]>>>16)|0,e[5]=i[5]+(i[4]<<8|i[4]>>>24)+i[3]|0,e[6]=i[6]+(i[5]<<16|i[5]>>>16)+(i[4]<<16|i[4]>>>16)|0,e[7]=i[7]+(i[6]<<8|i[6]>>>24)+i[5]|0}e.Rabbit=n._createHelper(o)}(),t.Rabbit)}()},2827(e,t,n){!function(){var t;e.exports=(t=n(1551),n(6596),n(2454),n(1964),n(283),function(){var e=t,n=e.lib.StreamCipher,r=e.algo,s=r.RC4=n.extend({_doReset:function(){for(var e=this._key,t=e.words,n=e.sigBytes,r=this._S=[],s=0;s<256;s++)r[s]=s;s=0;for(var a=0;s<256;s++){var i=s%n,o=t[i>>>2]>>>24-i%4*8&255;a=(a+r[s]+o)%256;var l=r[s];r[s]=r[a],r[a]=l}this._i=this._j=0},_doProcessBlock:function(e,t){e[t]^=a.call(this)},keySize:8,ivSize:0});function a(){for(var e=this._S,t=this._i,n=this._j,r=0,s=0;s<4;s++){n=(n+e[t=(t+1)%256])%256;var a=e[t];e[t]=e[n],e[n]=a,r|=e[(e[t]+e[n])%256]<<24-8*s}return this._i=t,this._j=n,r}e.RC4=n._createHelper(s);var i=r.RC4Drop=s.extend({cfg:s.cfg.extend({drop:192}),_doReset:function(){s._doReset.call(this);for(var e=this.cfg.drop;e>0;e--)a.call(this)}});e.RC4Drop=n._createHelper(i)}(),t.RC4)}()},8562(e,t,n){!function(){var t;e.exports=(t=n(1551),function(){var e=t,n=e.lib,r=n.WordArray,s=n.Hasher,a=e.algo,i=r.create([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,7,4,13,1,10,6,15,3,12,0,9,5,2,14,11,8,3,10,14,4,9,15,8,1,2,7,0,6,13,11,5,12,1,9,11,10,0,8,12,4,13,3,7,15,14,5,6,2,4,0,5,9,7,12,2,10,14,1,3,8,11,6,15,13]),o=r.create([5,14,7,0,9,2,11,4,13,6,15,8,1,10,3,12,6,11,3,7,0,13,5,10,14,15,8,12,4,9,1,2,15,5,1,3,7,14,6,9,11,8,12,2,10,0,4,13,8,6,4,1,3,11,15,0,5,12,2,13,9,7,10,14,12,15,10,4,1,5,8,7,6,2,13,14,0,3,9,11]),l=r.create([11,14,15,12,5,8,7,9,11,13,14,15,6,7,9,8,7,6,8,13,11,9,7,15,7,12,15,9,11,7,13,12,11,13,6,7,14,9,13,15,14,8,13,6,5,12,7,5,11,12,14,15,14,15,9,8,9,14,5,6,8,6,5,12,9,15,5,11,6,8,13,12,5,12,13,14,11,8,5,6]),c=r.create([8,9,9,11,13,15,15,5,7,7,8,11,14,14,12,6,9,13,15,7,12,8,9,11,7,7,12,7,6,15,13,11,9,7,15,11,8,6,6,14,12,13,5,14,13,13,7,5,15,5,8,11,14,14,6,14,6,9,12,9,12,5,15,8,8,5,12,9,12,5,14,6,8,13,6,5,15,13,11,11]),u=r.create([0,1518500249,1859775393,2400959708,2840853838]),d=r.create([1352829926,1548603684,1836072691,2053994217,0]),h=a.RIPEMD160=s.extend({_doReset:function(){this._hash=r.create([1732584193,4023233417,2562383102,271733878,3285377520])},_doProcessBlock:function(e,t){for(var n=0;n<16;n++){var r=t+n,s=e[r];e[r]=16711935&(s<<8|s>>>24)|4278255360&(s<<24|s>>>8)}var a,h,v,A,b,x,S,C,E,N,k,T=this._hash.words,I=u.words,_=d.words,R=i.words,M=o.words,D=l.words,j=c.words;for(x=a=T[0],S=h=T[1],C=v=T[2],E=A=T[3],N=b=T[4],n=0;n<80;n+=1)k=a+e[t+R[n]]|0,k+=n<16?f(h,v,A)+I[0]:n<32?p(h,v,A)+I[1]:n<48?m(h,v,A)+I[2]:n<64?g(h,v,A)+I[3]:y(h,v,A)+I[4],k=(k=w(k|=0,D[n]))+b|0,a=b,b=A,A=w(v,10),v=h,h=k,k=x+e[t+M[n]]|0,k+=n<16?y(S,C,E)+_[0]:n<32?g(S,C,E)+_[1]:n<48?m(S,C,E)+_[2]:n<64?p(S,C,E)+_[3]:f(S,C,E)+_[4],k=(k=w(k|=0,j[n]))+N|0,x=N,N=E,E=w(C,10),C=S,S=k;k=T[1]+v+E|0,T[1]=T[2]+A+N|0,T[2]=T[3]+b+x|0,T[3]=T[4]+a+S|0,T[4]=T[0]+h+C|0,T[0]=k},_doFinalize:function(){var e=this._data,t=e.words,n=8*this._nDataBytes,r=8*e.sigBytes;t[r>>>5]|=128<<24-r%32,t[14+(r+64>>>9<<4)]=16711935&(n<<8|n>>>24)|4278255360&(n<<24|n>>>8),e.sigBytes=4*(t.length+1),this._process();for(var s=this._hash,a=s.words,i=0;i<5;i++){var o=a[i];a[i]=16711935&(o<<8|o>>>24)|4278255360&(o<<24|o>>>8)}return s},clone:function(){var e=s.clone.call(this);return e._hash=this._hash.clone(),e}});function f(e,t,n){return e^t^n}function p(e,t,n){return e&t|~e&n}function m(e,t,n){return(e|~t)^n}function g(e,t,n){return e&n|t&~n}function y(e,t,n){return e^(t|~n)}function w(e,t){return e<<t|e>>>32-t}e.RIPEMD160=s._createHelper(h),e.HmacRIPEMD160=s._createHmacHelper(h)}(Math),t.RIPEMD160)}()},3025(e,t,n){!function(){var t;e.exports=(t=n(1551),function(){var e=t,n=e.lib,r=n.WordArray,s=n.Hasher,a=e.algo,i=[],o=a.SHA1=s.extend({_doReset:function(){this._hash=new r.init([1732584193,4023233417,2562383102,271733878,3285377520])},_doProcessBlock:function(e,t){for(var n=this._hash.words,r=n[0],s=n[1],a=n[2],o=n[3],l=n[4],c=0;c<80;c++){if(c<16)i[c]=0|e[t+c];else{var u=i[c-3]^i[c-8]^i[c-14]^i[c-16];i[c]=u<<1|u>>>31}var d=(r<<5|r>>>27)+l+i[c];d+=c<20?1518500249+(s&a|~s&o):c<40?1859775393+(s^a^o):c<60?(s&a|s&o|a&o)-1894007588:(s^a^o)-899497514,l=o,o=a,a=s<<30|s>>>2,s=r,r=d}n[0]=n[0]+r|0,n[1]=n[1]+s|0,n[2]=n[2]+a|0,n[3]=n[3]+o|0,n[4]=n[4]+l|0},_doFinalize:function(){var e=this._data,t=e.words,n=8*this._nDataBytes,r=8*e.sigBytes;return t[r>>>5]|=128<<24-r%32,t[14+(r+64>>>9<<4)]=Math.floor(n/4294967296),t[15+(r+64>>>9<<4)]=n,e.sigBytes=4*t.length,this._process(),this._hash},clone:function(){var e=s.clone.call(this);return e._hash=this._hash.clone(),e}});e.SHA1=s._createHelper(o),e.HmacSHA1=s._createHmacHelper(o)}(),t.SHA1)}()},7278(e,t,n){!function(){var t;e.exports=(t=n(1551),n(4595),function(){var e=t,n=e.lib.WordArray,r=e.algo,s=r.SHA256,a=r.SHA224=s.extend({_doReset:function(){this._hash=new n.init([3238371032,914150663,812702999,4144912697,4290775857,1750603025,1694076839,3204075428])},_doFinalize:function(){var e=s._doFinalize.call(this);return e.sigBytes-=4,e}});e.SHA224=s._createHelper(a),e.HmacSHA224=s._createHmacHelper(a)}(),t.SHA224)}()},4595(e,t,n){!function(){var t;e.exports=(t=n(1551),function(e){var n=t,r=n.lib,s=r.WordArray,a=r.Hasher,i=n.algo,o=[],l=[];!function(){function t(t){for(var n=e.sqrt(t),r=2;r<=n;r++)if(!(t%r))return!1;return!0}function n(e){return 4294967296*(e-(0|e))|0}for(var r=2,s=0;s<64;)t(r)&&(s<8&&(o[s]=n(e.pow(r,.5))),l[s]=n(e.pow(r,1/3)),s++),r++}();var c=[],u=i.SHA256=a.extend({_doReset:function(){this._hash=new s.init(o.slice(0))},_doProcessBlock:function(e,t){for(var n=this._hash.words,r=n[0],s=n[1],a=n[2],i=n[3],o=n[4],u=n[5],d=n[6],h=n[7],f=0;f<64;f++){if(f<16)c[f]=0|e[t+f];else{var p=c[f-15],m=(p<<25|p>>>7)^(p<<14|p>>>18)^p>>>3,g=c[f-2],y=(g<<15|g>>>17)^(g<<13|g>>>19)^g>>>10;c[f]=m+c[f-7]+y+c[f-16]}var w=r&s^r&a^s&a,v=(r<<30|r>>>2)^(r<<19|r>>>13)^(r<<10|r>>>22),A=h+((o<<26|o>>>6)^(o<<21|o>>>11)^(o<<7|o>>>25))+(o&u^~o&d)+l[f]+c[f];h=d,d=u,u=o,o=i+A|0,i=a,a=s,s=r,r=A+(v+w)|0}n[0]=n[0]+r|0,n[1]=n[1]+s|0,n[2]=n[2]+a|0,n[3]=n[3]+i|0,n[4]=n[4]+o|0,n[5]=n[5]+u|0,n[6]=n[6]+d|0,n[7]=n[7]+h|0},_doFinalize:function(){var t=this._data,n=t.words,r=8*this._nDataBytes,s=8*t.sigBytes;return n[s>>>5]|=128<<24-s%32,n[14+(s+64>>>9<<4)]=e.floor(r/4294967296),n[15+(s+64>>>9<<4)]=r,t.sigBytes=4*n.length,this._process(),this._hash},clone:function(){var e=a.clone.call(this);return e._hash=this._hash.clone(),e}});n.SHA256=a._createHelper(u),n.HmacSHA256=a._createHmacHelper(u)}(Math),t.SHA256)}()},5151(e,t,n){!function(){var t;e.exports=(t=n(1551),n(5790),function(e){var n=t,r=n.lib,s=r.WordArray,a=r.Hasher,i=n.x64.Word,o=n.algo,l=[],c=[],u=[];!function(){for(var e=1,t=0,n=0;n<24;n++){l[e+5*t]=(n+1)*(n+2)/2%64;var r=(2*e+3*t)%5;e=t%5,t=r}for(e=0;e<5;e++)for(t=0;t<5;t++)c[e+5*t]=t+(2*e+3*t)%5*5;for(var s=1,a=0;a<24;a++){for(var o=0,d=0,h=0;h<7;h++){if(1&s){var f=(1<<h)-1;f<32?d^=1<<f:o^=1<<f-32}128&s?s=s<<1^113:s<<=1}u[a]=i.create(o,d)}}();var d=[];!function(){for(var e=0;e<25;e++)d[e]=i.create()}();var h=o.SHA3=a.extend({cfg:a.cfg.extend({outputLength:512}),_doReset:function(){for(var e=this._state=[],t=0;t<25;t++)e[t]=new i.init;this.blockSize=(1600-2*this.cfg.outputLength)/32},_doProcessBlock:function(e,t){for(var n=this._state,r=this.blockSize/2,s=0;s<r;s++){var a=e[t+2*s],i=e[t+2*s+1];a=16711935&(a<<8|a>>>24)|4278255360&(a<<24|a>>>8),i=16711935&(i<<8|i>>>24)|4278255360&(i<<24|i>>>8),(T=n[s]).high^=i,T.low^=a}for(var o=0;o<24;o++){for(var h=0;h<5;h++){for(var f=0,p=0,m=0;m<5;m++)f^=(T=n[h+5*m]).high,p^=T.low;var g=d[h];g.high=f,g.low=p}for(h=0;h<5;h++){var y=d[(h+4)%5],w=d[(h+1)%5],v=w.high,A=w.low;for(f=y.high^(v<<1|A>>>31),p=y.low^(A<<1|v>>>31),m=0;m<5;m++)(T=n[h+5*m]).high^=f,T.low^=p}for(var b=1;b<25;b++){var x=(T=n[b]).high,S=T.low,C=l[b];C<32?(f=x<<C|S>>>32-C,p=S<<C|x>>>32-C):(f=S<<C-32|x>>>64-C,p=x<<C-32|S>>>64-C);var E=d[c[b]];E.high=f,E.low=p}var N=d[0],k=n[0];for(N.high=k.high,N.low=k.low,h=0;h<5;h++)for(m=0;m<5;m++){var T=n[b=h+5*m],I=d[b],_=d[(h+1)%5+5*m],R=d[(h+2)%5+5*m];T.high=I.high^~_.high&R.high,T.low=I.low^~_.low&R.low}T=n[0];var M=u[o];T.high^=M.high,T.low^=M.low}},_doFinalize:function(){var t=this._data,n=t.words,r=(this._nDataBytes,8*t.sigBytes),a=32*this.blockSize;n[r>>>5]|=1<<24-r%32,n[(e.ceil((r+1)/a)*a>>>5)-1]|=128,t.sigBytes=4*n.length,this._process();for(var i=this._state,o=this.cfg.outputLength/8,l=o/8,c=[],u=0;u<l;u++){var d=i[u],h=d.high,f=d.low;h=16711935&(h<<8|h>>>24)|4278255360&(h<<24|h>>>8),f=16711935&(f<<8|f>>>24)|4278255360&(f<<24|f>>>8),c.push(f),c.push(h)}return new s.init(c,o)},clone:function(){for(var e=a.clone.call(this),t=e._state=this._state.slice(0),n=0;n<25;n++)t[n]=t[n].clone();return e}});n.SHA3=a._createHelper(h),n.HmacSHA3=a._createHmacHelper(h)}(Math),t.SHA3)}()},4275(e,t,n){!function(){var t;e.exports=(t=n(1551),n(5790),n(9378),function(){var e=t,n=e.x64,r=n.Word,s=n.WordArray,a=e.algo,i=a.SHA512,o=a.SHA384=i.extend({_doReset:function(){this._hash=new s.init([new r.init(3418070365,3238371032),new r.init(1654270250,914150663),new r.init(2438529370,812702999),new r.init(355462360,4144912697),new r.init(1731405415,4290775857),new r.init(2394180231,1750603025),new r.init(3675008525,1694076839),new r.init(1203062813,3204075428)])},_doFinalize:function(){var e=i._doFinalize.call(this);return e.sigBytes-=16,e}});e.SHA384=i._createHelper(o),e.HmacSHA384=i._createHmacHelper(o)}(),t.SHA384)}()},9378(e,t,n){!function(){var t;e.exports=(t=n(1551),n(5790),function(){var e=t,n=e.lib.Hasher,r=e.x64,s=r.Word,a=r.WordArray,i=e.algo;function o(){return s.create.apply(s,arguments)}var l=[o(1116352408,3609767458),o(1899447441,602891725),o(3049323471,3964484399),o(3921009573,2173295548),o(961987163,4081628472),o(1508970993,3053834265),o(2453635748,2937671579),o(2870763221,3664609560),o(3624381080,2734883394),o(310598401,1164996542),o(607225278,1323610764),o(1426881987,3590304994),o(1925078388,4068182383),o(2162078206,991336113),o(2614888103,633803317),o(3248222580,3479774868),o(3835390401,2666613458),o(4022224774,944711139),o(264347078,2341262773),o(604807628,2007800933),o(770255983,1495990901),o(1249150122,1856431235),o(1555081692,3175218132),o(1996064986,2198950837),o(2554220882,3999719339),o(2821834349,766784016),o(2952996808,2566594879),o(3210313671,3203337956),o(3336571891,1034457026),o(3584528711,2466948901),o(113926993,3758326383),o(338241895,168717936),o(666307205,1188179964),o(773529912,1546045734),o(1294757372,1522805485),o(1396182291,2643833823),o(1695183700,2343527390),o(1986661051,1014477480),o(2177026350,1206759142),o(2456956037,344077627),o(2730485921,1290863460),o(2820302411,3158454273),o(3259730800,3505952657),o(3345764771,106217008),o(3516065817,3606008344),o(3600352804,1432725776),o(4094571909,1467031594),o(275423344,851169720),o(430227734,3100823752),o(506948616,1363258195),o(659060556,3750685593),o(883997877,3785050280),o(958139571,3318307427),o(1322822218,3812723403),o(1537002063,2003034995),o(1747873779,3602036899),o(1955562222,1575990012),o(2024104815,1125592928),o(2227730452,2716904306),o(2361852424,442776044),o(2428436474,593698344),o(2756734187,3733110249),o(3204031479,2999351573),o(3329325298,3815920427),o(3391569614,3928383900),o(3515267271,566280711),o(3940187606,3454069534),o(4118630271,4000239992),o(116418474,1914138554),o(174292421,2731055270),o(289380356,3203993006),o(460393269,320620315),o(685471733,587496836),o(852142971,1086792851),o(1017036298,365543100),o(1126000580,2618297676),o(1288033470,3409855158),o(1501505948,4234509866),o(1607167915,987167468),o(1816402316,1246189591)],c=[];!function(){for(var e=0;e<80;e++)c[e]=o()}();var u=i.SHA512=n.extend({_doReset:function(){this._hash=new a.init([new s.init(1779033703,4089235720),new s.init(3144134277,2227873595),new s.init(1013904242,4271175723),new s.init(2773480762,1595750129),new s.init(1359893119,2917565137),new s.init(2600822924,725511199),new s.init(528734635,4215389547),new s.init(1541459225,327033209)])},_doProcessBlock:function(e,t){for(var n=this._hash.words,r=n[0],s=n[1],a=n[2],i=n[3],o=n[4],u=n[5],d=n[6],h=n[7],f=r.high,p=r.low,m=s.high,g=s.low,y=a.high,w=a.low,v=i.high,A=i.low,b=o.high,x=o.low,S=u.high,C=u.low,E=d.high,N=d.low,k=h.high,T=h.low,I=f,_=p,R=m,M=g,D=y,j=w,O=v,P=A,L=b,B=x,F=S,U=C,W=E,z=N,H=k,V=T,G=0;G<80;G++){var J,Q,K=c[G];if(G<16)Q=K.high=0|e[t+2*G],J=K.low=0|e[t+2*G+1];else{var Y=c[G-15],q=Y.high,X=Y.low,Z=(q>>>1|X<<31)^(q>>>8|X<<24)^q>>>7,$=(X>>>1|q<<31)^(X>>>8|q<<24)^(X>>>7|q<<25),ee=c[G-2],te=ee.high,ne=ee.low,re=(te>>>19|ne<<13)^(te<<3|ne>>>29)^te>>>6,se=(ne>>>19|te<<13)^(ne<<3|te>>>29)^(ne>>>6|te<<26),ae=c[G-7],ie=ae.high,oe=ae.low,le=c[G-16],ce=le.high,ue=le.low;Q=(Q=(Q=Z+ie+((J=$+oe)>>>0<$>>>0?1:0))+re+((J+=se)>>>0<se>>>0?1:0))+ce+((J+=ue)>>>0<ue>>>0?1:0),K.high=Q,K.low=J}var de,he=L&F^~L&W,fe=B&U^~B&z,pe=I&R^I&D^R&D,me=_&M^_&j^M&j,ge=(I>>>28|_<<4)^(I<<30|_>>>2)^(I<<25|_>>>7),ye=(_>>>28|I<<4)^(_<<30|I>>>2)^(_<<25|I>>>7),we=(L>>>14|B<<18)^(L>>>18|B<<14)^(L<<23|B>>>9),ve=(B>>>14|L<<18)^(B>>>18|L<<14)^(B<<23|L>>>9),Ae=l[G],be=Ae.high,xe=Ae.low,Se=H+we+((de=V+ve)>>>0<V>>>0?1:0),Ce=ye+me;H=W,V=z,W=F,z=U,F=L,U=B,L=O+(Se=(Se=(Se=Se+he+((de+=fe)>>>0<fe>>>0?1:0))+be+((de+=xe)>>>0<xe>>>0?1:0))+Q+((de+=J)>>>0<J>>>0?1:0))+((B=P+de|0)>>>0<P>>>0?1:0)|0,O=D,P=j,D=R,j=M,R=I,M=_,I=Se+(ge+pe+(Ce>>>0<ye>>>0?1:0))+((_=de+Ce|0)>>>0<de>>>0?1:0)|0}p=r.low=p+_,r.high=f+I+(p>>>0<_>>>0?1:0),g=s.low=g+M,s.high=m+R+(g>>>0<M>>>0?1:0),w=a.low=w+j,a.high=y+D+(w>>>0<j>>>0?1:0),A=i.low=A+P,i.high=v+O+(A>>>0<P>>>0?1:0),x=o.low=x+B,o.high=b+L+(x>>>0<B>>>0?1:0),C=u.low=C+U,u.high=S+F+(C>>>0<U>>>0?1:0),N=d.low=N+z,d.high=E+W+(N>>>0<z>>>0?1:0),T=h.low=T+V,h.high=k+H+(T>>>0<V>>>0?1:0)},_doFinalize:function(){var e=this._data,t=e.words,n=8*this._nDataBytes,r=8*e.sigBytes;return t[r>>>5]|=128<<24-r%32,t[30+(r+128>>>10<<5)]=Math.floor(n/4294967296),t[31+(r+128>>>10<<5)]=n,e.sigBytes=4*t.length,this._process(),this._hash.toX32()},clone:function(){var e=n.clone.call(this);return e._hash=this._hash.clone(),e},blockSize:32});e.SHA512=n._createHelper(u),e.HmacSHA512=n._createHmacHelper(u)}(),t.SHA512)}()},4710(e,t,n){!function(){var t;e.exports=(t=n(1551),n(6596),n(2454),n(1964),n(283),function(){var e=t,n=e.lib,r=n.WordArray,s=n.BlockCipher,a=e.algo,i=[57,49,41,33,25,17,9,1,58,50,42,34,26,18,10,2,59,51,43,35,27,19,11,3,60,52,44,36,63,55,47,39,31,23,15,7,62,54,46,38,30,22,14,6,61,53,45,37,29,21,13,5,28,20,12,4],o=[14,17,11,24,1,5,3,28,15,6,21,10,23,19,12,4,26,8,16,7,27,20,13,2,41,52,31,37,47,55,30,40,51,45,33,48,44,49,39,56,34,53,46,42,50,36,29,32],l=[1,2,4,6,8,10,12,14,15,17,19,21,23,25,27,28],c=[{0:8421888,268435456:32768,536870912:8421378,805306368:2,1073741824:512,1342177280:8421890,1610612736:8389122,1879048192:8388608,2147483648:514,2415919104:8389120,2684354560:33280,2952790016:8421376,3221225472:32770,3489660928:8388610,3758096384:0,4026531840:33282,134217728:0,402653184:8421890,671088640:33282,939524096:32768,1207959552:8421888,1476395008:512,1744830464:8421378,2013265920:2,2281701376:8389120,2550136832:33280,2818572288:8421376,3087007744:8389122,3355443200:8388610,3623878656:32770,3892314112:514,4160749568:8388608,1:32768,268435457:2,536870913:8421888,805306369:8388608,1073741825:8421378,1342177281:33280,1610612737:512,1879048193:8389122,2147483649:8421890,2415919105:8421376,2684354561:8388610,2952790017:33282,3221225473:514,3489660929:8389120,3758096385:32770,4026531841:0,134217729:8421890,402653185:8421376,671088641:8388608,939524097:512,1207959553:32768,1476395009:8388610,1744830465:2,2013265921:33282,2281701377:32770,2550136833:8389122,2818572289:514,3087007745:8421888,3355443201:8389120,3623878657:0,3892314113:33280,4160749569:8421378},{0:1074282512,16777216:16384,33554432:524288,50331648:1074266128,67108864:1073741840,83886080:1074282496,100663296:1073758208,117440512:16,134217728:540672,150994944:1073758224,167772160:1073741824,184549376:540688,201326592:524304,218103808:0,234881024:16400,251658240:1074266112,8388608:1073758208,25165824:540688,41943040:16,58720256:1073758224,75497472:1074282512,92274688:1073741824,109051904:524288,125829120:1074266128,142606336:524304,159383552:0,176160768:16384,192937984:1074266112,209715200:1073741840,226492416:540672,243269632:1074282496,260046848:16400,268435456:0,285212672:1074266128,301989888:1073758224,318767104:1074282496,335544320:1074266112,352321536:16,369098752:540688,385875968:16384,402653184:16400,419430400:524288,436207616:524304,452984832:1073741840,469762048:540672,486539264:1073758208,503316480:1073741824,520093696:1074282512,276824064:540688,293601280:524288,310378496:1074266112,327155712:16384,343932928:1073758208,360710144:1074282512,377487360:16,394264576:1073741824,411041792:1074282496,427819008:1073741840,444596224:1073758224,461373440:524304,478150656:0,494927872:16400,511705088:1074266128,528482304:540672},{0:260,1048576:0,2097152:67109120,3145728:65796,4194304:65540,5242880:67108868,6291456:67174660,7340032:67174400,8388608:67108864,9437184:67174656,10485760:65792,11534336:67174404,12582912:67109124,13631488:65536,14680064:4,15728640:256,524288:67174656,1572864:67174404,2621440:0,3670016:67109120,4718592:67108868,5767168:65536,6815744:65540,7864320:260,8912896:4,9961472:256,11010048:67174400,12058624:65796,13107200:65792,14155776:67109124,15204352:67174660,16252928:67108864,16777216:67174656,17825792:65540,18874368:65536,19922944:67109120,20971520:256,22020096:67174660,23068672:67108868,24117248:0,25165824:67109124,26214400:67108864,27262976:4,28311552:65792,29360128:67174400,30408704:260,31457280:65796,32505856:67174404,17301504:67108864,18350080:260,19398656:67174656,20447232:0,21495808:65540,22544384:67109120,23592960:256,24641536:67174404,25690112:65536,26738688:67174660,27787264:65796,28835840:67108868,29884416:67109124,30932992:67174400,31981568:4,33030144:65792},{0:2151682048,65536:2147487808,131072:4198464,196608:2151677952,262144:0,327680:4198400,393216:2147483712,458752:4194368,524288:2147483648,589824:4194304,655360:64,720896:2147487744,786432:2151678016,851968:4160,917504:4096,983040:2151682112,32768:2147487808,98304:64,163840:2151678016,229376:2147487744,294912:4198400,360448:2151682112,425984:0,491520:2151677952,557056:4096,622592:2151682048,688128:4194304,753664:4160,819200:2147483648,884736:4194368,950272:4198464,1015808:2147483712,1048576:4194368,1114112:4198400,1179648:2147483712,1245184:0,1310720:4160,1376256:2151678016,1441792:2151682048,1507328:2147487808,1572864:2151682112,1638400:2147483648,1703936:2151677952,1769472:4198464,1835008:2147487744,1900544:4194304,1966080:64,2031616:4096,1081344:2151677952,1146880:2151682112,1212416:0,1277952:4198400,1343488:4194368,1409024:2147483648,1474560:2147487808,1540096:64,1605632:2147483712,1671168:4096,1736704:2147487744,1802240:2151678016,1867776:4160,1933312:2151682048,1998848:4194304,2064384:4198464},{0:128,4096:17039360,8192:262144,12288:536870912,16384:537133184,20480:16777344,24576:553648256,28672:262272,32768:16777216,36864:537133056,40960:536871040,45056:553910400,49152:553910272,53248:0,57344:17039488,61440:553648128,2048:17039488,6144:553648256,10240:128,14336:17039360,18432:262144,22528:537133184,26624:553910272,30720:536870912,34816:537133056,38912:0,43008:553910400,47104:16777344,51200:536871040,55296:553648128,59392:16777216,63488:262272,65536:262144,69632:128,73728:536870912,77824:553648256,81920:16777344,86016:553910272,90112:537133184,94208:16777216,98304:553910400,102400:553648128,106496:17039360,110592:537133056,114688:262272,118784:536871040,122880:0,126976:17039488,67584:553648256,71680:16777216,75776:17039360,79872:537133184,83968:536870912,88064:17039488,92160:128,96256:553910272,100352:262272,104448:553910400,108544:0,112640:553648128,116736:16777344,120832:262144,124928:537133056,129024:536871040},{0:268435464,256:8192,512:270532608,768:270540808,1024:268443648,1280:2097152,1536:2097160,1792:268435456,2048:0,2304:268443656,2560:2105344,2816:8,3072:270532616,3328:2105352,3584:8200,3840:270540800,128:270532608,384:270540808,640:8,896:2097152,1152:2105352,1408:268435464,1664:268443648,1920:8200,2176:2097160,2432:8192,2688:268443656,2944:270532616,3200:0,3456:270540800,3712:2105344,3968:268435456,4096:268443648,4352:270532616,4608:270540808,4864:8200,5120:2097152,5376:268435456,5632:268435464,5888:2105344,6144:2105352,6400:0,6656:8,6912:270532608,7168:8192,7424:268443656,7680:270540800,7936:2097160,4224:8,4480:2105344,4736:2097152,4992:268435464,5248:268443648,5504:8200,5760:270540808,6016:270532608,6272:270540800,6528:270532616,6784:8192,7040:2105352,7296:2097160,7552:0,7808:268435456,8064:268443656},{0:1048576,16:33555457,32:1024,48:1049601,64:34604033,80:0,96:1,112:34603009,128:33555456,144:1048577,160:33554433,176:34604032,192:34603008,208:1025,224:1049600,240:33554432,8:34603009,24:0,40:33555457,56:34604032,72:1048576,88:33554433,104:33554432,120:1025,136:1049601,152:33555456,168:34603008,184:1048577,200:1024,216:34604033,232:1,248:1049600,256:33554432,272:1048576,288:33555457,304:34603009,320:1048577,336:33555456,352:34604032,368:1049601,384:1025,400:34604033,416:1049600,432:1,448:0,464:34603008,480:33554433,496:1024,264:1049600,280:33555457,296:34603009,312:1,328:33554432,344:1048576,360:1025,376:34604032,392:33554433,408:34603008,424:0,440:34604033,456:1049601,472:1024,488:33555456,504:1048577},{0:134219808,1:131072,2:134217728,3:32,4:131104,5:134350880,6:134350848,7:2048,8:134348800,9:134219776,10:133120,11:134348832,12:2080,13:0,14:134217760,15:133152,2147483648:2048,2147483649:134350880,2147483650:134219808,2147483651:134217728,2147483652:134348800,2147483653:133120,2147483654:133152,2147483655:32,2147483656:134217760,2147483657:2080,2147483658:131104,2147483659:134350848,2147483660:0,2147483661:134348832,2147483662:134219776,2147483663:131072,16:133152,17:134350848,18:32,19:2048,20:134219776,21:134217760,22:134348832,23:131072,24:0,25:131104,26:134348800,27:134219808,28:134350880,29:133120,30:2080,31:134217728,2147483664:131072,2147483665:2048,2147483666:134348832,2147483667:133152,2147483668:32,2147483669:134348800,2147483670:134217728,2147483671:134219808,2147483672:134350880,2147483673:134217760,2147483674:134219776,2147483675:0,2147483676:133120,2147483677:2080,2147483678:131104,2147483679:134350848}],u=[4160749569,528482304,33030144,2064384,129024,8064,504,2147483679],d=a.DES=s.extend({_doReset:function(){for(var e=this._key.words,t=[],n=0;n<56;n++){var r=i[n]-1;t[n]=e[r>>>5]>>>31-r%32&1}for(var s=this._subKeys=[],a=0;a<16;a++){var c=s[a]=[],u=l[a];for(n=0;n<24;n++)c[n/6|0]|=t[(o[n]-1+u)%28]<<31-n%6,c[4+(n/6|0)]|=t[28+(o[n+24]-1+u)%28]<<31-n%6;for(c[0]=c[0]<<1|c[0]>>>31,n=1;n<7;n++)c[n]=c[n]>>>4*(n-1)+3;c[7]=c[7]<<5|c[7]>>>27}var d=this._invSubKeys=[];for(n=0;n<16;n++)d[n]=s[15-n]},encryptBlock:function(e,t){this._doCryptBlock(e,t,this._subKeys)},decryptBlock:function(e,t){this._doCryptBlock(e,t,this._invSubKeys)},_doCryptBlock:function(e,t,n){this._lBlock=e[t],this._rBlock=e[t+1],h.call(this,4,252645135),h.call(this,16,65535),f.call(this,2,858993459),f.call(this,8,16711935),h.call(this,1,1431655765);for(var r=0;r<16;r++){for(var s=n[r],a=this._lBlock,i=this._rBlock,o=0,l=0;l<8;l++)o|=c[l][((i^s[l])&u[l])>>>0];this._lBlock=i,this._rBlock=a^o}var d=this._lBlock;this._lBlock=this._rBlock,this._rBlock=d,h.call(this,1,1431655765),f.call(this,8,16711935),f.call(this,2,858993459),h.call(this,16,65535),h.call(this,4,252645135),e[t]=this._lBlock,e[t+1]=this._rBlock},keySize:2,ivSize:2,blockSize:2});function h(e,t){var n=(this._lBlock>>>e^this._rBlock)&t;this._rBlock^=n,this._lBlock^=n<<e}function f(e,t){var n=(this._rBlock>>>e^this._lBlock)&t;this._lBlock^=n,this._rBlock^=n<<e}e.DES=s._createHelper(d);var p=a.TripleDES=s.extend({_doReset:function(){var e=this._key.words;if(2!==e.length&&4!==e.length&&e.length<6)throw new Error("Invalid key length - 3DES requires the key length to be 64, 128, 192 or >192.");var t=e.slice(0,2),n=e.length<4?e.slice(0,2):e.slice(2,4),s=e.length<6?e.slice(0,2):e.slice(4,6);this._des1=d.createEncryptor(r.create(t)),this._des2=d.createEncryptor(r.create(n)),this._des3=d.createEncryptor(r.create(s))},encryptBlock:function(e,t){this._des1.encryptBlock(e,t),this._des2.decryptBlock(e,t),this._des3.encryptBlock(e,t)},decryptBlock:function(e,t){this._des3.decryptBlock(e,t),this._des2.encryptBlock(e,t),this._des1.decryptBlock(e,t)},keySize:6,ivSize:2,blockSize:2});e.TripleDES=s._createHelper(p)}(),t.TripleDES)}()},5790(e,t,n){!function(){var t;e.exports=(t=n(1551),function(e){var n=t,r=n.lib,s=r.Base,a=r.WordArray,i=n.x64={};i.Word=s.extend({init:function(e,t){this.high=e,this.low=t}}),i.WordArray=s.extend({init:function(t,n){t=this.words=t||[],this.sigBytes=n!=e?n:8*t.length},toX32:function(){for(var e=this.words,t=e.length,n=[],r=0;r<t;r++){var s=e[r];n.push(s.high),n.push(s.low)}return a.create(n,this.sigBytes)},clone:function(){for(var e=s.clone.call(this),t=e.words=this.words.slice(0),n=t.length,r=0;r<n;r++)t[r]=t[r].clone();return e}})}(),t)}()},8702(e){"use strict";var t={single_source_shortest_paths:function(e,n,r){var s={},a={};a[n]=0;var i,o,l,c,u,d,h,f=t.PriorityQueue.make();for(f.push(n,0);!f.empty();)for(l in o=(i=f.pop()).value,c=i.cost,u=e[o]||{})u.hasOwnProperty(l)&&(d=c+u[l],h=a[l],("undefined"===typeof a[l]||h>d)&&(a[l]=d,f.push(l,d),s[l]=o));if("undefined"!==typeof r&&"undefined"===typeof a[r]){var p=["Could not find a path from ",n," to ",r,"."].join("");throw new Error(p)}return s},extract_shortest_path_from_predecessor_list:function(e,t){for(var n=[],r=t;r;)n.push(r),e[r],r=e[r];return n.reverse(),n},find_path:function(e,n,r){var s=t.single_source_shortest_paths(e,n,r);return t.extract_shortest_path_from_predecessor_list(s,r)},PriorityQueue:{make:function(e){var n,r=t.PriorityQueue,s={};for(n in e=e||{},r)r.hasOwnProperty(n)&&(s[n]=r[n]);return s.queue=[],s.sorter=e.sorter||r.default_sorter,s},default_sorter:function(e,t){return e.cost-t.cost},push:function(e,t){var n={value:e,cost:t};this.queue.push(n),this.queue.sort(this.sorter)},pop:function(){return this.queue.shift()},empty:function(){return 0===this.queue.length}}};e.exports=t},7385(e,t,n){!function(e){"use strict";function t(e){return null===e||void 0===e}var r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};function s(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}function a(e,t){var n=Object.setPrototypeOf;n?n(e,t):e.__proto__=t}function i(e,t){void 0===t&&(t=e.constructor);var n=Error.captureStackTrace;n&&n(e,t)}var o,l=function(e){function t(t){var n=this.constructor,r=e.call(this,t)||this;return Object.defineProperty(r,"name",{value:n.name,enumerable:!1}),a(r,n.prototype),i(r),r}return s(t,e),t}(Error);class c extends l{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:void 0;super(e),this.message=e}getKind(){return this.constructor.kind}}c.kind="Exception";class u extends c{}u.kind="ArgumentException";class d extends c{}d.kind="IllegalArgumentException";class h{constructor(e){if(this.binarizer=e,null===e)throw new d("Binarizer must be non-null.")}getWidth(){return this.binarizer.getWidth()}getHeight(){return this.binarizer.getHeight()}getBlackRow(e,t){return this.binarizer.getBlackRow(e,t)}getBlackMatrix(){return null!==this.matrix&&void 0!==this.matrix||(this.matrix=this.binarizer.getBlackMatrix()),this.matrix}isCropSupported(){return this.binarizer.getLuminanceSource().isCropSupported()}crop(e,t,n,r){const s=this.binarizer.getLuminanceSource().crop(e,t,n,r);return new h(this.binarizer.createBinarizer(s))}isRotateSupported(){return this.binarizer.getLuminanceSource().isRotateSupported()}rotateCounterClockwise(){const e=this.binarizer.getLuminanceSource().rotateCounterClockwise();return new h(this.binarizer.createBinarizer(e))}rotateCounterClockwise45(){const e=this.binarizer.getLuminanceSource().rotateCounterClockwise45();return new h(this.binarizer.createBinarizer(e))}toString(){try{return this.getBlackMatrix().toString()}catch(e){return""}}}class f extends c{static getChecksumInstance(){return new f}}f.kind="ChecksumException";class p{constructor(e){this.source=e}getLuminanceSource(){return this.source}getWidth(){return this.source.getWidth()}getHeight(){return this.source.getHeight()}}class m{static arraycopy(e,t,n,r,s){for(;s--;)n[r++]=e[t++]}static currentTimeMillis(){return Date.now()}}class g extends c{}g.kind="IndexOutOfBoundsException";class y extends g{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:void 0,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;super(t),this.index=e,this.message=t}}y.kind="ArrayIndexOutOfBoundsException";class w{static fill(e,t){for(let n=0,r=e.length;n<r;n++)e[n]=t}static fillWithin(e,t,n,r){w.rangeCheck(e.length,t,n);for(let s=t;s<n;s++)e[s]=r}static rangeCheck(e,t,n){if(t>n)throw new d("fromIndex("+t+") > toIndex("+n+")");if(t<0)throw new y(t);if(n>e)throw new y(n)}static asList(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return t}static create(e,t,n){return Array.from({length:e}).map(e=>Array.from({length:t}).fill(n))}static createInt32Array(e,t,n){return Array.from({length:e}).map(e=>Int32Array.from({length:t}).fill(n))}static equals(e,t){if(!e)return!1;if(!t)return!1;if(!e.length)return!1;if(!t.length)return!1;if(e.length!==t.length)return!1;for(let n=0,r=e.length;n<r;n++)if(e[n]!==t[n])return!1;return!0}static hashCode(e){if(null===e)return 0;let t=1;for(const n of e)t=31*t+n;return t}static fillUint8Array(e,t){for(let n=0;n!==e.length;n++)e[n]=t}static copyOf(e,t){return e.slice(0,t)}static copyOfUint8Array(e,t){if(e.length<=t){const n=new Uint8Array(t);return n.set(e),n}return e.slice(0,t)}static copyOfRange(e,t,n){const r=n-t,s=new Int32Array(r);return m.arraycopy(e,t,s,0,r),s}static binarySearch(e,t,n){void 0===n&&(n=w.numberComparator);let r=0,s=e.length-1;for(;r<=s;){const a=s+r>>1,i=n(t,e[a]);if(i>0)r=a+1;else{if(!(i<0))return a;s=a-1}}return-r-1}static numberComparator(e,t){return e-t}}class v{static numberOfTrailingZeros(e){let t;if(0===e)return 32;let n=31;return t=e<<16,0!==t&&(n-=16,e=t),t=e<<8,0!==t&&(n-=8,e=t),t=e<<4,0!==t&&(n-=4,e=t),t=e<<2,0!==t&&(n-=2,e=t),n-(e<<1>>>31)}static numberOfLeadingZeros(e){if(0===e)return 32;let t=1;return e>>>16===0&&(t+=16,e<<=16),e>>>24===0&&(t+=8,e<<=8),e>>>28===0&&(t+=4,e<<=4),e>>>30===0&&(t+=2,e<<=2),t-=e>>>31,t}static toHexString(e){return e.toString(16)}static toBinaryString(e){return String(parseInt(String(e),2))}static bitCount(e){return e=(e=(858993459&(e-=e>>>1&1431655765))+(e>>>2&858993459))+(e>>>4)&252645135,e+=e>>>8,63&(e+=e>>>16)}static truncDivision(e,t){return Math.trunc(e/t)}static parseInt(e){return parseInt(e,arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0)}}v.MIN_VALUE_32_BITS=-2147483648,v.MAX_VALUE=Number.MAX_SAFE_INTEGER;class A{constructor(e,t){void 0===e?(this.size=0,this.bits=new Int32Array(1)):(this.size=e,this.bits=void 0===t||null===t?A.makeArray(e):t)}getSize(){return this.size}getSizeInBytes(){return Math.floor((this.size+7)/8)}ensureCapacity(e){if(e>32*this.bits.length){const t=A.makeArray(e);m.arraycopy(this.bits,0,t,0,this.bits.length),this.bits=t}}get(e){return 0!==(this.bits[Math.floor(e/32)]&1<<(31&e))}set(e){this.bits[Math.floor(e/32)]|=1<<(31&e)}flip(e){this.bits[Math.floor(e/32)]^=1<<(31&e)}getNextSet(e){const t=this.size;if(e>=t)return t;const n=this.bits;let r=Math.floor(e/32),s=n[r];s&=~((1<<(31&e))-1);const a=n.length;for(;0===s;){if(++r===a)return t;s=n[r]}const i=32*r+v.numberOfTrailingZeros(s);return i>t?t:i}getNextUnset(e){const t=this.size;if(e>=t)return t;const n=this.bits;let r=Math.floor(e/32),s=~n[r];s&=~((1<<(31&e))-1);const a=n.length;for(;0===s;){if(++r===a)return t;s=~n[r]}const i=32*r+v.numberOfTrailingZeros(s);return i>t?t:i}setBulk(e,t){this.bits[Math.floor(e/32)]=t}setRange(e,t){if(t<e||e<0||t>this.size)throw new d;if(t===e)return;t--;const n=Math.floor(e/32),r=Math.floor(t/32),s=this.bits;for(let a=n;a<=r;a++){const i=(2<<(a<r?31:31&t))-(1<<(a>n?0:31&e));s[a]|=i}}clear(){const e=this.bits.length,t=this.bits;for(let n=0;n<e;n++)t[n]=0}isRange(e,t,n){if(t<e||e<0||t>this.size)throw new d;if(t===e)return!0;t--;const r=Math.floor(e/32),s=Math.floor(t/32),a=this.bits;for(let i=r;i<=s;i++){const o=(2<<(i<s?31:31&t))-(1<<(i>r?0:31&e))&4294967295;if((a[i]&o)!==(n?o:0))return!1}return!0}appendBit(e){this.ensureCapacity(this.size+1),e&&(this.bits[Math.floor(this.size/32)]|=1<<(31&this.size)),this.size++}appendBits(e,t){if(t<0||t>32)throw new d("Num bits must be between 0 and 32");this.ensureCapacity(this.size+t);for(let n=t;n>0;n--)this.appendBit(1===(e>>n-1&1))}appendBitArray(e){const t=e.size;this.ensureCapacity(this.size+t);for(let n=0;n<t;n++)this.appendBit(e.get(n))}xor(e){if(this.size!==e.size)throw new d("Sizes don't match");const t=this.bits;for(let n=0,r=t.length;n<r;n++)t[n]^=e.bits[n]}toBytes(e,t,n,r){for(let s=0;s<r;s++){let r=0;for(let t=0;t<8;t++)this.get(e)&&(r|=1<<7-t),e++;t[n+s]=r}}getBitArray(){return this.bits}reverse(){const e=new Int32Array(this.bits.length),t=Math.floor((this.size-1)/32),n=t+1,r=this.bits;for(let s=0;s<n;s++){let n=r[s];n=n>>1&1431655765|(1431655765&n)<<1,n=n>>2&858993459|(858993459&n)<<2,n=n>>4&252645135|(252645135&n)<<4,n=n>>8&16711935|(16711935&n)<<8,n=n>>16&65535|(65535&n)<<16,e[t-s]=n}if(this.size!==32*n){const t=32*n-this.size;let r=e[0]>>>t;for(let s=1;s<n;s++){const n=e[s];r|=n<<32-t,e[s-1]=r,r=n>>>t}e[n-1]=r}this.bits=e}static makeArray(e){return new Int32Array(Math.floor((e+31)/32))}equals(e){if(!(e instanceof A))return!1;const t=e;return this.size===t.size&&w.equals(this.bits,t.bits)}hashCode(){return 31*this.size+w.hashCode(this.bits)}toString(){let e="";for(let t=0,n=this.size;t<n;t++)0===(7&t)&&(e+=" "),e+=this.get(t)?"X":".";return e}clone(){return new A(this.size,this.bits.slice())}}!function(e){e[e.OTHER=0]="OTHER",e[e.PURE_BARCODE=1]="PURE_BARCODE",e[e.POSSIBLE_FORMATS=2]="POSSIBLE_FORMATS",e[e.TRY_HARDER=3]="TRY_HARDER",e[e.CHARACTER_SET=4]="CHARACTER_SET",e[e.ALLOWED_LENGTHS=5]="ALLOWED_LENGTHS",e[e.ASSUME_CODE_39_CHECK_DIGIT=6]="ASSUME_CODE_39_CHECK_DIGIT",e[e.ASSUME_GS1=7]="ASSUME_GS1",e[e.RETURN_CODABAR_START_END=8]="RETURN_CODABAR_START_END",e[e.NEED_RESULT_POINT_CALLBACK=9]="NEED_RESULT_POINT_CALLBACK",e[e.ALLOWED_EAN_EXTENSIONS=10]="ALLOWED_EAN_EXTENSIONS"}(o||(o={}));var b,x=o;class S extends c{static getFormatInstance(){return new S}}S.kind="FormatException",function(e){e[e.Cp437=0]="Cp437",e[e.ISO8859_1=1]="ISO8859_1",e[e.ISO8859_2=2]="ISO8859_2",e[e.ISO8859_3=3]="ISO8859_3",e[e.ISO8859_4=4]="ISO8859_4",e[e.ISO8859_5=5]="ISO8859_5",e[e.ISO8859_6=6]="ISO8859_6",e[e.ISO8859_7=7]="ISO8859_7",e[e.ISO8859_8=8]="ISO8859_8",e[e.ISO8859_9=9]="ISO8859_9",e[e.ISO8859_10=10]="ISO8859_10",e[e.ISO8859_11=11]="ISO8859_11",e[e.ISO8859_13=12]="ISO8859_13",e[e.ISO8859_14=13]="ISO8859_14",e[e.ISO8859_15=14]="ISO8859_15",e[e.ISO8859_16=15]="ISO8859_16",e[e.SJIS=16]="SJIS",e[e.Cp1250=17]="Cp1250",e[e.Cp1251=18]="Cp1251",e[e.Cp1252=19]="Cp1252",e[e.Cp1256=20]="Cp1256",e[e.UnicodeBigUnmarked=21]="UnicodeBigUnmarked",e[e.UTF8=22]="UTF8",e[e.ASCII=23]="ASCII",e[e.Big5=24]="Big5",e[e.GB18030=25]="GB18030",e[e.EUC_KR=26]="EUC_KR"}(b||(b={}));class C{constructor(e,t,n){this.valueIdentifier=e,this.name=n,this.values="number"===typeof t?Int32Array.from([t]):t;for(var r=arguments.length,s=new Array(r>3?r-3:0),a=3;a<r;a++)s[a-3]=arguments[a];this.otherEncodingNames=s,C.VALUE_IDENTIFIER_TO_ECI.set(e,this),C.NAME_TO_ECI.set(n,this);const i=this.values;for(let o=0,l=i.length;o!==l;o++){const e=i[o];C.VALUES_TO_ECI.set(e,this)}for(const o of s)C.NAME_TO_ECI.set(o,this)}getValueIdentifier(){return this.valueIdentifier}getName(){return this.name}getValue(){return this.values[0]}static getCharacterSetECIByValue(e){if(e<0||e>=900)throw new S("incorect value");const t=C.VALUES_TO_ECI.get(e);if(void 0===t)throw new S("incorect value");return t}static getCharacterSetECIByName(e){const t=C.NAME_TO_ECI.get(e);if(void 0===t)throw new S("incorect value");return t}equals(e){if(!(e instanceof C))return!1;const t=e;return this.getName()===t.getName()}}C.VALUE_IDENTIFIER_TO_ECI=new Map,C.VALUES_TO_ECI=new Map,C.NAME_TO_ECI=new Map,C.Cp437=new C(b.Cp437,Int32Array.from([0,2]),"Cp437"),C.ISO8859_1=new C(b.ISO8859_1,Int32Array.from([1,3]),"ISO-8859-1","ISO88591","ISO8859_1"),C.ISO8859_2=new C(b.ISO8859_2,4,"ISO-8859-2","ISO88592","ISO8859_2"),C.ISO8859_3=new C(b.ISO8859_3,5,"ISO-8859-3","ISO88593","ISO8859_3"),C.ISO8859_4=new C(b.ISO8859_4,6,"ISO-8859-4","ISO88594","ISO8859_4"),C.ISO8859_5=new C(b.ISO8859_5,7,"ISO-8859-5","ISO88595","ISO8859_5"),C.ISO8859_6=new C(b.ISO8859_6,8,"ISO-8859-6","ISO88596","ISO8859_6"),C.ISO8859_7=new C(b.ISO8859_7,9,"ISO-8859-7","ISO88597","ISO8859_7"),C.ISO8859_8=new C(b.ISO8859_8,10,"ISO-8859-8","ISO88598","ISO8859_8"),C.ISO8859_9=new C(b.ISO8859_9,11,"ISO-8859-9","ISO88599","ISO8859_9"),C.ISO8859_10=new C(b.ISO8859_10,12,"ISO-8859-10","ISO885910","ISO8859_10"),C.ISO8859_11=new C(b.ISO8859_11,13,"ISO-8859-11","ISO885911","ISO8859_11"),C.ISO8859_13=new C(b.ISO8859_13,15,"ISO-8859-13","ISO885913","ISO8859_13"),C.ISO8859_14=new C(b.ISO8859_14,16,"ISO-8859-14","ISO885914","ISO8859_14"),C.ISO8859_15=new C(b.ISO8859_15,17,"ISO-8859-15","ISO885915","ISO8859_15"),C.ISO8859_16=new C(b.ISO8859_16,18,"ISO-8859-16","ISO885916","ISO8859_16"),C.SJIS=new C(b.SJIS,20,"SJIS","Shift_JIS"),C.Cp1250=new C(b.Cp1250,21,"Cp1250","windows-1250"),C.Cp1251=new C(b.Cp1251,22,"Cp1251","windows-1251"),C.Cp1252=new C(b.Cp1252,23,"Cp1252","windows-1252"),C.Cp1256=new C(b.Cp1256,24,"Cp1256","windows-1256"),C.UnicodeBigUnmarked=new C(b.UnicodeBigUnmarked,25,"UnicodeBigUnmarked","UTF-16BE","UnicodeBig"),C.UTF8=new C(b.UTF8,26,"UTF8","UTF-8"),C.ASCII=new C(b.ASCII,Int32Array.from([27,170]),"ASCII","US-ASCII"),C.Big5=new C(b.Big5,28,"Big5"),C.GB18030=new C(b.GB18030,29,"GB18030","GB2312","EUC_CN","GBK"),C.EUC_KR=new C(b.EUC_KR,30,"EUC_KR","EUC-KR");class E extends c{}E.kind="UnsupportedOperationException";class N{static decode(e,t){const n=this.encodingName(t);return this.customDecoder?this.customDecoder(e,n):"undefined"===typeof TextDecoder||this.shouldDecodeOnFallback(n)?this.decodeFallback(e,n):new TextDecoder(n).decode(e)}static shouldDecodeOnFallback(e){return!N.isBrowser()&&"ISO-8859-1"===e}static encode(e,t){const n=this.encodingName(t);return this.customEncoder?this.customEncoder(e,n):"undefined"===typeof TextEncoder?this.encodeFallback(e):(new TextEncoder).encode(e)}static isBrowser(){return"undefined"!==typeof window&&"[object Window]"==={}.toString.call(window)}static encodingName(e){return"string"===typeof e?e:e.getName()}static encodingCharacterSet(e){return e instanceof C?e:C.getCharacterSetECIByName(e)}static decodeFallback(e,t){const n=this.encodingCharacterSet(t);if(N.isDecodeFallbackSupported(n)){let t="";for(let n=0,r=e.length;n<r;n++){let r=e[n].toString(16);r.length<2&&(r="0"+r),t+="%"+r}return decodeURIComponent(t)}if(n.equals(C.UnicodeBigUnmarked))return String.fromCharCode.apply(null,new Uint16Array(e.buffer));throw new E("Encoding ".concat(this.encodingName(t)," not supported by fallback."))}static isDecodeFallbackSupported(e){return e.equals(C.UTF8)||e.equals(C.ISO8859_1)||e.equals(C.ASCII)}static encodeFallback(e){const t=btoa(unescape(encodeURIComponent(e))).split(""),n=[];for(let r=0;r<t.length;r++)n.push(t[r].charCodeAt(0));return new Uint8Array(n)}}class k{static castAsNonUtf8Char(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const n=t?t.getName():this.ISO88591;return N.decode(new Uint8Array([e]),n)}static guessEncoding(e,t){if(null!==t&&void 0!==t&&void 0!==t.get(x.CHARACTER_SET))return t.get(x.CHARACTER_SET).toString();const n=e.length;let r=!0,s=!0,a=!0,i=0,o=0,l=0,c=0,u=0,d=0,h=0,f=0,p=0,m=0,g=0;const y=e.length>3&&239===e[0]&&187===e[1]&&191===e[2];for(let w=0;w<n&&(r||s||a);w++){const t=255&e[w];a&&(i>0?0===(128&t)?a=!1:i--:0!==(128&t)&&(0===(64&t)?a=!1:(i++,0===(32&t)?o++:(i++,0===(16&t)?l++:(i++,0===(8&t)?c++:a=!1))))),r&&(t>127&&t<160?r=!1:t>159&&(t<192||215===t||247===t)&&g++),s&&(u>0?t<64||127===t||t>252?s=!1:u--:128===t||160===t||t>239?s=!1:t>160&&t<224?(d++,f=0,h++,h>p&&(p=h)):t>127?(u++,h=0,f++,f>m&&(m=f)):(h=0,f=0))}return a&&i>0&&(a=!1),s&&u>0&&(s=!1),a&&(y||o+l+c>0)?k.UTF8:s&&(k.ASSUME_SHIFT_JIS||p>=3||m>=3)?k.SHIFT_JIS:r&&s?2===p&&2===d||10*g>=n?k.SHIFT_JIS:k.ISO88591:r?k.ISO88591:s?k.SHIFT_JIS:a?k.UTF8:k.PLATFORM_DEFAULT_ENCODING}static format(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];let s=-1;function a(e,t,r,a,i,o){if("%%"===e)return"%";if(void 0===n[++s])return;e=a?parseInt(a.substr(1)):void 0;let l,c=i?parseInt(i.substr(1)):void 0;switch(o){case"s":l=n[s];break;case"c":l=n[s][0];break;case"f":l=parseFloat(n[s]).toFixed(e);break;case"p":l=parseFloat(n[s]).toPrecision(e);break;case"e":l=parseFloat(n[s]).toExponential(e);break;case"x":l=parseInt(n[s]).toString(c||16);break;case"d":l=parseFloat(parseInt(n[s],c||10).toPrecision(e)).toFixed(0)}l="object"===typeof l?JSON.stringify(l):(+l).toString(c);let u=parseInt(r),d=r&&r[0]+""==="0"?"0":" ";for(;l.length<u;)l=void 0!==t?l+d:d+l;return l}let i=/%(-)?(0?[0-9]+)?([.][0-9]+)?([#][0-9]+)?([scfpexd%])/g;return e.replace(i,a)}static getBytes(e,t){return N.encode(e,t)}static getCharCode(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return e.charCodeAt(t)}static getCharAt(e){return String.fromCharCode(e)}}k.SHIFT_JIS=C.SJIS.getName(),k.GB2312="GB2312",k.ISO88591=C.ISO8859_1.getName(),k.EUC_JP="EUC_JP",k.UTF8=C.UTF8.getName(),k.PLATFORM_DEFAULT_ENCODING=k.UTF8,k.ASSUME_SHIFT_JIS=!1;class T{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"";this.value=e}enableDecoding(e){return this.encoding=e,this}append(e){return"string"===typeof e?this.value+=e.toString():this.encoding?this.value+=k.castAsNonUtf8Char(e,this.encoding):this.value+=String.fromCharCode(e),this}appendChars(e,t,n){for(let r=t;t<t+n;r++)this.append(e[r]);return this}length(){return this.value.length}charAt(e){return this.value.charAt(e)}deleteCharAt(e){this.value=this.value.substr(0,e)+this.value.substring(e+1)}setCharAt(e,t){this.value=this.value.substr(0,e)+t+this.value.substr(e+1)}substring(e,t){return this.value.substring(e,t)}setLengthToZero(){this.value=""}toString(){return this.value}insert(e,t){this.value=this.value.substr(0,e)+t+this.value.substr(e+t.length)}}class I{constructor(e,t,n,r){if(this.width=e,this.height=t,this.rowSize=n,this.bits=r,void 0!==t&&null!==t||(t=e),this.height=t,e<1||t<1)throw new d("Both dimensions must be greater than 0");void 0!==n&&null!==n||(n=Math.floor((e+31)/32)),this.rowSize=n,void 0!==r&&null!==r||(this.bits=new Int32Array(this.rowSize*this.height))}static parseFromBooleanArray(e){const t=e.length,n=e[0].length,r=new I(n,t);for(let s=0;s<t;s++){const t=e[s];for(let e=0;e<n;e++)t[e]&&r.set(e,s)}return r}static parseFromString(e,t,n){if(null===e)throw new d("stringRepresentation cannot be null");const r=new Array(e.length);let s=0,a=0,i=-1,o=0,l=0;for(;l<e.length;)if("\n"===e.charAt(l)||"\r"===e.charAt(l)){if(s>a){if(-1===i)i=s-a;else if(s-a!==i)throw new d("row lengths do not match");a=s,o++}l++}else if(e.substring(l,l+t.length)===t)l+=t.length,r[s]=!0,s++;else{if(e.substring(l,l+n.length)!==n)throw new d("illegal character encountered: "+e.substring(l));l+=n.length,r[s]=!1,s++}if(s>a){if(-1===i)i=s-a;else if(s-a!==i)throw new d("row lengths do not match");o++}const c=new I(i,o);for(let u=0;u<s;u++)r[u]&&c.set(Math.floor(u%i),Math.floor(u/i));return c}get(e,t){const n=t*this.rowSize+Math.floor(e/32);return 0!==(this.bits[n]>>>(31&e)&1)}set(e,t){const n=t*this.rowSize+Math.floor(e/32);this.bits[n]|=1<<(31&e)&4294967295}unset(e,t){const n=t*this.rowSize+Math.floor(e/32);this.bits[n]&=~(1<<(31&e)&4294967295)}flip(e,t){const n=t*this.rowSize+Math.floor(e/32);this.bits[n]^=1<<(31&e)&4294967295}xor(e){if(this.width!==e.getWidth()||this.height!==e.getHeight()||this.rowSize!==e.getRowSize())throw new d("input matrix dimensions do not match");const t=new A(Math.floor(this.width/32)+1),n=this.rowSize,r=this.bits;for(let s=0,a=this.height;s<a;s++){const a=s*n,i=e.getRow(s,t).getBitArray();for(let e=0;e<n;e++)r[a+e]^=i[e]}}clear(){const e=this.bits,t=e.length;for(let n=0;n<t;n++)e[n]=0}setRegion(e,t,n,r){if(t<0||e<0)throw new d("Left and top must be nonnegative");if(r<1||n<1)throw new d("Height and width must be at least 1");const s=e+n,a=t+r;if(a>this.height||s>this.width)throw new d("The region must fit inside the matrix");const i=this.rowSize,o=this.bits;for(let l=t;l<a;l++){const t=l*i;for(let n=e;n<s;n++)o[t+Math.floor(n/32)]|=1<<(31&n)&4294967295}}getRow(e,t){null===t||void 0===t||t.getSize()<this.width?t=new A(this.width):t.clear();const n=this.rowSize,r=this.bits,s=e*n;for(let a=0;a<n;a++)t.setBulk(32*a,r[s+a]);return t}setRow(e,t){m.arraycopy(t.getBitArray(),0,this.bits,e*this.rowSize,this.rowSize)}rotate180(){const e=this.getWidth(),t=this.getHeight();let n=new A(e),r=new A(e);for(let s=0,a=Math.floor((t+1)/2);s<a;s++)n=this.getRow(s,n),r=this.getRow(t-1-s,r),n.reverse(),r.reverse(),this.setRow(s,r),this.setRow(t-1-s,n)}getEnclosingRectangle(){const e=this.width,t=this.height,n=this.rowSize,r=this.bits;let s=e,a=t,i=-1,o=-1;for(let l=0;l<t;l++)for(let e=0;e<n;e++){const t=r[l*n+e];if(0!==t){if(l<a&&(a=l),l>o&&(o=l),32*e<s){let n=0;for(;0===(t<<31-n&4294967295);)n++;32*e+n<s&&(s=32*e+n)}if(32*e+31>i){let n=31;for(;t>>>n===0;)n--;32*e+n>i&&(i=32*e+n)}}}return i<s||o<a?null:Int32Array.from([s,a,i-s+1,o-a+1])}getTopLeftOnBit(){const e=this.rowSize,t=this.bits;let n=0;for(;n<t.length&&0===t[n];)n++;if(n===t.length)return null;const r=n/e;let s=n%e*32;const a=t[n];let i=0;for(;0===(a<<31-i&4294967295);)i++;return s+=i,Int32Array.from([s,r])}getBottomRightOnBit(){const e=this.rowSize,t=this.bits;let n=t.length-1;for(;n>=0&&0===t[n];)n--;if(n<0)return null;const r=Math.floor(n/e);let s=32*Math.floor(n%e);const a=t[n];let i=31;for(;a>>>i===0;)i--;return s+=i,Int32Array.from([s,r])}getWidth(){return this.width}getHeight(){return this.height}getRowSize(){return this.rowSize}equals(e){if(!(e instanceof I))return!1;const t=e;return this.width===t.width&&this.height===t.height&&this.rowSize===t.rowSize&&w.equals(this.bits,t.bits)}hashCode(){let e=this.width;return e=31*e+this.width,e=31*e+this.height,e=31*e+this.rowSize,e=31*e+w.hashCode(this.bits),e}toString(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"X ",t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"  ",n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"\n";return this.buildToString(e,t,n)}buildToString(e,t,n){let r=new T;for(let s=0,a=this.height;s<a;s++){for(let n=0,a=this.width;n<a;n++)r.append(this.get(n,s)?e:t);r.append(n)}return r.toString()}clone(){return new I(this.width,this.height,this.rowSize,this.bits.slice())}}class _ extends c{static getNotFoundInstance(){return new _}}_.kind="NotFoundException";class R extends p{constructor(e){super(e),this.luminances=R.EMPTY,this.buckets=new Int32Array(R.LUMINANCE_BUCKETS)}getBlackRow(e,t){const n=this.getLuminanceSource(),r=n.getWidth();void 0===t||null===t||t.getSize()<r?t=new A(r):t.clear(),this.initArrays(r);const s=n.getRow(e,this.luminances),a=this.buckets;for(let o=0;o<r;o++)a[(255&s[o])>>R.LUMINANCE_SHIFT]++;const i=R.estimateBlackPoint(a);if(r<3)for(let o=0;o<r;o++)(255&s[o])<i&&t.set(o);else{let e=255&s[0],n=255&s[1];for(let a=1;a<r-1;a++){const r=255&s[a+1];(4*n-e-r)/2<i&&t.set(a),e=n,n=r}}return t}getBlackMatrix(){const e=this.getLuminanceSource(),t=e.getWidth(),n=e.getHeight(),r=new I(t,n);this.initArrays(t);const s=this.buckets;for(let o=1;o<5;o++){const r=Math.floor(n*o/5),a=e.getRow(r,this.luminances),i=Math.floor(4*t/5);for(let e=Math.floor(t/5);e<i;e++)s[(255&a[e])>>R.LUMINANCE_SHIFT]++}const a=R.estimateBlackPoint(s),i=e.getMatrix();for(let o=0;o<n;o++){const e=o*t;for(let n=0;n<t;n++)(255&i[e+n])<a&&r.set(n,o)}return r}createBinarizer(e){return new R(e)}initArrays(e){this.luminances.length<e&&(this.luminances=new Uint8ClampedArray(e));const t=this.buckets;for(let n=0;n<R.LUMINANCE_BUCKETS;n++)t[n]=0}static estimateBlackPoint(e){const t=e.length;let n=0,r=0,s=0;for(let c=0;c<t;c++)e[c]>s&&(r=c,s=e[c]),e[c]>n&&(n=e[c]);let a=0,i=0;for(let c=0;c<t;c++){const t=c-r,n=e[c]*t*t;n>i&&(a=c,i=n)}if(r>a){const e=r;r=a,a=e}if(a-r<=t/16)throw new _;let o=a-1,l=-1;for(let c=a-1;c>r;c--){const t=c-r,s=t*t*(a-c)*(n-e[c]);s>l&&(o=c,l=s)}return o<<R.LUMINANCE_SHIFT}}R.LUMINANCE_BITS=5,R.LUMINANCE_SHIFT=8-R.LUMINANCE_BITS,R.LUMINANCE_BUCKETS=1<<R.LUMINANCE_BITS,R.EMPTY=Uint8ClampedArray.from([0]);class M extends R{constructor(e){super(e),this.matrix=null}getBlackMatrix(){if(null!==this.matrix)return this.matrix;const e=this.getLuminanceSource(),t=e.getWidth(),n=e.getHeight();if(t>=M.MINIMUM_DIMENSION&&n>=M.MINIMUM_DIMENSION){const r=e.getMatrix();let s=t>>M.BLOCK_SIZE_POWER;0!==(t&M.BLOCK_SIZE_MASK)&&s++;let a=n>>M.BLOCK_SIZE_POWER;0!==(n&M.BLOCK_SIZE_MASK)&&a++;const i=M.calculateBlackPoints(r,s,a,t,n),o=new I(t,n);M.calculateThresholdForBlock(r,s,a,t,n,i,o),this.matrix=o}else this.matrix=super.getBlackMatrix();return this.matrix}createBinarizer(e){return new M(e)}static calculateThresholdForBlock(e,t,n,r,s,a,i){const o=s-M.BLOCK_SIZE,l=r-M.BLOCK_SIZE;for(let c=0;c<n;c++){let s=c<<M.BLOCK_SIZE_POWER;s>o&&(s=o);const u=M.cap(c,2,n-3);for(let n=0;n<t;n++){let o=n<<M.BLOCK_SIZE_POWER;o>l&&(o=l);const c=M.cap(n,2,t-3);let d=0;for(let e=-2;e<=2;e++){const t=a[u+e];d+=t[c-2]+t[c-1]+t[c]+t[c+1]+t[c+2]}const h=d/25;M.thresholdBlock(e,o,s,h,r,i)}}}static cap(e,t,n){return e<t?t:e>n?n:e}static thresholdBlock(e,t,n,r,s,a){for(let i=0,o=n*s+t;i<M.BLOCK_SIZE;i++,o+=s)for(let s=0;s<M.BLOCK_SIZE;s++)(255&e[o+s])<=r&&a.set(t+s,n+i)}static calculateBlackPoints(e,t,n,r,s){const a=s-M.BLOCK_SIZE,i=r-M.BLOCK_SIZE,o=new Array(n);for(let l=0;l<n;l++){o[l]=new Int32Array(t);let n=l<<M.BLOCK_SIZE_POWER;n>a&&(n=a);for(let s=0;s<t;s++){let t=s<<M.BLOCK_SIZE_POWER;t>i&&(t=i);let a=0,c=255,u=0;for(let s=0,i=n*r+t;s<M.BLOCK_SIZE;s++,i+=r){for(let t=0;t<M.BLOCK_SIZE;t++){const n=255&e[i+t];a+=n,n<c&&(c=n),n>u&&(u=n)}if(u-c>M.MIN_DYNAMIC_RANGE)for(s++,i+=r;s<M.BLOCK_SIZE;s++,i+=r)for(let t=0;t<M.BLOCK_SIZE;t++)a+=255&e[i+t]}let d=a>>2*M.BLOCK_SIZE_POWER;if(u-c<=M.MIN_DYNAMIC_RANGE&&(d=c/2,l>0&&s>0)){const e=(o[l-1][s]+2*o[l][s-1]+o[l-1][s-1])/4;c<e&&(d=e)}o[l][s]=d}}return o}}M.BLOCK_SIZE_POWER=3,M.BLOCK_SIZE=1<<M.BLOCK_SIZE_POWER,M.BLOCK_SIZE_MASK=M.BLOCK_SIZE-1,M.MINIMUM_DIMENSION=5*M.BLOCK_SIZE,M.MIN_DYNAMIC_RANGE=24;class D{constructor(e,t){this.width=e,this.height=t}getWidth(){return this.width}getHeight(){return this.height}isCropSupported(){return!1}crop(e,t,n,r){throw new E("This luminance source does not support cropping.")}isRotateSupported(){return!1}rotateCounterClockwise(){throw new E("This luminance source does not support rotation by 90 degrees.")}rotateCounterClockwise45(){throw new E("This luminance source does not support rotation by 45 degrees.")}toString(){const e=new Uint8ClampedArray(this.width);let t=new T;for(let n=0;n<this.height;n++){const r=this.getRow(n,e);for(let e=0;e<this.width;e++){const n=255&r[e];let s;s=n<64?"#":n<128?"+":n<192?".":" ",t.append(s)}t.append("\n")}return t.toString()}}class j extends D{constructor(e){super(e.getWidth(),e.getHeight()),this.delegate=e}getRow(e,t){const n=this.delegate.getRow(e,t),r=this.getWidth();for(let s=0;s<r;s++)n[s]=255-(255&n[s]);return n}getMatrix(){const e=this.delegate.getMatrix(),t=this.getWidth()*this.getHeight(),n=new Uint8ClampedArray(t);for(let r=0;r<t;r++)n[r]=255-(255&e[r]);return n}isCropSupported(){return this.delegate.isCropSupported()}crop(e,t,n,r){return new j(this.delegate.crop(e,t,n,r))}isRotateSupported(){return this.delegate.isRotateSupported()}invert(){return this.delegate}rotateCounterClockwise(){return new j(this.delegate.rotateCounterClockwise())}rotateCounterClockwise45(){return new j(this.delegate.rotateCounterClockwise45())}}class O extends D{constructor(e){super(e.width,e.height),this.canvas=e,this.tempCanvasElement=null,this.buffer=O.makeBufferFromCanvasImageData(e)}static makeBufferFromCanvasImageData(e){const t=e.getContext("2d").getImageData(0,0,e.width,e.height);return O.toGrayscaleBuffer(t.data,e.width,e.height)}static toGrayscaleBuffer(e,t,n){const r=new Uint8ClampedArray(t*n);for(let s=0,a=0,i=e.length;s<i;s+=4,a++){let t;t=0===e[s+3]?255:306*e[s]+601*e[s+1]+117*e[s+2]+512>>10,r[a]=t}return r}getRow(e,t){if(e<0||e>=this.getHeight())throw new d("Requested row is outside the image: "+e);const n=this.getWidth(),r=e*n;return null===t?t=this.buffer.slice(r,r+n):(t.length<n&&(t=new Uint8ClampedArray(n)),t.set(this.buffer.slice(r,r+n))),t}getMatrix(){return this.buffer}isCropSupported(){return!0}crop(e,t,n,r){return super.crop(e,t,n,r),this}isRotateSupported(){return!0}rotateCounterClockwise(){return this.rotate(-90),this}rotateCounterClockwise45(){return this.rotate(-45),this}getTempCanvasElement(){if(null===this.tempCanvasElement){const e=this.canvas.ownerDocument.createElement("canvas");e.width=this.canvas.width,e.height=this.canvas.height,this.tempCanvasElement=e}return this.tempCanvasElement}rotate(e){const t=this.getTempCanvasElement(),n=t.getContext("2d"),r=e*O.DEGREE_TO_RADIANS,s=this.canvas.width,a=this.canvas.height,i=Math.ceil(Math.abs(Math.cos(r))*s+Math.abs(Math.sin(r))*a),o=Math.ceil(Math.abs(Math.sin(r))*s+Math.abs(Math.cos(r))*a);return t.width=i,t.height=o,n.translate(i/2,o/2),n.rotate(r),n.drawImage(this.canvas,s/-2,a/-2),this.buffer=O.makeBufferFromCanvasImageData(t),this}invert(){return new j(this)}}O.DEGREE_TO_RADIANS=Math.PI/180;class P{constructor(e,t,n){this.deviceId=e,this.label=t,this.kind="videoinput",this.groupId=n||void 0}toJSON(){return{kind:this.kind,groupId:this.groupId,deviceId:this.deviceId,label:this.label}}}var L,B=(globalThis||n.g||self||window?(globalThis||n.g||self||window||void 0).__awaiter:void 0)||function(e,t,n,r){function s(e){return e instanceof n?e:new n(function(t){t(e)})}return new(n||(n=Promise))(function(n,a){function i(e){try{l(r.next(e))}catch(t){a(t)}}function o(e){try{l(r.throw(e))}catch(t){a(t)}}function l(e){e.done?n(e.value):s(e.value).then(i,o)}l((r=r.apply(e,t||[])).next())})};class F{constructor(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:500,n=arguments.length>2?arguments[2]:void 0;this.reader=e,this.timeBetweenScansMillis=t,this._hints=n,this._stopContinuousDecode=!1,this._stopAsyncDecode=!1,this._timeBetweenDecodingAttempts=0}get hasNavigator(){return"undefined"!==typeof navigator}get isMediaDevicesSuported(){return this.hasNavigator&&!!navigator.mediaDevices}get canEnumerateDevices(){return!(!this.isMediaDevicesSuported||!navigator.mediaDevices.enumerateDevices)}get timeBetweenDecodingAttempts(){return this._timeBetweenDecodingAttempts}set timeBetweenDecodingAttempts(e){this._timeBetweenDecodingAttempts=e<0?0:e}set hints(e){this._hints=e||null}get hints(){return this._hints}listVideoInputDevices(){return B(this,void 0,void 0,function*(){if(!this.hasNavigator)throw new Error("Can't enumerate devices, navigator is not present.");if(!this.canEnumerateDevices)throw new Error("Can't enumerate devices, method not supported.");const e=yield navigator.mediaDevices.enumerateDevices(),t=[];for(const n of e){const e="video"===n.kind?"videoinput":n.kind;if("videoinput"!==e)continue;const r={deviceId:n.deviceId||n.id,label:n.label||"Video device ".concat(t.length+1),kind:e,groupId:n.groupId};t.push(r)}return t})}getVideoInputDevices(){return B(this,void 0,void 0,function*(){return(yield this.listVideoInputDevices()).map(e=>new P(e.deviceId,e.label))})}findDeviceById(e){return B(this,void 0,void 0,function*(){const t=yield this.listVideoInputDevices();return t?t.find(t=>t.deviceId===e):null})}decodeFromInputVideoDevice(e,t){return B(this,void 0,void 0,function*(){return yield this.decodeOnceFromVideoDevice(e,t)})}decodeOnceFromVideoDevice(e,t){return B(this,void 0,void 0,function*(){let n;this.reset(),n=e?{deviceId:{exact:e}}:{facingMode:"environment"};const r={video:n};return yield this.decodeOnceFromConstraints(r,t)})}decodeOnceFromConstraints(e,t){return B(this,void 0,void 0,function*(){const n=yield navigator.mediaDevices.getUserMedia(e);return yield this.decodeOnceFromStream(n,t)})}decodeOnceFromStream(e,t){return B(this,void 0,void 0,function*(){this.reset();const n=yield this.attachStreamToVideo(e,t);return yield this.decodeOnce(n)})}decodeFromInputVideoDeviceContinuously(e,t,n){return B(this,void 0,void 0,function*(){return yield this.decodeFromVideoDevice(e,t,n)})}decodeFromVideoDevice(e,t,n){return B(this,void 0,void 0,function*(){let r;r=e?{deviceId:{exact:e}}:{facingMode:"environment"};const s={video:r};return yield this.decodeFromConstraints(s,t,n)})}decodeFromConstraints(e,t,n){return B(this,void 0,void 0,function*(){const r=yield navigator.mediaDevices.getUserMedia(e);return yield this.decodeFromStream(r,t,n)})}decodeFromStream(e,t,n){return B(this,void 0,void 0,function*(){this.reset();const r=yield this.attachStreamToVideo(e,t);return yield this.decodeContinuously(r,n)})}stopAsyncDecode(){this._stopAsyncDecode=!0}stopContinuousDecode(){this._stopContinuousDecode=!0}attachStreamToVideo(e,t){return B(this,void 0,void 0,function*(){const n=this.prepareVideoElement(t);return this.addVideoSource(n,e),this.videoElement=n,this.stream=e,yield this.playVideoOnLoadAsync(n),n})}playVideoOnLoadAsync(e){return new Promise((t,n)=>this.playVideoOnLoad(e,()=>t()))}playVideoOnLoad(e,t){this.videoEndedListener=()=>this.stopStreams(),this.videoCanPlayListener=()=>this.tryPlayVideo(e),e.addEventListener("ended",this.videoEndedListener),e.addEventListener("canplay",this.videoCanPlayListener),e.addEventListener("playing",t),this.tryPlayVideo(e)}isVideoPlaying(e){return e.currentTime>0&&!e.paused&&!e.ended&&e.readyState>2}tryPlayVideo(e){return B(this,void 0,void 0,function*(){if(this.isVideoPlaying(e))console.warn("Trying to play video that is already playing.");else try{yield e.play()}catch(t){console.warn("It was not possible to play the video.")}})}getMediaElement(e,t){const n=document.getElementById(e);if(!n)throw new u("element with id '".concat(e,"' not found"));if(n.nodeName.toLowerCase()!==t.toLowerCase())throw new u("element with id '".concat(e,"' must be an ").concat(t," element"));return n}decodeFromImage(e,t){if(!e&&!t)throw new u("either imageElement with a src set or an url must be provided");return t&&!e?this.decodeFromImageUrl(t):this.decodeFromImageElement(e)}decodeFromVideo(e,t){if(!e&&!t)throw new u("Either an element with a src set or an URL must be provided");return t&&!e?this.decodeFromVideoUrl(t):this.decodeFromVideoElement(e)}decodeFromVideoContinuously(e,t,n){if(void 0===e&&void 0===t)throw new u("Either an element with a src set or an URL must be provided");return t&&!e?this.decodeFromVideoUrlContinuously(t,n):this.decodeFromVideoElementContinuously(e,n)}decodeFromImageElement(e){if(!e)throw new u("An image element must be provided.");this.reset();const t=this.prepareImageElement(e);let n;return this.imageElement=t,n=this.isImageLoaded(t)?this.decodeOnce(t,!1,!0):this._decodeOnLoadImage(t),n}decodeFromVideoElement(e){const t=this._decodeFromVideoElementSetup(e);return this._decodeOnLoadVideo(t)}decodeFromVideoElementContinuously(e,t){const n=this._decodeFromVideoElementSetup(e);return this._decodeOnLoadVideoContinuously(n,t)}_decodeFromVideoElementSetup(e){if(!e)throw new u("A video element must be provided.");this.reset();const t=this.prepareVideoElement(e);return this.videoElement=t,t}decodeFromImageUrl(e){if(!e)throw new u("An URL must be provided.");this.reset();const t=this.prepareImageElement();this.imageElement=t;const n=this._decodeOnLoadImage(t);return t.src=e,n}decodeFromVideoUrl(e){if(!e)throw new u("An URL must be provided.");this.reset();const t=this.prepareVideoElement(),n=this.decodeFromVideoElement(t);return t.src=e,n}decodeFromVideoUrlContinuously(e,t){if(!e)throw new u("An URL must be provided.");this.reset();const n=this.prepareVideoElement(),r=this.decodeFromVideoElementContinuously(n,t);return n.src=e,r}_decodeOnLoadImage(e){return new Promise((t,n)=>{this.imageLoadedListener=()=>this.decodeOnce(e,!1,!0).then(t,n),e.addEventListener("load",this.imageLoadedListener)})}_decodeOnLoadVideo(e){return B(this,void 0,void 0,function*(){return yield this.playVideoOnLoadAsync(e),yield this.decodeOnce(e)})}_decodeOnLoadVideoContinuously(e,t){return B(this,void 0,void 0,function*(){yield this.playVideoOnLoadAsync(e),this.decodeContinuously(e,t)})}isImageLoaded(e){return!!e.complete&&0!==e.naturalWidth}prepareImageElement(e){let t;return"undefined"===typeof e&&(t=document.createElement("img"),t.width=200,t.height=200),"string"===typeof e&&(t=this.getMediaElement(e,"img")),e instanceof HTMLImageElement&&(t=e),t}prepareVideoElement(e){let t;return e||"undefined"===typeof document||(t=document.createElement("video"),t.width=200,t.height=200),"string"===typeof e&&(t=this.getMediaElement(e,"video")),e instanceof HTMLVideoElement&&(t=e),t.setAttribute("autoplay","true"),t.setAttribute("muted","true"),t.setAttribute("playsinline","true"),t}decodeOnce(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],n=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];this._stopAsyncDecode=!1;const r=(s,a)=>{if(this._stopAsyncDecode)return a(new _("Video stream has ended before any code could be detected.")),void(this._stopAsyncDecode=void 0);try{s(this.decode(e))}catch(i){if(t&&i instanceof _||(i instanceof f||i instanceof S)&&n)return setTimeout(r,this._timeBetweenDecodingAttempts,s,a);a(i)}};return new Promise((e,t)=>r(e,t))}decodeContinuously(e,t){this._stopContinuousDecode=!1;const n=()=>{if(this._stopContinuousDecode)this._stopContinuousDecode=void 0;else try{const r=this.decode(e);t(r,null),setTimeout(n,this.timeBetweenScansMillis)}catch(r){t(null,r),(r instanceof f||r instanceof S||r instanceof _)&&setTimeout(n,this._timeBetweenDecodingAttempts)}};n()}decode(e){const t=this.createBinaryBitmap(e);return this.decodeBitmap(t)}_isHTMLVideoElement(e){return 0!==e.videoWidth}drawFrameOnCanvas(e,t,n){t||(t={sx:0,sy:0,sWidth:e.videoWidth,sHeight:e.videoHeight,dx:0,dy:0,dWidth:e.videoWidth,dHeight:e.videoHeight}),n||(n=this.captureCanvasContext),n.drawImage(e,t.sx,t.sy,t.sWidth,t.sHeight,t.dx,t.dy,t.dWidth,t.dHeight)}drawImageOnCanvas(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:this.captureCanvasContext;t||(t={sx:0,sy:0,sWidth:e.naturalWidth,sHeight:e.naturalHeight,dx:0,dy:0,dWidth:e.naturalWidth,dHeight:e.naturalHeight}),n||(n=this.captureCanvasContext),n.drawImage(e,t.sx,t.sy,t.sWidth,t.sHeight,t.dx,t.dy,t.dWidth,t.dHeight)}createBinaryBitmap(e){this.getCaptureCanvasContext(e),this._isHTMLVideoElement(e)?this.drawFrameOnCanvas(e):this.drawImageOnCanvas(e);const t=this.getCaptureCanvas(e),n=new O(t),r=new M(n);return new h(r)}getCaptureCanvasContext(e){if(!this.captureCanvasContext){const t=this.getCaptureCanvas(e).getContext("2d");this.captureCanvasContext=t}return this.captureCanvasContext}getCaptureCanvas(e){if(!this.captureCanvas){const t=this.createCaptureCanvas(e);this.captureCanvas=t}return this.captureCanvas}decodeBitmap(e){return this.reader.decode(e,this._hints)}createCaptureCanvas(e){if("undefined"===typeof document)return this._destroyCaptureCanvas(),null;const t=document.createElement("canvas");let n,r;return"undefined"!==typeof e&&(e instanceof HTMLVideoElement?(n=e.videoWidth,r=e.videoHeight):e instanceof HTMLImageElement&&(n=e.naturalWidth||e.width,r=e.naturalHeight||e.height)),t.style.width=n+"px",t.style.height=r+"px",t.width=n,t.height=r,t}stopStreams(){this.stream&&(this.stream.getVideoTracks().forEach(e=>e.stop()),this.stream=void 0),!1===this._stopAsyncDecode&&this.stopAsyncDecode(),!1===this._stopContinuousDecode&&this.stopContinuousDecode()}reset(){this.stopStreams(),this._destroyVideoElement(),this._destroyImageElement(),this._destroyCaptureCanvas()}_destroyVideoElement(){this.videoElement&&("undefined"!==typeof this.videoEndedListener&&this.videoElement.removeEventListener("ended",this.videoEndedListener),"undefined"!==typeof this.videoPlayingEventListener&&this.videoElement.removeEventListener("playing",this.videoPlayingEventListener),"undefined"!==typeof this.videoCanPlayListener&&this.videoElement.removeEventListener("loadedmetadata",this.videoCanPlayListener),this.cleanVideoSource(this.videoElement),this.videoElement=void 0)}_destroyImageElement(){this.imageElement&&(void 0!==this.imageLoadedListener&&this.imageElement.removeEventListener("load",this.imageLoadedListener),this.imageElement.src=void 0,this.imageElement.removeAttribute("src"),this.imageElement=void 0)}_destroyCaptureCanvas(){this.captureCanvasContext=void 0,this.captureCanvas=void 0}addVideoSource(e,t){try{e.srcObject=t}catch(n){e.src=URL.createObjectURL(t)}}cleanVideoSource(e){try{e.srcObject=null}catch(t){e.src=""}this.videoElement.removeAttribute("src")}}class U{constructor(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null==t?0:8*t.length,r=arguments.length>3?arguments[3]:void 0,s=arguments.length>4?arguments[4]:void 0,a=arguments.length>5&&void 0!==arguments[5]?arguments[5]:m.currentTimeMillis();this.text=e,this.rawBytes=t,this.numBits=n,this.resultPoints=r,this.format=s,this.timestamp=a,this.text=e,this.rawBytes=t,this.numBits=void 0===n||null===n?null===t||void 0===t?0:8*t.length:n,this.resultPoints=r,this.format=s,this.resultMetadata=null,this.timestamp=void 0===a||null===a?m.currentTimeMillis():a}getText(){return this.text}getRawBytes(){return this.rawBytes}getNumBits(){return this.numBits}getResultPoints(){return this.resultPoints}getBarcodeFormat(){return this.format}getResultMetadata(){return this.resultMetadata}putMetadata(e,t){null===this.resultMetadata&&(this.resultMetadata=new Map),this.resultMetadata.set(e,t)}putAllMetadata(e){null!==e&&(null===this.resultMetadata?this.resultMetadata=e:this.resultMetadata=new Map(e))}addResultPoints(e){const t=this.resultPoints;if(null===t)this.resultPoints=e;else if(null!==e&&e.length>0){const n=new Array(t.length+e.length);m.arraycopy(t,0,n,0,t.length),m.arraycopy(e,0,n,t.length,e.length),this.resultPoints=n}}getTimestamp(){return this.timestamp}toString(){return this.text}}!function(e){e[e.AZTEC=0]="AZTEC",e[e.CODABAR=1]="CODABAR",e[e.CODE_39=2]="CODE_39",e[e.CODE_93=3]="CODE_93",e[e.CODE_128=4]="CODE_128",e[e.DATA_MATRIX=5]="DATA_MATRIX",e[e.EAN_8=6]="EAN_8",e[e.EAN_13=7]="EAN_13",e[e.ITF=8]="ITF",e[e.MAXICODE=9]="MAXICODE",e[e.PDF_417=10]="PDF_417",e[e.QR_CODE=11]="QR_CODE",e[e.RSS_14=12]="RSS_14",e[e.RSS_EXPANDED=13]="RSS_EXPANDED",e[e.UPC_A=14]="UPC_A",e[e.UPC_E=15]="UPC_E",e[e.UPC_EAN_EXTENSION=16]="UPC_EAN_EXTENSION"}(L||(L={}));var W,z=L;!function(e){e[e.OTHER=0]="OTHER",e[e.ORIENTATION=1]="ORIENTATION",e[e.BYTE_SEGMENTS=2]="BYTE_SEGMENTS",e[e.ERROR_CORRECTION_LEVEL=3]="ERROR_CORRECTION_LEVEL",e[e.ISSUE_NUMBER=4]="ISSUE_NUMBER",e[e.SUGGESTED_PRICE=5]="SUGGESTED_PRICE",e[e.POSSIBLE_COUNTRY=6]="POSSIBLE_COUNTRY",e[e.UPC_EAN_EXTENSION=7]="UPC_EAN_EXTENSION",e[e.PDF417_EXTRA_METADATA=8]="PDF417_EXTRA_METADATA",e[e.STRUCTURED_APPEND_SEQUENCE=9]="STRUCTURED_APPEND_SEQUENCE",e[e.STRUCTURED_APPEND_PARITY=10]="STRUCTURED_APPEND_PARITY"}(W||(W={}));var H,V,G,J,Q,K,Y=W;class q{constructor(e,t,n,r){let s=arguments.length>4&&void 0!==arguments[4]?arguments[4]:-1,a=arguments.length>5&&void 0!==arguments[5]?arguments[5]:-1;this.rawBytes=e,this.text=t,this.byteSegments=n,this.ecLevel=r,this.structuredAppendSequenceNumber=s,this.structuredAppendParity=a,this.numBits=void 0===e||null===e?0:8*e.length}getRawBytes(){return this.rawBytes}getNumBits(){return this.numBits}setNumBits(e){this.numBits=e}getText(){return this.text}getByteSegments(){return this.byteSegments}getECLevel(){return this.ecLevel}getErrorsCorrected(){return this.errorsCorrected}setErrorsCorrected(e){this.errorsCorrected=e}getErasures(){return this.erasures}setErasures(e){this.erasures=e}getOther(){return this.other}setOther(e){this.other=e}hasStructuredAppend(){return this.structuredAppendParity>=0&&this.structuredAppendSequenceNumber>=0}getStructuredAppendParity(){return this.structuredAppendParity}getStructuredAppendSequenceNumber(){return this.structuredAppendSequenceNumber}}class X{exp(e){return this.expTable[e]}log(e){if(0===e)throw new d;return this.logTable[e]}static addOrSubtract(e,t){return e^t}}class Z{constructor(e,t){if(0===t.length)throw new d;this.field=e;const n=t.length;if(n>1&&0===t[0]){let e=1;for(;e<n&&0===t[e];)e++;e===n?this.coefficients=Int32Array.from([0]):(this.coefficients=new Int32Array(n-e),m.arraycopy(t,e,this.coefficients,0,this.coefficients.length))}else this.coefficients=t}getCoefficients(){return this.coefficients}getDegree(){return this.coefficients.length-1}isZero(){return 0===this.coefficients[0]}getCoefficient(e){return this.coefficients[this.coefficients.length-1-e]}evaluateAt(e){if(0===e)return this.getCoefficient(0);const t=this.coefficients;let n;if(1===e){n=0;for(let e=0,r=t.length;e!==r;e++){const r=t[e];n=X.addOrSubtract(n,r)}return n}n=t[0];const r=t.length,s=this.field;for(let a=1;a<r;a++)n=X.addOrSubtract(s.multiply(e,n),t[a]);return n}addOrSubtract(e){if(!this.field.equals(e.field))throw new d("GenericGFPolys do not have same GenericGF field");if(this.isZero())return e;if(e.isZero())return this;let t=this.coefficients,n=e.coefficients;if(t.length>n.length){const e=t;t=n,n=e}let r=new Int32Array(n.length);const s=n.length-t.length;m.arraycopy(n,0,r,0,s);for(let a=s;a<n.length;a++)r[a]=X.addOrSubtract(t[a-s],n[a]);return new Z(this.field,r)}multiply(e){if(!this.field.equals(e.field))throw new d("GenericGFPolys do not have same GenericGF field");if(this.isZero()||e.isZero())return this.field.getZero();const t=this.coefficients,n=t.length,r=e.coefficients,s=r.length,a=new Int32Array(n+s-1),i=this.field;for(let o=0;o<n;o++){const e=t[o];for(let t=0;t<s;t++)a[o+t]=X.addOrSubtract(a[o+t],i.multiply(e,r[t]))}return new Z(i,a)}multiplyScalar(e){if(0===e)return this.field.getZero();if(1===e)return this;const t=this.coefficients.length,n=this.field,r=new Int32Array(t),s=this.coefficients;for(let a=0;a<t;a++)r[a]=n.multiply(s[a],e);return new Z(n,r)}multiplyByMonomial(e,t){if(e<0)throw new d;if(0===t)return this.field.getZero();const n=this.coefficients,r=n.length,s=new Int32Array(r+e),a=this.field;for(let i=0;i<r;i++)s[i]=a.multiply(n[i],t);return new Z(a,s)}divide(e){if(!this.field.equals(e.field))throw new d("GenericGFPolys do not have same GenericGF field");if(e.isZero())throw new d("Divide by 0");const t=this.field;let n=t.getZero(),r=this;const s=e.getCoefficient(e.getDegree()),a=t.inverse(s);for(;r.getDegree()>=e.getDegree()&&!r.isZero();){const s=r.getDegree()-e.getDegree(),i=t.multiply(r.getCoefficient(r.getDegree()),a),o=e.multiplyByMonomial(s,i),l=t.buildMonomial(s,i);n=n.addOrSubtract(l),r=r.addOrSubtract(o)}return[n,r]}toString(){let e="";for(let t=this.getDegree();t>=0;t--){let n=this.getCoefficient(t);if(0!==n){if(n<0?(e+=" - ",n=-n):e.length>0&&(e+=" + "),0===t||1!==n){const t=this.field.log(n);0===t?e+="1":1===t?e+="a":(e+="a^",e+=t)}0!==t&&(1===t?e+="x":(e+="x^",e+=t))}}return e}}class $ extends c{}$.kind="ArithmeticException";class ee extends X{constructor(e,t,n){super(),this.primitive=e,this.size=t,this.generatorBase=n;const r=new Int32Array(t);let s=1;for(let i=0;i<t;i++)r[i]=s,s*=2,s>=t&&(s^=e,s&=t-1);this.expTable=r;const a=new Int32Array(t);for(let i=0;i<t-1;i++)a[r[i]]=i;this.logTable=a,this.zero=new Z(this,Int32Array.from([0])),this.one=new Z(this,Int32Array.from([1]))}getZero(){return this.zero}getOne(){return this.one}buildMonomial(e,t){if(e<0)throw new d;if(0===t)return this.zero;const n=new Int32Array(e+1);return n[0]=t,new Z(this,n)}inverse(e){if(0===e)throw new $;return this.expTable[this.size-this.logTable[e]-1]}multiply(e,t){return 0===e||0===t?0:this.expTable[(this.logTable[e]+this.logTable[t])%(this.size-1)]}getSize(){return this.size}getGeneratorBase(){return this.generatorBase}toString(){return"GF(0x"+v.toHexString(this.primitive)+","+this.size+")"}equals(e){return e===this}}ee.AZTEC_DATA_12=new ee(4201,4096,1),ee.AZTEC_DATA_10=new ee(1033,1024,1),ee.AZTEC_DATA_6=new ee(67,64,1),ee.AZTEC_PARAM=new ee(19,16,1),ee.QR_CODE_FIELD_256=new ee(285,256,0),ee.DATA_MATRIX_FIELD_256=new ee(301,256,1),ee.AZTEC_DATA_8=ee.DATA_MATRIX_FIELD_256,ee.MAXICODE_FIELD_64=ee.AZTEC_DATA_6;class te extends c{}te.kind="ReedSolomonException";class ne extends c{}ne.kind="IllegalStateException";class re{constructor(e){this.field=e}decode(e,t){const n=this.field,r=new Z(n,e),s=new Int32Array(t);let a=!0;for(let h=0;h<t;h++){const e=r.evaluateAt(n.exp(h+n.getGeneratorBase()));s[s.length-1-h]=e,0!==e&&(a=!1)}if(a)return;const i=new Z(n,s),o=this.runEuclideanAlgorithm(n.buildMonomial(t,1),i,t),l=o[0],c=o[1],u=this.findErrorLocations(l),d=this.findErrorMagnitudes(c,u);for(let h=0;h<u.length;h++){const t=e.length-1-n.log(u[h]);if(t<0)throw new te("Bad error location");e[t]=ee.addOrSubtract(e[t],d[h])}}runEuclideanAlgorithm(e,t,n){if(e.getDegree()<t.getDegree()){const n=e;e=t,t=n}const r=this.field;let s=e,a=t,i=r.getZero(),o=r.getOne();for(;a.getDegree()>=(n/2|0);){let e=s,t=i;if(s=a,i=o,s.isZero())throw new te("r_{i-1} was zero");a=e;let n=r.getZero();const l=s.getCoefficient(s.getDegree()),c=r.inverse(l);for(;a.getDegree()>=s.getDegree()&&!a.isZero();){const e=a.getDegree()-s.getDegree(),t=r.multiply(a.getCoefficient(a.getDegree()),c);n=n.addOrSubtract(r.buildMonomial(e,t)),a=a.addOrSubtract(s.multiplyByMonomial(e,t))}if(o=n.multiply(i).addOrSubtract(t),a.getDegree()>=s.getDegree())throw new ne("Division algorithm failed to reduce polynomial?")}const l=o.getCoefficient(0);if(0===l)throw new te("sigmaTilde(0) was zero");const c=r.inverse(l);return[o.multiplyScalar(c),a.multiplyScalar(c)]}findErrorLocations(e){const t=e.getDegree();if(1===t)return Int32Array.from([e.getCoefficient(1)]);const n=new Int32Array(t);let r=0;const s=this.field;for(let a=1;a<s.getSize()&&r<t;a++)0===e.evaluateAt(a)&&(n[r]=s.inverse(a),r++);if(r!==t)throw new te("Error locator degree does not match number of roots");return n}findErrorMagnitudes(e,t){const n=t.length,r=new Int32Array(n),s=this.field;for(let a=0;a<n;a++){const i=s.inverse(t[a]);let o=1;for(let e=0;e<n;e++)if(a!==e){const n=s.multiply(t[e],i),r=0===(1&n)?1|n:-2&n;o=s.multiply(o,r)}r[a]=s.multiply(e.evaluateAt(i),s.inverse(o)),0!==s.getGeneratorBase()&&(r[a]=s.multiply(r[a],i))}return r}}!function(e){e[e.UPPER=0]="UPPER",e[e.LOWER=1]="LOWER",e[e.MIXED=2]="MIXED",e[e.DIGIT=3]="DIGIT",e[e.PUNCT=4]="PUNCT",e[e.BINARY=5]="BINARY"}(H||(H={}));class se{decode(e){this.ddata=e;let t=e.getBits(),n=this.extractBits(t),r=this.correctBits(n),s=se.convertBoolArrayToByteArray(r),a=se.getEncodedData(r),i=new q(s,a,null,null);return i.setNumBits(r.length),i}static highLevelDecode(e){return this.getEncodedData(e)}static getEncodedData(e){let t=e.length,n=H.UPPER,r=H.UPPER,s="",a=0;for(;a<t;)if(r===H.BINARY){if(t-a<5)break;let i=se.readCode(e,a,5);if(a+=5,0===i){if(t-a<11)break;i=se.readCode(e,a,11)+31,a+=11}for(let n=0;n<i;n++){if(t-a<8){a=t;break}const n=se.readCode(e,a,8);s+=k.castAsNonUtf8Char(n),a+=8}r=n}else{let i=r===H.DIGIT?4:5;if(t-a<i)break;let o=se.readCode(e,a,i);a+=i;let l=se.getCharacter(r,o);l.startsWith("CTRL_")?(n=r,r=se.getTable(l.charAt(5)),"L"===l.charAt(6)&&(n=r)):(s+=l,r=n)}return s}static getTable(e){switch(e){case"L":return H.LOWER;case"P":return H.PUNCT;case"M":return H.MIXED;case"D":return H.DIGIT;case"B":return H.BINARY;default:return H.UPPER}}static getCharacter(e,t){switch(e){case H.UPPER:return se.UPPER_TABLE[t];case H.LOWER:return se.LOWER_TABLE[t];case H.MIXED:return se.MIXED_TABLE[t];case H.PUNCT:return se.PUNCT_TABLE[t];case H.DIGIT:return se.DIGIT_TABLE[t];default:throw new ne("Bad table")}}correctBits(e){let t,n;this.ddata.getNbLayers()<=2?(n=6,t=ee.AZTEC_DATA_6):this.ddata.getNbLayers()<=8?(n=8,t=ee.AZTEC_DATA_8):this.ddata.getNbLayers()<=22?(n=10,t=ee.AZTEC_DATA_10):(n=12,t=ee.AZTEC_DATA_12);let r=this.ddata.getNbDatablocks(),s=e.length/n;if(s<r)throw new S;let a=e.length%n,i=new Int32Array(s);for(let h=0;h<s;h++,a+=n)i[h]=se.readCode(e,a,n);try{new re(t).decode(i,s-r)}catch(d){throw new S(d)}let o=(1<<n)-1,l=0;for(let h=0;h<r;h++){let e=i[h];if(0===e||e===o)throw new S;1!==e&&e!==o-1||l++}let c=new Array(r*n-l),u=0;for(let h=0;h<r;h++){let e=i[h];if(1===e||e===o-1)c.fill(e>1,u,u+n-1),u+=n-1;else for(let t=n-1;t>=0;--t)c[u++]=0!==(e&1<<t)}return c}extractBits(e){let t=this.ddata.isCompact(),n=this.ddata.getNbLayers(),r=(t?11:14)+4*n,s=new Int32Array(r),a=new Array(this.totalBitsInLayer(n,t));if(t)for(let i=0;i<s.length;i++)s[i]=i;else{let e=r+1+2*v.truncDivision(v.truncDivision(r,2)-1,15),t=r/2,n=v.truncDivision(e,2);for(let r=0;r<t;r++){let e=r+v.truncDivision(r,15);s[t-r-1]=n-e-1,s[t+r]=n+e+1}}for(let i=0,o=0;i<n;i++){let l=4*(n-i)+(t?9:12),c=2*i,u=r-1-c;for(let t=0;t<l;t++){let n=2*t;for(let r=0;r<2;r++)a[o+n+r]=e.get(s[c+r],s[c+t]),a[o+2*l+n+r]=e.get(s[c+t],s[u-r]),a[o+4*l+n+r]=e.get(s[u-r],s[u-t]),a[o+6*l+n+r]=e.get(s[u-t],s[c+r])}o+=8*l}return a}static readCode(e,t,n){let r=0;for(let s=t;s<t+n;s++)r<<=1,e[s]&&(r|=1);return r}static readByte(e,t){let n=e.length-t;return n>=8?se.readCode(e,t,8):se.readCode(e,t,n)<<8-n}static convertBoolArrayToByteArray(e){let t=new Uint8Array((e.length+7)/8);for(let n=0;n<t.length;n++)t[n]=se.readByte(e,8*n);return t}totalBitsInLayer(e,t){return((t?88:112)+16*e)*e}}se.UPPER_TABLE=["CTRL_PS"," ","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","CTRL_LL","CTRL_ML","CTRL_DL","CTRL_BS"],se.LOWER_TABLE=["CTRL_PS"," ","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","CTRL_US","CTRL_ML","CTRL_DL","CTRL_BS"],se.MIXED_TABLE=["CTRL_PS"," ","\\1","\\2","\\3","\\4","\\5","\\6","\\7","\b","\t","\n","\\13","\f","\r","\\33","\\34","\\35","\\36","\\37","@","\\","^","_","`","|","~","\\177","CTRL_LL","CTRL_UL","CTRL_PL","CTRL_BS"],se.PUNCT_TABLE=["","\r","\r\n",". ",", ",": ","!",'"',"#","$","%","&","'","(",")","*","+",",","-",".","/",":",";","<","=",">","?","[","]","{","}","CTRL_UL"],se.DIGIT_TABLE=["CTRL_PS"," ","0","1","2","3","4","5","6","7","8","9",",",".","CTRL_UL","CTRL_US"];class ae{constructor(){}static round(e){return NaN===e?0:e<=Number.MIN_SAFE_INTEGER?Number.MIN_SAFE_INTEGER:e>=Number.MAX_SAFE_INTEGER?Number.MAX_SAFE_INTEGER:e+(e<0?-.5:.5)|0}static distance(e,t,n,r){const s=e-n,a=t-r;return Math.sqrt(s*s+a*a)}static sum(e){let t=0;for(let n=0,r=e.length;n!==r;n++)t+=e[n];return t}}class ie{static floatToIntBits(e){return e}}ie.MAX_VALUE=Number.MAX_SAFE_INTEGER;class oe{constructor(e,t){this.x=e,this.y=t}getX(){return this.x}getY(){return this.y}equals(e){if(e instanceof oe){const t=e;return this.x===t.x&&this.y===t.y}return!1}hashCode(){return 31*ie.floatToIntBits(this.x)+ie.floatToIntBits(this.y)}toString(){return"("+this.x+","+this.y+")"}static orderBestPatterns(e){const t=this.distance(e[0],e[1]),n=this.distance(e[1],e[2]),r=this.distance(e[0],e[2]);let s,a,i;if(n>=t&&n>=r?(a=e[0],s=e[1],i=e[2]):r>=n&&r>=t?(a=e[1],s=e[0],i=e[2]):(a=e[2],s=e[0],i=e[1]),this.crossProductZ(s,a,i)<0){const e=s;s=i,i=e}e[0]=s,e[1]=a,e[2]=i}static distance(e,t){return ae.distance(e.x,e.y,t.x,t.y)}static crossProductZ(e,t,n){const r=t.x,s=t.y;return(n.x-r)*(e.y-s)-(n.y-s)*(e.x-r)}}class le{constructor(e,t){this.bits=e,this.points=t}getBits(){return this.bits}getPoints(){return this.points}}class ce extends le{constructor(e,t,n,r,s){super(e,t),this.compact=n,this.nbDatablocks=r,this.nbLayers=s}getNbLayers(){return this.nbLayers}getNbDatablocks(){return this.nbDatablocks}isCompact(){return this.compact}}class ue{constructor(e,t,n,r){this.image=e,this.height=e.getHeight(),this.width=e.getWidth(),void 0!==t&&null!==t||(t=ue.INIT_SIZE),void 0!==n&&null!==n||(n=e.getWidth()/2|0),void 0!==r&&null!==r||(r=e.getHeight()/2|0);const s=t/2|0;if(this.leftInit=n-s,this.rightInit=n+s,this.upInit=r-s,this.downInit=r+s,this.upInit<0||this.leftInit<0||this.downInit>=this.height||this.rightInit>=this.width)throw new _}detect(){let e=this.leftInit,t=this.rightInit,n=this.upInit,r=this.downInit,s=!1,a=!0,i=!1,o=!1,l=!1,c=!1,u=!1;const d=this.width,h=this.height;for(;a;){a=!1;let f=!0;for(;(f||!o)&&t<d;)f=this.containsBlackPoint(n,r,t,!1),f?(t++,a=!0,o=!0):o||t++;if(t>=d){s=!0;break}let p=!0;for(;(p||!l)&&r<h;)p=this.containsBlackPoint(e,t,r,!0),p?(r++,a=!0,l=!0):l||r++;if(r>=h){s=!0;break}let m=!0;for(;(m||!c)&&e>=0;)m=this.containsBlackPoint(n,r,e,!1),m?(e--,a=!0,c=!0):c||e--;if(e<0){s=!0;break}let g=!0;for(;(g||!u)&&n>=0;)g=this.containsBlackPoint(e,t,n,!0),g?(n--,a=!0,u=!0):u||n--;if(n<0){s=!0;break}a&&(i=!0)}if(!s&&i){const s=t-e;let a=null;for(let t=1;null===a&&t<s;t++)a=this.getBlackPointOnSegment(e,r-t,e+t,r);if(null==a)throw new _;let i=null;for(let t=1;null===i&&t<s;t++)i=this.getBlackPointOnSegment(e,n+t,e+t,n);if(null==i)throw new _;let o=null;for(let e=1;null===o&&e<s;e++)o=this.getBlackPointOnSegment(t,n+e,t-e,n);if(null==o)throw new _;let l=null;for(let e=1;null===l&&e<s;e++)l=this.getBlackPointOnSegment(t,r-e,t-e,r);if(null==l)throw new _;return this.centerEdges(l,a,o,i)}throw new _}getBlackPointOnSegment(e,t,n,r){const s=ae.round(ae.distance(e,t,n,r)),a=(n-e)/s,i=(r-t)/s,o=this.image;for(let l=0;l<s;l++){const n=ae.round(e+l*a),r=ae.round(t+l*i);if(o.get(n,r))return new oe(n,r)}return null}centerEdges(e,t,n,r){const s=e.getX(),a=e.getY(),i=t.getX(),o=t.getY(),l=n.getX(),c=n.getY(),u=r.getX(),d=r.getY(),h=ue.CORR;return s<this.width/2?[new oe(u-h,d+h),new oe(i+h,o+h),new oe(l-h,c-h),new oe(s+h,a-h)]:[new oe(u+h,d+h),new oe(i+h,o-h),new oe(l-h,c+h),new oe(s-h,a-h)]}containsBlackPoint(e,t,n,r){const s=this.image;if(r){for(let a=e;a<=t;a++)if(s.get(a,n))return!0}else for(let a=e;a<=t;a++)if(s.get(n,a))return!0;return!1}}ue.INIT_SIZE=10,ue.CORR=1;class de{static checkAndNudgePoints(e,t){const n=e.getWidth(),r=e.getHeight();let s=!0;for(let a=0;a<t.length&&s;a+=2){const e=Math.floor(t[a]),i=Math.floor(t[a+1]);if(e<-1||e>n||i<-1||i>r)throw new _;s=!1,-1===e?(t[a]=0,s=!0):e===n&&(t[a]=n-1,s=!0),-1===i?(t[a+1]=0,s=!0):i===r&&(t[a+1]=r-1,s=!0)}s=!0;for(let a=t.length-2;a>=0&&s;a-=2){const e=Math.floor(t[a]),i=Math.floor(t[a+1]);if(e<-1||e>n||i<-1||i>r)throw new _;s=!1,-1===e?(t[a]=0,s=!0):e===n&&(t[a]=n-1,s=!0),-1===i?(t[a+1]=0,s=!0):i===r&&(t[a+1]=r-1,s=!0)}}}class he{constructor(e,t,n,r,s,a,i,o,l){this.a11=e,this.a21=t,this.a31=n,this.a12=r,this.a22=s,this.a32=a,this.a13=i,this.a23=o,this.a33=l}static quadrilateralToQuadrilateral(e,t,n,r,s,a,i,o,l,c,u,d,h,f,p,m){const g=he.quadrilateralToSquare(e,t,n,r,s,a,i,o);return he.squareToQuadrilateral(l,c,u,d,h,f,p,m).times(g)}transformPoints(e){const t=e.length,n=this.a11,r=this.a12,s=this.a13,a=this.a21,i=this.a22,o=this.a23,l=this.a31,c=this.a32,u=this.a33;for(let d=0;d<t;d+=2){const t=e[d],h=e[d+1],f=s*t+o*h+u;e[d]=(n*t+a*h+l)/f,e[d+1]=(r*t+i*h+c)/f}}transformPointsWithValues(e,t){const n=this.a11,r=this.a12,s=this.a13,a=this.a21,i=this.a22,o=this.a23,l=this.a31,c=this.a32,u=this.a33,d=e.length;for(let h=0;h<d;h++){const d=e[h],f=t[h],p=s*d+o*f+u;e[h]=(n*d+a*f+l)/p,t[h]=(r*d+i*f+c)/p}}static squareToQuadrilateral(e,t,n,r,s,a,i,o){const l=e-n+s-i,c=t-r+a-o;if(0===l&&0===c)return new he(n-e,s-n,e,r-t,a-r,t,0,0,1);{const u=n-s,d=i-s,h=r-a,f=o-a,p=u*f-d*h,m=(l*f-d*c)/p,g=(u*c-l*h)/p;return new he(n-e+m*n,i-e+g*i,e,r-t+m*r,o-t+g*o,t,m,g,1)}}static quadrilateralToSquare(e,t,n,r,s,a,i,o){return he.squareToQuadrilateral(e,t,n,r,s,a,i,o).buildAdjoint()}buildAdjoint(){return new he(this.a22*this.a33-this.a23*this.a32,this.a23*this.a31-this.a21*this.a33,this.a21*this.a32-this.a22*this.a31,this.a13*this.a32-this.a12*this.a33,this.a11*this.a33-this.a13*this.a31,this.a12*this.a31-this.a11*this.a32,this.a12*this.a23-this.a13*this.a22,this.a13*this.a21-this.a11*this.a23,this.a11*this.a22-this.a12*this.a21)}times(e){return new he(this.a11*e.a11+this.a21*e.a12+this.a31*e.a13,this.a11*e.a21+this.a21*e.a22+this.a31*e.a23,this.a11*e.a31+this.a21*e.a32+this.a31*e.a33,this.a12*e.a11+this.a22*e.a12+this.a32*e.a13,this.a12*e.a21+this.a22*e.a22+this.a32*e.a23,this.a12*e.a31+this.a22*e.a32+this.a32*e.a33,this.a13*e.a11+this.a23*e.a12+this.a33*e.a13,this.a13*e.a21+this.a23*e.a22+this.a33*e.a23,this.a13*e.a31+this.a23*e.a32+this.a33*e.a33)}}class fe extends de{sampleGrid(e,t,n,r,s,a,i,o,l,c,u,d,h,f,p,m,g,y,w){const v=he.quadrilateralToQuadrilateral(r,s,a,i,o,l,c,u,d,h,f,p,m,g,y,w);return this.sampleGridWithTransform(e,t,n,v)}sampleGridWithTransform(e,t,n,r){if(t<=0||n<=0)throw new _;const s=new I(t,n),a=new Float32Array(2*t);for(let o=0;o<n;o++){const t=a.length,n=o+.5;for(let e=0;e<t;e+=2)a[e]=e/2+.5,a[e+1]=n;r.transformPoints(a),de.checkAndNudgePoints(e,a);try{for(let n=0;n<t;n+=2)e.get(Math.floor(a[n]),Math.floor(a[n+1]))&&s.set(n/2,o)}catch(i){throw new _}}return s}}class pe{static setGridSampler(e){pe.gridSampler=e}static getInstance(){return pe.gridSampler}}pe.gridSampler=new fe;class me{constructor(e,t){this.x=e,this.y=t}toResultPoint(){return new oe(this.getX(),this.getY())}getX(){return this.x}getY(){return this.y}}class ge{constructor(e){this.EXPECTED_CORNER_BITS=new Int32Array([3808,476,2107,1799]),this.image=e}detect(){return this.detectMirror(!1)}detectMirror(e){let t=this.getMatrixCenter(),n=this.getBullsEyeCorners(t);if(e){let e=n[0];n[0]=n[2],n[2]=e}this.extractParameters(n);let r=this.sampleGrid(this.image,n[this.shift%4],n[(this.shift+1)%4],n[(this.shift+2)%4],n[(this.shift+3)%4]),s=this.getMatrixCornerPoints(n);return new ce(r,s,this.compact,this.nbDataBlocks,this.nbLayers)}extractParameters(e){if(!this.isValidPoint(e[0])||!this.isValidPoint(e[1])||!this.isValidPoint(e[2])||!this.isValidPoint(e[3]))throw new _;let t=2*this.nbCenterLayers,n=new Int32Array([this.sampleLine(e[0],e[1],t),this.sampleLine(e[1],e[2],t),this.sampleLine(e[2],e[3],t),this.sampleLine(e[3],e[0],t)]);this.shift=this.getRotation(n,t);let r=0;for(let a=0;a<4;a++){let e=n[(this.shift+a)%4];this.compact?(r<<=7,r+=e>>1&127):(r<<=10,r+=(e>>2&992)+(e>>1&31))}let s=this.getCorrectedParameterData(r,this.compact);this.compact?(this.nbLayers=1+(s>>6),this.nbDataBlocks=1+(63&s)):(this.nbLayers=1+(s>>11),this.nbDataBlocks=1+(2047&s))}getRotation(e,t){let n=0;e.forEach((e,r,s)=>{n=(e>>t-2<<1)+(1&e)+(n<<3)}),n=((1&n)<<11)+(n>>1);for(let r=0;r<4;r++)if(v.bitCount(n^this.EXPECTED_CORNER_BITS[r])<=2)return r;throw new _}getCorrectedParameterData(e,t){let n,r;t?(n=7,r=2):(n=10,r=4);let s=n-r,a=new Int32Array(n);for(let l=n-1;l>=0;--l)a[l]=15&e,e>>=4;try{new re(ee.AZTEC_PARAM).decode(a,s)}catch(o){throw new _}let i=0;for(let l=0;l<r;l++)i=(i<<4)+a[l];return i}getBullsEyeCorners(e){let t=e,n=e,r=e,s=e,a=!0;for(this.nbCenterLayers=1;this.nbCenterLayers<9;this.nbCenterLayers++){let e=this.getFirstDifferent(t,a,1,-1),i=this.getFirstDifferent(n,a,1,1),o=this.getFirstDifferent(r,a,-1,1),l=this.getFirstDifferent(s,a,-1,-1);if(this.nbCenterLayers>2){let n=this.distancePoint(l,e)*this.nbCenterLayers/(this.distancePoint(s,t)*(this.nbCenterLayers+2));if(n<.75||n>1.25||!this.isWhiteOrBlackRectangle(e,i,o,l))break}t=e,n=i,r=o,s=l,a=!a}if(5!==this.nbCenterLayers&&7!==this.nbCenterLayers)throw new _;this.compact=5===this.nbCenterLayers;let i=new oe(t.getX()+.5,t.getY()-.5),o=new oe(n.getX()+.5,n.getY()+.5),l=new oe(r.getX()-.5,r.getY()+.5),c=new oe(s.getX()-.5,s.getY()-.5);return this.expandSquare([i,o,l,c],2*this.nbCenterLayers-3,2*this.nbCenterLayers)}getMatrixCenter(){let e,t,n,r;try{let s=new ue(this.image).detect();e=s[0],t=s[1],n=s[2],r=s[3]}catch(i){let s=this.image.getWidth()/2,a=this.image.getHeight()/2;e=this.getFirstDifferent(new me(s+7,a-7),!1,1,-1).toResultPoint(),t=this.getFirstDifferent(new me(s+7,a+7),!1,1,1).toResultPoint(),n=this.getFirstDifferent(new me(s-7,a+7),!1,-1,1).toResultPoint(),r=this.getFirstDifferent(new me(s-7,a-7),!1,-1,-1).toResultPoint()}let s=ae.round((e.getX()+r.getX()+t.getX()+n.getX())/4),a=ae.round((e.getY()+r.getY()+t.getY()+n.getY())/4);try{let i=new ue(this.image,15,s,a).detect();e=i[0],t=i[1],n=i[2],r=i[3]}catch(i){e=this.getFirstDifferent(new me(s+7,a-7),!1,1,-1).toResultPoint(),t=this.getFirstDifferent(new me(s+7,a+7),!1,1,1).toResultPoint(),n=this.getFirstDifferent(new me(s-7,a+7),!1,-1,1).toResultPoint(),r=this.getFirstDifferent(new me(s-7,a-7),!1,-1,-1).toResultPoint()}return s=ae.round((e.getX()+r.getX()+t.getX()+n.getX())/4),a=ae.round((e.getY()+r.getY()+t.getY()+n.getY())/4),new me(s,a)}getMatrixCornerPoints(e){return this.expandSquare(e,2*this.nbCenterLayers,this.getDimension())}sampleGrid(e,t,n,r,s){let a=pe.getInstance(),i=this.getDimension(),o=i/2-this.nbCenterLayers,l=i/2+this.nbCenterLayers;return a.sampleGrid(e,i,i,o,o,l,o,l,l,o,l,t.getX(),t.getY(),n.getX(),n.getY(),r.getX(),r.getY(),s.getX(),s.getY())}sampleLine(e,t,n){let r=0,s=this.distanceResultPoint(e,t),a=s/n,i=e.getX(),o=e.getY(),l=a*(t.getX()-e.getX())/s,c=a*(t.getY()-e.getY())/s;for(let u=0;u<n;u++)this.image.get(ae.round(i+u*l),ae.round(o+u*c))&&(r|=1<<n-u-1);return r}isWhiteOrBlackRectangle(e,t,n,r){let s=3;e=new me(e.getX()-s,e.getY()+s),t=new me(t.getX()-s,t.getY()-s),n=new me(n.getX()+s,n.getY()-s),r=new me(r.getX()+s,r.getY()+s);let a=this.getColor(r,e);if(0===a)return!1;let i=this.getColor(e,t);return i===a&&(i=this.getColor(t,n),i===a&&(i=this.getColor(n,r),i===a))}getColor(e,t){let n=this.distancePoint(e,t),r=(t.getX()-e.getX())/n,s=(t.getY()-e.getY())/n,a=0,i=e.getX(),o=e.getY(),l=this.image.get(e.getX(),e.getY()),c=Math.ceil(n);for(let d=0;d<c;d++)i+=r,o+=s,this.image.get(ae.round(i),ae.round(o))!==l&&a++;let u=a/n;return u>.1&&u<.9?0:u<=.1===l?1:-1}getFirstDifferent(e,t,n,r){let s=e.getX()+n,a=e.getY()+r;for(;this.isValid(s,a)&&this.image.get(s,a)===t;)s+=n,a+=r;for(s-=n,a-=r;this.isValid(s,a)&&this.image.get(s,a)===t;)s+=n;for(s-=n;this.isValid(s,a)&&this.image.get(s,a)===t;)a+=r;return a-=r,new me(s,a)}expandSquare(e,t,n){let r=n/(2*t),s=e[0].getX()-e[2].getX(),a=e[0].getY()-e[2].getY(),i=(e[0].getX()+e[2].getX())/2,o=(e[0].getY()+e[2].getY())/2,l=new oe(i+r*s,o+r*a),c=new oe(i-r*s,o-r*a);return s=e[1].getX()-e[3].getX(),a=e[1].getY()-e[3].getY(),i=(e[1].getX()+e[3].getX())/2,o=(e[1].getY()+e[3].getY())/2,[l,new oe(i+r*s,o+r*a),c,new oe(i-r*s,o-r*a)]}isValid(e,t){return e>=0&&e<this.image.getWidth()&&t>0&&t<this.image.getHeight()}isValidPoint(e){let t=ae.round(e.getX()),n=ae.round(e.getY());return this.isValid(t,n)}distancePoint(e,t){return ae.distance(e.getX(),e.getY(),t.getX(),t.getY())}distanceResultPoint(e,t){return ae.distance(e.getX(),e.getY(),t.getX(),t.getY())}getDimension(){return this.compact?4*this.nbLayers+11:this.nbLayers<=4?4*this.nbLayers+15:4*this.nbLayers+2*(v.truncDivision(this.nbLayers-4,8)+1)+15}}class ye{decode(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,n=null,r=new ge(e.getBlackMatrix()),s=null,a=null;try{let e=r.detectMirror(!1);s=e.getPoints(),this.reportFoundResultPoints(t,s),a=(new se).decode(e)}catch(c){n=c}if(null==a)try{let e=r.detectMirror(!0);s=e.getPoints(),this.reportFoundResultPoints(t,s),a=(new se).decode(e)}catch(c){if(null!=n)throw n;throw c}let i=new U(a.getText(),a.getRawBytes(),a.getNumBits(),s,z.AZTEC,m.currentTimeMillis()),o=a.getByteSegments();null!=o&&i.putMetadata(Y.BYTE_SEGMENTS,o);let l=a.getECLevel();return null!=l&&i.putMetadata(Y.ERROR_CORRECTION_LEVEL,l),i}reportFoundResultPoints(e,t){if(null!=e){let n=e.get(x.NEED_RESULT_POINT_CALLBACK);null!=n&&t.forEach((e,t,r)=>{n.foundPossibleResultPoint(e)})}}reset(){}}class we extends F{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:500;super(new ye,e)}}class ve{decode(e,t){try{return this.doDecode(e,t)}catch(n){if(t&&!0===t.get(x.TRY_HARDER)&&e.isRotateSupported()){const n=e.rotateCounterClockwise(),r=this.doDecode(n,t),s=r.getResultMetadata();let a=270;null!==s&&!0===s.get(Y.ORIENTATION)&&(a+=s.get(Y.ORIENTATION)%360),r.putMetadata(Y.ORIENTATION,a);const i=r.getResultPoints();if(null!==i){const e=n.getHeight();for(let t=0;t<i.length;t++)i[t]=new oe(e-i[t].getY()-1,i[t].getX())}return r}throw new _}}reset(){}doDecode(e,t){const n=e.getWidth(),r=e.getHeight();let s=new A(n);const a=t&&!0===t.get(x.TRY_HARDER),i=Math.max(1,r>>(a?8:5));let o;o=a?r:15;const l=Math.trunc(r/2);for(let d=0;d<o;d++){const a=Math.trunc((d+1)/2),o=l+i*(0===(1&d)?a:-a);if(o<0||o>=r)break;try{s=e.getBlackRow(o,s)}catch(c){continue}for(let e=0;e<2;e++){if(1===e&&(s.reverse(),t&&!0===t.get(x.NEED_RESULT_POINT_CALLBACK))){const e=new Map;t.forEach((t,n)=>e.set(n,t)),e.delete(x.NEED_RESULT_POINT_CALLBACK),t=e}try{const r=this.decodeRow(o,s,t);if(1===e){r.putMetadata(Y.ORIENTATION,180);const e=r.getResultPoints();null!==e&&(e[0]=new oe(n-e[0].getX()-1,e[0].getY()),e[1]=new oe(n-e[1].getX()-1,e[1].getY()))}return r}catch(u){}}}throw new _}static recordPattern(e,t,n){const r=n.length;for(let l=0;l<r;l++)n[l]=0;const s=e.getSize();if(t>=s)throw new _;let a=!e.get(t),i=0,o=t;for(;o<s;){if(e.get(o)!==a)n[i]++;else{if(++i===r)break;n[i]=1,a=!a}o++}if(i!==r&&(i!==r-1||o!==s))throw new _}static recordPatternInReverse(e,t,n){let r=n.length,s=e.get(t);for(;t>0&&r>=0;)e.get(--t)!==s&&(r--,s=!s);if(r>=0)throw new _;ve.recordPattern(e,t+1,n)}static patternMatchVariance(e,t,n){const r=e.length;let s=0,a=0;for(let l=0;l<r;l++)s+=e[l],a+=t[l];if(s<a)return Number.POSITIVE_INFINITY;const i=s/a;n*=i;let o=0;for(let l=0;l<r;l++){const r=e[l],s=t[l]*i,a=r>s?r-s:s-r;if(a>n)return Number.POSITIVE_INFINITY;o+=a}return o/s}}class Ae extends ve{static findStartPattern(e){const t=e.getSize(),n=e.getNextSet(0);let r=0,s=Int32Array.from([0,0,0,0,0,0]),a=n,i=!1;const o=6;for(let l=n;l<t;l++)if(e.get(l)!==i)s[r]++;else{if(r===o-1){let t=Ae.MAX_AVG_VARIANCE,n=-1;for(let e=Ae.CODE_START_A;e<=Ae.CODE_START_C;e++){const r=ve.patternMatchVariance(s,Ae.CODE_PATTERNS[e],Ae.MAX_INDIVIDUAL_VARIANCE);r<t&&(t=r,n=e)}if(n>=0&&e.isRange(Math.max(0,a-(l-a)/2),a,!1))return Int32Array.from([a,l,n]);a+=s[0]+s[1],s=s.slice(2,s.length-1),s[r-1]=0,s[r]=0,r--}else r++;s[r]=1,i=!i}throw new _}static decodeCode(e,t,n){ve.recordPattern(e,n,t);let r=Ae.MAX_AVG_VARIANCE,s=-1;for(let a=0;a<Ae.CODE_PATTERNS.length;a++){const e=Ae.CODE_PATTERNS[a],n=this.patternMatchVariance(t,e,Ae.MAX_INDIVIDUAL_VARIANCE);n<r&&(r=n,s=a)}if(s>=0)return s;throw new _}decodeRow(e,t,n){const r=n&&!0===n.get(x.ASSUME_GS1),s=Ae.findStartPattern(t),a=s[2];let i=0;const o=new Uint8Array(20);let l;switch(o[i++]=a,a){case Ae.CODE_START_A:l=Ae.CODE_CODE_A;break;case Ae.CODE_START_B:l=Ae.CODE_CODE_B;break;case Ae.CODE_START_C:l=Ae.CODE_CODE_C;break;default:throw new S}let c=!1,u=!1,d="",h=s[0],p=s[1];const m=Int32Array.from([0,0,0,0,0,0]);let g=0,y=0,w=a,v=0,A=!0,b=!1,C=!1;for(;!c;){const e=u;switch(u=!1,g=y,y=Ae.decodeCode(t,m,p),o[i++]=y,y!==Ae.CODE_STOP&&(A=!0),y!==Ae.CODE_STOP&&(v++,w+=v*y),h=p,p+=m.reduce((e,t)=>e+t,0),y){case Ae.CODE_START_A:case Ae.CODE_START_B:case Ae.CODE_START_C:throw new S}switch(l){case Ae.CODE_CODE_A:if(y<64)d+=C===b?String.fromCharCode(" ".charCodeAt(0)+y):String.fromCharCode(" ".charCodeAt(0)+y+128),C=!1;else if(y<96)d+=C===b?String.fromCharCode(y-64):String.fromCharCode(y+64),C=!1;else switch(y!==Ae.CODE_STOP&&(A=!1),y){case Ae.CODE_FNC_1:r&&(0===d.length?d+="]C1":d+=String.fromCharCode(29));break;case Ae.CODE_FNC_2:case Ae.CODE_FNC_3:break;case Ae.CODE_FNC_4_A:!b&&C?(b=!0,C=!1):b&&C?(b=!1,C=!1):C=!0;break;case Ae.CODE_SHIFT:u=!0,l=Ae.CODE_CODE_B;break;case Ae.CODE_CODE_B:l=Ae.CODE_CODE_B;break;case Ae.CODE_CODE_C:l=Ae.CODE_CODE_C;break;case Ae.CODE_STOP:c=!0}break;case Ae.CODE_CODE_B:if(y<96)d+=C===b?String.fromCharCode(" ".charCodeAt(0)+y):String.fromCharCode(" ".charCodeAt(0)+y+128),C=!1;else switch(y!==Ae.CODE_STOP&&(A=!1),y){case Ae.CODE_FNC_1:r&&(0===d.length?d+="]C1":d+=String.fromCharCode(29));break;case Ae.CODE_FNC_2:case Ae.CODE_FNC_3:break;case Ae.CODE_FNC_4_B:!b&&C?(b=!0,C=!1):b&&C?(b=!1,C=!1):C=!0;break;case Ae.CODE_SHIFT:u=!0,l=Ae.CODE_CODE_A;break;case Ae.CODE_CODE_A:l=Ae.CODE_CODE_A;break;case Ae.CODE_CODE_C:l=Ae.CODE_CODE_C;break;case Ae.CODE_STOP:c=!0}break;case Ae.CODE_CODE_C:if(y<100)y<10&&(d+="0"),d+=y;else switch(y!==Ae.CODE_STOP&&(A=!1),y){case Ae.CODE_FNC_1:r&&(0===d.length?d+="]C1":d+=String.fromCharCode(29));break;case Ae.CODE_CODE_A:l=Ae.CODE_CODE_A;break;case Ae.CODE_CODE_B:l=Ae.CODE_CODE_B;break;case Ae.CODE_STOP:c=!0}}e&&(l=l===Ae.CODE_CODE_A?Ae.CODE_CODE_B:Ae.CODE_CODE_A)}const E=p-h;if(p=t.getNextUnset(p),!t.isRange(p,Math.min(t.getSize(),p+(p-h)/2),!1))throw new _;if(w-=v*g,w%103!==g)throw new f;const N=d.length;if(0===N)throw new _;N>0&&A&&(d=l===Ae.CODE_CODE_C?d.substring(0,N-2):d.substring(0,N-1));const k=(s[1]+s[0])/2,T=h+E/2,I=o.length,R=new Uint8Array(I);for(let f=0;f<I;f++)R[f]=o[f];const M=[new oe(k,e),new oe(T,e)];return new U(d,R,0,M,z.CODE_128,(new Date).getTime())}}Ae.CODE_PATTERNS=[Int32Array.from([2,1,2,2,2,2]),Int32Array.from([2,2,2,1,2,2]),Int32Array.from([2,2,2,2,2,1]),Int32Array.from([1,2,1,2,2,3]),Int32Array.from([1,2,1,3,2,2]),Int32Array.from([1,3,1,2,2,2]),Int32Array.from([1,2,2,2,1,3]),Int32Array.from([1,2,2,3,1,2]),Int32Array.from([1,3,2,2,1,2]),Int32Array.from([2,2,1,2,1,3]),Int32Array.from([2,2,1,3,1,2]),Int32Array.from([2,3,1,2,1,2]),Int32Array.from([1,1,2,2,3,2]),Int32Array.from([1,2,2,1,3,2]),Int32Array.from([1,2,2,2,3,1]),Int32Array.from([1,1,3,2,2,2]),Int32Array.from([1,2,3,1,2,2]),Int32Array.from([1,2,3,2,2,1]),Int32Array.from([2,2,3,2,1,1]),Int32Array.from([2,2,1,1,3,2]),Int32Array.from([2,2,1,2,3,1]),Int32Array.from([2,1,3,2,1,2]),Int32Array.from([2,2,3,1,1,2]),Int32Array.from([3,1,2,1,3,1]),Int32Array.from([3,1,1,2,2,2]),Int32Array.from([3,2,1,1,2,2]),Int32Array.from([3,2,1,2,2,1]),Int32Array.from([3,1,2,2,1,2]),Int32Array.from([3,2,2,1,1,2]),Int32Array.from([3,2,2,2,1,1]),Int32Array.from([2,1,2,1,2,3]),Int32Array.from([2,1,2,3,2,1]),Int32Array.from([2,3,2,1,2,1]),Int32Array.from([1,1,1,3,2,3]),Int32Array.from([1,3,1,1,2,3]),Int32Array.from([1,3,1,3,2,1]),Int32Array.from([1,1,2,3,1,3]),Int32Array.from([1,3,2,1,1,3]),Int32Array.from([1,3,2,3,1,1]),Int32Array.from([2,1,1,3,1,3]),Int32Array.from([2,3,1,1,1,3]),Int32Array.from([2,3,1,3,1,1]),Int32Array.from([1,1,2,1,3,3]),Int32Array.from([1,1,2,3,3,1]),Int32Array.from([1,3,2,1,3,1]),Int32Array.from([1,1,3,1,2,3]),Int32Array.from([1,1,3,3,2,1]),Int32Array.from([1,3,3,1,2,1]),Int32Array.from([3,1,3,1,2,1]),Int32Array.from([2,1,1,3,3,1]),Int32Array.from([2,3,1,1,3,1]),Int32Array.from([2,1,3,1,1,3]),Int32Array.from([2,1,3,3,1,1]),Int32Array.from([2,1,3,1,3,1]),Int32Array.from([3,1,1,1,2,3]),Int32Array.from([3,1,1,3,2,1]),Int32Array.from([3,3,1,1,2,1]),Int32Array.from([3,1,2,1,1,3]),Int32Array.from([3,1,2,3,1,1]),Int32Array.from([3,3,2,1,1,1]),Int32Array.from([3,1,4,1,1,1]),Int32Array.from([2,2,1,4,1,1]),Int32Array.from([4,3,1,1,1,1]),Int32Array.from([1,1,1,2,2,4]),Int32Array.from([1,1,1,4,2,2]),Int32Array.from([1,2,1,1,2,4]),Int32Array.from([1,2,1,4,2,1]),Int32Array.from([1,4,1,1,2,2]),Int32Array.from([1,4,1,2,2,1]),Int32Array.from([1,1,2,2,1,4]),Int32Array.from([1,1,2,4,1,2]),Int32Array.from([1,2,2,1,1,4]),Int32Array.from([1,2,2,4,1,1]),Int32Array.from([1,4,2,1,1,2]),Int32Array.from([1,4,2,2,1,1]),Int32Array.from([2,4,1,2,1,1]),Int32Array.from([2,2,1,1,1,4]),Int32Array.from([4,1,3,1,1,1]),Int32Array.from([2,4,1,1,1,2]),Int32Array.from([1,3,4,1,1,1]),Int32Array.from([1,1,1,2,4,2]),Int32Array.from([1,2,1,1,4,2]),Int32Array.from([1,2,1,2,4,1]),Int32Array.from([1,1,4,2,1,2]),Int32Array.from([1,2,4,1,1,2]),Int32Array.from([1,2,4,2,1,1]),Int32Array.from([4,1,1,2,1,2]),Int32Array.from([4,2,1,1,1,2]),Int32Array.from([4,2,1,2,1,1]),Int32Array.from([2,1,2,1,4,1]),Int32Array.from([2,1,4,1,2,1]),Int32Array.from([4,1,2,1,2,1]),Int32Array.from([1,1,1,1,4,3]),Int32Array.from([1,1,1,3,4,1]),Int32Array.from([1,3,1,1,4,1]),Int32Array.from([1,1,4,1,1,3]),Int32Array.from([1,1,4,3,1,1]),Int32Array.from([4,1,1,1,1,3]),Int32Array.from([4,1,1,3,1,1]),Int32Array.from([1,1,3,1,4,1]),Int32Array.from([1,1,4,1,3,1]),Int32Array.from([3,1,1,1,4,1]),Int32Array.from([4,1,1,1,3,1]),Int32Array.from([2,1,1,4,1,2]),Int32Array.from([2,1,1,2,1,4]),Int32Array.from([2,1,1,2,3,2]),Int32Array.from([2,3,3,1,1,1,2])],Ae.MAX_AVG_VARIANCE=.25,Ae.MAX_INDIVIDUAL_VARIANCE=.7,Ae.CODE_SHIFT=98,Ae.CODE_CODE_C=99,Ae.CODE_CODE_B=100,Ae.CODE_CODE_A=101,Ae.CODE_FNC_1=102,Ae.CODE_FNC_2=97,Ae.CODE_FNC_3=96,Ae.CODE_FNC_4_A=101,Ae.CODE_FNC_4_B=100,Ae.CODE_START_A=103,Ae.CODE_START_B=104,Ae.CODE_START_C=105,Ae.CODE_STOP=106;class be extends ve{constructor(){let e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];super(),this.usingCheckDigit=e,this.extendedMode=t,this.decodeRowResult="",this.counters=new Int32Array(9)}decodeRow(e,t,n){let r=this.counters;r.fill(0),this.decodeRowResult="";let s,a,i=be.findAsteriskPattern(t,r),o=t.getNextSet(i[1]),l=t.getSize();do{be.recordPattern(t,o,r);let e=be.toNarrowWidePattern(r);if(e<0)throw new _;s=be.patternToChar(e),this.decodeRowResult+=s,a=o;for(let t of r)o+=t;o=t.getNextSet(o)}while("*"!==s);this.decodeRowResult=this.decodeRowResult.substring(0,this.decodeRowResult.length-1);let c,u=0;for(let f of r)u+=f;if(o!==l&&2*(o-a-u)<u)throw new _;if(this.usingCheckDigit){let e=this.decodeRowResult.length-1,t=0;for(let n=0;n<e;n++)t+=be.ALPHABET_STRING.indexOf(this.decodeRowResult.charAt(n));if(this.decodeRowResult.charAt(e)!==be.ALPHABET_STRING.charAt(t%43))throw new f;this.decodeRowResult=this.decodeRowResult.substring(0,e)}if(0===this.decodeRowResult.length)throw new _;c=this.extendedMode?be.decodeExtended(this.decodeRowResult):this.decodeRowResult;let d=(i[1]+i[0])/2,h=a+u/2;return new U(c,null,0,[new oe(d,e),new oe(h,e)],z.CODE_39,(new Date).getTime())}static findAsteriskPattern(e,t){let n=e.getSize(),r=e.getNextSet(0),s=0,a=r,i=!1,o=t.length;for(let l=r;l<n;l++)if(e.get(l)!==i)t[s]++;else{if(s===o-1){if(this.toNarrowWidePattern(t)===be.ASTERISK_ENCODING&&e.isRange(Math.max(0,a-Math.floor((l-a)/2)),a,!1))return[a,l];a+=t[0]+t[1],t.copyWithin(0,2,2+s-1),t[s-1]=0,t[s]=0,s--}else s++;t[s]=1,i=!i}throw new _}static toNarrowWidePattern(e){let t,n=e.length,r=0;do{let s=2147483647;for(let t of e)t<s&&t>r&&(s=t);r=s,t=0;let a=0,i=0;for(let o=0;o<n;o++){let s=e[o];s>r&&(i|=1<<n-1-o,t++,a+=s)}if(3===t){for(let s=0;s<n&&t>0;s++){let n=e[s];if(n>r&&(t--,2*n>=a))return-1}return i}}while(t>3);return-1}static patternToChar(e){for(let t=0;t<be.CHARACTER_ENCODINGS.length;t++)if(be.CHARACTER_ENCODINGS[t]===e)return be.ALPHABET_STRING.charAt(t);if(e===be.ASTERISK_ENCODING)return"*";throw new _}static decodeExtended(e){let t=e.length,n="";for(let r=0;r<t;r++){let t=e.charAt(r);if("+"===t||"$"===t||"%"===t||"/"===t){let s=e.charAt(r+1),a="\0";switch(t){case"+":if(!(s>="A"&&s<="Z"))throw new S;a=String.fromCharCode(s.charCodeAt(0)+32);break;case"$":if(!(s>="A"&&s<="Z"))throw new S;a=String.fromCharCode(s.charCodeAt(0)-64);break;case"%":if(s>="A"&&s<="E")a=String.fromCharCode(s.charCodeAt(0)-38);else if(s>="F"&&s<="J")a=String.fromCharCode(s.charCodeAt(0)-11);else if(s>="K"&&s<="O")a=String.fromCharCode(s.charCodeAt(0)+16);else if(s>="P"&&s<="T")a=String.fromCharCode(s.charCodeAt(0)+43);else if("U"===s)a="\0";else if("V"===s)a="@";else if("W"===s)a="`";else{if("X"!==s&&"Y"!==s&&"Z"!==s)throw new S;a="\x7f"}break;case"/":if(s>="A"&&s<="O")a=String.fromCharCode(s.charCodeAt(0)-32);else{if("Z"!==s)throw new S;a=":"}}n+=a,r++}else n+=t}return n}}be.ALPHABET_STRING="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%",be.CHARACTER_ENCODINGS=[52,289,97,352,49,304,112,37,292,100,265,73,328,25,280,88,13,268,76,28,259,67,322,19,274,82,7,262,70,22,385,193,448,145,400,208,133,388,196,168,162,138,42],be.ASTERISK_ENCODING=148;class xe extends ve{constructor(){super(...arguments),this.narrowLineWidth=-1}decodeRow(e,t,n){let r=this.decodeStart(t),s=this.decodeEnd(t),a=new T;xe.decodeMiddle(t,r[1],s[0],a);let i=a.toString(),o=null;null!=n&&(o=n.get(x.ALLOWED_LENGTHS)),null==o&&(o=xe.DEFAULT_ALLOWED_LENGTHS);let l=i.length,c=!1,u=0;for(let h of o){if(l===h){c=!0;break}h>u&&(u=h)}if(!c&&l>u&&(c=!0),!c)throw new S;const d=[new oe(r[1],e),new oe(s[0],e)];return new U(i,null,0,d,z.ITF,(new Date).getTime())}static decodeMiddle(e,t,n,r){let s=new Int32Array(10),a=new Int32Array(5),i=new Int32Array(5);for(s.fill(0),a.fill(0),i.fill(0);t<n;){ve.recordPattern(e,t,s);for(let e=0;e<5;e++){let t=2*e;a[e]=s[t],i[e]=s[t+1]}let n=xe.decodeDigit(a);r.append(n.toString()),n=this.decodeDigit(i),r.append(n.toString()),s.forEach(function(e){t+=e})}}decodeStart(e){let t=xe.skipWhiteSpace(e),n=xe.findGuardPattern(e,t,xe.START_PATTERN);return this.narrowLineWidth=(n[1]-n[0])/4,this.validateQuietZone(e,n[0]),n}validateQuietZone(e,t){let n=10*this.narrowLineWidth;n=n<t?n:t;for(let r=t-1;n>0&&r>=0&&!e.get(r);r--)n--;if(0!==n)throw new _}static skipWhiteSpace(e){const t=e.getSize(),n=e.getNextSet(0);if(n===t)throw new _;return n}decodeEnd(e){e.reverse();try{let n,r=xe.skipWhiteSpace(e);try{n=xe.findGuardPattern(e,r,xe.END_PATTERN_REVERSED[0])}catch(t){t instanceof _&&(n=xe.findGuardPattern(e,r,xe.END_PATTERN_REVERSED[1]))}this.validateQuietZone(e,n[0]);let s=n[0];return n[0]=e.getSize()-n[1],n[1]=e.getSize()-s,n}finally{e.reverse()}}static findGuardPattern(e,t,n){let r=n.length,s=new Int32Array(r),a=e.getSize(),i=!1,o=0,l=t;s.fill(0);for(let c=t;c<a;c++)if(e.get(c)!==i)s[o]++;else{if(o===r-1){if(ve.patternMatchVariance(s,n,xe.MAX_INDIVIDUAL_VARIANCE)<xe.MAX_AVG_VARIANCE)return[l,c];l+=s[0]+s[1],m.arraycopy(s,2,s,0,o-1),s[o-1]=0,s[o]=0,o--}else o++;s[o]=1,i=!i}throw new _}static decodeDigit(e){let t=xe.MAX_AVG_VARIANCE,n=-1,r=xe.PATTERNS.length;for(let s=0;s<r;s++){let r=xe.PATTERNS[s],a=ve.patternMatchVariance(e,r,xe.MAX_INDIVIDUAL_VARIANCE);a<t?(t=a,n=s):a===t&&(n=-1)}if(n>=0)return n%10;throw new _}}xe.PATTERNS=[Int32Array.from([1,1,2,2,1]),Int32Array.from([2,1,1,1,2]),Int32Array.from([1,2,1,1,2]),Int32Array.from([2,2,1,1,1]),Int32Array.from([1,1,2,1,2]),Int32Array.from([2,1,2,1,1]),Int32Array.from([1,2,2,1,1]),Int32Array.from([1,1,1,2,2]),Int32Array.from([2,1,1,2,1]),Int32Array.from([1,2,1,2,1]),Int32Array.from([1,1,3,3,1]),Int32Array.from([3,1,1,1,3]),Int32Array.from([1,3,1,1,3]),Int32Array.from([3,3,1,1,1]),Int32Array.from([1,1,3,1,3]),Int32Array.from([3,1,3,1,1]),Int32Array.from([1,3,3,1,1]),Int32Array.from([1,1,1,3,3]),Int32Array.from([3,1,1,3,1]),Int32Array.from([1,3,1,3,1])],xe.MAX_AVG_VARIANCE=.38,xe.MAX_INDIVIDUAL_VARIANCE=.5,xe.DEFAULT_ALLOWED_LENGTHS=[6,8,10,12,14],xe.START_PATTERN=Int32Array.from([1,1,1,1]),xe.END_PATTERN_REVERSED=[Int32Array.from([1,1,2]),Int32Array.from([1,1,3])];class Se extends ve{constructor(){super(...arguments),this.decodeRowStringBuffer=""}static findStartGuardPattern(e){let t,n=!1,r=0,s=Int32Array.from([0,0,0]);for(;!n;){s=Int32Array.from([0,0,0]),t=Se.findGuardPattern(e,r,!1,this.START_END_PATTERN,s);let a=t[0];r=t[1];let i=a-(r-a);i>=0&&(n=e.isRange(i,a,!1))}return t}static checkChecksum(e){return Se.checkStandardUPCEANChecksum(e)}static checkStandardUPCEANChecksum(e){let t=e.length;if(0===t)return!1;let n=parseInt(e.charAt(t-1),10);return Se.getStandardUPCEANChecksum(e.substring(0,t-1))===n}static getStandardUPCEANChecksum(e){let t=e.length,n=0;for(let r=t-1;r>=0;r-=2){let t=e.charAt(r).charCodeAt(0)-"0".charCodeAt(0);if(t<0||t>9)throw new S;n+=t}n*=3;for(let r=t-2;r>=0;r-=2){let t=e.charAt(r).charCodeAt(0)-"0".charCodeAt(0);if(t<0||t>9)throw new S;n+=t}return(1e3-n)%10}static decodeEnd(e,t){return Se.findGuardPattern(e,t,!1,Se.START_END_PATTERN,new Int32Array(Se.START_END_PATTERN.length).fill(0))}static findGuardPatternWithoutCounters(e,t,n,r){return this.findGuardPattern(e,t,n,r,new Int32Array(r.length))}static findGuardPattern(e,t,n,r,s){let a=e.getSize(),i=0,o=t=n?e.getNextUnset(t):e.getNextSet(t),l=r.length,c=n;for(let u=t;u<a;u++)if(e.get(u)!==c)s[i]++;else{if(i===l-1){if(ve.patternMatchVariance(s,r,Se.MAX_INDIVIDUAL_VARIANCE)<Se.MAX_AVG_VARIANCE)return Int32Array.from([o,u]);o+=s[0]+s[1];let e=s.slice(2,s.length-1);for(let t=0;t<i-1;t++)s[t]=e[t];s[i-1]=0,s[i]=0,i--}else i++;s[i]=1,c=!c}throw new _}static decodeDigit(e,t,n,r){this.recordPattern(e,n,t);let s=this.MAX_AVG_VARIANCE,a=-1,i=r.length;for(let o=0;o<i;o++){let e=r[o],n=ve.patternMatchVariance(t,e,Se.MAX_INDIVIDUAL_VARIANCE);n<s&&(s=n,a=o)}if(a>=0)return a;throw new _}}Se.MAX_AVG_VARIANCE=.48,Se.MAX_INDIVIDUAL_VARIANCE=.7,Se.START_END_PATTERN=Int32Array.from([1,1,1]),Se.MIDDLE_PATTERN=Int32Array.from([1,1,1,1,1]),Se.END_PATTERN=Int32Array.from([1,1,1,1,1,1]),Se.L_PATTERNS=[Int32Array.from([3,2,1,1]),Int32Array.from([2,2,2,1]),Int32Array.from([2,1,2,2]),Int32Array.from([1,4,1,1]),Int32Array.from([1,1,3,2]),Int32Array.from([1,2,3,1]),Int32Array.from([1,1,1,4]),Int32Array.from([1,3,1,2]),Int32Array.from([1,2,1,3]),Int32Array.from([3,1,1,2])];class Ce{constructor(){this.CHECK_DIGIT_ENCODINGS=[24,20,18,17,12,6,3,10,9,5],this.decodeMiddleCounters=Int32Array.from([0,0,0,0]),this.decodeRowStringBuffer=""}decodeRow(e,t,n){let r=this.decodeRowStringBuffer,s=this.decodeMiddle(t,n,r),a=r.toString(),i=Ce.parseExtensionString(a),o=[new oe((n[0]+n[1])/2,e),new oe(s,e)],l=new U(a,null,0,o,z.UPC_EAN_EXTENSION,(new Date).getTime());return null!=i&&l.putAllMetadata(i),l}decodeMiddle(e,t,n){let r=this.decodeMiddleCounters;r[0]=0,r[1]=0,r[2]=0,r[3]=0;let s=e.getSize(),a=t[1],i=0;for(let l=0;l<5&&a<s;l++){let t=Se.decodeDigit(e,r,a,Se.L_AND_G_PATTERNS);n+=String.fromCharCode("0".charCodeAt(0)+t%10);for(let e of r)a+=e;t>=10&&(i|=1<<4-l),4!==l&&(a=e.getNextSet(a),a=e.getNextUnset(a))}if(5!==n.length)throw new _;let o=this.determineCheckDigit(i);if(Ce.extensionChecksum(n.toString())!==o)throw new _;return a}static extensionChecksum(e){let t=e.length,n=0;for(let r=t-2;r>=0;r-=2)n+=e.charAt(r).charCodeAt(0)-"0".charCodeAt(0);n*=3;for(let r=t-1;r>=0;r-=2)n+=e.charAt(r).charCodeAt(0)-"0".charCodeAt(0);return n*=3,n%10}determineCheckDigit(e){for(let t=0;t<10;t++)if(e===this.CHECK_DIGIT_ENCODINGS[t])return t;throw new _}static parseExtensionString(e){if(5!==e.length)return null;let t=Ce.parseExtension5String(e);return null==t?null:new Map([[Y.SUGGESTED_PRICE,t]])}static parseExtension5String(e){let t;switch(e.charAt(0)){case"0":t="\xa3";break;case"5":t="$";break;case"9":switch(e){case"90000":return null;case"99991":return"0.00";case"99990":return"Used"}t="";break;default:t=""}let n=parseInt(e.substring(1)),r=n%100;return t+(n/100).toString()+"."+(r<10?"0"+r:r.toString())}}class Ee{constructor(){this.decodeMiddleCounters=Int32Array.from([0,0,0,0]),this.decodeRowStringBuffer=""}decodeRow(e,t,n){let r=this.decodeRowStringBuffer,s=this.decodeMiddle(t,n,r),a=r.toString(),i=Ee.parseExtensionString(a),o=[new oe((n[0]+n[1])/2,e),new oe(s,e)],l=new U(a,null,0,o,z.UPC_EAN_EXTENSION,(new Date).getTime());return null!=i&&l.putAllMetadata(i),l}decodeMiddle(e,t,n){let r=this.decodeMiddleCounters;r[0]=0,r[1]=0,r[2]=0,r[3]=0;let s=e.getSize(),a=t[1],i=0;for(let o=0;o<2&&a<s;o++){let t=Se.decodeDigit(e,r,a,Se.L_AND_G_PATTERNS);n+=String.fromCharCode("0".charCodeAt(0)+t%10);for(let e of r)a+=e;t>=10&&(i|=1<<1-o),1!==o&&(a=e.getNextSet(a),a=e.getNextUnset(a))}if(2!==n.length)throw new _;if(parseInt(n.toString())%4!==i)throw new _;return a}static parseExtensionString(e){return 2!==e.length?null:new Map([[Y.ISSUE_NUMBER,parseInt(e)]])}}class Ne{static decodeRow(e,t,n){let r=Se.findGuardPattern(t,n,!1,this.EXTENSION_START_PATTERN,new Int32Array(this.EXTENSION_START_PATTERN.length).fill(0));try{return(new Ce).decodeRow(e,t,r)}catch(s){return(new Ee).decodeRow(e,t,r)}}}Ne.EXTENSION_START_PATTERN=Int32Array.from([1,1,2]);class ke extends Se{constructor(){super(),this.decodeRowStringBuffer="",ke.L_AND_G_PATTERNS=ke.L_PATTERNS.map(e=>Int32Array.from(e));for(let e=10;e<20;e++){let t=ke.L_PATTERNS[e-10],n=new Int32Array(t.length);for(let e=0;e<t.length;e++)n[e]=t[t.length-e-1];ke.L_AND_G_PATTERNS[e]=n}}decodeRow(e,t,n){let r=ke.findStartGuardPattern(t),s=null==n?null:n.get(x.NEED_RESULT_POINT_CALLBACK);if(null!=s){const t=new oe((r[0]+r[1])/2,e);s.foundPossibleResultPoint(t)}let a=this.decodeMiddle(t,r,this.decodeRowStringBuffer),i=a.rowOffset,o=a.resultString;if(null!=s){const t=new oe(i,e);s.foundPossibleResultPoint(t)}let l=this.decodeEnd(t,i);if(null!=s){const t=new oe((l[0]+l[1])/2,e);s.foundPossibleResultPoint(t)}let c=l[1],u=c+(c-l[0]);if(u>=t.getSize()||!t.isRange(c,u,!1))throw new _;let d=o.toString();if(d.length<8)throw new S;if(!ke.checkChecksum(d))throw new f;let h=(r[1]+r[0])/2,p=(l[1]+l[0])/2,m=this.getBarcodeFormat(),g=[new oe(h,e),new oe(p,e)],y=new U(d,null,0,g,m,(new Date).getTime()),w=0;try{let n=Ne.decodeRow(e,t,l[1]);y.putMetadata(Y.UPC_EAN_EXTENSION,n.getText()),y.putAllMetadata(n.getResultMetadata()),y.addResultPoints(n.getResultPoints()),w=n.getText().length}catch(A){}let v=null==n?null:n.get(x.ALLOWED_EAN_EXTENSIONS);if(null!=v){let e=!1;for(let t in v)if(w.toString()===t){e=!0;break}if(!e)throw new _}return y}decodeEnd(e,t){return ke.findGuardPattern(e,t,!1,ke.START_END_PATTERN,new Int32Array(ke.START_END_PATTERN.length).fill(0))}static checkChecksum(e){return ke.checkStandardUPCEANChecksum(e)}static checkStandardUPCEANChecksum(e){let t=e.length;if(0===t)return!1;let n=parseInt(e.charAt(t-1),10);return ke.getStandardUPCEANChecksum(e.substring(0,t-1))===n}static getStandardUPCEANChecksum(e){let t=e.length,n=0;for(let r=t-1;r>=0;r-=2){let t=e.charAt(r).charCodeAt(0)-"0".charCodeAt(0);if(t<0||t>9)throw new S;n+=t}n*=3;for(let r=t-2;r>=0;r-=2){let t=e.charAt(r).charCodeAt(0)-"0".charCodeAt(0);if(t<0||t>9)throw new S;n+=t}return(1e3-n)%10}}class Te extends ke{constructor(){super(),this.decodeMiddleCounters=Int32Array.from([0,0,0,0])}decodeMiddle(e,t,n){let r=this.decodeMiddleCounters;r[0]=0,r[1]=0,r[2]=0,r[3]=0;let s=e.getSize(),a=t[1],i=0;for(let o=0;o<6&&a<s;o++){let t=ke.decodeDigit(e,r,a,ke.L_AND_G_PATTERNS);n+=String.fromCharCode("0".charCodeAt(0)+t%10);for(let e of r)a+=e;t>=10&&(i|=1<<5-o)}n=Te.determineFirstDigit(n,i),a=ke.findGuardPattern(e,a,!0,ke.MIDDLE_PATTERN,new Int32Array(ke.MIDDLE_PATTERN.length).fill(0))[1];for(let o=0;o<6&&a<s;o++){let t=ke.decodeDigit(e,r,a,ke.L_PATTERNS);n+=String.fromCharCode("0".charCodeAt(0)+t);for(let e of r)a+=e}return{rowOffset:a,resultString:n}}getBarcodeFormat(){return z.EAN_13}static determineFirstDigit(e,t){for(let n=0;n<10;n++)if(t===this.FIRST_DIGIT_ENCODINGS[n])return e=String.fromCharCode("0".charCodeAt(0)+n)+e;throw new _}}Te.FIRST_DIGIT_ENCODINGS=[0,11,13,14,19,25,28,21,22,26];class Ie extends ke{constructor(){super(),this.decodeMiddleCounters=Int32Array.from([0,0,0,0])}decodeMiddle(e,t,n){const r=this.decodeMiddleCounters;r[0]=0,r[1]=0,r[2]=0,r[3]=0;let s=e.getSize(),a=t[1];for(let i=0;i<4&&a<s;i++){let t=ke.decodeDigit(e,r,a,ke.L_PATTERNS);n+=String.fromCharCode("0".charCodeAt(0)+t);for(let e of r)a+=e}a=ke.findGuardPattern(e,a,!0,ke.MIDDLE_PATTERN,new Int32Array(ke.MIDDLE_PATTERN.length).fill(0))[1];for(let i=0;i<4&&a<s;i++){let t=ke.decodeDigit(e,r,a,ke.L_PATTERNS);n+=String.fromCharCode("0".charCodeAt(0)+t);for(let e of r)a+=e}return{rowOffset:a,resultString:n}}getBarcodeFormat(){return z.EAN_8}}class _e extends ke{constructor(){super(...arguments),this.ean13Reader=new Te}getBarcodeFormat(){return z.UPC_A}decode(e,t){return this.maybeReturnResult(this.ean13Reader.decode(e))}decodeRow(e,t,n){return this.maybeReturnResult(this.ean13Reader.decodeRow(e,t,n))}decodeMiddle(e,t,n){return this.ean13Reader.decodeMiddle(e,t,n)}maybeReturnResult(e){let t=e.getText();if("0"===t.charAt(0)){let n=new U(t.substring(1),null,null,e.getResultPoints(),z.UPC_A);return null!=e.getResultMetadata()&&n.putAllMetadata(e.getResultMetadata()),n}throw new _}reset(){this.ean13Reader.reset()}}class Re extends ke{constructor(){super(),this.decodeMiddleCounters=new Int32Array(4)}decodeMiddle(e,t,n){const r=this.decodeMiddleCounters.map(e=>e);r[0]=0,r[1]=0,r[2]=0,r[3]=0;const s=e.getSize();let a=t[1],i=0;for(let o=0;o<6&&a<s;o++){const t=Re.decodeDigit(e,r,a,Re.L_AND_G_PATTERNS);n+=String.fromCharCode("0".charCodeAt(0)+t%10);for(let e of r)a+=e;t>=10&&(i|=1<<5-o)}return{rowOffset:a,resultString:Re.determineNumSysAndCheckDigit(n,i)}}decodeEnd(e,t){return Re.findGuardPatternWithoutCounters(e,t,!0,Re.MIDDLE_END_PATTERN)}checkChecksum(e){return ke.checkChecksum(Re.convertUPCEtoUPCA(e))}static determineNumSysAndCheckDigit(e,t){for(let n=0;n<=1;n++)for(let r=0;r<10;r++)if(t===this.NUMSYS_AND_CHECK_DIGIT_PATTERNS[n][r])return String.fromCharCode("0".charCodeAt(0)+n)+e+String.fromCharCode("0".charCodeAt(0)+r);throw _.getNotFoundInstance()}getBarcodeFormat(){return z.UPC_E}static convertUPCEtoUPCA(e){const t=e.slice(1,7).split("").map(e=>e.charCodeAt(0)),n=new T;n.append(e.charAt(0));let r=t[5];switch(r){case 0:case 1:case 2:n.appendChars(t,0,2),n.append(r),n.append("0000"),n.appendChars(t,2,3);break;case 3:n.appendChars(t,0,3),n.append("00000"),n.appendChars(t,3,2);break;case 4:n.appendChars(t,0,4),n.append("00000"),n.append(t[4]);break;default:n.appendChars(t,0,5),n.append("0000"),n.append(r)}return e.length>=8&&n.append(e.charAt(7)),n.toString()}}Re.MIDDLE_END_PATTERN=Int32Array.from([1,1,1,1,1,1]),Re.NUMSYS_AND_CHECK_DIGIT_PATTERNS=[Int32Array.from([56,52,50,49,44,38,35,42,41,37]),Int32Array.from([7,11,13,14,19,25,28,21,22,26])];class Me extends ve{constructor(e){super();let n=null==e?null:e.get(x.POSSIBLE_FORMATS),r=[];t(n)?(r.push(new Te),r.push(new _e),r.push(new Ie),r.push(new Re)):(n.indexOf(z.EAN_13)>-1&&r.push(new Te),n.indexOf(z.UPC_A)>-1&&r.push(new _e),n.indexOf(z.EAN_8)>-1&&r.push(new Ie),n.indexOf(z.UPC_E)>-1&&r.push(new Re)),this.readers=r}decodeRow(e,t,n){for(let s of this.readers)try{const r=s.decodeRow(e,t,n),a=r.getBarcodeFormat()===z.EAN_13&&"0"===r.getText().charAt(0),i=null==n?null:n.get(x.POSSIBLE_FORMATS),o=null==i||i.includes(z.UPC_A);if(a&&o){const e=r.getRawBytes(),t=new U(r.getText().substring(1),e,e?e.length:null,r.getResultPoints(),z.UPC_A);return t.putAllMetadata(r.getResultMetadata()),t}return r}catch(r){}throw new _}reset(){for(let e of this.readers)e.reset()}}class De extends ve{constructor(){super(),this.decodeFinderCounters=new Int32Array(4),this.dataCharacterCounters=new Int32Array(8),this.oddRoundingErrors=new Array(4),this.evenRoundingErrors=new Array(4),this.oddCounts=new Array(this.dataCharacterCounters.length/2),this.evenCounts=new Array(this.dataCharacterCounters.length/2)}getDecodeFinderCounters(){return this.decodeFinderCounters}getDataCharacterCounters(){return this.dataCharacterCounters}getOddRoundingErrors(){return this.oddRoundingErrors}getEvenRoundingErrors(){return this.evenRoundingErrors}getOddCounts(){return this.oddCounts}getEvenCounts(){return this.evenCounts}parseFinderValue(e,t){for(let n=0;n<t.length;n++)if(ve.patternMatchVariance(e,t[n],De.MAX_INDIVIDUAL_VARIANCE)<De.MAX_AVG_VARIANCE)return n;throw new _}static count(e){return ae.sum(new Int32Array(e))}static increment(e,t){let n=0,r=t[0];for(let s=1;s<e.length;s++)t[s]>r&&(r=t[s],n=s);e[n]++}static decrement(e,t){let n=0,r=t[0];for(let s=1;s<e.length;s++)t[s]<r&&(r=t[s],n=s);e[n]--}static isFinderPattern(e){let t=e[0]+e[1],n=t/(t+e[2]+e[3]);if(n>=De.MIN_FINDER_PATTERN_RATIO&&n<=De.MAX_FINDER_PATTERN_RATIO){let t=Number.MAX_SAFE_INTEGER,n=Number.MIN_SAFE_INTEGER;for(let r of e)r>n&&(n=r),r<t&&(t=r);return n<10*t}return!1}}De.MAX_AVG_VARIANCE=.2,De.MAX_INDIVIDUAL_VARIANCE=.45,De.MIN_FINDER_PATTERN_RATIO=9.5/12,De.MAX_FINDER_PATTERN_RATIO=12.5/14;class je{constructor(e,t){this.value=e,this.checksumPortion=t}getValue(){return this.value}getChecksumPortion(){return this.checksumPortion}toString(){return this.value+"("+this.checksumPortion+")"}equals(e){if(!(e instanceof je))return!1;const t=e;return this.value===t.value&&this.checksumPortion===t.checksumPortion}hashCode(){return this.value^this.checksumPortion}}class Oe{constructor(e,t,n,r,s){this.value=e,this.startEnd=t,this.value=e,this.startEnd=t,this.resultPoints=new Array,this.resultPoints.push(new oe(n,s)),this.resultPoints.push(new oe(r,s))}getValue(){return this.value}getStartEnd(){return this.startEnd}getResultPoints(){return this.resultPoints}equals(e){if(!(e instanceof Oe))return!1;const t=e;return this.value===t.value}hashCode(){return this.value}}class Pe{constructor(){}static getRSSvalue(e,t,n){let r=0;for(let o of e)r+=o;let s=0,a=0,i=e.length;for(let o=0;o<i-1;o++){let l;for(l=1,a|=1<<o;l<e[o];l++,a&=~(1<<o)){let e=Pe.combins(r-l-1,i-o-2);if(n&&0===a&&r-l-(i-o-1)>=i-o-1&&(e-=Pe.combins(r-l-(i-o),i-o-2)),i-o-1>1){let n=0;for(let e=r-l-(i-o-2);e>t;e--)n+=Pe.combins(r-l-e-1,i-o-3);e-=n*(i-1-o)}else r-l>t&&e--;s+=e}r-=l}return s}static combins(e,t){let n,r;e-t>t?(r=t,n=e-t):(r=e-t,n=t);let s=1,a=1;for(let i=e;i>n;i--)s*=i,a<=r&&(s/=a,a++);for(;a<=r;)s/=a,a++;return s}}class Le{static buildBitArray(e){let t=2*e.length-1;null==e[e.length-1].getRightChar()&&(t-=1);let n=new A(12*t),r=0,s=e[0].getRightChar().getValue();for(let a=11;a>=0;--a)0!=(s&1<<a)&&n.set(r),r++;for(let a=1;a<e.length;++a){let t=e[a],s=t.getLeftChar().getValue();for(let e=11;e>=0;--e)0!=(s&1<<e)&&n.set(r),r++;if(null!=t.getRightChar()){let e=t.getRightChar().getValue();for(let t=11;t>=0;--t)0!=(e&1<<t)&&n.set(r),r++}}return n}}class Be{constructor(e,t){t?this.decodedInformation=null:(this.finished=e,this.decodedInformation=t)}getDecodedInformation(){return this.decodedInformation}isFinished(){return this.finished}}class Fe{constructor(e){this.newPosition=e}getNewPosition(){return this.newPosition}}class Ue extends Fe{constructor(e,t){super(e),this.value=t}getValue(){return this.value}isFNC1(){return this.value===Ue.FNC1}}Ue.FNC1="$";class We extends Fe{constructor(e,t,n){super(e),n?(this.remaining=!0,this.remainingValue=this.remainingValue):(this.remaining=!1,this.remainingValue=0),this.newString=t}getNewString(){return this.newString}isRemaining(){return this.remaining}getRemainingValue(){return this.remainingValue}}class ze extends Fe{constructor(e,t,n){if(super(e),t<0||t>10||n<0||n>10)throw new S;this.firstDigit=t,this.secondDigit=n}getFirstDigit(){return this.firstDigit}getSecondDigit(){return this.secondDigit}getValue(){return 10*this.firstDigit+this.secondDigit}isFirstDigitFNC1(){return this.firstDigit===ze.FNC1}isSecondDigitFNC1(){return this.secondDigit===ze.FNC1}isAnyFNC1(){return this.firstDigit===ze.FNC1||this.secondDigit===ze.FNC1}}ze.FNC1=10;class He{constructor(){}static parseFieldsInGeneralPurpose(e){if(!e)return null;if(e.length<2)throw new _;let t=e.substring(0,2);for(let s of He.TWO_DIGIT_DATA_LENGTH)if(s[0]===t)return s[1]===He.VARIABLE_LENGTH?He.processVariableAI(2,s[2],e):He.processFixedAI(2,s[1],e);if(e.length<3)throw new _;let n=e.substring(0,3);for(let s of He.THREE_DIGIT_DATA_LENGTH)if(s[0]===n)return s[1]===He.VARIABLE_LENGTH?He.processVariableAI(3,s[2],e):He.processFixedAI(3,s[1],e);for(let s of He.THREE_DIGIT_PLUS_DIGIT_DATA_LENGTH)if(s[0]===n)return s[1]===He.VARIABLE_LENGTH?He.processVariableAI(4,s[2],e):He.processFixedAI(4,s[1],e);if(e.length<4)throw new _;let r=e.substring(0,4);for(let s of He.FOUR_DIGIT_DATA_LENGTH)if(s[0]===r)return s[1]===He.VARIABLE_LENGTH?He.processVariableAI(4,s[2],e):He.processFixedAI(4,s[1],e);throw new _}static processFixedAI(e,t,n){if(n.length<e)throw new _;let r=n.substring(0,e);if(n.length<e+t)throw new _;let s=n.substring(e,e+t),a=n.substring(e+t),i="("+r+")"+s,o=He.parseFieldsInGeneralPurpose(a);return null==o?i:i+o}static processVariableAI(e,t,n){let r,s=n.substring(0,e);r=n.length<e+t?n.length:e+t;let a=n.substring(e,r),i=n.substring(r),o="("+s+")"+a,l=He.parseFieldsInGeneralPurpose(i);return null==l?o:o+l}}He.VARIABLE_LENGTH=[],He.TWO_DIGIT_DATA_LENGTH=[["00",18],["01",14],["02",14],["10",He.VARIABLE_LENGTH,20],["11",6],["12",6],["13",6],["15",6],["17",6],["20",2],["21",He.VARIABLE_LENGTH,20],["22",He.VARIABLE_LENGTH,29],["30",He.VARIABLE_LENGTH,8],["37",He.VARIABLE_LENGTH,8],["90",He.VARIABLE_LENGTH,30],["91",He.VARIABLE_LENGTH,30],["92",He.VARIABLE_LENGTH,30],["93",He.VARIABLE_LENGTH,30],["94",He.VARIABLE_LENGTH,30],["95",He.VARIABLE_LENGTH,30],["96",He.VARIABLE_LENGTH,30],["97",He.VARIABLE_LENGTH,3],["98",He.VARIABLE_LENGTH,30],["99",He.VARIABLE_LENGTH,30]],He.THREE_DIGIT_DATA_LENGTH=[["240",He.VARIABLE_LENGTH,30],["241",He.VARIABLE_LENGTH,30],["242",He.VARIABLE_LENGTH,6],["250",He.VARIABLE_LENGTH,30],["251",He.VARIABLE_LENGTH,30],["253",He.VARIABLE_LENGTH,17],["254",He.VARIABLE_LENGTH,20],["400",He.VARIABLE_LENGTH,30],["401",He.VARIABLE_LENGTH,30],["402",17],["403",He.VARIABLE_LENGTH,30],["410",13],["411",13],["412",13],["413",13],["414",13],["420",He.VARIABLE_LENGTH,20],["421",He.VARIABLE_LENGTH,15],["422",3],["423",He.VARIABLE_LENGTH,15],["424",3],["425",3],["426",3]],He.THREE_DIGIT_PLUS_DIGIT_DATA_LENGTH=[["310",6],["311",6],["312",6],["313",6],["314",6],["315",6],["316",6],["320",6],["321",6],["322",6],["323",6],["324",6],["325",6],["326",6],["327",6],["328",6],["329",6],["330",6],["331",6],["332",6],["333",6],["334",6],["335",6],["336",6],["340",6],["341",6],["342",6],["343",6],["344",6],["345",6],["346",6],["347",6],["348",6],["349",6],["350",6],["351",6],["352",6],["353",6],["354",6],["355",6],["356",6],["357",6],["360",6],["361",6],["362",6],["363",6],["364",6],["365",6],["366",6],["367",6],["368",6],["369",6],["390",He.VARIABLE_LENGTH,15],["391",He.VARIABLE_LENGTH,18],["392",He.VARIABLE_LENGTH,15],["393",He.VARIABLE_LENGTH,18],["703",He.VARIABLE_LENGTH,30]],He.FOUR_DIGIT_DATA_LENGTH=[["7001",13],["7002",He.VARIABLE_LENGTH,30],["7003",10],["8001",14],["8002",He.VARIABLE_LENGTH,20],["8003",He.VARIABLE_LENGTH,30],["8004",He.VARIABLE_LENGTH,30],["8005",6],["8006",18],["8007",He.VARIABLE_LENGTH,30],["8008",He.VARIABLE_LENGTH,12],["8018",18],["8020",He.VARIABLE_LENGTH,25],["8100",6],["8101",10],["8102",2],["8110",He.VARIABLE_LENGTH,70],["8200",He.VARIABLE_LENGTH,70]];class Ve{constructor(e){this.buffer=new T,this.information=e}decodeAllCodes(e,t){let n=t,r=null;for(;;){let t=this.decodeGeneralPurposeField(n,r),s=He.parseFieldsInGeneralPurpose(t.getNewString());if(null!=s&&e.append(s),r=t.isRemaining()?""+t.getRemainingValue():null,n===t.getNewPosition())break;n=t.getNewPosition()}return e.toString()}isStillNumeric(e){if(e+7>this.information.getSize())return e+4<=this.information.getSize();for(let t=e;t<e+3;++t)if(this.information.get(t))return!0;return this.information.get(e+3)}decodeNumeric(e){if(e+7>this.information.getSize()){let t=this.extractNumericValueFromBitArray(e,4);return new ze(this.information.getSize(),0===t?ze.FNC1:t-1,ze.FNC1)}let t=this.extractNumericValueFromBitArray(e,7);return new ze(e+7,(t-8)/11,(t-8)%11)}extractNumericValueFromBitArray(e,t){return Ve.extractNumericValueFromBitArray(this.information,e,t)}static extractNumericValueFromBitArray(e,t,n){let r=0;for(let s=0;s<n;++s)e.get(t+s)&&(r|=1<<n-s-1);return r}decodeGeneralPurposeField(e,t){this.buffer.setLengthToZero(),null!=t&&this.buffer.append(t),this.current.setPosition(e);let n=this.parseBlocks();return null!=n&&n.isRemaining()?new We(this.current.getPosition(),this.buffer.toString(),n.getRemainingValue()):new We(this.current.getPosition(),this.buffer.toString())}parseBlocks(){let e,t;do{let n=this.current.getPosition();if(this.current.isAlpha()?(t=this.parseAlphaBlock(),e=t.isFinished()):this.current.isIsoIec646()?(t=this.parseIsoIec646Block(),e=t.isFinished()):(t=this.parseNumericBlock(),e=t.isFinished()),n===this.current.getPosition()&&!e)break}while(!e);return t.getDecodedInformation()}parseNumericBlock(){for(;this.isStillNumeric(this.current.getPosition());){let e=this.decodeNumeric(this.current.getPosition());if(this.current.setPosition(e.getNewPosition()),e.isFirstDigitFNC1()){let t;return t=e.isSecondDigitFNC1()?new We(this.current.getPosition(),this.buffer.toString()):new We(this.current.getPosition(),this.buffer.toString(),e.getSecondDigit()),new Be(!0,t)}if(this.buffer.append(e.getFirstDigit()),e.isSecondDigitFNC1()){let e=new We(this.current.getPosition(),this.buffer.toString());return new Be(!0,e)}this.buffer.append(e.getSecondDigit())}return this.isNumericToAlphaNumericLatch(this.current.getPosition())&&(this.current.setAlpha(),this.current.incrementPosition(4)),new Be(!1)}parseIsoIec646Block(){for(;this.isStillIsoIec646(this.current.getPosition());){let e=this.decodeIsoIec646(this.current.getPosition());if(this.current.setPosition(e.getNewPosition()),e.isFNC1()){let e=new We(this.current.getPosition(),this.buffer.toString());return new Be(!0,e)}this.buffer.append(e.getValue())}return this.isAlphaOr646ToNumericLatch(this.current.getPosition())?(this.current.incrementPosition(3),this.current.setNumeric()):this.isAlphaTo646ToAlphaLatch(this.current.getPosition())&&(this.current.getPosition()+5<this.information.getSize()?this.current.incrementPosition(5):this.current.setPosition(this.information.getSize()),this.current.setAlpha()),new Be(!1)}parseAlphaBlock(){for(;this.isStillAlpha(this.current.getPosition());){let e=this.decodeAlphanumeric(this.current.getPosition());if(this.current.setPosition(e.getNewPosition()),e.isFNC1()){let e=new We(this.current.getPosition(),this.buffer.toString());return new Be(!0,e)}this.buffer.append(e.getValue())}return this.isAlphaOr646ToNumericLatch(this.current.getPosition())?(this.current.incrementPosition(3),this.current.setNumeric()):this.isAlphaTo646ToAlphaLatch(this.current.getPosition())&&(this.current.getPosition()+5<this.information.getSize()?this.current.incrementPosition(5):this.current.setPosition(this.information.getSize()),this.current.setIsoIec646()),new Be(!1)}isStillIsoIec646(e){if(e+5>this.information.getSize())return!1;let t=this.extractNumericValueFromBitArray(e,5);if(t>=5&&t<16)return!0;if(e+7>this.information.getSize())return!1;let n=this.extractNumericValueFromBitArray(e,7);if(n>=64&&n<116)return!0;if(e+8>this.information.getSize())return!1;let r=this.extractNumericValueFromBitArray(e,8);return r>=232&&r<253}decodeIsoIec646(e){let t=this.extractNumericValueFromBitArray(e,5);if(15===t)return new Ue(e+5,Ue.FNC1);if(t>=5&&t<15)return new Ue(e+5,"0"+(t-5));let n,r=this.extractNumericValueFromBitArray(e,7);if(r>=64&&r<90)return new Ue(e+7,""+(r+1));if(r>=90&&r<116)return new Ue(e+7,""+(r+7));switch(this.extractNumericValueFromBitArray(e,8)){case 232:n="!";break;case 233:n='"';break;case 234:n="%";break;case 235:n="&";break;case 236:n="'";break;case 237:n="(";break;case 238:n=")";break;case 239:n="*";break;case 240:n="+";break;case 241:n=",";break;case 242:n="-";break;case 243:n=".";break;case 244:n="/";break;case 245:n=":";break;case 246:n=";";break;case 247:n="<";break;case 248:n="=";break;case 249:n=">";break;case 250:n="?";break;case 251:n="_";break;case 252:n=" ";break;default:throw new S}return new Ue(e+8,n)}isStillAlpha(e){if(e+5>this.information.getSize())return!1;let t=this.extractNumericValueFromBitArray(e,5);if(t>=5&&t<16)return!0;if(e+6>this.information.getSize())return!1;let n=this.extractNumericValueFromBitArray(e,6);return n>=16&&n<63}decodeAlphanumeric(e){let t=this.extractNumericValueFromBitArray(e,5);if(15===t)return new Ue(e+5,Ue.FNC1);if(t>=5&&t<15)return new Ue(e+5,"0"+(t-5));let n,r=this.extractNumericValueFromBitArray(e,6);if(r>=32&&r<58)return new Ue(e+6,""+(r+33));switch(r){case 58:n="*";break;case 59:n=",";break;case 60:n="-";break;case 61:n=".";break;case 62:n="/";break;default:throw new ne("Decoding invalid alphanumeric value: "+r)}return new Ue(e+6,n)}isAlphaTo646ToAlphaLatch(e){if(e+1>this.information.getSize())return!1;for(let t=0;t<5&&t+e<this.information.getSize();++t)if(2===t){if(!this.information.get(e+2))return!1}else if(this.information.get(e+t))return!1;return!0}isAlphaOr646ToNumericLatch(e){if(e+3>this.information.getSize())return!1;for(let t=e;t<e+3;++t)if(this.information.get(t))return!1;return!0}isNumericToAlphaNumericLatch(e){if(e+1>this.information.getSize())return!1;for(let t=0;t<4&&t+e<this.information.getSize();++t)if(this.information.get(e+t))return!1;return!0}}class Ge{constructor(e){this.information=e,this.generalDecoder=new Ve(e)}getInformation(){return this.information}getGeneralDecoder(){return this.generalDecoder}}class Je extends Ge{constructor(e){super(e)}encodeCompressedGtin(e,t){e.append("(01)");let n=e.length();e.append("9"),this.encodeCompressedGtinWithoutAI(e,t,n)}encodeCompressedGtinWithoutAI(e,t,n){for(let r=0;r<4;++r){let n=this.getGeneralDecoder().extractNumericValueFromBitArray(t+10*r,10);n/100===0&&e.append("0"),n/10===0&&e.append("0"),e.append(n)}Je.appendCheckDigit(e,n)}static appendCheckDigit(e,t){let n=0;for(let r=0;r<13;r++){let s=e.charAt(r+t).charCodeAt(0)-"0".charCodeAt(0);n+=0===(1&r)?3*s:s}n=10-n%10,10===n&&(n=0),e.append(n)}}Je.GTIN_SIZE=40;class Qe extends Je{constructor(e){super(e)}parseInformation(){let e=new T;e.append("(01)");let t=e.length(),n=this.getGeneralDecoder().extractNumericValueFromBitArray(Qe.HEADER_SIZE,4);return e.append(n),this.encodeCompressedGtinWithoutAI(e,Qe.HEADER_SIZE+4,t),this.getGeneralDecoder().decodeAllCodes(e,Qe.HEADER_SIZE+44)}}Qe.HEADER_SIZE=4;class Ke extends Ge{constructor(e){super(e)}parseInformation(){let e=new T;return this.getGeneralDecoder().decodeAllCodes(e,Ke.HEADER_SIZE)}}Ke.HEADER_SIZE=5;class Ye extends Je{constructor(e){super(e)}encodeCompressedWeight(e,t,n){let r=this.getGeneralDecoder().extractNumericValueFromBitArray(t,n);this.addWeightCode(e,r);let s=this.checkWeight(r),a=1e5;for(let i=0;i<5;++i)s/a===0&&e.append("0"),a/=10;e.append(s)}}class qe extends Ye{constructor(e){super(e)}parseInformation(){if(this.getInformation().getSize()!=qe.HEADER_SIZE+Ye.GTIN_SIZE+qe.WEIGHT_SIZE)throw new _;let e=new T;return this.encodeCompressedGtin(e,qe.HEADER_SIZE),this.encodeCompressedWeight(e,qe.HEADER_SIZE+Ye.GTIN_SIZE,qe.WEIGHT_SIZE),e.toString()}}qe.HEADER_SIZE=5,qe.WEIGHT_SIZE=15;class Xe extends qe{constructor(e){super(e)}addWeightCode(e,t){e.append("(3103)")}checkWeight(e){return e}}class Ze extends qe{constructor(e){super(e)}addWeightCode(e,t){t<1e4?e.append("(3202)"):e.append("(3203)")}checkWeight(e){return e<1e4?e:e-1e4}}class $e extends Je{constructor(e){super(e)}parseInformation(){if(this.getInformation().getSize()<$e.HEADER_SIZE+Je.GTIN_SIZE)throw new _;let e=new T;this.encodeCompressedGtin(e,$e.HEADER_SIZE);let t=this.getGeneralDecoder().extractNumericValueFromBitArray($e.HEADER_SIZE+Je.GTIN_SIZE,$e.LAST_DIGIT_SIZE);e.append("(392"),e.append(t),e.append(")");let n=this.getGeneralDecoder().decodeGeneralPurposeField($e.HEADER_SIZE+Je.GTIN_SIZE+$e.LAST_DIGIT_SIZE,null);return e.append(n.getNewString()),e.toString()}}$e.HEADER_SIZE=8,$e.LAST_DIGIT_SIZE=2;class et extends Je{constructor(e){super(e)}parseInformation(){if(this.getInformation().getSize()<et.HEADER_SIZE+Je.GTIN_SIZE)throw new _;let e=new T;this.encodeCompressedGtin(e,et.HEADER_SIZE);let t=this.getGeneralDecoder().extractNumericValueFromBitArray(et.HEADER_SIZE+Je.GTIN_SIZE,et.LAST_DIGIT_SIZE);e.append("(393"),e.append(t),e.append(")");let n=this.getGeneralDecoder().extractNumericValueFromBitArray(et.HEADER_SIZE+Je.GTIN_SIZE+et.LAST_DIGIT_SIZE,et.FIRST_THREE_DIGITS_SIZE);n/100==0&&e.append("0"),n/10==0&&e.append("0"),e.append(n);let r=this.getGeneralDecoder().decodeGeneralPurposeField(et.HEADER_SIZE+Je.GTIN_SIZE+et.LAST_DIGIT_SIZE+et.FIRST_THREE_DIGITS_SIZE,null);return e.append(r.getNewString()),e.toString()}}et.HEADER_SIZE=8,et.LAST_DIGIT_SIZE=2,et.FIRST_THREE_DIGITS_SIZE=10;class tt extends Ye{constructor(e,t,n){super(e),this.dateCode=n,this.firstAIdigits=t}parseInformation(){if(this.getInformation().getSize()!=tt.HEADER_SIZE+tt.GTIN_SIZE+tt.WEIGHT_SIZE+tt.DATE_SIZE)throw new _;let e=new T;return this.encodeCompressedGtin(e,tt.HEADER_SIZE),this.encodeCompressedWeight(e,tt.HEADER_SIZE+tt.GTIN_SIZE,tt.WEIGHT_SIZE),this.encodeCompressedDate(e,tt.HEADER_SIZE+tt.GTIN_SIZE+tt.WEIGHT_SIZE),e.toString()}encodeCompressedDate(e,t){let n=this.getGeneralDecoder().extractNumericValueFromBitArray(t,tt.DATE_SIZE);if(38400==n)return;e.append("("),e.append(this.dateCode),e.append(")");let r=n%32;n/=32;let s=n%12+1;n/=12;let a=n;a/10==0&&e.append("0"),e.append(a),s/10==0&&e.append("0"),e.append(s),r/10==0&&e.append("0"),e.append(r)}addWeightCode(e,t){e.append("("),e.append(this.firstAIdigits),e.append(t/1e5),e.append(")")}checkWeight(e){return e%1e5}}function nt(e){try{if(e.get(1))return new Qe(e);if(!e.get(2))return new Ke(e);switch(Ve.extractNumericValueFromBitArray(e,1,4)){case 4:return new Xe(e);case 5:return new Ze(e)}switch(Ve.extractNumericValueFromBitArray(e,1,5)){case 12:return new $e(e);case 13:return new et(e)}switch(Ve.extractNumericValueFromBitArray(e,1,7)){case 56:return new tt(e,"310","11");case 57:return new tt(e,"320","11");case 58:return new tt(e,"310","13");case 59:return new tt(e,"320","13");case 60:return new tt(e,"310","15");case 61:return new tt(e,"320","15");case 62:return new tt(e,"310","17");case 63:return new tt(e,"320","17")}}catch(t){throw console.log(t),new ne("unknown decoder: "+e)}}tt.HEADER_SIZE=8,tt.WEIGHT_SIZE=20,tt.DATE_SIZE=16;class rt{constructor(e,t,n,r){this.leftchar=e,this.rightchar=t,this.finderpattern=n,this.maybeLast=r}mayBeLast(){return this.maybeLast}getLeftChar(){return this.leftchar}getRightChar(){return this.rightchar}getFinderPattern(){return this.finderpattern}mustBeLast(){return null==this.rightchar}toString(){return"[ "+this.leftchar+", "+this.rightchar+" : "+(null==this.finderpattern?"null":this.finderpattern.getValue())+" ]"}static equals(e,t){return e instanceof rt&&rt.equalsOrNull(e.leftchar,t.leftchar)&&rt.equalsOrNull(e.rightchar,t.rightchar)&&rt.equalsOrNull(e.finderpattern,t.finderpattern)}static equalsOrNull(e,t){return null===e?null===t:rt.equals(e,t)}hashCode(){return this.leftchar.getValue()^this.rightchar.getValue()^this.finderpattern.getValue()}}class st{constructor(e,t,n){this.pairs=e,this.rowNumber=t,this.wasReversed=n}getPairs(){return this.pairs}getRowNumber(){return this.rowNumber}isReversed(){return this.wasReversed}isEquivalent(e){return this.checkEqualitity(this,e)}toString(){return"{ "+this.pairs+" }"}equals(e,t){return e instanceof st&&this.checkEqualitity(e,t)&&e.wasReversed===t.wasReversed}checkEqualitity(e,t){if(!e||!t)return;let n;return e.forEach((e,r)=>{t.forEach(t=>{e.getLeftChar().getValue()===t.getLeftChar().getValue()&&e.getRightChar().getValue()===t.getRightChar().getValue()&&e.getFinderPatter().getValue()===t.getFinderPatter().getValue()&&(n=!0)})}),n}}class at extends De{constructor(e){super(...arguments),this.pairs=new Array(at.MAX_PAIRS),this.rows=new Array,this.startEnd=[2],this.verbose=!0===e}decodeRow(e,t,n){this.pairs.length=0,this.startFromEven=!1;try{return at.constructResult(this.decodeRow2pairs(e,t))}catch(r){this.verbose&&console.log(r)}return this.pairs.length=0,this.startFromEven=!0,at.constructResult(this.decodeRow2pairs(e,t))}reset(){this.pairs.length=0,this.rows.length=0}decodeRow2pairs(e,t){let n,r=!1;for(;!r;)try{this.pairs.push(this.retrieveNextPair(t,this.pairs,e))}catch(s){if(s instanceof _){if(!this.pairs.length)throw new _;r=!0}}if(this.checkChecksum())return this.pairs;if(n=!!this.rows.length,this.storeRow(e,!1),n){let e=this.checkRowsBoolean(!1);if(null!=e)return e;if(e=this.checkRowsBoolean(!0),null!=e)return e}throw new _}checkRowsBoolean(e){if(this.rows.length>25)return this.rows.length=0,null;this.pairs.length=0,e&&(this.rows=this.rows.reverse());let t=null;try{t=this.checkRows(new Array,0)}catch(n){this.verbose&&console.log(n)}return e&&(this.rows=this.rows.reverse()),t}checkRows(e,t){for(let r=t;r<this.rows.length;r++){let t=this.rows[r];this.pairs.length=0;for(let n of e)this.pairs.push(n.getPairs());if(this.pairs.push(t.getPairs()),!at.isValidSequence(this.pairs))continue;if(this.checkChecksum())return this.pairs;let s=new Array(e);s.push(t);try{return this.checkRows(s,r+1)}catch(n){this.verbose&&console.log(n)}}throw new _}static isValidSequence(e){for(let t of at.FINDER_PATTERN_SEQUENCES){if(e.length>t.length)continue;let n=!0;for(let r=0;r<e.length;r++)if(e[r].getFinderPattern().getValue()!=t[r]){n=!1;break}if(n)return!0}return!1}storeRow(e,t){let n=0,r=!1,s=!1;for(;n<this.rows.length;){let t=this.rows[n];if(t.getRowNumber()>e){s=t.isEquivalent(this.pairs);break}r=t.isEquivalent(this.pairs),n++}s||r||at.isPartialRow(this.pairs,this.rows)||(this.rows.push(n,new st(this.pairs,e,t)),this.removePartialRows(this.pairs,this.rows))}removePartialRows(e,t){for(let n of t)if(n.getPairs().length!==e.length)for(let t of n.getPairs())for(let n of e)if(rt.equals(t,n))break}static isPartialRow(e,t){for(let n of t){let t=!0;for(let r of e){let e=!1;for(let t of n.getPairs())if(r.equals(t)){e=!0;break}if(!e){t=!1;break}}if(t)return!0}return!1}getRows(){return this.rows}static constructResult(e){let t=nt(Le.buildBitArray(e)).parseInformation(),n=e[0].getFinderPattern().getResultPoints(),r=e[e.length-1].getFinderPattern().getResultPoints(),s=[n[0],n[1],r[0],r[1]];return new U(t,null,null,s,z.RSS_EXPANDED,null)}checkChecksum(){let e=this.pairs.get(0),t=e.getLeftChar(),n=e.getRightChar();if(null==n)return!1;let r=n.getChecksumPortion(),s=2;for(let a=1;a<this.pairs.size();++a){let e=this.pairs.get(a);r+=e.getLeftChar().getChecksumPortion(),s++;let t=e.getRightChar();null!=t&&(r+=t.getChecksumPortion(),s++)}return r%=211,211*(s-4)+r==t.getValue()}static getNextSecondBar(e,t){let n;return e.get(t)?(n=e.getNextUnset(t),n=e.getNextSet(n)):(n=e.getNextSet(t),n=e.getNextUnset(n)),n}retrieveNextPair(e,t,n){let r,s=t.length%2==0;this.startFromEven&&(s=!s);let a=!0,i=-1;do{this.findNextPair(e,t,i),r=this.parseFoundFinderPattern(e,n,s),null==r?i=at.getNextSecondBar(e,this.startEnd[0]):a=!1}while(a);let o,l=this.decodeDataCharacter(e,r,s,!0);if(!this.isEmptyPair(t)&&t[t.length-1].mustBeLast())throw new _;try{o=this.decodeDataCharacter(e,r,s,!1)}catch(c){o=null,this.verbose&&console.log(c)}return new rt(l,o,r,!0)}isEmptyPair(e){return 0===e.length}findNextPair(e,t,n){let r=this.getDecodeFinderCounters();r[0]=0,r[1]=0,r[2]=0,r[3]=0;let s,a=e.getSize();s=n>=0?n:this.isEmptyPair(t)?0:t[t.length-1].getFinderPattern().getStartEnd()[1];let i=t.length%2!=0;this.startFromEven&&(i=!i);let o=!1;for(;s<a&&(o=!e.get(s),o);)s++;let l=0,c=s;for(let u=s;u<a;u++)if(e.get(u)!=o)r[l]++;else{if(3==l){if(i&&at.reverseCounters(r),at.isFinderPattern(r))return this.startEnd[0]=c,void(this.startEnd[1]=u);i&&at.reverseCounters(r),c+=r[0]+r[1],r[0]=r[2],r[1]=r[3],r[2]=0,r[3]=0,l--}else l++;r[l]=1,o=!o}throw new _}static reverseCounters(e){let t=e.length;for(let n=0;n<t/2;++n){let r=e[n];e[n]=e[t-n-1],e[t-n-1]=r}}parseFoundFinderPattern(e,t,n){let r,s,a;if(n){let t=this.startEnd[0]-1;for(;t>=0&&!e.get(t);)t--;t++,r=this.startEnd[0]-t,s=t,a=this.startEnd[1]}else s=this.startEnd[0],a=e.getNextUnset(this.startEnd[1]+1),r=a-this.startEnd[1];let i,o=this.getDecodeFinderCounters();m.arraycopy(o,0,o,1,o.length-1),o[0]=r;try{i=this.parseFinderValue(o,at.FINDER_PATTERNS)}catch(l){return null}return new Oe(i,[s,a],s,a,t)}decodeDataCharacter(e,t,n,r){let s=this.getDataCharacterCounters();for(let C=0;C<s.length;C++)s[C]=0;if(r)at.recordPatternInReverse(e,t.getStartEnd()[0],s);else{at.recordPattern(e,t.getStartEnd()[1],s);for(let e=0,t=s.length-1;e<t;e++,t--){let n=s[e];s[e]=s[t],s[t]=n}}let a=17,i=ae.sum(new Int32Array(s))/a,o=(t.getStartEnd()[1]-t.getStartEnd()[0])/15;if(Math.abs(i-o)/o>.3)throw new _;let l=this.getOddCounts(),c=this.getEvenCounts(),u=this.getOddRoundingErrors(),d=this.getEvenRoundingErrors();for(let C=0;C<s.length;C++){let e=1*s[C]/i,t=e+.5;if(t<1){if(e<.3)throw new _;t=1}else if(t>8){if(e>8.7)throw new _;t=8}let n=C/2;0==(1&C)?(l[n]=t,u[n]=e-t):(c[n]=t,d[n]=e-t)}this.adjustOddEvenCounts(a);let h=4*t.getValue()+(n?0:2)+(r?0:1)-1,f=0,p=0;for(let C=l.length-1;C>=0;C--){if(at.isNotA1left(t,n,r)){let e=at.WEIGHTS[h][2*C];p+=l[C]*e}f+=l[C]}let m=0;for(let C=c.length-1;C>=0;C--)if(at.isNotA1left(t,n,r)){let e=at.WEIGHTS[h][2*C+1];m+=c[C]*e}let g=p+m;if(0!=(1&f)||f>13||f<4)throw new _;let y=(13-f)/2,w=at.SYMBOL_WIDEST[y],v=9-w,A=Pe.getRSSvalue(l,w,!0),b=Pe.getRSSvalue(c,v,!1),x=at.EVEN_TOTAL_SUBSET[y],S=at.GSUM[y];return new je(A*x+b+S,g)}static isNotA1left(e,t,n){return!(0==e.getValue()&&t&&n)}adjustOddEvenCounts(e){let t=ae.sum(new Int32Array(this.getOddCounts())),n=ae.sum(new Int32Array(this.getEvenCounts())),r=!1,s=!1;t>13?s=!0:t<4&&(r=!0);let a=!1,i=!1;n>13?i=!0:n<4&&(a=!0);let o=t+n-e,l=1==(1&t),c=0==(1&n);if(1==o)if(l){if(c)throw new _;s=!0}else{if(!c)throw new _;i=!0}else if(-1==o)if(l){if(c)throw new _;r=!0}else{if(!c)throw new _;a=!0}else{if(0!=o)throw new _;if(l){if(!c)throw new _;t<n?(r=!0,i=!0):(s=!0,a=!0)}else if(c)throw new _}if(r){if(s)throw new _;at.increment(this.getOddCounts(),this.getOddRoundingErrors())}if(s&&at.decrement(this.getOddCounts(),this.getOddRoundingErrors()),a){if(i)throw new _;at.increment(this.getEvenCounts(),this.getOddRoundingErrors())}i&&at.decrement(this.getEvenCounts(),this.getEvenRoundingErrors())}}at.SYMBOL_WIDEST=[7,5,4,3,1],at.EVEN_TOTAL_SUBSET=[4,20,52,104,204],at.GSUM=[0,348,1388,2948,3988],at.FINDER_PATTERNS=[Int32Array.from([1,8,4,1]),Int32Array.from([3,6,4,1]),Int32Array.from([3,4,6,1]),Int32Array.from([3,2,8,1]),Int32Array.from([2,6,5,1]),Int32Array.from([2,2,9,1])],at.WEIGHTS=[[1,3,9,27,81,32,96,77],[20,60,180,118,143,7,21,63],[189,145,13,39,117,140,209,205],[193,157,49,147,19,57,171,91],[62,186,136,197,169,85,44,132],[185,133,188,142,4,12,36,108],[113,128,173,97,80,29,87,50],[150,28,84,41,123,158,52,156],[46,138,203,187,139,206,196,166],[76,17,51,153,37,111,122,155],[43,129,176,106,107,110,119,146],[16,48,144,10,30,90,59,177],[109,116,137,200,178,112,125,164],[70,210,208,202,184,130,179,115],[134,191,151,31,93,68,204,190],[148,22,66,198,172,94,71,2],[6,18,54,162,64,192,154,40],[120,149,25,75,14,42,126,167],[79,26,78,23,69,207,199,175],[103,98,83,38,114,131,182,124],[161,61,183,127,170,88,53,159],[55,165,73,8,24,72,5,15],[45,135,194,160,58,174,100,89]],at.FINDER_PAT_A=0,at.FINDER_PAT_B=1,at.FINDER_PAT_C=2,at.FINDER_PAT_D=3,at.FINDER_PAT_E=4,at.FINDER_PAT_F=5,at.FINDER_PATTERN_SEQUENCES=[[at.FINDER_PAT_A,at.FINDER_PAT_A],[at.FINDER_PAT_A,at.FINDER_PAT_B,at.FINDER_PAT_B],[at.FINDER_PAT_A,at.FINDER_PAT_C,at.FINDER_PAT_B,at.FINDER_PAT_D],[at.FINDER_PAT_A,at.FINDER_PAT_E,at.FINDER_PAT_B,at.FINDER_PAT_D,at.FINDER_PAT_C],[at.FINDER_PAT_A,at.FINDER_PAT_E,at.FINDER_PAT_B,at.FINDER_PAT_D,at.FINDER_PAT_D,at.FINDER_PAT_F],[at.FINDER_PAT_A,at.FINDER_PAT_E,at.FINDER_PAT_B,at.FINDER_PAT_D,at.FINDER_PAT_E,at.FINDER_PAT_F,at.FINDER_PAT_F],[at.FINDER_PAT_A,at.FINDER_PAT_A,at.FINDER_PAT_B,at.FINDER_PAT_B,at.FINDER_PAT_C,at.FINDER_PAT_C,at.FINDER_PAT_D,at.FINDER_PAT_D],[at.FINDER_PAT_A,at.FINDER_PAT_A,at.FINDER_PAT_B,at.FINDER_PAT_B,at.FINDER_PAT_C,at.FINDER_PAT_C,at.FINDER_PAT_D,at.FINDER_PAT_E,at.FINDER_PAT_E],[at.FINDER_PAT_A,at.FINDER_PAT_A,at.FINDER_PAT_B,at.FINDER_PAT_B,at.FINDER_PAT_C,at.FINDER_PAT_C,at.FINDER_PAT_D,at.FINDER_PAT_E,at.FINDER_PAT_F,at.FINDER_PAT_F],[at.FINDER_PAT_A,at.FINDER_PAT_A,at.FINDER_PAT_B,at.FINDER_PAT_B,at.FINDER_PAT_C,at.FINDER_PAT_D,at.FINDER_PAT_D,at.FINDER_PAT_E,at.FINDER_PAT_E,at.FINDER_PAT_F,at.FINDER_PAT_F]],at.MAX_PAIRS=11;class it extends je{constructor(e,t,n){super(e,t),this.count=0,this.finderPattern=n}getFinderPattern(){return this.finderPattern}getCount(){return this.count}incrementCount(){this.count++}}class ot extends De{constructor(){super(...arguments),this.possibleLeftPairs=[],this.possibleRightPairs=[]}decodeRow(e,t,n){const r=this.decodePair(t,!1,e,n);ot.addOrTally(this.possibleLeftPairs,r),t.reverse();let s=this.decodePair(t,!0,e,n);ot.addOrTally(this.possibleRightPairs,s),t.reverse();for(let a of this.possibleLeftPairs)if(a.getCount()>1)for(let e of this.possibleRightPairs)if(e.getCount()>1&&ot.checkChecksum(a,e))return ot.constructResult(a,e);throw new _}static addOrTally(e,t){if(null==t)return;let n=!1;for(let r of e)if(r.getValue()===t.getValue()){r.incrementCount(),n=!0;break}n||e.push(t)}reset(){this.possibleLeftPairs.length=0,this.possibleRightPairs.length=0}static constructResult(e,t){let n=4537077*e.getValue()+t.getValue(),r=new String(n).toString(),s=new T;for(let l=13-r.length;l>0;l--)s.append("0");s.append(r);let a=0;for(let l=0;l<13;l++){let e=s.charAt(l).charCodeAt(0)-"0".charCodeAt(0);a+=0===(1&l)?3*e:e}a=10-a%10,10===a&&(a=0),s.append(a.toString());let i=e.getFinderPattern().getResultPoints(),o=t.getFinderPattern().getResultPoints();return new U(s.toString(),null,0,[i[0],i[1],o[0],o[1]],z.RSS_14,(new Date).getTime())}static checkChecksum(e,t){let n=(e.getChecksumPortion()+16*t.getChecksumPortion())%79,r=9*e.getFinderPattern().getValue()+t.getFinderPattern().getValue();return r>72&&r--,r>8&&r--,n===r}decodePair(e,t,n,r){try{let s=this.findFinderPattern(e,t),a=this.parseFoundFinderPattern(e,n,t,s),i=null==r?null:r.get(x.NEED_RESULT_POINT_CALLBACK);if(null!=i){let r=(s[0]+s[1])/2;t&&(r=e.getSize()-1-r),i.foundPossibleResultPoint(new oe(r,n))}let o=this.decodeDataCharacter(e,a,!0),l=this.decodeDataCharacter(e,a,!1);return new it(1597*o.getValue()+l.getValue(),o.getChecksumPortion()+4*l.getChecksumPortion(),a)}catch(s){return null}}decodeDataCharacter(e,t,n){let r=this.getDataCharacterCounters();for(let m=0;m<r.length;m++)r[m]=0;if(n)ve.recordPatternInReverse(e,t.getStartEnd()[0],r);else{ve.recordPattern(e,t.getStartEnd()[1]+1,r);for(let e=0,t=r.length-1;e<t;e++,t--){let n=r[e];r[e]=r[t],r[t]=n}}let s=n?16:15,a=ae.sum(new Int32Array(r))/s,i=this.getOddCounts(),o=this.getEvenCounts(),l=this.getOddRoundingErrors(),c=this.getEvenRoundingErrors();for(let m=0;m<r.length;m++){let e=r[m]/a,t=Math.floor(e+.5);t<1?t=1:t>8&&(t=8);let n=Math.floor(m/2);0===(1&m)?(i[n]=t,l[n]=e-t):(o[n]=t,c[n]=e-t)}this.adjustOddEvenCounts(n,s);let u=0,d=0;for(let m=i.length-1;m>=0;m--)d*=9,d+=i[m],u+=i[m];let h=0,f=0;for(let m=o.length-1;m>=0;m--)h*=9,h+=o[m],f+=o[m];let p=d+3*h;if(n){if(0!==(1&u)||u>12||u<4)throw new _;let e=(12-u)/2,t=ot.OUTSIDE_ODD_WIDEST[e],n=9-t,r=Pe.getRSSvalue(i,t,!1),s=Pe.getRSSvalue(o,n,!0),a=ot.OUTSIDE_EVEN_TOTAL_SUBSET[e],l=ot.OUTSIDE_GSUM[e];return new je(r*a+s+l,p)}{if(0!==(1&f)||f>10||f<4)throw new _;let e=(10-f)/2,t=ot.INSIDE_ODD_WIDEST[e],n=9-t,r=Pe.getRSSvalue(i,t,!0),s=Pe.getRSSvalue(o,n,!1),a=ot.INSIDE_ODD_TOTAL_SUBSET[e],l=ot.INSIDE_GSUM[e];return new je(s*a+r+l,p)}}findFinderPattern(e,t){let n=this.getDecodeFinderCounters();n[0]=0,n[1]=0,n[2]=0,n[3]=0;let r=e.getSize(),s=!1,a=0;for(;a<r&&(s=!e.get(a),t!==s);)a++;let i=0,o=a;for(let l=a;l<r;l++)if(e.get(l)!==s)n[i]++;else{if(3===i){if(De.isFinderPattern(n))return[o,l];o+=n[0]+n[1],n[0]=n[2],n[1]=n[3],n[2]=0,n[3]=0,i--}else i++;n[i]=1,s=!s}throw new _}parseFoundFinderPattern(e,t,n,r){let s=e.get(r[0]),a=r[0]-1;for(;a>=0&&s!==e.get(a);)a--;a++;const i=r[0]-a,o=this.getDecodeFinderCounters(),l=new Int32Array(o.length);m.arraycopy(o,0,l,1,o.length-1),l[0]=i;const c=this.parseFinderValue(l,ot.FINDER_PATTERNS);let u=a,d=r[1];return n&&(u=e.getSize()-1-u,d=e.getSize()-1-d),new Oe(c,[a,r[1]],u,d,t)}adjustOddEvenCounts(e,t){let n=ae.sum(new Int32Array(this.getOddCounts())),r=ae.sum(new Int32Array(this.getEvenCounts())),s=!1,a=!1,i=!1,o=!1;e?(n>12?a=!0:n<4&&(s=!0),r>12?o=!0:r<4&&(i=!0)):(n>11?a=!0:n<5&&(s=!0),r>10?o=!0:r<4&&(i=!0));let l=n+r-t,c=(1&n)===(e?1:0),u=1===(1&r);if(1===l)if(c){if(u)throw new _;a=!0}else{if(!u)throw new _;o=!0}else if(-1===l)if(c){if(u)throw new _;s=!0}else{if(!u)throw new _;i=!0}else{if(0!==l)throw new _;if(c){if(!u)throw new _;n<r?(s=!0,o=!0):(a=!0,i=!0)}else if(u)throw new _}if(s){if(a)throw new _;De.increment(this.getOddCounts(),this.getOddRoundingErrors())}if(a&&De.decrement(this.getOddCounts(),this.getOddRoundingErrors()),i){if(o)throw new _;De.increment(this.getEvenCounts(),this.getOddRoundingErrors())}o&&De.decrement(this.getEvenCounts(),this.getEvenRoundingErrors())}}ot.OUTSIDE_EVEN_TOTAL_SUBSET=[1,10,34,70,126],ot.INSIDE_ODD_TOTAL_SUBSET=[4,20,48,81],ot.OUTSIDE_GSUM=[0,161,961,2015,2715],ot.INSIDE_GSUM=[0,336,1036,1516],ot.OUTSIDE_ODD_WIDEST=[8,6,4,3,1],ot.INSIDE_ODD_WIDEST=[2,4,6,8],ot.FINDER_PATTERNS=[Int32Array.from([3,8,2,1]),Int32Array.from([3,5,5,1]),Int32Array.from([3,3,7,1]),Int32Array.from([3,1,9,1]),Int32Array.from([2,7,4,1]),Int32Array.from([2,5,6,1]),Int32Array.from([2,3,8,1]),Int32Array.from([1,5,7,1]),Int32Array.from([1,3,9,1])];class lt extends ve{constructor(e,t){super(),this.readers=[],this.verbose=!0===t;const n=e?e.get(x.POSSIBLE_FORMATS):null,r=e&&void 0!==e.get(x.ASSUME_CODE_39_CHECK_DIGIT);n?((n.includes(z.EAN_13)||n.includes(z.UPC_A)||n.includes(z.EAN_8)||n.includes(z.UPC_E))&&this.readers.push(new Me(e)),n.includes(z.CODE_39)&&this.readers.push(new be(r)),n.includes(z.CODE_128)&&this.readers.push(new Ae),n.includes(z.ITF)&&this.readers.push(new xe),n.includes(z.RSS_14)&&this.readers.push(new ot),n.includes(z.RSS_EXPANDED)&&this.readers.push(new at(this.verbose))):(this.readers.push(new Me(e)),this.readers.push(new be),this.readers.push(new Me(e)),this.readers.push(new Ae),this.readers.push(new xe),this.readers.push(new ot),this.readers.push(new at(this.verbose)))}decodeRow(e,t,n){for(let s=0;s<this.readers.length;s++)try{return this.readers[s].decodeRow(e,t,n)}catch(r){}throw new _}reset(){this.readers.forEach(e=>e.reset())}}class ct extends F{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:500,t=arguments.length>1?arguments[1]:void 0;super(new lt(t),e,t)}}class ut{constructor(e,t,n){this.ecCodewords=e,this.ecBlocks=[t],n&&this.ecBlocks.push(n)}getECCodewords(){return this.ecCodewords}getECBlocks(){return this.ecBlocks}}class dt{constructor(e,t){this.count=e,this.dataCodewords=t}getCount(){return this.count}getDataCodewords(){return this.dataCodewords}}class ht{constructor(e,t,n,r,s,a){this.versionNumber=e,this.symbolSizeRows=t,this.symbolSizeColumns=n,this.dataRegionSizeRows=r,this.dataRegionSizeColumns=s,this.ecBlocks=a;let i=0;const o=a.getECCodewords(),l=a.getECBlocks();for(let c of l)i+=c.getCount()*(c.getDataCodewords()+o);this.totalCodewords=i}getVersionNumber(){return this.versionNumber}getSymbolSizeRows(){return this.symbolSizeRows}getSymbolSizeColumns(){return this.symbolSizeColumns}getDataRegionSizeRows(){return this.dataRegionSizeRows}getDataRegionSizeColumns(){return this.dataRegionSizeColumns}getTotalCodewords(){return this.totalCodewords}getECBlocks(){return this.ecBlocks}static getVersionForDimensions(e,t){if(0!==(1&e)||0!==(1&t))throw new S;for(let n of ht.VERSIONS)if(n.symbolSizeRows===e&&n.symbolSizeColumns===t)return n;throw new S}toString(){return""+this.versionNumber}static buildVersions(){return[new ht(1,10,10,8,8,new ut(5,new dt(1,3))),new ht(2,12,12,10,10,new ut(7,new dt(1,5))),new ht(3,14,14,12,12,new ut(10,new dt(1,8))),new ht(4,16,16,14,14,new ut(12,new dt(1,12))),new ht(5,18,18,16,16,new ut(14,new dt(1,18))),new ht(6,20,20,18,18,new ut(18,new dt(1,22))),new ht(7,22,22,20,20,new ut(20,new dt(1,30))),new ht(8,24,24,22,22,new ut(24,new dt(1,36))),new ht(9,26,26,24,24,new ut(28,new dt(1,44))),new ht(10,32,32,14,14,new ut(36,new dt(1,62))),new ht(11,36,36,16,16,new ut(42,new dt(1,86))),new ht(12,40,40,18,18,new ut(48,new dt(1,114))),new ht(13,44,44,20,20,new ut(56,new dt(1,144))),new ht(14,48,48,22,22,new ut(68,new dt(1,174))),new ht(15,52,52,24,24,new ut(42,new dt(2,102))),new ht(16,64,64,14,14,new ut(56,new dt(2,140))),new ht(17,72,72,16,16,new ut(36,new dt(4,92))),new ht(18,80,80,18,18,new ut(48,new dt(4,114))),new ht(19,88,88,20,20,new ut(56,new dt(4,144))),new ht(20,96,96,22,22,new ut(68,new dt(4,174))),new ht(21,104,104,24,24,new ut(56,new dt(6,136))),new ht(22,120,120,18,18,new ut(68,new dt(6,175))),new ht(23,132,132,20,20,new ut(62,new dt(8,163))),new ht(24,144,144,22,22,new ut(62,new dt(8,156),new dt(2,155))),new ht(25,8,18,6,16,new ut(7,new dt(1,5))),new ht(26,8,32,6,14,new ut(11,new dt(1,10))),new ht(27,12,26,10,24,new ut(14,new dt(1,16))),new ht(28,12,36,10,16,new ut(18,new dt(1,22))),new ht(29,16,36,14,16,new ut(24,new dt(1,32))),new ht(30,16,48,14,22,new ut(28,new dt(1,49)))]}}ht.VERSIONS=ht.buildVersions();class ft{constructor(e){const t=e.getHeight();if(t<8||t>144||0!==(1&t))throw new S;this.version=ft.readVersion(e),this.mappingBitMatrix=this.extractDataRegion(e),this.readMappingMatrix=new I(this.mappingBitMatrix.getWidth(),this.mappingBitMatrix.getHeight())}getVersion(){return this.version}static readVersion(e){const t=e.getHeight(),n=e.getWidth();return ht.getVersionForDimensions(t,n)}readCodewords(){const e=new Int8Array(this.version.getTotalCodewords());let t=0,n=4,r=0;const s=this.mappingBitMatrix.getHeight(),a=this.mappingBitMatrix.getWidth();let i=!1,o=!1,l=!1,c=!1;do{if(n!==s||0!==r||i)if(n!==s-2||0!==r||0===(3&a)||o)if(n!==s+4||2!==r||0!==(7&a)||l)if(n!==s-2||0!==r||4!==(7&a)||c){do{n<s&&r>=0&&!this.readMappingMatrix.get(r,n)&&(e[t++]=255&this.readUtah(n,r,s,a)),n-=2,r+=2}while(n>=0&&r<a);n+=1,r+=3;do{n>=0&&r<a&&!this.readMappingMatrix.get(r,n)&&(e[t++]=255&this.readUtah(n,r,s,a)),n+=2,r-=2}while(n<s&&r>=0);n+=3,r+=1}else e[t++]=255&this.readCorner4(s,a),n-=2,r+=2,c=!0;else e[t++]=255&this.readCorner3(s,a),n-=2,r+=2,l=!0;else e[t++]=255&this.readCorner2(s,a),n-=2,r+=2,o=!0;else e[t++]=255&this.readCorner1(s,a),n-=2,r+=2,i=!0}while(n<s||r<a);if(t!==this.version.getTotalCodewords())throw new S;return e}readModule(e,t,n,r){return e<0&&(e+=n,t+=4-(n+4&7)),t<0&&(t+=r,e+=4-(r+4&7)),this.readMappingMatrix.set(t,e),this.mappingBitMatrix.get(t,e)}readUtah(e,t,n,r){let s=0;return this.readModule(e-2,t-2,n,r)&&(s|=1),s<<=1,this.readModule(e-2,t-1,n,r)&&(s|=1),s<<=1,this.readModule(e-1,t-2,n,r)&&(s|=1),s<<=1,this.readModule(e-1,t-1,n,r)&&(s|=1),s<<=1,this.readModule(e-1,t,n,r)&&(s|=1),s<<=1,this.readModule(e,t-2,n,r)&&(s|=1),s<<=1,this.readModule(e,t-1,n,r)&&(s|=1),s<<=1,this.readModule(e,t,n,r)&&(s|=1),s}readCorner1(e,t){let n=0;return this.readModule(e-1,0,e,t)&&(n|=1),n<<=1,this.readModule(e-1,1,e,t)&&(n|=1),n<<=1,this.readModule(e-1,2,e,t)&&(n|=1),n<<=1,this.readModule(0,t-2,e,t)&&(n|=1),n<<=1,this.readModule(0,t-1,e,t)&&(n|=1),n<<=1,this.readModule(1,t-1,e,t)&&(n|=1),n<<=1,this.readModule(2,t-1,e,t)&&(n|=1),n<<=1,this.readModule(3,t-1,e,t)&&(n|=1),n}readCorner2(e,t){let n=0;return this.readModule(e-3,0,e,t)&&(n|=1),n<<=1,this.readModule(e-2,0,e,t)&&(n|=1),n<<=1,this.readModule(e-1,0,e,t)&&(n|=1),n<<=1,this.readModule(0,t-4,e,t)&&(n|=1),n<<=1,this.readModule(0,t-3,e,t)&&(n|=1),n<<=1,this.readModule(0,t-2,e,t)&&(n|=1),n<<=1,this.readModule(0,t-1,e,t)&&(n|=1),n<<=1,this.readModule(1,t-1,e,t)&&(n|=1),n}readCorner3(e,t){let n=0;return this.readModule(e-1,0,e,t)&&(n|=1),n<<=1,this.readModule(e-1,t-1,e,t)&&(n|=1),n<<=1,this.readModule(0,t-3,e,t)&&(n|=1),n<<=1,this.readModule(0,t-2,e,t)&&(n|=1),n<<=1,this.readModule(0,t-1,e,t)&&(n|=1),n<<=1,this.readModule(1,t-3,e,t)&&(n|=1),n<<=1,this.readModule(1,t-2,e,t)&&(n|=1),n<<=1,this.readModule(1,t-1,e,t)&&(n|=1),n}readCorner4(e,t){let n=0;return this.readModule(e-3,0,e,t)&&(n|=1),n<<=1,this.readModule(e-2,0,e,t)&&(n|=1),n<<=1,this.readModule(e-1,0,e,t)&&(n|=1),n<<=1,this.readModule(0,t-2,e,t)&&(n|=1),n<<=1,this.readModule(0,t-1,e,t)&&(n|=1),n<<=1,this.readModule(1,t-1,e,t)&&(n|=1),n<<=1,this.readModule(2,t-1,e,t)&&(n|=1),n<<=1,this.readModule(3,t-1,e,t)&&(n|=1),n}extractDataRegion(e){const t=this.version.getSymbolSizeRows(),n=this.version.getSymbolSizeColumns();if(e.getHeight()!==t)throw new d("Dimension of bitMatrix must match the version size");const r=this.version.getDataRegionSizeRows(),s=this.version.getDataRegionSizeColumns(),a=t/r|0,i=n/s|0,o=new I(i*s,a*r);for(let l=0;l<a;++l){const t=l*r;for(let n=0;n<i;++n){const a=n*s;for(let i=0;i<r;++i){const c=l*(r+2)+1+i,u=t+i;for(let t=0;t<s;++t){const r=n*(s+2)+1+t;if(e.get(r,c)){const e=a+t;o.set(e,u)}}}}}return o}}class pt{constructor(e,t){this.numDataCodewords=e,this.codewords=t}static getDataBlocks(e,t){const n=t.getECBlocks();let r=0;const s=n.getECBlocks();for(let d of s)r+=d.getCount();const a=new Array(r);let i=0;for(let d of s)for(let e=0;e<d.getCount();e++){const e=d.getDataCodewords(),t=n.getECCodewords()+e;a[i++]=new pt(e,new Uint8Array(t))}const o=a[0].codewords.length-n.getECCodewords(),l=o-1;let c=0;for(let d=0;d<l;d++)for(let t=0;t<i;t++)a[t].codewords[d]=e[c++];const u=24===t.getVersionNumber(),h=u?8:i;for(let d=0;d<h;d++)a[d].codewords[o-1]=e[c++];const f=a[0].codewords.length;for(let d=o;d<f;d++)for(let t=0;t<i;t++){const n=u?(t+8)%i:t,r=u&&n>7?d-1:d;a[n].codewords[r]=e[c++]}if(c!==e.length)throw new d;return a}getNumDataCodewords(){return this.numDataCodewords}getCodewords(){return this.codewords}}class mt{constructor(e){this.bytes=e,this.byteOffset=0,this.bitOffset=0}getBitOffset(){return this.bitOffset}getByteOffset(){return this.byteOffset}readBits(e){if(e<1||e>32||e>this.available())throw new d(""+e);let t=0,n=this.bitOffset,r=this.byteOffset;const s=this.bytes;if(n>0){const a=8-n,i=e<a?e:a,o=a-i,l=255>>8-i<<o;t=(s[r]&l)>>o,e-=i,n+=i,8===n&&(n=0,r++)}if(e>0){for(;e>=8;)t=t<<8|255&s[r],r++,e-=8;if(e>0){const a=8-e,i=255>>a<<a;t=t<<e|(s[r]&i)>>a,n+=e}}return this.bitOffset=n,this.byteOffset=r,t}available(){return 8*(this.bytes.length-this.byteOffset)-this.bitOffset}}!function(e){e[e.PAD_ENCODE=0]="PAD_ENCODE",e[e.ASCII_ENCODE=1]="ASCII_ENCODE",e[e.C40_ENCODE=2]="C40_ENCODE",e[e.TEXT_ENCODE=3]="TEXT_ENCODE",e[e.ANSIX12_ENCODE=4]="ANSIX12_ENCODE",e[e.EDIFACT_ENCODE=5]="EDIFACT_ENCODE",e[e.BASE256_ENCODE=6]="BASE256_ENCODE"}(V||(V={}));class gt{static decode(e){const t=new mt(e),n=new T,r=new T,s=new Array;let a=V.ASCII_ENCODE;do{if(a===V.ASCII_ENCODE)a=this.decodeAsciiSegment(t,n,r);else{switch(a){case V.C40_ENCODE:this.decodeC40Segment(t,n);break;case V.TEXT_ENCODE:this.decodeTextSegment(t,n);break;case V.ANSIX12_ENCODE:this.decodeAnsiX12Segment(t,n);break;case V.EDIFACT_ENCODE:this.decodeEdifactSegment(t,n);break;case V.BASE256_ENCODE:this.decodeBase256Segment(t,n,s);break;default:throw new S}a=V.ASCII_ENCODE}}while(a!==V.PAD_ENCODE&&t.available()>0);return r.length()>0&&n.append(r.toString()),new q(e,n.toString(),0===s.length?null:s,null)}static decodeAsciiSegment(e,t,n){let r=!1;do{let s=e.readBits(8);if(0===s)throw new S;if(s<=128)return r&&(s+=128),t.append(String.fromCharCode(s-1)),V.ASCII_ENCODE;if(129===s)return V.PAD_ENCODE;if(s<=229){const e=s-130;e<10&&t.append("0"),t.append(""+e)}else switch(s){case 230:return V.C40_ENCODE;case 231:return V.BASE256_ENCODE;case 232:t.append(String.fromCharCode(29));break;case 233:case 234:case 241:break;case 235:r=!0;break;case 236:t.append("[)>\x1e05\x1d"),n.insert(0,"\x1e\x04");break;case 237:t.append("[)>\x1e06\x1d"),n.insert(0,"\x1e\x04");break;case 238:return V.ANSIX12_ENCODE;case 239:return V.TEXT_ENCODE;case 240:return V.EDIFACT_ENCODE;default:if(254!==s||0!==e.available())throw new S}}while(e.available()>0);return V.ASCII_ENCODE}static decodeC40Segment(e,t){let n=!1;const r=[];let s=0;do{if(8===e.available())return;const a=e.readBits(8);if(254===a)return;this.parseTwoBytes(a,e.readBits(8),r);for(let e=0;e<3;e++){const a=r[e];switch(s){case 0:if(a<3)s=a+1;else{if(!(a<this.C40_BASIC_SET_CHARS.length))throw new S;{const e=this.C40_BASIC_SET_CHARS[a];n?(t.append(String.fromCharCode(e.charCodeAt(0)+128)),n=!1):t.append(e)}}break;case 1:n?(t.append(String.fromCharCode(a+128)),n=!1):t.append(String.fromCharCode(a)),s=0;break;case 2:if(a<this.C40_SHIFT2_SET_CHARS.length){const e=this.C40_SHIFT2_SET_CHARS[a];n?(t.append(String.fromCharCode(e.charCodeAt(0)+128)),n=!1):t.append(e)}else switch(a){case 27:t.append(String.fromCharCode(29));break;case 30:n=!0;break;default:throw new S}s=0;break;case 3:n?(t.append(String.fromCharCode(a+224)),n=!1):t.append(String.fromCharCode(a+96)),s=0;break;default:throw new S}}}while(e.available()>0)}static decodeTextSegment(e,t){let n=!1,r=[],s=0;do{if(8===e.available())return;const a=e.readBits(8);if(254===a)return;this.parseTwoBytes(a,e.readBits(8),r);for(let e=0;e<3;e++){const a=r[e];switch(s){case 0:if(a<3)s=a+1;else{if(!(a<this.TEXT_BASIC_SET_CHARS.length))throw new S;{const e=this.TEXT_BASIC_SET_CHARS[a];n?(t.append(String.fromCharCode(e.charCodeAt(0)+128)),n=!1):t.append(e)}}break;case 1:n?(t.append(String.fromCharCode(a+128)),n=!1):t.append(String.fromCharCode(a)),s=0;break;case 2:if(a<this.TEXT_SHIFT2_SET_CHARS.length){const e=this.TEXT_SHIFT2_SET_CHARS[a];n?(t.append(String.fromCharCode(e.charCodeAt(0)+128)),n=!1):t.append(e)}else switch(a){case 27:t.append(String.fromCharCode(29));break;case 30:n=!0;break;default:throw new S}s=0;break;case 3:if(!(a<this.TEXT_SHIFT3_SET_CHARS.length))throw new S;{const e=this.TEXT_SHIFT3_SET_CHARS[a];n?(t.append(String.fromCharCode(e.charCodeAt(0)+128)),n=!1):t.append(e),s=0}break;default:throw new S}}}while(e.available()>0)}static decodeAnsiX12Segment(e,t){const n=[];do{if(8===e.available())return;const r=e.readBits(8);if(254===r)return;this.parseTwoBytes(r,e.readBits(8),n);for(let e=0;e<3;e++){const r=n[e];switch(r){case 0:t.append("\r");break;case 1:t.append("*");break;case 2:t.append(">");break;case 3:t.append(" ");break;default:if(r<14)t.append(String.fromCharCode(r+44));else{if(!(r<40))throw new S;t.append(String.fromCharCode(r+51))}}}}while(e.available()>0)}static parseTwoBytes(e,t,n){let r=(e<<8)+t-1,s=Math.floor(r/1600);n[0]=s,r-=1600*s,s=Math.floor(r/40),n[1]=s,n[2]=r-40*s}static decodeEdifactSegment(e,t){do{if(e.available()<=16)return;for(let n=0;n<4;n++){let n=e.readBits(6);if(31===n){const t=8-e.getBitOffset();return void(8!==t&&e.readBits(t))}0===(32&n)&&(n|=64),t.append(String.fromCharCode(n))}}while(e.available()>0)}static decodeBase256Segment(e,t,n){let r=1+e.getByteOffset();const s=this.unrandomize255State(e.readBits(8),r++);let a;if(a=0===s?e.available()/8|0:s<250?s:250*(s-249)+this.unrandomize255State(e.readBits(8),r++),a<0)throw new S;const i=new Uint8Array(a);for(let l=0;l<a;l++){if(e.available()<8)throw new S;i[l]=this.unrandomize255State(e.readBits(8),r++)}n.push(i);try{t.append(N.decode(i,k.ISO88591))}catch(o){throw new ne("Platform does not support required encoding: "+o.message)}}static unrandomize255State(e,t){const n=e-(149*t%255+1);return n>=0?n:n+256}}gt.C40_BASIC_SET_CHARS=["*","*","*"," ","0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"],gt.C40_SHIFT2_SET_CHARS=["!",'"',"#","$","%","&","'","(",")","*","+",",","-",".","/",":",";","<","=",">","?","@","[","\\","]","^","_"],gt.TEXT_BASIC_SET_CHARS=["*","*","*"," ","0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"],gt.TEXT_SHIFT2_SET_CHARS=gt.C40_SHIFT2_SET_CHARS,gt.TEXT_SHIFT3_SET_CHARS=["`","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","{","|","}","~",String.fromCharCode(127)];class yt{constructor(){this.rsDecoder=new re(ee.DATA_MATRIX_FIELD_256)}decode(e){const t=new ft(e),n=t.getVersion(),r=t.readCodewords(),s=pt.getDataBlocks(r,n);let a=0;for(let l of s)a+=l.getNumDataCodewords();const i=new Uint8Array(a),o=s.length;for(let l=0;l<o;l++){const e=s[l],t=e.getCodewords(),n=e.getNumDataCodewords();this.correctErrors(t,n);for(let r=0;r<n;r++)i[r*o+l]=t[r]}return gt.decode(i)}correctErrors(e,t){const n=new Int32Array(e);try{this.rsDecoder.decode(n,e.length-t)}catch(r){throw new f}for(let s=0;s<t;s++)e[s]=n[s]}}class wt{constructor(e){this.image=e,this.rectangleDetector=new ue(this.image)}detect(){const e=this.rectangleDetector.detect();let t=this.detectSolid1(e);if(t=this.detectSolid2(t),t[3]=this.correctTopRight(t),!t[3])throw new _;t=this.shiftToModuleCenter(t);const n=t[0],r=t[1],s=t[2],a=t[3];let i=this.transitionsBetween(n,a)+1,o=this.transitionsBetween(s,a)+1;1===(1&i)&&(i+=1),1===(1&o)&&(o+=1),4*i<7*o&&4*o<7*i&&(i=o=Math.max(i,o));let l=wt.sampleGrid(this.image,n,r,s,a,i,o);return new le(l,[n,r,s,a])}static shiftPoint(e,t,n){let r=(t.getX()-e.getX())/(n+1),s=(t.getY()-e.getY())/(n+1);return new oe(e.getX()+r,e.getY()+s)}static moveAway(e,t,n){let r=e.getX(),s=e.getY();return r<t?r-=1:r+=1,s<n?s-=1:s+=1,new oe(r,s)}detectSolid1(e){let t=e[0],n=e[1],r=e[3],s=e[2],a=this.transitionsBetween(t,n),i=this.transitionsBetween(n,r),o=this.transitionsBetween(r,s),l=this.transitionsBetween(s,t),c=a,u=[s,t,n,r];return c>i&&(c=i,u[0]=t,u[1]=n,u[2]=r,u[3]=s),c>o&&(c=o,u[0]=n,u[1]=r,u[2]=s,u[3]=t),c>l&&(u[0]=r,u[1]=s,u[2]=t,u[3]=n),u}detectSolid2(e){let t=e[0],n=e[1],r=e[2],s=e[3],a=this.transitionsBetween(t,s),i=wt.shiftPoint(n,r,4*(a+1)),o=wt.shiftPoint(r,n,4*(a+1));return this.transitionsBetween(i,t)<this.transitionsBetween(o,s)?(e[0]=t,e[1]=n,e[2]=r,e[3]=s):(e[0]=n,e[1]=r,e[2]=s,e[3]=t),e}correctTopRight(e){let t=e[0],n=e[1],r=e[2],s=e[3],a=this.transitionsBetween(t,s),i=this.transitionsBetween(n,s),o=wt.shiftPoint(t,n,4*(i+1)),l=wt.shiftPoint(r,n,4*(a+1));a=this.transitionsBetween(o,s),i=this.transitionsBetween(l,s);let c=new oe(s.getX()+(r.getX()-n.getX())/(a+1),s.getY()+(r.getY()-n.getY())/(a+1)),u=new oe(s.getX()+(t.getX()-n.getX())/(i+1),s.getY()+(t.getY()-n.getY())/(i+1));return this.isValid(c)?this.isValid(u)?this.transitionsBetween(o,c)+this.transitionsBetween(l,c)>this.transitionsBetween(o,u)+this.transitionsBetween(l,u)?c:u:c:this.isValid(u)?u:null}shiftToModuleCenter(e){let t=e[0],n=e[1],r=e[2],s=e[3],a=this.transitionsBetween(t,s)+1,i=this.transitionsBetween(r,s)+1,o=wt.shiftPoint(t,n,4*i),l=wt.shiftPoint(r,n,4*a);a=this.transitionsBetween(o,s)+1,i=this.transitionsBetween(l,s)+1,1===(1&a)&&(a+=1),1===(1&i)&&(i+=1);let c,u,d=(t.getX()+n.getX()+r.getX()+s.getX())/4,h=(t.getY()+n.getY()+r.getY()+s.getY())/4;return t=wt.moveAway(t,d,h),n=wt.moveAway(n,d,h),r=wt.moveAway(r,d,h),s=wt.moveAway(s,d,h),o=wt.shiftPoint(t,n,4*i),o=wt.shiftPoint(o,s,4*a),c=wt.shiftPoint(n,t,4*i),c=wt.shiftPoint(c,r,4*a),l=wt.shiftPoint(r,s,4*i),l=wt.shiftPoint(l,n,4*a),u=wt.shiftPoint(s,r,4*i),u=wt.shiftPoint(u,t,4*a),[o,c,l,u]}isValid(e){return e.getX()>=0&&e.getX()<this.image.getWidth()&&e.getY()>0&&e.getY()<this.image.getHeight()}static sampleGrid(e,t,n,r,s,a,i){return pe.getInstance().sampleGrid(e,a,i,.5,.5,a-.5,.5,a-.5,i-.5,.5,i-.5,t.getX(),t.getY(),s.getX(),s.getY(),r.getX(),r.getY(),n.getX(),n.getY())}transitionsBetween(e,t){let n=Math.trunc(e.getX()),r=Math.trunc(e.getY()),s=Math.trunc(t.getX()),a=Math.trunc(t.getY()),i=Math.abs(a-r)>Math.abs(s-n);if(i){let e=n;n=r,r=e,e=s,s=a,a=e}let o=Math.abs(s-n),l=Math.abs(a-r),c=-o/2,u=r<a?1:-1,d=n<s?1:-1,h=0,f=this.image.get(i?r:n,i?n:r);for(let p=n,m=r;p!==s;p+=d){let e=this.image.get(i?m:p,i?p:m);if(e!==f&&(h++,f=e),c+=l,c>0){if(m===a)break;m+=u,c-=o}}return h}}class vt{constructor(){this.decoder=new yt}decode(e){let t,n,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;if(null!=r&&r.has(x.PURE_BARCODE)){const r=vt.extractPureBits(e.getBlackMatrix());t=this.decoder.decode(r),n=vt.NO_POINTS}else{const r=new wt(e.getBlackMatrix()).detect();t=this.decoder.decode(r.getBits()),n=r.getPoints()}const s=t.getRawBytes(),a=new U(t.getText(),s,8*s.length,n,z.DATA_MATRIX,m.currentTimeMillis()),i=t.getByteSegments();null!=i&&a.putMetadata(Y.BYTE_SEGMENTS,i);const o=t.getECLevel();return null!=o&&a.putMetadata(Y.ERROR_CORRECTION_LEVEL,o),a}reset(){}static extractPureBits(e){const t=e.getTopLeftOnBit(),n=e.getBottomRightOnBit();if(null==t||null==n)throw new _;const r=this.moduleSize(t,e);let s=t[1];const a=n[1];let i=t[0];const o=(n[0]-i+1)/r,l=(a-s+1)/r;if(o<=0||l<=0)throw new _;const c=r/2;s+=c,i+=c;const u=new I(o,l);for(let d=0;d<l;d++){const t=s+d*r;for(let n=0;n<o;n++)e.get(i+n*r,t)&&u.set(n,d)}return u}static moduleSize(e,t){const n=t.getWidth();let r=e[0];const s=e[1];for(;r<n&&t.get(r,s);)r++;if(r===n)throw new _;const a=r-e[0];if(0===a)throw new _;return a}}vt.NO_POINTS=[];class At extends F{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:500;super(new vt,e)}}!function(e){e[e.L=0]="L",e[e.M=1]="M",e[e.Q=2]="Q",e[e.H=3]="H"}(G||(G={}));class bt{constructor(e,t,n){this.value=e,this.stringValue=t,this.bits=n,bt.FOR_BITS.set(n,this),bt.FOR_VALUE.set(e,this)}getValue(){return this.value}getBits(){return this.bits}static fromString(e){switch(e){case"L":return bt.L;case"M":return bt.M;case"Q":return bt.Q;case"H":return bt.H;default:throw new u(e+"not available")}}toString(){return this.stringValue}equals(e){if(!(e instanceof bt))return!1;const t=e;return this.value===t.value}static forBits(e){if(e<0||e>=bt.FOR_BITS.size)throw new d;return bt.FOR_BITS.get(e)}}bt.FOR_BITS=new Map,bt.FOR_VALUE=new Map,bt.L=new bt(G.L,"L",1),bt.M=new bt(G.M,"M",0),bt.Q=new bt(G.Q,"Q",3),bt.H=new bt(G.H,"H",2);class xt{constructor(e){this.errorCorrectionLevel=bt.forBits(e>>3&3),this.dataMask=7&e}static numBitsDiffering(e,t){return v.bitCount(e^t)}static decodeFormatInformation(e,t){const n=xt.doDecodeFormatInformation(e,t);return null!==n?n:xt.doDecodeFormatInformation(e^xt.FORMAT_INFO_MASK_QR,t^xt.FORMAT_INFO_MASK_QR)}static doDecodeFormatInformation(e,t){let n=Number.MAX_SAFE_INTEGER,r=0;for(const s of xt.FORMAT_INFO_DECODE_LOOKUP){const a=s[0];if(a===e||a===t)return new xt(s[1]);let i=xt.numBitsDiffering(e,a);i<n&&(r=s[1],n=i),e!==t&&(i=xt.numBitsDiffering(t,a),i<n&&(r=s[1],n=i))}return n<=3?new xt(r):null}getErrorCorrectionLevel(){return this.errorCorrectionLevel}getDataMask(){return this.dataMask}hashCode(){return this.errorCorrectionLevel.getBits()<<3|this.dataMask}equals(e){if(!(e instanceof xt))return!1;const t=e;return this.errorCorrectionLevel===t.errorCorrectionLevel&&this.dataMask===t.dataMask}}xt.FORMAT_INFO_MASK_QR=21522,xt.FORMAT_INFO_DECODE_LOOKUP=[Int32Array.from([21522,0]),Int32Array.from([20773,1]),Int32Array.from([24188,2]),Int32Array.from([23371,3]),Int32Array.from([17913,4]),Int32Array.from([16590,5]),Int32Array.from([20375,6]),Int32Array.from([19104,7]),Int32Array.from([30660,8]),Int32Array.from([29427,9]),Int32Array.from([32170,10]),Int32Array.from([30877,11]),Int32Array.from([26159,12]),Int32Array.from([25368,13]),Int32Array.from([27713,14]),Int32Array.from([26998,15]),Int32Array.from([5769,16]),Int32Array.from([5054,17]),Int32Array.from([7399,18]),Int32Array.from([6608,19]),Int32Array.from([1890,20]),Int32Array.from([597,21]),Int32Array.from([3340,22]),Int32Array.from([2107,23]),Int32Array.from([13663,24]),Int32Array.from([12392,25]),Int32Array.from([16177,26]),Int32Array.from([14854,27]),Int32Array.from([9396,28]),Int32Array.from([8579,29]),Int32Array.from([11994,30]),Int32Array.from([11245,31])];class St{constructor(e){this.ecCodewordsPerBlock=e;for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];this.ecBlocks=n}getECCodewordsPerBlock(){return this.ecCodewordsPerBlock}getNumBlocks(){let e=0;const t=this.ecBlocks;for(const n of t)e+=n.getCount();return e}getTotalECCodewords(){return this.ecCodewordsPerBlock*this.getNumBlocks()}getECBlocks(){return this.ecBlocks}}class Ct{constructor(e,t){this.count=e,this.dataCodewords=t}getCount(){return this.count}getDataCodewords(){return this.dataCodewords}}class Et{constructor(e,t){this.versionNumber=e,this.alignmentPatternCenters=t;for(var n=arguments.length,r=new Array(n>2?n-2:0),s=2;s<n;s++)r[s-2]=arguments[s];this.ecBlocks=r;let a=0;const i=r[0].getECCodewordsPerBlock(),o=r[0].getECBlocks();for(const l of o)a+=l.getCount()*(l.getDataCodewords()+i);this.totalCodewords=a}getVersionNumber(){return this.versionNumber}getAlignmentPatternCenters(){return this.alignmentPatternCenters}getTotalCodewords(){return this.totalCodewords}getDimensionForVersion(){return 17+4*this.versionNumber}getECBlocksForLevel(e){return this.ecBlocks[e.getValue()]}static getProvisionalVersionForDimension(e){if(e%4!==1)throw new S;try{return this.getVersionForNumber((e-17)/4)}catch(t){throw new S}}static getVersionForNumber(e){if(e<1||e>40)throw new d;return Et.VERSIONS[e-1]}static decodeVersionInformation(e){let t=Number.MAX_SAFE_INTEGER,n=0;for(let r=0;r<Et.VERSION_DECODE_INFO.length;r++){const s=Et.VERSION_DECODE_INFO[r];if(s===e)return Et.getVersionForNumber(r+7);const a=xt.numBitsDiffering(e,s);a<t&&(n=r+7,t=a)}return t<=3?Et.getVersionForNumber(n):null}buildFunctionPattern(){const e=this.getDimensionForVersion(),t=new I(e);t.setRegion(0,0,9,9),t.setRegion(e-8,0,8,9),t.setRegion(0,e-8,9,8);const n=this.alignmentPatternCenters.length;for(let r=0;r<n;r++){const e=this.alignmentPatternCenters[r]-2;for(let s=0;s<n;s++)0===r&&(0===s||s===n-1)||r===n-1&&0===s||t.setRegion(this.alignmentPatternCenters[s]-2,e,5,5)}return t.setRegion(6,9,1,e-17),t.setRegion(9,6,e-17,1),this.versionNumber>6&&(t.setRegion(e-11,0,3,6),t.setRegion(0,e-11,6,3)),t}toString(){return""+this.versionNumber}}Et.VERSION_DECODE_INFO=Int32Array.from([31892,34236,39577,42195,48118,51042,55367,58893,63784,68472,70749,76311,79154,84390,87683,92361,96236,102084,102881,110507,110734,117786,119615,126325,127568,133589,136944,141498,145311,150283,152622,158308,161089,167017]),Et.VERSIONS=[new Et(1,new Int32Array(0),new St(7,new Ct(1,19)),new St(10,new Ct(1,16)),new St(13,new Ct(1,13)),new St(17,new Ct(1,9))),new Et(2,Int32Array.from([6,18]),new St(10,new Ct(1,34)),new St(16,new Ct(1,28)),new St(22,new Ct(1,22)),new St(28,new Ct(1,16))),new Et(3,Int32Array.from([6,22]),new St(15,new Ct(1,55)),new St(26,new Ct(1,44)),new St(18,new Ct(2,17)),new St(22,new Ct(2,13))),new Et(4,Int32Array.from([6,26]),new St(20,new Ct(1,80)),new St(18,new Ct(2,32)),new St(26,new Ct(2,24)),new St(16,new Ct(4,9))),new Et(5,Int32Array.from([6,30]),new St(26,new Ct(1,108)),new St(24,new Ct(2,43)),new St(18,new Ct(2,15),new Ct(2,16)),new St(22,new Ct(2,11),new Ct(2,12))),new Et(6,Int32Array.from([6,34]),new St(18,new Ct(2,68)),new St(16,new Ct(4,27)),new St(24,new Ct(4,19)),new St(28,new Ct(4,15))),new Et(7,Int32Array.from([6,22,38]),new St(20,new Ct(2,78)),new St(18,new Ct(4,31)),new St(18,new Ct(2,14),new Ct(4,15)),new St(26,new Ct(4,13),new Ct(1,14))),new Et(8,Int32Array.from([6,24,42]),new St(24,new Ct(2,97)),new St(22,new Ct(2,38),new Ct(2,39)),new St(22,new Ct(4,18),new Ct(2,19)),new St(26,new Ct(4,14),new Ct(2,15))),new Et(9,Int32Array.from([6,26,46]),new St(30,new Ct(2,116)),new St(22,new Ct(3,36),new Ct(2,37)),new St(20,new Ct(4,16),new Ct(4,17)),new St(24,new Ct(4,12),new Ct(4,13))),new Et(10,Int32Array.from([6,28,50]),new St(18,new Ct(2,68),new Ct(2,69)),new St(26,new Ct(4,43),new Ct(1,44)),new St(24,new Ct(6,19),new Ct(2,20)),new St(28,new Ct(6,15),new Ct(2,16))),new Et(11,Int32Array.from([6,30,54]),new St(20,new Ct(4,81)),new St(30,new Ct(1,50),new Ct(4,51)),new St(28,new Ct(4,22),new Ct(4,23)),new St(24,new Ct(3,12),new Ct(8,13))),new Et(12,Int32Array.from([6,32,58]),new St(24,new Ct(2,92),new Ct(2,93)),new St(22,new Ct(6,36),new Ct(2,37)),new St(26,new Ct(4,20),new Ct(6,21)),new St(28,new Ct(7,14),new Ct(4,15))),new Et(13,Int32Array.from([6,34,62]),new St(26,new Ct(4,107)),new St(22,new Ct(8,37),new Ct(1,38)),new St(24,new Ct(8,20),new Ct(4,21)),new St(22,new Ct(12,11),new Ct(4,12))),new Et(14,Int32Array.from([6,26,46,66]),new St(30,new Ct(3,115),new Ct(1,116)),new St(24,new Ct(4,40),new Ct(5,41)),new St(20,new Ct(11,16),new Ct(5,17)),new St(24,new Ct(11,12),new Ct(5,13))),new Et(15,Int32Array.from([6,26,48,70]),new St(22,new Ct(5,87),new Ct(1,88)),new St(24,new Ct(5,41),new Ct(5,42)),new St(30,new Ct(5,24),new Ct(7,25)),new St(24,new Ct(11,12),new Ct(7,13))),new Et(16,Int32Array.from([6,26,50,74]),new St(24,new Ct(5,98),new Ct(1,99)),new St(28,new Ct(7,45),new Ct(3,46)),new St(24,new Ct(15,19),new Ct(2,20)),new St(30,new Ct(3,15),new Ct(13,16))),new Et(17,Int32Array.from([6,30,54,78]),new St(28,new Ct(1,107),new Ct(5,108)),new St(28,new Ct(10,46),new Ct(1,47)),new St(28,new Ct(1,22),new Ct(15,23)),new St(28,new Ct(2,14),new Ct(17,15))),new Et(18,Int32Array.from([6,30,56,82]),new St(30,new Ct(5,120),new Ct(1,121)),new St(26,new Ct(9,43),new Ct(4,44)),new St(28,new Ct(17,22),new Ct(1,23)),new St(28,new Ct(2,14),new Ct(19,15))),new Et(19,Int32Array.from([6,30,58,86]),new St(28,new Ct(3,113),new Ct(4,114)),new St(26,new Ct(3,44),new Ct(11,45)),new St(26,new Ct(17,21),new Ct(4,22)),new St(26,new Ct(9,13),new Ct(16,14))),new Et(20,Int32Array.from([6,34,62,90]),new St(28,new Ct(3,107),new Ct(5,108)),new St(26,new Ct(3,41),new Ct(13,42)),new St(30,new Ct(15,24),new Ct(5,25)),new St(28,new Ct(15,15),new Ct(10,16))),new Et(21,Int32Array.from([6,28,50,72,94]),new St(28,new Ct(4,116),new Ct(4,117)),new St(26,new Ct(17,42)),new St(28,new Ct(17,22),new Ct(6,23)),new St(30,new Ct(19,16),new Ct(6,17))),new Et(22,Int32Array.from([6,26,50,74,98]),new St(28,new Ct(2,111),new Ct(7,112)),new St(28,new Ct(17,46)),new St(30,new Ct(7,24),new Ct(16,25)),new St(24,new Ct(34,13))),new Et(23,Int32Array.from([6,30,54,78,102]),new St(30,new Ct(4,121),new Ct(5,122)),new St(28,new Ct(4,47),new Ct(14,48)),new St(30,new Ct(11,24),new Ct(14,25)),new St(30,new Ct(16,15),new Ct(14,16))),new Et(24,Int32Array.from([6,28,54,80,106]),new St(30,new Ct(6,117),new Ct(4,118)),new St(28,new Ct(6,45),new Ct(14,46)),new St(30,new Ct(11,24),new Ct(16,25)),new St(30,new Ct(30,16),new Ct(2,17))),new Et(25,Int32Array.from([6,32,58,84,110]),new St(26,new Ct(8,106),new Ct(4,107)),new St(28,new Ct(8,47),new Ct(13,48)),new St(30,new Ct(7,24),new Ct(22,25)),new St(30,new Ct(22,15),new Ct(13,16))),new Et(26,Int32Array.from([6,30,58,86,114]),new St(28,new Ct(10,114),new Ct(2,115)),new St(28,new Ct(19,46),new Ct(4,47)),new St(28,new Ct(28,22),new Ct(6,23)),new St(30,new Ct(33,16),new Ct(4,17))),new Et(27,Int32Array.from([6,34,62,90,118]),new St(30,new Ct(8,122),new Ct(4,123)),new St(28,new Ct(22,45),new Ct(3,46)),new St(30,new Ct(8,23),new Ct(26,24)),new St(30,new Ct(12,15),new Ct(28,16))),new Et(28,Int32Array.from([6,26,50,74,98,122]),new St(30,new Ct(3,117),new Ct(10,118)),new St(28,new Ct(3,45),new Ct(23,46)),new St(30,new Ct(4,24),new Ct(31,25)),new St(30,new Ct(11,15),new Ct(31,16))),new Et(29,Int32Array.from([6,30,54,78,102,126]),new St(30,new Ct(7,116),new Ct(7,117)),new St(28,new Ct(21,45),new Ct(7,46)),new St(30,new Ct(1,23),new Ct(37,24)),new St(30,new Ct(19,15),new Ct(26,16))),new Et(30,Int32Array.from([6,26,52,78,104,130]),new St(30,new Ct(5,115),new Ct(10,116)),new St(28,new Ct(19,47),new Ct(10,48)),new St(30,new Ct(15,24),new Ct(25,25)),new St(30,new Ct(23,15),new Ct(25,16))),new Et(31,Int32Array.from([6,30,56,82,108,134]),new St(30,new Ct(13,115),new Ct(3,116)),new St(28,new Ct(2,46),new Ct(29,47)),new St(30,new Ct(42,24),new Ct(1,25)),new St(30,new Ct(23,15),new Ct(28,16))),new Et(32,Int32Array.from([6,34,60,86,112,138]),new St(30,new Ct(17,115)),new St(28,new Ct(10,46),new Ct(23,47)),new St(30,new Ct(10,24),new Ct(35,25)),new St(30,new Ct(19,15),new Ct(35,16))),new Et(33,Int32Array.from([6,30,58,86,114,142]),new St(30,new Ct(17,115),new Ct(1,116)),new St(28,new Ct(14,46),new Ct(21,47)),new St(30,new Ct(29,24),new Ct(19,25)),new St(30,new Ct(11,15),new Ct(46,16))),new Et(34,Int32Array.from([6,34,62,90,118,146]),new St(30,new Ct(13,115),new Ct(6,116)),new St(28,new Ct(14,46),new Ct(23,47)),new St(30,new Ct(44,24),new Ct(7,25)),new St(30,new Ct(59,16),new Ct(1,17))),new Et(35,Int32Array.from([6,30,54,78,102,126,150]),new St(30,new Ct(12,121),new Ct(7,122)),new St(28,new Ct(12,47),new Ct(26,48)),new St(30,new Ct(39,24),new Ct(14,25)),new St(30,new Ct(22,15),new Ct(41,16))),new Et(36,Int32Array.from([6,24,50,76,102,128,154]),new St(30,new Ct(6,121),new Ct(14,122)),new St(28,new Ct(6,47),new Ct(34,48)),new St(30,new Ct(46,24),new Ct(10,25)),new St(30,new Ct(2,15),new Ct(64,16))),new Et(37,Int32Array.from([6,28,54,80,106,132,158]),new St(30,new Ct(17,122),new Ct(4,123)),new St(28,new Ct(29,46),new Ct(14,47)),new St(30,new Ct(49,24),new Ct(10,25)),new St(30,new Ct(24,15),new Ct(46,16))),new Et(38,Int32Array.from([6,32,58,84,110,136,162]),new St(30,new Ct(4,122),new Ct(18,123)),new St(28,new Ct(13,46),new Ct(32,47)),new St(30,new Ct(48,24),new Ct(14,25)),new St(30,new Ct(42,15),new Ct(32,16))),new Et(39,Int32Array.from([6,26,54,82,110,138,166]),new St(30,new Ct(20,117),new Ct(4,118)),new St(28,new Ct(40,47),new Ct(7,48)),new St(30,new Ct(43,24),new Ct(22,25)),new St(30,new Ct(10,15),new Ct(67,16))),new Et(40,Int32Array.from([6,30,58,86,114,142,170]),new St(30,new Ct(19,118),new Ct(6,119)),new St(28,new Ct(18,47),new Ct(31,48)),new St(30,new Ct(34,24),new Ct(34,25)),new St(30,new Ct(20,15),new Ct(61,16)))],function(e){e[e.DATA_MASK_000=0]="DATA_MASK_000",e[e.DATA_MASK_001=1]="DATA_MASK_001",e[e.DATA_MASK_010=2]="DATA_MASK_010",e[e.DATA_MASK_011=3]="DATA_MASK_011",e[e.DATA_MASK_100=4]="DATA_MASK_100",e[e.DATA_MASK_101=5]="DATA_MASK_101",e[e.DATA_MASK_110=6]="DATA_MASK_110",e[e.DATA_MASK_111=7]="DATA_MASK_111"}(J||(J={}));class Nt{constructor(e,t){this.value=e,this.isMasked=t}unmaskBitMatrix(e,t){for(let n=0;n<t;n++)for(let r=0;r<t;r++)this.isMasked(n,r)&&e.flip(r,n)}}Nt.values=new Map([[J.DATA_MASK_000,new Nt(J.DATA_MASK_000,(e,t)=>0===(e+t&1))],[J.DATA_MASK_001,new Nt(J.DATA_MASK_001,(e,t)=>0===(1&e))],[J.DATA_MASK_010,new Nt(J.DATA_MASK_010,(e,t)=>t%3===0)],[J.DATA_MASK_011,new Nt(J.DATA_MASK_011,(e,t)=>(e+t)%3===0)],[J.DATA_MASK_100,new Nt(J.DATA_MASK_100,(e,t)=>0===(Math.floor(e/2)+Math.floor(t/3)&1))],[J.DATA_MASK_101,new Nt(J.DATA_MASK_101,(e,t)=>e*t%6===0)],[J.DATA_MASK_110,new Nt(J.DATA_MASK_110,(e,t)=>e*t%6<3)],[J.DATA_MASK_111,new Nt(J.DATA_MASK_111,(e,t)=>0===(e+t+e*t%3&1))]]);class kt{constructor(e){const t=e.getHeight();if(t<21||1!==(3&t))throw new S;this.bitMatrix=e}readFormatInformation(){if(null!==this.parsedFormatInfo&&void 0!==this.parsedFormatInfo)return this.parsedFormatInfo;let e=0;for(let s=0;s<6;s++)e=this.copyBit(s,8,e);e=this.copyBit(7,8,e),e=this.copyBit(8,8,e),e=this.copyBit(8,7,e);for(let s=5;s>=0;s--)e=this.copyBit(8,s,e);const t=this.bitMatrix.getHeight();let n=0;const r=t-7;for(let s=t-1;s>=r;s--)n=this.copyBit(8,s,n);for(let s=t-8;s<t;s++)n=this.copyBit(s,8,n);if(this.parsedFormatInfo=xt.decodeFormatInformation(e,n),null!==this.parsedFormatInfo)return this.parsedFormatInfo;throw new S}readVersion(){if(null!==this.parsedVersion&&void 0!==this.parsedVersion)return this.parsedVersion;const e=this.bitMatrix.getHeight(),t=Math.floor((e-17)/4);if(t<=6)return Et.getVersionForNumber(t);let n=0;const r=e-11;for(let a=5;a>=0;a--)for(let t=e-9;t>=r;t--)n=this.copyBit(t,a,n);let s=Et.decodeVersionInformation(n);if(null!==s&&s.getDimensionForVersion()===e)return this.parsedVersion=s,s;n=0;for(let a=5;a>=0;a--)for(let t=e-9;t>=r;t--)n=this.copyBit(a,t,n);if(s=Et.decodeVersionInformation(n),null!==s&&s.getDimensionForVersion()===e)return this.parsedVersion=s,s;throw new S}copyBit(e,t,n){return(this.isMirror?this.bitMatrix.get(t,e):this.bitMatrix.get(e,t))?n<<1|1:n<<1}readCodewords(){const e=this.readFormatInformation(),t=this.readVersion(),n=Nt.values.get(e.getDataMask()),r=this.bitMatrix.getHeight();n.unmaskBitMatrix(this.bitMatrix,r);const s=t.buildFunctionPattern();let a=!0;const i=new Uint8Array(t.getTotalCodewords());let o=0,l=0,c=0;for(let u=r-1;u>0;u-=2){6===u&&u--;for(let e=0;e<r;e++){const t=a?r-1-e:e;for(let e=0;e<2;e++)s.get(u-e,t)||(c++,l<<=1,this.bitMatrix.get(u-e,t)&&(l|=1),8===c&&(i[o++]=l,c=0,l=0))}a=!a}if(o!==t.getTotalCodewords())throw new S;return i}remask(){if(null===this.parsedFormatInfo)return;const e=Nt.values[this.parsedFormatInfo.getDataMask()],t=this.bitMatrix.getHeight();e.unmaskBitMatrix(this.bitMatrix,t)}setMirror(e){this.parsedVersion=null,this.parsedFormatInfo=null,this.isMirror=e}mirror(){const e=this.bitMatrix;for(let t=0,n=e.getWidth();t<n;t++)for(let r=t+1,s=e.getHeight();r<s;r++)e.get(t,r)!==e.get(r,t)&&(e.flip(r,t),e.flip(t,r))}}class Tt{constructor(e,t){this.numDataCodewords=e,this.codewords=t}static getDataBlocks(e,t,n){if(e.length!==t.getTotalCodewords())throw new d;const r=t.getECBlocksForLevel(n);let s=0;const a=r.getECBlocks();for(const d of a)s+=d.getCount();const i=new Array(s);let o=0;for(const d of a)for(let e=0;e<d.getCount();e++){const e=d.getDataCodewords(),t=r.getECCodewordsPerBlock()+e;i[o++]=new Tt(e,new Uint8Array(t))}const l=i[0].codewords.length;let c=i.length-1;for(;c>=0&&i[c].codewords.length!==l;)c--;c++;const u=l-r.getECCodewordsPerBlock();let h=0;for(let d=0;d<u;d++)for(let t=0;t<o;t++)i[t].codewords[d]=e[h++];for(let d=c;d<o;d++)i[d].codewords[u]=e[h++];const f=i[0].codewords.length;for(let d=u;d<f;d++)for(let t=0;t<o;t++){const n=t<c?d:d+1;i[t].codewords[n]=e[h++]}return i}getNumDataCodewords(){return this.numDataCodewords}getCodewords(){return this.codewords}}!function(e){e[e.TERMINATOR=0]="TERMINATOR",e[e.NUMERIC=1]="NUMERIC",e[e.ALPHANUMERIC=2]="ALPHANUMERIC",e[e.STRUCTURED_APPEND=3]="STRUCTURED_APPEND",e[e.BYTE=4]="BYTE",e[e.ECI=5]="ECI",e[e.KANJI=6]="KANJI",e[e.FNC1_FIRST_POSITION=7]="FNC1_FIRST_POSITION",e[e.FNC1_SECOND_POSITION=8]="FNC1_SECOND_POSITION",e[e.HANZI=9]="HANZI"}(Q||(Q={}));class It{constructor(e,t,n,r){this.value=e,this.stringValue=t,this.characterCountBitsForVersions=n,this.bits=r,It.FOR_BITS.set(r,this),It.FOR_VALUE.set(e,this)}static forBits(e){const t=It.FOR_BITS.get(e);if(void 0===t)throw new d;return t}getCharacterCountBits(e){const t=e.getVersionNumber();let n;return n=t<=9?0:t<=26?1:2,this.characterCountBitsForVersions[n]}getValue(){return this.value}getBits(){return this.bits}equals(e){if(!(e instanceof It))return!1;const t=e;return this.value===t.value}toString(){return this.stringValue}}It.FOR_BITS=new Map,It.FOR_VALUE=new Map,It.TERMINATOR=new It(Q.TERMINATOR,"TERMINATOR",Int32Array.from([0,0,0]),0),It.NUMERIC=new It(Q.NUMERIC,"NUMERIC",Int32Array.from([10,12,14]),1),It.ALPHANUMERIC=new It(Q.ALPHANUMERIC,"ALPHANUMERIC",Int32Array.from([9,11,13]),2),It.STRUCTURED_APPEND=new It(Q.STRUCTURED_APPEND,"STRUCTURED_APPEND",Int32Array.from([0,0,0]),3),It.BYTE=new It(Q.BYTE,"BYTE",Int32Array.from([8,16,16]),4),It.ECI=new It(Q.ECI,"ECI",Int32Array.from([0,0,0]),7),It.KANJI=new It(Q.KANJI,"KANJI",Int32Array.from([8,10,12]),8),It.FNC1_FIRST_POSITION=new It(Q.FNC1_FIRST_POSITION,"FNC1_FIRST_POSITION",Int32Array.from([0,0,0]),5),It.FNC1_SECOND_POSITION=new It(Q.FNC1_SECOND_POSITION,"FNC1_SECOND_POSITION",Int32Array.from([0,0,0]),9),It.HANZI=new It(Q.HANZI,"HANZI",Int32Array.from([8,10,12]),13);class _t{static decode(e,t,n,r){const s=new mt(e);let a=new T;const i=new Array;let o=-1,l=-1;try{let e,n=null,c=!1;do{if(s.available()<4)e=It.TERMINATOR;else{const t=s.readBits(4);e=It.forBits(t)}switch(e){case It.TERMINATOR:break;case It.FNC1_FIRST_POSITION:case It.FNC1_SECOND_POSITION:c=!0;break;case It.STRUCTURED_APPEND:if(s.available()<16)throw new S;o=s.readBits(8),l=s.readBits(8);break;case It.ECI:const u=_t.parseECIValue(s);if(n=C.getCharacterSetECIByValue(u),null===n)throw new S;break;case It.HANZI:const d=s.readBits(4),h=s.readBits(e.getCharacterCountBits(t));d===_t.GB2312_SUBSET&&_t.decodeHanziSegment(s,a,h);break;default:const f=s.readBits(e.getCharacterCountBits(t));switch(e){case It.NUMERIC:_t.decodeNumericSegment(s,a,f);break;case It.ALPHANUMERIC:_t.decodeAlphanumericSegment(s,a,f,c);break;case It.BYTE:_t.decodeByteSegment(s,a,f,n,i,r);break;case It.KANJI:_t.decodeKanjiSegment(s,a,f);break;default:throw new S}}}while(e!==It.TERMINATOR)}catch(c){throw new S}return new q(e,a.toString(),0===i.length?null:i,null===n?null:n.toString(),o,l)}static decodeHanziSegment(e,t,n){if(13*n>e.available())throw new S;const r=new Uint8Array(2*n);let s=0;for(;n>0;){const t=e.readBits(13);let a=t/96<<8&4294967295|t%96;a+=a<959?41377:42657,r[s]=a>>8&255,r[s+1]=255&a,s+=2,n--}try{t.append(N.decode(r,k.GB2312))}catch(a){throw new S(a)}}static decodeKanjiSegment(e,t,n){if(13*n>e.available())throw new S;const r=new Uint8Array(2*n);let s=0;for(;n>0;){const t=e.readBits(13);let a=t/192<<8&4294967295|t%192;a+=a<7936?33088:49472,r[s]=a>>8,r[s+1]=a,s+=2,n--}try{t.append(N.decode(r,k.SHIFT_JIS))}catch(a){throw new S(a)}}static decodeByteSegment(e,t,n,r,s,a){if(8*n>e.available())throw new S;const i=new Uint8Array(n);for(let c=0;c<n;c++)i[c]=e.readBits(8);let o;o=null===r?k.guessEncoding(i,a):r.getName();try{t.append(N.decode(i,o))}catch(l){throw new S(l)}s.push(i)}static toAlphaNumericChar(e){if(e>=_t.ALPHANUMERIC_CHARS.length)throw new S;return _t.ALPHANUMERIC_CHARS[e]}static decodeAlphanumericSegment(e,t,n,r){const s=t.length();for(;n>1;){if(e.available()<11)throw new S;const r=e.readBits(11);t.append(_t.toAlphaNumericChar(Math.floor(r/45))),t.append(_t.toAlphaNumericChar(r%45)),n-=2}if(1===n){if(e.available()<6)throw new S;t.append(_t.toAlphaNumericChar(e.readBits(6)))}if(r)for(let a=s;a<t.length();a++)"%"===t.charAt(a)&&(a<t.length()-1&&"%"===t.charAt(a+1)?t.deleteCharAt(a+1):t.setCharAt(a,String.fromCharCode(29)))}static decodeNumericSegment(e,t,n){for(;n>=3;){if(e.available()<10)throw new S;const r=e.readBits(10);if(r>=1e3)throw new S;t.append(_t.toAlphaNumericChar(Math.floor(r/100))),t.append(_t.toAlphaNumericChar(Math.floor(r/10)%10)),t.append(_t.toAlphaNumericChar(r%10)),n-=3}if(2===n){if(e.available()<7)throw new S;const n=e.readBits(7);if(n>=100)throw new S;t.append(_t.toAlphaNumericChar(Math.floor(n/10))),t.append(_t.toAlphaNumericChar(n%10))}else if(1===n){if(e.available()<4)throw new S;const n=e.readBits(4);if(n>=10)throw new S;t.append(_t.toAlphaNumericChar(n))}}static parseECIValue(e){const t=e.readBits(8);if(0===(128&t))return 127&t;if(128===(192&t))return(63&t)<<8&4294967295|e.readBits(8);if(192===(224&t))return(31&t)<<16&4294967295|e.readBits(16);throw new S}}_t.ALPHANUMERIC_CHARS="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:",_t.GB2312_SUBSET=1;class Rt{constructor(e){this.mirrored=e}isMirrored(){return this.mirrored}applyMirroredCorrection(e){if(!this.mirrored||null===e||e.length<3)return;const t=e[0];e[0]=e[2],e[2]=t}}class Mt{constructor(){this.rsDecoder=new re(ee.QR_CODE_FIELD_256)}decodeBooleanArray(e,t){return this.decodeBitMatrix(I.parseFromBooleanArray(e),t)}decodeBitMatrix(e,t){const n=new kt(e);let r=null;try{return this.decodeBitMatrixParser(n,t)}catch(s){r=s}try{n.remask(),n.setMirror(!0),n.readVersion(),n.readFormatInformation(),n.mirror();const e=this.decodeBitMatrixParser(n,t);return e.setOther(new Rt(!0)),e}catch(s){if(null!==r)throw r;throw s}}decodeBitMatrixParser(e,t){const n=e.readVersion(),r=e.readFormatInformation().getErrorCorrectionLevel(),s=e.readCodewords(),a=Tt.getDataBlocks(s,n,r);let i=0;for(const c of a)i+=c.getNumDataCodewords();const o=new Uint8Array(i);let l=0;for(const c of a){const e=c.getCodewords(),t=c.getNumDataCodewords();this.correctErrors(e,t);for(let n=0;n<t;n++)o[l++]=e[n]}return _t.decode(o,n,r,t)}correctErrors(e,t){const n=new Int32Array(e);try{this.rsDecoder.decode(n,e.length-t)}catch(r){throw new f}for(let s=0;s<t;s++)e[s]=n[s]}}class Dt extends oe{constructor(e,t,n){super(e,t),this.estimatedModuleSize=n}aboutEquals(e,t,n){if(Math.abs(t-this.getY())<=e&&Math.abs(n-this.getX())<=e){const t=Math.abs(e-this.estimatedModuleSize);return t<=1||t<=this.estimatedModuleSize}return!1}combineEstimate(e,t,n){const r=(this.getX()+t)/2,s=(this.getY()+e)/2,a=(this.estimatedModuleSize+n)/2;return new Dt(r,s,a)}}class jt{constructor(e,t,n,r,s,a,i){this.image=e,this.startX=t,this.startY=n,this.width=r,this.height=s,this.moduleSize=a,this.resultPointCallback=i,this.possibleCenters=[],this.crossCheckStateCount=new Int32Array(3)}find(){const e=this.startX,t=this.height,n=e+this.width,r=this.startY+t/2,s=new Int32Array(3),a=this.image;for(let i=0;i<t;i++){const t=r+(0===(1&i)?Math.floor((i+1)/2):-Math.floor((i+1)/2));s[0]=0,s[1]=0,s[2]=0;let o=e;for(;o<n&&!a.get(o,t);)o++;let l=0;for(;o<n;){if(a.get(o,t))if(1===l)s[1]++;else if(2===l){if(this.foundPatternCross(s)){const e=this.handlePossibleCenter(s,t,o);if(null!==e)return e}s[0]=s[2],s[1]=1,s[2]=0,l=1}else s[++l]++;else 1===l&&l++,s[l]++;o++}if(this.foundPatternCross(s)){const e=this.handlePossibleCenter(s,t,n);if(null!==e)return e}}if(0!==this.possibleCenters.length)return this.possibleCenters[0];throw new _}static centerFromEnd(e,t){return t-e[2]-e[1]/2}foundPatternCross(e){const t=this.moduleSize,n=t/2;for(let r=0;r<3;r++)if(Math.abs(t-e[r])>=n)return!1;return!0}crossCheckVertical(e,t,n,r){const s=this.image,a=s.getHeight(),i=this.crossCheckStateCount;i[0]=0,i[1]=0,i[2]=0;let o=e;for(;o>=0&&s.get(t,o)&&i[1]<=n;)i[1]++,o--;if(o<0||i[1]>n)return NaN;for(;o>=0&&!s.get(t,o)&&i[0]<=n;)i[0]++,o--;if(i[0]>n)return NaN;for(o=e+1;o<a&&s.get(t,o)&&i[1]<=n;)i[1]++,o++;if(o===a||i[1]>n)return NaN;for(;o<a&&!s.get(t,o)&&i[2]<=n;)i[2]++,o++;if(i[2]>n)return NaN;const l=i[0]+i[1]+i[2];return 5*Math.abs(l-r)>=2*r?NaN:this.foundPatternCross(i)?jt.centerFromEnd(i,o):NaN}handlePossibleCenter(e,t,n){const r=e[0]+e[1]+e[2],s=jt.centerFromEnd(e,n),a=this.crossCheckVertical(t,s,2*e[1],r);if(!isNaN(a)){const t=(e[0]+e[1]+e[2])/3;for(const e of this.possibleCenters)if(e.aboutEquals(t,a,s))return e.combineEstimate(a,s,t);const n=new Dt(s,a,t);this.possibleCenters.push(n),null!==this.resultPointCallback&&void 0!==this.resultPointCallback&&this.resultPointCallback.foundPossibleResultPoint(n)}return null}}class Ot extends oe{constructor(e,t,n,r){super(e,t),this.estimatedModuleSize=n,this.count=r,void 0===r&&(this.count=1)}getEstimatedModuleSize(){return this.estimatedModuleSize}getCount(){return this.count}aboutEquals(e,t,n){if(Math.abs(t-this.getY())<=e&&Math.abs(n-this.getX())<=e){const t=Math.abs(e-this.estimatedModuleSize);return t<=1||t<=this.estimatedModuleSize}return!1}combineEstimate(e,t,n){const r=this.count+1,s=(this.count*this.getX()+t)/r,a=(this.count*this.getY()+e)/r,i=(this.count*this.estimatedModuleSize+n)/r;return new Ot(s,a,i,r)}}class Pt{constructor(e){this.bottomLeft=e[0],this.topLeft=e[1],this.topRight=e[2]}getBottomLeft(){return this.bottomLeft}getTopLeft(){return this.topLeft}getTopRight(){return this.topRight}}class Lt{constructor(e,t){this.image=e,this.resultPointCallback=t,this.possibleCenters=[],this.crossCheckStateCount=new Int32Array(5),this.resultPointCallback=t}getImage(){return this.image}getPossibleCenters(){return this.possibleCenters}find(e){const t=null!==e&&void 0!==e&&void 0!==e.get(x.TRY_HARDER),n=null!==e&&void 0!==e&&void 0!==e.get(x.PURE_BARCODE),r=this.image,s=r.getHeight(),a=r.getWidth();let i=Math.floor(3*s/(4*Lt.MAX_MODULES));(i<Lt.MIN_SKIP||t)&&(i=Lt.MIN_SKIP);let o=!1;const l=new Int32Array(5);for(let u=i-1;u<s&&!o;u+=i){l[0]=0,l[1]=0,l[2]=0,l[3]=0,l[4]=0;let e=0;for(let t=0;t<a;t++)if(r.get(t,u))1===(1&e)&&e++,l[e]++;else if(0===(1&e))if(4===e)if(Lt.foundPatternCross(l)){if(!0!==this.handlePossibleCenter(l,u,t,n)){l[0]=l[2],l[1]=l[3],l[2]=l[4],l[3]=1,l[4]=0,e=3;continue}if(i=2,!0===this.hasSkipped)o=this.haveMultiplyConfirmedCenters();else{const e=this.findRowSkip();e>l[2]&&(u+=e-l[2]-i,t=a-1)}e=0,l[0]=0,l[1]=0,l[2]=0,l[3]=0,l[4]=0}else l[0]=l[2],l[1]=l[3],l[2]=l[4],l[3]=1,l[4]=0,e=3;else l[++e]++;else l[e]++;Lt.foundPatternCross(l)&&!0===this.handlePossibleCenter(l,u,a,n)&&(i=l[0],this.hasSkipped&&(o=this.haveMultiplyConfirmedCenters()))}const c=this.selectBestPatterns();return oe.orderBestPatterns(c),new Pt(c)}static centerFromEnd(e,t){return t-e[4]-e[3]-e[2]/2}static foundPatternCross(e){let t=0;for(let s=0;s<5;s++){const n=e[s];if(0===n)return!1;t+=n}if(t<7)return!1;const n=t/7,r=n/2;return Math.abs(n-e[0])<r&&Math.abs(n-e[1])<r&&Math.abs(3*n-e[2])<3*r&&Math.abs(n-e[3])<r&&Math.abs(n-e[4])<r}getCrossCheckStateCount(){const e=this.crossCheckStateCount;return e[0]=0,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e}crossCheckDiagonal(e,t,n,r){const s=this.getCrossCheckStateCount();let a=0;const i=this.image;for(;e>=a&&t>=a&&i.get(t-a,e-a);)s[2]++,a++;if(e<a||t<a)return!1;for(;e>=a&&t>=a&&!i.get(t-a,e-a)&&s[1]<=n;)s[1]++,a++;if(e<a||t<a||s[1]>n)return!1;for(;e>=a&&t>=a&&i.get(t-a,e-a)&&s[0]<=n;)s[0]++,a++;if(s[0]>n)return!1;const o=i.getHeight(),l=i.getWidth();for(a=1;e+a<o&&t+a<l&&i.get(t+a,e+a);)s[2]++,a++;if(e+a>=o||t+a>=l)return!1;for(;e+a<o&&t+a<l&&!i.get(t+a,e+a)&&s[3]<n;)s[3]++,a++;if(e+a>=o||t+a>=l||s[3]>=n)return!1;for(;e+a<o&&t+a<l&&i.get(t+a,e+a)&&s[4]<n;)s[4]++,a++;if(s[4]>=n)return!1;const c=s[0]+s[1]+s[2]+s[3]+s[4];return Math.abs(c-r)<2*r&&Lt.foundPatternCross(s)}crossCheckVertical(e,t,n,r){const s=this.image,a=s.getHeight(),i=this.getCrossCheckStateCount();let o=e;for(;o>=0&&s.get(t,o);)i[2]++,o--;if(o<0)return NaN;for(;o>=0&&!s.get(t,o)&&i[1]<=n;)i[1]++,o--;if(o<0||i[1]>n)return NaN;for(;o>=0&&s.get(t,o)&&i[0]<=n;)i[0]++,o--;if(i[0]>n)return NaN;for(o=e+1;o<a&&s.get(t,o);)i[2]++,o++;if(o===a)return NaN;for(;o<a&&!s.get(t,o)&&i[3]<n;)i[3]++,o++;if(o===a||i[3]>=n)return NaN;for(;o<a&&s.get(t,o)&&i[4]<n;)i[4]++,o++;if(i[4]>=n)return NaN;const l=i[0]+i[1]+i[2]+i[3]+i[4];return 5*Math.abs(l-r)>=2*r?NaN:Lt.foundPatternCross(i)?Lt.centerFromEnd(i,o):NaN}crossCheckHorizontal(e,t,n,r){const s=this.image,a=s.getWidth(),i=this.getCrossCheckStateCount();let o=e;for(;o>=0&&s.get(o,t);)i[2]++,o--;if(o<0)return NaN;for(;o>=0&&!s.get(o,t)&&i[1]<=n;)i[1]++,o--;if(o<0||i[1]>n)return NaN;for(;o>=0&&s.get(o,t)&&i[0]<=n;)i[0]++,o--;if(i[0]>n)return NaN;for(o=e+1;o<a&&s.get(o,t);)i[2]++,o++;if(o===a)return NaN;for(;o<a&&!s.get(o,t)&&i[3]<n;)i[3]++,o++;if(o===a||i[3]>=n)return NaN;for(;o<a&&s.get(o,t)&&i[4]<n;)i[4]++,o++;if(i[4]>=n)return NaN;const l=i[0]+i[1]+i[2]+i[3]+i[4];return 5*Math.abs(l-r)>=r?NaN:Lt.foundPatternCross(i)?Lt.centerFromEnd(i,o):NaN}handlePossibleCenter(e,t,n,r){const s=e[0]+e[1]+e[2]+e[3]+e[4];let a=Lt.centerFromEnd(e,n),i=this.crossCheckVertical(t,Math.floor(a),e[2],s);if(!isNaN(i)&&(a=this.crossCheckHorizontal(Math.floor(a),Math.floor(i),e[2],s),!isNaN(a)&&(!r||this.crossCheckDiagonal(Math.floor(i),Math.floor(a),e[2],s)))){const e=s/7;let t=!1;const n=this.possibleCenters;for(let r=0,s=n.length;r<s;r++){const s=n[r];if(s.aboutEquals(e,i,a)){n[r]=s.combineEstimate(i,a,e),t=!0;break}}if(!t){const t=new Ot(a,i,e);n.push(t),null!==this.resultPointCallback&&void 0!==this.resultPointCallback&&this.resultPointCallback.foundPossibleResultPoint(t)}return!0}return!1}findRowSkip(){if(this.possibleCenters.length<=1)return 0;let e=null;for(const t of this.possibleCenters)if(t.getCount()>=Lt.CENTER_QUORUM){if(null!=e)return this.hasSkipped=!0,Math.floor((Math.abs(e.getX()-t.getX())-Math.abs(e.getY()-t.getY()))/2);e=t}return 0}haveMultiplyConfirmedCenters(){let e=0,t=0;const n=this.possibleCenters.length;for(const a of this.possibleCenters)a.getCount()>=Lt.CENTER_QUORUM&&(e++,t+=a.getEstimatedModuleSize());if(e<3)return!1;const r=t/n;let s=0;for(const a of this.possibleCenters)s+=Math.abs(a.getEstimatedModuleSize()-r);return s<=.05*t}selectBestPatterns(){const e=this.possibleCenters.length;if(e<3)throw new _;const t=this.possibleCenters;let n;if(e>3){let r=0,s=0;for(const e of this.possibleCenters){const t=e.getEstimatedModuleSize();r+=t,s+=t*t}n=r/e;let a=Math.sqrt(s/e-n*n);t.sort((e,t)=>{const r=Math.abs(t.getEstimatedModuleSize()-n),s=Math.abs(e.getEstimatedModuleSize()-n);return r<s?-1:r>s?1:0});const i=Math.max(.2*n,a);for(let e=0;e<t.length&&t.length>3;e++){const r=t[e];Math.abs(r.getEstimatedModuleSize()-n)>i&&(t.splice(e,1),e--)}}if(t.length>3){let e=0;for(const n of t)e+=n.getEstimatedModuleSize();n=e/t.length,t.sort((e,t)=>{if(t.getCount()===e.getCount()){const r=Math.abs(t.getEstimatedModuleSize()-n),s=Math.abs(e.getEstimatedModuleSize()-n);return r<s?1:r>s?-1:0}return t.getCount()-e.getCount()}),t.splice(3)}return[t[0],t[1],t[2]]}}Lt.CENTER_QUORUM=2,Lt.MIN_SKIP=3,Lt.MAX_MODULES=57;class Bt{constructor(e){this.image=e}getImage(){return this.image}getResultPointCallback(){return this.resultPointCallback}detect(e){this.resultPointCallback=null===e||void 0===e?null:e.get(x.NEED_RESULT_POINT_CALLBACK);const t=new Lt(this.image,this.resultPointCallback).find(e);return this.processFinderPatternInfo(t)}processFinderPatternInfo(e){const t=e.getTopLeft(),n=e.getTopRight(),r=e.getBottomLeft(),s=this.calculateModuleSize(t,n,r);if(s<1)throw new _("No pattern found in proccess finder.");const a=Bt.computeDimension(t,n,r,s),i=Et.getProvisionalVersionForDimension(a),o=i.getDimensionForVersion()-7;let l=null;if(i.getAlignmentPatternCenters().length>0){const e=n.getX()-t.getX()+r.getX(),a=n.getY()-t.getY()+r.getY(),i=1-3/o,c=Math.floor(t.getX()+i*(e-t.getX())),u=Math.floor(t.getY()+i*(a-t.getY()));for(let t=4;t<=16;t<<=1)try{l=this.findAlignmentInRegion(s,c,u,t);break}catch(h){if(!(h instanceof _))throw h}}const c=Bt.createTransform(t,n,r,l,a),u=Bt.sampleGrid(this.image,c,a);let d;return d=null===l?[r,t,n]:[r,t,n,l],new le(u,d)}static createTransform(e,t,n,r,s){const a=s-3.5;let i,o,l,c;return null!==r?(i=r.getX(),o=r.getY(),l=a-3,c=l):(i=t.getX()-e.getX()+n.getX(),o=t.getY()-e.getY()+n.getY(),l=a,c=a),he.quadrilateralToQuadrilateral(3.5,3.5,a,3.5,l,c,3.5,a,e.getX(),e.getY(),t.getX(),t.getY(),i,o,n.getX(),n.getY())}static sampleGrid(e,t,n){return pe.getInstance().sampleGridWithTransform(e,n,n,t)}static computeDimension(e,t,n,r){const s=ae.round(oe.distance(e,t)/r),a=ae.round(oe.distance(e,n)/r);let i=Math.floor((s+a)/2)+7;switch(3&i){case 0:i++;break;case 2:i--;break;case 3:throw new _("Dimensions could be not found.")}return i}calculateModuleSize(e,t,n){return(this.calculateModuleSizeOneWay(e,t)+this.calculateModuleSizeOneWay(e,n))/2}calculateModuleSizeOneWay(e,t){const n=this.sizeOfBlackWhiteBlackRunBothWays(Math.floor(e.getX()),Math.floor(e.getY()),Math.floor(t.getX()),Math.floor(t.getY())),r=this.sizeOfBlackWhiteBlackRunBothWays(Math.floor(t.getX()),Math.floor(t.getY()),Math.floor(e.getX()),Math.floor(e.getY()));return isNaN(n)?r/7:isNaN(r)?n/7:(n+r)/14}sizeOfBlackWhiteBlackRunBothWays(e,t,n,r){let s=this.sizeOfBlackWhiteBlackRun(e,t,n,r),a=1,i=e-(n-e);i<0?(a=e/(e-i),i=0):i>=this.image.getWidth()&&(a=(this.image.getWidth()-1-e)/(i-e),i=this.image.getWidth()-1);let o=Math.floor(t-(r-t)*a);return a=1,o<0?(a=t/(t-o),o=0):o>=this.image.getHeight()&&(a=(this.image.getHeight()-1-t)/(o-t),o=this.image.getHeight()-1),i=Math.floor(e+(i-e)*a),s+=this.sizeOfBlackWhiteBlackRun(e,t,i,o),s-1}sizeOfBlackWhiteBlackRun(e,t,n,r){const s=Math.abs(r-t)>Math.abs(n-e);if(s){let s=e;e=t,t=s,s=n,n=r,r=s}const a=Math.abs(n-e),i=Math.abs(r-t);let o=-a/2;const l=e<n?1:-1,c=t<r?1:-1;let u=0;const d=n+l;for(let h=e,f=t;h!==d;h+=l){const n=s?f:h,l=s?h:f;if(1===u===this.image.get(n,l)){if(2===u)return ae.distance(h,f,e,t);u++}if(o+=i,o>0){if(f===r)break;f+=c,o-=a}}return 2===u?ae.distance(n+l,r,e,t):NaN}findAlignmentInRegion(e,t,n,r){const s=Math.floor(r*e),a=Math.max(0,t-s),i=Math.min(this.image.getWidth()-1,t+s);if(i-a<3*e)throw new _("Alignment top exceeds estimated module size.");const o=Math.max(0,n-s),l=Math.min(this.image.getHeight()-1,n+s);if(l-o<3*e)throw new _("Alignment bottom exceeds estimated module size.");return new jt(this.image,a,o,i-a,l-o,e,this.resultPointCallback).find()}}class Ft{constructor(){this.decoder=new Mt}getDecoder(){return this.decoder}decode(e,t){let n,r;if(void 0!==t&&null!==t&&void 0!==t.get(x.PURE_BARCODE)){const s=Ft.extractPureBits(e.getBlackMatrix());n=this.decoder.decodeBitMatrix(s,t),r=Ft.NO_POINTS}else{const s=new Bt(e.getBlackMatrix()).detect(t);n=this.decoder.decodeBitMatrix(s.getBits(),t),r=s.getPoints()}n.getOther()instanceof Rt&&n.getOther().applyMirroredCorrection(r);const s=new U(n.getText(),n.getRawBytes(),void 0,r,z.QR_CODE,void 0),a=n.getByteSegments();null!==a&&s.putMetadata(Y.BYTE_SEGMENTS,a);const i=n.getECLevel();return null!==i&&s.putMetadata(Y.ERROR_CORRECTION_LEVEL,i),n.hasStructuredAppend()&&(s.putMetadata(Y.STRUCTURED_APPEND_SEQUENCE,n.getStructuredAppendSequenceNumber()),s.putMetadata(Y.STRUCTURED_APPEND_PARITY,n.getStructuredAppendParity())),s}reset(){}static extractPureBits(e){const t=e.getTopLeftOnBit(),n=e.getBottomRightOnBit();if(null===t||null===n)throw new _;const r=this.moduleSize(t,e);let s=t[1],a=n[1],i=t[0],o=n[0];if(i>=o||s>=a)throw new _;if(a-s!==o-i&&(o=i+(a-s),o>=e.getWidth()))throw new _;const l=Math.round((o-i+1)/r),c=Math.round((a-s+1)/r);if(l<=0||c<=0)throw new _;if(c!==l)throw new _;const u=Math.floor(r/2);s+=u,i+=u;const d=i+Math.floor((l-1)*r)-o;if(d>0){if(d>u)throw new _;i-=d}const h=s+Math.floor((c-1)*r)-a;if(h>0){if(h>u)throw new _;s-=h}const f=new I(l,c);for(let p=0;p<c;p++){const t=s+Math.floor(p*r);for(let n=0;n<l;n++)e.get(i+Math.floor(n*r),t)&&f.set(n,p)}return f}static moduleSize(e,t){const n=t.getHeight(),r=t.getWidth();let s=e[0],a=e[1],i=!0,o=0;for(;s<r&&a<n;){if(i!==t.get(s,a)){if(5===++o)break;i=!i}s++,a++}if(s===r||a===n)throw new _;return(s-e[0])/7}}Ft.NO_POINTS=new Array;class Ut{PDF417Common(){}static getBitCountSum(e){return ae.sum(e)}static toIntArray(e){if(null==e||!e.length)return Ut.EMPTY_INT_ARRAY;const t=new Int32Array(e.length);let n=0;for(const r of e)t[n++]=r;return t}static getCodeword(e){const t=w.binarySearch(Ut.SYMBOL_TABLE,262143&e);return t<0?-1:(Ut.CODEWORD_TABLE[t]-1)%Ut.NUMBER_OF_CODEWORDS}}Ut.NUMBER_OF_CODEWORDS=929,Ut.MAX_CODEWORDS_IN_BARCODE=Ut.NUMBER_OF_CODEWORDS-1,Ut.MIN_ROWS_IN_BARCODE=3,Ut.MAX_ROWS_IN_BARCODE=90,Ut.MODULES_IN_CODEWORD=17,Ut.MODULES_IN_STOP_PATTERN=18,Ut.BARS_IN_MODULE=8,Ut.EMPTY_INT_ARRAY=new Int32Array([]),Ut.SYMBOL_TABLE=Int32Array.from([66142,66170,66206,66236,66290,66292,66350,66382,66396,66454,66470,66476,66594,66600,66614,66626,66628,66632,66640,66654,66662,66668,66682,66690,66718,66720,66748,66758,66776,66798,66802,66804,66820,66824,66832,66846,66848,66876,66880,66936,66950,66956,66968,66992,67006,67022,67036,67042,67044,67048,67062,67118,67150,67164,67214,67228,67256,67294,67322,67350,67366,67372,67398,67404,67416,67438,67474,67476,67490,67492,67496,67510,67618,67624,67650,67656,67664,67678,67686,67692,67706,67714,67716,67728,67742,67744,67772,67782,67788,67800,67822,67826,67828,67842,67848,67870,67872,67900,67904,67960,67974,67992,68016,68030,68046,68060,68066,68068,68072,68086,68104,68112,68126,68128,68156,68160,68216,68336,68358,68364,68376,68400,68414,68448,68476,68494,68508,68536,68546,68548,68552,68560,68574,68582,68588,68654,68686,68700,68706,68708,68712,68726,68750,68764,68792,68802,68804,68808,68816,68830,68838,68844,68858,68878,68892,68920,68976,68990,68994,68996,69e3,69008,69022,69024,69052,69062,69068,69080,69102,69106,69108,69142,69158,69164,69190,69208,69230,69254,69260,69272,69296,69310,69326,69340,69386,69394,69396,69410,69416,69430,69442,69444,69448,69456,69470,69478,69484,69554,69556,69666,69672,69698,69704,69712,69726,69754,69762,69764,69776,69790,69792,69820,69830,69836,69848,69870,69874,69876,69890,69918,69920,69948,69952,70008,70022,70040,70064,70078,70094,70108,70114,70116,70120,70134,70152,70174,70176,70264,70384,70412,70448,70462,70496,70524,70542,70556,70584,70594,70600,70608,70622,70630,70636,70664,70672,70686,70688,70716,70720,70776,70896,71136,71180,71192,71216,71230,71264,71292,71360,71416,71452,71480,71536,71550,71554,71556,71560,71568,71582,71584,71612,71622,71628,71640,71662,71726,71732,71758,71772,71778,71780,71784,71798,71822,71836,71864,71874,71880,71888,71902,71910,71916,71930,71950,71964,71992,72048,72062,72066,72068,72080,72094,72096,72124,72134,72140,72152,72174,72178,72180,72206,72220,72248,72304,72318,72416,72444,72456,72464,72478,72480,72508,72512,72568,72588,72600,72624,72638,72654,72668,72674,72676,72680,72694,72726,72742,72748,72774,72780,72792,72814,72838,72856,72880,72894,72910,72924,72930,72932,72936,72950,72966,72972,72984,73008,73022,73056,73084,73102,73116,73144,73156,73160,73168,73182,73190,73196,73210,73226,73234,73236,73250,73252,73256,73270,73282,73284,73296,73310,73318,73324,73346,73348,73352,73360,73374,73376,73404,73414,73420,73432,73454,73498,73518,73522,73524,73550,73564,73570,73572,73576,73590,73800,73822,73858,73860,73872,73886,73888,73916,73944,73970,73972,73992,74014,74016,74044,74048,74104,74118,74136,74160,74174,74210,74212,74216,74230,74244,74256,74270,74272,74360,74480,74502,74508,74544,74558,74592,74620,74638,74652,74680,74690,74696,74704,74726,74732,74782,74784,74812,74992,75232,75288,75326,75360,75388,75456,75512,75576,75632,75646,75650,75652,75664,75678,75680,75708,75718,75724,75736,75758,75808,75836,75840,75896,76016,76256,76736,76824,76848,76862,76896,76924,76992,77048,77296,77340,77368,77424,77438,77536,77564,77572,77576,77584,77600,77628,77632,77688,77702,77708,77720,77744,77758,77774,77788,77870,77902,77916,77922,77928,77966,77980,78008,78018,78024,78032,78046,78060,78074,78094,78136,78192,78206,78210,78212,78224,78238,78240,78268,78278,78284,78296,78322,78324,78350,78364,78448,78462,78560,78588,78600,78622,78624,78652,78656,78712,78726,78744,78768,78782,78798,78812,78818,78820,78824,78838,78862,78876,78904,78960,78974,79072,79100,79296,79352,79368,79376,79390,79392,79420,79424,79480,79600,79628,79640,79664,79678,79712,79740,79772,79800,79810,79812,79816,79824,79838,79846,79852,79894,79910,79916,79942,79948,79960,79982,79988,80006,80024,80048,80062,80078,80092,80098,80100,80104,80134,80140,80176,80190,80224,80252,80270,80284,80312,80328,80336,80350,80358,80364,80378,80390,80396,80408,80432,80446,80480,80508,80576,80632,80654,80668,80696,80752,80766,80776,80784,80798,80800,80828,80844,80856,80878,80882,80884,80914,80916,80930,80932,80936,80950,80962,80968,80976,80990,80998,81004,81026,81028,81040,81054,81056,81084,81094,81100,81112,81134,81154,81156,81160,81168,81182,81184,81212,81216,81272,81286,81292,81304,81328,81342,81358,81372,81380,81384,81398,81434,81454,81458,81460,81486,81500,81506,81508,81512,81526,81550,81564,81592,81602,81604,81608,81616,81630,81638,81644,81702,81708,81722,81734,81740,81752,81774,81778,81780,82050,82078,82080,82108,82180,82184,82192,82206,82208,82236,82240,82296,82316,82328,82352,82366,82402,82404,82408,82440,82448,82462,82464,82492,82496,82552,82672,82694,82700,82712,82736,82750,82784,82812,82830,82882,82884,82888,82896,82918,82924,82952,82960,82974,82976,83004,83008,83064,83184,83424,83468,83480,83504,83518,83552,83580,83648,83704,83740,83768,83824,83838,83842,83844,83848,83856,83872,83900,83910,83916,83928,83950,83984,84e3,84028,84032,84088,84208,84448,84928,85040,85054,85088,85116,85184,85240,85488,85560,85616,85630,85728,85756,85764,85768,85776,85790,85792,85820,85824,85880,85894,85900,85912,85936,85966,85980,86048,86080,86136,86256,86496,86976,88160,88188,88256,88312,88560,89056,89200,89214,89312,89340,89536,89592,89608,89616,89632,89664,89720,89840,89868,89880,89904,89952,89980,89998,90012,90040,90190,90204,90254,90268,90296,90306,90308,90312,90334,90382,90396,90424,90480,90494,90500,90504,90512,90526,90528,90556,90566,90572,90584,90610,90612,90638,90652,90680,90736,90750,90848,90876,90884,90888,90896,90910,90912,90940,90944,91e3,91014,91020,91032,91056,91070,91086,91100,91106,91108,91112,91126,91150,91164,91192,91248,91262,91360,91388,91584,91640,91664,91678,91680,91708,91712,91768,91888,91928,91952,91966,92e3,92028,92046,92060,92088,92098,92100,92104,92112,92126,92134,92140,92188,92216,92272,92384,92412,92608,92664,93168,93200,93214,93216,93244,93248,93304,93424,93664,93720,93744,93758,93792,93820,93888,93944,93980,94008,94064,94078,94084,94088,94096,94110,94112,94140,94150,94156,94168,94246,94252,94278,94284,94296,94318,94342,94348,94360,94384,94398,94414,94428,94440,94470,94476,94488,94512,94526,94560,94588,94606,94620,94648,94658,94660,94664,94672,94686,94694,94700,94714,94726,94732,94744,94768,94782,94816,94844,94912,94968,94990,95004,95032,95088,95102,95112,95120,95134,95136,95164,95180,95192,95214,95218,95220,95244,95256,95280,95294,95328,95356,95424,95480,95728,95758,95772,95800,95856,95870,95968,95996,96008,96016,96030,96032,96060,96064,96120,96152,96176,96190,96220,96226,96228,96232,96290,96292,96296,96310,96322,96324,96328,96336,96350,96358,96364,96386,96388,96392,96400,96414,96416,96444,96454,96460,96472,96494,96498,96500,96514,96516,96520,96528,96542,96544,96572,96576,96632,96646,96652,96664,96688,96702,96718,96732,96738,96740,96744,96758,96772,96776,96784,96798,96800,96828,96832,96888,97008,97030,97036,97048,97072,97086,97120,97148,97166,97180,97208,97220,97224,97232,97246,97254,97260,97326,97330,97332,97358,97372,97378,97380,97384,97398,97422,97436,97464,97474,97476,97480,97488,97502,97510,97516,97550,97564,97592,97648,97666,97668,97672,97680,97694,97696,97724,97734,97740,97752,97774,97830,97836,97850,97862,97868,97880,97902,97906,97908,97926,97932,97944,97968,97998,98012,98018,98020,98024,98038,98618,98674,98676,98838,98854,98874,98892,98904,98926,98930,98932,98968,99006,99042,99044,99048,99062,99166,99194,99246,99286,99350,99366,99372,99386,99398,99416,99438,99442,99444,99462,99504,99518,99534,99548,99554,99556,99560,99574,99590,99596,99608,99632,99646,99680,99708,99726,99740,99768,99778,99780,99784,99792,99806,99814,99820,99834,99858,99860,99874,99880,99894,99906,99920,99934,99962,99970,99972,99976,99984,99998,1e5,100028,100038,100044,100056,100078,100082,100084,100142,100174,100188,100246,100262,100268,100306,100308,100390,100396,100410,100422,100428,100440,100462,100466,100468,100486,100504,100528,100542,100558,100572,100578,100580,100584,100598,100620,100656,100670,100704,100732,100750,100792,100802,100808,100816,100830,100838,100844,100858,100888,100912,100926,100960,100988,101056,101112,101148,101176,101232,101246,101250,101252,101256,101264,101278,101280,101308,101318,101324,101336,101358,101362,101364,101410,101412,101416,101430,101442,101448,101456,101470,101478,101498,101506,101508,101520,101534,101536,101564,101580,101618,101620,101636,101640,101648,101662,101664,101692,101696,101752,101766,101784,101838,101858,101860,101864,101934,101938,101940,101966,101980,101986,101988,101992,102030,102044,102072,102082,102084,102088,102096,102138,102166,102182,102188,102214,102220,102232,102254,102282,102290,102292,102306,102308,102312,102326,102444,102458,102470,102476,102488,102514,102516,102534,102552,102576,102590,102606,102620,102626,102632,102646,102662,102668,102704,102718,102752,102780,102798,102812,102840,102850,102856,102864,102878,102886,102892,102906,102936,102974,103008,103036,103104,103160,103224,103280,103294,103298,103300,103312,103326,103328,103356,103366,103372,103384,103406,103410,103412,103472,103486,103520,103548,103616,103672,103920,103992,104048,104062,104160,104188,104194,104196,104200,104208,104224,104252,104256,104312,104326,104332,104344,104368,104382,104398,104412,104418,104420,104424,104482,104484,104514,104520,104528,104542,104550,104570,104578,104580,104592,104606,104608,104636,104652,104690,104692,104706,104712,104734,104736,104764,104768,104824,104838,104856,104910,104930,104932,104936,104968,104976,104990,104992,105020,105024,105080,105200,105240,105278,105312,105372,105410,105412,105416,105424,105446,105518,105524,105550,105564,105570,105572,105576,105614,105628,105656,105666,105672,105680,105702,105722,105742,105756,105784,105840,105854,105858,105860,105864,105872,105888,105932,105970,105972,106006,106022,106028,106054,106060,106072,106100,106118,106124,106136,106160,106174,106190,106210,106212,106216,106250,106258,106260,106274,106276,106280,106306,106308,106312,106320,106334,106348,106394,106414,106418,106420,106566,106572,106610,106612,106630,106636,106648,106672,106686,106722,106724,106728,106742,106758,106764,106776,106800,106814,106848,106876,106894,106908,106936,106946,106948,106952,106960,106974,106982,106988,107032,107056,107070,107104,107132,107200,107256,107292,107320,107376,107390,107394,107396,107400,107408,107422,107424,107452,107462,107468,107480,107502,107506,107508,107544,107568,107582,107616,107644,107712,107768,108016,108060,108088,108144,108158,108256,108284,108290,108292,108296,108304,108318,108320,108348,108352,108408,108422,108428,108440,108464,108478,108494,108508,108514,108516,108520,108592,108640,108668,108736,108792,109040,109536,109680,109694,109792,109820,110016,110072,110084,110088,110096,110112,110140,110144,110200,110320,110342,110348,110360,110384,110398,110432,110460,110478,110492,110520,110532,110536,110544,110558,110658,110686,110714,110722,110724,110728,110736,110750,110752,110780,110796,110834,110836,110850,110852,110856,110864,110878,110880,110908,110912,110968,110982,111e3,111054,111074,111076,111080,111108,111112,111120,111134,111136,111164,111168,111224,111344,111372,111422,111456,111516,111554,111556,111560,111568,111590,111632,111646,111648,111676,111680,111736,111856,112096,112152,112224,112252,112320,112440,112514,112516,112520,112528,112542,112544,112588,112686,112718,112732,112782,112796,112824,112834,112836,112840,112848,112870,112890,112910,112924,112952,113008,113022,113026,113028,113032,113040,113054,113056,113100,113138,113140,113166,113180,113208,113264,113278,113376,113404,113416,113424,113440,113468,113472,113560,113614,113634,113636,113640,113686,113702,113708,113734,113740,113752,113778,113780,113798,113804,113816,113840,113854,113870,113890,113892,113896,113926,113932,113944,113968,113982,114016,114044,114076,114114,114116,114120,114128,114150,114170,114194,114196,114210,114212,114216,114242,114244,114248,114256,114270,114278,114306,114308,114312,114320,114334,114336,114364,114380,114420,114458,114478,114482,114484,114510,114524,114530,114532,114536,114842,114866,114868,114970,114994,114996,115042,115044,115048,115062,115130,115226,115250,115252,115278,115292,115298,115300,115304,115318,115342,115394,115396,115400,115408,115422,115430,115436,115450,115478,115494,115514,115526,115532,115570,115572,115738,115758,115762,115764,115790,115804,115810,115812,115816,115830,115854,115868,115896,115906,115912,115920,115934,115942,115948,115962,115996,116024,116080,116094,116098,116100,116104,116112,116126,116128,116156,116166,116172,116184,116206,116210,116212,116246,116262,116268,116282,116294,116300,116312,116334,116338,116340,116358,116364,116376,116400,116414,116430,116444,116450,116452,116456,116498,116500,116514,116520,116534,116546,116548,116552,116560,116574,116582,116588,116602,116654,116694,116714,116762,116782,116786,116788,116814,116828,116834,116836,116840,116854,116878,116892,116920,116930,116936,116944,116958,116966,116972,116986,117006,117048,117104,117118,117122,117124,117136,117150,117152,117180,117190,117196,117208,117230,117234,117236,117304,117360,117374,117472,117500,117506,117508,117512,117520,117536,117564,117568,117624,117638,117644,117656,117680,117694,117710,117724,117730,117732,117736,117750,117782,117798,117804,117818,117830,117848,117874,117876,117894,117936,117950,117966,117986,117988,117992,118022,118028,118040,118064,118078,118112,118140,118172,118210,118212,118216,118224,118238,118246,118266,118306,118312,118338,118352,118366,118374,118394,118402,118404,118408,118416,118430,118432,118460,118476,118514,118516,118574,118578,118580,118606,118620,118626,118628,118632,118678,118694,118700,118730,118738,118740,118830,118834,118836,118862,118876,118882,118884,118888,118902,118926,118940,118968,118978,118980,118984,118992,119006,119014,119020,119034,119068,119096,119152,119166,119170,119172,119176,119184,119198,119200,119228,119238,119244,119256,119278,119282,119284,119324,119352,119408,119422,119520,119548,119554,119556,119560,119568,119582,119584,119612,119616,119672,119686,119692,119704,119728,119742,119758,119772,119778,119780,119784,119798,119920,119934,120032,120060,120256,120312,120324,120328,120336,120352,120384,120440,120560,120582,120588,120600,120624,120638,120672,120700,120718,120732,120760,120770,120772,120776,120784,120798,120806,120812,120870,120876,120890,120902,120908,120920,120946,120948,120966,120972,120984,121008,121022,121038,121058,121060,121064,121078,121100,121112,121136,121150,121184,121212,121244,121282,121284,121288,121296,121318,121338,121356,121368,121392,121406,121440,121468,121536,121592,121656,121730,121732,121736,121744,121758,121760,121804,121842,121844,121890,121922,121924,121928,121936,121950,121958,121978,121986,121988,121992,122e3,122014,122016,122044,122060,122098,122100,122116,122120,122128,122142,122144,122172,122176,122232,122246,122264,122318,122338,122340,122344,122414,122418,122420,122446,122460,122466,122468,122472,122510,122524,122552,122562,122564,122568,122576,122598,122618,122646,122662,122668,122694,122700,122712,122738,122740,122762,122770,122772,122786,122788,122792,123018,123026,123028,123042,123044,123048,123062,123098,123146,123154,123156,123170,123172,123176,123190,123202,123204,123208,123216,123238,123244,123258,123290,123314,123316,123402,123410,123412,123426,123428,123432,123446,123458,123464,123472,123486,123494,123500,123514,123522,123524,123528,123536,123552,123580,123590,123596,123608,123630,123634,123636,123674,123698,123700,123740,123746,123748,123752,123834,123914,123922,123924,123938,123944,123958,123970,123976,123984,123998,124006,124012,124026,124034,124036,124048,124062,124064,124092,124102,124108,124120,124142,124146,124148,124162,124164,124168,124176,124190,124192,124220,124224,124280,124294,124300,124312,124336,124350,124366,124380,124386,124388,124392,124406,124442,124462,124466,124468,124494,124508,124514,124520,124558,124572,124600,124610,124612,124616,124624,124646,124666,124694,124710,124716,124730,124742,124748,124760,124786,124788,124818,124820,124834,124836,124840,124854,124946,124948,124962,124964,124968,124982,124994,124996,125e3,125008,125022,125030,125036,125050,125058,125060,125064,125072,125086,125088,125116,125126,125132,125144,125166,125170,125172,125186,125188,125192,125200,125216,125244,125248,125304,125318,125324,125336,125360,125374,125390,125404,125410,125412,125416,125430,125444,125448,125456,125472,125504,125560,125680,125702,125708,125720,125744,125758,125792,125820,125838,125852,125880,125890,125892,125896,125904,125918,125926,125932,125978,125998,126002,126004,126030,126044,126050,126052,126056,126094,126108,126136,126146,126148,126152,126160,126182,126202,126222,126236,126264,126320,126334,126338,126340,126344,126352,126366,126368,126412,126450,126452,126486,126502,126508,126522,126534,126540,126552,126574,126578,126580,126598,126604,126616,126640,126654,126670,126684,126690,126692,126696,126738,126754,126756,126760,126774,126786,126788,126792,126800,126814,126822,126828,126842,126894,126898,126900,126934,127126,127142,127148,127162,127178,127186,127188,127254,127270,127276,127290,127302,127308,127320,127342,127346,127348,127370,127378,127380,127394,127396,127400,127450,127510,127526,127532,127546,127558,127576,127598,127602,127604,127622,127628,127640,127664,127678,127694,127708,127714,127716,127720,127734,127754,127762,127764,127778,127784,127810,127812,127816,127824,127838,127846,127866,127898,127918,127922,127924,128022,128038,128044,128058,128070,128076,128088,128110,128114,128116,128134,128140,128152,128176,128190,128206,128220,128226,128228,128232,128246,128262,128268,128280,128304,128318,128352,128380,128398,128412,128440,128450,128452,128456,128464,128478,128486,128492,128506,128522,128530,128532,128546,128548,128552,128566,128578,128580,128584,128592,128606,128614,128634,128642,128644,128648,128656,128670,128672,128700,128716,128754,128756,128794,128814,128818,128820,128846,128860,128866,128868,128872,128886,128918,128934,128940,128954,128978,128980,129178,129198,129202,129204,129238,129258,129306,129326,129330,129332,129358,129372,129378,129380,129384,129398,129430,129446,129452,129466,129482,129490,129492,129562,129582,129586,129588,129614,129628,129634,129636,129640,129654,129678,129692,129720,129730,129732,129736,129744,129758,129766,129772,129814,129830,129836,129850,129862,129868,129880,129902,129906,129908,129930,129938,129940,129954,129956,129960,129974,130010]),Ut.CODEWORD_TABLE=Int32Array.from([2627,1819,2622,2621,1813,1812,2729,2724,2723,2779,2774,2773,902,896,908,868,865,861,859,2511,873,871,1780,835,2493,825,2491,842,837,844,1764,1762,811,810,809,2483,807,2482,806,2480,815,814,813,812,2484,817,816,1745,1744,1742,1746,2655,2637,2635,2626,2625,2623,2628,1820,2752,2739,2737,2728,2727,2725,2730,2785,2783,2778,2777,2775,2780,787,781,747,739,736,2413,754,752,1719,692,689,681,2371,678,2369,700,697,694,703,1688,1686,642,638,2343,631,2341,627,2338,651,646,643,2345,654,652,1652,1650,1647,1654,601,599,2322,596,2321,594,2319,2317,611,610,608,606,2324,603,2323,615,614,612,1617,1616,1614,1612,616,1619,1618,2575,2538,2536,905,901,898,909,2509,2507,2504,870,867,864,860,2512,875,872,1781,2490,2489,2487,2485,1748,836,834,832,830,2494,827,2492,843,841,839,845,1765,1763,2701,2676,2674,2653,2648,2656,2634,2633,2631,2629,1821,2638,2636,2770,2763,2761,2750,2745,2753,2736,2735,2733,2731,1848,2740,2738,2786,2784,591,588,576,569,566,2296,1590,537,534,526,2276,522,2274,545,542,539,548,1572,1570,481,2245,466,2242,462,2239,492,485,482,2249,496,494,1534,1531,1528,1538,413,2196,406,2191,2188,425,419,2202,415,2199,432,430,427,1472,1467,1464,433,1476,1474,368,367,2160,365,2159,362,2157,2155,2152,378,377,375,2166,372,2165,369,2162,383,381,379,2168,1419,1418,1416,1414,385,1411,384,1423,1422,1420,1424,2461,802,2441,2439,790,786,783,794,2409,2406,2403,750,742,738,2414,756,753,1720,2367,2365,2362,2359,1663,693,691,684,2373,680,2370,702,699,696,704,1690,1687,2337,2336,2334,2332,1624,2329,1622,640,637,2344,634,2342,630,2340,650,648,645,2346,655,653,1653,1651,1649,1655,2612,2597,2595,2571,2568,2565,2576,2534,2529,2526,1787,2540,2537,907,904,900,910,2503,2502,2500,2498,1768,2495,1767,2510,2508,2506,869,866,863,2513,876,874,1782,2720,2713,2711,2697,2694,2691,2702,2672,2670,2664,1828,2678,2675,2647,2646,2644,2642,1823,2639,1822,2654,2652,2650,2657,2771,1855,2765,2762,1850,1849,2751,2749,2747,2754,353,2148,344,342,336,2142,332,2140,345,1375,1373,306,2130,299,2128,295,2125,319,314,311,2132,1354,1352,1349,1356,262,257,2101,253,2096,2093,274,273,267,2107,263,2104,280,278,275,1316,1311,1308,1320,1318,2052,202,2050,2044,2040,219,2063,212,2060,208,2055,224,221,2066,1260,1258,1252,231,1248,229,1266,1264,1261,1268,155,1998,153,1996,1994,1991,1988,165,164,2007,162,2006,159,2003,2e3,172,171,169,2012,166,2010,1186,1184,1182,1179,175,1176,173,1192,1191,1189,1187,176,1194,1193,2313,2307,2305,592,589,2294,2292,2289,578,572,568,2297,580,1591,2272,2267,2264,1547,538,536,529,2278,525,2275,547,544,541,1574,1571,2237,2235,2229,1493,2225,1489,478,2247,470,2244,465,2241,493,488,484,2250,498,495,1536,1533,1530,1539,2187,2186,2184,2182,1432,2179,1430,2176,1427,414,412,2197,409,2195,405,2193,2190,426,424,421,2203,418,2201,431,429,1473,1471,1469,1466,434,1477,1475,2478,2472,2470,2459,2457,2454,2462,803,2437,2432,2429,1726,2443,2440,792,789,785,2401,2399,2393,1702,2389,1699,2411,2408,2405,745,741,2415,758,755,1721,2358,2357,2355,2353,1661,2350,1660,2347,1657,2368,2366,2364,2361,1666,690,687,2374,683,2372,701,698,705,1691,1689,2619,2617,2610,2608,2605,2613,2593,2588,2585,1803,2599,2596,2563,2561,2555,1797,2551,1795,2573,2570,2567,2577,2525,2524,2522,2520,1786,2517,1785,2514,1783,2535,2533,2531,2528,1788,2541,2539,906,903,911,2721,1844,2715,2712,1838,1836,2699,2696,2693,2703,1827,1826,1824,2673,2671,2669,2666,1829,2679,2677,1858,1857,2772,1854,1853,1851,1856,2766,2764,143,1987,139,1986,135,133,131,1984,128,1983,125,1981,138,137,136,1985,1133,1132,1130,112,110,1974,107,1973,104,1971,1969,122,121,119,117,1977,114,1976,124,1115,1114,1112,1110,1117,1116,84,83,1953,81,1952,78,1950,1948,1945,94,93,91,1959,88,1958,85,1955,99,97,95,1961,1086,1085,1083,1081,1078,100,1090,1089,1087,1091,49,47,1917,44,1915,1913,1910,1907,59,1926,56,1925,53,1922,1919,66,64,1931,61,1929,1042,1040,1038,71,1035,70,1032,68,1048,1047,1045,1043,1050,1049,12,10,1869,1867,1864,1861,21,1880,19,1877,1874,1871,28,1888,25,1886,22,1883,982,980,977,974,32,30,991,989,987,984,34,995,994,992,2151,2150,2147,2146,2144,356,355,354,2149,2139,2138,2136,2134,1359,343,341,338,2143,335,2141,348,347,346,1376,1374,2124,2123,2121,2119,1326,2116,1324,310,308,305,2131,302,2129,298,2127,320,318,316,313,2133,322,321,1355,1353,1351,1357,2092,2091,2089,2087,1276,2084,1274,2081,1271,259,2102,256,2100,252,2098,2095,272,269,2108,266,2106,281,279,277,1317,1315,1313,1310,282,1321,1319,2039,2037,2035,2032,1203,2029,1200,1197,207,2053,205,2051,201,2049,2046,2043,220,218,2064,215,2062,211,2059,228,226,223,2069,1259,1257,1254,232,1251,230,1267,1265,1263,2316,2315,2312,2311,2309,2314,2304,2303,2301,2299,1593,2308,2306,590,2288,2287,2285,2283,1578,2280,1577,2295,2293,2291,579,577,574,571,2298,582,581,1592,2263,2262,2260,2258,1545,2255,1544,2252,1541,2273,2271,2269,2266,1550,535,532,2279,528,2277,546,543,549,1575,1573,2224,2222,2220,1486,2217,1485,2214,1482,1479,2238,2236,2234,2231,1496,2228,1492,480,477,2248,473,2246,469,2243,490,487,2251,497,1537,1535,1532,2477,2476,2474,2479,2469,2468,2466,2464,1730,2473,2471,2453,2452,2450,2448,1729,2445,1728,2460,2458,2456,2463,805,804,2428,2427,2425,2423,1725,2420,1724,2417,1722,2438,2436,2434,2431,1727,2444,2442,793,791,788,795,2388,2386,2384,1697,2381,1696,2378,1694,1692,2402,2400,2398,2395,1703,2392,1701,2412,2410,2407,751,748,744,2416,759,757,1807,2620,2618,1806,1805,2611,2609,2607,2614,1802,1801,1799,2594,2592,2590,2587,1804,2600,2598,1794,1793,1791,1789,2564,2562,2560,2557,1798,2554,1796,2574,2572,2569,2578,1847,1846,2722,1843,1842,1840,1845,2716,2714,1835,1834,1832,1830,1839,1837,2700,2698,2695,2704,1817,1811,1810,897,862,1777,829,826,838,1760,1758,808,2481,1741,1740,1738,1743,2624,1818,2726,2776,782,740,737,1715,686,679,695,1682,1680,639,628,2339,647,644,1645,1643,1640,1648,602,600,597,595,2320,593,2318,609,607,604,1611,1610,1608,1606,613,1615,1613,2328,926,924,892,886,899,857,850,2505,1778,824,823,821,819,2488,818,2486,833,831,828,840,1761,1759,2649,2632,2630,2746,2734,2732,2782,2781,570,567,1587,531,527,523,540,1566,1564,476,467,463,2240,486,483,1524,1521,1518,1529,411,403,2192,399,2189,423,416,1462,1457,1454,428,1468,1465,2210,366,363,2158,360,2156,357,2153,376,373,370,2163,1410,1409,1407,1405,382,1402,380,1417,1415,1412,1421,2175,2174,777,774,771,784,732,725,722,2404,743,1716,676,674,668,2363,665,2360,685,1684,1681,626,624,622,2335,620,2333,617,2330,641,635,649,1646,1644,1642,2566,928,925,2530,2527,894,891,888,2501,2499,2496,858,856,854,851,1779,2692,2668,2665,2645,2643,2640,2651,2768,2759,2757,2744,2743,2741,2748,352,1382,340,337,333,1371,1369,307,300,296,2126,315,312,1347,1342,1350,261,258,250,2097,246,2094,271,268,264,1306,1301,1298,276,1312,1309,2115,203,2048,195,2045,191,2041,213,209,2056,1246,1244,1238,225,1234,222,1256,1253,1249,1262,2080,2079,154,1997,150,1995,147,1992,1989,163,160,2004,156,2001,1175,1174,1172,1170,1167,170,1164,167,1185,1183,1180,1177,174,1190,1188,2025,2024,2022,587,586,564,559,556,2290,573,1588,520,518,512,2268,508,2265,530,1568,1565,461,457,2233,450,2230,446,2226,479,471,489,1526,1523,1520,397,395,2185,392,2183,389,2180,2177,410,2194,402,422,1463,1461,1459,1456,1470,2455,799,2433,2430,779,776,773,2397,2394,2390,734,728,724,746,1717,2356,2354,2351,2348,1658,677,675,673,670,667,688,1685,1683,2606,2589,2586,2559,2556,2552,927,2523,2521,2518,2515,1784,2532,895,893,890,2718,2709,2707,2689,2687,2684,2663,2662,2660,2658,1825,2667,2769,1852,2760,2758,142,141,1139,1138,134,132,129,126,1982,1129,1128,1126,1131,113,111,108,105,1972,101,1970,120,118,115,1109,1108,1106,1104,123,1113,1111,82,79,1951,75,1949,72,1946,92,89,86,1956,1077,1076,1074,1072,98,1069,96,1084,1082,1079,1088,1968,1967,48,45,1916,42,1914,39,1911,1908,60,57,54,1923,50,1920,1031,1030,1028,1026,67,1023,65,1020,62,1041,1039,1036,1033,69,1046,1044,1944,1943,1941,11,9,1868,7,1865,1862,1859,20,1878,16,1875,13,1872,970,968,966,963,29,960,26,23,983,981,978,975,33,971,31,990,988,985,1906,1904,1902,993,351,2145,1383,331,330,328,326,2137,323,2135,339,1372,1370,294,293,291,289,2122,286,2120,283,2117,309,303,317,1348,1346,1344,245,244,242,2090,239,2088,236,2085,2082,260,2099,249,270,1307,1305,1303,1300,1314,189,2038,186,2036,183,2033,2030,2026,206,198,2047,194,216,1247,1245,1243,1240,227,1237,1255,2310,2302,2300,2286,2284,2281,565,563,561,558,575,1589,2261,2259,2256,2253,1542,521,519,517,514,2270,511,533,1569,1567,2223,2221,2218,2215,1483,2211,1480,459,456,453,2232,449,474,491,1527,1525,1522,2475,2467,2465,2451,2449,2446,801,800,2426,2424,2421,2418,1723,2435,780,778,775,2387,2385,2382,2379,1695,2375,1693,2396,735,733,730,727,749,1718,2616,2615,2604,2603,2601,2584,2583,2581,2579,1800,2591,2550,2549,2547,2545,1792,2542,1790,2558,929,2719,1841,2710,2708,1833,1831,2690,2688,2686,1815,1809,1808,1774,1756,1754,1737,1736,1734,1739,1816,1711,1676,1674,633,629,1638,1636,1633,1641,598,1605,1604,1602,1600,605,1609,1607,2327,887,853,1775,822,820,1757,1755,1584,524,1560,1558,468,464,1514,1511,1508,1519,408,404,400,1452,1447,1444,417,1458,1455,2208,364,361,358,2154,1401,1400,1398,1396,374,1393,371,1408,1406,1403,1413,2173,2172,772,726,723,1712,672,669,666,682,1678,1675,625,623,621,618,2331,636,632,1639,1637,1635,920,918,884,880,889,849,848,847,846,2497,855,852,1776,2641,2742,2787,1380,334,1367,1365,301,297,1340,1338,1335,1343,255,251,247,1296,1291,1288,265,1302,1299,2113,204,196,192,2042,1232,1230,1224,214,1220,210,1242,1239,1235,1250,2077,2075,151,148,1993,144,1990,1163,1162,1160,1158,1155,161,1152,157,1173,1171,1168,1165,168,1181,1178,2021,2020,2018,2023,585,560,557,1585,516,509,1562,1559,458,447,2227,472,1516,1513,1510,398,396,393,390,2181,386,2178,407,1453,1451,1449,1446,420,1460,2209,769,764,720,712,2391,729,1713,664,663,661,659,2352,656,2349,671,1679,1677,2553,922,919,2519,2516,885,883,881,2685,2661,2659,2767,2756,2755,140,1137,1136,130,127,1125,1124,1122,1127,109,106,102,1103,1102,1100,1098,116,1107,1105,1980,80,76,73,1947,1068,1067,1065,1063,90,1060,87,1075,1073,1070,1080,1966,1965,46,43,40,1912,36,1909,1019,1018,1016,1014,58,1011,55,1008,51,1029,1027,1024,1021,63,1037,1034,1940,1939,1937,1942,8,1866,4,1863,1,1860,956,954,952,949,946,17,14,969,967,964,961,27,957,24,979,976,972,1901,1900,1898,1896,986,1905,1903,350,349,1381,329,327,324,1368,1366,292,290,287,284,2118,304,1341,1339,1337,1345,243,240,237,2086,233,2083,254,1297,1295,1293,1290,1304,2114,190,187,184,2034,180,2031,177,2027,199,1233,1231,1229,1226,217,1223,1241,2078,2076,584,555,554,552,550,2282,562,1586,507,506,504,502,2257,499,2254,515,1563,1561,445,443,441,2219,438,2216,435,2212,460,454,475,1517,1515,1512,2447,798,797,2422,2419,770,768,766,2383,2380,2376,721,719,717,714,731,1714,2602,2582,2580,2548,2546,2543,923,921,2717,2706,2705,2683,2682,2680,1771,1752,1750,1733,1732,1731,1735,1814,1707,1670,1668,1631,1629,1626,1634,1599,1598,1596,1594,1603,1601,2326,1772,1753,1751,1581,1554,1552,1504,1501,1498,1509,1442,1437,1434,401,1448,1445,2206,1392,1391,1389,1387,1384,359,1399,1397,1394,1404,2171,2170,1708,1672,1669,619,1632,1630,1628,1773,1378,1363,1361,1333,1328,1336,1286,1281,1278,248,1292,1289,2111,1218,1216,1210,197,1206,193,1228,1225,1221,1236,2073,2071,1151,1150,1148,1146,152,1143,149,1140,145,1161,1159,1156,1153,158,1169,1166,2017,2016,2014,2019,1582,510,1556,1553,452,448,1506,1500,394,391,387,1443,1441,1439,1436,1450,2207,765,716,713,1709,662,660,657,1673,1671,916,914,879,878,877,882,1135,1134,1121,1120,1118,1123,1097,1096,1094,1092,103,1101,1099,1979,1059,1058,1056,1054,77,1051,74,1066,1064,1061,1071,1964,1963,1007,1006,1004,1002,999,41,996,37,1017,1015,1012,1009,52,1025,1022,1936,1935,1933,1938,942,940,938,935,932,5,2,955,953,950,947,18,943,15,965,962,958,1895,1894,1892,1890,973,1899,1897,1379,325,1364,1362,288,285,1334,1332,1330,241,238,234,1287,1285,1283,1280,1294,2112,188,185,181,178,2028,1219,1217,1215,1212,200,1209,1227,2074,2072,583,553,551,1583,505,503,500,513,1557,1555,444,442,439,436,2213,455,451,1507,1505,1502,796,763,762,760,767,711,710,708,706,2377,718,715,1710,2544,917,915,2681,1627,1597,1595,2325,1769,1749,1747,1499,1438,1435,2204,1390,1388,1385,1395,2169,2167,1704,1665,1662,1625,1623,1620,1770,1329,1282,1279,2109,1214,1207,1222,2068,2065,1149,1147,1144,1141,146,1157,1154,2013,2011,2008,2015,1579,1549,1546,1495,1487,1433,1431,1428,1425,388,1440,2205,1705,658,1667,1664,1119,1095,1093,1978,1057,1055,1052,1062,1962,1960,1005,1003,1e3,997,38,1013,1010,1932,1930,1927,1934,941,939,936,933,6,930,3,951,948,944,1889,1887,1884,1881,959,1893,1891,35,1377,1360,1358,1327,1325,1322,1331,1277,1275,1272,1269,235,1284,2110,1205,1204,1201,1198,182,1195,179,1213,2070,2067,1580,501,1551,1548,440,437,1497,1494,1490,1503,761,709,707,1706,913,912,2198,1386,2164,2161,1621,1766,2103,1208,2058,2054,1145,1142,2005,2002,1999,2009,1488,1429,1426,2200,1698,1659,1656,1975,1053,1957,1954,1001,998,1924,1921,1918,1928,937,934,931,1879,1876,1873,1870,945,1885,1882,1323,1273,1270,2105,1202,1199,1196,1211,2061,2057,1576,1543,1540,1484,1481,1478,1491,1700]);class Wt{constructor(e,t){this.bits=e,this.points=t}getBits(){return this.bits}getPoints(){return this.points}}class zt{static detectMultiple(e,t,n){let r=e.getBlackMatrix(),s=zt.detect(n,r);return s.length||(r=r.clone(),r.rotate180(),s=zt.detect(n,r)),new Wt(r,s)}static detect(e,t){const n=new Array;let r=0,s=0,a=!1;for(;r<t.getHeight();){const i=zt.findVertices(t,r,s);if(null!=i[0]||null!=i[3]){if(a=!0,n.push(i),!e)break;null!=i[2]?(s=Math.trunc(i[2].getX()),r=Math.trunc(i[2].getY())):(s=Math.trunc(i[4].getX()),r=Math.trunc(i[4].getY()))}else{if(!a)break;a=!1,s=0;for(const e of n)null!=e[1]&&(r=Math.trunc(Math.max(r,e[1].getY()))),null!=e[3]&&(r=Math.max(r,Math.trunc(e[3].getY())));r+=zt.ROW_STEP}}return n}static findVertices(e,t,n){const r=e.getHeight(),s=e.getWidth(),a=new Array(8);return zt.copyToResult(a,zt.findRowsWithPattern(e,r,s,t,n,zt.START_PATTERN),zt.INDEXES_START_PATTERN),null!=a[4]&&(n=Math.trunc(a[4].getX()),t=Math.trunc(a[4].getY())),zt.copyToResult(a,zt.findRowsWithPattern(e,r,s,t,n,zt.STOP_PATTERN),zt.INDEXES_STOP_PATTERN),a}static copyToResult(e,t,n){for(let r=0;r<n.length;r++)e[n[r]]=t[r]}static findRowsWithPattern(e,t,n,r,s,a){const i=new Array(4);let o=!1;const l=new Int32Array(a.length);for(;r<t;r+=zt.ROW_STEP){let t=zt.findGuardPattern(e,s,r,n,!1,a,l);if(null!=t){for(;r>0;){const i=zt.findGuardPattern(e,s,--r,n,!1,a,l);if(null==i){r++;break}t=i}i[0]=new oe(t[0],r),i[1]=new oe(t[1],r),o=!0;break}}let c=r+1;if(o){let r=0,s=Int32Array.from([Math.trunc(i[0].getX()),Math.trunc(i[1].getX())]);for(;c<t;c++){const t=zt.findGuardPattern(e,s[0],c,n,!1,a,l);if(null!=t&&Math.abs(s[0]-t[0])<zt.MAX_PATTERN_DRIFT&&Math.abs(s[1]-t[1])<zt.MAX_PATTERN_DRIFT)s=t,r=0;else{if(r>zt.SKIPPED_ROW_COUNT_MAX)break;r++}}c-=r+1,i[2]=new oe(s[0],c),i[3]=new oe(s[1],c)}return c-r<zt.BARCODE_MIN_HEIGHT&&w.fill(i,null),i}static findGuardPattern(e,t,n,r,s,a,i){w.fillWithin(i,0,i.length,0);let o=t,l=0;for(;e.get(o,n)&&o>0&&l++<zt.MAX_PIXEL_DRIFT;)o--;let c=o,u=0,d=a.length;for(let h=s;c<r;c++)if(e.get(c,n)!==h)i[u]++;else{if(u===d-1){if(zt.patternMatchVariance(i,a,zt.MAX_INDIVIDUAL_VARIANCE)<zt.MAX_AVG_VARIANCE)return new Int32Array([o,c]);o+=i[0]+i[1],m.arraycopy(i,2,i,0,u-1),i[u-1]=0,i[u]=0,u--}else u++;i[u]=1,h=!h}return u===d-1&&zt.patternMatchVariance(i,a,zt.MAX_INDIVIDUAL_VARIANCE)<zt.MAX_AVG_VARIANCE?new Int32Array([o,c-1]):null}static patternMatchVariance(e,t,n){let r=e.length,s=0,a=0;for(let l=0;l<r;l++)s+=e[l],a+=t[l];if(s<a)return 1/0;let i=s/a;n*=i;let o=0;for(let l=0;l<r;l++){let r=e[l],s=t[l]*i,a=r>s?r-s:s-r;if(a>n)return 1/0;o+=a}return o/s}}zt.INDEXES_START_PATTERN=Int32Array.from([0,4,1,5]),zt.INDEXES_STOP_PATTERN=Int32Array.from([6,2,7,3]),zt.MAX_AVG_VARIANCE=.42,zt.MAX_INDIVIDUAL_VARIANCE=.8,zt.START_PATTERN=Int32Array.from([8,1,1,1,1,1,1,3]),zt.STOP_PATTERN=Int32Array.from([7,1,1,3,1,1,1,2,1]),zt.MAX_PIXEL_DRIFT=3,zt.MAX_PATTERN_DRIFT=5,zt.SKIPPED_ROW_COUNT_MAX=25,zt.ROW_STEP=5,zt.BARCODE_MIN_HEIGHT=10;class Ht{constructor(e,t){if(0===t.length)throw new d;this.field=e;let n=t.length;if(n>1&&0===t[0]){let e=1;for(;e<n&&0===t[e];)e++;e===n?this.coefficients=new Int32Array([0]):(this.coefficients=new Int32Array(n-e),m.arraycopy(t,e,this.coefficients,0,this.coefficients.length))}else this.coefficients=t}getCoefficients(){return this.coefficients}getDegree(){return this.coefficients.length-1}isZero(){return 0===this.coefficients[0]}getCoefficient(e){return this.coefficients[this.coefficients.length-1-e]}evaluateAt(e){if(0===e)return this.getCoefficient(0);if(1===e){let e=0;for(let t of this.coefficients)e=this.field.add(e,t);return e}let t=this.coefficients[0],n=this.coefficients.length;for(let r=1;r<n;r++)t=this.field.add(this.field.multiply(e,t),this.coefficients[r]);return t}add(e){if(!this.field.equals(e.field))throw new d("ModulusPolys do not have same ModulusGF field");if(this.isZero())return e;if(e.isZero())return this;let t=this.coefficients,n=e.coefficients;if(t.length>n.length){let e=t;t=n,n=e}let r=new Int32Array(n.length),s=n.length-t.length;m.arraycopy(n,0,r,0,s);for(let a=s;a<n.length;a++)r[a]=this.field.add(t[a-s],n[a]);return new Ht(this.field,r)}subtract(e){if(!this.field.equals(e.field))throw new d("ModulusPolys do not have same ModulusGF field");return e.isZero()?this:this.add(e.negative())}multiply(e){return e instanceof Ht?this.multiplyOther(e):this.multiplyScalar(e)}multiplyOther(e){if(!this.field.equals(e.field))throw new d("ModulusPolys do not have same ModulusGF field");if(this.isZero()||e.isZero())return new Ht(this.field,new Int32Array([0]));let t=this.coefficients,n=t.length,r=e.coefficients,s=r.length,a=new Int32Array(n+s-1);for(let i=0;i<n;i++){let e=t[i];for(let t=0;t<s;t++)a[i+t]=this.field.add(a[i+t],this.field.multiply(e,r[t]))}return new Ht(this.field,a)}negative(){let e=this.coefficients.length,t=new Int32Array(e);for(let n=0;n<e;n++)t[n]=this.field.subtract(0,this.coefficients[n]);return new Ht(this.field,t)}multiplyScalar(e){if(0===e)return new Ht(this.field,new Int32Array([0]));if(1===e)return this;let t=this.coefficients.length,n=new Int32Array(t);for(let r=0;r<t;r++)n[r]=this.field.multiply(this.coefficients[r],e);return new Ht(this.field,n)}multiplyByMonomial(e,t){if(e<0)throw new d;if(0===t)return new Ht(this.field,new Int32Array([0]));let n=this.coefficients.length,r=new Int32Array(n+e);for(let s=0;s<n;s++)r[s]=this.field.multiply(this.coefficients[s],t);return new Ht(this.field,r)}toString(){let e=new T;for(let t=this.getDegree();t>=0;t--){let n=this.getCoefficient(t);0!==n&&(n<0?(e.append(" - "),n=-n):e.length()>0&&e.append(" + "),0!==t&&1===n||e.append(n),0!==t&&(1===t?e.append("x"):(e.append("x^"),e.append(t))))}return e.toString()}}class Vt{add(e,t){return(e+t)%this.modulus}subtract(e,t){return(this.modulus+e-t)%this.modulus}exp(e){return this.expTable[e]}log(e){if(0===e)throw new d;return this.logTable[e]}inverse(e){if(0===e)throw new $;return this.expTable[this.modulus-this.logTable[e]-1]}multiply(e,t){return 0===e||0===t?0:this.expTable[(this.logTable[e]+this.logTable[t])%(this.modulus-1)]}getSize(){return this.modulus}equals(e){return e===this}}class Gt extends Vt{constructor(e,t){super(),this.modulus=e,this.expTable=new Int32Array(e),this.logTable=new Int32Array(e);let n=1;for(let r=0;r<e;r++)this.expTable[r]=n,n=n*t%e;for(let r=0;r<e-1;r++)this.logTable[this.expTable[r]]=r;this.zero=new Ht(this,new Int32Array([0])),this.one=new Ht(this,new Int32Array([1]))}getZero(){return this.zero}getOne(){return this.one}buildMonomial(e,t){if(e<0)throw new d;if(0===t)return this.zero;let n=new Int32Array(e+1);return n[0]=t,new Ht(this,n)}}Gt.PDF417_GF=new Gt(Ut.NUMBER_OF_CODEWORDS,3);class Jt{constructor(){this.field=Gt.PDF417_GF}decode(e,t,n){let r=new Ht(this.field,e),s=new Int32Array(t),a=!1;for(let f=t;f>0;f--){let e=r.evaluateAt(this.field.exp(f));s[t-f]=e,0!==e&&(a=!0)}if(!a)return 0;let i=this.field.getOne();if(null!=n)for(const f of n){let t=this.field.exp(e.length-1-f),n=new Ht(this.field,new Int32Array([this.field.subtract(0,t),1]));i=i.multiply(n)}let o=new Ht(this.field,s),l=this.runEuclideanAlgorithm(this.field.buildMonomial(t,1),o,t),c=l[0],u=l[1],d=this.findErrorLocations(c),h=this.findErrorMagnitudes(u,c,d);for(let p=0;p<d.length;p++){let t=e.length-1-this.field.log(d[p]);if(t<0)throw f.getChecksumInstance();e[t]=this.field.subtract(e[t],h[p])}return d.length}runEuclideanAlgorithm(e,t,n){if(e.getDegree()<t.getDegree()){let n=e;e=t,t=n}let r=e,s=t,a=this.field.getZero(),i=this.field.getOne();for(;s.getDegree()>=Math.round(n/2);){let e=r,t=a;if(r=s,a=i,r.isZero())throw f.getChecksumInstance();s=e;let n=this.field.getZero(),o=r.getCoefficient(r.getDegree()),l=this.field.inverse(o);for(;s.getDegree()>=r.getDegree()&&!s.isZero();){let e=s.getDegree()-r.getDegree(),t=this.field.multiply(s.getCoefficient(s.getDegree()),l);n=n.add(this.field.buildMonomial(e,t)),s=s.subtract(r.multiplyByMonomial(e,t))}i=n.multiply(a).subtract(t).negative()}let o=i.getCoefficient(0);if(0===o)throw f.getChecksumInstance();let l=this.field.inverse(o);return[i.multiply(l),s.multiply(l)]}findErrorLocations(e){let t=e.getDegree(),n=new Int32Array(t),r=0;for(let s=1;s<this.field.getSize()&&r<t;s++)0===e.evaluateAt(s)&&(n[r]=this.field.inverse(s),r++);if(r!==t)throw f.getChecksumInstance();return n}findErrorMagnitudes(e,t,n){let r=t.getDegree(),s=new Int32Array(r);for(let l=1;l<=r;l++)s[r-l]=this.field.multiply(l,t.getCoefficient(l));let a=new Ht(this.field,s),i=n.length,o=new Int32Array(i);for(let l=0;l<i;l++){let t=this.field.inverse(n[l]),r=this.field.subtract(0,e.evaluateAt(t)),s=this.field.inverse(a.evaluateAt(t));o[l]=this.field.multiply(r,s)}return o}}class Qt{constructor(e,t,n,r,s){e instanceof Qt?this.constructor_2(e):this.constructor_1(e,t,n,r,s)}constructor_1(e,t,n,r,s){const a=null==t||null==n,i=null==r||null==s;if(a&&i)throw new _;a?(t=new oe(0,r.getY()),n=new oe(0,s.getY())):i&&(r=new oe(e.getWidth()-1,t.getY()),s=new oe(e.getWidth()-1,n.getY())),this.image=e,this.topLeft=t,this.bottomLeft=n,this.topRight=r,this.bottomRight=s,this.minX=Math.trunc(Math.min(t.getX(),n.getX())),this.maxX=Math.trunc(Math.max(r.getX(),s.getX())),this.minY=Math.trunc(Math.min(t.getY(),r.getY())),this.maxY=Math.trunc(Math.max(n.getY(),s.getY()))}constructor_2(e){this.image=e.image,this.topLeft=e.getTopLeft(),this.bottomLeft=e.getBottomLeft(),this.topRight=e.getTopRight(),this.bottomRight=e.getBottomRight(),this.minX=e.getMinX(),this.maxX=e.getMaxX(),this.minY=e.getMinY(),this.maxY=e.getMaxY()}static merge(e,t){return null==e?t:null==t?e:new Qt(e.image,e.topLeft,e.bottomLeft,t.topRight,t.bottomRight)}addMissingRows(e,t,n){let r=this.topLeft,s=this.bottomLeft,a=this.topRight,i=this.bottomRight;if(e>0){let t=n?this.topLeft:this.topRight,s=Math.trunc(t.getY()-e);s<0&&(s=0);let i=new oe(t.getX(),s);n?r=i:a=i}if(t>0){let e=n?this.bottomLeft:this.bottomRight,r=Math.trunc(e.getY()+t);r>=this.image.getHeight()&&(r=this.image.getHeight()-1);let a=new oe(e.getX(),r);n?s=a:i=a}return new Qt(this.image,r,s,a,i)}getMinX(){return this.minX}getMaxX(){return this.maxX}getMinY(){return this.minY}getMaxY(){return this.maxY}getTopLeft(){return this.topLeft}getTopRight(){return this.topRight}getBottomLeft(){return this.bottomLeft}getBottomRight(){return this.bottomRight}}class Kt{constructor(e,t,n,r){this.columnCount=e,this.errorCorrectionLevel=r,this.rowCountUpperPart=t,this.rowCountLowerPart=n,this.rowCount=t+n}getColumnCount(){return this.columnCount}getErrorCorrectionLevel(){return this.errorCorrectionLevel}getRowCount(){return this.rowCount}getRowCountUpperPart(){return this.rowCountUpperPart}getRowCountLowerPart(){return this.rowCountLowerPart}}class Yt{constructor(){this.buffer=""}static form(e,t){let n=-1;function r(e,r,s,a,i,o){if("%%"===e)return"%";if(void 0===t[++n])return;e=a?parseInt(a.substr(1)):void 0;let l,c=i?parseInt(i.substr(1)):void 0;switch(o){case"s":l=t[n];break;case"c":l=t[n][0];break;case"f":l=parseFloat(t[n]).toFixed(e);break;case"p":l=parseFloat(t[n]).toPrecision(e);break;case"e":l=parseFloat(t[n]).toExponential(e);break;case"x":l=parseInt(t[n]).toString(c||16);break;case"d":l=parseFloat(parseInt(t[n],c||10).toPrecision(e)).toFixed(0)}l="object"===typeof l?JSON.stringify(l):(+l).toString(c);let u=parseInt(s),d=s&&s[0]+""==="0"?"0":" ";for(;l.length<u;)l=void 0!==r?l+d:d+l;return l}let s=/%(-)?(0?[0-9]+)?([.][0-9]+)?([#][0-9]+)?([scfpexd%])/g;return e.replace(s,r)}format(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];this.buffer+=Yt.form(e,n)}toString(){return this.buffer}}class qt{constructor(e){this.boundingBox=new Qt(e),this.codewords=new Array(e.getMaxY()-e.getMinY()+1)}getCodewordNearby(e){let t=this.getCodeword(e);if(null!=t)return t;for(let n=1;n<qt.MAX_NEARBY_DISTANCE;n++){let r=this.imageRowToCodewordIndex(e)-n;if(r>=0&&(t=this.codewords[r],null!=t))return t;if(r=this.imageRowToCodewordIndex(e)+n,r<this.codewords.length&&(t=this.codewords[r],null!=t))return t}return null}imageRowToCodewordIndex(e){return e-this.boundingBox.getMinY()}setCodeword(e,t){this.codewords[this.imageRowToCodewordIndex(e)]=t}getCodeword(e){return this.codewords[this.imageRowToCodewordIndex(e)]}getBoundingBox(){return this.boundingBox}getCodewords(){return this.codewords}toString(){const e=new Yt;let t=0;for(const n of this.codewords)null!=n?e.format("%3d: %3d|%3d%n",t++,n.getRowNumber(),n.getValue()):e.format("%3d:    |   %n",t++);return e.toString()}}qt.MAX_NEARBY_DISTANCE=5;class Xt{constructor(){this.values=new Map}setValue(e){e=Math.trunc(e);let t=this.values.get(e);null==t&&(t=0),t++,this.values.set(e,t)}getValue(){let e=-1,t=new Array;for(const[n,r]of this.values.entries()){const s={getKey:()=>n,getValue:()=>r};s.getValue()>e?(e=s.getValue(),t=[],t.push(s.getKey())):s.getValue()===e&&t.push(s.getKey())}return Ut.toIntArray(t)}getConfidence(e){return this.values.get(e)}}class Zt extends qt{constructor(e,t){super(e),this._isLeft=t}setRowNumbers(){for(let e of this.getCodewords())null!=e&&e.setRowNumberAsRowIndicatorColumn()}adjustCompleteIndicatorColumnRowNumbers(e){let t=this.getCodewords();this.setRowNumbers(),this.removeIncorrectCodewords(t,e);let n=this.getBoundingBox(),r=this._isLeft?n.getTopLeft():n.getTopRight(),s=this._isLeft?n.getBottomLeft():n.getBottomRight(),a=this.imageRowToCodewordIndex(Math.trunc(r.getY())),i=this.imageRowToCodewordIndex(Math.trunc(s.getY())),o=-1,l=1,c=0;for(let u=a;u<i;u++){if(null==t[u])continue;let n=t[u],r=n.getRowNumber()-o;if(0===r)c++;else if(1===r)l=Math.max(l,c),c=1,o=n.getRowNumber();else if(r<0||n.getRowNumber()>=e.getRowCount()||r>u)t[u]=null;else{let e;e=l>2?(l-2)*r:r;let s=e>=u;for(let n=1;n<=e&&!s;n++)s=null!=t[u-n];s?t[u]=null:(o=n.getRowNumber(),c=1)}}}getRowHeights(){let e=this.getBarcodeMetadata();if(null==e)return null;this.adjustIncompleteIndicatorColumnRowNumbers(e);let t=new Int32Array(e.getRowCount());for(let n of this.getCodewords())if(null!=n){let e=n.getRowNumber();if(e>=t.length)continue;t[e]++}return t}adjustIncompleteIndicatorColumnRowNumbers(e){let t=this.getBoundingBox(),n=this._isLeft?t.getTopLeft():t.getTopRight(),r=this._isLeft?t.getBottomLeft():t.getBottomRight(),s=this.imageRowToCodewordIndex(Math.trunc(n.getY())),a=this.imageRowToCodewordIndex(Math.trunc(r.getY())),i=this.getCodewords(),o=-1;for(let l=s;l<a;l++){if(null==i[l])continue;let t=i[l];t.setRowNumberAsRowIndicatorColumn();let n=t.getRowNumber()-o;0===n||(1===n?o=t.getRowNumber():t.getRowNumber()>=e.getRowCount()?i[l]=null:o=t.getRowNumber())}}getBarcodeMetadata(){let e=this.getCodewords(),t=new Xt,n=new Xt,r=new Xt,s=new Xt;for(let i of e){if(null==i)continue;i.setRowNumberAsRowIndicatorColumn();let e=i.getValue()%30,a=i.getRowNumber();switch(this._isLeft||(a+=2),a%3){case 0:n.setValue(3*e+1);break;case 1:s.setValue(e/3),r.setValue(e%3);break;case 2:t.setValue(e+1)}}if(0===t.getValue().length||0===n.getValue().length||0===r.getValue().length||0===s.getValue().length||t.getValue()[0]<1||n.getValue()[0]+r.getValue()[0]<Ut.MIN_ROWS_IN_BARCODE||n.getValue()[0]+r.getValue()[0]>Ut.MAX_ROWS_IN_BARCODE)return null;let a=new Kt(t.getValue()[0],n.getValue()[0],r.getValue()[0],s.getValue()[0]);return this.removeIncorrectCodewords(e,a),a}removeIncorrectCodewords(e,t){for(let n=0;n<e.length;n++){let r=e[n];if(null==e[n])continue;let s=r.getValue()%30,a=r.getRowNumber();if(a>t.getRowCount())e[n]=null;else switch(this._isLeft||(a+=2),a%3){case 0:3*s+1!==t.getRowCountUpperPart()&&(e[n]=null);break;case 1:Math.trunc(s/3)===t.getErrorCorrectionLevel()&&s%3===t.getRowCountLowerPart()||(e[n]=null);break;case 2:s+1!==t.getColumnCount()&&(e[n]=null)}}}isLeft(){return this._isLeft}toString(){return"IsLeft: "+this._isLeft+"\n"+super.toString()}}class $t{constructor(e,t){this.ADJUST_ROW_NUMBER_SKIP=2,this.barcodeMetadata=e,this.barcodeColumnCount=e.getColumnCount(),this.boundingBox=t,this.detectionResultColumns=new Array(this.barcodeColumnCount+2)}getDetectionResultColumns(){this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[0]),this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[this.barcodeColumnCount+1]);let e,t=Ut.MAX_CODEWORDS_IN_BARCODE;do{e=t,t=this.adjustRowNumbersAndGetCount()}while(t>0&&t<e);return this.detectionResultColumns}adjustIndicatorColumnRowNumbers(e){null!=e&&e.adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata)}adjustRowNumbersAndGetCount(){let e=this.adjustRowNumbersByRow();if(0===e)return 0;for(let t=1;t<this.barcodeColumnCount+1;t++){let e=this.detectionResultColumns[t].getCodewords();for(let n=0;n<e.length;n++)null!=e[n]&&(e[n].hasValidRowNumber()||this.adjustRowNumbers(t,n,e))}return e}adjustRowNumbersByRow(){return this.adjustRowNumbersFromBothRI(),this.adjustRowNumbersFromLRI()+this.adjustRowNumbersFromRRI()}adjustRowNumbersFromBothRI(){if(null==this.detectionResultColumns[0]||null==this.detectionResultColumns[this.barcodeColumnCount+1])return;let e=this.detectionResultColumns[0].getCodewords(),t=this.detectionResultColumns[this.barcodeColumnCount+1].getCodewords();for(let n=0;n<e.length;n++)if(null!=e[n]&&null!=t[n]&&e[n].getRowNumber()===t[n].getRowNumber())for(let t=1;t<=this.barcodeColumnCount;t++){let r=this.detectionResultColumns[t].getCodewords()[n];null!=r&&(r.setRowNumber(e[n].getRowNumber()),r.hasValidRowNumber()||(this.detectionResultColumns[t].getCodewords()[n]=null))}}adjustRowNumbersFromRRI(){if(null==this.detectionResultColumns[this.barcodeColumnCount+1])return 0;let e=0,t=this.detectionResultColumns[this.barcodeColumnCount+1].getCodewords();for(let n=0;n<t.length;n++){if(null==t[n])continue;let r=t[n].getRowNumber(),s=0;for(let t=this.barcodeColumnCount+1;t>0&&s<this.ADJUST_ROW_NUMBER_SKIP;t--){let a=this.detectionResultColumns[t].getCodewords()[n];null!=a&&(s=$t.adjustRowNumberIfValid(r,s,a),a.hasValidRowNumber()||e++)}}return e}adjustRowNumbersFromLRI(){if(null==this.detectionResultColumns[0])return 0;let e=0,t=this.detectionResultColumns[0].getCodewords();for(let n=0;n<t.length;n++){if(null==t[n])continue;let r=t[n].getRowNumber(),s=0;for(let t=1;t<this.barcodeColumnCount+1&&s<this.ADJUST_ROW_NUMBER_SKIP;t++){let a=this.detectionResultColumns[t].getCodewords()[n];null!=a&&(s=$t.adjustRowNumberIfValid(r,s,a),a.hasValidRowNumber()||e++)}}return e}static adjustRowNumberIfValid(e,t,n){return null==n||n.hasValidRowNumber()||(n.isValidRowNumber(e)?(n.setRowNumber(e),t=0):++t),t}adjustRowNumbers(e,t,n){if(!this.detectionResultColumns[e-1])return;let r=n[t],s=this.detectionResultColumns[e-1].getCodewords(),a=s;null!=this.detectionResultColumns[e+1]&&(a=this.detectionResultColumns[e+1].getCodewords());let i=new Array(14);i[2]=s[t],i[3]=a[t],t>0&&(i[0]=n[t-1],i[4]=s[t-1],i[5]=a[t-1]),t>1&&(i[8]=n[t-2],i[10]=s[t-2],i[11]=a[t-2]),t<n.length-1&&(i[1]=n[t+1],i[6]=s[t+1],i[7]=a[t+1]),t<n.length-2&&(i[9]=n[t+2],i[12]=s[t+2],i[13]=a[t+2]);for(let o of i)if($t.adjustRowNumber(r,o))return}static adjustRowNumber(e,t){return null!=t&&!(!t.hasValidRowNumber()||t.getBucket()!==e.getBucket())&&(e.setRowNumber(t.getRowNumber()),!0)}getBarcodeColumnCount(){return this.barcodeColumnCount}getBarcodeRowCount(){return this.barcodeMetadata.getRowCount()}getBarcodeECLevel(){return this.barcodeMetadata.getErrorCorrectionLevel()}setBoundingBox(e){this.boundingBox=e}getBoundingBox(){return this.boundingBox}setDetectionResultColumn(e,t){this.detectionResultColumns[e]=t}getDetectionResultColumn(e){return this.detectionResultColumns[e]}toString(){let e=this.detectionResultColumns[0];null==e&&(e=this.detectionResultColumns[this.barcodeColumnCount+1]);let t=new Yt;for(let n=0;n<e.getCodewords().length;n++){t.format("CW %3d:",n);for(let e=0;e<this.barcodeColumnCount+2;e++){if(null==this.detectionResultColumns[e]){t.format("    |   ");continue}let r=this.detectionResultColumns[e].getCodewords()[n];null!=r?t.format(" %3d|%3d",r.getRowNumber(),r.getValue()):t.format("    |   ")}t.format("%n")}return t.toString()}}class en{constructor(e,t,n,r){this.rowNumber=en.BARCODE_ROW_UNKNOWN,this.startX=Math.trunc(e),this.endX=Math.trunc(t),this.bucket=Math.trunc(n),this.value=Math.trunc(r)}hasValidRowNumber(){return this.isValidRowNumber(this.rowNumber)}isValidRowNumber(e){return e!==en.BARCODE_ROW_UNKNOWN&&this.bucket===e%3*3}setRowNumberAsRowIndicatorColumn(){this.rowNumber=Math.trunc(3*Math.trunc(this.value/30)+Math.trunc(this.bucket/3))}getWidth(){return this.endX-this.startX}getStartX(){return this.startX}getEndX(){return this.endX}getBucket(){return this.bucket}getValue(){return this.value}getRowNumber(){return this.rowNumber}setRowNumber(e){this.rowNumber=e}toString(){return this.rowNumber+"|"+this.value}}en.BARCODE_ROW_UNKNOWN=-1;class tn{static initialize(){for(let e=0;e<Ut.SYMBOL_TABLE.length;e++){let t=Ut.SYMBOL_TABLE[e],n=1&t;for(let r=0;r<Ut.BARS_IN_MODULE;r++){let s=0;for(;(1&t)===n;)s+=1,t>>=1;n=1&t,tn.RATIOS_TABLE[e]||(tn.RATIOS_TABLE[e]=new Array(Ut.BARS_IN_MODULE)),tn.RATIOS_TABLE[e][Ut.BARS_IN_MODULE-r-1]=Math.fround(s/Ut.MODULES_IN_CODEWORD)}}this.bSymbolTableReady=!0}static getDecodedValue(e){let t=tn.getDecodedCodewordValue(tn.sampleBitCounts(e));return-1!==t?t:tn.getClosestDecodedValue(e)}static sampleBitCounts(e){let t=ae.sum(e),n=new Int32Array(Ut.BARS_IN_MODULE),r=0,s=0;for(let a=0;a<Ut.MODULES_IN_CODEWORD;a++){let i=t/(2*Ut.MODULES_IN_CODEWORD)+a*t/Ut.MODULES_IN_CODEWORD;s+e[r]<=i&&(s+=e[r],r++),n[r]++}return n}static getDecodedCodewordValue(e){let t=tn.getBitValue(e);return-1===Ut.getCodeword(t)?-1:t}static getBitValue(e){let t=0;for(let n=0;n<e.length;n++)for(let r=0;r<e[n];r++)t=t<<1|(n%2===0?1:0);return Math.trunc(t)}static getClosestDecodedValue(e){let t=ae.sum(e),n=new Array(Ut.BARS_IN_MODULE);if(t>1)for(let a=0;a<n.length;a++)n[a]=Math.fround(e[a]/t);let r=ie.MAX_VALUE,s=-1;this.bSymbolTableReady||tn.initialize();for(let a=0;a<tn.RATIOS_TABLE.length;a++){let e=0,t=tn.RATIOS_TABLE[a];for(let s=0;s<Ut.BARS_IN_MODULE;s++){let a=Math.fround(t[s]-n[s]);if(e+=Math.fround(a*a),e>=r)break}e<r&&(r=e,s=Ut.SYMBOL_TABLE[a])}return s}}tn.bSymbolTableReady=!1,tn.RATIOS_TABLE=new Array(Ut.SYMBOL_TABLE.length).map(e=>new Array(Ut.BARS_IN_MODULE));class nn{constructor(){this.segmentCount=-1,this.fileSize=-1,this.timestamp=-1,this.checksum=-1}getSegmentIndex(){return this.segmentIndex}setSegmentIndex(e){this.segmentIndex=e}getFileId(){return this.fileId}setFileId(e){this.fileId=e}getOptionalData(){return this.optionalData}setOptionalData(e){this.optionalData=e}isLastSegment(){return this.lastSegment}setLastSegment(e){this.lastSegment=e}getSegmentCount(){return this.segmentCount}setSegmentCount(e){this.segmentCount=e}getSender(){return this.sender||null}setSender(e){this.sender=e}getAddressee(){return this.addressee||null}setAddressee(e){this.addressee=e}getFileName(){return this.fileName}setFileName(e){this.fileName=e}getFileSize(){return this.fileSize}setFileSize(e){this.fileSize=e}getChecksum(){return this.checksum}setChecksum(e){this.checksum=e}getTimestamp(){return this.timestamp}setTimestamp(e){this.timestamp=e}}class rn{static parseLong(e){return parseInt(e,arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0)}}class sn extends c{}sn.kind="NullPointerException";class an{writeBytes(e){this.writeBytesOffset(e,0,e.length)}writeBytesOffset(e,t,n){if(null==e)throw new sn;if(t<0||t>e.length||n<0||t+n>e.length||t+n<0)throw new g;if(0!==n)for(let r=0;r<n;r++)this.write(e[t+r])}flush(){}close(){}}class on extends c{}class ln extends an{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:32;if(super(),this.count=0,e<0)throw new d("Negative initial size: "+e);this.buf=new Uint8Array(e)}ensureCapacity(e){e-this.buf.length>0&&this.grow(e)}grow(e){let t=this.buf.length<<1;if(t-e<0&&(t=e),t<0){if(e<0)throw new on;t=v.MAX_VALUE}this.buf=w.copyOfUint8Array(this.buf,t)}write(e){this.ensureCapacity(this.count+1),this.buf[this.count]=e,this.count+=1}writeBytesOffset(e,t,n){if(t<0||t>e.length||n<0||t+n-e.length>0)throw new g;this.ensureCapacity(this.count+n),m.arraycopy(e,t,this.buf,this.count,n),this.count+=n}writeTo(e){e.writeBytesOffset(this.buf,0,this.count)}reset(){this.count=0}toByteArray(){return w.copyOfUint8Array(this.buf,this.count)}size(){return this.count}toString(e){return e?"string"===typeof e?this.toString_string(e):this.toString_number(e):this.toString_void()}toString_void(){return new String(this.buf).toString()}toString_string(e){return new String(this.buf).toString()}toString_number(e){return new String(this.buf).toString()}close(){}}function cn(){if("undefined"!==typeof window)return window.BigInt||null;if("undefined"!==typeof n.g)return n.g.BigInt||null;if("undefined"!==typeof self)return self.BigInt||null;throw new Error("Can't search globals for BigInt!")}let un;function dn(e){if("undefined"===typeof un&&(un=cn()),null===un)throw new Error("BigInt is not supported!");return un(e)}function hn(){let e=[];e[0]=dn(1);let t=dn(900);e[1]=t;for(let n=2;n<16;n++)e[n]=e[n-1]*t;return e}!function(e){e[e.ALPHA=0]="ALPHA",e[e.LOWER=1]="LOWER",e[e.MIXED=2]="MIXED",e[e.PUNCT=3]="PUNCT",e[e.ALPHA_SHIFT=4]="ALPHA_SHIFT",e[e.PUNCT_SHIFT=5]="PUNCT_SHIFT"}(K||(K={}));class fn{static decode(e,t){let n=new T(""),r=C.ISO8859_1;n.enableDecoding(r);let s=1,a=e[s++],i=new nn;for(;s<e[0];){switch(a){case fn.TEXT_COMPACTION_MODE_LATCH:s=fn.textCompaction(e,s,n);break;case fn.BYTE_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH_6:s=fn.byteCompaction(a,e,r,s,n);break;case fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:n.append(e[s++]);break;case fn.NUMERIC_COMPACTION_MODE_LATCH:s=fn.numericCompaction(e,s,n);break;case fn.ECI_CHARSET:C.getCharacterSetECIByValue(e[s++]);break;case fn.ECI_GENERAL_PURPOSE:s+=2;break;case fn.ECI_USER_DEFINED:s++;break;case fn.BEGIN_MACRO_PDF417_CONTROL_BLOCK:s=fn.decodeMacroBlock(e,s,i);break;case fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:case fn.MACRO_PDF417_TERMINATOR:throw new S;default:s--,s=fn.textCompaction(e,s,n)}if(!(s<e.length))throw S.getFormatInstance();a=e[s++]}if(0===n.length())throw S.getFormatInstance();let o=new q(null,n.toString(),null,t);return o.setOther(i),o}static decodeMacroBlock(e,t,n){if(t+fn.NUMBER_OF_SEQUENCE_CODEWORDS>e[0])throw S.getFormatInstance();let r=new Int32Array(fn.NUMBER_OF_SEQUENCE_CODEWORDS);for(let i=0;i<fn.NUMBER_OF_SEQUENCE_CODEWORDS;i++,t++)r[i]=e[t];n.setSegmentIndex(v.parseInt(fn.decodeBase900toBase10(r,fn.NUMBER_OF_SEQUENCE_CODEWORDS)));let s=new T;t=fn.textCompaction(e,t,s),n.setFileId(s.toString());let a=-1;for(e[t]===fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD&&(a=t+1);t<e[0];)switch(e[t]){case fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:switch(e[++t]){case fn.MACRO_PDF417_OPTIONAL_FIELD_FILE_NAME:let r=new T;t=fn.textCompaction(e,t+1,r),n.setFileName(r.toString());break;case fn.MACRO_PDF417_OPTIONAL_FIELD_SENDER:let s=new T;t=fn.textCompaction(e,t+1,s),n.setSender(s.toString());break;case fn.MACRO_PDF417_OPTIONAL_FIELD_ADDRESSEE:let a=new T;t=fn.textCompaction(e,t+1,a),n.setAddressee(a.toString());break;case fn.MACRO_PDF417_OPTIONAL_FIELD_SEGMENT_COUNT:let i=new T;t=fn.numericCompaction(e,t+1,i),n.setSegmentCount(v.parseInt(i.toString()));break;case fn.MACRO_PDF417_OPTIONAL_FIELD_TIME_STAMP:let o=new T;t=fn.numericCompaction(e,t+1,o),n.setTimestamp(rn.parseLong(o.toString()));break;case fn.MACRO_PDF417_OPTIONAL_FIELD_CHECKSUM:let l=new T;t=fn.numericCompaction(e,t+1,l),n.setChecksum(v.parseInt(l.toString()));break;case fn.MACRO_PDF417_OPTIONAL_FIELD_FILE_SIZE:let c=new T;t=fn.numericCompaction(e,t+1,c),n.setFileSize(rn.parseLong(c.toString()));break;default:throw S.getFormatInstance()}break;case fn.MACRO_PDF417_TERMINATOR:t++,n.setLastSegment(!0);break;default:throw S.getFormatInstance()}if(-1!==a){let r=t-a;n.isLastSegment()&&r--,n.setOptionalData(w.copyOfRange(e,a,a+r))}return t}static textCompaction(e,t,n){let r=new Int32Array(2*(e[0]-t)),s=new Int32Array(2*(e[0]-t)),a=0,i=!1;for(;t<e[0]&&!i;){let n=e[t++];if(n<fn.TEXT_COMPACTION_MODE_LATCH)r[a]=n/30,r[a+1]=n%30,a+=2;else switch(n){case fn.TEXT_COMPACTION_MODE_LATCH:r[a++]=fn.TEXT_COMPACTION_MODE_LATCH;break;case fn.BYTE_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH_6:case fn.NUMERIC_COMPACTION_MODE_LATCH:case fn.BEGIN_MACRO_PDF417_CONTROL_BLOCK:case fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:case fn.MACRO_PDF417_TERMINATOR:t--,i=!0;break;case fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:r[a]=fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE,n=e[t++],s[a]=n,a++}}return fn.decodeTextCompaction(r,s,a,n),t}static decodeTextCompaction(e,t,n,r){let s=K.ALPHA,a=K.ALPHA,i=0;for(;i<n;){let n=e[i],o="";switch(s){case K.ALPHA:if(n<26)o=String.fromCharCode(65+n);else switch(n){case 26:o=" ";break;case fn.LL:s=K.LOWER;break;case fn.ML:s=K.MIXED;break;case fn.PS:a=s,s=K.PUNCT_SHIFT;break;case fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:r.append(t[i]);break;case fn.TEXT_COMPACTION_MODE_LATCH:s=K.ALPHA}break;case K.LOWER:if(n<26)o=String.fromCharCode(97+n);else switch(n){case 26:o=" ";break;case fn.AS:a=s,s=K.ALPHA_SHIFT;break;case fn.ML:s=K.MIXED;break;case fn.PS:a=s,s=K.PUNCT_SHIFT;break;case fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:r.append(t[i]);break;case fn.TEXT_COMPACTION_MODE_LATCH:s=K.ALPHA}break;case K.MIXED:if(n<fn.PL)o=fn.MIXED_CHARS[n];else switch(n){case fn.PL:s=K.PUNCT;break;case 26:o=" ";break;case fn.LL:s=K.LOWER;break;case fn.AL:s=K.ALPHA;break;case fn.PS:a=s,s=K.PUNCT_SHIFT;break;case fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:r.append(t[i]);break;case fn.TEXT_COMPACTION_MODE_LATCH:s=K.ALPHA}break;case K.PUNCT:if(n<fn.PAL)o=fn.PUNCT_CHARS[n];else switch(n){case fn.PAL:s=K.ALPHA;break;case fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:r.append(t[i]);break;case fn.TEXT_COMPACTION_MODE_LATCH:s=K.ALPHA}break;case K.ALPHA_SHIFT:if(s=a,n<26)o=String.fromCharCode(65+n);else switch(n){case 26:o=" ";break;case fn.TEXT_COMPACTION_MODE_LATCH:s=K.ALPHA}break;case K.PUNCT_SHIFT:if(s=a,n<fn.PAL)o=fn.PUNCT_CHARS[n];else switch(n){case fn.PAL:s=K.ALPHA;break;case fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE:r.append(t[i]);break;case fn.TEXT_COMPACTION_MODE_LATCH:s=K.ALPHA}}""!==o&&r.append(o),i++}}static byteCompaction(e,t,n,r,s){let a=new ln,i=0,o=0,l=!1;switch(e){case fn.BYTE_COMPACTION_MODE_LATCH:let e=new Int32Array(6),n=t[r++];for(;r<t[0]&&!l;)switch(e[i++]=n,o=900*o+n,n=t[r++],n){case fn.TEXT_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH:case fn.NUMERIC_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH_6:case fn.BEGIN_MACRO_PDF417_CONTROL_BLOCK:case fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:case fn.MACRO_PDF417_TERMINATOR:r--,l=!0;break;default:if(i%5===0&&i>0){for(let e=0;e<6;++e)a.write(Number(dn(o)>>dn(8*(5-e))));o=0,i=0}}r===t[0]&&n<fn.TEXT_COMPACTION_MODE_LATCH&&(e[i++]=n);for(let t=0;t<i;t++)a.write(e[t]);break;case fn.BYTE_COMPACTION_MODE_LATCH_6:for(;r<t[0]&&!l;){let e=t[r++];if(e<fn.TEXT_COMPACTION_MODE_LATCH)i++,o=900*o+e;else switch(e){case fn.TEXT_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH:case fn.NUMERIC_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH_6:case fn.BEGIN_MACRO_PDF417_CONTROL_BLOCK:case fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:case fn.MACRO_PDF417_TERMINATOR:r--,l=!0}if(i%5===0&&i>0){for(let e=0;e<6;++e)a.write(Number(dn(o)>>dn(8*(5-e))));o=0,i=0}}}return s.append(N.decode(a.toByteArray(),n)),r}static numericCompaction(e,t,n){let r=0,s=!1,a=new Int32Array(fn.MAX_NUMERIC_CODEWORDS);for(;t<e[0]&&!s;){let i=e[t++];if(t===e[0]&&(s=!0),i<fn.TEXT_COMPACTION_MODE_LATCH)a[r]=i,r++;else switch(i){case fn.TEXT_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH:case fn.BYTE_COMPACTION_MODE_LATCH_6:case fn.BEGIN_MACRO_PDF417_CONTROL_BLOCK:case fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD:case fn.MACRO_PDF417_TERMINATOR:t--,s=!0}(r%fn.MAX_NUMERIC_CODEWORDS===0||i===fn.NUMERIC_COMPACTION_MODE_LATCH||s)&&r>0&&(n.append(fn.decodeBase900toBase10(a,r)),r=0)}return t}static decodeBase900toBase10(e,t){let n=dn(0);for(let s=0;s<t;s++)n+=fn.EXP900[t-s-1]*dn(e[s]);let r=n.toString();if("1"!==r.charAt(0))throw new S;return r.substring(1)}}fn.TEXT_COMPACTION_MODE_LATCH=900,fn.BYTE_COMPACTION_MODE_LATCH=901,fn.NUMERIC_COMPACTION_MODE_LATCH=902,fn.BYTE_COMPACTION_MODE_LATCH_6=924,fn.ECI_USER_DEFINED=925,fn.ECI_GENERAL_PURPOSE=926,fn.ECI_CHARSET=927,fn.BEGIN_MACRO_PDF417_CONTROL_BLOCK=928,fn.BEGIN_MACRO_PDF417_OPTIONAL_FIELD=923,fn.MACRO_PDF417_TERMINATOR=922,fn.MODE_SHIFT_TO_BYTE_COMPACTION_MODE=913,fn.MAX_NUMERIC_CODEWORDS=15,fn.MACRO_PDF417_OPTIONAL_FIELD_FILE_NAME=0,fn.MACRO_PDF417_OPTIONAL_FIELD_SEGMENT_COUNT=1,fn.MACRO_PDF417_OPTIONAL_FIELD_TIME_STAMP=2,fn.MACRO_PDF417_OPTIONAL_FIELD_SENDER=3,fn.MACRO_PDF417_OPTIONAL_FIELD_ADDRESSEE=4,fn.MACRO_PDF417_OPTIONAL_FIELD_FILE_SIZE=5,fn.MACRO_PDF417_OPTIONAL_FIELD_CHECKSUM=6,fn.PL=25,fn.LL=27,fn.AS=27,fn.ML=28,fn.AL=28,fn.PS=29,fn.PAL=29,fn.PUNCT_CHARS=";<>@[\\]_`~!\r\t,:\n-.$/\"|*()?{}'",fn.MIXED_CHARS="0123456789&\r\t,:#-.$/+%*=^",fn.EXP900=cn()?hn():[],fn.NUMBER_OF_SEQUENCE_CODEWORDS=2;class pn{constructor(){}static decode(e,t,n,r,s,a,i){let o,l=new Qt(e,t,n,r,s),c=null,u=null;for(let f=!0;;f=!1){if(null!=t&&(c=pn.getRowIndicatorColumn(e,l,t,!0,a,i)),null!=r&&(u=pn.getRowIndicatorColumn(e,l,r,!1,a,i)),o=pn.merge(c,u),null==o)throw _.getNotFoundInstance();let n=o.getBoundingBox();if(!f||null==n||!(n.getMinY()<l.getMinY()||n.getMaxY()>l.getMaxY()))break;l=n}o.setBoundingBox(l);let d=o.getBarcodeColumnCount()+1;o.setDetectionResultColumn(0,c),o.setDetectionResultColumn(d,u);let h=null!=c;for(let f=1;f<=d;f++){let t,n=h?f:d-f;if(void 0!==o.getDetectionResultColumn(n))continue;t=0===n||n===d?new Zt(l,0===n):new qt(l),o.setDetectionResultColumn(n,t);let r=-1,s=r;for(let c=l.getMinY();c<=l.getMaxY();c++){if(r=pn.getStartColumn(o,n,c,h),r<0||r>l.getMaxX()){if(-1===s)continue;r=s}let u=pn.detectCodeword(e,l.getMinX(),l.getMaxX(),h,r,c,a,i);null!=u&&(t.setCodeword(c,u),s=r,a=Math.min(a,u.getWidth()),i=Math.max(i,u.getWidth()))}}return pn.createDecoderResult(o)}static merge(e,t){if(null==e&&null==t)return null;let n=pn.getBarcodeMetadata(e,t);if(null==n)return null;let r=Qt.merge(pn.adjustBoundingBox(e),pn.adjustBoundingBox(t));return new $t(n,r)}static adjustBoundingBox(e){if(null==e)return null;let t=e.getRowHeights();if(null==t)return null;let n=pn.getMax(t),r=0;for(let i of t)if(r+=n-i,i>0)break;let s=e.getCodewords();for(let i=0;r>0&&null==s[i];i++)r--;let a=0;for(let i=t.length-1;i>=0&&(a+=n-t[i],!(t[i]>0));i--);for(let i=s.length-1;a>0&&null==s[i];i--)a--;return e.getBoundingBox().addMissingRows(r,a,e.isLeft())}static getMax(e){let t=-1;for(let n of e)t=Math.max(t,n);return t}static getBarcodeMetadata(e,t){let n,r;return null==e||null==(n=e.getBarcodeMetadata())?null==t?null:t.getBarcodeMetadata():null==t||null==(r=t.getBarcodeMetadata())?n:n.getColumnCount()!==r.getColumnCount()&&n.getErrorCorrectionLevel()!==r.getErrorCorrectionLevel()&&n.getRowCount()!==r.getRowCount()?null:n}static getRowIndicatorColumn(e,t,n,r,s,a){let i=new Zt(t,r);for(let o=0;o<2;o++){let l=0===o?1:-1,c=Math.trunc(Math.trunc(n.getX()));for(let o=Math.trunc(Math.trunc(n.getY()));o<=t.getMaxY()&&o>=t.getMinY();o+=l){let t=pn.detectCodeword(e,0,e.getWidth(),r,c,o,s,a);null!=t&&(i.setCodeword(o,t),c=r?t.getStartX():t.getEndX())}}return i}static adjustCodewordCount(e,t){let n=t[0][1],r=n.getValue(),s=e.getBarcodeColumnCount()*e.getBarcodeRowCount()-pn.getNumberOfECCodeWords(e.getBarcodeECLevel());if(0===r.length){if(s<1||s>Ut.MAX_CODEWORDS_IN_BARCODE)throw _.getNotFoundInstance();n.setValue(s)}else r[0]!==s&&n.setValue(s)}static createDecoderResult(e){let t=pn.createBarcodeMatrix(e);pn.adjustCodewordCount(e,t);let n=new Array,r=new Int32Array(e.getBarcodeRowCount()*e.getBarcodeColumnCount()),s=[],a=new Array;for(let o=0;o<e.getBarcodeRowCount();o++)for(let i=0;i<e.getBarcodeColumnCount();i++){let l=t[o][i+1].getValue(),c=o*e.getBarcodeColumnCount()+i;0===l.length?n.push(c):1===l.length?r[c]=l[0]:(a.push(c),s.push(l))}let i=new Array(s.length);for(let o=0;o<i.length;o++)i[o]=s[o];return pn.createDecoderResultFromAmbiguousValues(e.getBarcodeECLevel(),r,Ut.toIntArray(n),Ut.toIntArray(a),i)}static createDecoderResultFromAmbiguousValues(e,t,n,r,s){let a=new Int32Array(r.length),i=100;for(;i-- >0;){for(let e=0;e<a.length;e++)t[r[e]]=s[e][a[e]];try{return pn.decodeCodewords(t,e,n)}catch(o){if(!(o instanceof f))throw o}if(0===a.length)throw f.getChecksumInstance();for(let e=0;e<a.length;e++){if(a[e]<s[e].length-1){a[e]++;break}if(a[e]=0,e===a.length-1)throw f.getChecksumInstance()}}throw f.getChecksumInstance()}static createBarcodeMatrix(e){let t=Array.from({length:e.getBarcodeRowCount()},()=>new Array(e.getBarcodeColumnCount()+2));for(let r=0;r<t.length;r++)for(let e=0;e<t[r].length;e++)t[r][e]=new Xt;let n=0;for(let r of e.getDetectionResultColumns()){if(null!=r)for(let e of r.getCodewords())if(null!=e){let r=e.getRowNumber();if(r>=0){if(r>=t.length)continue;t[r][n].setValue(e.getValue())}}n++}return t}static isValidBarcodeColumn(e,t){return t>=0&&t<=e.getBarcodeColumnCount()+1}static getStartColumn(e,t,n,r){let s=r?1:-1,a=null;if(pn.isValidBarcodeColumn(e,t-s)&&(a=e.getDetectionResultColumn(t-s).getCodeword(n)),null!=a)return r?a.getEndX():a.getStartX();if(a=e.getDetectionResultColumn(t).getCodewordNearby(n),null!=a)return r?a.getStartX():a.getEndX();if(pn.isValidBarcodeColumn(e,t-s)&&(a=e.getDetectionResultColumn(t-s).getCodewordNearby(n)),null!=a)return r?a.getEndX():a.getStartX();let i=0;for(;pn.isValidBarcodeColumn(e,t-s);){t-=s;for(let n of e.getDetectionResultColumn(t).getCodewords())if(null!=n)return(r?n.getEndX():n.getStartX())+s*i*(n.getEndX()-n.getStartX());i++}return r?e.getBoundingBox().getMinX():e.getBoundingBox().getMaxX()}static detectCodeword(e,t,n,r,s,a,i,o){s=pn.adjustCodewordStartColumn(e,t,n,r,s,a);let l,c=pn.getModuleBitCount(e,t,n,r,s,a);if(null==c)return null;let u=ae.sum(c);if(r)l=s+u;else{for(let e=0;e<c.length/2;e++){let t=c[e];c[e]=c[c.length-1-e],c[c.length-1-e]=t}l=s,s=l-u}if(!pn.checkCodewordSkew(u,i,o))return null;let d=tn.getDecodedValue(c),h=Ut.getCodeword(d);return-1===h?null:new en(s,l,pn.getCodewordBucketNumber(d),h)}static getModuleBitCount(e,t,n,r,s,a){let i=s,o=new Int32Array(8),l=0,c=r?1:-1,u=r;for(;(r?i<n:i>=t)&&l<o.length;)e.get(i,a)===u?(o[l]++,i+=c):(l++,u=!u);return l===o.length||i===(r?n:t)&&l===o.length-1?o:null}static getNumberOfECCodeWords(e){return 2<<e}static adjustCodewordStartColumn(e,t,n,r,s,a){let i=s,o=r?-1:1;for(let l=0;l<2;l++){for(;(r?i>=t:i<n)&&r===e.get(i,a);){if(Math.abs(s-i)>pn.CODEWORD_SKEW_SIZE)return s;i+=o}o=-o,r=!r}return i}static checkCodewordSkew(e,t,n){return t-pn.CODEWORD_SKEW_SIZE<=e&&e<=n+pn.CODEWORD_SKEW_SIZE}static decodeCodewords(e,t,n){if(0===e.length)throw S.getFormatInstance();let r=1<<t+1,s=pn.correctErrors(e,n,r);pn.verifyCodewordCount(e,r);let a=fn.decode(e,""+t);return a.setErrorsCorrected(s),a.setErasures(n.length),a}static correctErrors(e,t,n){if(null!=t&&t.length>n/2+pn.MAX_ERRORS||n<0||n>pn.MAX_EC_CODEWORDS)throw f.getChecksumInstance();return pn.errorCorrection.decode(e,n,t)}static verifyCodewordCount(e,t){if(e.length<4)throw S.getFormatInstance();let n=e[0];if(n>e.length)throw S.getFormatInstance();if(0===n){if(!(t<e.length))throw S.getFormatInstance();e[0]=e.length-t}}static getBitCountForCodeword(e){let t=new Int32Array(8),n=0,r=t.length-1;for(;!((1&e)!==n&&(n=1&e,r--,r<0));)t[r]++,e>>=1;return t}static getCodewordBucketNumber(e){return e instanceof Int32Array?this.getCodewordBucketNumber_Int32Array(e):this.getCodewordBucketNumber_number(e)}static getCodewordBucketNumber_number(e){return pn.getCodewordBucketNumber(pn.getBitCountForCodeword(e))}static getCodewordBucketNumber_Int32Array(e){return(e[0]-e[2]+e[4]-e[6]+9)%9}static toString(e){let t=new Yt;for(let n=0;n<e.length;n++){t.format("Row %2d: ",n);for(let r=0;r<e[n].length;r++){let s=e[n][r];0===s.getValue().length?t.format("        ",null):t.format("%4d(%2d)",s.getValue()[0],s.getConfidence(s.getValue()[0]))}t.format("%n")}return t.toString()}}pn.CODEWORD_SKEW_SIZE=2,pn.MAX_ERRORS=3,pn.MAX_EC_CODEWORDS=512,pn.errorCorrection=new Jt;class mn{decode(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,n=mn.decode(e,t,!1);if(null==n||0===n.length||null==n[0])throw _.getNotFoundInstance();return n[0]}decodeMultiple(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;try{return mn.decode(e,t,!0)}catch(n){if(n instanceof S||n instanceof f)throw _.getNotFoundInstance();throw n}}static decode(e,t,n){const r=new Array,s=zt.detectMultiple(e,t,n);for(const a of s.getPoints()){const e=pn.decode(s.getBits(),a[4],a[5],a[6],a[7],mn.getMinCodewordWidth(a),mn.getMaxCodewordWidth(a)),t=new U(e.getText(),e.getRawBytes(),void 0,a,z.PDF_417);t.putMetadata(Y.ERROR_CORRECTION_LEVEL,e.getECLevel());const n=e.getOther();null!=n&&t.putMetadata(Y.PDF417_EXTRA_METADATA,n),r.push(t)}return r.map(e=>e)}static getMaxWidth(e,t){return null==e||null==t?0:Math.trunc(Math.abs(e.getX()-t.getX()))}static getMinWidth(e,t){return null==e||null==t?v.MAX_VALUE:Math.trunc(Math.abs(e.getX()-t.getX()))}static getMaxCodewordWidth(e){return Math.floor(Math.max(Math.max(mn.getMaxWidth(e[0],e[4]),mn.getMaxWidth(e[6],e[2])*Ut.MODULES_IN_CODEWORD/Ut.MODULES_IN_STOP_PATTERN),Math.max(mn.getMaxWidth(e[1],e[5]),mn.getMaxWidth(e[7],e[3])*Ut.MODULES_IN_CODEWORD/Ut.MODULES_IN_STOP_PATTERN)))}static getMinCodewordWidth(e){return Math.floor(Math.min(Math.min(mn.getMinWidth(e[0],e[4]),mn.getMinWidth(e[6],e[2])*Ut.MODULES_IN_CODEWORD/Ut.MODULES_IN_STOP_PATTERN),Math.min(mn.getMinWidth(e[1],e[5]),mn.getMinWidth(e[7],e[3])*Ut.MODULES_IN_CODEWORD/Ut.MODULES_IN_STOP_PATTERN)))}reset(){}}class gn extends c{}gn.kind="ReaderException";class yn{constructor(e,t){this.verbose=!0===e,t&&this.setHints(t)}decode(e,t){return t&&this.setHints(t),this.decodeInternal(e)}decodeWithState(e){return null!==this.readers&&void 0!==this.readers||this.setHints(null),this.decodeInternal(e)}setHints(e){this.hints=e;const n=!t(e)&&!0===e.get(x.TRY_HARDER),r=t(e)?null:e.get(x.POSSIBLE_FORMATS),s=new Array;if(!t(r)){const t=r.some(e=>e===z.UPC_A||e===z.UPC_E||e===z.EAN_13||e===z.EAN_8||e===z.CODABAR||e===z.CODE_39||e===z.CODE_93||e===z.CODE_128||e===z.ITF||e===z.RSS_14||e===z.RSS_EXPANDED);t&&!n&&s.push(new lt(e,this.verbose)),r.includes(z.QR_CODE)&&s.push(new Ft),r.includes(z.DATA_MATRIX)&&s.push(new vt),r.includes(z.AZTEC)&&s.push(new ye),r.includes(z.PDF_417)&&s.push(new mn),t&&n&&s.push(new lt(e,this.verbose))}0===s.length&&(n||s.push(new lt(e,this.verbose)),s.push(new Ft),s.push(new vt),s.push(new ye),s.push(new mn),n&&s.push(new lt(e,this.verbose))),this.readers=s}reset(){if(null!==this.readers)for(const e of this.readers)e.reset()}decodeInternal(e){if(null===this.readers)throw new gn("No readers where selected, nothing can be read.");for(const n of this.readers)try{return n.decode(e,this.hints)}catch(t){if(t instanceof gn)continue}throw new _("No MultiFormat Readers were able to detect the code.")}}class wn extends F{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:500;const n=new yn;n.setHints(e),super(n,t)}decodeBitmap(e){return this.reader.decodeWithState(e)}}class vn extends F{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:500;super(new mn,e)}}class An extends F{constructor(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:500;super(new Ft,e)}}var bn;!function(e){e[e.ERROR_CORRECTION=0]="ERROR_CORRECTION",e[e.CHARACTER_SET=1]="CHARACTER_SET",e[e.DATA_MATRIX_SHAPE=2]="DATA_MATRIX_SHAPE",e[e.MIN_SIZE=3]="MIN_SIZE",e[e.MAX_SIZE=4]="MAX_SIZE",e[e.MARGIN=5]="MARGIN",e[e.PDF417_COMPACT=6]="PDF417_COMPACT",e[e.PDF417_COMPACTION=7]="PDF417_COMPACTION",e[e.PDF417_DIMENSIONS=8]="PDF417_DIMENSIONS",e[e.AZTEC_LAYERS=9]="AZTEC_LAYERS",e[e.QR_VERSION=10]="QR_VERSION"}(bn||(bn={}));var xn=bn;class Sn{constructor(e){this.field=e,this.cachedGenerators=[],this.cachedGenerators.push(new Z(e,Int32Array.from([1])))}buildGenerator(e){const t=this.cachedGenerators;if(e>=t.length){let n=t[t.length-1];const r=this.field;for(let s=t.length;s<=e;s++){const e=n.multiply(new Z(r,Int32Array.from([1,r.exp(s-1+r.getGeneratorBase())])));t.push(e),n=e}}return t[e]}encode(e,t){if(0===t)throw new d("No error correction bytes");const n=e.length-t;if(n<=0)throw new d("No data bytes provided");const r=this.buildGenerator(t),s=new Int32Array(n);m.arraycopy(e,0,s,0,n);let a=new Z(this.field,s);a=a.multiplyByMonomial(t,1);const i=a.divide(r)[1].getCoefficients(),o=t-i.length;for(let l=0;l<o;l++)e[n+l]=0;m.arraycopy(i,0,e,n+o,i.length)}}class Cn{constructor(){}static applyMaskPenaltyRule1(e){return Cn.applyMaskPenaltyRule1Internal(e,!0)+Cn.applyMaskPenaltyRule1Internal(e,!1)}static applyMaskPenaltyRule2(e){let t=0;const n=e.getArray(),r=e.getWidth(),s=e.getHeight();for(let a=0;a<s-1;a++){const e=n[a];for(let s=0;s<r-1;s++){const r=e[s];r===e[s+1]&&r===n[a+1][s]&&r===n[a+1][s+1]&&t++}}return Cn.N2*t}static applyMaskPenaltyRule3(e){let t=0;const n=e.getArray(),r=e.getWidth(),s=e.getHeight();for(let a=0;a<s;a++)for(let e=0;e<r;e++){const i=n[a];e+6<r&&1===i[e]&&0===i[e+1]&&1===i[e+2]&&1===i[e+3]&&1===i[e+4]&&0===i[e+5]&&1===i[e+6]&&(Cn.isWhiteHorizontal(i,e-4,e)||Cn.isWhiteHorizontal(i,e+7,e+11))&&t++,a+6<s&&1===n[a][e]&&0===n[a+1][e]&&1===n[a+2][e]&&1===n[a+3][e]&&1===n[a+4][e]&&0===n[a+5][e]&&1===n[a+6][e]&&(Cn.isWhiteVertical(n,e,a-4,a)||Cn.isWhiteVertical(n,e,a+7,a+11))&&t++}return t*Cn.N3}static isWhiteHorizontal(e,t,n){t=Math.max(t,0),n=Math.min(n,e.length);for(let r=t;r<n;r++)if(1===e[r])return!1;return!0}static isWhiteVertical(e,t,n,r){n=Math.max(n,0),r=Math.min(r,e.length);for(let s=n;s<r;s++)if(1===e[s][t])return!1;return!0}static applyMaskPenaltyRule4(e){let t=0;const n=e.getArray(),r=e.getWidth(),s=e.getHeight();for(let i=0;i<s;i++){const e=n[i];for(let n=0;n<r;n++)1===e[n]&&t++}const a=e.getHeight()*e.getWidth();return Math.floor(10*Math.abs(2*t-a)/a)*Cn.N4}static getDataMaskBit(e,t,n){let r,s;switch(e){case 0:r=n+t&1;break;case 1:r=1&n;break;case 2:r=t%3;break;case 3:r=(n+t)%3;break;case 4:r=Math.floor(n/2)+Math.floor(t/3)&1;break;case 5:s=n*t,r=(1&s)+s%3;break;case 6:s=n*t,r=(1&s)+s%3&1;break;case 7:s=n*t,r=s%3+(n+t&1)&1;break;default:throw new d("Invalid mask pattern: "+e)}return 0===r}static applyMaskPenaltyRule1Internal(e,t){let n=0;const r=t?e.getHeight():e.getWidth(),s=t?e.getWidth():e.getHeight(),a=e.getArray();for(let i=0;i<r;i++){let e=0,r=-1;for(let o=0;o<s;o++){const s=t?a[i][o]:a[o][i];s===r?e++:(e>=5&&(n+=Cn.N1+(e-5)),e=1,r=s)}e>=5&&(n+=Cn.N1+(e-5))}return n}}Cn.N1=3,Cn.N2=3,Cn.N3=40,Cn.N4=10;class En{constructor(e,t){this.width=e,this.height=t;const n=new Array(t);for(let r=0;r!==t;r++)n[r]=new Uint8Array(e);this.bytes=n}getHeight(){return this.height}getWidth(){return this.width}get(e,t){return this.bytes[t][e]}getArray(){return this.bytes}setNumber(e,t,n){this.bytes[t][e]=n}setBoolean(e,t,n){this.bytes[t][e]=n?1:0}clear(e){for(const t of this.bytes)w.fill(t,e)}equals(e){if(!(e instanceof En))return!1;const t=e;if(this.width!==t.width)return!1;if(this.height!==t.height)return!1;for(let n=0,r=this.height;n<r;++n){const e=this.bytes[n],r=t.bytes[n];for(let t=0,n=this.width;t<n;++t)if(e[t]!==r[t])return!1}return!0}toString(){const e=new T;for(let t=0,n=this.height;t<n;++t){const n=this.bytes[t];for(let t=0,r=this.width;t<r;++t)switch(n[t]){case 0:e.append(" 0");break;case 1:e.append(" 1");break;default:e.append("  ")}e.append("\n")}return e.toString()}}class Nn{constructor(){this.maskPattern=-1}getMode(){return this.mode}getECLevel(){return this.ecLevel}getVersion(){return this.version}getMaskPattern(){return this.maskPattern}getMatrix(){return this.matrix}toString(){const e=new T;return e.append("<<\n"),e.append(" mode: "),e.append(this.mode?this.mode.toString():"null"),e.append("\n ecLevel: "),e.append(this.ecLevel?this.ecLevel.toString():"null"),e.append("\n version: "),e.append(this.version?this.version.toString():"null"),e.append("\n maskPattern: "),e.append(this.maskPattern.toString()),this.matrix?(e.append("\n matrix:\n"),e.append(this.matrix.toString())):e.append("\n matrix: null\n"),e.append(">>\n"),e.toString()}setMode(e){this.mode=e}setECLevel(e){this.ecLevel=e}setVersion(e){this.version=e}setMaskPattern(e){this.maskPattern=e}setMatrix(e){this.matrix=e}static isValidMaskPattern(e){return e>=0&&e<Nn.NUM_MASK_PATTERNS}}Nn.NUM_MASK_PATTERNS=8;class kn extends c{}kn.kind="WriterException";class Tn{constructor(){}static clearMatrix(e){e.clear(255)}static buildMatrix(e,t,n,r,s){Tn.clearMatrix(s),Tn.embedBasicPatterns(n,s),Tn.embedTypeInfo(t,r,s),Tn.maybeEmbedVersionInfo(n,s),Tn.embedDataBits(e,r,s)}static embedBasicPatterns(e,t){Tn.embedPositionDetectionPatternsAndSeparators(t),Tn.embedDarkDotAtLeftBottomCorner(t),Tn.maybeEmbedPositionAdjustmentPatterns(e,t),Tn.embedTimingPatterns(t)}static embedTypeInfo(e,t,n){const r=new A;Tn.makeTypeInfoBits(e,t,r);for(let s=0,a=r.getSize();s<a;++s){const e=r.get(r.getSize()-1-s),t=Tn.TYPE_INFO_COORDINATES[s],a=t[0],i=t[1];if(n.setBoolean(a,i,e),s<8){const t=n.getWidth()-s-1,r=8;n.setBoolean(t,r,e)}else{const t=8,r=n.getHeight()-7+(s-8);n.setBoolean(t,r,e)}}}static maybeEmbedVersionInfo(e,t){if(e.getVersionNumber()<7)return;const n=new A;Tn.makeVersionInfoBits(e,n);let r=17;for(let s=0;s<6;++s)for(let e=0;e<3;++e){const a=n.get(r);r--,t.setBoolean(s,t.getHeight()-11+e,a),t.setBoolean(t.getHeight()-11+e,s,a)}}static embedDataBits(e,t,n){let r=0,s=-1,a=n.getWidth()-1,i=n.getHeight()-1;for(;a>0;){for(6===a&&(a-=1);i>=0&&i<n.getHeight();){for(let s=0;s<2;++s){const o=a-s;if(!Tn.isEmpty(n.get(o,i)))continue;let l;r<e.getSize()?(l=e.get(r),++r):l=!1,255!==t&&Cn.getDataMaskBit(t,o,i)&&(l=!l),n.setBoolean(o,i,l)}i+=s}s=-s,i+=s,a-=2}if(r!==e.getSize())throw new kn("Not all bits consumed: "+r+"/"+e.getSize())}static findMSBSet(e){return 32-v.numberOfLeadingZeros(e)}static calculateBCHCode(e,t){if(0===t)throw new d("0 polynomial");const n=Tn.findMSBSet(t);for(e<<=n-1;Tn.findMSBSet(e)>=n;)e^=t<<Tn.findMSBSet(e)-n;return e}static makeTypeInfoBits(e,t,n){if(!Nn.isValidMaskPattern(t))throw new kn("Invalid mask pattern");const r=e.getBits()<<3|t;n.appendBits(r,5);const s=Tn.calculateBCHCode(r,Tn.TYPE_INFO_POLY);n.appendBits(s,10);const a=new A;if(a.appendBits(Tn.TYPE_INFO_MASK_PATTERN,15),n.xor(a),15!==n.getSize())throw new kn("should not happen but we got: "+n.getSize())}static makeVersionInfoBits(e,t){t.appendBits(e.getVersionNumber(),6);const n=Tn.calculateBCHCode(e.getVersionNumber(),Tn.VERSION_INFO_POLY);if(t.appendBits(n,12),18!==t.getSize())throw new kn("should not happen but we got: "+t.getSize())}static isEmpty(e){return 255===e}static embedTimingPatterns(e){for(let t=8;t<e.getWidth()-8;++t){const n=(t+1)%2;Tn.isEmpty(e.get(t,6))&&e.setNumber(t,6,n),Tn.isEmpty(e.get(6,t))&&e.setNumber(6,t,n)}}static embedDarkDotAtLeftBottomCorner(e){if(0===e.get(8,e.getHeight()-8))throw new kn;e.setNumber(8,e.getHeight()-8,1)}static embedHorizontalSeparationPattern(e,t,n){for(let r=0;r<8;++r){if(!Tn.isEmpty(n.get(e+r,t)))throw new kn;n.setNumber(e+r,t,0)}}static embedVerticalSeparationPattern(e,t,n){for(let r=0;r<7;++r){if(!Tn.isEmpty(n.get(e,t+r)))throw new kn;n.setNumber(e,t+r,0)}}static embedPositionAdjustmentPattern(e,t,n){for(let r=0;r<5;++r){const s=Tn.POSITION_ADJUSTMENT_PATTERN[r];for(let a=0;a<5;++a)n.setNumber(e+a,t+r,s[a])}}static embedPositionDetectionPattern(e,t,n){for(let r=0;r<7;++r){const s=Tn.POSITION_DETECTION_PATTERN[r];for(let a=0;a<7;++a)n.setNumber(e+a,t+r,s[a])}}static embedPositionDetectionPatternsAndSeparators(e){const t=Tn.POSITION_DETECTION_PATTERN[0].length;Tn.embedPositionDetectionPattern(0,0,e),Tn.embedPositionDetectionPattern(e.getWidth()-t,0,e),Tn.embedPositionDetectionPattern(0,e.getWidth()-t,e);const n=8;Tn.embedHorizontalSeparationPattern(0,n-1,e),Tn.embedHorizontalSeparationPattern(e.getWidth()-n,n-1,e),Tn.embedHorizontalSeparationPattern(0,e.getWidth()-n,e);const r=7;Tn.embedVerticalSeparationPattern(r,0,e),Tn.embedVerticalSeparationPattern(e.getHeight()-r-1,0,e),Tn.embedVerticalSeparationPattern(r,e.getHeight()-r,e)}static maybeEmbedPositionAdjustmentPatterns(e,t){if(e.getVersionNumber()<2)return;const n=e.getVersionNumber()-1,r=Tn.POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n];for(let s=0,a=r.length;s!==a;s++){const e=r[s];if(e>=0)for(let n=0;n!==a;n++){const s=r[n];s>=0&&Tn.isEmpty(t.get(s,e))&&Tn.embedPositionAdjustmentPattern(s-2,e-2,t)}}}}Tn.POSITION_DETECTION_PATTERN=Array.from([Int32Array.from([1,1,1,1,1,1,1]),Int32Array.from([1,0,0,0,0,0,1]),Int32Array.from([1,0,1,1,1,0,1]),Int32Array.from([1,0,1,1,1,0,1]),Int32Array.from([1,0,1,1,1,0,1]),Int32Array.from([1,0,0,0,0,0,1]),Int32Array.from([1,1,1,1,1,1,1])]),Tn.POSITION_ADJUSTMENT_PATTERN=Array.from([Int32Array.from([1,1,1,1,1]),Int32Array.from([1,0,0,0,1]),Int32Array.from([1,0,1,0,1]),Int32Array.from([1,0,0,0,1]),Int32Array.from([1,1,1,1,1])]),Tn.POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE=Array.from([Int32Array.from([-1,-1,-1,-1,-1,-1,-1]),Int32Array.from([6,18,-1,-1,-1,-1,-1]),Int32Array.from([6,22,-1,-1,-1,-1,-1]),Int32Array.from([6,26,-1,-1,-1,-1,-1]),Int32Array.from([6,30,-1,-1,-1,-1,-1]),Int32Array.from([6,34,-1,-1,-1,-1,-1]),Int32Array.from([6,22,38,-1,-1,-1,-1]),Int32Array.from([6,24,42,-1,-1,-1,-1]),Int32Array.from([6,26,46,-1,-1,-1,-1]),Int32Array.from([6,28,50,-1,-1,-1,-1]),Int32Array.from([6,30,54,-1,-1,-1,-1]),Int32Array.from([6,32,58,-1,-1,-1,-1]),Int32Array.from([6,34,62,-1,-1,-1,-1]),Int32Array.from([6,26,46,66,-1,-1,-1]),Int32Array.from([6,26,48,70,-1,-1,-1]),Int32Array.from([6,26,50,74,-1,-1,-1]),Int32Array.from([6,30,54,78,-1,-1,-1]),Int32Array.from([6,30,56,82,-1,-1,-1]),Int32Array.from([6,30,58,86,-1,-1,-1]),Int32Array.from([6,34,62,90,-1,-1,-1]),Int32Array.from([6,28,50,72,94,-1,-1]),Int32Array.from([6,26,50,74,98,-1,-1]),Int32Array.from([6,30,54,78,102,-1,-1]),Int32Array.from([6,28,54,80,106,-1,-1]),Int32Array.from([6,32,58,84,110,-1,-1]),Int32Array.from([6,30,58,86,114,-1,-1]),Int32Array.from([6,34,62,90,118,-1,-1]),Int32Array.from([6,26,50,74,98,122,-1]),Int32Array.from([6,30,54,78,102,126,-1]),Int32Array.from([6,26,52,78,104,130,-1]),Int32Array.from([6,30,56,82,108,134,-1]),Int32Array.from([6,34,60,86,112,138,-1]),Int32Array.from([6,30,58,86,114,142,-1]),Int32Array.from([6,34,62,90,118,146,-1]),Int32Array.from([6,30,54,78,102,126,150]),Int32Array.from([6,24,50,76,102,128,154]),Int32Array.from([6,28,54,80,106,132,158]),Int32Array.from([6,32,58,84,110,136,162]),Int32Array.from([6,26,54,82,110,138,166]),Int32Array.from([6,30,58,86,114,142,170])]),Tn.TYPE_INFO_COORDINATES=Array.from([Int32Array.from([8,0]),Int32Array.from([8,1]),Int32Array.from([8,2]),Int32Array.from([8,3]),Int32Array.from([8,4]),Int32Array.from([8,5]),Int32Array.from([8,7]),Int32Array.from([8,8]),Int32Array.from([7,8]),Int32Array.from([5,8]),Int32Array.from([4,8]),Int32Array.from([3,8]),Int32Array.from([2,8]),Int32Array.from([1,8]),Int32Array.from([0,8])]),Tn.VERSION_INFO_POLY=7973,Tn.TYPE_INFO_POLY=1335,Tn.TYPE_INFO_MASK_PATTERN=21522;class In{constructor(e,t){this.dataBytes=e,this.errorCorrectionBytes=t}getDataBytes(){return this.dataBytes}getErrorCorrectionBytes(){return this.errorCorrectionBytes}}class _n{constructor(){}static calculateMaskPenalty(e){return Cn.applyMaskPenaltyRule1(e)+Cn.applyMaskPenaltyRule2(e)+Cn.applyMaskPenaltyRule3(e)+Cn.applyMaskPenaltyRule4(e)}static encode(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,r=_n.DEFAULT_BYTE_MODE_ENCODING;const s=null!==n&&void 0!==n.get(xn.CHARACTER_SET);s&&(r=n.get(xn.CHARACTER_SET).toString());const a=this.chooseMode(e,r),i=new A;if(a===It.BYTE&&(s||_n.DEFAULT_BYTE_MODE_ENCODING!==r)){const e=C.getCharacterSetECIByName(r);void 0!==e&&this.appendECI(e,i)}this.appendModeInfo(a,i);const o=new A;let l;if(this.appendBytes(e,a,o,r),null!==n&&void 0!==n.get(xn.QR_VERSION)){const e=Number.parseInt(n.get(xn.QR_VERSION).toString(),10);l=Et.getVersionForNumber(e);const r=this.calculateBitsNeeded(a,i,o,l);if(!this.willFit(r,l,t))throw new kn("Data too big for requested version")}else l=this.recommendVersion(t,a,i,o);const c=new A;c.appendBitArray(i);const u=a===It.BYTE?o.getSizeInBytes():e.length;this.appendLengthInfo(u,l,a,c),c.appendBitArray(o);const d=l.getECBlocksForLevel(t),h=l.getTotalCodewords()-d.getTotalECCodewords();this.terminateBits(h,c);const f=this.interleaveWithECBytes(c,l.getTotalCodewords(),h,d.getNumBlocks()),p=new Nn;p.setECLevel(t),p.setMode(a),p.setVersion(l);const m=l.getDimensionForVersion(),g=new En(m,m),y=this.chooseMaskPattern(f,t,l,g);return p.setMaskPattern(y),Tn.buildMatrix(f,t,l,y,g),p.setMatrix(g),p}static recommendVersion(e,t,n,r){const s=this.calculateBitsNeeded(t,n,r,Et.getVersionForNumber(1)),a=this.chooseVersion(s,e),i=this.calculateBitsNeeded(t,n,r,a);return this.chooseVersion(i,e)}static calculateBitsNeeded(e,t,n,r){return t.getSize()+e.getCharacterCountBits(r)+n.getSize()}static getAlphanumericCode(e){return e<_n.ALPHANUMERIC_TABLE.length?_n.ALPHANUMERIC_TABLE[e]:-1}static chooseMode(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;if(C.SJIS.getName()===t&&this.isOnlyDoubleByteKanji(e))return It.KANJI;let n=!1,r=!1;for(let s=0,a=e.length;s<a;++s){const t=e.charAt(s);if(_n.isDigit(t))n=!0;else{if(-1===this.getAlphanumericCode(t.charCodeAt(0)))return It.BYTE;r=!0}}return r?It.ALPHANUMERIC:n?It.NUMERIC:It.BYTE}static isOnlyDoubleByteKanji(e){let t;try{t=N.encode(e,C.SJIS)}catch(r){return!1}const n=t.length;if(n%2!==0)return!1;for(let s=0;s<n;s+=2){const e=255&t[s];if((e<129||e>159)&&(e<224||e>235))return!1}return!0}static chooseMaskPattern(e,t,n,r){let s=Number.MAX_SAFE_INTEGER,a=-1;for(let i=0;i<Nn.NUM_MASK_PATTERNS;i++){Tn.buildMatrix(e,t,n,i,r);let o=this.calculateMaskPenalty(r);o<s&&(s=o,a=i)}return a}static chooseVersion(e,t){for(let n=1;n<=40;n++){const r=Et.getVersionForNumber(n);if(_n.willFit(e,r,t))return r}throw new kn("Data too big")}static willFit(e,t,n){return t.getTotalCodewords()-t.getECBlocksForLevel(n).getTotalECCodewords()>=(e+7)/8}static terminateBits(e,t){const n=8*e;if(t.getSize()>n)throw new kn("data bits cannot fit in the QR Code"+t.getSize()+" > "+n);for(let a=0;a<4&&t.getSize()<n;++a)t.appendBit(!1);const r=7&t.getSize();if(r>0)for(let a=r;a<8;a++)t.appendBit(!1);const s=e-t.getSizeInBytes();for(let a=0;a<s;++a)t.appendBits(0===(1&a)?236:17,8);if(t.getSize()!==n)throw new kn("Bits size does not equal capacity")}static getNumDataBytesAndNumECBytesForBlockID(e,t,n,r,s,a){if(r>=n)throw new kn("Block ID too large");const i=e%n,o=n-i,l=Math.floor(e/n),c=l+1,u=Math.floor(t/n),d=u+1,h=l-u,f=c-d;if(h!==f)throw new kn("EC bytes mismatch");if(n!==o+i)throw new kn("RS blocks mismatch");if(e!==(u+h)*o+(d+f)*i)throw new kn("Total bytes mismatch");r<o?(s[0]=u,a[0]=h):(s[0]=d,a[0]=f)}static interleaveWithECBytes(e,t,n,r){if(e.getSizeInBytes()!==n)throw new kn("Number of bits and data bytes does not match");let s=0,a=0,i=0;const o=new Array;for(let c=0;c<r;++c){const l=new Int32Array(1),u=new Int32Array(1);_n.getNumDataBytesAndNumECBytesForBlockID(t,n,r,c,l,u);const d=l[0],h=new Uint8Array(d);e.toBytes(8*s,h,0,d);const f=_n.generateECBytes(h,u[0]);o.push(new In(h,f)),a=Math.max(a,d),i=Math.max(i,f.length),s+=l[0]}if(n!==s)throw new kn("Data bytes does not match offset");const l=new A;for(let c=0;c<a;++c)for(const e of o){const t=e.getDataBytes();c<t.length&&l.appendBits(t[c],8)}for(let c=0;c<i;++c)for(const e of o){const t=e.getErrorCorrectionBytes();c<t.length&&l.appendBits(t[c],8)}if(t!==l.getSizeInBytes())throw new kn("Interleaving error: "+t+" and "+l.getSizeInBytes()+" differ.");return l}static generateECBytes(e,t){const n=e.length,r=new Int32Array(n+t);for(let a=0;a<n;a++)r[a]=255&e[a];new Sn(ee.QR_CODE_FIELD_256).encode(r,t);const s=new Uint8Array(t);for(let a=0;a<t;a++)s[a]=r[n+a];return s}static appendModeInfo(e,t){t.appendBits(e.getBits(),4)}static appendLengthInfo(e,t,n,r){const s=n.getCharacterCountBits(t);if(e>=1<<s)throw new kn(e+" is bigger than "+((1<<s)-1));r.appendBits(e,s)}static appendBytes(e,t,n,r){switch(t){case It.NUMERIC:_n.appendNumericBytes(e,n);break;case It.ALPHANUMERIC:_n.appendAlphanumericBytes(e,n);break;case It.BYTE:_n.append8BitBytes(e,n,r);break;case It.KANJI:_n.appendKanjiBytes(e,n);break;default:throw new kn("Invalid mode: "+t)}}static getDigit(e){return e.charCodeAt(0)-48}static isDigit(e){const t=_n.getDigit(e);return t>=0&&t<=9}static appendNumericBytes(e,t){const n=e.length;let r=0;for(;r<n;){const s=_n.getDigit(e.charAt(r));if(r+2<n){const n=_n.getDigit(e.charAt(r+1)),a=_n.getDigit(e.charAt(r+2));t.appendBits(100*s+10*n+a,10),r+=3}else if(r+1<n){const n=_n.getDigit(e.charAt(r+1));t.appendBits(10*s+n,7),r+=2}else t.appendBits(s,4),r++}}static appendAlphanumericBytes(e,t){const n=e.length;let r=0;for(;r<n;){const s=_n.getAlphanumericCode(e.charCodeAt(r));if(-1===s)throw new kn;if(r+1<n){const n=_n.getAlphanumericCode(e.charCodeAt(r+1));if(-1===n)throw new kn;t.appendBits(45*s+n,11),r+=2}else t.appendBits(s,6),r++}}static append8BitBytes(e,t,n){let r;try{r=N.encode(e,n)}catch(s){throw new kn(s)}for(let a=0,i=r.length;a!==i;a++){const e=r[a];t.appendBits(e,8)}}static appendKanjiBytes(e,t){let n;try{n=N.encode(e,C.SJIS)}catch(s){throw new kn(s)}const r=n.length;for(let a=0;a<r;a+=2){const e=(255&n[a])<<8&4294967295|255&n[a+1];let r=-1;if(e>=33088&&e<=40956?r=e-33088:e>=57408&&e<=60351&&(r=e-49472),-1===r)throw new kn("Invalid byte sequence");const s=192*(r>>8)+(255&r);t.appendBits(s,13)}}static appendECI(e,t){t.appendBits(It.ECI.getBits(),4),t.appendBits(e.getValue(),8)}}_n.ALPHANUMERIC_TABLE=Int32Array.from([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,36,-1,-1,-1,37,38,-1,-1,-1,-1,39,40,-1,41,42,43,0,1,2,3,4,5,6,7,8,9,44,-1,-1,-1,-1,-1,-1,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,-1,-1,-1,-1,-1]),_n.DEFAULT_BYTE_MODE_ENCODING=C.UTF8.getName();class Rn{write(e,t,n){let r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null;if(0===e.length)throw new d("Found empty contents");if(t<0||n<0)throw new d("Requested dimensions are too small: "+t+"x"+n);let s=bt.L,a=Rn.QUIET_ZONE_SIZE;null!==r&&(void 0!==r.get(xn.ERROR_CORRECTION)&&(s=bt.fromString(r.get(xn.ERROR_CORRECTION).toString())),void 0!==r.get(xn.MARGIN)&&(a=Number.parseInt(r.get(xn.MARGIN).toString(),10)));const i=_n.encode(e,s,r);return this.renderResult(i,t,n,a)}writeToDom(e,t,n,r){let s=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null;"string"===typeof e&&(e=document.querySelector(e));const a=this.write(t,n,r,s);e&&e.appendChild(a)}renderResult(e,t,n,r){const s=e.getMatrix();if(null===s)throw new ne;const a=s.getWidth(),i=s.getHeight(),o=a+2*r,l=i+2*r,c=Math.max(t,o),u=Math.max(n,l),d=Math.min(Math.floor(c/o),Math.floor(u/l)),h=Math.floor((c-a*d)/2),f=Math.floor((u-i*d)/2),p=this.createSVGElement(c,u);for(let m=0,g=f;m<i;m++,g+=d)for(let e=0,t=h;e<a;e++,t+=d)if(1===s.get(e,m)){const e=this.createSvgRectElement(t,g,d,d);p.appendChild(e)}return p}createSVGElement(e,t){const n=document.createElementNS(Rn.SVG_NS,"svg");return n.setAttributeNS(null,"height",e.toString()),n.setAttributeNS(null,"width",t.toString()),n}createSvgRectElement(e,t,n,r){const s=document.createElementNS(Rn.SVG_NS,"rect");return s.setAttributeNS(null,"x",e.toString()),s.setAttributeNS(null,"y",t.toString()),s.setAttributeNS(null,"height",n.toString()),s.setAttributeNS(null,"width",r.toString()),s.setAttributeNS(null,"fill","#000000"),s}}Rn.QUIET_ZONE_SIZE=4,Rn.SVG_NS="http://www.w3.org/2000/svg";class Mn{encode(e,t,n,r,s){if(0===e.length)throw new d("Found empty contents");if(t!==z.QR_CODE)throw new d("Can only encode QR_CODE, but got "+t);if(n<0||r<0)throw new d("Requested dimensions are too small: ".concat(n,"x").concat(r));let a=bt.L,i=Mn.QUIET_ZONE_SIZE;null!==s&&(void 0!==s.get(xn.ERROR_CORRECTION)&&(a=bt.fromString(s.get(xn.ERROR_CORRECTION).toString())),void 0!==s.get(xn.MARGIN)&&(i=Number.parseInt(s.get(xn.MARGIN).toString(),10)));const o=_n.encode(e,a,s);return Mn.renderResult(o,n,r,i)}static renderResult(e,t,n,r){const s=e.getMatrix();if(null===s)throw new ne;const a=s.getWidth(),i=s.getHeight(),o=a+2*r,l=i+2*r,c=Math.max(t,o),u=Math.max(n,l),d=Math.min(Math.floor(c/o),Math.floor(u/l)),h=Math.floor((c-a*d)/2),f=Math.floor((u-i*d)/2),p=new I(c,u);for(let m=0,g=f;m<i;m++,g+=d)for(let e=0,t=h;e<a;e++,t+=d)1===s.get(e,m)&&p.setRegion(t,g,d,d);return p}}Mn.QUIET_ZONE_SIZE=4;class Dn{encode(e,t,n,r,s){let a;if(t!==z.QR_CODE)throw new d("No encoder available for format "+t);return a=new Mn,a.encode(e,t,n,r,s)}}class jn extends D{constructor(e,t,n,r,s,a,i,o){if(super(a,i),this.yuvData=e,this.dataWidth=t,this.dataHeight=n,this.left=r,this.top=s,r+a>t||s+i>n)throw new d("Crop rectangle does not fit within image data.");o&&this.reverseHorizontal(a,i)}getRow(e,t){if(e<0||e>=this.getHeight())throw new d("Requested row is outside the image: "+e);const n=this.getWidth();(null===t||void 0===t||t.length<n)&&(t=new Uint8ClampedArray(n));const r=(e+this.top)*this.dataWidth+this.left;return m.arraycopy(this.yuvData,r,t,0,n),t}getMatrix(){const e=this.getWidth(),t=this.getHeight();if(e===this.dataWidth&&t===this.dataHeight)return this.yuvData;const n=e*t,r=new Uint8ClampedArray(n);let s=this.top*this.dataWidth+this.left;if(e===this.dataWidth)return m.arraycopy(this.yuvData,s,r,0,n),r;for(let a=0;a<t;a++){const t=a*e;m.arraycopy(this.yuvData,s,r,t,e),s+=this.dataWidth}return r}isCropSupported(){return!0}crop(e,t,n,r){return new jn(this.yuvData,this.dataWidth,this.dataHeight,this.left+e,this.top+t,n,r,!1)}renderThumbnail(){const e=this.getWidth()/jn.THUMBNAIL_SCALE_FACTOR,t=this.getHeight()/jn.THUMBNAIL_SCALE_FACTOR,n=new Int32Array(e*t),r=this.yuvData;let s=this.top*this.dataWidth+this.left;for(let a=0;a<t;a++){const t=a*e;for(let a=0;a<e;a++){const e=255&r[s+a*jn.THUMBNAIL_SCALE_FACTOR];n[t+a]=4278190080|65793*e}s+=this.dataWidth*jn.THUMBNAIL_SCALE_FACTOR}return n}getThumbnailWidth(){return this.getWidth()/jn.THUMBNAIL_SCALE_FACTOR}getThumbnailHeight(){return this.getHeight()/jn.THUMBNAIL_SCALE_FACTOR}reverseHorizontal(e,t){const n=this.yuvData;for(let r=0,s=this.top*this.dataWidth+this.left;r<t;r++,s+=this.dataWidth){const t=s+e/2;for(let r=s,a=s+e-1;r<t;r++,a--){const e=n[r];n[r]=n[a],n[a]=e}}}invert(){return new j(this)}}jn.THUMBNAIL_SCALE_FACTOR=2;class On extends D{constructor(e,t,n,r,s,a,i){if(super(t,n),this.dataWidth=r,this.dataHeight=s,this.left=a,this.top=i,4===e.BYTES_PER_ELEMENT){const r=t*n,s=new Uint8ClampedArray(r);for(let t=0;t<r;t++){const n=e[t],r=n>>16&255,a=n>>7&510,i=255&n;s[t]=(r+a+i)/4&255}this.luminances=s}else this.luminances=e;if(void 0===r&&(this.dataWidth=t),void 0===s&&(this.dataHeight=n),void 0===a&&(this.left=0),void 0===i&&(this.top=0),this.left+t>this.dataWidth||this.top+n>this.dataHeight)throw new d("Crop rectangle does not fit within image data.")}getRow(e,t){if(e<0||e>=this.getHeight())throw new d("Requested row is outside the image: "+e);const n=this.getWidth();(null===t||void 0===t||t.length<n)&&(t=new Uint8ClampedArray(n));const r=(e+this.top)*this.dataWidth+this.left;return m.arraycopy(this.luminances,r,t,0,n),t}getMatrix(){const e=this.getWidth(),t=this.getHeight();if(e===this.dataWidth&&t===this.dataHeight)return this.luminances;const n=e*t,r=new Uint8ClampedArray(n);let s=this.top*this.dataWidth+this.left;if(e===this.dataWidth)return m.arraycopy(this.luminances,s,r,0,n),r;for(let a=0;a<t;a++){const t=a*e;m.arraycopy(this.luminances,s,r,t,e),s+=this.dataWidth}return r}isCropSupported(){return!0}crop(e,t,n,r){return new On(this.luminances,n,r,this.dataWidth,this.dataHeight,this.left+e,this.top+t)}invert(){return new j(this)}}class Pn extends C{static forName(e){return this.getCharacterSetECIByName(e)}}class Ln{}Ln.ISO_8859_1=C.ISO8859_1;class Bn{isCompact(){return this.compact}setCompact(e){this.compact=e}getSize(){return this.size}setSize(e){this.size=e}getLayers(){return this.layers}setLayers(e){this.layers=e}getCodeWords(){return this.codeWords}setCodeWords(e){this.codeWords=e}getMatrix(){return this.matrix}setMatrix(e){this.matrix=e}}class Fn{static singletonList(e){return[e]}static min(e,t){return e.sort(t)[0]}}class Un{constructor(e){this.previous=e}getPrevious(){return this.previous}}class Wn extends Un{constructor(e,t,n){super(e),this.value=t,this.bitCount=n}appendTo(e,t){e.appendBits(this.value,this.bitCount)}add(e,t){return new Wn(this,e,t)}addBinaryShift(e,t){return console.warn("addBinaryShift on SimpleToken, this simply returns a copy of this token"),new Wn(this,e,t)}toString(){let e=this.value&(1<<this.bitCount)-1;return e|=1<<this.bitCount,"<"+v.toBinaryString(e|1<<this.bitCount).substring(1)+">"}}class zn extends Wn{constructor(e,t,n){super(e,0,0),this.binaryShiftStart=t,this.binaryShiftByteCount=n}appendTo(e,t){for(let n=0;n<this.binaryShiftByteCount;n++)(0===n||31===n&&this.binaryShiftByteCount<=62)&&(e.appendBits(31,5),this.binaryShiftByteCount>62?e.appendBits(this.binaryShiftByteCount-31,16):0===n?e.appendBits(Math.min(this.binaryShiftByteCount,31),5):e.appendBits(this.binaryShiftByteCount-31,5)),e.appendBits(t[this.binaryShiftStart+n],8)}addBinaryShift(e,t){return new zn(this,e,t)}toString(){return"<"+this.binaryShiftStart+"::"+(this.binaryShiftStart+this.binaryShiftByteCount-1)+">"}}function Hn(e,t,n){return new zn(e,t,n)}function Vn(e,t,n){return new Wn(e,t,n)}const Gn=["UPPER","LOWER","DIGIT","MIXED","PUNCT"],Jn=0,Qn=1,Kn=2,Yn=3,qn=4,Xn=new Wn(null,0,0),Zn=[Int32Array.from([0,327708,327710,327709,656318]),Int32Array.from([590318,0,327710,327709,656318]),Int32Array.from([262158,590300,0,590301,932798]),Int32Array.from([327709,327708,656318,0,327710]),Int32Array.from([327711,656380,656382,656381,0])];function $n(e){for(let t of e)w.fill(t,-1);return e[Jn][qn]=0,e[Qn][qn]=0,e[Qn][Jn]=28,e[Yn][qn]=0,e[Kn][qn]=0,e[Kn][Jn]=15,e}const er=$n(w.createInt32Array(6,6));class tr{constructor(e,t,n,r){this.token=e,this.mode=t,this.binaryShiftByteCount=n,this.bitCount=r}getMode(){return this.mode}getToken(){return this.token}getBinaryShiftByteCount(){return this.binaryShiftByteCount}getBitCount(){return this.bitCount}latchAndAppend(e,t){let n=this.bitCount,r=this.token;if(e!==this.mode){let t=Zn[this.mode][e];r=Vn(r,65535&t,t>>16),n+=t>>16}let s=e===Kn?4:5;return r=Vn(r,t,s),new tr(r,e,0,n+s)}shiftAndAppend(e,t){let n=this.token,r=this.mode===Kn?4:5;return n=Vn(n,er[this.mode][e],r),n=Vn(n,t,5),new tr(n,this.mode,0,this.bitCount+r+5)}addBinaryShiftChar(e){let t=this.token,n=this.mode,r=this.bitCount;if(this.mode===qn||this.mode===Kn){let e=Zn[n][Jn];t=Vn(t,65535&e,e>>16),r+=e>>16,n=Jn}let s=0===this.binaryShiftByteCount||31===this.binaryShiftByteCount?18:62===this.binaryShiftByteCount?9:8,a=new tr(t,n,this.binaryShiftByteCount+1,r+s);return 2078===a.binaryShiftByteCount&&(a=a.endBinaryShift(e+1)),a}endBinaryShift(e){if(0===this.binaryShiftByteCount)return this;let t=this.token;return t=Hn(t,e-this.binaryShiftByteCount,this.binaryShiftByteCount),new tr(t,this.mode,0,this.bitCount)}isBetterThanOrEqualTo(e){let t=this.bitCount+(Zn[this.mode][e.mode]>>16);return this.binaryShiftByteCount<e.binaryShiftByteCount?t+=tr.calculateBinaryShiftCost(e)-tr.calculateBinaryShiftCost(this):this.binaryShiftByteCount>e.binaryShiftByteCount&&e.binaryShiftByteCount>0&&(t+=10),t<=e.bitCount}toBitArray(e){let t=[];for(let r=this.endBinaryShift(e.length).token;null!==r;r=r.getPrevious())t.unshift(r);let n=new A;for(const r of t)r.appendTo(n,e);return n}toString(){return k.format("%s bits=%d bytes=%d",Gn[this.mode],this.bitCount,this.binaryShiftByteCount)}static calculateBinaryShiftCost(e){return e.binaryShiftByteCount>62?21:e.binaryShiftByteCount>31?20:e.binaryShiftByteCount>0?10:0}}function nr(e){const t=k.getCharCode(" "),n=k.getCharCode("."),r=k.getCharCode(",");e[Jn][t]=1;const s=k.getCharCode("Z"),a=k.getCharCode("A");for(let h=a;h<=s;h++)e[Jn][h]=h-a+2;e[Qn][t]=1;const i=k.getCharCode("z"),o=k.getCharCode("a");for(let h=o;h<=i;h++)e[Qn][h]=h-o+2;e[Kn][t]=1;const l=k.getCharCode("9"),c=k.getCharCode("0");for(let h=c;h<=l;h++)e[Kn][h]=h-c+2;e[Kn][r]=12,e[Kn][n]=13;const u=["\0"," ","\x01","\x02","\x03","\x04","\x05","\x06","\x07","\b","\t","\n","\v","\f","\r","\x1b","\x1c","\x1d","\x1e","\x1f","@","\\","^","_","`","|","~","\x7f"];for(let h=0;h<u.length;h++)e[Yn][k.getCharCode(u[h])]=h;const d=["\0","\r","\0","\0","\0","\0","!","'","#","$","%","&","'","(",")","*","+",",","-",".","/",":",";","<","=",">","?","[","]","{","}"];for(let h=0;h<d.length;h++)k.getCharCode(d[h])>0&&(e[qn][k.getCharCode(d[h])]=h);return e}tr.INITIAL_STATE=new tr(Xn,Jn,0,0);const rr=nr(w.createInt32Array(5,256));class sr{constructor(e){this.text=e}encode(){const e=k.getCharCode(" "),t=k.getCharCode("\n");let n=Fn.singletonList(tr.INITIAL_STATE);for(let r=0;r<this.text.length;r++){let s,a=r+1<this.text.length?this.text[r+1]:0;switch(this.text[r]){case k.getCharCode("\r"):s=a===t?2:0;break;case k.getCharCode("."):s=a===e?3:0;break;case k.getCharCode(","):s=a===e?4:0;break;case k.getCharCode(":"):s=a===e?5:0;break;default:s=0}s>0?(n=sr.updateStateListForPair(n,r,s),r++):n=this.updateStateListForChar(n,r)}return Fn.min(n,(e,t)=>e.getBitCount()-t.getBitCount()).toBitArray(this.text)}updateStateListForChar(e,t){const n=[];for(let r of e)this.updateStateForChar(r,t,n);return sr.simplifyStates(n)}updateStateForChar(e,t,n){let r=255&this.text[t],s=rr[e.getMode()][r]>0,a=null;for(let i=0;i<=qn;i++){let o=rr[i][r];if(o>0){if(null==a&&(a=e.endBinaryShift(t)),!s||i===e.getMode()||i===Kn){const e=a.latchAndAppend(i,o);n.push(e)}if(!s&&er[e.getMode()][i]>=0){const e=a.shiftAndAppend(i,o);n.push(e)}}}if(e.getBinaryShiftByteCount()>0||0===rr[e.getMode()][r]){let r=e.addBinaryShiftChar(t);n.push(r)}}static updateStateListForPair(e,t,n){const r=[];for(let s of e)this.updateStateForPair(s,t,n,r);return this.simplifyStates(r)}static updateStateForPair(e,t,n,r){let s=e.endBinaryShift(t);if(r.push(s.latchAndAppend(qn,n)),e.getMode()!==qn&&r.push(s.shiftAndAppend(qn,n)),3===n||4===n){let e=s.latchAndAppend(Kn,16-n).latchAndAppend(Kn,1);r.push(e)}if(e.getBinaryShiftByteCount()>0){let n=e.addBinaryShiftChar(t).addBinaryShiftChar(t+1);r.push(n)}}static simplifyStates(e){let t=[];for(const n of e){let e=!0;for(const r of t){if(r.isBetterThanOrEqualTo(n)){e=!1;break}n.isBetterThanOrEqualTo(r)&&(t=t.filter(e=>e!==r))}e&&t.push(n)}return t}}class ar{constructor(){}static encodeBytes(e){return ar.encode(e,ar.DEFAULT_EC_PERCENT,ar.DEFAULT_AZTEC_LAYERS)}static encode(e,t,n){let r,s,a,i,o,l=new sr(e).encode(),c=v.truncDivision(l.getSize()*t,100)+11,u=l.getSize()+c;if(n!==ar.DEFAULT_AZTEC_LAYERS){if(r=n<0,s=Math.abs(n),s>(r?ar.MAX_NB_BITS_COMPACT:ar.MAX_NB_BITS))throw new d(k.format("Illegal value %s for layers",n));a=ar.totalBitsInLayer(s,r),i=ar.WORD_SIZE[s];let e=a-a%i;if(o=ar.stuffBits(l,i),o.getSize()+c>e)throw new d("Data to large for user specified layer");if(r&&o.getSize()>64*i)throw new d("Data to large for user specified layer")}else{i=0,o=null;for(let e=0;;e++){if(e>ar.MAX_NB_BITS)throw new d("Data too large for an Aztec code");if(r=e<=3,s=r?e+1:e,a=ar.totalBitsInLayer(s,r),u>a)continue;null!=o&&i===ar.WORD_SIZE[s]||(i=ar.WORD_SIZE[s],o=ar.stuffBits(l,i));let t=a-a%i;if(!(r&&o.getSize()>64*i)&&o.getSize()+c<=t)break}}let h,f=ar.generateCheckWords(o,a,i),p=o.getSize()/i,m=ar.generateModeMessage(r,s,p),g=(r?11:14)+4*s,y=new Int32Array(g);if(r){h=g;for(let e=0;e<y.length;e++)y[e]=e}else{h=g+1+2*v.truncDivision(v.truncDivision(g,2)-1,15);let e=v.truncDivision(g,2),t=v.truncDivision(h,2);for(let n=0;n<e;n++){let r=n+v.truncDivision(n,15);y[e-n-1]=t-r-1,y[e+n]=t+r+1}}let w=new I(h);for(let d=0,v=0;d<s;d++){let e=4*(s-d)+(r?9:12);for(let t=0;t<e;t++){let n=2*t;for(let r=0;r<2;r++)f.get(v+n+r)&&w.set(y[2*d+r],y[2*d+t]),f.get(v+2*e+n+r)&&w.set(y[2*d+t],y[g-1-2*d-r]),f.get(v+4*e+n+r)&&w.set(y[g-1-2*d-r],y[g-1-2*d-t]),f.get(v+6*e+n+r)&&w.set(y[g-1-2*d-t],y[2*d+r])}v+=8*e}if(ar.drawModeMessage(w,r,h,m),r)ar.drawBullsEye(w,v.truncDivision(h,2),5);else{ar.drawBullsEye(w,v.truncDivision(h,2),7);for(let e=0,t=0;e<v.truncDivision(g,2)-1;e+=15,t+=16)for(let n=1&v.truncDivision(h,2);n<h;n+=2)w.set(v.truncDivision(h,2)-t,n),w.set(v.truncDivision(h,2)+t,n),w.set(n,v.truncDivision(h,2)-t),w.set(n,v.truncDivision(h,2)+t)}let A=new Bn;return A.setCompact(r),A.setSize(h),A.setLayers(s),A.setCodeWords(p),A.setMatrix(w),A}static drawBullsEye(e,t,n){for(let r=0;r<n;r+=2)for(let n=t-r;n<=t+r;n++)e.set(n,t-r),e.set(n,t+r),e.set(t-r,n),e.set(t+r,n);e.set(t-n,t-n),e.set(t-n+1,t-n),e.set(t-n,t-n+1),e.set(t+n,t-n),e.set(t+n,t-n+1),e.set(t+n,t+n-1)}static generateModeMessage(e,t,n){let r=new A;return e?(r.appendBits(t-1,2),r.appendBits(n-1,6),r=ar.generateCheckWords(r,28,4)):(r.appendBits(t-1,5),r.appendBits(n-1,11),r=ar.generateCheckWords(r,40,4)),r}static drawModeMessage(e,t,n,r){let s=v.truncDivision(n,2);if(t)for(let a=0;a<7;a++){let t=s-3+a;r.get(a)&&e.set(t,s-5),r.get(a+7)&&e.set(s+5,t),r.get(20-a)&&e.set(t,s+5),r.get(27-a)&&e.set(s-5,t)}else for(let a=0;a<10;a++){let t=s-5+a+v.truncDivision(a,5);r.get(a)&&e.set(t,s-7),r.get(a+10)&&e.set(s+7,t),r.get(29-a)&&e.set(t,s+7),r.get(39-a)&&e.set(s-7,t)}}static generateCheckWords(e,t,n){let r=e.getSize()/n,s=new Sn(ar.getGF(n)),a=v.truncDivision(t,n),i=ar.bitsToWords(e,n,a);s.encode(i,a-r);let o=t%n,l=new A;l.appendBits(0,o);for(const c of Array.from(i))l.appendBits(c,n);return l}static bitsToWords(e,t,n){let r,s,a=new Int32Array(n);for(r=0,s=e.getSize()/t;r<s;r++){let n=0;for(let s=0;s<t;s++)n|=e.get(r*t+s)?1<<t-s-1:0;a[r]=n}return a}static getGF(e){switch(e){case 4:return ee.AZTEC_PARAM;case 6:return ee.AZTEC_DATA_6;case 8:return ee.AZTEC_DATA_8;case 10:return ee.AZTEC_DATA_10;case 12:return ee.AZTEC_DATA_12;default:throw new d("Unsupported word size "+e)}}static stuffBits(e,t){let n=new A,r=e.getSize(),s=(1<<t)-2;for(let a=0;a<r;a+=t){let i=0;for(let n=0;n<t;n++)(a+n>=r||e.get(a+n))&&(i|=1<<t-1-n);(i&s)===s?(n.appendBits(i&s,t),a--):0===(i&s)?(n.appendBits(1|i,t),a--):n.appendBits(i,t)}return n}static totalBitsInLayer(e,t){return((t?88:112)+16*e)*e}}ar.DEFAULT_EC_PERCENT=33,ar.DEFAULT_AZTEC_LAYERS=0,ar.MAX_NB_BITS=32,ar.MAX_NB_BITS_COMPACT=4,ar.WORD_SIZE=Int32Array.from([4,6,6,8,8,8,8,8,8,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12,12,12,12,12,12,12,12]);class ir{encode(e,t,n,r){return this.encodeWithHints(e,t,n,r,null)}encodeWithHints(e,t,n,r,s){let a=Ln.ISO_8859_1,i=ar.DEFAULT_EC_PERCENT,o=ar.DEFAULT_AZTEC_LAYERS;return null!=s&&(s.has(xn.CHARACTER_SET)&&(a=Pn.forName(s.get(xn.CHARACTER_SET).toString())),s.has(xn.ERROR_CORRECTION)&&(i=v.parseInt(s.get(xn.ERROR_CORRECTION).toString())),s.has(xn.AZTEC_LAYERS)&&(o=v.parseInt(s.get(xn.AZTEC_LAYERS).toString()))),ir.encodeLayers(e,t,n,r,a,i,o)}static encodeLayers(e,t,n,r,s,a,i){if(t!==z.AZTEC)throw new d("Can only encode AZTEC, but got "+t);let o=ar.encode(k.getBytes(e,s),a,i);return ir.renderResult(o,n,r)}static renderResult(e,t,n){let r=e.getMatrix();if(null==r)throw new ne;let s=r.getWidth(),a=r.getHeight(),i=Math.max(t,s),o=Math.max(n,a),l=Math.min(i/s,o/a),c=(i-s*l)/2,u=(o-a*l)/2,d=new I(i,o);for(let h=0,f=u;h<a;h++,f+=l)for(let e=0,t=c;e<s;e++,t+=l)r.get(e,h)&&d.setRegion(t,f,l,l);return d}}e.AbstractExpandedDecoder=Ge,e.ArgumentException=u,e.ArithmeticException=$,e.AztecCode=Bn,e.AztecCodeReader=ye,e.AztecCodeWriter=ir,e.AztecDecoder=se,e.AztecDetector=ge,e.AztecDetectorResult=ce,e.AztecEncoder=ar,e.AztecHighLevelEncoder=sr,e.AztecPoint=me,e.BarcodeFormat=z,e.Binarizer=p,e.BinaryBitmap=h,e.BitArray=A,e.BitMatrix=I,e.BitSource=mt,e.BrowserAztecCodeReader=we,e.BrowserBarcodeReader=ct,e.BrowserCodeReader=F,e.BrowserDatamatrixCodeReader=At,e.BrowserMultiFormatReader=wn,e.BrowserPDF417Reader=vn,e.BrowserQRCodeReader=An,e.BrowserQRCodeSvgWriter=Rn,e.CharacterSetECI=C,e.ChecksumException=f,e.Code128Reader=Ae,e.Code39Reader=be,e.DataMatrixDecodedBitStreamParser=gt,e.DataMatrixReader=vt,e.DecodeHintType=x,e.DecoderResult=q,e.DefaultGridSampler=fe,e.DetectorResult=le,e.EAN13Reader=Te,e.EncodeHintType=xn,e.Exception=c,e.FormatException=S,e.GenericGF=ee,e.GenericGFPoly=Z,e.GlobalHistogramBinarizer=R,e.GridSampler=de,e.GridSamplerInstance=pe,e.HTMLCanvasElementLuminanceSource=O,e.HybridBinarizer=M,e.ITFReader=xe,e.IllegalArgumentException=d,e.IllegalStateException=ne,e.InvertedLuminanceSource=j,e.LuminanceSource=D,e.MathUtils=ae,e.MultiFormatOneDReader=lt,e.MultiFormatReader=yn,e.MultiFormatWriter=Dn,e.NotFoundException=_,e.OneDReader=ve,e.PDF417DecodedBitStreamParser=fn,e.PDF417DecoderErrorCorrection=Jt,e.PDF417Reader=mn,e.PDF417ResultMetadata=nn,e.PerspectiveTransform=he,e.PlanarYUVLuminanceSource=jn,e.QRCodeByteMatrix=En,e.QRCodeDataMask=Nt,e.QRCodeDecodedBitStreamParser=_t,e.QRCodeDecoderErrorCorrectionLevel=bt,e.QRCodeDecoderFormatInformation=xt,e.QRCodeEncoder=_n,e.QRCodeEncoderQRCode=Nn,e.QRCodeMaskUtil=Cn,e.QRCodeMatrixUtil=Tn,e.QRCodeMode=It,e.QRCodeReader=Ft,e.QRCodeVersion=Et,e.QRCodeWriter=Mn,e.RGBLuminanceSource=On,e.RSS14Reader=ot,e.RSSExpandedReader=at,e.ReaderException=gn,e.ReedSolomonDecoder=re,e.ReedSolomonEncoder=Sn,e.ReedSolomonException=te,e.Result=U,e.ResultMetadataType=Y,e.ResultPoint=oe,e.StringUtils=k,e.UnsupportedOperationException=E,e.VideoInputDevice=P,e.WhiteRectangleDetector=ue,e.WriterException=kn,e.ZXingArrays=w,e.ZXingCharset=Pn,e.ZXingInteger=v,e.ZXingStandardCharsets=Ln,e.ZXingStringBuilder=T,e.ZXingStringEncoding=N,e.ZXingSystem=m,e.createAbstractExpandedDecoder=nt,Object.defineProperty(e,"__esModule",{value:!0})}(t)},1781(e,t,n){const r=n(5399),s=n(375),a=n(4253),i=n(5666);function o(e,t,n,a,i){const o=[].slice.call(arguments,1),l=o.length,c="function"===typeof o[l-1];if(!c&&!r())throw new Error("Callback required as last argument");if(!c){if(l<1)throw new Error("Too few arguments provided");return 1===l?(n=t,t=a=void 0):2!==l||t.getContext||(a=n,n=t,t=void 0),new Promise(function(r,i){try{const i=s.create(n,a);r(e(i,t,a))}catch(o){i(o)}})}if(l<2)throw new Error("Too few arguments provided");2===l?(i=n,n=t,t=a=void 0):3===l&&(t.getContext&&"undefined"===typeof i?(i=a,a=void 0):(i=a,a=n,n=t,t=void 0));try{const r=s.create(n,a);i(null,e(r,t,a))}catch(u){i(u)}}t.create=s.create,t.toCanvas=o.bind(null,a.render),t.toDataURL=o.bind(null,a.renderToDataURL),t.toString=o.bind(null,function(e,t,n){return i.render(e,n)})},5399(e){e.exports=function(){return"function"===typeof Promise&&Promise.prototype&&Promise.prototype.then}},8227(e,t,n){const r=n(7476).getSymbolSize;t.getRowColCoords=function(e){if(1===e)return[];const t=Math.floor(e/7)+2,n=r(e),s=145===n?26:2*Math.ceil((n-13)/(2*t-2)),a=[n-7];for(let r=1;r<t-1;r++)a[r]=a[r-1]-s;return a.push(6),a.reverse()},t.getPositions=function(e){const n=[],r=t.getRowColCoords(e),s=r.length;for(let t=0;t<s;t++)for(let e=0;e<s;e++)0===t&&0===e||0===t&&e===s-1||t===s-1&&0===e||n.push([r[t],r[e]]);return n}},3791(e,t,n){const r=n(8314),s=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"," ","$","%","*","+","-",".","/",":"];function a(e){this.mode=r.ALPHANUMERIC,this.data=e}a.getBitsLength=function(e){return 11*Math.floor(e/2)+e%2*6},a.prototype.getLength=function(){return this.data.length},a.prototype.getBitsLength=function(){return a.getBitsLength(this.data.length)},a.prototype.write=function(e){let t;for(t=0;t+2<=this.data.length;t+=2){let n=45*s.indexOf(this.data[t]);n+=s.indexOf(this.data[t+1]),e.put(n,11)}this.data.length%2&&e.put(s.indexOf(this.data[t]),6)},e.exports=a},9109(e){function t(){this.buffer=[],this.length=0}t.prototype={get:function(e){const t=Math.floor(e/8);return 1===(this.buffer[t]>>>7-e%8&1)},put:function(e,t){for(let n=0;n<t;n++)this.putBit(1===(e>>>t-n-1&1))},getLengthInBits:function(){return this.length},putBit:function(e){const t=Math.floor(this.length/8);this.buffer.length<=t&&this.buffer.push(0),e&&(this.buffer[t]|=128>>>this.length%8),this.length++}},e.exports=t},7802(e){function t(e){if(!e||e<1)throw new Error("BitMatrix size must be defined and greater than 0");this.size=e,this.data=new Uint8Array(e*e),this.reservedBit=new Uint8Array(e*e)}t.prototype.set=function(e,t,n,r){const s=e*this.size+t;this.data[s]=n,r&&(this.reservedBit[s]=!0)},t.prototype.get=function(e,t){return this.data[e*this.size+t]},t.prototype.xor=function(e,t,n){this.data[e*this.size+t]^=n},t.prototype.isReserved=function(e,t){return this.reservedBit[e*this.size+t]},e.exports=t},3452(e,t,n){const r=n(8314);function s(e){this.mode=r.BYTE,this.data="string"===typeof e?(new TextEncoder).encode(e):new Uint8Array(e)}s.getBitsLength=function(e){return 8*e},s.prototype.getLength=function(){return this.data.length},s.prototype.getBitsLength=function(){return s.getBitsLength(this.data.length)},s.prototype.write=function(e){for(let t=0,n=this.data.length;t<n;t++)e.put(this.data[t],8)},e.exports=s},3524(e,t,n){const r=n(4175),s=[1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,4,1,2,4,4,2,4,4,4,2,4,6,5,2,4,6,6,2,5,8,8,4,5,8,8,4,5,8,11,4,8,10,11,4,9,12,16,4,9,16,16,6,10,12,18,6,10,17,16,6,11,16,19,6,13,18,21,7,14,21,25,8,16,20,25,8,17,23,25,9,17,23,34,9,18,25,30,10,20,27,32,12,21,29,35,12,23,34,37,12,25,34,40,13,26,35,42,14,28,38,45,15,29,40,48,16,31,43,51,17,33,45,54,18,35,48,57,19,37,51,60,19,38,53,63,20,40,56,66,21,43,59,70,22,45,62,74,24,47,65,77,25,49,68,81],a=[7,10,13,17,10,16,22,28,15,26,36,44,20,36,52,64,26,48,72,88,36,64,96,112,40,72,108,130,48,88,132,156,60,110,160,192,72,130,192,224,80,150,224,264,96,176,260,308,104,198,288,352,120,216,320,384,132,240,360,432,144,280,408,480,168,308,448,532,180,338,504,588,196,364,546,650,224,416,600,700,224,442,644,750,252,476,690,816,270,504,750,900,300,560,810,960,312,588,870,1050,336,644,952,1110,360,700,1020,1200,390,728,1050,1260,420,784,1140,1350,450,812,1200,1440,480,868,1290,1530,510,924,1350,1620,540,980,1440,1710,570,1036,1530,1800,570,1064,1590,1890,600,1120,1680,1980,630,1204,1770,2100,660,1260,1860,2220,720,1316,1950,2310,750,1372,2040,2430];t.getBlocksCount=function(e,t){switch(t){case r.L:return s[4*(e-1)+0];case r.M:return s[4*(e-1)+1];case r.Q:return s[4*(e-1)+2];case r.H:return s[4*(e-1)+3];default:return}},t.getTotalCodewordsCount=function(e,t){switch(t){case r.L:return a[4*(e-1)+0];case r.M:return a[4*(e-1)+1];case r.Q:return a[4*(e-1)+2];case r.H:return a[4*(e-1)+3];default:return}}},4175(e,t){t.L={bit:1},t.M={bit:0},t.Q={bit:3},t.H={bit:2},t.isValid=function(e){return e&&"undefined"!==typeof e.bit&&e.bit>=0&&e.bit<4},t.from=function(e,n){if(t.isValid(e))return e;try{return function(e){if("string"!==typeof e)throw new Error("Param is not a string");switch(e.toLowerCase()){case"l":case"low":return t.L;case"m":case"medium":return t.M;case"q":case"quartile":return t.Q;case"h":case"high":return t.H;default:throw new Error("Unknown EC Level: "+e)}}(e)}catch(r){return n}}},2958(e,t,n){const r=n(7476).getSymbolSize;t.getPositions=function(e){const t=r(e);return[[0,0],[t-7,0],[0,t-7]]}},1751(e,t,n){const r=n(7476),s=r.getBCHDigit(1335);t.getEncodedBits=function(e,t){const n=e.bit<<3|t;let a=n<<10;for(;r.getBCHDigit(a)-s>=0;)a^=1335<<r.getBCHDigit(a)-s;return 21522^(n<<10|a)}},7545(e,t){const n=new Uint8Array(512),r=new Uint8Array(256);!function(){let e=1;for(let t=0;t<255;t++)n[t]=e,r[e]=t,e<<=1,256&e&&(e^=285);for(let t=255;t<512;t++)n[t]=n[t-255]}(),t.log=function(e){if(e<1)throw new Error("log("+e+")");return r[e]},t.exp=function(e){return n[e]},t.mul=function(e,t){return 0===e||0===t?0:n[r[e]+r[t]]}},1175(e,t,n){const r=n(8314),s=n(7476);function a(e){this.mode=r.KANJI,this.data=e}a.getBitsLength=function(e){return 13*e},a.prototype.getLength=function(){return this.data.length},a.prototype.getBitsLength=function(){return a.getBitsLength(this.data.length)},a.prototype.write=function(e){let t;for(t=0;t<this.data.length;t++){let n=s.toSJIS(this.data[t]);if(n>=33088&&n<=40956)n-=33088;else{if(!(n>=57408&&n<=60351))throw new Error("Invalid SJIS character: "+this.data[t]+"\nMake sure your charset is UTF-8");n-=49472}n=192*(n>>>8&255)+(255&n),e.put(n,13)}},e.exports=a},2378(e,t){t.Patterns={PATTERN000:0,PATTERN001:1,PATTERN010:2,PATTERN011:3,PATTERN100:4,PATTERN101:5,PATTERN110:6,PATTERN111:7};const n=3,r=3,s=40,a=10;function i(e,n,r){switch(e){case t.Patterns.PATTERN000:return(n+r)%2===0;case t.Patterns.PATTERN001:return n%2===0;case t.Patterns.PATTERN010:return r%3===0;case t.Patterns.PATTERN011:return(n+r)%3===0;case t.Patterns.PATTERN100:return(Math.floor(n/2)+Math.floor(r/3))%2===0;case t.Patterns.PATTERN101:return n*r%2+n*r%3===0;case t.Patterns.PATTERN110:return(n*r%2+n*r%3)%2===0;case t.Patterns.PATTERN111:return(n*r%3+(n+r)%2)%2===0;default:throw new Error("bad maskPattern:"+e)}}t.isValid=function(e){return null!=e&&""!==e&&!isNaN(e)&&e>=0&&e<=7},t.from=function(e){return t.isValid(e)?parseInt(e,10):void 0},t.getPenaltyN1=function(e){const t=e.size;let r=0,s=0,a=0,i=null,o=null;for(let l=0;l<t;l++){s=a=0,i=o=null;for(let c=0;c<t;c++){let t=e.get(l,c);t===i?s++:(s>=5&&(r+=n+(s-5)),i=t,s=1),t=e.get(c,l),t===o?a++:(a>=5&&(r+=n+(a-5)),o=t,a=1)}s>=5&&(r+=n+(s-5)),a>=5&&(r+=n+(a-5))}return r},t.getPenaltyN2=function(e){const t=e.size;let n=0;for(let r=0;r<t-1;r++)for(let s=0;s<t-1;s++){const t=e.get(r,s)+e.get(r,s+1)+e.get(r+1,s)+e.get(r+1,s+1);4!==t&&0!==t||n++}return n*r},t.getPenaltyN3=function(e){const t=e.size;let n=0,r=0,a=0;for(let s=0;s<t;s++){r=a=0;for(let i=0;i<t;i++)r=r<<1&2047|e.get(s,i),i>=10&&(1488===r||93===r)&&n++,a=a<<1&2047|e.get(i,s),i>=10&&(1488===a||93===a)&&n++}return n*s},t.getPenaltyN4=function(e){let t=0;const n=e.data.length;for(let r=0;r<n;r++)t+=e.data[r];return Math.abs(Math.ceil(100*t/n/5)-10)*a},t.applyMask=function(e,t){const n=t.size;for(let r=0;r<n;r++)for(let s=0;s<n;s++)t.isReserved(s,r)||t.xor(s,r,i(e,s,r))},t.getBestMask=function(e,n){const r=Object.keys(t.Patterns).length;let s=0,a=1/0;for(let i=0;i<r;i++){n(i),t.applyMask(i,e);const r=t.getPenaltyN1(e)+t.getPenaltyN2(e)+t.getPenaltyN3(e)+t.getPenaltyN4(e);t.applyMask(i,e),r<a&&(a=r,s=i)}return s}},8314(e,t,n){const r=n(7232),s=n(1270);t.NUMERIC={id:"Numeric",bit:1,ccBits:[10,12,14]},t.ALPHANUMERIC={id:"Alphanumeric",bit:2,ccBits:[9,11,13]},t.BYTE={id:"Byte",bit:4,ccBits:[8,16,16]},t.KANJI={id:"Kanji",bit:8,ccBits:[8,10,12]},t.MIXED={bit:-1},t.getCharCountIndicator=function(e,t){if(!e.ccBits)throw new Error("Invalid mode: "+e);if(!r.isValid(t))throw new Error("Invalid version: "+t);return t>=1&&t<10?e.ccBits[0]:t<27?e.ccBits[1]:e.ccBits[2]},t.getBestModeForData=function(e){return s.testNumeric(e)?t.NUMERIC:s.testAlphanumeric(e)?t.ALPHANUMERIC:s.testKanji(e)?t.KANJI:t.BYTE},t.toString=function(e){if(e&&e.id)return e.id;throw new Error("Invalid mode")},t.isValid=function(e){return e&&e.bit&&e.ccBits},t.from=function(e,n){if(t.isValid(e))return e;try{return function(e){if("string"!==typeof e)throw new Error("Param is not a string");switch(e.toLowerCase()){case"numeric":return t.NUMERIC;case"alphanumeric":return t.ALPHANUMERIC;case"kanji":return t.KANJI;case"byte":return t.BYTE;default:throw new Error("Unknown mode: "+e)}}(e)}catch(r){return n}}},6455(e,t,n){const r=n(8314);function s(e){this.mode=r.NUMERIC,this.data=e.toString()}s.getBitsLength=function(e){return 10*Math.floor(e/3)+(e%3?e%3*3+1:0)},s.prototype.getLength=function(){return this.data.length},s.prototype.getBitsLength=function(){return s.getBitsLength(this.data.length)},s.prototype.write=function(e){let t,n,r;for(t=0;t+3<=this.data.length;t+=3)n=this.data.substr(t,3),r=parseInt(n,10),e.put(r,10);const s=this.data.length-t;s>0&&(n=this.data.substr(t),r=parseInt(n,10),e.put(r,3*s+1))},e.exports=s},3019(e,t,n){const r=n(7545);t.mul=function(e,t){const n=new Uint8Array(e.length+t.length-1);for(let s=0;s<e.length;s++)for(let a=0;a<t.length;a++)n[s+a]^=r.mul(e[s],t[a]);return n},t.mod=function(e,t){let n=new Uint8Array(e);for(;n.length-t.length>=0;){const e=n[0];for(let a=0;a<t.length;a++)n[a]^=r.mul(t[a],e);let s=0;for(;s<n.length&&0===n[s];)s++;n=n.slice(s)}return n},t.generateECPolynomial=function(e){let n=new Uint8Array([1]);for(let s=0;s<e;s++)n=t.mul(n,new Uint8Array([1,r.exp(s)]));return n}},375(e,t,n){const r=n(7476),s=n(4175),a=n(9109),i=n(7802),o=n(8227),l=n(2958),c=n(2378),u=n(3524),d=n(7898),h=n(7225),f=n(1751),p=n(8314),m=n(8263);function g(e,t,n){const r=e.size,s=f.getEncodedBits(t,n);let a,i;for(a=0;a<15;a++)i=1===(s>>a&1),a<6?e.set(a,8,i,!0):a<8?e.set(a+1,8,i,!0):e.set(r-15+a,8,i,!0),a<8?e.set(8,r-a-1,i,!0):a<9?e.set(8,15-a-1+1,i,!0):e.set(8,15-a-1,i,!0);e.set(r-8,8,1,!0)}function y(e,t,n){const s=new a;n.forEach(function(t){s.put(t.mode.bit,4),s.put(t.getLength(),p.getCharCountIndicator(t.mode,e)),t.write(s)});const i=8*(r.getSymbolTotalCodewords(e)-u.getTotalCodewordsCount(e,t));for(s.getLengthInBits()+4<=i&&s.put(0,4);s.getLengthInBits()%8!==0;)s.putBit(0);const o=(i-s.getLengthInBits())/8;for(let r=0;r<o;r++)s.put(r%2?17:236,8);return function(e,t,n){const s=r.getSymbolTotalCodewords(t),a=u.getTotalCodewordsCount(t,n),i=s-a,o=u.getBlocksCount(t,n),l=s%o,c=o-l,h=Math.floor(s/o),f=Math.floor(i/o),p=f+1,m=h-f,g=new d(m);let y=0;const w=new Array(o),v=new Array(o);let A=0;const b=new Uint8Array(e.buffer);for(let r=0;r<o;r++){const e=r<c?f:p;w[r]=b.slice(y,y+e),v[r]=g.encode(w[r]),y+=e,A=Math.max(A,e)}const x=new Uint8Array(s);let S,C,E=0;for(S=0;S<A;S++)for(C=0;C<o;C++)S<w[C].length&&(x[E++]=w[C][S]);for(S=0;S<m;S++)for(C=0;C<o;C++)x[E++]=v[C][S];return x}(s,e,t)}function w(e,t,n,s){let a;if(Array.isArray(e))a=m.fromArray(e);else{if("string"!==typeof e)throw new Error("Invalid data");{let r=t;if(!r){const t=m.rawSplit(e);r=h.getBestVersionForData(t,n)}a=m.fromString(e,r||40)}}const u=h.getBestVersionForData(a,n);if(!u)throw new Error("The amount of data is too big to be stored in a QR Code");if(t){if(t<u)throw new Error("\nThe chosen QR Code version cannot contain this amount of data.\nMinimum version required to store current data is: "+u+".\n")}else t=u;const d=y(t,n,a),f=r.getSymbolSize(t),p=new i(f);return function(e,t){const n=e.size,r=l.getPositions(t);for(let s=0;s<r.length;s++){const t=r[s][0],a=r[s][1];for(let r=-1;r<=7;r++)if(!(t+r<=-1||n<=t+r))for(let s=-1;s<=7;s++)a+s<=-1||n<=a+s||(r>=0&&r<=6&&(0===s||6===s)||s>=0&&s<=6&&(0===r||6===r)||r>=2&&r<=4&&s>=2&&s<=4?e.set(t+r,a+s,!0,!0):e.set(t+r,a+s,!1,!0))}}(p,t),function(e){const t=e.size;for(let n=8;n<t-8;n++){const t=n%2===0;e.set(n,6,t,!0),e.set(6,n,t,!0)}}(p),function(e,t){const n=o.getPositions(t);for(let r=0;r<n.length;r++){const t=n[r][0],s=n[r][1];for(let n=-2;n<=2;n++)for(let r=-2;r<=2;r++)-2===n||2===n||-2===r||2===r||0===n&&0===r?e.set(t+n,s+r,!0,!0):e.set(t+n,s+r,!1,!0)}}(p,t),g(p,n,0),t>=7&&function(e,t){const n=e.size,r=h.getEncodedBits(t);let s,a,i;for(let o=0;o<18;o++)s=Math.floor(o/3),a=o%3+n-8-3,i=1===(r>>o&1),e.set(s,a,i,!0),e.set(a,s,i,!0)}(p,t),function(e,t){const n=e.size;let r=-1,s=n-1,a=7,i=0;for(let o=n-1;o>0;o-=2)for(6===o&&o--;;){for(let n=0;n<2;n++)if(!e.isReserved(s,o-n)){let r=!1;i<t.length&&(r=1===(t[i]>>>a&1)),e.set(s,o-n,r),a--,-1===a&&(i++,a=7)}if(s+=r,s<0||n<=s){s-=r,r=-r;break}}}(p,d),isNaN(s)&&(s=c.getBestMask(p,g.bind(null,p,n))),c.applyMask(s,p),g(p,n,s),{modules:p,version:t,errorCorrectionLevel:n,maskPattern:s,segments:a}}t.create=function(e,t){if("undefined"===typeof e||""===e)throw new Error("No input text");let n,a,i=s.M;return"undefined"!==typeof t&&(i=s.from(t.errorCorrectionLevel,s.M),n=h.from(t.version),a=c.from(t.maskPattern),t.toSJISFunc&&r.setToSJISFunction(t.toSJISFunc)),w(e,n,i,a)}},7898(e,t,n){const r=n(3019);function s(e){this.genPoly=void 0,this.degree=e,this.degree&&this.initialize(this.degree)}s.prototype.initialize=function(e){this.degree=e,this.genPoly=r.generateECPolynomial(this.degree)},s.prototype.encode=function(e){if(!this.genPoly)throw new Error("Encoder not initialized");const t=new Uint8Array(e.length+this.degree);t.set(e);const n=r.mod(t,this.genPoly),s=this.degree-n.length;if(s>0){const e=new Uint8Array(this.degree);return e.set(n,s),e}return n},e.exports=s},1270(e,t){const n="[0-9]+";let r="(?:[u3000-u303F]|[u3040-u309F]|[u30A0-u30FF]|[uFF00-uFFEF]|[u4E00-u9FAF]|[u2605-u2606]|[u2190-u2195]|u203B|[u2010u2015u2018u2019u2025u2026u201Cu201Du2225u2260]|[u0391-u0451]|[u00A7u00A8u00B1u00B4u00D7u00F7])+";r=r.replace(/u/g,"\\u");const s="(?:(?![A-Z0-9 $%*+\\-./:]|"+r+")(?:.|[\r\n]))+";t.KANJI=new RegExp(r,"g"),t.BYTE_KANJI=new RegExp("[^A-Z0-9 $%*+\\-./:]+","g"),t.BYTE=new RegExp(s,"g"),t.NUMERIC=new RegExp(n,"g"),t.ALPHANUMERIC=new RegExp("[A-Z $%*+\\-./:]+","g");const a=new RegExp("^"+r+"$"),i=new RegExp("^"+n+"$"),o=new RegExp("^[A-Z0-9 $%*+\\-./:]+$");t.testKanji=function(e){return a.test(e)},t.testNumeric=function(e){return i.test(e)},t.testAlphanumeric=function(e){return o.test(e)}},8263(e,t,n){const r=n(8314),s=n(6455),a=n(3791),i=n(3452),o=n(1175),l=n(1270),c=n(7476),u=n(8702);function d(e){return unescape(encodeURIComponent(e)).length}function h(e,t,n){const r=[];let s;for(;null!==(s=e.exec(n));)r.push({data:s[0],index:s.index,mode:t,length:s[0].length});return r}function f(e){const t=h(l.NUMERIC,r.NUMERIC,e),n=h(l.ALPHANUMERIC,r.ALPHANUMERIC,e);let s,a;c.isKanjiModeEnabled()?(s=h(l.BYTE,r.BYTE,e),a=h(l.KANJI,r.KANJI,e)):(s=h(l.BYTE_KANJI,r.BYTE,e),a=[]);return t.concat(n,s,a).sort(function(e,t){return e.index-t.index}).map(function(e){return{data:e.data,mode:e.mode,length:e.length}})}function p(e,t){switch(t){case r.NUMERIC:return s.getBitsLength(e);case r.ALPHANUMERIC:return a.getBitsLength(e);case r.KANJI:return o.getBitsLength(e);case r.BYTE:return i.getBitsLength(e)}}function m(e,t){let n;const l=r.getBestModeForData(e);if(n=r.from(t,l),n!==r.BYTE&&n.bit<l.bit)throw new Error('"'+e+'" cannot be encoded with mode '+r.toString(n)+".\n Suggested mode is: "+r.toString(l));switch(n!==r.KANJI||c.isKanjiModeEnabled()||(n=r.BYTE),n){case r.NUMERIC:return new s(e);case r.ALPHANUMERIC:return new a(e);case r.KANJI:return new o(e);case r.BYTE:return new i(e)}}t.fromArray=function(e){return e.reduce(function(e,t){return"string"===typeof t?e.push(m(t,null)):t.data&&e.push(m(t.data,t.mode)),e},[])},t.fromString=function(e,n){const s=function(e){const t=[];for(let n=0;n<e.length;n++){const s=e[n];switch(s.mode){case r.NUMERIC:t.push([s,{data:s.data,mode:r.ALPHANUMERIC,length:s.length},{data:s.data,mode:r.BYTE,length:s.length}]);break;case r.ALPHANUMERIC:t.push([s,{data:s.data,mode:r.BYTE,length:s.length}]);break;case r.KANJI:t.push([s,{data:s.data,mode:r.BYTE,length:d(s.data)}]);break;case r.BYTE:t.push([{data:s.data,mode:r.BYTE,length:d(s.data)}])}}return t}(f(e,c.isKanjiModeEnabled())),a=function(e,t){const n={},s={start:{}};let a=["start"];for(let i=0;i<e.length;i++){const o=e[i],l=[];for(let e=0;e<o.length;e++){const c=o[e],u=""+i+e;l.push(u),n[u]={node:c,lastCount:0},s[u]={};for(let e=0;e<a.length;e++){const i=a[e];n[i]&&n[i].node.mode===c.mode?(s[i][u]=p(n[i].lastCount+c.length,c.mode)-p(n[i].lastCount,c.mode),n[i].lastCount+=c.length):(n[i]&&(n[i].lastCount=c.length),s[i][u]=p(c.length,c.mode)+4+r.getCharCountIndicator(c.mode,t))}}a=l}for(let r=0;r<a.length;r++)s[a[r]].end=0;return{map:s,table:n}}(s,n),i=u.find_path(a.map,"start","end"),o=[];for(let t=1;t<i.length-1;t++)o.push(a.table[i[t]].node);return t.fromArray(function(e){return e.reduce(function(e,t){const n=e.length-1>=0?e[e.length-1]:null;return n&&n.mode===t.mode?(e[e.length-1].data+=t.data,e):(e.push(t),e)},[])}(o))},t.rawSplit=function(e){return t.fromArray(f(e,c.isKanjiModeEnabled()))}},7476(e,t){let n;const r=[0,26,44,70,100,134,172,196,242,292,346,404,466,532,581,655,733,815,901,991,1085,1156,1258,1364,1474,1588,1706,1828,1921,2051,2185,2323,2465,2611,2761,2876,3034,3196,3362,3532,3706];t.getSymbolSize=function(e){if(!e)throw new Error('"version" cannot be null or undefined');if(e<1||e>40)throw new Error('"version" should be in range from 1 to 40');return 4*e+17},t.getSymbolTotalCodewords=function(e){return r[e]},t.getBCHDigit=function(e){let t=0;for(;0!==e;)t++,e>>>=1;return t},t.setToSJISFunction=function(e){if("function"!==typeof e)throw new Error('"toSJISFunc" is not a valid function.');n=e},t.isKanjiModeEnabled=function(){return"undefined"!==typeof n},t.toSJIS=function(e){return n(e)}},7232(e,t){t.isValid=function(e){return!isNaN(e)&&e>=1&&e<=40}},7225(e,t,n){const r=n(7476),s=n(3524),a=n(4175),i=n(8314),o=n(7232),l=r.getBCHDigit(7973);function c(e,t){return i.getCharCountIndicator(e,t)+4}function u(e,t){let n=0;return e.forEach(function(e){const r=c(e.mode,t);n+=r+e.getBitsLength()}),n}t.from=function(e,t){return o.isValid(e)?parseInt(e,10):t},t.getCapacity=function(e,t,n){if(!o.isValid(e))throw new Error("Invalid QR Code version");"undefined"===typeof n&&(n=i.BYTE);const a=8*(r.getSymbolTotalCodewords(e)-s.getTotalCodewordsCount(e,t));if(n===i.MIXED)return a;const l=a-c(n,e);switch(n){case i.NUMERIC:return Math.floor(l/10*3);case i.ALPHANUMERIC:return Math.floor(l/11*2);case i.KANJI:return Math.floor(l/13);case i.BYTE:default:return Math.floor(l/8)}},t.getBestVersionForData=function(e,n){let r;const s=a.from(n,a.M);if(Array.isArray(e)){if(e.length>1)return function(e,n){for(let r=1;r<=40;r++)if(u(e,r)<=t.getCapacity(r,n,i.MIXED))return r}(e,s);if(0===e.length)return 1;r=e[0]}else r=e;return function(e,n,r){for(let s=1;s<=40;s++)if(n<=t.getCapacity(s,r,e))return s}(r.mode,r.getLength(),s)},t.getEncodedBits=function(e){if(!o.isValid(e)||e<7)throw new Error("Invalid QR Code version");let t=e<<12;for(;r.getBCHDigit(t)-l>=0;)t^=7973<<r.getBCHDigit(t)-l;return e<<12|t}},4253(e,t,n){const r=n(9192);t.render=function(e,t,n){let s=n,a=t;"undefined"!==typeof s||t&&t.getContext||(s=t,t=void 0),t||(a=function(){try{return document.createElement("canvas")}catch(e){throw new Error("You need to specify a canvas element")}}()),s=r.getOptions(s);const i=r.getImageWidth(e.modules.size,s),o=a.getContext("2d"),l=o.createImageData(i,i);return r.qrToImageData(l.data,e,s),function(e,t,n){e.clearRect(0,0,t.width,t.height),t.style||(t.style={}),t.height=n,t.width=n,t.style.height=n+"px",t.style.width=n+"px"}(o,a,i),o.putImageData(l,0,0),a},t.renderToDataURL=function(e,n,r){let s=r;"undefined"!==typeof s||n&&n.getContext||(s=n,n=void 0),s||(s={});const a=t.render(e,n,s),i=s.type||"image/png",o=s.rendererOpts||{};return a.toDataURL(i,o.quality)}},5666(e,t,n){const r=n(9192);function s(e,t){const n=e.a/255,r=t+'="'+e.hex+'"';return n<1?r+" "+t+'-opacity="'+n.toFixed(2).slice(1)+'"':r}function a(e,t,n){let r=e+t;return"undefined"!==typeof n&&(r+=" "+n),r}t.render=function(e,t,n){const i=r.getOptions(t),o=e.modules.size,l=e.modules.data,c=o+2*i.margin,u=i.color.light.a?"<path "+s(i.color.light,"fill")+' d="M0 0h'+c+"v"+c+'H0z"/>':"",d="<path "+s(i.color.dark,"stroke")+' d="'+function(e,t,n){let r="",s=0,i=!1,o=0;for(let l=0;l<e.length;l++){const c=Math.floor(l%t),u=Math.floor(l/t);c||i||(i=!0),e[l]?(o++,l>0&&c>0&&e[l-1]||(r+=i?a("M",c+n,.5+u+n):a("m",s,0),s=0,i=!1),c+1<t&&e[l+1]||(r+=a("h",o),o=0)):s++}return r}(l,o,i.margin)+'"/>',h='viewBox="0 0 '+c+" "+c+'"',f='<svg xmlns="http://www.w3.org/2000/svg" '+(i.width?'width="'+i.width+'" height="'+i.width+'" ':"")+h+' shape-rendering="crispEdges">'+u+d+"</svg>\n";return"function"===typeof n&&n(null,f),f}},9192(e,t){function n(e){if("number"===typeof e&&(e=e.toString()),"string"!==typeof e)throw new Error("Color should be defined as hex string");let t=e.slice().replace("#","").split("");if(t.length<3||5===t.length||t.length>8)throw new Error("Invalid hex color: "+e);3!==t.length&&4!==t.length||(t=Array.prototype.concat.apply([],t.map(function(e){return[e,e]}))),6===t.length&&t.push("F","F");const n=parseInt(t.join(""),16);return{r:n>>24&255,g:n>>16&255,b:n>>8&255,a:255&n,hex:"#"+t.slice(0,6).join("")}}t.getOptions=function(e){e||(e={}),e.color||(e.color={});const t="undefined"===typeof e.margin||null===e.margin||e.margin<0?4:e.margin,r=e.width&&e.width>=21?e.width:void 0,s=e.scale||4;return{width:r,scale:r?4:s,margin:t,color:{dark:n(e.color.dark||"#000000ff"),light:n(e.color.light||"#ffffffff")},type:e.type,rendererOpts:e.rendererOpts||{}}},t.getScale=function(e,t){return t.width&&t.width>=e+2*t.margin?t.width/(e+2*t.margin):t.scale},t.getImageWidth=function(e,n){const r=t.getScale(e,n);return Math.floor((e+2*n.margin)*r)},t.qrToImageData=function(e,n,r){const s=n.modules.size,a=n.modules.data,i=t.getScale(s,r),o=Math.floor((s+2*r.margin)*i),l=r.margin*i,c=[r.color.light,r.color.dark];for(let t=0;t<o;t++)for(let n=0;n<o;n++){let u=4*(t*o+n),d=r.color.light;if(t>=l&&n>=l&&t<o-l&&n<o-l){d=c[a[Math.floor((t-l)/i)*s+Math.floor((n-l)/i)]?1:0]}e[u++]=d.r,e[u++]=d.g,e[u++]=d.b,e[u]=d.a}}},8477(e,t,n){"use strict";var r=n(8732),s=n(8094),a=n(3775);function i(e){var t="https://react.dev/errors/"+e;if(1<arguments.length){t+="?args[]="+encodeURIComponent(arguments[1]);for(var n=2;n<arguments.length;n++)t+="&args[]="+encodeURIComponent(arguments[n])}return"Minified React error #"+e+"; visit "+t+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}function o(e){return!(!e||1!==e.nodeType&&9!==e.nodeType&&11!==e.nodeType)}function l(e){var t=e,n=e;if(e.alternate)for(;t.return;)t=t.return;else{e=t;do{0!==(4098&(t=e).flags)&&(n=t.return),e=t.return}while(e)}return 3===t.tag?n:null}function c(e){if(13===e.tag){var t=e.memoizedState;if(null===t&&(null!==(e=e.alternate)&&(t=e.memoizedState)),null!==t)return t.dehydrated}return null}function u(e){if(31===e.tag){var t=e.memoizedState;if(null===t&&(null!==(e=e.alternate)&&(t=e.memoizedState)),null!==t)return t.dehydrated}return null}function d(e){if(l(e)!==e)throw Error(i(188))}function h(e){var t=e.tag;if(5===t||26===t||27===t||6===t)return e;for(e=e.child;null!==e;){if(null!==(t=h(e)))return t;e=e.sibling}return null}var f=Object.assign,p=Symbol.for("react.element"),m=Symbol.for("react.transitional.element"),g=Symbol.for("react.portal"),y=Symbol.for("react.fragment"),w=Symbol.for("react.strict_mode"),v=Symbol.for("react.profiler"),A=Symbol.for("react.consumer"),b=Symbol.for("react.context"),x=Symbol.for("react.forward_ref"),S=Symbol.for("react.suspense"),C=Symbol.for("react.suspense_list"),E=Symbol.for("react.memo"),N=Symbol.for("react.lazy");Symbol.for("react.scope");var k=Symbol.for("react.activity");Symbol.for("react.legacy_hidden"),Symbol.for("react.tracing_marker");var T=Symbol.for("react.memo_cache_sentinel");Symbol.for("react.view_transition");var I=Symbol.iterator;function _(e){return null===e||"object"!==typeof e?null:"function"===typeof(e=I&&e[I]||e["@@iterator"])?e:null}var R=Symbol.for("react.client.reference");function M(e){if(null==e)return null;if("function"===typeof e)return e.$$typeof===R?null:e.displayName||e.name||null;if("string"===typeof e)return e;switch(e){case y:return"Fragment";case v:return"Profiler";case w:return"StrictMode";case S:return"Suspense";case C:return"SuspenseList";case k:return"Activity"}if("object"===typeof e)switch(e.$$typeof){case g:return"Portal";case b:return e.displayName||"Context";case A:return(e._context.displayName||"Context")+".Consumer";case x:var t=e.render;return(e=e.displayName)||(e=""!==(e=t.displayName||t.name||"")?"ForwardRef("+e+")":"ForwardRef"),e;case E:return null!==(t=e.displayName||null)?t:M(e.type)||"Memo";case N:t=e._payload,e=e._init;try{return M(e(t))}catch(n){}}return null}var D=Array.isArray,j=s.__CLIENT_INTERNALS_DO_NOT_USE_OR_WARN_USERS_THEY_CANNOT_UPGRADE,O=a.__DOM_INTERNALS_DO_NOT_USE_OR_WARN_USERS_THEY_CANNOT_UPGRADE,P={pending:!1,data:null,method:null,action:null},L=[],B=-1;function F(e){return{current:e}}function U(e){0>B||(e.current=L[B],L[B]=null,B--)}function W(e,t){B++,L[B]=e.current,e.current=t}var z,H,V=F(null),G=F(null),J=F(null),Q=F(null);function K(e,t){switch(W(J,t),W(G,e),W(V,null),t.nodeType){case 9:case 11:e=(e=t.documentElement)&&(e=e.namespaceURI)?yd(e):0;break;default:if(e=t.tagName,t=t.namespaceURI)e=wd(t=yd(t),e);else switch(e){case"svg":e=1;break;case"math":e=2;break;default:e=0}}U(V),W(V,e)}function Y(){U(V),U(G),U(J)}function q(e){null!==e.memoizedState&&W(Q,e);var t=V.current,n=wd(t,e.type);t!==n&&(W(G,e),W(V,n))}function X(e){G.current===e&&(U(V),U(G)),Q.current===e&&(U(Q),uh._currentValue=P)}function Z(e){if(void 0===z)try{throw Error()}catch(n){var t=n.stack.trim().match(/\n( *(at )?)/);z=t&&t[1]||"",H=-1<n.stack.indexOf("\n    at")?" (<anonymous>)":-1<n.stack.indexOf("@")?"@unknown:0:0":""}return"\n"+z+e+H}var $=!1;function ee(e,t){if(!e||$)return"";$=!0;var n=Error.prepareStackTrace;Error.prepareStackTrace=void 0;try{var r={DetermineComponentFrameRoot:function(){try{if(t){var n=function(){throw Error()};if(Object.defineProperty(n.prototype,"props",{set:function(){throw Error()}}),"object"===typeof Reflect&&Reflect.construct){try{Reflect.construct(n,[])}catch(s){var r=s}Reflect.construct(e,[],n)}else{try{n.call()}catch(a){r=a}e.call(n.prototype)}}else{try{throw Error()}catch(i){r=i}(n=e())&&"function"===typeof n.catch&&n.catch(function(){})}}catch(o){if(o&&r&&"string"===typeof o.stack)return[o.stack,r.stack]}return[null,null]}};r.DetermineComponentFrameRoot.displayName="DetermineComponentFrameRoot";var s=Object.getOwnPropertyDescriptor(r.DetermineComponentFrameRoot,"name");s&&s.configurable&&Object.defineProperty(r.DetermineComponentFrameRoot,"name",{value:"DetermineComponentFrameRoot"});var a=r.DetermineComponentFrameRoot(),i=a[0],o=a[1];if(i&&o){var l=i.split("\n"),c=o.split("\n");for(s=r=0;r<l.length&&!l[r].includes("DetermineComponentFrameRoot");)r++;for(;s<c.length&&!c[s].includes("DetermineComponentFrameRoot");)s++;if(r===l.length||s===c.length)for(r=l.length-1,s=c.length-1;1<=r&&0<=s&&l[r]!==c[s];)s--;for(;1<=r&&0<=s;r--,s--)if(l[r]!==c[s]){if(1!==r||1!==s)do{if(r--,0>--s||l[r]!==c[s]){var u="\n"+l[r].replace(" at new "," at ");return e.displayName&&u.includes("<anonymous>")&&(u=u.replace("<anonymous>",e.displayName)),u}}while(1<=r&&0<=s);break}}}finally{$=!1,Error.prepareStackTrace=n}return(n=e?e.displayName||e.name:"")?Z(n):""}function te(e,t){switch(e.tag){case 26:case 27:case 5:return Z(e.type);case 16:return Z("Lazy");case 13:return e.child!==t&&null!==t?Z("Suspense Fallback"):Z("Suspense");case 19:return Z("SuspenseList");case 0:case 15:return ee(e.type,!1);case 11:return ee(e.type.render,!1);case 1:return ee(e.type,!0);case 31:return Z("Activity");default:return""}}function ne(e){try{var t="",n=null;do{t+=te(e,n),n=e,e=e.return}while(e);return t}catch(r){return"\nError generating stack: "+r.message+"\n"+r.stack}}var re=Object.prototype.hasOwnProperty,se=r.unstable_scheduleCallback,ae=r.unstable_cancelCallback,ie=r.unstable_shouldYield,oe=r.unstable_requestPaint,le=r.unstable_now,ce=r.unstable_getCurrentPriorityLevel,ue=r.unstable_ImmediatePriority,de=r.unstable_UserBlockingPriority,he=r.unstable_NormalPriority,fe=r.unstable_LowPriority,pe=r.unstable_IdlePriority,me=r.log,ge=r.unstable_setDisableYieldValue,ye=null,we=null;function ve(e){if("function"===typeof me&&ge(e),we&&"function"===typeof we.setStrictMode)try{we.setStrictMode(ye,e)}catch(t){}}var Ae=Math.clz32?Math.clz32:function(e){return 0===(e>>>=0)?32:31-(be(e)/xe|0)|0},be=Math.log,xe=Math.LN2;var Se=256,Ce=262144,Ee=4194304;function Ne(e){var t=42&e;if(0!==t)return t;switch(e&-e){case 1:return 1;case 2:return 2;case 4:return 4;case 8:return 8;case 16:return 16;case 32:return 32;case 64:return 64;case 128:return 128;case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:return 261888&e;case 262144:case 524288:case 1048576:case 2097152:return 3932160&e;case 4194304:case 8388608:case 16777216:case 33554432:return 62914560&e;case 67108864:return 67108864;case 134217728:return 134217728;case 268435456:return 268435456;case 536870912:return 536870912;case 1073741824:return 0;default:return e}}function ke(e,t,n){var r=e.pendingLanes;if(0===r)return 0;var s=0,a=e.suspendedLanes,i=e.pingedLanes;e=e.warmLanes;var o=134217727&r;return 0!==o?0!==(r=o&~a)?s=Ne(r):0!==(i&=o)?s=Ne(i):n||0!==(n=o&~e)&&(s=Ne(n)):0!==(o=r&~a)?s=Ne(o):0!==i?s=Ne(i):n||0!==(n=r&~e)&&(s=Ne(n)),0===s?0:0!==t&&t!==s&&0===(t&a)&&((a=s&-s)>=(n=t&-t)||32===a&&0!==(4194048&n))?t:s}function Te(e,t){return 0===(e.pendingLanes&~(e.suspendedLanes&~e.pingedLanes)&t)}function Ie(e,t){switch(e){case 1:case 2:case 4:case 8:case 64:return t+250;case 16:case 32:case 128:case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:return t+5e3;default:return-1}}function _e(){var e=Ee;return 0===(62914560&(Ee<<=1))&&(Ee=4194304),e}function Re(e){for(var t=[],n=0;31>n;n++)t.push(e);return t}function Me(e,t){e.pendingLanes|=t,268435456!==t&&(e.suspendedLanes=0,e.pingedLanes=0,e.warmLanes=0)}function De(e,t,n){e.pendingLanes|=t,e.suspendedLanes&=~t;var r=31-Ae(t);e.entangledLanes|=t,e.entanglements[r]=1073741824|e.entanglements[r]|261930&n}function je(e,t){var n=e.entangledLanes|=t;for(e=e.entanglements;n;){var r=31-Ae(n),s=1<<r;s&t|e[r]&t&&(e[r]|=t),n&=~s}}function Oe(e,t){var n=t&-t;return 0!==((n=0!==(42&n)?1:Pe(n))&(e.suspendedLanes|t))?0:n}function Pe(e){switch(e){case 2:e=1;break;case 8:e=4;break;case 32:e=16;break;case 256:case 512:case 1024:case 2048:case 4096:case 8192:case 16384:case 32768:case 65536:case 131072:case 262144:case 524288:case 1048576:case 2097152:case 4194304:case 8388608:case 16777216:case 33554432:e=128;break;case 268435456:e=134217728;break;default:e=0}return e}function Le(e){return 2<(e&=-e)?8<e?0!==(134217727&e)?32:268435456:8:2}function Be(){var e=O.p;return 0!==e?e:void 0===(e=window.event)?32:Nh(e.type)}function Fe(e,t){var n=O.p;try{return O.p=e,t()}finally{O.p=n}}var Ue=Math.random().toString(36).slice(2),We="__reactFiber$"+Ue,ze="__reactProps$"+Ue,He="__reactContainer$"+Ue,Ve="__reactEvents$"+Ue,Ge="__reactListeners$"+Ue,Je="__reactHandles$"+Ue,Qe="__reactResources$"+Ue,Ke="__reactMarker$"+Ue;function Ye(e){delete e[We],delete e[ze],delete e[Ve],delete e[Ge],delete e[Je]}function qe(e){var t=e[We];if(t)return t;for(var n=e.parentNode;n;){if(t=n[He]||n[We]){if(n=t.alternate,null!==t.child||null!==n&&null!==n.child)for(e=Pd(e);null!==e;){if(n=e[We])return n;e=Pd(e)}return t}n=(e=n).parentNode}return null}function Xe(e){if(e=e[We]||e[He]){var t=e.tag;if(5===t||6===t||13===t||31===t||26===t||27===t||3===t)return e}return null}function Ze(e){var t=e.tag;if(5===t||26===t||27===t||6===t)return e.stateNode;throw Error(i(33))}function $e(e){var t=e[Qe];return t||(t=e[Qe]={hoistableStyles:new Map,hoistableScripts:new Map}),t}function et(e){e[Ke]=!0}var tt=new Set,nt={};function rt(e,t){st(e,t),st(e+"Capture",t)}function st(e,t){for(nt[e]=t,e=0;e<t.length;e++)tt.add(t[e])}var at=RegExp("^[:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD][:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\-.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040]*$"),it={},ot={};function lt(e,t,n){if(s=t,re.call(ot,s)||!re.call(it,s)&&(at.test(s)?ot[s]=!0:(it[s]=!0,0)))if(null===n)e.removeAttribute(t);else{switch(typeof n){case"undefined":case"function":case"symbol":return void e.removeAttribute(t);case"boolean":var r=t.toLowerCase().slice(0,5);if("data-"!==r&&"aria-"!==r)return void e.removeAttribute(t)}e.setAttribute(t,""+n)}var s}function ct(e,t,n){if(null===n)e.removeAttribute(t);else{switch(typeof n){case"undefined":case"function":case"symbol":case"boolean":return void e.removeAttribute(t)}e.setAttribute(t,""+n)}}function ut(e,t,n,r){if(null===r)e.removeAttribute(n);else{switch(typeof r){case"undefined":case"function":case"symbol":case"boolean":return void e.removeAttribute(n)}e.setAttributeNS(t,n,""+r)}}function dt(e){switch(typeof e){case"bigint":case"boolean":case"number":case"string":case"undefined":case"object":return e;default:return""}}function ht(e){var t=e.type;return(e=e.nodeName)&&"input"===e.toLowerCase()&&("checkbox"===t||"radio"===t)}function ft(e){if(!e._valueTracker){var t=ht(e)?"checked":"value";e._valueTracker=function(e,t,n){var r=Object.getOwnPropertyDescriptor(e.constructor.prototype,t);if(!e.hasOwnProperty(t)&&"undefined"!==typeof r&&"function"===typeof r.get&&"function"===typeof r.set){var s=r.get,a=r.set;return Object.defineProperty(e,t,{configurable:!0,get:function(){return s.call(this)},set:function(e){n=""+e,a.call(this,e)}}),Object.defineProperty(e,t,{enumerable:r.enumerable}),{getValue:function(){return n},setValue:function(e){n=""+e},stopTracking:function(){e._valueTracker=null,delete e[t]}}}}(e,t,""+e[t])}}function pt(e){if(!e)return!1;var t=e._valueTracker;if(!t)return!0;var n=t.getValue(),r="";return e&&(r=ht(e)?e.checked?"true":"false":e.value),(e=r)!==n&&(t.setValue(e),!0)}function mt(e){if("undefined"===typeof(e=e||("undefined"!==typeof document?document:void 0)))return null;try{return e.activeElement||e.body}catch(t){return e.body}}var gt=/[\n"\\]/g;function yt(e){return e.replace(gt,function(e){return"\\"+e.charCodeAt(0).toString(16)+" "})}function wt(e,t,n,r,s,a,i,o){e.name="",null!=i&&"function"!==typeof i&&"symbol"!==typeof i&&"boolean"!==typeof i?e.type=i:e.removeAttribute("type"),null!=t?"number"===i?(0===t&&""===e.value||e.value!=t)&&(e.value=""+dt(t)):e.value!==""+dt(t)&&(e.value=""+dt(t)):"submit"!==i&&"reset"!==i||e.removeAttribute("value"),null!=t?At(e,i,dt(t)):null!=n?At(e,i,dt(n)):null!=r&&e.removeAttribute("value"),null==s&&null!=a&&(e.defaultChecked=!!a),null!=s&&(e.checked=s&&"function"!==typeof s&&"symbol"!==typeof s),null!=o&&"function"!==typeof o&&"symbol"!==typeof o&&"boolean"!==typeof o?e.name=""+dt(o):e.removeAttribute("name")}function vt(e,t,n,r,s,a,i,o){if(null!=a&&"function"!==typeof a&&"symbol"!==typeof a&&"boolean"!==typeof a&&(e.type=a),null!=t||null!=n){if(!("submit"!==a&&"reset"!==a||void 0!==t&&null!==t))return void ft(e);n=null!=n?""+dt(n):"",t=null!=t?""+dt(t):n,o||t===e.value||(e.value=t),e.defaultValue=t}r="function"!==typeof(r=null!=r?r:s)&&"symbol"!==typeof r&&!!r,e.checked=o?e.checked:!!r,e.defaultChecked=!!r,null!=i&&"function"!==typeof i&&"symbol"!==typeof i&&"boolean"!==typeof i&&(e.name=i),ft(e)}function At(e,t,n){"number"===t&&mt(e.ownerDocument)===e||e.defaultValue===""+n||(e.defaultValue=""+n)}function bt(e,t,n,r){if(e=e.options,t){t={};for(var s=0;s<n.length;s++)t["$"+n[s]]=!0;for(n=0;n<e.length;n++)s=t.hasOwnProperty("$"+e[n].value),e[n].selected!==s&&(e[n].selected=s),s&&r&&(e[n].defaultSelected=!0)}else{for(n=""+dt(n),t=null,s=0;s<e.length;s++){if(e[s].value===n)return e[s].selected=!0,void(r&&(e[s].defaultSelected=!0));null!==t||e[s].disabled||(t=e[s])}null!==t&&(t.selected=!0)}}function xt(e,t,n){null==t||((t=""+dt(t))!==e.value&&(e.value=t),null!=n)?e.defaultValue=null!=n?""+dt(n):"":e.defaultValue!==t&&(e.defaultValue=t)}function St(e,t,n,r){if(null==t){if(null!=r){if(null!=n)throw Error(i(92));if(D(r)){if(1<r.length)throw Error(i(93));r=r[0]}n=r}null==n&&(n=""),t=n}n=dt(t),e.defaultValue=n,(r=e.textContent)===n&&""!==r&&null!==r&&(e.value=r),ft(e)}function Ct(e,t){if(t){var n=e.firstChild;if(n&&n===e.lastChild&&3===n.nodeType)return void(n.nodeValue=t)}e.textContent=t}var Et=new Set("animationIterationCount aspectRatio borderImageOutset borderImageSlice borderImageWidth boxFlex boxFlexGroup boxOrdinalGroup columnCount columns flex flexGrow flexPositive flexShrink flexNegative flexOrder gridArea gridRow gridRowEnd gridRowSpan gridRowStart gridColumn gridColumnEnd gridColumnSpan gridColumnStart fontWeight lineClamp lineHeight opacity order orphans scale tabSize widows zIndex zoom fillOpacity floodOpacity stopOpacity strokeDasharray strokeDashoffset strokeMiterlimit strokeOpacity strokeWidth MozAnimationIterationCount MozBoxFlex MozBoxFlexGroup MozLineClamp msAnimationIterationCount msFlex msZoom msFlexGrow msFlexNegative msFlexOrder msFlexPositive msFlexShrink msGridColumn msGridColumnSpan msGridRow msGridRowSpan WebkitAnimationIterationCount WebkitBoxFlex WebKitBoxFlexGroup WebkitBoxOrdinalGroup WebkitColumnCount WebkitColumns WebkitFlex WebkitFlexGrow WebkitFlexPositive WebkitFlexShrink WebkitLineClamp".split(" "));function Nt(e,t,n){var r=0===t.indexOf("--");null==n||"boolean"===typeof n||""===n?r?e.setProperty(t,""):"float"===t?e.cssFloat="":e[t]="":r?e.setProperty(t,n):"number"!==typeof n||0===n||Et.has(t)?"float"===t?e.cssFloat=n:e[t]=(""+n).trim():e[t]=n+"px"}function kt(e,t,n){if(null!=t&&"object"!==typeof t)throw Error(i(62));if(e=e.style,null!=n){for(var r in n)!n.hasOwnProperty(r)||null!=t&&t.hasOwnProperty(r)||(0===r.indexOf("--")?e.setProperty(r,""):"float"===r?e.cssFloat="":e[r]="");for(var s in t)r=t[s],t.hasOwnProperty(s)&&n[s]!==r&&Nt(e,s,r)}else for(var a in t)t.hasOwnProperty(a)&&Nt(e,a,t[a])}function Tt(e){if(-1===e.indexOf("-"))return!1;switch(e){case"annotation-xml":case"color-profile":case"font-face":case"font-face-src":case"font-face-uri":case"font-face-format":case"font-face-name":case"missing-glyph":return!1;default:return!0}}var It=new Map([["acceptCharset","accept-charset"],["htmlFor","for"],["httpEquiv","http-equiv"],["crossOrigin","crossorigin"],["accentHeight","accent-height"],["alignmentBaseline","alignment-baseline"],["arabicForm","arabic-form"],["baselineShift","baseline-shift"],["capHeight","cap-height"],["clipPath","clip-path"],["clipRule","clip-rule"],["colorInterpolation","color-interpolation"],["colorInterpolationFilters","color-interpolation-filters"],["colorProfile","color-profile"],["colorRendering","color-rendering"],["dominantBaseline","dominant-baseline"],["enableBackground","enable-background"],["fillOpacity","fill-opacity"],["fillRule","fill-rule"],["floodColor","flood-color"],["floodOpacity","flood-opacity"],["fontFamily","font-family"],["fontSize","font-size"],["fontSizeAdjust","font-size-adjust"],["fontStretch","font-stretch"],["fontStyle","font-style"],["fontVariant","font-variant"],["fontWeight","font-weight"],["glyphName","glyph-name"],["glyphOrientationHorizontal","glyph-orientation-horizontal"],["glyphOrientationVertical","glyph-orientation-vertical"],["horizAdvX","horiz-adv-x"],["horizOriginX","horiz-origin-x"],["imageRendering","image-rendering"],["letterSpacing","letter-spacing"],["lightingColor","lighting-color"],["markerEnd","marker-end"],["markerMid","marker-mid"],["markerStart","marker-start"],["overlinePosition","overline-position"],["overlineThickness","overline-thickness"],["paintOrder","paint-order"],["panose-1","panose-1"],["pointerEvents","pointer-events"],["renderingIntent","rendering-intent"],["shapeRendering","shape-rendering"],["stopColor","stop-color"],["stopOpacity","stop-opacity"],["strikethroughPosition","strikethrough-position"],["strikethroughThickness","strikethrough-thickness"],["strokeDasharray","stroke-dasharray"],["strokeDashoffset","stroke-dashoffset"],["strokeLinecap","stroke-linecap"],["strokeLinejoin","stroke-linejoin"],["strokeMiterlimit","stroke-miterlimit"],["strokeOpacity","stroke-opacity"],["strokeWidth","stroke-width"],["textAnchor","text-anchor"],["textDecoration","text-decoration"],["textRendering","text-rendering"],["transformOrigin","transform-origin"],["underlinePosition","underline-position"],["underlineThickness","underline-thickness"],["unicodeBidi","unicode-bidi"],["unicodeRange","unicode-range"],["unitsPerEm","units-per-em"],["vAlphabetic","v-alphabetic"],["vHanging","v-hanging"],["vIdeographic","v-ideographic"],["vMathematical","v-mathematical"],["vectorEffect","vector-effect"],["vertAdvY","vert-adv-y"],["vertOriginX","vert-origin-x"],["vertOriginY","vert-origin-y"],["wordSpacing","word-spacing"],["writingMode","writing-mode"],["xmlnsXlink","xmlns:xlink"],["xHeight","x-height"]]),_t=/^[\u0000-\u001F ]*j[\r\n\t]*a[\r\n\t]*v[\r\n\t]*a[\r\n\t]*s[\r\n\t]*c[\r\n\t]*r[\r\n\t]*i[\r\n\t]*p[\r\n\t]*t[\r\n\t]*:/i;function Rt(e){return _t.test(""+e)?"javascript:throw new Error('React has blocked a javascript: URL as a security precaution.')":e}function Mt(){}var Dt=null;function jt(e){return(e=e.target||e.srcElement||window).correspondingUseElement&&(e=e.correspondingUseElement),3===e.nodeType?e.parentNode:e}var Ot=null,Pt=null;function Lt(e){var t=Xe(e);if(t&&(e=t.stateNode)){var n=e[ze]||null;e:switch(e=t.stateNode,t.type){case"input":if(wt(e,n.value,n.defaultValue,n.defaultValue,n.checked,n.defaultChecked,n.type,n.name),t=n.name,"radio"===n.type&&null!=t){for(n=e;n.parentNode;)n=n.parentNode;for(n=n.querySelectorAll('input[name="'+yt(""+t)+'"][type="radio"]'),t=0;t<n.length;t++){var r=n[t];if(r!==e&&r.form===e.form){var s=r[ze]||null;if(!s)throw Error(i(90));wt(r,s.value,s.defaultValue,s.defaultValue,s.checked,s.defaultChecked,s.type,s.name)}}for(t=0;t<n.length;t++)(r=n[t]).form===e.form&&pt(r)}break e;case"textarea":xt(e,n.value,n.defaultValue);break e;case"select":null!=(t=n.value)&&bt(e,!!n.multiple,t,!1)}}}var Bt=!1;function Ft(e,t,n){if(Bt)return e(t,n);Bt=!0;try{return e(t)}finally{if(Bt=!1,(null!==Ot||null!==Pt)&&($c(),Ot&&(t=Ot,e=Pt,Pt=Ot=null,Lt(t),e)))for(t=0;t<e.length;t++)Lt(e[t])}}function Ut(e,t){var n=e.stateNode;if(null===n)return null;var r=n[ze]||null;if(null===r)return null;n=r[t];e:switch(t){case"onClick":case"onClickCapture":case"onDoubleClick":case"onDoubleClickCapture":case"onMouseDown":case"onMouseDownCapture":case"onMouseMove":case"onMouseMoveCapture":case"onMouseUp":case"onMouseUpCapture":case"onMouseEnter":(r=!r.disabled)||(r=!("button"===(e=e.type)||"input"===e||"select"===e||"textarea"===e)),e=!r;break e;default:e=!1}if(e)return null;if(n&&"function"!==typeof n)throw Error(i(231,t,typeof n));return n}var Wt=!("undefined"===typeof window||"undefined"===typeof window.document||"undefined"===typeof window.document.createElement),zt=!1;if(Wt)try{var Ht={};Object.defineProperty(Ht,"passive",{get:function(){zt=!0}}),window.addEventListener("test",Ht,Ht),window.removeEventListener("test",Ht,Ht)}catch(Xh){zt=!1}var Vt=null,Gt=null,Jt=null;function Qt(){if(Jt)return Jt;var e,t,n=Gt,r=n.length,s="value"in Vt?Vt.value:Vt.textContent,a=s.length;for(e=0;e<r&&n[e]===s[e];e++);var i=r-e;for(t=1;t<=i&&n[r-t]===s[a-t];t++);return Jt=s.slice(e,1<t?1-t:void 0)}function Kt(e){var t=e.keyCode;return"charCode"in e?0===(e=e.charCode)&&13===t&&(e=13):e=t,10===e&&(e=13),32<=e||13===e?e:0}function Yt(){return!0}function qt(){return!1}function Xt(e){function t(t,n,r,s,a){for(var i in this._reactName=t,this._targetInst=r,this.type=n,this.nativeEvent=s,this.target=a,this.currentTarget=null,e)e.hasOwnProperty(i)&&(t=e[i],this[i]=t?t(s):s[i]);return this.isDefaultPrevented=(null!=s.defaultPrevented?s.defaultPrevented:!1===s.returnValue)?Yt:qt,this.isPropagationStopped=qt,this}return f(t.prototype,{preventDefault:function(){this.defaultPrevented=!0;var e=this.nativeEvent;e&&(e.preventDefault?e.preventDefault():"unknown"!==typeof e.returnValue&&(e.returnValue=!1),this.isDefaultPrevented=Yt)},stopPropagation:function(){var e=this.nativeEvent;e&&(e.stopPropagation?e.stopPropagation():"unknown"!==typeof e.cancelBubble&&(e.cancelBubble=!0),this.isPropagationStopped=Yt)},persist:function(){},isPersistent:Yt}),t}var Zt,$t,en,tn={eventPhase:0,bubbles:0,cancelable:0,timeStamp:function(e){return e.timeStamp||Date.now()},defaultPrevented:0,isTrusted:0},nn=Xt(tn),rn=f({},tn,{view:0,detail:0}),sn=Xt(rn),an=f({},rn,{screenX:0,screenY:0,clientX:0,clientY:0,pageX:0,pageY:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,getModifierState:yn,button:0,buttons:0,relatedTarget:function(e){return void 0===e.relatedTarget?e.fromElement===e.srcElement?e.toElement:e.fromElement:e.relatedTarget},movementX:function(e){return"movementX"in e?e.movementX:(e!==en&&(en&&"mousemove"===e.type?(Zt=e.screenX-en.screenX,$t=e.screenY-en.screenY):$t=Zt=0,en=e),Zt)},movementY:function(e){return"movementY"in e?e.movementY:$t}}),on=Xt(an),ln=Xt(f({},an,{dataTransfer:0})),cn=Xt(f({},rn,{relatedTarget:0})),un=Xt(f({},tn,{animationName:0,elapsedTime:0,pseudoElement:0})),dn=Xt(f({},tn,{clipboardData:function(e){return"clipboardData"in e?e.clipboardData:window.clipboardData}})),hn=Xt(f({},tn,{data:0})),fn={Esc:"Escape",Spacebar:" ",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown",Del:"Delete",Win:"OS",Menu:"ContextMenu",Apps:"ContextMenu",Scroll:"ScrollLock",MozPrintableKey:"Unidentified"},pn={8:"Backspace",9:"Tab",12:"Clear",13:"Enter",16:"Shift",17:"Control",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",224:"Meta"},mn={Alt:"altKey",Control:"ctrlKey",Meta:"metaKey",Shift:"shiftKey"};function gn(e){var t=this.nativeEvent;return t.getModifierState?t.getModifierState(e):!!(e=mn[e])&&!!t[e]}function yn(){return gn}var wn=Xt(f({},rn,{key:function(e){if(e.key){var t=fn[e.key]||e.key;if("Unidentified"!==t)return t}return"keypress"===e.type?13===(e=Kt(e))?"Enter":String.fromCharCode(e):"keydown"===e.type||"keyup"===e.type?pn[e.keyCode]||"Unidentified":""},code:0,location:0,ctrlKey:0,shiftKey:0,altKey:0,metaKey:0,repeat:0,locale:0,getModifierState:yn,charCode:function(e){return"keypress"===e.type?Kt(e):0},keyCode:function(e){return"keydown"===e.type||"keyup"===e.type?e.keyCode:0},which:function(e){return"keypress"===e.type?Kt(e):"keydown"===e.type||"keyup"===e.type?e.keyCode:0}})),vn=Xt(f({},an,{pointerId:0,width:0,height:0,pressure:0,tangentialPressure:0,tiltX:0,tiltY:0,twist:0,pointerType:0,isPrimary:0})),An=Xt(f({},rn,{touches:0,targetTouches:0,changedTouches:0,altKey:0,metaKey:0,ctrlKey:0,shiftKey:0,getModifierState:yn})),bn=Xt(f({},tn,{propertyName:0,elapsedTime:0,pseudoElement:0})),xn=Xt(f({},an,{deltaX:function(e){return"deltaX"in e?e.deltaX:"wheelDeltaX"in e?-e.wheelDeltaX:0},deltaY:function(e){return"deltaY"in e?e.deltaY:"wheelDeltaY"in e?-e.wheelDeltaY:"wheelDelta"in e?-e.wheelDelta:0},deltaZ:0,deltaMode:0})),Sn=Xt(f({},tn,{newState:0,oldState:0})),Cn=[9,13,27,32],En=Wt&&"CompositionEvent"in window,Nn=null;Wt&&"documentMode"in document&&(Nn=document.documentMode);var kn=Wt&&"TextEvent"in window&&!Nn,Tn=Wt&&(!En||Nn&&8<Nn&&11>=Nn),In=String.fromCharCode(32),_n=!1;function Rn(e,t){switch(e){case"keyup":return-1!==Cn.indexOf(t.keyCode);case"keydown":return 229!==t.keyCode;case"keypress":case"mousedown":case"focusout":return!0;default:return!1}}function Mn(e){return"object"===typeof(e=e.detail)&&"data"in e?e.data:null}var Dn=!1;var jn={color:!0,date:!0,datetime:!0,"datetime-local":!0,email:!0,month:!0,number:!0,password:!0,range:!0,search:!0,tel:!0,text:!0,time:!0,url:!0,week:!0};function On(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return"input"===t?!!jn[e.type]:"textarea"===t}function Pn(e,t,n,r){Ot?Pt?Pt.push(r):Pt=[r]:Ot=r,0<(t=rd(t,"onChange")).length&&(n=new nn("onChange","change",null,n,r),e.push({event:n,listeners:t}))}var Ln=null,Bn=null;function Fn(e){Yu(e,0)}function Un(e){if(pt(Ze(e)))return e}function Wn(e,t){if("change"===e)return t}var zn=!1;if(Wt){var Hn;if(Wt){var Vn="oninput"in document;if(!Vn){var Gn=document.createElement("div");Gn.setAttribute("oninput","return;"),Vn="function"===typeof Gn.oninput}Hn=Vn}else Hn=!1;zn=Hn&&(!document.documentMode||9<document.documentMode)}function Jn(){Ln&&(Ln.detachEvent("onpropertychange",Qn),Bn=Ln=null)}function Qn(e){if("value"===e.propertyName&&Un(Bn)){var t=[];Pn(t,Bn,e,jt(e)),Ft(Fn,t)}}function Kn(e,t,n){"focusin"===e?(Jn(),Bn=n,(Ln=t).attachEvent("onpropertychange",Qn)):"focusout"===e&&Jn()}function Yn(e){if("selectionchange"===e||"keyup"===e||"keydown"===e)return Un(Bn)}function qn(e,t){if("click"===e)return Un(t)}function Xn(e,t){if("input"===e||"change"===e)return Un(t)}var Zn="function"===typeof Object.is?Object.is:function(e,t){return e===t&&(0!==e||1/e===1/t)||e!==e&&t!==t};function $n(e,t){if(Zn(e,t))return!0;if("object"!==typeof e||null===e||"object"!==typeof t||null===t)return!1;var n=Object.keys(e),r=Object.keys(t);if(n.length!==r.length)return!1;for(r=0;r<n.length;r++){var s=n[r];if(!re.call(t,s)||!Zn(e[s],t[s]))return!1}return!0}function er(e){for(;e&&e.firstChild;)e=e.firstChild;return e}function tr(e,t){var n,r=er(e);for(e=0;r;){if(3===r.nodeType){if(n=e+r.textContent.length,e<=t&&n>=t)return{node:r,offset:t-e};e=n}e:{for(;r;){if(r.nextSibling){r=r.nextSibling;break e}r=r.parentNode}r=void 0}r=er(r)}}function nr(e,t){return!(!e||!t)&&(e===t||(!e||3!==e.nodeType)&&(t&&3===t.nodeType?nr(e,t.parentNode):"contains"in e?e.contains(t):!!e.compareDocumentPosition&&!!(16&e.compareDocumentPosition(t))))}function rr(e){for(var t=mt((e=null!=e&&null!=e.ownerDocument&&null!=e.ownerDocument.defaultView?e.ownerDocument.defaultView:window).document);t instanceof e.HTMLIFrameElement;){try{var n="string"===typeof t.contentWindow.location.href}catch(r){n=!1}if(!n)break;t=mt((e=t.contentWindow).document)}return t}function sr(e){var t=e&&e.nodeName&&e.nodeName.toLowerCase();return t&&("input"===t&&("text"===e.type||"search"===e.type||"tel"===e.type||"url"===e.type||"password"===e.type)||"textarea"===t||"true"===e.contentEditable)}var ar=Wt&&"documentMode"in document&&11>=document.documentMode,ir=null,or=null,lr=null,cr=!1;function ur(e,t,n){var r=n.window===n?n.document:9===n.nodeType?n:n.ownerDocument;cr||null==ir||ir!==mt(r)||("selectionStart"in(r=ir)&&sr(r)?r={start:r.selectionStart,end:r.selectionEnd}:r={anchorNode:(r=(r.ownerDocument&&r.ownerDocument.defaultView||window).getSelection()).anchorNode,anchorOffset:r.anchorOffset,focusNode:r.focusNode,focusOffset:r.focusOffset},lr&&$n(lr,r)||(lr=r,0<(r=rd(or,"onSelect")).length&&(t=new nn("onSelect","select",null,t,n),e.push({event:t,listeners:r}),t.target=ir)))}function dr(e,t){var n={};return n[e.toLowerCase()]=t.toLowerCase(),n["Webkit"+e]="webkit"+t,n["Moz"+e]="moz"+t,n}var hr={animationend:dr("Animation","AnimationEnd"),animationiteration:dr("Animation","AnimationIteration"),animationstart:dr("Animation","AnimationStart"),transitionrun:dr("Transition","TransitionRun"),transitionstart:dr("Transition","TransitionStart"),transitioncancel:dr("Transition","TransitionCancel"),transitionend:dr("Transition","TransitionEnd")},fr={},pr={};function mr(e){if(fr[e])return fr[e];if(!hr[e])return e;var t,n=hr[e];for(t in n)if(n.hasOwnProperty(t)&&t in pr)return fr[e]=n[t];return e}Wt&&(pr=document.createElement("div").style,"AnimationEvent"in window||(delete hr.animationend.animation,delete hr.animationiteration.animation,delete hr.animationstart.animation),"TransitionEvent"in window||delete hr.transitionend.transition);var gr=mr("animationend"),yr=mr("animationiteration"),wr=mr("animationstart"),vr=mr("transitionrun"),Ar=mr("transitionstart"),br=mr("transitioncancel"),xr=mr("transitionend"),Sr=new Map,Cr="abort auxClick beforeToggle cancel canPlay canPlayThrough click close contextMenu copy cut drag dragEnd dragEnter dragExit dragLeave dragOver dragStart drop durationChange emptied encrypted ended error gotPointerCapture input invalid keyDown keyPress keyUp load loadedData loadedMetadata loadStart lostPointerCapture mouseDown mouseMove mouseOut mouseOver mouseUp paste pause play playing pointerCancel pointerDown pointerMove pointerOut pointerOver pointerUp progress rateChange reset resize seeked seeking stalled submit suspend timeUpdate touchCancel touchEnd touchStart volumeChange scroll toggle touchMove waiting wheel".split(" ");function Er(e,t){Sr.set(e,t),rt(t,[e])}Cr.push("scrollEnd");var Nr="function"===typeof reportError?reportError:function(e){if("object"===typeof window&&"function"===typeof window.ErrorEvent){var t=new window.ErrorEvent("error",{bubbles:!0,cancelable:!0,message:"object"===typeof e&&null!==e&&"string"===typeof e.message?String(e.message):String(e),error:e});if(!window.dispatchEvent(t))return}else if("object"===typeof process&&"function"===typeof process.emit)return void process.emit("uncaughtException",e);console.error(e)},kr=[],Tr=0,Ir=0;function _r(){for(var e=Tr,t=Ir=Tr=0;t<e;){var n=kr[t];kr[t++]=null;var r=kr[t];kr[t++]=null;var s=kr[t];kr[t++]=null;var a=kr[t];if(kr[t++]=null,null!==r&&null!==s){var i=r.pending;null===i?s.next=s:(s.next=i.next,i.next=s),r.pending=s}0!==a&&jr(n,s,a)}}function Rr(e,t,n,r){kr[Tr++]=e,kr[Tr++]=t,kr[Tr++]=n,kr[Tr++]=r,Ir|=r,e.lanes|=r,null!==(e=e.alternate)&&(e.lanes|=r)}function Mr(e,t,n,r){return Rr(e,t,n,r),Or(e)}function Dr(e,t){return Rr(e,null,null,t),Or(e)}function jr(e,t,n){e.lanes|=n;var r=e.alternate;null!==r&&(r.lanes|=n);for(var s=!1,a=e.return;null!==a;)a.childLanes|=n,null!==(r=a.alternate)&&(r.childLanes|=n),22===a.tag&&(null===(e=a.stateNode)||1&e._visibility||(s=!0)),e=a,a=a.return;return 3===e.tag?(a=e.stateNode,s&&null!==t&&(s=31-Ae(n),null===(r=(e=a.hiddenUpdates)[s])?e[s]=[t]:r.push(t),t.lane=536870912|n),a):null}function Or(e){if(50<Vc)throw Vc=0,Gc=null,Error(i(185));for(var t=e.return;null!==t;)t=(e=t).return;return 3===e.tag?e.stateNode:null}var Pr={};function Lr(e,t,n,r){this.tag=e,this.key=n,this.sibling=this.child=this.return=this.stateNode=this.type=this.elementType=null,this.index=0,this.refCleanup=this.ref=null,this.pendingProps=t,this.dependencies=this.memoizedState=this.updateQueue=this.memoizedProps=null,this.mode=r,this.subtreeFlags=this.flags=0,this.deletions=null,this.childLanes=this.lanes=0,this.alternate=null}function Br(e,t,n,r){return new Lr(e,t,n,r)}function Fr(e){return!(!(e=e.prototype)||!e.isReactComponent)}function Ur(e,t){var n=e.alternate;return null===n?((n=Br(e.tag,t,e.key,e.mode)).elementType=e.elementType,n.type=e.type,n.stateNode=e.stateNode,n.alternate=e,e.alternate=n):(n.pendingProps=t,n.type=e.type,n.flags=0,n.subtreeFlags=0,n.deletions=null),n.flags=65011712&e.flags,n.childLanes=e.childLanes,n.lanes=e.lanes,n.child=e.child,n.memoizedProps=e.memoizedProps,n.memoizedState=e.memoizedState,n.updateQueue=e.updateQueue,t=e.dependencies,n.dependencies=null===t?null:{lanes:t.lanes,firstContext:t.firstContext},n.sibling=e.sibling,n.index=e.index,n.ref=e.ref,n.refCleanup=e.refCleanup,n}function Wr(e,t){e.flags&=65011714;var n=e.alternate;return null===n?(e.childLanes=0,e.lanes=t,e.child=null,e.subtreeFlags=0,e.memoizedProps=null,e.memoizedState=null,e.updateQueue=null,e.dependencies=null,e.stateNode=null):(e.childLanes=n.childLanes,e.lanes=n.lanes,e.child=n.child,e.subtreeFlags=0,e.deletions=null,e.memoizedProps=n.memoizedProps,e.memoizedState=n.memoizedState,e.updateQueue=n.updateQueue,e.type=n.type,t=n.dependencies,e.dependencies=null===t?null:{lanes:t.lanes,firstContext:t.firstContext}),e}function zr(e,t,n,r,s,a){var o=0;if(r=e,"function"===typeof e)Fr(e)&&(o=1);else if("string"===typeof e)o=function(e,t,n){if(1===n||null!=t.itemProp)return!1;switch(e){case"meta":case"title":return!0;case"style":if("string"!==typeof t.precedence||"string"!==typeof t.href||""===t.href)break;return!0;case"link":if("string"!==typeof t.rel||"string"!==typeof t.href||""===t.href||t.onLoad||t.onError)break;return"stylesheet"!==t.rel||(e=t.disabled,"string"===typeof t.precedence&&null==e);case"script":if(t.async&&"function"!==typeof t.async&&"symbol"!==typeof t.async&&!t.onLoad&&!t.onError&&t.src&&"string"===typeof t.src)return!0}return!1}(e,n,V.current)?26:"html"===e||"head"===e||"body"===e?27:5;else e:switch(e){case k:return(e=Br(31,n,t,s)).elementType=k,e.lanes=a,e;case y:return Hr(n.children,s,a,t);case w:o=8,s|=24;break;case v:return(e=Br(12,n,t,2|s)).elementType=v,e.lanes=a,e;case S:return(e=Br(13,n,t,s)).elementType=S,e.lanes=a,e;case C:return(e=Br(19,n,t,s)).elementType=C,e.lanes=a,e;default:if("object"===typeof e&&null!==e)switch(e.$$typeof){case b:o=10;break e;case A:o=9;break e;case x:o=11;break e;case E:o=14;break e;case N:o=16,r=null;break e}o=29,n=Error(i(130,null===e?"null":typeof e,"")),r=null}return(t=Br(o,n,t,s)).elementType=e,t.type=r,t.lanes=a,t}function Hr(e,t,n,r){return(e=Br(7,e,r,t)).lanes=n,e}function Vr(e,t,n){return(e=Br(6,e,null,t)).lanes=n,e}function Gr(e){var t=Br(18,null,null,0);return t.stateNode=e,t}function Jr(e,t,n){return(t=Br(4,null!==e.children?e.children:[],e.key,t)).lanes=n,t.stateNode={containerInfo:e.containerInfo,pendingChildren:null,implementation:e.implementation},t}var Qr=new WeakMap;function Kr(e,t){if("object"===typeof e&&null!==e){var n=Qr.get(e);return void 0!==n?n:(t={value:e,source:t,stack:ne(t)},Qr.set(e,t),t)}return{value:e,source:t,stack:ne(t)}}var Yr=[],qr=0,Xr=null,Zr=0,$r=[],es=0,ts=null,ns=1,rs="";function ss(e,t){Yr[qr++]=Zr,Yr[qr++]=Xr,Xr=e,Zr=t}function as(e,t,n){$r[es++]=ns,$r[es++]=rs,$r[es++]=ts,ts=e;var r=ns;e=rs;var s=32-Ae(r)-1;r&=~(1<<s),n+=1;var a=32-Ae(t)+s;if(30<a){var i=s-s%5;a=(r&(1<<i)-1).toString(32),r>>=i,s-=i,ns=1<<32-Ae(t)+s|n<<s|r,rs=a+e}else ns=1<<a|n<<s|r,rs=e}function is(e){null!==e.return&&(ss(e,1),as(e,1,0))}function os(e){for(;e===Xr;)Xr=Yr[--qr],Yr[qr]=null,Zr=Yr[--qr],Yr[qr]=null;for(;e===ts;)ts=$r[--es],$r[es]=null,rs=$r[--es],$r[es]=null,ns=$r[--es],$r[es]=null}function ls(e,t){$r[es++]=ns,$r[es++]=rs,$r[es++]=ts,ns=t.id,rs=t.overflow,ts=e}var cs=null,us=null,ds=!1,hs=null,fs=!1,ps=Error(i(519));function ms(e){throw bs(Kr(Error(i(418,1<arguments.length&&void 0!==arguments[1]&&arguments[1]?"text":"HTML","")),e)),ps}function gs(e){var t=e.stateNode,n=e.type,r=e.memoizedProps;switch(t[We]=e,t[ze]=r,n){case"dialog":qu("cancel",t),qu("close",t);break;case"iframe":case"object":case"embed":qu("load",t);break;case"video":case"audio":for(n=0;n<Qu.length;n++)qu(Qu[n],t);break;case"source":qu("error",t);break;case"img":case"image":case"link":qu("error",t),qu("load",t);break;case"details":qu("toggle",t);break;case"input":qu("invalid",t),vt(t,r.value,r.defaultValue,r.checked,r.defaultChecked,r.type,r.name,!0);break;case"select":qu("invalid",t);break;case"textarea":qu("invalid",t),St(t,r.value,r.defaultValue,r.children)}"string"!==typeof(n=r.children)&&"number"!==typeof n&&"bigint"!==typeof n||t.textContent===""+n||!0===r.suppressHydrationWarning||cd(t.textContent,n)?(null!=r.popover&&(qu("beforetoggle",t),qu("toggle",t)),null!=r.onScroll&&qu("scroll",t),null!=r.onScrollEnd&&qu("scrollend",t),null!=r.onClick&&(t.onclick=Mt),t=!0):t=!1,t||ms(e,!0)}function ys(e){for(cs=e.return;cs;)switch(cs.tag){case 5:case 31:case 13:return void(fs=!1);case 27:case 3:return void(fs=!0);default:cs=cs.return}}function ws(e){if(e!==cs)return!1;if(!ds)return ys(e),ds=!0,!1;var t,n=e.tag;if((t=3!==n&&27!==n)&&((t=5===n)&&(t=!("form"!==(t=e.type)&&"button"!==t)||vd(e.type,e.memoizedProps)),t=!t),t&&us&&ms(e),ys(e),13===n){if(!(e=null!==(e=e.memoizedState)?e.dehydrated:null))throw Error(i(317));us=Od(e)}else if(31===n){if(!(e=null!==(e=e.memoizedState)?e.dehydrated:null))throw Error(i(317));us=Od(e)}else 27===n?(n=us,Nd(e.type)?(e=jd,jd=null,us=e):us=n):us=cs?Dd(e.stateNode.nextSibling):null;return!0}function vs(){us=cs=null,ds=!1}function As(){var e=hs;return null!==e&&(null===_c?_c=e:_c.push.apply(_c,e),hs=null),e}function bs(e){null===hs?hs=[e]:hs.push(e)}var xs=F(null),Ss=null,Cs=null;function Es(e,t,n){W(xs,t._currentValue),t._currentValue=n}function Ns(e){e._currentValue=xs.current,U(xs)}function ks(e,t,n){for(;null!==e;){var r=e.alternate;if((e.childLanes&t)!==t?(e.childLanes|=t,null!==r&&(r.childLanes|=t)):null!==r&&(r.childLanes&t)!==t&&(r.childLanes|=t),e===n)break;e=e.return}}function Ts(e,t,n,r){var s=e.child;for(null!==s&&(s.return=e);null!==s;){var a=s.dependencies;if(null!==a){var o=s.child;a=a.firstContext;e:for(;null!==a;){var l=a;a=s;for(var c=0;c<t.length;c++)if(l.context===t[c]){a.lanes|=n,null!==(l=a.alternate)&&(l.lanes|=n),ks(a.return,n,e),r||(o=null);break e}a=l.next}}else if(18===s.tag){if(null===(o=s.return))throw Error(i(341));o.lanes|=n,null!==(a=o.alternate)&&(a.lanes|=n),ks(o,n,e),o=null}else o=s.child;if(null!==o)o.return=s;else for(o=s;null!==o;){if(o===e){o=null;break}if(null!==(s=o.sibling)){s.return=o.return,o=s;break}o=o.return}s=o}}function Is(e,t,n,r){e=null;for(var s=t,a=!1;null!==s;){if(!a)if(0!==(524288&s.flags))a=!0;else if(0!==(262144&s.flags))break;if(10===s.tag){var o=s.alternate;if(null===o)throw Error(i(387));if(null!==(o=o.memoizedProps)){var l=s.type;Zn(s.pendingProps.value,o.value)||(null!==e?e.push(l):e=[l])}}else if(s===Q.current){if(null===(o=s.alternate))throw Error(i(387));o.memoizedState.memoizedState!==s.memoizedState.memoizedState&&(null!==e?e.push(uh):e=[uh])}s=s.return}null!==e&&Ts(t,e,n,r),t.flags|=262144}function _s(e){for(e=e.firstContext;null!==e;){if(!Zn(e.context._currentValue,e.memoizedValue))return!0;e=e.next}return!1}function Rs(e){Ss=e,Cs=null,null!==(e=e.dependencies)&&(e.firstContext=null)}function Ms(e){return js(Ss,e)}function Ds(e,t){return null===Ss&&Rs(e),js(e,t)}function js(e,t){var n=t._currentValue;if(t={context:t,memoizedValue:n,next:null},null===Cs){if(null===e)throw Error(i(308));Cs=t,e.dependencies={lanes:0,firstContext:t},e.flags|=524288}else Cs=Cs.next=t;return n}var Os="undefined"!==typeof AbortController?AbortController:function(){var e=[],t=this.signal={aborted:!1,addEventListener:function(t,n){e.push(n)}};this.abort=function(){t.aborted=!0,e.forEach(function(e){return e()})}},Ps=r.unstable_scheduleCallback,Ls=r.unstable_NormalPriority,Bs={$$typeof:b,Consumer:null,Provider:null,_currentValue:null,_currentValue2:null,_threadCount:0};function Fs(){return{controller:new Os,data:new Map,refCount:0}}function Us(e){e.refCount--,0===e.refCount&&Ps(Ls,function(){e.controller.abort()})}var Ws=null,zs=0,Hs=0,Vs=null;function Gs(){if(0===--zs&&null!==Ws){null!==Vs&&(Vs.status="fulfilled");var e=Ws;Ws=null,Hs=0,Vs=null;for(var t=0;t<e.length;t++)(0,e[t])()}}var Js=j.S;j.S=function(e,t){Dc=le(),"object"===typeof t&&null!==t&&"function"===typeof t.then&&function(e,t){if(null===Ws){var n=Ws=[];zs=0,Hs=zu(),Vs={status:"pending",value:void 0,then:function(e){n.push(e)}}}zs++,t.then(Gs,Gs)}(0,t),null!==Js&&Js(e,t)};var Qs=F(null);function Ks(){var e=Qs.current;return null!==e?e:pc.pooledCache}function Ys(e,t){W(Qs,null===t?Qs.current:t.pool)}function qs(){var e=Ks();return null===e?null:{parent:Bs._currentValue,pool:e}}var Xs=Error(i(460)),Zs=Error(i(474)),$s=Error(i(542)),ea={then:function(){}};function ta(e){return"fulfilled"===(e=e.status)||"rejected"===e}function na(e,t,n){switch(void 0===(n=e[n])?e.push(t):n!==t&&(t.then(Mt,Mt),t=n),t.status){case"fulfilled":return t.value;case"rejected":throw ia(e=t.reason),e;default:if("string"===typeof t.status)t.then(Mt,Mt);else{if(null!==(e=pc)&&100<e.shellSuspendCounter)throw Error(i(482));(e=t).status="pending",e.then(function(e){if("pending"===t.status){var n=t;n.status="fulfilled",n.value=e}},function(e){if("pending"===t.status){var n=t;n.status="rejected",n.reason=e}})}switch(t.status){case"fulfilled":return t.value;case"rejected":throw ia(e=t.reason),e}throw sa=t,Xs}}function ra(e){try{return(0,e._init)(e._payload)}catch(t){if(null!==t&&"object"===typeof t&&"function"===typeof t.then)throw sa=t,Xs;throw t}}var sa=null;function aa(){if(null===sa)throw Error(i(459));var e=sa;return sa=null,e}function ia(e){if(e===Xs||e===$s)throw Error(i(483))}var oa=null,la=0;function ca(e){var t=la;return la+=1,null===oa&&(oa=[]),na(oa,e,t)}function ua(e,t){t=t.props.ref,e.ref=void 0!==t?t:null}function da(e,t){if(t.$$typeof===p)throw Error(i(525));throw e=Object.prototype.toString.call(t),Error(i(31,"[object Object]"===e?"object with keys {"+Object.keys(t).join(", ")+"}":e))}function ha(e){function t(t,n){if(e){var r=t.deletions;null===r?(t.deletions=[n],t.flags|=16):r.push(n)}}function n(n,r){if(!e)return null;for(;null!==r;)t(n,r),r=r.sibling;return null}function r(e){for(var t=new Map;null!==e;)null!==e.key?t.set(e.key,e):t.set(e.index,e),e=e.sibling;return t}function s(e,t){return(e=Ur(e,t)).index=0,e.sibling=null,e}function a(t,n,r){return t.index=r,e?null!==(r=t.alternate)?(r=r.index)<n?(t.flags|=67108866,n):r:(t.flags|=67108866,n):(t.flags|=1048576,n)}function o(t){return e&&null===t.alternate&&(t.flags|=67108866),t}function l(e,t,n,r){return null===t||6!==t.tag?((t=Vr(n,e.mode,r)).return=e,t):((t=s(t,n)).return=e,t)}function c(e,t,n,r){var a=n.type;return a===y?d(e,t,n.props.children,r,n.key):null!==t&&(t.elementType===a||"object"===typeof a&&null!==a&&a.$$typeof===N&&ra(a)===t.type)?(ua(t=s(t,n.props),n),t.return=e,t):(ua(t=zr(n.type,n.key,n.props,null,e.mode,r),n),t.return=e,t)}function u(e,t,n,r){return null===t||4!==t.tag||t.stateNode.containerInfo!==n.containerInfo||t.stateNode.implementation!==n.implementation?((t=Jr(n,e.mode,r)).return=e,t):((t=s(t,n.children||[])).return=e,t)}function d(e,t,n,r,a){return null===t||7!==t.tag?((t=Hr(n,e.mode,r,a)).return=e,t):((t=s(t,n)).return=e,t)}function h(e,t,n){if("string"===typeof t&&""!==t||"number"===typeof t||"bigint"===typeof t)return(t=Vr(""+t,e.mode,n)).return=e,t;if("object"===typeof t&&null!==t){switch(t.$$typeof){case m:return ua(n=zr(t.type,t.key,t.props,null,e.mode,n),t),n.return=e,n;case g:return(t=Jr(t,e.mode,n)).return=e,t;case N:return h(e,t=ra(t),n)}if(D(t)||_(t))return(t=Hr(t,e.mode,n,null)).return=e,t;if("function"===typeof t.then)return h(e,ca(t),n);if(t.$$typeof===b)return h(e,Ds(e,t),n);da(e,t)}return null}function f(e,t,n,r){var s=null!==t?t.key:null;if("string"===typeof n&&""!==n||"number"===typeof n||"bigint"===typeof n)return null!==s?null:l(e,t,""+n,r);if("object"===typeof n&&null!==n){switch(n.$$typeof){case m:return n.key===s?c(e,t,n,r):null;case g:return n.key===s?u(e,t,n,r):null;case N:return f(e,t,n=ra(n),r)}if(D(n)||_(n))return null!==s?null:d(e,t,n,r,null);if("function"===typeof n.then)return f(e,t,ca(n),r);if(n.$$typeof===b)return f(e,t,Ds(e,n),r);da(e,n)}return null}function p(e,t,n,r,s){if("string"===typeof r&&""!==r||"number"===typeof r||"bigint"===typeof r)return l(t,e=e.get(n)||null,""+r,s);if("object"===typeof r&&null!==r){switch(r.$$typeof){case m:return c(t,e=e.get(null===r.key?n:r.key)||null,r,s);case g:return u(t,e=e.get(null===r.key?n:r.key)||null,r,s);case N:return p(e,t,n,r=ra(r),s)}if(D(r)||_(r))return d(t,e=e.get(n)||null,r,s,null);if("function"===typeof r.then)return p(e,t,n,ca(r),s);if(r.$$typeof===b)return p(e,t,n,Ds(t,r),s);da(t,r)}return null}function w(l,c,u,d){if("object"===typeof u&&null!==u&&u.type===y&&null===u.key&&(u=u.props.children),"object"===typeof u&&null!==u){switch(u.$$typeof){case m:e:{for(var v=u.key;null!==c;){if(c.key===v){if((v=u.type)===y){if(7===c.tag){n(l,c.sibling),(d=s(c,u.props.children)).return=l,l=d;break e}}else if(c.elementType===v||"object"===typeof v&&null!==v&&v.$$typeof===N&&ra(v)===c.type){n(l,c.sibling),ua(d=s(c,u.props),u),d.return=l,l=d;break e}n(l,c);break}t(l,c),c=c.sibling}u.type===y?((d=Hr(u.props.children,l.mode,d,u.key)).return=l,l=d):(ua(d=zr(u.type,u.key,u.props,null,l.mode,d),u),d.return=l,l=d)}return o(l);case g:e:{for(v=u.key;null!==c;){if(c.key===v){if(4===c.tag&&c.stateNode.containerInfo===u.containerInfo&&c.stateNode.implementation===u.implementation){n(l,c.sibling),(d=s(c,u.children||[])).return=l,l=d;break e}n(l,c);break}t(l,c),c=c.sibling}(d=Jr(u,l.mode,d)).return=l,l=d}return o(l);case N:return w(l,c,u=ra(u),d)}if(D(u))return function(s,i,o,l){for(var c=null,u=null,d=i,m=i=0,g=null;null!==d&&m<o.length;m++){d.index>m?(g=d,d=null):g=d.sibling;var y=f(s,d,o[m],l);if(null===y){null===d&&(d=g);break}e&&d&&null===y.alternate&&t(s,d),i=a(y,i,m),null===u?c=y:u.sibling=y,u=y,d=g}if(m===o.length)return n(s,d),ds&&ss(s,m),c;if(null===d){for(;m<o.length;m++)null!==(d=h(s,o[m],l))&&(i=a(d,i,m),null===u?c=d:u.sibling=d,u=d);return ds&&ss(s,m),c}for(d=r(d);m<o.length;m++)null!==(g=p(d,s,m,o[m],l))&&(e&&null!==g.alternate&&d.delete(null===g.key?m:g.key),i=a(g,i,m),null===u?c=g:u.sibling=g,u=g);return e&&d.forEach(function(e){return t(s,e)}),ds&&ss(s,m),c}(l,c,u,d);if(_(u)){if("function"!==typeof(v=_(u)))throw Error(i(150));return function(s,o,l,c){if(null==l)throw Error(i(151));for(var u=null,d=null,m=o,g=o=0,y=null,w=l.next();null!==m&&!w.done;g++,w=l.next()){m.index>g?(y=m,m=null):y=m.sibling;var v=f(s,m,w.value,c);if(null===v){null===m&&(m=y);break}e&&m&&null===v.alternate&&t(s,m),o=a(v,o,g),null===d?u=v:d.sibling=v,d=v,m=y}if(w.done)return n(s,m),ds&&ss(s,g),u;if(null===m){for(;!w.done;g++,w=l.next())null!==(w=h(s,w.value,c))&&(o=a(w,o,g),null===d?u=w:d.sibling=w,d=w);return ds&&ss(s,g),u}for(m=r(m);!w.done;g++,w=l.next())null!==(w=p(m,s,g,w.value,c))&&(e&&null!==w.alternate&&m.delete(null===w.key?g:w.key),o=a(w,o,g),null===d?u=w:d.sibling=w,d=w);return e&&m.forEach(function(e){return t(s,e)}),ds&&ss(s,g),u}(l,c,u=v.call(u),d)}if("function"===typeof u.then)return w(l,c,ca(u),d);if(u.$$typeof===b)return w(l,c,Ds(l,u),d);da(l,u)}return"string"===typeof u&&""!==u||"number"===typeof u||"bigint"===typeof u?(u=""+u,null!==c&&6===c.tag?(n(l,c.sibling),(d=s(c,u)).return=l,l=d):(n(l,c),(d=Vr(u,l.mode,d)).return=l,l=d),o(l)):n(l,c)}return function(e,t,n,r){try{la=0;var s=w(e,t,n,r);return oa=null,s}catch(i){if(i===Xs||i===$s)throw i;var a=Br(29,i,null,e.mode);return a.lanes=r,a.return=e,a}}}var fa=ha(!0),pa=ha(!1),ma=!1;function ga(e){e.updateQueue={baseState:e.memoizedState,firstBaseUpdate:null,lastBaseUpdate:null,shared:{pending:null,lanes:0,hiddenCallbacks:null},callbacks:null}}function ya(e,t){e=e.updateQueue,t.updateQueue===e&&(t.updateQueue={baseState:e.baseState,firstBaseUpdate:e.firstBaseUpdate,lastBaseUpdate:e.lastBaseUpdate,shared:e.shared,callbacks:null})}function wa(e){return{lane:e,tag:0,payload:null,callback:null,next:null}}function va(e,t,n){var r=e.updateQueue;if(null===r)return null;if(r=r.shared,0!==(2&fc)){var s=r.pending;return null===s?t.next=t:(t.next=s.next,s.next=t),r.pending=t,t=Or(e),jr(e,null,n),t}return Rr(e,r,t,n),Or(e)}function Aa(e,t,n){if(null!==(t=t.updateQueue)&&(t=t.shared,0!==(4194048&n))){var r=t.lanes;n|=r&=e.pendingLanes,t.lanes=n,je(e,n)}}function ba(e,t){var n=e.updateQueue,r=e.alternate;if(null!==r&&n===(r=r.updateQueue)){var s=null,a=null;if(null!==(n=n.firstBaseUpdate)){do{var i={lane:n.lane,tag:n.tag,payload:n.payload,callback:null,next:null};null===a?s=a=i:a=a.next=i,n=n.next}while(null!==n);null===a?s=a=t:a=a.next=t}else s=a=t;return n={baseState:r.baseState,firstBaseUpdate:s,lastBaseUpdate:a,shared:r.shared,callbacks:r.callbacks},void(e.updateQueue=n)}null===(e=n.lastBaseUpdate)?n.firstBaseUpdate=t:e.next=t,n.lastBaseUpdate=t}var xa=!1;function Sa(){if(xa){if(null!==Vs)throw Vs}}function Ca(e,t,n,r){xa=!1;var s=e.updateQueue;ma=!1;var a=s.firstBaseUpdate,i=s.lastBaseUpdate,o=s.shared.pending;if(null!==o){s.shared.pending=null;var l=o,c=l.next;l.next=null,null===i?a=c:i.next=c,i=l;var u=e.alternate;null!==u&&((o=(u=u.updateQueue).lastBaseUpdate)!==i&&(null===o?u.firstBaseUpdate=c:o.next=c,u.lastBaseUpdate=l))}if(null!==a){var d=s.baseState;for(i=0,u=c=l=null,o=a;;){var h=-536870913&o.lane,p=h!==o.lane;if(p?(gc&h)===h:(r&h)===h){0!==h&&h===Hs&&(xa=!0),null!==u&&(u=u.next={lane:0,tag:o.tag,payload:o.payload,callback:null,next:null});e:{var m=e,g=o;h=t;var y=n;switch(g.tag){case 1:if("function"===typeof(m=g.payload)){d=m.call(y,d,h);break e}d=m;break e;case 3:m.flags=-65537&m.flags|128;case 0:if(null===(h="function"===typeof(m=g.payload)?m.call(y,d,h):m)||void 0===h)break e;d=f({},d,h);break e;case 2:ma=!0}}null!==(h=o.callback)&&(e.flags|=64,p&&(e.flags|=8192),null===(p=s.callbacks)?s.callbacks=[h]:p.push(h))}else p={lane:h,tag:o.tag,payload:o.payload,callback:o.callback,next:null},null===u?(c=u=p,l=d):u=u.next=p,i|=h;if(null===(o=o.next)){if(null===(o=s.shared.pending))break;o=(p=o).next,p.next=null,s.lastBaseUpdate=p,s.shared.pending=null}}null===u&&(l=d),s.baseState=l,s.firstBaseUpdate=c,s.lastBaseUpdate=u,null===a&&(s.shared.lanes=0),Cc|=i,e.lanes=i,e.memoizedState=d}}function Ea(e,t){if("function"!==typeof e)throw Error(i(191,e));e.call(t)}function Na(e,t){var n=e.callbacks;if(null!==n)for(e.callbacks=null,e=0;e<n.length;e++)Ea(n[e],t)}var ka=F(null),Ta=F(0);function Ia(e,t){W(Ta,e=xc),W(ka,t),xc=e|t.baseLanes}function _a(){W(Ta,xc),W(ka,ka.current)}function Ra(){xc=Ta.current,U(ka),U(Ta)}var Ma=F(null),Da=null;function ja(e){var t=e.alternate;W(Fa,1&Fa.current),W(Ma,e),null===Da&&(null===t||null!==ka.current||null!==t.memoizedState)&&(Da=e)}function Oa(e){W(Fa,Fa.current),W(Ma,e),null===Da&&(Da=e)}function Pa(e){22===e.tag?(W(Fa,Fa.current),W(Ma,e),null===Da&&(Da=e)):La()}function La(){W(Fa,Fa.current),W(Ma,Ma.current)}function Ba(e){U(Ma),Da===e&&(Da=null),U(Fa)}var Fa=F(0);function Ua(e){for(var t=e;null!==t;){if(13===t.tag){var n=t.memoizedState;if(null!==n&&(null===(n=n.dehydrated)||Rd(n)||Md(n)))return t}else if(19!==t.tag||"forwards"!==t.memoizedProps.revealOrder&&"backwards"!==t.memoizedProps.revealOrder&&"unstable_legacy-backwards"!==t.memoizedProps.revealOrder&&"together"!==t.memoizedProps.revealOrder){if(null!==t.child){t.child.return=t,t=t.child;continue}}else if(0!==(128&t.flags))return t;if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return null;t=t.return}t.sibling.return=t.return,t=t.sibling}return null}var Wa=0,za=null,Ha=null,Va=null,Ga=!1,Ja=!1,Qa=!1,Ka=0,Ya=0,qa=null,Xa=0;function Za(){throw Error(i(321))}function $a(e,t){if(null===t)return!1;for(var n=0;n<t.length&&n<e.length;n++)if(!Zn(e[n],t[n]))return!1;return!0}function ei(e,t,n,r,s,a){return Wa=a,za=t,t.memoizedState=null,t.updateQueue=null,t.lanes=0,j.H=null===e||null===e.memoizedState?go:yo,Qa=!1,a=n(r,s),Qa=!1,Ja&&(a=ni(t,n,r,s)),ti(e),a}function ti(e){j.H=mo;var t=null!==Ha&&null!==Ha.next;if(Wa=0,Va=Ha=za=null,Ga=!1,Ya=0,qa=null,t)throw Error(i(300));null===e||Do||null!==(e=e.dependencies)&&_s(e)&&(Do=!0)}function ni(e,t,n,r){za=e;var s=0;do{if(Ja&&(qa=null),Ya=0,Ja=!1,25<=s)throw Error(i(301));if(s+=1,Va=Ha=null,null!=e.updateQueue){var a=e.updateQueue;a.lastEffect=null,a.events=null,a.stores=null,null!=a.memoCache&&(a.memoCache.index=0)}j.H=wo,a=t(n,r)}while(Ja);return a}function ri(){var e=j.H,t=e.useState()[0];return t="function"===typeof t.then?ci(t):t,e=e.useState()[0],(null!==Ha?Ha.memoizedState:null)!==e&&(za.flags|=1024),t}function si(){var e=0!==Ka;return Ka=0,e}function ai(e,t,n){t.updateQueue=e.updateQueue,t.flags&=-2053,e.lanes&=~n}function ii(e){if(Ga){for(e=e.memoizedState;null!==e;){var t=e.queue;null!==t&&(t.pending=null),e=e.next}Ga=!1}Wa=0,Va=Ha=za=null,Ja=!1,Ya=Ka=0,qa=null}function oi(){var e={memoizedState:null,baseState:null,baseQueue:null,queue:null,next:null};return null===Va?za.memoizedState=Va=e:Va=Va.next=e,Va}function li(){if(null===Ha){var e=za.alternate;e=null!==e?e.memoizedState:null}else e=Ha.next;var t=null===Va?za.memoizedState:Va.next;if(null!==t)Va=t,Ha=e;else{if(null===e){if(null===za.alternate)throw Error(i(467));throw Error(i(310))}e={memoizedState:(Ha=e).memoizedState,baseState:Ha.baseState,baseQueue:Ha.baseQueue,queue:Ha.queue,next:null},null===Va?za.memoizedState=Va=e:Va=Va.next=e}return Va}function ci(e){var t=Ya;return Ya+=1,null===qa&&(qa=[]),e=na(qa,e,t),t=za,null===(null===Va?t.memoizedState:Va.next)&&(t=t.alternate,j.H=null===t||null===t.memoizedState?go:yo),e}function ui(e){if(null!==e&&"object"===typeof e){if("function"===typeof e.then)return ci(e);if(e.$$typeof===b)return Ms(e)}throw Error(i(438,String(e)))}function di(e){var t=null,n=za.updateQueue;if(null!==n&&(t=n.memoCache),null==t){var r=za.alternate;null!==r&&(null!==(r=r.updateQueue)&&(null!=(r=r.memoCache)&&(t={data:r.data.map(function(e){return e.slice()}),index:0})))}if(null==t&&(t={data:[],index:0}),null===n&&(n={lastEffect:null,events:null,stores:null,memoCache:null},za.updateQueue=n),n.memoCache=t,void 0===(n=t.data[t.index]))for(n=t.data[t.index]=Array(e),r=0;r<e;r++)n[r]=T;return t.index++,n}function hi(e,t){return"function"===typeof t?t(e):t}function fi(e){return pi(li(),Ha,e)}function pi(e,t,n){var r=e.queue;if(null===r)throw Error(i(311));r.lastRenderedReducer=n;var s=e.baseQueue,a=r.pending;if(null!==a){if(null!==s){var o=s.next;s.next=a.next,a.next=o}t.baseQueue=s=a,r.pending=null}if(a=e.baseState,null===s)e.memoizedState=a;else{var l=o=null,c=null,u=t=s.next,d=!1;do{var h=-536870913&u.lane;if(h!==u.lane?(gc&h)===h:(Wa&h)===h){var f=u.revertLane;if(0===f)null!==c&&(c=c.next={lane:0,revertLane:0,gesture:null,action:u.action,hasEagerState:u.hasEagerState,eagerState:u.eagerState,next:null}),h===Hs&&(d=!0);else{if((Wa&f)===f){u=u.next,f===Hs&&(d=!0);continue}h={lane:0,revertLane:u.revertLane,gesture:null,action:u.action,hasEagerState:u.hasEagerState,eagerState:u.eagerState,next:null},null===c?(l=c=h,o=a):c=c.next=h,za.lanes|=f,Cc|=f}h=u.action,Qa&&n(a,h),a=u.hasEagerState?u.eagerState:n(a,h)}else f={lane:h,revertLane:u.revertLane,gesture:u.gesture,action:u.action,hasEagerState:u.hasEagerState,eagerState:u.eagerState,next:null},null===c?(l=c=f,o=a):c=c.next=f,za.lanes|=h,Cc|=h;u=u.next}while(null!==u&&u!==t);if(null===c?o=a:c.next=l,!Zn(a,e.memoizedState)&&(Do=!0,d&&null!==(n=Vs)))throw n;e.memoizedState=a,e.baseState=o,e.baseQueue=c,r.lastRenderedState=a}return null===s&&(r.lanes=0),[e.memoizedState,r.dispatch]}function mi(e){var t=li(),n=t.queue;if(null===n)throw Error(i(311));n.lastRenderedReducer=e;var r=n.dispatch,s=n.pending,a=t.memoizedState;if(null!==s){n.pending=null;var o=s=s.next;do{a=e(a,o.action),o=o.next}while(o!==s);Zn(a,t.memoizedState)||(Do=!0),t.memoizedState=a,null===t.baseQueue&&(t.baseState=a),n.lastRenderedState=a}return[a,r]}function gi(e,t,n){var r=za,s=li(),a=ds;if(a){if(void 0===n)throw Error(i(407));n=n()}else n=t();var o=!Zn((Ha||s).memoizedState,n);if(o&&(s.memoizedState=n,Do=!0),s=s.queue,Wi(vi.bind(null,r,s,e),[e]),s.getSnapshot!==t||o||null!==Va&&1&Va.memoizedState.tag){if(r.flags|=2048,Pi(9,{destroy:void 0},wi.bind(null,r,s,n,t),null),null===pc)throw Error(i(349));a||0!==(127&Wa)||yi(r,t,n)}return n}function yi(e,t,n){e.flags|=16384,e={getSnapshot:t,value:n},null===(t=za.updateQueue)?(t={lastEffect:null,events:null,stores:null,memoCache:null},za.updateQueue=t,t.stores=[e]):null===(n=t.stores)?t.stores=[e]:n.push(e)}function wi(e,t,n,r){t.value=n,t.getSnapshot=r,Ai(t)&&bi(e)}function vi(e,t,n){return n(function(){Ai(t)&&bi(e)})}function Ai(e){var t=e.getSnapshot;e=e.value;try{var n=t();return!Zn(e,n)}catch(r){return!0}}function bi(e){var t=Dr(e,2);null!==t&&Kc(t,e,2)}function xi(e){var t=oi();if("function"===typeof e){var n=e;if(e=n(),Qa){ve(!0);try{n()}finally{ve(!1)}}}return t.memoizedState=t.baseState=e,t.queue={pending:null,lanes:0,dispatch:null,lastRenderedReducer:hi,lastRenderedState:e},t}function Si(e,t,n,r){return e.baseState=n,pi(e,Ha,"function"===typeof r?r:hi)}function Ci(e,t,n,r,s){if(ho(e))throw Error(i(485));if(null!==(e=t.action)){var a={payload:s,action:e,next:null,isTransition:!0,status:"pending",value:null,reason:null,listeners:[],then:function(e){a.listeners.push(e)}};null!==j.T?n(!0):a.isTransition=!1,r(a),null===(n=t.pending)?(a.next=t.pending=a,Ei(t,a)):(a.next=n.next,t.pending=n.next=a)}}function Ei(e,t){var n=t.action,r=t.payload,s=e.state;if(t.isTransition){var a=j.T,i={};j.T=i;try{var o=n(s,r),l=j.S;null!==l&&l(i,o),Ni(e,t,o)}catch(c){Ti(e,t,c)}finally{null!==a&&null!==i.types&&(a.types=i.types),j.T=a}}else try{Ni(e,t,a=n(s,r))}catch(u){Ti(e,t,u)}}function Ni(e,t,n){null!==n&&"object"===typeof n&&"function"===typeof n.then?n.then(function(n){ki(e,t,n)},function(n){return Ti(e,t,n)}):ki(e,t,n)}function ki(e,t,n){t.status="fulfilled",t.value=n,Ii(t),e.state=n,null!==(t=e.pending)&&((n=t.next)===t?e.pending=null:(n=n.next,t.next=n,Ei(e,n)))}function Ti(e,t,n){var r=e.pending;if(e.pending=null,null!==r){r=r.next;do{t.status="rejected",t.reason=n,Ii(t),t=t.next}while(t!==r)}e.action=null}function Ii(e){e=e.listeners;for(var t=0;t<e.length;t++)(0,e[t])()}function _i(e,t){return t}function Ri(e,t){if(ds){var n=pc.formState;if(null!==n){e:{var r=za;if(ds){if(us){t:{for(var s=us,a=fs;8!==s.nodeType;){if(!a){s=null;break t}if(null===(s=Dd(s.nextSibling))){s=null;break t}}s="F!"===(a=s.data)||"F"===a?s:null}if(s){us=Dd(s.nextSibling),r="F!"===s.data;break e}}ms(r)}r=!1}r&&(t=n[0])}}return(n=oi()).memoizedState=n.baseState=t,r={pending:null,lanes:0,dispatch:null,lastRenderedReducer:_i,lastRenderedState:t},n.queue=r,n=lo.bind(null,za,r),r.dispatch=n,r=xi(!1),a=uo.bind(null,za,!1,r.queue),s={state:t,dispatch:null,action:e,pending:null},(r=oi()).queue=s,n=Ci.bind(null,za,s,a,n),s.dispatch=n,r.memoizedState=e,[t,n,!1]}function Mi(e){return Di(li(),Ha,e)}function Di(e,t,n){if(t=pi(e,t,_i)[0],e=fi(hi)[0],"object"===typeof t&&null!==t&&"function"===typeof t.then)try{var r=ci(t)}catch(i){if(i===Xs)throw $s;throw i}else r=t;var s=(t=li()).queue,a=s.dispatch;return n!==t.memoizedState&&(za.flags|=2048,Pi(9,{destroy:void 0},ji.bind(null,s,n),null)),[r,a,e]}function ji(e,t){e.action=t}function Oi(e){var t=li(),n=Ha;if(null!==n)return Di(t,n,e);li(),t=t.memoizedState;var r=(n=li()).queue.dispatch;return n.memoizedState=e,[t,r,!1]}function Pi(e,t,n,r){return e={tag:e,create:n,deps:r,inst:t,next:null},null===(t=za.updateQueue)&&(t={lastEffect:null,events:null,stores:null,memoCache:null},za.updateQueue=t),null===(n=t.lastEffect)?t.lastEffect=e.next=e:(r=n.next,n.next=e,e.next=r,t.lastEffect=e),e}function Li(){return li().memoizedState}function Bi(e,t,n,r){var s=oi();za.flags|=e,s.memoizedState=Pi(1|t,{destroy:void 0},n,void 0===r?null:r)}function Fi(e,t,n,r){var s=li();r=void 0===r?null:r;var a=s.memoizedState.inst;null!==Ha&&null!==r&&$a(r,Ha.memoizedState.deps)?s.memoizedState=Pi(t,a,n,r):(za.flags|=e,s.memoizedState=Pi(1|t,a,n,r))}function Ui(e,t){Bi(8390656,8,e,t)}function Wi(e,t){Fi(2048,8,e,t)}function zi(e){var t=li().memoizedState;return function(e){za.flags|=4;var t=za.updateQueue;if(null===t)t={lastEffect:null,events:null,stores:null,memoCache:null},za.updateQueue=t,t.events=[e];else{var n=t.events;null===n?t.events=[e]:n.push(e)}}({ref:t,nextImpl:e}),function(){if(0!==(2&fc))throw Error(i(440));return t.impl.apply(void 0,arguments)}}function Hi(e,t){return Fi(4,2,e,t)}function Vi(e,t){return Fi(4,4,e,t)}function Gi(e,t){if("function"===typeof t){e=e();var n=t(e);return function(){"function"===typeof n?n():t(null)}}if(null!==t&&void 0!==t)return e=e(),t.current=e,function(){t.current=null}}function Ji(e,t,n){n=null!==n&&void 0!==n?n.concat([e]):null,Fi(4,4,Gi.bind(null,t,e),n)}function Qi(){}function Ki(e,t){var n=li();t=void 0===t?null:t;var r=n.memoizedState;return null!==t&&$a(t,r[1])?r[0]:(n.memoizedState=[e,t],e)}function Yi(e,t){var n=li();t=void 0===t?null:t;var r=n.memoizedState;if(null!==t&&$a(t,r[1]))return r[0];if(r=e(),Qa){ve(!0);try{e()}finally{ve(!1)}}return n.memoizedState=[r,t],r}function qi(e,t,n){return void 0===n||0!==(1073741824&Wa)&&0===(261930&gc)?e.memoizedState=t:(e.memoizedState=n,e=Qc(),za.lanes|=e,Cc|=e,n)}function Xi(e,t,n,r){return Zn(n,t)?n:null!==ka.current?(e=qi(e,n,r),Zn(e,t)||(Do=!0),e):0===(42&Wa)||0!==(1073741824&Wa)&&0===(261930&gc)?(Do=!0,e.memoizedState=n):(e=Qc(),za.lanes|=e,Cc|=e,t)}function Zi(e,t,n,r,s){var a=O.p;O.p=0!==a&&8>a?a:8;var i=j.T,o={};j.T=o,uo(e,!1,t,n);try{var l=s(),c=j.S;if(null!==c&&c(o,l),null!==l&&"object"===typeof l&&"function"===typeof l.then)co(e,t,function(e,t){var n=[],r={status:"pending",value:null,reason:null,then:function(e){n.push(e)}};return e.then(function(){r.status="fulfilled",r.value=t;for(var e=0;e<n.length;e++)(0,n[e])(t)},function(e){for(r.status="rejected",r.reason=e,e=0;e<n.length;e++)(0,n[e])(void 0)}),r}(l,r),Jc());else co(e,t,r,Jc())}catch(u){co(e,t,{then:function(){},status:"rejected",reason:u},Jc())}finally{O.p=a,null!==i&&null!==o.types&&(i.types=o.types),j.T=i}}function $i(){}function eo(e,t,n,r){if(5!==e.tag)throw Error(i(476));var s=to(e).queue;Zi(e,s,t,P,null===n?$i:function(){return no(e),n(r)})}function to(e){var t=e.memoizedState;if(null!==t)return t;var n={};return(t={memoizedState:P,baseState:P,baseQueue:null,queue:{pending:null,lanes:0,dispatch:null,lastRenderedReducer:hi,lastRenderedState:P},next:null}).next={memoizedState:n,baseState:n,baseQueue:null,queue:{pending:null,lanes:0,dispatch:null,lastRenderedReducer:hi,lastRenderedState:n},next:null},e.memoizedState=t,null!==(e=e.alternate)&&(e.memoizedState=t),t}function no(e){var t=to(e);null===t.next&&(t=e.alternate.memoizedState),co(e,t.next.queue,{},Jc())}function ro(){return Ms(uh)}function so(){return li().memoizedState}function ao(){return li().memoizedState}function io(e){for(var t=e.return;null!==t;){switch(t.tag){case 24:case 3:var n=Jc(),r=va(t,e=wa(n),n);return null!==r&&(Kc(r,t,n),Aa(r,t,n)),t={cache:Fs()},void(e.payload=t)}t=t.return}}function oo(e,t,n){var r=Jc();n={lane:r,revertLane:0,gesture:null,action:n,hasEagerState:!1,eagerState:null,next:null},ho(e)?fo(t,n):null!==(n=Mr(e,t,n,r))&&(Kc(n,e,r),po(n,t,r))}function lo(e,t,n){co(e,t,n,Jc())}function co(e,t,n,r){var s={lane:r,revertLane:0,gesture:null,action:n,hasEagerState:!1,eagerState:null,next:null};if(ho(e))fo(t,s);else{var a=e.alternate;if(0===e.lanes&&(null===a||0===a.lanes)&&null!==(a=t.lastRenderedReducer))try{var i=t.lastRenderedState,o=a(i,n);if(s.hasEagerState=!0,s.eagerState=o,Zn(o,i))return Rr(e,t,s,0),null===pc&&_r(),!1}catch(l){}if(null!==(n=Mr(e,t,s,r)))return Kc(n,e,r),po(n,t,r),!0}return!1}function uo(e,t,n,r){if(r={lane:2,revertLane:zu(),gesture:null,action:r,hasEagerState:!1,eagerState:null,next:null},ho(e)){if(t)throw Error(i(479))}else null!==(t=Mr(e,n,r,2))&&Kc(t,e,2)}function ho(e){var t=e.alternate;return e===za||null!==t&&t===za}function fo(e,t){Ja=Ga=!0;var n=e.pending;null===n?t.next=t:(t.next=n.next,n.next=t),e.pending=t}function po(e,t,n){if(0!==(4194048&n)){var r=t.lanes;n|=r&=e.pendingLanes,t.lanes=n,je(e,n)}}var mo={readContext:Ms,use:ui,useCallback:Za,useContext:Za,useEffect:Za,useImperativeHandle:Za,useLayoutEffect:Za,useInsertionEffect:Za,useMemo:Za,useReducer:Za,useRef:Za,useState:Za,useDebugValue:Za,useDeferredValue:Za,useTransition:Za,useSyncExternalStore:Za,useId:Za,useHostTransitionStatus:Za,useFormState:Za,useActionState:Za,useOptimistic:Za,useMemoCache:Za,useCacheRefresh:Za};mo.useEffectEvent=Za;var go={readContext:Ms,use:ui,useCallback:function(e,t){return oi().memoizedState=[e,void 0===t?null:t],e},useContext:Ms,useEffect:Ui,useImperativeHandle:function(e,t,n){n=null!==n&&void 0!==n?n.concat([e]):null,Bi(4194308,4,Gi.bind(null,t,e),n)},useLayoutEffect:function(e,t){return Bi(4194308,4,e,t)},useInsertionEffect:function(e,t){Bi(4,2,e,t)},useMemo:function(e,t){var n=oi();t=void 0===t?null:t;var r=e();if(Qa){ve(!0);try{e()}finally{ve(!1)}}return n.memoizedState=[r,t],r},useReducer:function(e,t,n){var r=oi();if(void 0!==n){var s=n(t);if(Qa){ve(!0);try{n(t)}finally{ve(!1)}}}else s=t;return r.memoizedState=r.baseState=s,e={pending:null,lanes:0,dispatch:null,lastRenderedReducer:e,lastRenderedState:s},r.queue=e,e=e.dispatch=oo.bind(null,za,e),[r.memoizedState,e]},useRef:function(e){return e={current:e},oi().memoizedState=e},useState:function(e){var t=(e=xi(e)).queue,n=lo.bind(null,za,t);return t.dispatch=n,[e.memoizedState,n]},useDebugValue:Qi,useDeferredValue:function(e,t){return qi(oi(),e,t)},useTransition:function(){var e=xi(!1);return e=Zi.bind(null,za,e.queue,!0,!1),oi().memoizedState=e,[!1,e]},useSyncExternalStore:function(e,t,n){var r=za,s=oi();if(ds){if(void 0===n)throw Error(i(407));n=n()}else{if(n=t(),null===pc)throw Error(i(349));0!==(127&gc)||yi(r,t,n)}s.memoizedState=n;var a={value:n,getSnapshot:t};return s.queue=a,Ui(vi.bind(null,r,a,e),[e]),r.flags|=2048,Pi(9,{destroy:void 0},wi.bind(null,r,a,n,t),null),n},useId:function(){var e=oi(),t=pc.identifierPrefix;if(ds){var n=rs;t="_"+t+"R_"+(n=(ns&~(1<<32-Ae(ns)-1)).toString(32)+n),0<(n=Ka++)&&(t+="H"+n.toString(32)),t+="_"}else t="_"+t+"r_"+(n=Xa++).toString(32)+"_";return e.memoizedState=t},useHostTransitionStatus:ro,useFormState:Ri,useActionState:Ri,useOptimistic:function(e){var t=oi();t.memoizedState=t.baseState=e;var n={pending:null,lanes:0,dispatch:null,lastRenderedReducer:null,lastRenderedState:null};return t.queue=n,t=uo.bind(null,za,!0,n),n.dispatch=t,[e,t]},useMemoCache:di,useCacheRefresh:function(){return oi().memoizedState=io.bind(null,za)},useEffectEvent:function(e){var t=oi(),n={impl:e};return t.memoizedState=n,function(){if(0!==(2&fc))throw Error(i(440));return n.impl.apply(void 0,arguments)}}},yo={readContext:Ms,use:ui,useCallback:Ki,useContext:Ms,useEffect:Wi,useImperativeHandle:Ji,useInsertionEffect:Hi,useLayoutEffect:Vi,useMemo:Yi,useReducer:fi,useRef:Li,useState:function(){return fi(hi)},useDebugValue:Qi,useDeferredValue:function(e,t){return Xi(li(),Ha.memoizedState,e,t)},useTransition:function(){var e=fi(hi)[0],t=li().memoizedState;return["boolean"===typeof e?e:ci(e),t]},useSyncExternalStore:gi,useId:so,useHostTransitionStatus:ro,useFormState:Mi,useActionState:Mi,useOptimistic:function(e,t){return Si(li(),0,e,t)},useMemoCache:di,useCacheRefresh:ao};yo.useEffectEvent=zi;var wo={readContext:Ms,use:ui,useCallback:Ki,useContext:Ms,useEffect:Wi,useImperativeHandle:Ji,useInsertionEffect:Hi,useLayoutEffect:Vi,useMemo:Yi,useReducer:mi,useRef:Li,useState:function(){return mi(hi)},useDebugValue:Qi,useDeferredValue:function(e,t){var n=li();return null===Ha?qi(n,e,t):Xi(n,Ha.memoizedState,e,t)},useTransition:function(){var e=mi(hi)[0],t=li().memoizedState;return["boolean"===typeof e?e:ci(e),t]},useSyncExternalStore:gi,useId:so,useHostTransitionStatus:ro,useFormState:Oi,useActionState:Oi,useOptimistic:function(e,t){var n=li();return null!==Ha?Si(n,0,e,t):(n.baseState=e,[e,n.queue.dispatch])},useMemoCache:di,useCacheRefresh:ao};function vo(e,t,n,r){n=null===(n=n(r,t=e.memoizedState))||void 0===n?t:f({},t,n),e.memoizedState=n,0===e.lanes&&(e.updateQueue.baseState=n)}wo.useEffectEvent=zi;var Ao={enqueueSetState:function(e,t,n){e=e._reactInternals;var r=Jc(),s=wa(r);s.payload=t,void 0!==n&&null!==n&&(s.callback=n),null!==(t=va(e,s,r))&&(Kc(t,e,r),Aa(t,e,r))},enqueueReplaceState:function(e,t,n){e=e._reactInternals;var r=Jc(),s=wa(r);s.tag=1,s.payload=t,void 0!==n&&null!==n&&(s.callback=n),null!==(t=va(e,s,r))&&(Kc(t,e,r),Aa(t,e,r))},enqueueForceUpdate:function(e,t){e=e._reactInternals;var n=Jc(),r=wa(n);r.tag=2,void 0!==t&&null!==t&&(r.callback=t),null!==(t=va(e,r,n))&&(Kc(t,e,n),Aa(t,e,n))}};function bo(e,t,n,r,s,a,i){return"function"===typeof(e=e.stateNode).shouldComponentUpdate?e.shouldComponentUpdate(r,a,i):!t.prototype||!t.prototype.isPureReactComponent||(!$n(n,r)||!$n(s,a))}function xo(e,t,n,r){e=t.state,"function"===typeof t.componentWillReceiveProps&&t.componentWillReceiveProps(n,r),"function"===typeof t.UNSAFE_componentWillReceiveProps&&t.UNSAFE_componentWillReceiveProps(n,r),t.state!==e&&Ao.enqueueReplaceState(t,t.state,null)}function So(e,t){var n=t;if("ref"in t)for(var r in n={},t)"ref"!==r&&(n[r]=t[r]);if(e=e.defaultProps)for(var s in n===t&&(n=f({},n)),e)void 0===n[s]&&(n[s]=e[s]);return n}function Co(e){Nr(e)}function Eo(e){console.error(e)}function No(e){Nr(e)}function ko(e,t){try{(0,e.onUncaughtError)(t.value,{componentStack:t.stack})}catch(n){setTimeout(function(){throw n})}}function To(e,t,n){try{(0,e.onCaughtError)(n.value,{componentStack:n.stack,errorBoundary:1===t.tag?t.stateNode:null})}catch(r){setTimeout(function(){throw r})}}function Io(e,t,n){return(n=wa(n)).tag=3,n.payload={element:null},n.callback=function(){ko(e,t)},n}function _o(e){return(e=wa(e)).tag=3,e}function Ro(e,t,n,r){var s=n.type.getDerivedStateFromError;if("function"===typeof s){var a=r.value;e.payload=function(){return s(a)},e.callback=function(){To(t,n,r)}}var i=n.stateNode;null!==i&&"function"===typeof i.componentDidCatch&&(e.callback=function(){To(t,n,r),"function"!==typeof s&&(null===Pc?Pc=new Set([this]):Pc.add(this));var e=r.stack;this.componentDidCatch(r.value,{componentStack:null!==e?e:""})})}var Mo=Error(i(461)),Do=!1;function jo(e,t,n,r){t.child=null===e?pa(t,null,n,r):fa(t,e.child,n,r)}function Oo(e,t,n,r,s){n=n.render;var a=t.ref;if("ref"in r){var i={};for(var o in r)"ref"!==o&&(i[o]=r[o])}else i=r;return Rs(t),r=ei(e,t,n,i,a,s),o=si(),null===e||Do?(ds&&o&&is(t),t.flags|=1,jo(e,t,r,s),t.child):(ai(e,t,s),sl(e,t,s))}function Po(e,t,n,r,s){if(null===e){var a=n.type;return"function"!==typeof a||Fr(a)||void 0!==a.defaultProps||null!==n.compare?((e=zr(n.type,null,r,t,t.mode,s)).ref=t.ref,e.return=t,t.child=e):(t.tag=15,t.type=a,Lo(e,t,a,r,s))}if(a=e.child,!al(e,s)){var i=a.memoizedProps;if((n=null!==(n=n.compare)?n:$n)(i,r)&&e.ref===t.ref)return sl(e,t,s)}return t.flags|=1,(e=Ur(a,r)).ref=t.ref,e.return=t,t.child=e}function Lo(e,t,n,r,s){if(null!==e){var a=e.memoizedProps;if($n(a,r)&&e.ref===t.ref){if(Do=!1,t.pendingProps=r=a,!al(e,s))return t.lanes=e.lanes,sl(e,t,s);0!==(131072&e.flags)&&(Do=!0)}}return Vo(e,t,n,r,s)}function Bo(e,t,n,r){var s=r.children,a=null!==e?e.memoizedState:null;if(null===e&&null===t.stateNode&&(t.stateNode={_visibility:1,_pendingMarkers:null,_retryCache:null,_transitions:null}),"hidden"===r.mode){if(0!==(128&t.flags)){if(a=null!==a?a.baseLanes|n:n,null!==e){for(r=t.child=e.child,s=0;null!==r;)s=s|r.lanes|r.childLanes,r=r.sibling;r=s&~a}else r=0,t.child=null;return Uo(e,t,a,n,r)}if(0===(536870912&n))return r=t.lanes=536870912,Uo(e,t,null!==a?a.baseLanes|n:n,n,r);t.memoizedState={baseLanes:0,cachePool:null},null!==e&&Ys(0,null!==a?a.cachePool:null),null!==a?Ia(t,a):_a(),Pa(t)}else null!==a?(Ys(0,a.cachePool),Ia(t,a),La(),t.memoizedState=null):(null!==e&&Ys(0,null),_a(),La());return jo(e,t,s,n),t.child}function Fo(e,t){return null!==e&&22===e.tag||null!==t.stateNode||(t.stateNode={_visibility:1,_pendingMarkers:null,_retryCache:null,_transitions:null}),t.sibling}function Uo(e,t,n,r,s){var a=Ks();return a=null===a?null:{parent:Bs._currentValue,pool:a},t.memoizedState={baseLanes:n,cachePool:a},null!==e&&Ys(0,null),_a(),Pa(t),null!==e&&Is(e,t,r,!0),t.childLanes=s,null}function Wo(e,t){return(t=$o({mode:t.mode,children:t.children},e.mode)).ref=e.ref,e.child=t,t.return=e,t}function zo(e,t,n){return fa(t,e.child,null,n),(e=Wo(t,t.pendingProps)).flags|=2,Ba(t),t.memoizedState=null,e}function Ho(e,t){var n=t.ref;if(null===n)null!==e&&null!==e.ref&&(t.flags|=4194816);else{if("function"!==typeof n&&"object"!==typeof n)throw Error(i(284));null!==e&&e.ref===n||(t.flags|=4194816)}}function Vo(e,t,n,r,s){return Rs(t),n=ei(e,t,n,r,void 0,s),r=si(),null===e||Do?(ds&&r&&is(t),t.flags|=1,jo(e,t,n,s),t.child):(ai(e,t,s),sl(e,t,s))}function Go(e,t,n,r,s,a){return Rs(t),t.updateQueue=null,n=ni(t,r,n,s),ti(e),r=si(),null===e||Do?(ds&&r&&is(t),t.flags|=1,jo(e,t,n,a),t.child):(ai(e,t,a),sl(e,t,a))}function Jo(e,t,n,r,s){if(Rs(t),null===t.stateNode){var a=Pr,i=n.contextType;"object"===typeof i&&null!==i&&(a=Ms(i)),a=new n(r,a),t.memoizedState=null!==a.state&&void 0!==a.state?a.state:null,a.updater=Ao,t.stateNode=a,a._reactInternals=t,(a=t.stateNode).props=r,a.state=t.memoizedState,a.refs={},ga(t),i=n.contextType,a.context="object"===typeof i&&null!==i?Ms(i):Pr,a.state=t.memoizedState,"function"===typeof(i=n.getDerivedStateFromProps)&&(vo(t,n,i,r),a.state=t.memoizedState),"function"===typeof n.getDerivedStateFromProps||"function"===typeof a.getSnapshotBeforeUpdate||"function"!==typeof a.UNSAFE_componentWillMount&&"function"!==typeof a.componentWillMount||(i=a.state,"function"===typeof a.componentWillMount&&a.componentWillMount(),"function"===typeof a.UNSAFE_componentWillMount&&a.UNSAFE_componentWillMount(),i!==a.state&&Ao.enqueueReplaceState(a,a.state,null),Ca(t,r,a,s),Sa(),a.state=t.memoizedState),"function"===typeof a.componentDidMount&&(t.flags|=4194308),r=!0}else if(null===e){a=t.stateNode;var o=t.memoizedProps,l=So(n,o);a.props=l;var c=a.context,u=n.contextType;i=Pr,"object"===typeof u&&null!==u&&(i=Ms(u));var d=n.getDerivedStateFromProps;u="function"===typeof d||"function"===typeof a.getSnapshotBeforeUpdate,o=t.pendingProps!==o,u||"function"!==typeof a.UNSAFE_componentWillReceiveProps&&"function"!==typeof a.componentWillReceiveProps||(o||c!==i)&&xo(t,a,r,i),ma=!1;var h=t.memoizedState;a.state=h,Ca(t,r,a,s),Sa(),c=t.memoizedState,o||h!==c||ma?("function"===typeof d&&(vo(t,n,d,r),c=t.memoizedState),(l=ma||bo(t,n,l,r,h,c,i))?(u||"function"!==typeof a.UNSAFE_componentWillMount&&"function"!==typeof a.componentWillMount||("function"===typeof a.componentWillMount&&a.componentWillMount(),"function"===typeof a.UNSAFE_componentWillMount&&a.UNSAFE_componentWillMount()),"function"===typeof a.componentDidMount&&(t.flags|=4194308)):("function"===typeof a.componentDidMount&&(t.flags|=4194308),t.memoizedProps=r,t.memoizedState=c),a.props=r,a.state=c,a.context=i,r=l):("function"===typeof a.componentDidMount&&(t.flags|=4194308),r=!1)}else{a=t.stateNode,ya(e,t),u=So(n,i=t.memoizedProps),a.props=u,d=t.pendingProps,h=a.context,c=n.contextType,l=Pr,"object"===typeof c&&null!==c&&(l=Ms(c)),(c="function"===typeof(o=n.getDerivedStateFromProps)||"function"===typeof a.getSnapshotBeforeUpdate)||"function"!==typeof a.UNSAFE_componentWillReceiveProps&&"function"!==typeof a.componentWillReceiveProps||(i!==d||h!==l)&&xo(t,a,r,l),ma=!1,h=t.memoizedState,a.state=h,Ca(t,r,a,s),Sa();var f=t.memoizedState;i!==d||h!==f||ma||null!==e&&null!==e.dependencies&&_s(e.dependencies)?("function"===typeof o&&(vo(t,n,o,r),f=t.memoizedState),(u=ma||bo(t,n,u,r,h,f,l)||null!==e&&null!==e.dependencies&&_s(e.dependencies))?(c||"function"!==typeof a.UNSAFE_componentWillUpdate&&"function"!==typeof a.componentWillUpdate||("function"===typeof a.componentWillUpdate&&a.componentWillUpdate(r,f,l),"function"===typeof a.UNSAFE_componentWillUpdate&&a.UNSAFE_componentWillUpdate(r,f,l)),"function"===typeof a.componentDidUpdate&&(t.flags|=4),"function"===typeof a.getSnapshotBeforeUpdate&&(t.flags|=1024)):("function"!==typeof a.componentDidUpdate||i===e.memoizedProps&&h===e.memoizedState||(t.flags|=4),"function"!==typeof a.getSnapshotBeforeUpdate||i===e.memoizedProps&&h===e.memoizedState||(t.flags|=1024),t.memoizedProps=r,t.memoizedState=f),a.props=r,a.state=f,a.context=l,r=u):("function"!==typeof a.componentDidUpdate||i===e.memoizedProps&&h===e.memoizedState||(t.flags|=4),"function"!==typeof a.getSnapshotBeforeUpdate||i===e.memoizedProps&&h===e.memoizedState||(t.flags|=1024),r=!1)}return a=r,Ho(e,t),r=0!==(128&t.flags),a||r?(a=t.stateNode,n=r&&"function"!==typeof n.getDerivedStateFromError?null:a.render(),t.flags|=1,null!==e&&r?(t.child=fa(t,e.child,null,s),t.child=fa(t,null,n,s)):jo(e,t,n,s),t.memoizedState=a.state,e=t.child):e=sl(e,t,s),e}function Qo(e,t,n,r){return vs(),t.flags|=256,jo(e,t,n,r),t.child}var Ko={dehydrated:null,treeContext:null,retryLane:0,hydrationErrors:null};function Yo(e){return{baseLanes:e,cachePool:qs()}}function qo(e,t,n){return e=null!==e?e.childLanes&~n:0,t&&(e|=kc),e}function Xo(e,t,n){var r,s=t.pendingProps,a=!1,o=0!==(128&t.flags);if((r=o)||(r=(null===e||null!==e.memoizedState)&&0!==(2&Fa.current)),r&&(a=!0,t.flags&=-129),r=0!==(32&t.flags),t.flags&=-33,null===e){if(ds){if(a?ja(t):La(),(e=us)?null!==(e=null!==(e=_d(e,fs))&&"&"!==e.data?e:null)&&(t.memoizedState={dehydrated:e,treeContext:null!==ts?{id:ns,overflow:rs}:null,retryLane:536870912,hydrationErrors:null},(n=Gr(e)).return=t,t.child=n,cs=t,us=null):e=null,null===e)throw ms(t);return Md(e)?t.lanes=32:t.lanes=536870912,null}var l=s.children;return s=s.fallback,a?(La(),l=$o({mode:"hidden",children:l},a=t.mode),s=Hr(s,a,n,null),l.return=t,s.return=t,l.sibling=s,t.child=l,(s=t.child).memoizedState=Yo(n),s.childLanes=qo(e,r,n),t.memoizedState=Ko,Fo(null,s)):(ja(t),Zo(t,l))}var c=e.memoizedState;if(null!==c&&null!==(l=c.dehydrated)){if(o)256&t.flags?(ja(t),t.flags&=-257,t=el(e,t,n)):null!==t.memoizedState?(La(),t.child=e.child,t.flags|=128,t=null):(La(),l=s.fallback,a=t.mode,s=$o({mode:"visible",children:s.children},a),(l=Hr(l,a,n,null)).flags|=2,s.return=t,l.return=t,s.sibling=l,t.child=s,fa(t,e.child,null,n),(s=t.child).memoizedState=Yo(n),s.childLanes=qo(e,r,n),t.memoizedState=Ko,t=Fo(null,s));else if(ja(t),Md(l)){if(r=l.nextSibling&&l.nextSibling.dataset)var u=r.dgst;r=u,(s=Error(i(419))).stack="",s.digest=r,bs({value:s,source:null,stack:null}),t=el(e,t,n)}else if(Do||Is(e,t,n,!1),r=0!==(n&e.childLanes),Do||r){if(null!==(r=pc)&&(0!==(s=Oe(r,n))&&s!==c.retryLane))throw c.retryLane=s,Dr(e,s),Kc(r,e,s),Mo;Rd(l)||iu(),t=el(e,t,n)}else Rd(l)?(t.flags|=192,t.child=e.child,t=null):(e=c.treeContext,us=Dd(l.nextSibling),cs=t,ds=!0,hs=null,fs=!1,null!==e&&ls(t,e),(t=Zo(t,s.children)).flags|=4096);return t}return a?(La(),l=s.fallback,a=t.mode,u=(c=e.child).sibling,(s=Ur(c,{mode:"hidden",children:s.children})).subtreeFlags=65011712&c.subtreeFlags,null!==u?l=Ur(u,l):(l=Hr(l,a,n,null)).flags|=2,l.return=t,s.return=t,s.sibling=l,t.child=s,Fo(null,s),s=t.child,null===(l=e.child.memoizedState)?l=Yo(n):(null!==(a=l.cachePool)?(c=Bs._currentValue,a=a.parent!==c?{parent:c,pool:c}:a):a=qs(),l={baseLanes:l.baseLanes|n,cachePool:a}),s.memoizedState=l,s.childLanes=qo(e,r,n),t.memoizedState=Ko,Fo(e.child,s)):(ja(t),e=(n=e.child).sibling,(n=Ur(n,{mode:"visible",children:s.children})).return=t,n.sibling=null,null!==e&&(null===(r=t.deletions)?(t.deletions=[e],t.flags|=16):r.push(e)),t.child=n,t.memoizedState=null,n)}function Zo(e,t){return(t=$o({mode:"visible",children:t},e.mode)).return=e,e.child=t}function $o(e,t){return(e=Br(22,e,null,t)).lanes=0,e}function el(e,t,n){return fa(t,e.child,null,n),(e=Zo(t,t.pendingProps.children)).flags|=2,t.memoizedState=null,e}function tl(e,t,n){e.lanes|=t;var r=e.alternate;null!==r&&(r.lanes|=t),ks(e.return,t,n)}function nl(e,t,n,r,s,a){var i=e.memoizedState;null===i?e.memoizedState={isBackwards:t,rendering:null,renderingStartTime:0,last:r,tail:n,tailMode:s,treeForkCount:a}:(i.isBackwards=t,i.rendering=null,i.renderingStartTime=0,i.last=r,i.tail=n,i.tailMode=s,i.treeForkCount=a)}function rl(e,t,n){var r=t.pendingProps,s=r.revealOrder,a=r.tail;r=r.children;var i=Fa.current,o=0!==(2&i);if(o?(i=1&i|2,t.flags|=128):i&=1,W(Fa,i),jo(e,t,r,n),r=ds?Zr:0,!o&&null!==e&&0!==(128&e.flags))e:for(e=t.child;null!==e;){if(13===e.tag)null!==e.memoizedState&&tl(e,n,t);else if(19===e.tag)tl(e,n,t);else if(null!==e.child){e.child.return=e,e=e.child;continue}if(e===t)break e;for(;null===e.sibling;){if(null===e.return||e.return===t)break e;e=e.return}e.sibling.return=e.return,e=e.sibling}switch(s){case"forwards":for(n=t.child,s=null;null!==n;)null!==(e=n.alternate)&&null===Ua(e)&&(s=n),n=n.sibling;null===(n=s)?(s=t.child,t.child=null):(s=n.sibling,n.sibling=null),nl(t,!1,s,n,a,r);break;case"backwards":case"unstable_legacy-backwards":for(n=null,s=t.child,t.child=null;null!==s;){if(null!==(e=s.alternate)&&null===Ua(e)){t.child=s;break}e=s.sibling,s.sibling=n,n=s,s=e}nl(t,!0,n,null,a,r);break;case"together":nl(t,!1,null,null,void 0,r);break;default:t.memoizedState=null}return t.child}function sl(e,t,n){if(null!==e&&(t.dependencies=e.dependencies),Cc|=t.lanes,0===(n&t.childLanes)){if(null===e)return null;if(Is(e,t,n,!1),0===(n&t.childLanes))return null}if(null!==e&&t.child!==e.child)throw Error(i(153));if(null!==t.child){for(n=Ur(e=t.child,e.pendingProps),t.child=n,n.return=t;null!==e.sibling;)e=e.sibling,(n=n.sibling=Ur(e,e.pendingProps)).return=t;n.sibling=null}return t.child}function al(e,t){return 0!==(e.lanes&t)||!(null===(e=e.dependencies)||!_s(e))}function il(e,t,n){if(null!==e)if(e.memoizedProps!==t.pendingProps)Do=!0;else{if(!al(e,n)&&0===(128&t.flags))return Do=!1,function(e,t,n){switch(t.tag){case 3:K(t,t.stateNode.containerInfo),Es(0,Bs,e.memoizedState.cache),vs();break;case 27:case 5:q(t);break;case 4:K(t,t.stateNode.containerInfo);break;case 10:Es(0,t.type,t.memoizedProps.value);break;case 31:if(null!==t.memoizedState)return t.flags|=128,Oa(t),null;break;case 13:var r=t.memoizedState;if(null!==r)return null!==r.dehydrated?(ja(t),t.flags|=128,null):0!==(n&t.child.childLanes)?Xo(e,t,n):(ja(t),null!==(e=sl(e,t,n))?e.sibling:null);ja(t);break;case 19:var s=0!==(128&e.flags);if((r=0!==(n&t.childLanes))||(Is(e,t,n,!1),r=0!==(n&t.childLanes)),s){if(r)return rl(e,t,n);t.flags|=128}if(null!==(s=t.memoizedState)&&(s.rendering=null,s.tail=null,s.lastEffect=null),W(Fa,Fa.current),r)break;return null;case 22:return t.lanes=0,Bo(e,t,n,t.pendingProps);case 24:Es(0,Bs,e.memoizedState.cache)}return sl(e,t,n)}(e,t,n);Do=0!==(131072&e.flags)}else Do=!1,ds&&0!==(1048576&t.flags)&&as(t,Zr,t.index);switch(t.lanes=0,t.tag){case 16:e:{var r=t.pendingProps;if(e=ra(t.elementType),t.type=e,"function"!==typeof e){if(void 0!==e&&null!==e){var s=e.$$typeof;if(s===x){t.tag=11,t=Oo(null,t,e,r,n);break e}if(s===E){t.tag=14,t=Po(null,t,e,r,n);break e}}throw t=M(e)||e,Error(i(306,t,""))}Fr(e)?(r=So(e,r),t.tag=1,t=Jo(null,t,e,r,n)):(t.tag=0,t=Vo(null,t,e,r,n))}return t;case 0:return Vo(e,t,t.type,t.pendingProps,n);case 1:return Jo(e,t,r=t.type,s=So(r,t.pendingProps),n);case 3:e:{if(K(t,t.stateNode.containerInfo),null===e)throw Error(i(387));r=t.pendingProps;var a=t.memoizedState;s=a.element,ya(e,t),Ca(t,r,null,n);var o=t.memoizedState;if(r=o.cache,Es(0,Bs,r),r!==a.cache&&Ts(t,[Bs],n,!0),Sa(),r=o.element,a.isDehydrated){if(a={element:r,isDehydrated:!1,cache:o.cache},t.updateQueue.baseState=a,t.memoizedState=a,256&t.flags){t=Qo(e,t,r,n);break e}if(r!==s){bs(s=Kr(Error(i(424)),t)),t=Qo(e,t,r,n);break e}if(9===(e=t.stateNode.containerInfo).nodeType)e=e.body;else e="HTML"===e.nodeName?e.ownerDocument.body:e;for(us=Dd(e.firstChild),cs=t,ds=!0,hs=null,fs=!0,n=pa(t,null,r,n),t.child=n;n;)n.flags=-3&n.flags|4096,n=n.sibling}else{if(vs(),r===s){t=sl(e,t,n);break e}jo(e,t,r,n)}t=t.child}return t;case 26:return Ho(e,t),null===e?(n=Gd(t.type,null,t.pendingProps,null))?t.memoizedState=n:ds||(n=t.type,e=t.pendingProps,(r=gd(J.current).createElement(n))[We]=t,r[ze]=e,hd(r,n,e),et(r),t.stateNode=r):t.memoizedState=Gd(t.type,e.memoizedProps,t.pendingProps,e.memoizedState),null;case 27:return q(t),null===e&&ds&&(r=t.stateNode=Ld(t.type,t.pendingProps,J.current),cs=t,fs=!0,s=us,Nd(t.type)?(jd=s,us=Dd(r.firstChild)):us=s),jo(e,t,t.pendingProps.children,n),Ho(e,t),null===e&&(t.flags|=4194304),t.child;case 5:return null===e&&ds&&((s=r=us)&&(null!==(r=function(e,t,n,r){for(;1===e.nodeType;){var s=n;if(e.nodeName.toLowerCase()!==t.toLowerCase()){if(!r&&("INPUT"!==e.nodeName||"hidden"!==e.type))break}else if(r){if(!e[Ke])switch(t){case"meta":if(!e.hasAttribute("itemprop"))break;return e;case"link":if("stylesheet"===(a=e.getAttribute("rel"))&&e.hasAttribute("data-precedence"))break;if(a!==s.rel||e.getAttribute("href")!==(null==s.href||""===s.href?null:s.href)||e.getAttribute("crossorigin")!==(null==s.crossOrigin?null:s.crossOrigin)||e.getAttribute("title")!==(null==s.title?null:s.title))break;return e;case"style":if(e.hasAttribute("data-precedence"))break;return e;case"script":if(((a=e.getAttribute("src"))!==(null==s.src?null:s.src)||e.getAttribute("type")!==(null==s.type?null:s.type)||e.getAttribute("crossorigin")!==(null==s.crossOrigin?null:s.crossOrigin))&&a&&e.hasAttribute("async")&&!e.hasAttribute("itemprop"))break;return e;default:return e}}else{if("input"!==t||"hidden"!==e.type)return e;var a=null==s.name?null:""+s.name;if("hidden"===s.type&&e.getAttribute("name")===a)return e}if(null===(e=Dd(e.nextSibling)))break}return null}(r,t.type,t.pendingProps,fs))?(t.stateNode=r,cs=t,us=Dd(r.firstChild),fs=!1,s=!0):s=!1),s||ms(t)),q(t),s=t.type,a=t.pendingProps,o=null!==e?e.memoizedProps:null,r=a.children,vd(s,a)?r=null:null!==o&&vd(s,o)&&(t.flags|=32),null!==t.memoizedState&&(s=ei(e,t,ri,null,null,n),uh._currentValue=s),Ho(e,t),jo(e,t,r,n),t.child;case 6:return null===e&&ds&&((e=n=us)&&(null!==(n=function(e,t,n){if(""===t)return null;for(;3!==e.nodeType;){if((1!==e.nodeType||"INPUT"!==e.nodeName||"hidden"!==e.type)&&!n)return null;if(null===(e=Dd(e.nextSibling)))return null}return e}(n,t.pendingProps,fs))?(t.stateNode=n,cs=t,us=null,e=!0):e=!1),e||ms(t)),null;case 13:return Xo(e,t,n);case 4:return K(t,t.stateNode.containerInfo),r=t.pendingProps,null===e?t.child=fa(t,null,r,n):jo(e,t,r,n),t.child;case 11:return Oo(e,t,t.type,t.pendingProps,n);case 7:return jo(e,t,t.pendingProps,n),t.child;case 8:case 12:return jo(e,t,t.pendingProps.children,n),t.child;case 10:return r=t.pendingProps,Es(0,t.type,r.value),jo(e,t,r.children,n),t.child;case 9:return s=t.type._context,r=t.pendingProps.children,Rs(t),r=r(s=Ms(s)),t.flags|=1,jo(e,t,r,n),t.child;case 14:return Po(e,t,t.type,t.pendingProps,n);case 15:return Lo(e,t,t.type,t.pendingProps,n);case 19:return rl(e,t,n);case 31:return function(e,t,n){var r=t.pendingProps,s=0!==(128&t.flags);if(t.flags&=-129,null===e){if(ds){if("hidden"===r.mode)return e=Wo(t,r),t.lanes=536870912,Fo(null,e);if(Oa(t),(e=us)?null!==(e=null!==(e=_d(e,fs))&&"&"===e.data?e:null)&&(t.memoizedState={dehydrated:e,treeContext:null!==ts?{id:ns,overflow:rs}:null,retryLane:536870912,hydrationErrors:null},(n=Gr(e)).return=t,t.child=n,cs=t,us=null):e=null,null===e)throw ms(t);return t.lanes=536870912,null}return Wo(t,r)}var a=e.memoizedState;if(null!==a){var o=a.dehydrated;if(Oa(t),s)if(256&t.flags)t.flags&=-257,t=zo(e,t,n);else{if(null===t.memoizedState)throw Error(i(558));t.child=e.child,t.flags|=128,t=null}else if(Do||Is(e,t,n,!1),s=0!==(n&e.childLanes),Do||s){if(null!==(r=pc)&&0!==(o=Oe(r,n))&&o!==a.retryLane)throw a.retryLane=o,Dr(e,o),Kc(r,e,o),Mo;iu(),t=zo(e,t,n)}else e=a.treeContext,us=Dd(o.nextSibling),cs=t,ds=!0,hs=null,fs=!1,null!==e&&ls(t,e),(t=Wo(t,r)).flags|=4096;return t}return(e=Ur(e.child,{mode:r.mode,children:r.children})).ref=t.ref,t.child=e,e.return=t,e}(e,t,n);case 22:return Bo(e,t,n,t.pendingProps);case 24:return Rs(t),r=Ms(Bs),null===e?(null===(s=Ks())&&(s=pc,a=Fs(),s.pooledCache=a,a.refCount++,null!==a&&(s.pooledCacheLanes|=n),s=a),t.memoizedState={parent:r,cache:s},ga(t),Es(0,Bs,s)):(0!==(e.lanes&n)&&(ya(e,t),Ca(t,null,null,n),Sa()),s=e.memoizedState,a=t.memoizedState,s.parent!==r?(s={parent:r,cache:r},t.memoizedState=s,0===t.lanes&&(t.memoizedState=t.updateQueue.baseState=s),Es(0,Bs,r)):(r=a.cache,Es(0,Bs,r),r!==s.cache&&Ts(t,[Bs],n,!0))),jo(e,t,t.pendingProps.children,n),t.child;case 29:throw t.pendingProps}throw Error(i(156,t.tag))}function ol(e){e.flags|=4}function ll(e,t,n,r,s){if((t=0!==(32&e.mode))&&(t=!1),t){if(e.flags|=16777216,(335544128&s)===s)if(e.stateNode.complete)e.flags|=8192;else{if(!ru())throw sa=ea,Zs;e.flags|=8192}}else e.flags&=-16777217}function cl(e,t){if("stylesheet"!==t.type||0!==(4&t.state.loading))e.flags&=-16777217;else if(e.flags|=16777216,!sh(t)){if(!ru())throw sa=ea,Zs;e.flags|=8192}}function ul(e,t){null!==t&&(e.flags|=4),16384&e.flags&&(t=22!==e.tag?_e():536870912,e.lanes|=t,Tc|=t)}function dl(e,t){if(!ds)switch(e.tailMode){case"hidden":t=e.tail;for(var n=null;null!==t;)null!==t.alternate&&(n=t),t=t.sibling;null===n?e.tail=null:n.sibling=null;break;case"collapsed":n=e.tail;for(var r=null;null!==n;)null!==n.alternate&&(r=n),n=n.sibling;null===r?t||null===e.tail?e.tail=null:e.tail.sibling=null:r.sibling=null}}function hl(e){var t=null!==e.alternate&&e.alternate.child===e.child,n=0,r=0;if(t)for(var s=e.child;null!==s;)n|=s.lanes|s.childLanes,r|=65011712&s.subtreeFlags,r|=65011712&s.flags,s.return=e,s=s.sibling;else for(s=e.child;null!==s;)n|=s.lanes|s.childLanes,r|=s.subtreeFlags,r|=s.flags,s.return=e,s=s.sibling;return e.subtreeFlags|=r,e.childLanes=n,t}function fl(e,t,n){var r=t.pendingProps;switch(os(t),t.tag){case 16:case 15:case 0:case 11:case 7:case 8:case 12:case 9:case 14:case 1:return hl(t),null;case 3:return n=t.stateNode,r=null,null!==e&&(r=e.memoizedState.cache),t.memoizedState.cache!==r&&(t.flags|=2048),Ns(Bs),Y(),n.pendingContext&&(n.context=n.pendingContext,n.pendingContext=null),null!==e&&null!==e.child||(ws(t)?ol(t):null===e||e.memoizedState.isDehydrated&&0===(256&t.flags)||(t.flags|=1024,As())),hl(t),null;case 26:var s=t.type,a=t.memoizedState;return null===e?(ol(t),null!==a?(hl(t),cl(t,a)):(hl(t),ll(t,s,0,0,n))):a?a!==e.memoizedState?(ol(t),hl(t),cl(t,a)):(hl(t),t.flags&=-16777217):((e=e.memoizedProps)!==r&&ol(t),hl(t),ll(t,s,0,0,n)),null;case 27:if(X(t),n=J.current,s=t.type,null!==e&&null!=t.stateNode)e.memoizedProps!==r&&ol(t);else{if(!r){if(null===t.stateNode)throw Error(i(166));return hl(t),null}e=V.current,ws(t)?gs(t):(e=Ld(s,r,n),t.stateNode=e,ol(t))}return hl(t),null;case 5:if(X(t),s=t.type,null!==e&&null!=t.stateNode)e.memoizedProps!==r&&ol(t);else{if(!r){if(null===t.stateNode)throw Error(i(166));return hl(t),null}if(a=V.current,ws(t))gs(t);else{var o=gd(J.current);switch(a){case 1:a=o.createElementNS("http://www.w3.org/2000/svg",s);break;case 2:a=o.createElementNS("http://www.w3.org/1998/Math/MathML",s);break;default:switch(s){case"svg":a=o.createElementNS("http://www.w3.org/2000/svg",s);break;case"math":a=o.createElementNS("http://www.w3.org/1998/Math/MathML",s);break;case"script":(a=o.createElement("div")).innerHTML="<script><\/script>",a=a.removeChild(a.firstChild);break;case"select":a="string"===typeof r.is?o.createElement("select",{is:r.is}):o.createElement("select"),r.multiple?a.multiple=!0:r.size&&(a.size=r.size);break;default:a="string"===typeof r.is?o.createElement(s,{is:r.is}):o.createElement(s)}}a[We]=t,a[ze]=r;e:for(o=t.child;null!==o;){if(5===o.tag||6===o.tag)a.appendChild(o.stateNode);else if(4!==o.tag&&27!==o.tag&&null!==o.child){o.child.return=o,o=o.child;continue}if(o===t)break e;for(;null===o.sibling;){if(null===o.return||o.return===t)break e;o=o.return}o.sibling.return=o.return,o=o.sibling}t.stateNode=a;e:switch(hd(a,s,r),s){case"button":case"input":case"select":case"textarea":r=!!r.autoFocus;break e;case"img":r=!0;break e;default:r=!1}r&&ol(t)}}return hl(t),ll(t,t.type,null===e||e.memoizedProps,t.pendingProps,n),null;case 6:if(e&&null!=t.stateNode)e.memoizedProps!==r&&ol(t);else{if("string"!==typeof r&&null===t.stateNode)throw Error(i(166));if(e=J.current,ws(t)){if(e=t.stateNode,n=t.memoizedProps,r=null,null!==(s=cs))switch(s.tag){case 27:case 5:r=s.memoizedProps}e[We]=t,(e=!!(e.nodeValue===n||null!==r&&!0===r.suppressHydrationWarning||cd(e.nodeValue,n)))||ms(t,!0)}else(e=gd(e).createTextNode(r))[We]=t,t.stateNode=e}return hl(t),null;case 31:if(n=t.memoizedState,null===e||null!==e.memoizedState){if(r=ws(t),null!==n){if(null===e){if(!r)throw Error(i(318));if(!(e=null!==(e=t.memoizedState)?e.dehydrated:null))throw Error(i(557));e[We]=t}else vs(),0===(128&t.flags)&&(t.memoizedState=null),t.flags|=4;hl(t),e=!1}else n=As(),null!==e&&null!==e.memoizedState&&(e.memoizedState.hydrationErrors=n),e=!0;if(!e)return 256&t.flags?(Ba(t),t):(Ba(t),null);if(0!==(128&t.flags))throw Error(i(558))}return hl(t),null;case 13:if(r=t.memoizedState,null===e||null!==e.memoizedState&&null!==e.memoizedState.dehydrated){if(s=ws(t),null!==r&&null!==r.dehydrated){if(null===e){if(!s)throw Error(i(318));if(!(s=null!==(s=t.memoizedState)?s.dehydrated:null))throw Error(i(317));s[We]=t}else vs(),0===(128&t.flags)&&(t.memoizedState=null),t.flags|=4;hl(t),s=!1}else s=As(),null!==e&&null!==e.memoizedState&&(e.memoizedState.hydrationErrors=s),s=!0;if(!s)return 256&t.flags?(Ba(t),t):(Ba(t),null)}return Ba(t),0!==(128&t.flags)?(t.lanes=n,t):(n=null!==r,e=null!==e&&null!==e.memoizedState,n&&(s=null,null!==(r=t.child).alternate&&null!==r.alternate.memoizedState&&null!==r.alternate.memoizedState.cachePool&&(s=r.alternate.memoizedState.cachePool.pool),a=null,null!==r.memoizedState&&null!==r.memoizedState.cachePool&&(a=r.memoizedState.cachePool.pool),a!==s&&(r.flags|=2048)),n!==e&&n&&(t.child.flags|=8192),ul(t,t.updateQueue),hl(t),null);case 4:return Y(),null===e&&$u(t.stateNode.containerInfo),hl(t),null;case 10:return Ns(t.type),hl(t),null;case 19:if(U(Fa),null===(r=t.memoizedState))return hl(t),null;if(s=0!==(128&t.flags),null===(a=r.rendering))if(s)dl(r,!1);else{if(0!==Sc||null!==e&&0!==(128&e.flags))for(e=t.child;null!==e;){if(null!==(a=Ua(e))){for(t.flags|=128,dl(r,!1),e=a.updateQueue,t.updateQueue=e,ul(t,e),t.subtreeFlags=0,e=n,n=t.child;null!==n;)Wr(n,e),n=n.sibling;return W(Fa,1&Fa.current|2),ds&&ss(t,r.treeForkCount),t.child}e=e.sibling}null!==r.tail&&le()>jc&&(t.flags|=128,s=!0,dl(r,!1),t.lanes=4194304)}else{if(!s)if(null!==(e=Ua(a))){if(t.flags|=128,s=!0,e=e.updateQueue,t.updateQueue=e,ul(t,e),dl(r,!0),null===r.tail&&"hidden"===r.tailMode&&!a.alternate&&!ds)return hl(t),null}else 2*le()-r.renderingStartTime>jc&&536870912!==n&&(t.flags|=128,s=!0,dl(r,!1),t.lanes=4194304);r.isBackwards?(a.sibling=t.child,t.child=a):(null!==(e=r.last)?e.sibling=a:t.child=a,r.last=a)}return null!==r.tail?(e=r.tail,r.rendering=e,r.tail=e.sibling,r.renderingStartTime=le(),e.sibling=null,n=Fa.current,W(Fa,s?1&n|2:1&n),ds&&ss(t,r.treeForkCount),e):(hl(t),null);case 22:case 23:return Ba(t),Ra(),r=null!==t.memoizedState,null!==e?null!==e.memoizedState!==r&&(t.flags|=8192):r&&(t.flags|=8192),r?0!==(536870912&n)&&0===(128&t.flags)&&(hl(t),6&t.subtreeFlags&&(t.flags|=8192)):hl(t),null!==(n=t.updateQueue)&&ul(t,n.retryQueue),n=null,null!==e&&null!==e.memoizedState&&null!==e.memoizedState.cachePool&&(n=e.memoizedState.cachePool.pool),r=null,null!==t.memoizedState&&null!==t.memoizedState.cachePool&&(r=t.memoizedState.cachePool.pool),r!==n&&(t.flags|=2048),null!==e&&U(Qs),null;case 24:return n=null,null!==e&&(n=e.memoizedState.cache),t.memoizedState.cache!==n&&(t.flags|=2048),Ns(Bs),hl(t),null;case 25:case 30:return null}throw Error(i(156,t.tag))}function pl(e,t){switch(os(t),t.tag){case 1:return 65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 3:return Ns(Bs),Y(),0!==(65536&(e=t.flags))&&0===(128&e)?(t.flags=-65537&e|128,t):null;case 26:case 27:case 5:return X(t),null;case 31:if(null!==t.memoizedState){if(Ba(t),null===t.alternate)throw Error(i(340));vs()}return 65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 13:if(Ba(t),null!==(e=t.memoizedState)&&null!==e.dehydrated){if(null===t.alternate)throw Error(i(340));vs()}return 65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 19:return U(Fa),null;case 4:return Y(),null;case 10:return Ns(t.type),null;case 22:case 23:return Ba(t),Ra(),null!==e&&U(Qs),65536&(e=t.flags)?(t.flags=-65537&e|128,t):null;case 24:return Ns(Bs),null;default:return null}}function ml(e,t){switch(os(t),t.tag){case 3:Ns(Bs),Y();break;case 26:case 27:case 5:X(t);break;case 4:Y();break;case 31:null!==t.memoizedState&&Ba(t);break;case 13:Ba(t);break;case 19:U(Fa);break;case 10:Ns(t.type);break;case 22:case 23:Ba(t),Ra(),null!==e&&U(Qs);break;case 24:Ns(Bs)}}function gl(e,t){try{var n=t.updateQueue,r=null!==n?n.lastEffect:null;if(null!==r){var s=r.next;n=s;do{if((n.tag&e)===e){r=void 0;var a=n.create,i=n.inst;r=a(),i.destroy=r}n=n.next}while(n!==s)}}catch(o){Su(t,t.return,o)}}function yl(e,t,n){try{var r=t.updateQueue,s=null!==r?r.lastEffect:null;if(null!==s){var a=s.next;r=a;do{if((r.tag&e)===e){var i=r.inst,o=i.destroy;if(void 0!==o){i.destroy=void 0,s=t;var l=n,c=o;try{c()}catch(u){Su(s,l,u)}}}r=r.next}while(r!==a)}}catch(u){Su(t,t.return,u)}}function wl(e){var t=e.updateQueue;if(null!==t){var n=e.stateNode;try{Na(t,n)}catch(r){Su(e,e.return,r)}}}function vl(e,t,n){n.props=So(e.type,e.memoizedProps),n.state=e.memoizedState;try{n.componentWillUnmount()}catch(r){Su(e,t,r)}}function Al(e,t){try{var n=e.ref;if(null!==n){switch(e.tag){case 26:case 27:case 5:var r=e.stateNode;break;default:r=e.stateNode}"function"===typeof n?e.refCleanup=n(r):n.current=r}}catch(s){Su(e,t,s)}}function bl(e,t){var n=e.ref,r=e.refCleanup;if(null!==n)if("function"===typeof r)try{r()}catch(s){Su(e,t,s)}finally{e.refCleanup=null,null!=(e=e.alternate)&&(e.refCleanup=null)}else if("function"===typeof n)try{n(null)}catch(a){Su(e,t,a)}else n.current=null}function xl(e){var t=e.type,n=e.memoizedProps,r=e.stateNode;try{e:switch(t){case"button":case"input":case"select":case"textarea":n.autoFocus&&r.focus();break e;case"img":n.src?r.src=n.src:n.srcSet&&(r.srcset=n.srcSet)}}catch(s){Su(e,e.return,s)}}function Sl(e,t,n){try{var r=e.stateNode;!function(e,t,n,r){switch(t){case"div":case"span":case"svg":case"path":case"a":case"g":case"p":case"li":break;case"input":var s=null,a=null,o=null,l=null,c=null,u=null,d=null;for(p in n){var h=n[p];if(n.hasOwnProperty(p)&&null!=h)switch(p){case"checked":case"value":break;case"defaultValue":c=h;default:r.hasOwnProperty(p)||ud(e,t,p,null,r,h)}}for(var f in r){var p=r[f];if(h=n[f],r.hasOwnProperty(f)&&(null!=p||null!=h))switch(f){case"type":a=p;break;case"name":s=p;break;case"checked":u=p;break;case"defaultChecked":d=p;break;case"value":o=p;break;case"defaultValue":l=p;break;case"children":case"dangerouslySetInnerHTML":if(null!=p)throw Error(i(137,t));break;default:p!==h&&ud(e,t,f,p,r,h)}}return void wt(e,o,l,c,u,d,a,s);case"select":for(a in p=o=l=f=null,n)if(c=n[a],n.hasOwnProperty(a)&&null!=c)switch(a){case"value":break;case"multiple":p=c;default:r.hasOwnProperty(a)||ud(e,t,a,null,r,c)}for(s in r)if(a=r[s],c=n[s],r.hasOwnProperty(s)&&(null!=a||null!=c))switch(s){case"value":f=a;break;case"defaultValue":l=a;break;case"multiple":o=a;default:a!==c&&ud(e,t,s,a,r,c)}return t=l,n=o,r=p,void(null!=f?bt(e,!!n,f,!1):!!r!==!!n&&(null!=t?bt(e,!!n,t,!0):bt(e,!!n,n?[]:"",!1)));case"textarea":for(l in p=f=null,n)if(s=n[l],n.hasOwnProperty(l)&&null!=s&&!r.hasOwnProperty(l))switch(l){case"value":case"children":break;default:ud(e,t,l,null,r,s)}for(o in r)if(s=r[o],a=n[o],r.hasOwnProperty(o)&&(null!=s||null!=a))switch(o){case"value":f=s;break;case"defaultValue":p=s;break;case"children":break;case"dangerouslySetInnerHTML":if(null!=s)throw Error(i(91));break;default:s!==a&&ud(e,t,o,s,r,a)}return void xt(e,f,p);case"option":for(var m in n)if(f=n[m],n.hasOwnProperty(m)&&null!=f&&!r.hasOwnProperty(m))if("selected"===m)e.selected=!1;else ud(e,t,m,null,r,f);for(c in r)if(f=r[c],p=n[c],r.hasOwnProperty(c)&&f!==p&&(null!=f||null!=p))if("selected"===c)e.selected=f&&"function"!==typeof f&&"symbol"!==typeof f;else ud(e,t,c,f,r,p);return;case"img":case"link":case"area":case"base":case"br":case"col":case"embed":case"hr":case"keygen":case"meta":case"param":case"source":case"track":case"wbr":case"menuitem":for(var g in n)f=n[g],n.hasOwnProperty(g)&&null!=f&&!r.hasOwnProperty(g)&&ud(e,t,g,null,r,f);for(u in r)if(f=r[u],p=n[u],r.hasOwnProperty(u)&&f!==p&&(null!=f||null!=p))switch(u){case"children":case"dangerouslySetInnerHTML":if(null!=f)throw Error(i(137,t));break;default:ud(e,t,u,f,r,p)}return;default:if(Tt(t)){for(var y in n)f=n[y],n.hasOwnProperty(y)&&void 0!==f&&!r.hasOwnProperty(y)&&dd(e,t,y,void 0,r,f);for(d in r)f=r[d],p=n[d],!r.hasOwnProperty(d)||f===p||void 0===f&&void 0===p||dd(e,t,d,f,r,p);return}}for(var w in n)f=n[w],n.hasOwnProperty(w)&&null!=f&&!r.hasOwnProperty(w)&&ud(e,t,w,null,r,f);for(h in r)f=r[h],p=n[h],!r.hasOwnProperty(h)||f===p||null==f&&null==p||ud(e,t,h,f,r,p)}(r,e.type,n,t),r[ze]=t}catch(s){Su(e,e.return,s)}}function Cl(e){return 5===e.tag||3===e.tag||26===e.tag||27===e.tag&&Nd(e.type)||4===e.tag}function El(e){e:for(;;){for(;null===e.sibling;){if(null===e.return||Cl(e.return))return null;e=e.return}for(e.sibling.return=e.return,e=e.sibling;5!==e.tag&&6!==e.tag&&18!==e.tag;){if(27===e.tag&&Nd(e.type))continue e;if(2&e.flags)continue e;if(null===e.child||4===e.tag)continue e;e.child.return=e,e=e.child}if(!(2&e.flags))return e.stateNode}}function Nl(e,t,n){var r=e.tag;if(5===r||6===r)e=e.stateNode,t?(9===n.nodeType?n.body:"HTML"===n.nodeName?n.ownerDocument.body:n).insertBefore(e,t):((t=9===n.nodeType?n.body:"HTML"===n.nodeName?n.ownerDocument.body:n).appendChild(e),null!==(n=n._reactRootContainer)&&void 0!==n||null!==t.onclick||(t.onclick=Mt));else if(4!==r&&(27===r&&Nd(e.type)&&(n=e.stateNode,t=null),null!==(e=e.child)))for(Nl(e,t,n),e=e.sibling;null!==e;)Nl(e,t,n),e=e.sibling}function kl(e,t,n){var r=e.tag;if(5===r||6===r)e=e.stateNode,t?n.insertBefore(e,t):n.appendChild(e);else if(4!==r&&(27===r&&Nd(e.type)&&(n=e.stateNode),null!==(e=e.child)))for(kl(e,t,n),e=e.sibling;null!==e;)kl(e,t,n),e=e.sibling}function Tl(e){var t=e.stateNode,n=e.memoizedProps;try{for(var r=e.type,s=t.attributes;s.length;)t.removeAttributeNode(s[0]);hd(t,r,n),t[We]=e,t[ze]=n}catch(a){Su(e,e.return,a)}}var Il=!1,_l=!1,Rl=!1,Ml="function"===typeof WeakSet?WeakSet:Set,Dl=null;function jl(e,t,n){var r=n.flags;switch(n.tag){case 0:case 11:case 15:Kl(e,n),4&r&&gl(5,n);break;case 1:if(Kl(e,n),4&r)if(e=n.stateNode,null===t)try{e.componentDidMount()}catch(i){Su(n,n.return,i)}else{var s=So(n.type,t.memoizedProps);t=t.memoizedState;try{e.componentDidUpdate(s,t,e.__reactInternalSnapshotBeforeUpdate)}catch(o){Su(n,n.return,o)}}64&r&&wl(n),512&r&&Al(n,n.return);break;case 3:if(Kl(e,n),64&r&&null!==(e=n.updateQueue)){if(t=null,null!==n.child)switch(n.child.tag){case 27:case 5:case 1:t=n.child.stateNode}try{Na(e,t)}catch(i){Su(n,n.return,i)}}break;case 27:null===t&&4&r&&Tl(n);case 26:case 5:Kl(e,n),null===t&&4&r&&xl(n),512&r&&Al(n,n.return);break;case 12:Kl(e,n);break;case 31:Kl(e,n),4&r&&Ul(e,n);break;case 13:Kl(e,n),4&r&&Wl(e,n),64&r&&(null!==(e=n.memoizedState)&&(null!==(e=e.dehydrated)&&function(e,t){var n=e.ownerDocument;if("$~"===e.data)e._reactRetry=t;else if("$?"!==e.data||"loading"!==n.readyState)t();else{var r=function(){t(),n.removeEventListener("DOMContentLoaded",r)};n.addEventListener("DOMContentLoaded",r),e._reactRetry=r}}(e,n=ku.bind(null,n))));break;case 22:if(!(r=null!==n.memoizedState||Il)){t=null!==t&&null!==t.memoizedState||_l,s=Il;var a=_l;Il=r,(_l=t)&&!a?ql(e,n,0!==(8772&n.subtreeFlags)):Kl(e,n),Il=s,_l=a}break;case 30:break;default:Kl(e,n)}}function Ol(e){var t=e.alternate;null!==t&&(e.alternate=null,Ol(t)),e.child=null,e.deletions=null,e.sibling=null,5===e.tag&&(null!==(t=e.stateNode)&&Ye(t)),e.stateNode=null,e.return=null,e.dependencies=null,e.memoizedProps=null,e.memoizedState=null,e.pendingProps=null,e.stateNode=null,e.updateQueue=null}var Pl=null,Ll=!1;function Bl(e,t,n){for(n=n.child;null!==n;)Fl(e,t,n),n=n.sibling}function Fl(e,t,n){if(we&&"function"===typeof we.onCommitFiberUnmount)try{we.onCommitFiberUnmount(ye,n)}catch(a){}switch(n.tag){case 26:_l||bl(n,t),Bl(e,t,n),n.memoizedState?n.memoizedState.count--:n.stateNode&&(n=n.stateNode).parentNode.removeChild(n);break;case 27:_l||bl(n,t);var r=Pl,s=Ll;Nd(n.type)&&(Pl=n.stateNode,Ll=!1),Bl(e,t,n),Bd(n.stateNode),Pl=r,Ll=s;break;case 5:_l||bl(n,t);case 6:if(r=Pl,s=Ll,Pl=null,Bl(e,t,n),Ll=s,null!==(Pl=r))if(Ll)try{(9===Pl.nodeType?Pl.body:"HTML"===Pl.nodeName?Pl.ownerDocument.body:Pl).removeChild(n.stateNode)}catch(i){Su(n,t,i)}else try{Pl.removeChild(n.stateNode)}catch(i){Su(n,t,i)}break;case 18:null!==Pl&&(Ll?(kd(9===(e=Pl).nodeType?e.body:"HTML"===e.nodeName?e.ownerDocument.body:e,n.stateNode),Vh(e)):kd(Pl,n.stateNode));break;case 4:r=Pl,s=Ll,Pl=n.stateNode.containerInfo,Ll=!0,Bl(e,t,n),Pl=r,Ll=s;break;case 0:case 11:case 14:case 15:yl(2,n,t),_l||yl(4,n,t),Bl(e,t,n);break;case 1:_l||(bl(n,t),"function"===typeof(r=n.stateNode).componentWillUnmount&&vl(n,t,r)),Bl(e,t,n);break;case 21:Bl(e,t,n);break;case 22:_l=(r=_l)||null!==n.memoizedState,Bl(e,t,n),_l=r;break;default:Bl(e,t,n)}}function Ul(e,t){if(null===t.memoizedState&&(null!==(e=t.alternate)&&null!==(e=e.memoizedState))){e=e.dehydrated;try{Vh(e)}catch(n){Su(t,t.return,n)}}}function Wl(e,t){if(null===t.memoizedState&&(null!==(e=t.alternate)&&(null!==(e=e.memoizedState)&&null!==(e=e.dehydrated))))try{Vh(e)}catch(n){Su(t,t.return,n)}}function zl(e,t){var n=function(e){switch(e.tag){case 31:case 13:case 19:var t=e.stateNode;return null===t&&(t=e.stateNode=new Ml),t;case 22:return null===(t=(e=e.stateNode)._retryCache)&&(t=e._retryCache=new Ml),t;default:throw Error(i(435,e.tag))}}(e);t.forEach(function(t){if(!n.has(t)){n.add(t);var r=Tu.bind(null,e,t);t.then(r,r)}})}function Hl(e,t){var n=t.deletions;if(null!==n)for(var r=0;r<n.length;r++){var s=n[r],a=e,o=t,l=o;e:for(;null!==l;){switch(l.tag){case 27:if(Nd(l.type)){Pl=l.stateNode,Ll=!1;break e}break;case 5:Pl=l.stateNode,Ll=!1;break e;case 3:case 4:Pl=l.stateNode.containerInfo,Ll=!0;break e}l=l.return}if(null===Pl)throw Error(i(160));Fl(a,o,s),Pl=null,Ll=!1,null!==(a=s.alternate)&&(a.return=null),s.return=null}if(13886&t.subtreeFlags)for(t=t.child;null!==t;)Gl(t,e),t=t.sibling}var Vl=null;function Gl(e,t){var n=e.alternate,r=e.flags;switch(e.tag){case 0:case 11:case 14:case 15:Hl(t,e),Jl(e),4&r&&(yl(3,e,e.return),gl(3,e),yl(5,e,e.return));break;case 1:Hl(t,e),Jl(e),512&r&&(_l||null===n||bl(n,n.return)),64&r&&Il&&(null!==(e=e.updateQueue)&&(null!==(r=e.callbacks)&&(n=e.shared.hiddenCallbacks,e.shared.hiddenCallbacks=null===n?r:n.concat(r))));break;case 26:var s=Vl;if(Hl(t,e),Jl(e),512&r&&(_l||null===n||bl(n,n.return)),4&r){var a=null!==n?n.memoizedState:null;if(r=e.memoizedState,null===n)if(null===r)if(null===e.stateNode){e:{r=e.type,n=e.memoizedProps,s=s.ownerDocument||s;t:switch(r){case"title":(!(a=s.getElementsByTagName("title")[0])||a[Ke]||a[We]||"http://www.w3.org/2000/svg"===a.namespaceURI||a.hasAttribute("itemprop"))&&(a=s.createElement(r),s.head.insertBefore(a,s.querySelector("head > title"))),hd(a,r,n),a[We]=e,et(a),r=a;break e;case"link":var o=nh("link","href",s).get(r+(n.href||""));if(o)for(var l=0;l<o.length;l++)if((a=o[l]).getAttribute("href")===(null==n.href||""===n.href?null:n.href)&&a.getAttribute("rel")===(null==n.rel?null:n.rel)&&a.getAttribute("title")===(null==n.title?null:n.title)&&a.getAttribute("crossorigin")===(null==n.crossOrigin?null:n.crossOrigin)){o.splice(l,1);break t}hd(a=s.createElement(r),r,n),s.head.appendChild(a);break;case"meta":if(o=nh("meta","content",s).get(r+(n.content||"")))for(l=0;l<o.length;l++)if((a=o[l]).getAttribute("content")===(null==n.content?null:""+n.content)&&a.getAttribute("name")===(null==n.name?null:n.name)&&a.getAttribute("property")===(null==n.property?null:n.property)&&a.getAttribute("http-equiv")===(null==n.httpEquiv?null:n.httpEquiv)&&a.getAttribute("charset")===(null==n.charSet?null:n.charSet)){o.splice(l,1);break t}hd(a=s.createElement(r),r,n),s.head.appendChild(a);break;default:throw Error(i(468,r))}a[We]=e,et(a),r=a}e.stateNode=r}else rh(s,e.type,e.stateNode);else e.stateNode=Xd(s,r,e.memoizedProps);else a!==r?(null===a?null!==n.stateNode&&(n=n.stateNode).parentNode.removeChild(n):a.count--,null===r?rh(s,e.type,e.stateNode):Xd(s,r,e.memoizedProps)):null===r&&null!==e.stateNode&&Sl(e,e.memoizedProps,n.memoizedProps)}break;case 27:Hl(t,e),Jl(e),512&r&&(_l||null===n||bl(n,n.return)),null!==n&&4&r&&Sl(e,e.memoizedProps,n.memoizedProps);break;case 5:if(Hl(t,e),Jl(e),512&r&&(_l||null===n||bl(n,n.return)),32&e.flags){s=e.stateNode;try{Ct(s,"")}catch(m){Su(e,e.return,m)}}4&r&&null!=e.stateNode&&Sl(e,s=e.memoizedProps,null!==n?n.memoizedProps:s),1024&r&&(Rl=!0);break;case 6:if(Hl(t,e),Jl(e),4&r){if(null===e.stateNode)throw Error(i(162));r=e.memoizedProps,n=e.stateNode;try{n.nodeValue=r}catch(m){Su(e,e.return,m)}}break;case 3:if(th=null,s=Vl,Vl=Wd(t.containerInfo),Hl(t,e),Vl=s,Jl(e),4&r&&null!==n&&n.memoizedState.isDehydrated)try{Vh(t.containerInfo)}catch(m){Su(e,e.return,m)}Rl&&(Rl=!1,Ql(e));break;case 4:r=Vl,Vl=Wd(e.stateNode.containerInfo),Hl(t,e),Jl(e),Vl=r;break;case 12:default:Hl(t,e),Jl(e);break;case 31:case 19:Hl(t,e),Jl(e),4&r&&(null!==(r=e.updateQueue)&&(e.updateQueue=null,zl(e,r)));break;case 13:Hl(t,e),Jl(e),8192&e.child.flags&&null!==e.memoizedState!==(null!==n&&null!==n.memoizedState)&&(Mc=le()),4&r&&(null!==(r=e.updateQueue)&&(e.updateQueue=null,zl(e,r)));break;case 22:s=null!==e.memoizedState;var c=null!==n&&null!==n.memoizedState,u=Il,d=_l;if(Il=u||s,_l=d||c,Hl(t,e),_l=d,Il=u,Jl(e),8192&r)e:for(t=e.stateNode,t._visibility=s?-2&t._visibility:1|t._visibility,s&&(null===n||c||Il||_l||Yl(e)),n=null,t=e;;){if(5===t.tag||26===t.tag){if(null===n){c=n=t;try{if(a=c.stateNode,s)"function"===typeof(o=a.style).setProperty?o.setProperty("display","none","important"):o.display="none";else{l=c.stateNode;var h=c.memoizedProps.style,f=void 0!==h&&null!==h&&h.hasOwnProperty("display")?h.display:null;l.style.display=null==f||"boolean"===typeof f?"":(""+f).trim()}}catch(m){Su(c,c.return,m)}}}else if(6===t.tag){if(null===n){c=t;try{c.stateNode.nodeValue=s?"":c.memoizedProps}catch(m){Su(c,c.return,m)}}}else if(18===t.tag){if(null===n){c=t;try{var p=c.stateNode;s?Td(p,!0):Td(c.stateNode,!1)}catch(m){Su(c,c.return,m)}}}else if((22!==t.tag&&23!==t.tag||null===t.memoizedState||t===e)&&null!==t.child){t.child.return=t,t=t.child;continue}if(t===e)break e;for(;null===t.sibling;){if(null===t.return||t.return===e)break e;n===t&&(n=null),t=t.return}n===t&&(n=null),t.sibling.return=t.return,t=t.sibling}4&r&&(null!==(r=e.updateQueue)&&(null!==(n=r.retryQueue)&&(r.retryQueue=null,zl(e,n))));case 30:case 21:}}function Jl(e){var t=e.flags;if(2&t){try{for(var n,r=e.return;null!==r;){if(Cl(r)){n=r;break}r=r.return}if(null==n)throw Error(i(160));switch(n.tag){case 27:var s=n.stateNode;kl(e,El(e),s);break;case 5:var a=n.stateNode;32&n.flags&&(Ct(a,""),n.flags&=-33),kl(e,El(e),a);break;case 3:case 4:var o=n.stateNode.containerInfo;Nl(e,El(e),o);break;default:throw Error(i(161))}}catch(l){Su(e,e.return,l)}e.flags&=-3}4096&t&&(e.flags&=-4097)}function Ql(e){if(1024&e.subtreeFlags)for(e=e.child;null!==e;){var t=e;Ql(t),5===t.tag&&1024&t.flags&&t.stateNode.reset(),e=e.sibling}}function Kl(e,t){if(8772&t.subtreeFlags)for(t=t.child;null!==t;)jl(e,t.alternate,t),t=t.sibling}function Yl(e){for(e=e.child;null!==e;){var t=e;switch(t.tag){case 0:case 11:case 14:case 15:yl(4,t,t.return),Yl(t);break;case 1:bl(t,t.return);var n=t.stateNode;"function"===typeof n.componentWillUnmount&&vl(t,t.return,n),Yl(t);break;case 27:Bd(t.stateNode);case 26:case 5:bl(t,t.return),Yl(t);break;case 22:null===t.memoizedState&&Yl(t);break;default:Yl(t)}e=e.sibling}}function ql(e,t,n){for(n=n&&0!==(8772&t.subtreeFlags),t=t.child;null!==t;){var r=t.alternate,s=e,a=t,i=a.flags;switch(a.tag){case 0:case 11:case 15:ql(s,a,n),gl(4,a);break;case 1:if(ql(s,a,n),"function"===typeof(s=(r=a).stateNode).componentDidMount)try{s.componentDidMount()}catch(c){Su(r,r.return,c)}if(null!==(s=(r=a).updateQueue)){var o=r.stateNode;try{var l=s.shared.hiddenCallbacks;if(null!==l)for(s.shared.hiddenCallbacks=null,s=0;s<l.length;s++)Ea(l[s],o)}catch(c){Su(r,r.return,c)}}n&&64&i&&wl(a),Al(a,a.return);break;case 27:Tl(a);case 26:case 5:ql(s,a,n),n&&null===r&&4&i&&xl(a),Al(a,a.return);break;case 12:ql(s,a,n);break;case 31:ql(s,a,n),n&&4&i&&Ul(s,a);break;case 13:ql(s,a,n),n&&4&i&&Wl(s,a);break;case 22:null===a.memoizedState&&ql(s,a,n),Al(a,a.return);break;case 30:break;default:ql(s,a,n)}t=t.sibling}}function Xl(e,t){var n=null;null!==e&&null!==e.memoizedState&&null!==e.memoizedState.cachePool&&(n=e.memoizedState.cachePool.pool),e=null,null!==t.memoizedState&&null!==t.memoizedState.cachePool&&(e=t.memoizedState.cachePool.pool),e!==n&&(null!=e&&e.refCount++,null!=n&&Us(n))}function Zl(e,t){e=null,null!==t.alternate&&(e=t.alternate.memoizedState.cache),(t=t.memoizedState.cache)!==e&&(t.refCount++,null!=e&&Us(e))}function $l(e,t,n,r){if(10256&t.subtreeFlags)for(t=t.child;null!==t;)ec(e,t,n,r),t=t.sibling}function ec(e,t,n,r){var s=t.flags;switch(t.tag){case 0:case 11:case 15:$l(e,t,n,r),2048&s&&gl(9,t);break;case 1:case 31:case 13:default:$l(e,t,n,r);break;case 3:$l(e,t,n,r),2048&s&&(e=null,null!==t.alternate&&(e=t.alternate.memoizedState.cache),(t=t.memoizedState.cache)!==e&&(t.refCount++,null!=e&&Us(e)));break;case 12:if(2048&s){$l(e,t,n,r),e=t.stateNode;try{var a=t.memoizedProps,i=a.id,o=a.onPostCommit;"function"===typeof o&&o(i,null===t.alternate?"mount":"update",e.passiveEffectDuration,-0)}catch(l){Su(t,t.return,l)}}else $l(e,t,n,r);break;case 23:break;case 22:a=t.stateNode,i=t.alternate,null!==t.memoizedState?2&a._visibility?$l(e,t,n,r):nc(e,t):2&a._visibility?$l(e,t,n,r):(a._visibility|=2,tc(e,t,n,r,0!==(10256&t.subtreeFlags)||!1)),2048&s&&Xl(i,t);break;case 24:$l(e,t,n,r),2048&s&&Zl(t.alternate,t)}}function tc(e,t,n,r,s){for(s=s&&(0!==(10256&t.subtreeFlags)||!1),t=t.child;null!==t;){var a=e,i=t,o=n,l=r,c=i.flags;switch(i.tag){case 0:case 11:case 15:tc(a,i,o,l,s),gl(8,i);break;case 23:break;case 22:var u=i.stateNode;null!==i.memoizedState?2&u._visibility?tc(a,i,o,l,s):nc(a,i):(u._visibility|=2,tc(a,i,o,l,s)),s&&2048&c&&Xl(i.alternate,i);break;case 24:tc(a,i,o,l,s),s&&2048&c&&Zl(i.alternate,i);break;default:tc(a,i,o,l,s)}t=t.sibling}}function nc(e,t){if(10256&t.subtreeFlags)for(t=t.child;null!==t;){var n=e,r=t,s=r.flags;switch(r.tag){case 22:nc(n,r),2048&s&&Xl(r.alternate,r);break;case 24:nc(n,r),2048&s&&Zl(r.alternate,r);break;default:nc(n,r)}t=t.sibling}}var rc=8192;function sc(e,t,n){if(e.subtreeFlags&rc)for(e=e.child;null!==e;)ac(e,t,n),e=e.sibling}function ac(e,t,n){switch(e.tag){case 26:sc(e,t,n),e.flags&rc&&null!==e.memoizedState&&function(e,t,n,r){if("stylesheet"===n.type&&("string"!==typeof r.media||!1!==matchMedia(r.media).matches)&&0===(4&n.state.loading)){if(null===n.instance){var s=Jd(r.href),a=t.querySelector(Qd(s));if(a)return null!==(t=a._p)&&"object"===typeof t&&"function"===typeof t.then&&(e.count++,e=ih.bind(e),t.then(e,e)),n.state.loading|=4,n.instance=a,void et(a);a=t.ownerDocument||t,r=Kd(r),(s=Fd.get(s))&&$d(r,s),et(a=a.createElement("link"));var i=a;i._p=new Promise(function(e,t){i.onload=e,i.onerror=t}),hd(a,"link",r),n.instance=a}null===e.stylesheets&&(e.stylesheets=new Map),e.stylesheets.set(n,t),(t=n.state.preload)&&0===(3&n.state.loading)&&(e.count++,n=ih.bind(e),t.addEventListener("load",n),t.addEventListener("error",n))}}(n,Vl,e.memoizedState,e.memoizedProps);break;case 5:default:sc(e,t,n);break;case 3:case 4:var r=Vl;Vl=Wd(e.stateNode.containerInfo),sc(e,t,n),Vl=r;break;case 22:null===e.memoizedState&&(null!==(r=e.alternate)&&null!==r.memoizedState?(r=rc,rc=16777216,sc(e,t,n),rc=r):sc(e,t,n))}}function ic(e){var t=e.alternate;if(null!==t&&null!==(e=t.child)){t.child=null;do{t=e.sibling,e.sibling=null,e=t}while(null!==e)}}function oc(e){var t=e.deletions;if(0!==(16&e.flags)){if(null!==t)for(var n=0;n<t.length;n++){var r=t[n];Dl=r,uc(r,e)}ic(e)}if(10256&e.subtreeFlags)for(e=e.child;null!==e;)lc(e),e=e.sibling}function lc(e){switch(e.tag){case 0:case 11:case 15:oc(e),2048&e.flags&&yl(9,e,e.return);break;case 3:case 12:default:oc(e);break;case 22:var t=e.stateNode;null!==e.memoizedState&&2&t._visibility&&(null===e.return||13!==e.return.tag)?(t._visibility&=-3,cc(e)):oc(e)}}function cc(e){var t=e.deletions;if(0!==(16&e.flags)){if(null!==t)for(var n=0;n<t.length;n++){var r=t[n];Dl=r,uc(r,e)}ic(e)}for(e=e.child;null!==e;){switch((t=e).tag){case 0:case 11:case 15:yl(8,t,t.return),cc(t);break;case 22:2&(n=t.stateNode)._visibility&&(n._visibility&=-3,cc(t));break;default:cc(t)}e=e.sibling}}function uc(e,t){for(;null!==Dl;){var n=Dl;switch(n.tag){case 0:case 11:case 15:yl(8,n,t);break;case 23:case 22:if(null!==n.memoizedState&&null!==n.memoizedState.cachePool){var r=n.memoizedState.cachePool.pool;null!=r&&r.refCount++}break;case 24:Us(n.memoizedState.cache)}if(null!==(r=n.child))r.return=n,Dl=r;else e:for(n=e;null!==Dl;){var s=(r=Dl).sibling,a=r.return;if(Ol(r),r===n){Dl=null;break e}if(null!==s){s.return=a,Dl=s;break e}Dl=a}}}var dc={getCacheForType:function(e){var t=Ms(Bs),n=t.data.get(e);return void 0===n&&(n=e(),t.data.set(e,n)),n},cacheSignal:function(){return Ms(Bs).controller.signal}},hc="function"===typeof WeakMap?WeakMap:Map,fc=0,pc=null,mc=null,gc=0,yc=0,wc=null,vc=!1,Ac=!1,bc=!1,xc=0,Sc=0,Cc=0,Ec=0,Nc=0,kc=0,Tc=0,Ic=null,_c=null,Rc=!1,Mc=0,Dc=0,jc=1/0,Oc=null,Pc=null,Lc=0,Bc=null,Fc=null,Uc=0,Wc=0,zc=null,Hc=null,Vc=0,Gc=null;function Jc(){return 0!==(2&fc)&&0!==gc?gc&-gc:null!==j.T?zu():Be()}function Qc(){if(0===kc)if(0===(536870912&gc)||ds){var e=Ce;0===(3932160&(Ce<<=1))&&(Ce=262144),kc=e}else kc=536870912;return null!==(e=Ma.current)&&(e.flags|=32),kc}function Kc(e,t,n){(e!==pc||2!==yc&&9!==yc)&&null===e.cancelPendingCommit||(tu(e,0),Zc(e,gc,kc,!1)),Me(e,n),0!==(2&fc)&&e===pc||(e===pc&&(0===(2&fc)&&(Ec|=n),4===Sc&&Zc(e,gc,kc,!1)),Ou(e))}function Yc(e,t,n){if(0!==(6&fc))throw Error(i(327));for(var r=!n&&0===(127&t)&&0===(t&e.expiredLanes)||Te(e,t),s=r?function(e,t){var n=fc;fc|=2;var r=su(),s=au();pc!==e||gc!==t?(Oc=null,jc=le()+500,tu(e,t)):Ac=Te(e,t);e:for(;;)try{if(0!==yc&&null!==mc){t=mc;var a=wc;t:switch(yc){case 1:yc=0,wc=null,hu(e,t,a,1);break;case 2:case 9:if(ta(a)){yc=0,wc=null,du(t);break}t=function(){2!==yc&&9!==yc||pc!==e||(yc=7),Ou(e)},a.then(t,t);break e;case 3:yc=7;break e;case 4:yc=5;break e;case 7:ta(a)?(yc=0,wc=null,du(t)):(yc=0,wc=null,hu(e,t,a,7));break;case 5:var o=null;switch(mc.tag){case 26:o=mc.memoizedState;case 5:case 27:var l=mc;if(o?sh(o):l.stateNode.complete){yc=0,wc=null;var c=l.sibling;if(null!==c)mc=c;else{var u=l.return;null!==u?(mc=u,fu(u)):mc=null}break t}}yc=0,wc=null,hu(e,t,a,5);break;case 6:yc=0,wc=null,hu(e,t,a,6);break;case 8:eu(),Sc=6;break e;default:throw Error(i(462))}}cu();break}catch(d){nu(e,d)}return Cs=Ss=null,j.H=r,j.A=s,fc=n,null!==mc?0:(pc=null,gc=0,_r(),Sc)}(e,t):ou(e,t,!0),a=r;;){if(0===s){Ac&&!r&&Zc(e,t,0,!1);break}if(n=e.current.alternate,!a||Xc(n)){if(2===s){if(a=t,e.errorRecoveryDisabledLanes&a)var o=0;else o=0!==(o=-536870913&e.pendingLanes)?o:536870912&o?536870912:0;if(0!==o){t=o;e:{var l=e;s=Ic;var c=l.current.memoizedState.isDehydrated;if(c&&(tu(l,o).flags|=256),2!==(o=ou(l,o,!1))){if(bc&&!c){l.errorRecoveryDisabledLanes|=a,Ec|=a,s=4;break e}a=_c,_c=s,null!==a&&(null===_c?_c=a:_c.push.apply(_c,a))}s=o}if(a=!1,2!==s)continue}}if(1===s){tu(e,0),Zc(e,t,0,!0);break}e:{switch(r=e,a=s){case 0:case 1:throw Error(i(345));case 4:if((4194048&t)!==t)break;case 6:Zc(r,t,kc,!vc);break e;case 2:_c=null;break;case 3:case 5:break;default:throw Error(i(329))}if((62914560&t)===t&&10<(s=Mc+300-le())){if(Zc(r,t,kc,!vc),0!==ke(r,0,!0))break e;Uc=t,r.timeoutHandle=bd(qc.bind(null,r,n,_c,Oc,Rc,t,kc,Ec,Tc,vc,a,"Throttled",-0,0),s)}else qc(r,n,_c,Oc,Rc,t,kc,Ec,Tc,vc,a,null,-0,0)}break}s=ou(e,t,!1),a=!1}Ou(e)}function qc(e,t,n,r,s,a,i,o,l,c,u,d,h,f){if(e.timeoutHandle=-1,8192&(d=t.subtreeFlags)||16785408===(16785408&d)){ac(t,a,d={stylesheets:null,count:0,imgCount:0,imgBytes:0,suspenseyImages:[],waitingForImages:!0,waitingForViewTransition:!1,unsuspend:Mt});var p=(62914560&a)===a?Mc-le():(4194048&a)===a?Dc-le():0;if(null!==(p=function(e,t){return e.stylesheets&&0===e.count&&lh(e,e.stylesheets),0<e.count||0<e.imgCount?function(n){var r=setTimeout(function(){if(e.stylesheets&&lh(e,e.stylesheets),e.unsuspend){var t=e.unsuspend;e.unsuspend=null,t()}},6e4+t);0<e.imgBytes&&0===ah&&(ah=62500*function(){if("function"===typeof performance.getEntriesByType){for(var e=0,t=0,n=performance.getEntriesByType("resource"),r=0;r<n.length;r++){var s=n[r],a=s.transferSize,i=s.initiatorType,o=s.duration;if(a&&o&&fd(i)){for(i=0,o=s.responseEnd,r+=1;r<n.length;r++){var l=n[r],c=l.startTime;if(c>o)break;var u=l.transferSize,d=l.initiatorType;u&&fd(d)&&(i+=u*((l=l.responseEnd)<o?1:(o-c)/(l-c)))}if(--r,t+=8*(a+i)/(s.duration/1e3),10<++e)break}}if(0<e)return t/e/1e6}return navigator.connection&&"number"===typeof(e=navigator.connection.downlink)?e:5}());var s=setTimeout(function(){if(e.waitingForImages=!1,0===e.count&&(e.stylesheets&&lh(e,e.stylesheets),e.unsuspend)){var t=e.unsuspend;e.unsuspend=null,t()}},(e.imgBytes>ah?50:800)+t);return e.unsuspend=n,function(){e.unsuspend=null,clearTimeout(r),clearTimeout(s)}}:null}(d,p)))return Uc=a,e.cancelPendingCommit=p(mu.bind(null,e,t,a,n,r,s,i,o,l,u,d,null,h,f)),void Zc(e,a,i,!c)}mu(e,t,a,n,r,s,i,o,l)}function Xc(e){for(var t=e;;){var n=t.tag;if((0===n||11===n||15===n)&&16384&t.flags&&(null!==(n=t.updateQueue)&&null!==(n=n.stores)))for(var r=0;r<n.length;r++){var s=n[r],a=s.getSnapshot;s=s.value;try{if(!Zn(a(),s))return!1}catch(i){return!1}}if(n=t.child,16384&t.subtreeFlags&&null!==n)n.return=t,t=n;else{if(t===e)break;for(;null===t.sibling;){if(null===t.return||t.return===e)return!0;t=t.return}t.sibling.return=t.return,t=t.sibling}}return!0}function Zc(e,t,n,r){t&=~Nc,t&=~Ec,e.suspendedLanes|=t,e.pingedLanes&=~t,r&&(e.warmLanes|=t),r=e.expirationTimes;for(var s=t;0<s;){var a=31-Ae(s),i=1<<a;r[a]=-1,s&=~i}0!==n&&De(e,n,t)}function $c(){return 0!==(6&fc)||(Pu(0,!1),!1)}function eu(){if(null!==mc){if(0===yc)var e=mc.return;else Cs=Ss=null,ii(e=mc),oa=null,la=0,e=mc;for(;null!==e;)ml(e.alternate,e),e=e.return;mc=null}}function tu(e,t){var n=e.timeoutHandle;-1!==n&&(e.timeoutHandle=-1,xd(n)),null!==(n=e.cancelPendingCommit)&&(e.cancelPendingCommit=null,n()),Uc=0,eu(),pc=e,mc=n=Ur(e.current,null),gc=t,yc=0,wc=null,vc=!1,Ac=Te(e,t),bc=!1,Tc=kc=Nc=Ec=Cc=Sc=0,_c=Ic=null,Rc=!1,0!==(8&t)&&(t|=32&t);var r=e.entangledLanes;if(0!==r)for(e=e.entanglements,r&=t;0<r;){var s=31-Ae(r),a=1<<s;t|=e[s],r&=~a}return xc=t,_r(),n}function nu(e,t){za=null,j.H=mo,t===Xs||t===$s?(t=aa(),yc=3):t===Zs?(t=aa(),yc=4):yc=t===Mo?8:null!==t&&"object"===typeof t&&"function"===typeof t.then?6:1,wc=t,null===mc&&(Sc=1,ko(e,Kr(t,e.current)))}function ru(){var e=Ma.current;return null===e||((4194048&gc)===gc?null===Da:((62914560&gc)===gc||0!==(536870912&gc))&&e===Da)}function su(){var e=j.H;return j.H=mo,null===e?mo:e}function au(){var e=j.A;return j.A=dc,e}function iu(){Sc=4,vc||(4194048&gc)!==gc&&null!==Ma.current||(Ac=!0),0===(134217727&Cc)&&0===(134217727&Ec)||null===pc||Zc(pc,gc,kc,!1)}function ou(e,t,n){var r=fc;fc|=2;var s=su(),a=au();pc===e&&gc===t||(Oc=null,tu(e,t)),t=!1;var i=Sc;e:for(;;)try{if(0!==yc&&null!==mc){var o=mc,l=wc;switch(yc){case 8:eu(),i=6;break e;case 3:case 2:case 9:case 6:null===Ma.current&&(t=!0);var c=yc;if(yc=0,wc=null,hu(e,o,l,c),n&&Ac){i=0;break e}break;default:c=yc,yc=0,wc=null,hu(e,o,l,c)}}lu(),i=Sc;break}catch(u){nu(e,u)}return t&&e.shellSuspendCounter++,Cs=Ss=null,fc=r,j.H=s,j.A=a,null===mc&&(pc=null,gc=0,_r()),i}function lu(){for(;null!==mc;)uu(mc)}function cu(){for(;null!==mc&&!ie();)uu(mc)}function uu(e){var t=il(e.alternate,e,xc);e.memoizedProps=e.pendingProps,null===t?fu(e):mc=t}function du(e){var t=e,n=t.alternate;switch(t.tag){case 15:case 0:t=Go(n,t,t.pendingProps,t.type,void 0,gc);break;case 11:t=Go(n,t,t.pendingProps,t.type.render,t.ref,gc);break;case 5:ii(t);default:ml(n,t),t=il(n,t=mc=Wr(t,xc),xc)}e.memoizedProps=e.pendingProps,null===t?fu(e):mc=t}function hu(e,t,n,r){Cs=Ss=null,ii(t),oa=null,la=0;var s=t.return;try{if(function(e,t,n,r,s){if(n.flags|=32768,null!==r&&"object"===typeof r&&"function"===typeof r.then){if(null!==(t=n.alternate)&&Is(t,n,s,!0),null!==(n=Ma.current)){switch(n.tag){case 31:case 13:return null===Da?iu():null===n.alternate&&0===Sc&&(Sc=3),n.flags&=-257,n.flags|=65536,n.lanes=s,r===ea?n.flags|=16384:(null===(t=n.updateQueue)?n.updateQueue=new Set([r]):t.add(r),Cu(e,r,s)),!1;case 22:return n.flags|=65536,r===ea?n.flags|=16384:(null===(t=n.updateQueue)?(t={transitions:null,markerInstances:null,retryQueue:new Set([r])},n.updateQueue=t):null===(n=t.retryQueue)?t.retryQueue=new Set([r]):n.add(r),Cu(e,r,s)),!1}throw Error(i(435,n.tag))}return Cu(e,r,s),iu(),!1}if(ds)return null!==(t=Ma.current)?(0===(65536&t.flags)&&(t.flags|=256),t.flags|=65536,t.lanes=s,r!==ps&&bs(Kr(e=Error(i(422),{cause:r}),n))):(r!==ps&&bs(Kr(t=Error(i(423),{cause:r}),n)),(e=e.current.alternate).flags|=65536,s&=-s,e.lanes|=s,r=Kr(r,n),ba(e,s=Io(e.stateNode,r,s)),4!==Sc&&(Sc=2)),!1;var a=Error(i(520),{cause:r});if(a=Kr(a,n),null===Ic?Ic=[a]:Ic.push(a),4!==Sc&&(Sc=2),null===t)return!0;r=Kr(r,n),n=t;do{switch(n.tag){case 3:return n.flags|=65536,e=s&-s,n.lanes|=e,ba(n,e=Io(n.stateNode,r,e)),!1;case 1:if(t=n.type,a=n.stateNode,0===(128&n.flags)&&("function"===typeof t.getDerivedStateFromError||null!==a&&"function"===typeof a.componentDidCatch&&(null===Pc||!Pc.has(a))))return n.flags|=65536,s&=-s,n.lanes|=s,Ro(s=_o(s),e,n,r),ba(n,s),!1}n=n.return}while(null!==n);return!1}(e,s,t,n,gc))return Sc=1,ko(e,Kr(n,e.current)),void(mc=null)}catch(a){if(null!==s)throw mc=s,a;return Sc=1,ko(e,Kr(n,e.current)),void(mc=null)}32768&t.flags?(ds||1===r?e=!0:Ac||0!==(536870912&gc)?e=!1:(vc=e=!0,(2===r||9===r||3===r||6===r)&&(null!==(r=Ma.current)&&13===r.tag&&(r.flags|=16384))),pu(t,e)):fu(t)}function fu(e){var t=e;do{if(0!==(32768&t.flags))return void pu(t,vc);e=t.return;var n=fl(t.alternate,t,xc);if(null!==n)return void(mc=n);if(null!==(t=t.sibling))return void(mc=t);mc=t=e}while(null!==t);0===Sc&&(Sc=5)}function pu(e,t){do{var n=pl(e.alternate,e);if(null!==n)return n.flags&=32767,void(mc=n);if(null!==(n=e.return)&&(n.flags|=32768,n.subtreeFlags=0,n.deletions=null),!t&&null!==(e=e.sibling))return void(mc=e);mc=e=n}while(null!==e);Sc=6,mc=null}function mu(e,t,n,r,s,a,o,l,c){e.cancelPendingCommit=null;do{Au()}while(0!==Lc);if(0!==(6&fc))throw Error(i(327));if(null!==t){if(t===e.current)throw Error(i(177));if(a=t.lanes|t.childLanes,function(e,t,n,r,s,a){var i=e.pendingLanes;e.pendingLanes=n,e.suspendedLanes=0,e.pingedLanes=0,e.warmLanes=0,e.expiredLanes&=n,e.entangledLanes&=n,e.errorRecoveryDisabledLanes&=n,e.shellSuspendCounter=0;var o=e.entanglements,l=e.expirationTimes,c=e.hiddenUpdates;for(n=i&~n;0<n;){var u=31-Ae(n),d=1<<u;o[u]=0,l[u]=-1;var h=c[u];if(null!==h)for(c[u]=null,u=0;u<h.length;u++){var f=h[u];null!==f&&(f.lane&=-536870913)}n&=~d}0!==r&&De(e,r,0),0!==a&&0===s&&0!==e.tag&&(e.suspendedLanes|=a&~(i&~t))}(e,n,a|=Ir,o,l,c),e===pc&&(mc=pc=null,gc=0),Fc=t,Bc=e,Uc=n,Wc=a,zc=s,Hc=r,0!==(10256&t.subtreeFlags)||0!==(10256&t.flags)?(e.callbackNode=null,e.callbackPriority=0,se(he,function(){return bu(),null})):(e.callbackNode=null,e.callbackPriority=0),r=0!==(13878&t.flags),0!==(13878&t.subtreeFlags)||r){r=j.T,j.T=null,s=O.p,O.p=2,o=fc,fc|=4;try{!function(e,t){if(e=e.containerInfo,pd=vh,sr(e=rr(e))){if("selectionStart"in e)var n={start:e.selectionStart,end:e.selectionEnd};else e:{var r=(n=(n=e.ownerDocument)&&n.defaultView||window).getSelection&&n.getSelection();if(r&&0!==r.rangeCount){n=r.anchorNode;var s=r.anchorOffset,a=r.focusNode;r=r.focusOffset;try{n.nodeType,a.nodeType}catch(g){n=null;break e}var o=0,l=-1,c=-1,u=0,d=0,h=e,f=null;t:for(;;){for(var p;h!==n||0!==s&&3!==h.nodeType||(l=o+s),h!==a||0!==r&&3!==h.nodeType||(c=o+r),3===h.nodeType&&(o+=h.nodeValue.length),null!==(p=h.firstChild);)f=h,h=p;for(;;){if(h===e)break t;if(f===n&&++u===s&&(l=o),f===a&&++d===r&&(c=o),null!==(p=h.nextSibling))break;f=(h=f).parentNode}h=p}n=-1===l||-1===c?null:{start:l,end:c}}else n=null}n=n||{start:0,end:0}}else n=null;for(md={focusedElem:e,selectionRange:n},vh=!1,Dl=t;null!==Dl;)if(e=(t=Dl).child,0!==(1028&t.subtreeFlags)&&null!==e)e.return=t,Dl=e;else for(;null!==Dl;){switch(a=(t=Dl).alternate,e=t.flags,t.tag){case 0:if(0!==(4&e)&&null!==(e=null!==(e=t.updateQueue)?e.events:null))for(n=0;n<e.length;n++)(s=e[n]).ref.impl=s.nextImpl;break;case 11:case 15:case 5:case 26:case 27:case 6:case 4:case 17:break;case 1:if(0!==(1024&e)&&null!==a){e=void 0,n=t,s=a.memoizedProps,a=a.memoizedState,r=n.stateNode;try{var m=So(n.type,s);e=r.getSnapshotBeforeUpdate(m,a),r.__reactInternalSnapshotBeforeUpdate=e}catch(y){Su(n,n.return,y)}}break;case 3:if(0!==(1024&e))if(9===(n=(e=t.stateNode.containerInfo).nodeType))Id(e);else if(1===n)switch(e.nodeName){case"HEAD":case"HTML":case"BODY":Id(e);break;default:e.textContent=""}break;default:if(0!==(1024&e))throw Error(i(163))}if(null!==(e=t.sibling)){e.return=t.return,Dl=e;break}Dl=t.return}}(e,t)}finally{fc=o,O.p=s,j.T=r}}Lc=1,gu(),yu(),wu()}}function gu(){if(1===Lc){Lc=0;var e=Bc,t=Fc,n=0!==(13878&t.flags);if(0!==(13878&t.subtreeFlags)||n){n=j.T,j.T=null;var r=O.p;O.p=2;var s=fc;fc|=4;try{Gl(t,e);var a=md,i=rr(e.containerInfo),o=a.focusedElem,l=a.selectionRange;if(i!==o&&o&&o.ownerDocument&&nr(o.ownerDocument.documentElement,o)){if(null!==l&&sr(o)){var c=l.start,u=l.end;if(void 0===u&&(u=c),"selectionStart"in o)o.selectionStart=c,o.selectionEnd=Math.min(u,o.value.length);else{var d=o.ownerDocument||document,h=d&&d.defaultView||window;if(h.getSelection){var f=h.getSelection(),p=o.textContent.length,m=Math.min(l.start,p),g=void 0===l.end?m:Math.min(l.end,p);!f.extend&&m>g&&(i=g,g=m,m=i);var y=tr(o,m),w=tr(o,g);if(y&&w&&(1!==f.rangeCount||f.anchorNode!==y.node||f.anchorOffset!==y.offset||f.focusNode!==w.node||f.focusOffset!==w.offset)){var v=d.createRange();v.setStart(y.node,y.offset),f.removeAllRanges(),m>g?(f.addRange(v),f.extend(w.node,w.offset)):(v.setEnd(w.node,w.offset),f.addRange(v))}}}}for(d=[],f=o;f=f.parentNode;)1===f.nodeType&&d.push({element:f,left:f.scrollLeft,top:f.scrollTop});for("function"===typeof o.focus&&o.focus(),o=0;o<d.length;o++){var A=d[o];A.element.scrollLeft=A.left,A.element.scrollTop=A.top}}vh=!!pd,md=pd=null}finally{fc=s,O.p=r,j.T=n}}e.current=t,Lc=2}}function yu(){if(2===Lc){Lc=0;var e=Bc,t=Fc,n=0!==(8772&t.flags);if(0!==(8772&t.subtreeFlags)||n){n=j.T,j.T=null;var r=O.p;O.p=2;var s=fc;fc|=4;try{jl(e,t.alternate,t)}finally{fc=s,O.p=r,j.T=n}}Lc=3}}function wu(){if(4===Lc||3===Lc){Lc=0,oe();var e=Bc,t=Fc,n=Uc,r=Hc;0!==(10256&t.subtreeFlags)||0!==(10256&t.flags)?Lc=5:(Lc=0,Fc=Bc=null,vu(e,e.pendingLanes));var s=e.pendingLanes;if(0===s&&(Pc=null),Le(n),t=t.stateNode,we&&"function"===typeof we.onCommitFiberRoot)try{we.onCommitFiberRoot(ye,t,void 0,128===(128&t.current.flags))}catch(l){}if(null!==r){t=j.T,s=O.p,O.p=2,j.T=null;try{for(var a=e.onRecoverableError,i=0;i<r.length;i++){var o=r[i];a(o.value,{componentStack:o.stack})}}finally{j.T=t,O.p=s}}0!==(3&Uc)&&Au(),Ou(e),s=e.pendingLanes,0!==(261930&n)&&0!==(42&s)?e===Gc?Vc++:(Vc=0,Gc=e):Vc=0,Pu(0,!1)}}function vu(e,t){0===(e.pooledCacheLanes&=t)&&(null!=(t=e.pooledCache)&&(e.pooledCache=null,Us(t)))}function Au(){return gu(),yu(),wu(),bu()}function bu(){if(5!==Lc)return!1;var e=Bc,t=Wc;Wc=0;var n=Le(Uc),r=j.T,s=O.p;try{O.p=32>n?32:n,j.T=null,n=zc,zc=null;var a=Bc,o=Uc;if(Lc=0,Fc=Bc=null,Uc=0,0!==(6&fc))throw Error(i(331));var l=fc;if(fc|=4,lc(a.current),ec(a,a.current,o,n),fc=l,Pu(0,!1),we&&"function"===typeof we.onPostCommitFiberRoot)try{we.onPostCommitFiberRoot(ye,a)}catch(c){}return!0}finally{O.p=s,j.T=r,vu(e,t)}}function xu(e,t,n){t=Kr(n,t),null!==(e=va(e,t=Io(e.stateNode,t,2),2))&&(Me(e,2),Ou(e))}function Su(e,t,n){if(3===e.tag)xu(e,e,n);else for(;null!==t;){if(3===t.tag){xu(t,e,n);break}if(1===t.tag){var r=t.stateNode;if("function"===typeof t.type.getDerivedStateFromError||"function"===typeof r.componentDidCatch&&(null===Pc||!Pc.has(r))){e=Kr(n,e),null!==(r=va(t,n=_o(2),2))&&(Ro(n,r,t,e),Me(r,2),Ou(r));break}}t=t.return}}function Cu(e,t,n){var r=e.pingCache;if(null===r){r=e.pingCache=new hc;var s=new Set;r.set(t,s)}else void 0===(s=r.get(t))&&(s=new Set,r.set(t,s));s.has(n)||(bc=!0,s.add(n),e=Eu.bind(null,e,t,n),t.then(e,e))}function Eu(e,t,n){var r=e.pingCache;null!==r&&r.delete(t),e.pingedLanes|=e.suspendedLanes&n,e.warmLanes&=~n,pc===e&&(gc&n)===n&&(4===Sc||3===Sc&&(62914560&gc)===gc&&300>le()-Mc?0===(2&fc)&&tu(e,0):Nc|=n,Tc===gc&&(Tc=0)),Ou(e)}function Nu(e,t){0===t&&(t=_e()),null!==(e=Dr(e,t))&&(Me(e,t),Ou(e))}function ku(e){var t=e.memoizedState,n=0;null!==t&&(n=t.retryLane),Nu(e,n)}function Tu(e,t){var n=0;switch(e.tag){case 31:case 13:var r=e.stateNode,s=e.memoizedState;null!==s&&(n=s.retryLane);break;case 19:r=e.stateNode;break;case 22:r=e.stateNode._retryCache;break;default:throw Error(i(314))}null!==r&&r.delete(t),Nu(e,n)}var Iu=null,_u=null,Ru=!1,Mu=!1,Du=!1,ju=0;function Ou(e){e!==_u&&null===e.next&&(null===_u?Iu=_u=e:_u=_u.next=e),Mu=!0,Ru||(Ru=!0,Cd(function(){0!==(6&fc)?se(ue,Lu):Bu()}))}function Pu(e,t){if(!Du&&Mu){Du=!0;do{for(var n=!1,r=Iu;null!==r;){if(!t)if(0!==e){var s=r.pendingLanes;if(0===s)var a=0;else{var i=r.suspendedLanes,o=r.pingedLanes;a=(1<<31-Ae(42|e)+1)-1,a=201326741&(a&=s&~(i&~o))?201326741&a|1:a?2|a:0}0!==a&&(n=!0,Wu(r,a))}else a=gc,0===(3&(a=ke(r,r===pc?a:0,null!==r.cancelPendingCommit||-1!==r.timeoutHandle)))||Te(r,a)||(n=!0,Wu(r,a));r=r.next}}while(n);Du=!1}}function Lu(){Bu()}function Bu(){Mu=Ru=!1;var e=0;0!==ju&&function(){var e=window.event;if(e&&"popstate"===e.type)return e!==Ad&&(Ad=e,!0);return Ad=null,!1}()&&(e=ju);for(var t=le(),n=null,r=Iu;null!==r;){var s=r.next,a=Fu(r,t);0===a?(r.next=null,null===n?Iu=s:n.next=s,null===s&&(_u=n)):(n=r,(0!==e||0!==(3&a))&&(Mu=!0)),r=s}0!==Lc&&5!==Lc||Pu(e,!1),0!==ju&&(ju=0)}function Fu(e,t){for(var n=e.suspendedLanes,r=e.pingedLanes,s=e.expirationTimes,a=-62914561&e.pendingLanes;0<a;){var i=31-Ae(a),o=1<<i,l=s[i];-1===l?0!==(o&n)&&0===(o&r)||(s[i]=Ie(o,t)):l<=t&&(e.expiredLanes|=o),a&=~o}if(n=gc,n=ke(e,e===(t=pc)?n:0,null!==e.cancelPendingCommit||-1!==e.timeoutHandle),r=e.callbackNode,0===n||e===t&&(2===yc||9===yc)||null!==e.cancelPendingCommit)return null!==r&&null!==r&&ae(r),e.callbackNode=null,e.callbackPriority=0;if(0===(3&n)||Te(e,n)){if((t=n&-n)===e.callbackPriority)return t;switch(null!==r&&ae(r),Le(n)){case 2:case 8:n=de;break;case 32:default:n=he;break;case 268435456:n=pe}return r=Uu.bind(null,e),n=se(n,r),e.callbackPriority=t,e.callbackNode=n,t}return null!==r&&null!==r&&ae(r),e.callbackPriority=2,e.callbackNode=null,2}function Uu(e,t){if(0!==Lc&&5!==Lc)return e.callbackNode=null,e.callbackPriority=0,null;var n=e.callbackNode;if(Au()&&e.callbackNode!==n)return null;var r=gc;return 0===(r=ke(e,e===pc?r:0,null!==e.cancelPendingCommit||-1!==e.timeoutHandle))?null:(Yc(e,r,t),Fu(e,le()),null!=e.callbackNode&&e.callbackNode===n?Uu.bind(null,e):null)}function Wu(e,t){if(Au())return null;Yc(e,t,!0)}function zu(){if(0===ju){var e=Hs;0===e&&(e=Se,0===(261888&(Se<<=1))&&(Se=256)),ju=e}return ju}function Hu(e){return null==e||"symbol"===typeof e||"boolean"===typeof e?null:"function"===typeof e?e:Rt(""+e)}function Vu(e,t){var n=t.ownerDocument.createElement("input");return n.name=t.name,n.value=t.value,e.id&&n.setAttribute("form",e.id),t.parentNode.insertBefore(n,t),e=new FormData(e),n.parentNode.removeChild(n),e}for(var Gu=0;Gu<Cr.length;Gu++){var Ju=Cr[Gu];Er(Ju.toLowerCase(),"on"+(Ju[0].toUpperCase()+Ju.slice(1)))}Er(gr,"onAnimationEnd"),Er(yr,"onAnimationIteration"),Er(wr,"onAnimationStart"),Er("dblclick","onDoubleClick"),Er("focusin","onFocus"),Er("focusout","onBlur"),Er(vr,"onTransitionRun"),Er(Ar,"onTransitionStart"),Er(br,"onTransitionCancel"),Er(xr,"onTransitionEnd"),st("onMouseEnter",["mouseout","mouseover"]),st("onMouseLeave",["mouseout","mouseover"]),st("onPointerEnter",["pointerout","pointerover"]),st("onPointerLeave",["pointerout","pointerover"]),rt("onChange","change click focusin focusout input keydown keyup selectionchange".split(" ")),rt("onSelect","focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" ")),rt("onBeforeInput",["compositionend","keypress","textInput","paste"]),rt("onCompositionEnd","compositionend focusout keydown keypress keyup mousedown".split(" ")),rt("onCompositionStart","compositionstart focusout keydown keypress keyup mousedown".split(" ")),rt("onCompositionUpdate","compositionupdate focusout keydown keypress keyup mousedown".split(" "));var Qu="abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange resize seeked seeking stalled suspend timeupdate volumechange waiting".split(" "),Ku=new Set("beforetoggle cancel close invalid load scroll scrollend toggle".split(" ").concat(Qu));function Yu(e,t){t=0!==(4&t);for(var n=0;n<e.length;n++){var r=e[n],s=r.event;r=r.listeners;e:{var a=void 0;if(t)for(var i=r.length-1;0<=i;i--){var o=r[i],l=o.instance,c=o.currentTarget;if(o=o.listener,l!==a&&s.isPropagationStopped())break e;a=o,s.currentTarget=c;try{a(s)}catch(u){Nr(u)}s.currentTarget=null,a=l}else for(i=0;i<r.length;i++){if(l=(o=r[i]).instance,c=o.currentTarget,o=o.listener,l!==a&&s.isPropagationStopped())break e;a=o,s.currentTarget=c;try{a(s)}catch(u){Nr(u)}s.currentTarget=null,a=l}}}}function qu(e,t){var n=t[Ve];void 0===n&&(n=t[Ve]=new Set);var r=e+"__bubble";n.has(r)||(ed(t,e,2,!1),n.add(r))}function Xu(e,t,n){var r=0;t&&(r|=4),ed(n,e,r,t)}var Zu="_reactListening"+Math.random().toString(36).slice(2);function $u(e){if(!e[Zu]){e[Zu]=!0,tt.forEach(function(t){"selectionchange"!==t&&(Ku.has(t)||Xu(t,!1,e),Xu(t,!0,e))});var t=9===e.nodeType?e:e.ownerDocument;null===t||t[Zu]||(t[Zu]=!0,Xu("selectionchange",!1,t))}}function ed(e,t,n,r){switch(Nh(t)){case 2:var s=Ah;break;case 8:s=bh;break;default:s=xh}n=s.bind(null,t,n,e),s=void 0,!zt||"touchstart"!==t&&"touchmove"!==t&&"wheel"!==t||(s=!0),r?void 0!==s?e.addEventListener(t,n,{capture:!0,passive:s}):e.addEventListener(t,n,!0):void 0!==s?e.addEventListener(t,n,{passive:s}):e.addEventListener(t,n,!1)}function td(e,t,n,r,s){var a=r;if(0===(1&t)&&0===(2&t)&&null!==r)e:for(;;){if(null===r)return;var i=r.tag;if(3===i||4===i){var o=r.stateNode.containerInfo;if(o===s)break;if(4===i)for(i=r.return;null!==i;){var c=i.tag;if((3===c||4===c)&&i.stateNode.containerInfo===s)return;i=i.return}for(;null!==o;){if(null===(i=qe(o)))return;if(5===(c=i.tag)||6===c||26===c||27===c){r=a=i;continue e}o=o.parentNode}}r=r.return}Ft(function(){var r=a,s=jt(n),i=[];e:{var o=Sr.get(e);if(void 0!==o){var c=nn,u=e;switch(e){case"keypress":if(0===Kt(n))break e;case"keydown":case"keyup":c=wn;break;case"focusin":u="focus",c=cn;break;case"focusout":u="blur",c=cn;break;case"beforeblur":case"afterblur":c=cn;break;case"click":if(2===n.button)break e;case"auxclick":case"dblclick":case"mousedown":case"mousemove":case"mouseup":case"mouseout":case"mouseover":case"contextmenu":c=on;break;case"drag":case"dragend":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"dragstart":case"drop":c=ln;break;case"touchcancel":case"touchend":case"touchmove":case"touchstart":c=An;break;case gr:case yr:case wr:c=un;break;case xr:c=bn;break;case"scroll":case"scrollend":c=sn;break;case"wheel":c=xn;break;case"copy":case"cut":case"paste":c=dn;break;case"gotpointercapture":case"lostpointercapture":case"pointercancel":case"pointerdown":case"pointermove":case"pointerout":case"pointerover":case"pointerup":c=vn;break;case"toggle":case"beforetoggle":c=Sn}var d=0!==(4&t),h=!d&&("scroll"===e||"scrollend"===e),f=d?null!==o?o+"Capture":null:o;d=[];for(var p,m=r;null!==m;){var g=m;if(p=g.stateNode,5!==(g=g.tag)&&26!==g&&27!==g||null===p||null===f||null!=(g=Ut(m,f))&&d.push(nd(m,g,p)),h)break;m=m.return}0<d.length&&(o=new c(o,u,null,n,s),i.push({event:o,listeners:d}))}}if(0===(7&t)){if(c="mouseout"===e||"pointerout"===e,(!(o="mouseover"===e||"pointerover"===e)||n===Dt||!(u=n.relatedTarget||n.fromElement)||!qe(u)&&!u[He])&&(c||o)&&(o=s.window===s?s:(o=s.ownerDocument)?o.defaultView||o.parentWindow:window,c?(c=r,null!==(u=(u=n.relatedTarget||n.toElement)?qe(u):null)&&(h=l(u),d=u.tag,u!==h||5!==d&&27!==d&&6!==d)&&(u=null)):(c=null,u=r),c!==u)){if(d=on,g="onMouseLeave",f="onMouseEnter",m="mouse","pointerout"!==e&&"pointerover"!==e||(d=vn,g="onPointerLeave",f="onPointerEnter",m="pointer"),h=null==c?o:Ze(c),p=null==u?o:Ze(u),(o=new d(g,m+"leave",c,n,s)).target=h,o.relatedTarget=p,g=null,qe(s)===r&&((d=new d(f,m+"enter",u,n,s)).target=p,d.relatedTarget=h,g=d),h=g,c&&u)e:{for(d=sd,m=u,p=0,g=f=c;g;g=d(g))p++;g=0;for(var y=m;y;y=d(y))g++;for(;0<p-g;)f=d(f),p--;for(;0<g-p;)m=d(m),g--;for(;p--;){if(f===m||null!==m&&f===m.alternate){d=f;break e}f=d(f),m=d(m)}d=null}else d=null;null!==c&&ad(i,o,c,d,!1),null!==u&&null!==h&&ad(i,h,u,d,!0)}if("select"===(c=(o=r?Ze(r):window).nodeName&&o.nodeName.toLowerCase())||"input"===c&&"file"===o.type)var w=Wn;else if(On(o))if(zn)w=Xn;else{w=Yn;var v=Kn}else!(c=o.nodeName)||"input"!==c.toLowerCase()||"checkbox"!==o.type&&"radio"!==o.type?r&&Tt(r.elementType)&&(w=Wn):w=qn;switch(w&&(w=w(e,r))?Pn(i,w,n,s):(v&&v(e,o,r),"focusout"===e&&r&&"number"===o.type&&null!=r.memoizedProps.value&&At(o,"number",o.value)),v=r?Ze(r):window,e){case"focusin":(On(v)||"true"===v.contentEditable)&&(ir=v,or=r,lr=null);break;case"focusout":lr=or=ir=null;break;case"mousedown":cr=!0;break;case"contextmenu":case"mouseup":case"dragend":cr=!1,ur(i,n,s);break;case"selectionchange":if(ar)break;case"keydown":case"keyup":ur(i,n,s)}var A;if(En)e:{switch(e){case"compositionstart":var b="onCompositionStart";break e;case"compositionend":b="onCompositionEnd";break e;case"compositionupdate":b="onCompositionUpdate";break e}b=void 0}else Dn?Rn(e,n)&&(b="onCompositionEnd"):"keydown"===e&&229===n.keyCode&&(b="onCompositionStart");b&&(Tn&&"ko"!==n.locale&&(Dn||"onCompositionStart"!==b?"onCompositionEnd"===b&&Dn&&(A=Qt()):(Gt="value"in(Vt=s)?Vt.value:Vt.textContent,Dn=!0)),0<(v=rd(r,b)).length&&(b=new hn(b,e,null,n,s),i.push({event:b,listeners:v}),A?b.data=A:null!==(A=Mn(n))&&(b.data=A))),(A=kn?function(e,t){switch(e){case"compositionend":return Mn(t);case"keypress":return 32!==t.which?null:(_n=!0,In);case"textInput":return(e=t.data)===In&&_n?null:e;default:return null}}(e,n):function(e,t){if(Dn)return"compositionend"===e||!En&&Rn(e,t)?(e=Qt(),Jt=Gt=Vt=null,Dn=!1,e):null;switch(e){case"paste":default:return null;case"keypress":if(!(t.ctrlKey||t.altKey||t.metaKey)||t.ctrlKey&&t.altKey){if(t.char&&1<t.char.length)return t.char;if(t.which)return String.fromCharCode(t.which)}return null;case"compositionend":return Tn&&"ko"!==t.locale?null:t.data}}(e,n))&&(0<(b=rd(r,"onBeforeInput")).length&&(v=new hn("onBeforeInput","beforeinput",null,n,s),i.push({event:v,listeners:b}),v.data=A)),function(e,t,n,r,s){if("submit"===t&&n&&n.stateNode===s){var a=Hu((s[ze]||null).action),i=r.submitter;i&&null!==(t=(t=i[ze]||null)?Hu(t.formAction):i.getAttribute("formAction"))&&(a=t,i=null);var o=new nn("action","action",null,r,s);e.push({event:o,listeners:[{instance:null,listener:function(){if(r.defaultPrevented){if(0!==ju){var e=i?Vu(s,i):new FormData(s);eo(n,{pending:!0,data:e,method:s.method,action:a},null,e)}}else"function"===typeof a&&(o.preventDefault(),e=i?Vu(s,i):new FormData(s),eo(n,{pending:!0,data:e,method:s.method,action:a},a,e))},currentTarget:s}]})}}(i,e,r,n,s)}Yu(i,t)})}function nd(e,t,n){return{instance:e,listener:t,currentTarget:n}}function rd(e,t){for(var n=t+"Capture",r=[];null!==e;){var s=e,a=s.stateNode;if(5!==(s=s.tag)&&26!==s&&27!==s||null===a||(null!=(s=Ut(e,n))&&r.unshift(nd(e,s,a)),null!=(s=Ut(e,t))&&r.push(nd(e,s,a))),3===e.tag)return r;e=e.return}return[]}function sd(e){if(null===e)return null;do{e=e.return}while(e&&5!==e.tag&&27!==e.tag);return e||null}function ad(e,t,n,r,s){for(var a=t._reactName,i=[];null!==n&&n!==r;){var o=n,l=o.alternate,c=o.stateNode;if(o=o.tag,null!==l&&l===r)break;5!==o&&26!==o&&27!==o||null===c||(l=c,s?null!=(c=Ut(n,a))&&i.unshift(nd(n,c,l)):s||null!=(c=Ut(n,a))&&i.push(nd(n,c,l))),n=n.return}0!==i.length&&e.push({event:t,listeners:i})}var id=/\r\n?/g,od=/\u0000|\uFFFD/g;function ld(e){return("string"===typeof e?e:""+e).replace(id,"\n").replace(od,"")}function cd(e,t){return t=ld(t),ld(e)===t}function ud(e,t,n,r,s,a){switch(n){case"children":"string"===typeof r?"body"===t||"textarea"===t&&""===r||Ct(e,r):("number"===typeof r||"bigint"===typeof r)&&"body"!==t&&Ct(e,""+r);break;case"className":ct(e,"class",r);break;case"tabIndex":ct(e,"tabindex",r);break;case"dir":case"role":case"viewBox":case"width":case"height":ct(e,n,r);break;case"style":kt(e,r,a);break;case"data":if("object"!==t){ct(e,"data",r);break}case"src":case"href":if(""===r&&("a"!==t||"href"!==n)){e.removeAttribute(n);break}if(null==r||"function"===typeof r||"symbol"===typeof r||"boolean"===typeof r){e.removeAttribute(n);break}r=Rt(""+r),e.setAttribute(n,r);break;case"action":case"formAction":if("function"===typeof r){e.setAttribute(n,"javascript:throw new Error('A React form was unexpectedly submitted. If you called form.submit() manually, consider using form.requestSubmit() instead. If you\\'re trying to use event.stopPropagation() in a submit event handler, consider also calling event.preventDefault().')");break}if("function"===typeof a&&("formAction"===n?("input"!==t&&ud(e,t,"name",s.name,s,null),ud(e,t,"formEncType",s.formEncType,s,null),ud(e,t,"formMethod",s.formMethod,s,null),ud(e,t,"formTarget",s.formTarget,s,null)):(ud(e,t,"encType",s.encType,s,null),ud(e,t,"method",s.method,s,null),ud(e,t,"target",s.target,s,null))),null==r||"symbol"===typeof r||"boolean"===typeof r){e.removeAttribute(n);break}r=Rt(""+r),e.setAttribute(n,r);break;case"onClick":null!=r&&(e.onclick=Mt);break;case"onScroll":null!=r&&qu("scroll",e);break;case"onScrollEnd":null!=r&&qu("scrollend",e);break;case"dangerouslySetInnerHTML":if(null!=r){if("object"!==typeof r||!("__html"in r))throw Error(i(61));if(null!=(n=r.__html)){if(null!=s.children)throw Error(i(60));e.innerHTML=n}}break;case"multiple":e.multiple=r&&"function"!==typeof r&&"symbol"!==typeof r;break;case"muted":e.muted=r&&"function"!==typeof r&&"symbol"!==typeof r;break;case"suppressContentEditableWarning":case"suppressHydrationWarning":case"defaultValue":case"defaultChecked":case"innerHTML":case"ref":case"autoFocus":break;case"xlinkHref":if(null==r||"function"===typeof r||"boolean"===typeof r||"symbol"===typeof r){e.removeAttribute("xlink:href");break}n=Rt(""+r),e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",n);break;case"contentEditable":case"spellCheck":case"draggable":case"value":case"autoReverse":case"externalResourcesRequired":case"focusable":case"preserveAlpha":null!=r&&"function"!==typeof r&&"symbol"!==typeof r?e.setAttribute(n,""+r):e.removeAttribute(n);break;case"inert":case"allowFullScreen":case"async":case"autoPlay":case"controls":case"default":case"defer":case"disabled":case"disablePictureInPicture":case"disableRemotePlayback":case"formNoValidate":case"hidden":case"loop":case"noModule":case"noValidate":case"open":case"playsInline":case"readOnly":case"required":case"reversed":case"scoped":case"seamless":case"itemScope":r&&"function"!==typeof r&&"symbol"!==typeof r?e.setAttribute(n,""):e.removeAttribute(n);break;case"capture":case"download":!0===r?e.setAttribute(n,""):!1!==r&&null!=r&&"function"!==typeof r&&"symbol"!==typeof r?e.setAttribute(n,r):e.removeAttribute(n);break;case"cols":case"rows":case"size":case"span":null!=r&&"function"!==typeof r&&"symbol"!==typeof r&&!isNaN(r)&&1<=r?e.setAttribute(n,r):e.removeAttribute(n);break;case"rowSpan":case"start":null==r||"function"===typeof r||"symbol"===typeof r||isNaN(r)?e.removeAttribute(n):e.setAttribute(n,r);break;case"popover":qu("beforetoggle",e),qu("toggle",e),lt(e,"popover",r);break;case"xlinkActuate":ut(e,"http://www.w3.org/1999/xlink","xlink:actuate",r);break;case"xlinkArcrole":ut(e,"http://www.w3.org/1999/xlink","xlink:arcrole",r);break;case"xlinkRole":ut(e,"http://www.w3.org/1999/xlink","xlink:role",r);break;case"xlinkShow":ut(e,"http://www.w3.org/1999/xlink","xlink:show",r);break;case"xlinkTitle":ut(e,"http://www.w3.org/1999/xlink","xlink:title",r);break;case"xlinkType":ut(e,"http://www.w3.org/1999/xlink","xlink:type",r);break;case"xmlBase":ut(e,"http://www.w3.org/XML/1998/namespace","xml:base",r);break;case"xmlLang":ut(e,"http://www.w3.org/XML/1998/namespace","xml:lang",r);break;case"xmlSpace":ut(e,"http://www.w3.org/XML/1998/namespace","xml:space",r);break;case"is":lt(e,"is",r);break;case"innerText":case"textContent":break;default:(!(2<n.length)||"o"!==n[0]&&"O"!==n[0]||"n"!==n[1]&&"N"!==n[1])&&lt(e,n=It.get(n)||n,r)}}function dd(e,t,n,r,s,a){switch(n){case"style":kt(e,r,a);break;case"dangerouslySetInnerHTML":if(null!=r){if("object"!==typeof r||!("__html"in r))throw Error(i(61));if(null!=(n=r.__html)){if(null!=s.children)throw Error(i(60));e.innerHTML=n}}break;case"children":"string"===typeof r?Ct(e,r):("number"===typeof r||"bigint"===typeof r)&&Ct(e,""+r);break;case"onScroll":null!=r&&qu("scroll",e);break;case"onScrollEnd":null!=r&&qu("scrollend",e);break;case"onClick":null!=r&&(e.onclick=Mt);break;case"suppressContentEditableWarning":case"suppressHydrationWarning":case"innerHTML":case"ref":case"innerText":case"textContent":break;default:nt.hasOwnProperty(n)||("o"!==n[0]||"n"!==n[1]||(s=n.endsWith("Capture"),t=n.slice(2,s?n.length-7:void 0),"function"===typeof(a=null!=(a=e[ze]||null)?a[n]:null)&&e.removeEventListener(t,a,s),"function"!==typeof r)?n in e?e[n]=r:!0===r?e.setAttribute(n,""):lt(e,n,r):("function"!==typeof a&&null!==a&&(n in e?e[n]=null:e.hasAttribute(n)&&e.removeAttribute(n)),e.addEventListener(t,r,s)))}}function hd(e,t,n){switch(t){case"div":case"span":case"svg":case"path":case"a":case"g":case"p":case"li":break;case"img":qu("error",e),qu("load",e);var r,s=!1,a=!1;for(r in n)if(n.hasOwnProperty(r)){var o=n[r];if(null!=o)switch(r){case"src":s=!0;break;case"srcSet":a=!0;break;case"children":case"dangerouslySetInnerHTML":throw Error(i(137,t));default:ud(e,t,r,o,n,null)}}return a&&ud(e,t,"srcSet",n.srcSet,n,null),void(s&&ud(e,t,"src",n.src,n,null));case"input":qu("invalid",e);var l=r=o=a=null,c=null,u=null;for(s in n)if(n.hasOwnProperty(s)){var d=n[s];if(null!=d)switch(s){case"name":a=d;break;case"type":o=d;break;case"checked":c=d;break;case"defaultChecked":u=d;break;case"value":r=d;break;case"defaultValue":l=d;break;case"children":case"dangerouslySetInnerHTML":if(null!=d)throw Error(i(137,t));break;default:ud(e,t,s,d,n,null)}}return void vt(e,r,l,c,u,o,a,!1);case"select":for(a in qu("invalid",e),s=o=r=null,n)if(n.hasOwnProperty(a)&&null!=(l=n[a]))switch(a){case"value":r=l;break;case"defaultValue":o=l;break;case"multiple":s=l;default:ud(e,t,a,l,n,null)}return t=r,n=o,e.multiple=!!s,void(null!=t?bt(e,!!s,t,!1):null!=n&&bt(e,!!s,n,!0));case"textarea":for(o in qu("invalid",e),r=a=s=null,n)if(n.hasOwnProperty(o)&&null!=(l=n[o]))switch(o){case"value":s=l;break;case"defaultValue":a=l;break;case"children":r=l;break;case"dangerouslySetInnerHTML":if(null!=l)throw Error(i(91));break;default:ud(e,t,o,l,n,null)}return void St(e,s,a,r);case"option":for(c in n)if(n.hasOwnProperty(c)&&null!=(s=n[c]))if("selected"===c)e.selected=s&&"function"!==typeof s&&"symbol"!==typeof s;else ud(e,t,c,s,n,null);return;case"dialog":qu("beforetoggle",e),qu("toggle",e),qu("cancel",e),qu("close",e);break;case"iframe":case"object":qu("load",e);break;case"video":case"audio":for(s=0;s<Qu.length;s++)qu(Qu[s],e);break;case"image":qu("error",e),qu("load",e);break;case"details":qu("toggle",e);break;case"embed":case"source":case"link":qu("error",e),qu("load",e);case"area":case"base":case"br":case"col":case"hr":case"keygen":case"meta":case"param":case"track":case"wbr":case"menuitem":for(u in n)if(n.hasOwnProperty(u)&&null!=(s=n[u]))switch(u){case"children":case"dangerouslySetInnerHTML":throw Error(i(137,t));default:ud(e,t,u,s,n,null)}return;default:if(Tt(t)){for(d in n)n.hasOwnProperty(d)&&(void 0!==(s=n[d])&&dd(e,t,d,s,n,void 0));return}}for(l in n)n.hasOwnProperty(l)&&(null!=(s=n[l])&&ud(e,t,l,s,n,null))}function fd(e){switch(e){case"css":case"script":case"font":case"img":case"image":case"input":case"link":return!0;default:return!1}}var pd=null,md=null;function gd(e){return 9===e.nodeType?e:e.ownerDocument}function yd(e){switch(e){case"http://www.w3.org/2000/svg":return 1;case"http://www.w3.org/1998/Math/MathML":return 2;default:return 0}}function wd(e,t){if(0===e)switch(t){case"svg":return 1;case"math":return 2;default:return 0}return 1===e&&"foreignObject"===t?0:e}function vd(e,t){return"textarea"===e||"noscript"===e||"string"===typeof t.children||"number"===typeof t.children||"bigint"===typeof t.children||"object"===typeof t.dangerouslySetInnerHTML&&null!==t.dangerouslySetInnerHTML&&null!=t.dangerouslySetInnerHTML.__html}var Ad=null;var bd="function"===typeof setTimeout?setTimeout:void 0,xd="function"===typeof clearTimeout?clearTimeout:void 0,Sd="function"===typeof Promise?Promise:void 0,Cd="function"===typeof queueMicrotask?queueMicrotask:"undefined"!==typeof Sd?function(e){return Sd.resolve(null).then(e).catch(Ed)}:bd;function Ed(e){setTimeout(function(){throw e})}function Nd(e){return"head"===e}function kd(e,t){var n=t,r=0;do{var s=n.nextSibling;if(e.removeChild(n),s&&8===s.nodeType)if("/$"===(n=s.data)||"/&"===n){if(0===r)return e.removeChild(s),void Vh(t);r--}else if("$"===n||"$?"===n||"$~"===n||"$!"===n||"&"===n)r++;else if("html"===n)Bd(e.ownerDocument.documentElement);else if("head"===n){Bd(n=e.ownerDocument.head);for(var a=n.firstChild;a;){var i=a.nextSibling,o=a.nodeName;a[Ke]||"SCRIPT"===o||"STYLE"===o||"LINK"===o&&"stylesheet"===a.rel.toLowerCase()||n.removeChild(a),a=i}}else"body"===n&&Bd(e.ownerDocument.body);n=s}while(n);Vh(t)}function Td(e,t){var n=e;e=0;do{var r=n.nextSibling;if(1===n.nodeType?t?(n._stashedDisplay=n.style.display,n.style.display="none"):(n.style.display=n._stashedDisplay||"",""===n.getAttribute("style")&&n.removeAttribute("style")):3===n.nodeType&&(t?(n._stashedText=n.nodeValue,n.nodeValue=""):n.nodeValue=n._stashedText||""),r&&8===r.nodeType)if("/$"===(n=r.data)){if(0===e)break;e--}else"$"!==n&&"$?"!==n&&"$~"!==n&&"$!"!==n||e++;n=r}while(n)}function Id(e){var t=e.firstChild;for(t&&10===t.nodeType&&(t=t.nextSibling);t;){var n=t;switch(t=t.nextSibling,n.nodeName){case"HTML":case"HEAD":case"BODY":Id(n),Ye(n);continue;case"SCRIPT":case"STYLE":continue;case"LINK":if("stylesheet"===n.rel.toLowerCase())continue}e.removeChild(n)}}function _d(e,t){for(;8!==e.nodeType;){if((1!==e.nodeType||"INPUT"!==e.nodeName||"hidden"!==e.type)&&!t)return null;if(null===(e=Dd(e.nextSibling)))return null}return e}function Rd(e){return"$?"===e.data||"$~"===e.data}function Md(e){return"$!"===e.data||"$?"===e.data&&"loading"!==e.ownerDocument.readyState}function Dd(e){for(;null!=e;e=e.nextSibling){var t=e.nodeType;if(1===t||3===t)break;if(8===t){if("$"===(t=e.data)||"$!"===t||"$?"===t||"$~"===t||"&"===t||"F!"===t||"F"===t)break;if("/$"===t||"/&"===t)return null}}return e}var jd=null;function Od(e){e=e.nextSibling;for(var t=0;e;){if(8===e.nodeType){var n=e.data;if("/$"===n||"/&"===n){if(0===t)return Dd(e.nextSibling);t--}else"$"!==n&&"$!"!==n&&"$?"!==n&&"$~"!==n&&"&"!==n||t++}e=e.nextSibling}return null}function Pd(e){e=e.previousSibling;for(var t=0;e;){if(8===e.nodeType){var n=e.data;if("$"===n||"$!"===n||"$?"===n||"$~"===n||"&"===n){if(0===t)return e;t--}else"/$"!==n&&"/&"!==n||t++}e=e.previousSibling}return null}function Ld(e,t,n){switch(t=gd(n),e){case"html":if(!(e=t.documentElement))throw Error(i(452));return e;case"head":if(!(e=t.head))throw Error(i(453));return e;case"body":if(!(e=t.body))throw Error(i(454));return e;default:throw Error(i(451))}}function Bd(e){for(var t=e.attributes;t.length;)e.removeAttributeNode(t[0]);Ye(e)}var Fd=new Map,Ud=new Set;function Wd(e){return"function"===typeof e.getRootNode?e.getRootNode():9===e.nodeType?e:e.ownerDocument}var zd=O.d;O.d={f:function(){var e=zd.f(),t=$c();return e||t},r:function(e){var t=Xe(e);null!==t&&5===t.tag&&"form"===t.type?no(t):zd.r(e)},D:function(e){zd.D(e),Vd("dns-prefetch",e,null)},C:function(e,t){zd.C(e,t),Vd("preconnect",e,t)},L:function(e,t,n){zd.L(e,t,n);var r=Hd;if(r&&e&&t){var s='link[rel="preload"][as="'+yt(t)+'"]';"image"===t&&n&&n.imageSrcSet?(s+='[imagesrcset="'+yt(n.imageSrcSet)+'"]',"string"===typeof n.imageSizes&&(s+='[imagesizes="'+yt(n.imageSizes)+'"]')):s+='[href="'+yt(e)+'"]';var a=s;switch(t){case"style":a=Jd(e);break;case"script":a=Yd(e)}Fd.has(a)||(e=f({rel:"preload",href:"image"===t&&n&&n.imageSrcSet?void 0:e,as:t},n),Fd.set(a,e),null!==r.querySelector(s)||"style"===t&&r.querySelector(Qd(a))||"script"===t&&r.querySelector(qd(a))||(hd(t=r.createElement("link"),"link",e),et(t),r.head.appendChild(t)))}},m:function(e,t){zd.m(e,t);var n=Hd;if(n&&e){var r=t&&"string"===typeof t.as?t.as:"script",s='link[rel="modulepreload"][as="'+yt(r)+'"][href="'+yt(e)+'"]',a=s;switch(r){case"audioworklet":case"paintworklet":case"serviceworker":case"sharedworker":case"worker":case"script":a=Yd(e)}if(!Fd.has(a)&&(e=f({rel:"modulepreload",href:e},t),Fd.set(a,e),null===n.querySelector(s))){switch(r){case"audioworklet":case"paintworklet":case"serviceworker":case"sharedworker":case"worker":case"script":if(n.querySelector(qd(a)))return}hd(r=n.createElement("link"),"link",e),et(r),n.head.appendChild(r)}}},X:function(e,t){zd.X(e,t);var n=Hd;if(n&&e){var r=$e(n).hoistableScripts,s=Yd(e),a=r.get(s);a||((a=n.querySelector(qd(s)))||(e=f({src:e,async:!0},t),(t=Fd.get(s))&&eh(e,t),et(a=n.createElement("script")),hd(a,"link",e),n.head.appendChild(a)),a={type:"script",instance:a,count:1,state:null},r.set(s,a))}},S:function(e,t,n){zd.S(e,t,n);var r=Hd;if(r&&e){var s=$e(r).hoistableStyles,a=Jd(e);t=t||"default";var i=s.get(a);if(!i){var o={loading:0,preload:null};if(i=r.querySelector(Qd(a)))o.loading=5;else{e=f({rel:"stylesheet",href:e,"data-precedence":t},n),(n=Fd.get(a))&&$d(e,n);var l=i=r.createElement("link");et(l),hd(l,"link",e),l._p=new Promise(function(e,t){l.onload=e,l.onerror=t}),l.addEventListener("load",function(){o.loading|=1}),l.addEventListener("error",function(){o.loading|=2}),o.loading|=4,Zd(i,t,r)}i={type:"stylesheet",instance:i,count:1,state:o},s.set(a,i)}}},M:function(e,t){zd.M(e,t);var n=Hd;if(n&&e){var r=$e(n).hoistableScripts,s=Yd(e),a=r.get(s);a||((a=n.querySelector(qd(s)))||(e=f({src:e,async:!0,type:"module"},t),(t=Fd.get(s))&&eh(e,t),et(a=n.createElement("script")),hd(a,"link",e),n.head.appendChild(a)),a={type:"script",instance:a,count:1,state:null},r.set(s,a))}}};var Hd="undefined"===typeof document?null:document;function Vd(e,t,n){var r=Hd;if(r&&"string"===typeof t&&t){var s=yt(t);s='link[rel="'+e+'"][href="'+s+'"]',"string"===typeof n&&(s+='[crossorigin="'+n+'"]'),Ud.has(s)||(Ud.add(s),e={rel:e,crossOrigin:n,href:t},null===r.querySelector(s)&&(hd(t=r.createElement("link"),"link",e),et(t),r.head.appendChild(t)))}}function Gd(e,t,n,r){var s,a,o,l,c=(c=J.current)?Wd(c):null;if(!c)throw Error(i(446));switch(e){case"meta":case"title":return null;case"style":return"string"===typeof n.precedence&&"string"===typeof n.href?(t=Jd(n.href),(r=(n=$e(c).hoistableStyles).get(t))||(r={type:"style",instance:null,count:0,state:null},n.set(t,r)),r):{type:"void",instance:null,count:0,state:null};case"link":if("stylesheet"===n.rel&&"string"===typeof n.href&&"string"===typeof n.precedence){e=Jd(n.href);var u=$e(c).hoistableStyles,d=u.get(e);if(d||(c=c.ownerDocument||c,d={type:"stylesheet",instance:null,count:0,state:{loading:0,preload:null}},u.set(e,d),(u=c.querySelector(Qd(e)))&&!u._p&&(d.instance=u,d.state.loading=5),Fd.has(e)||(n={rel:"preload",as:"style",href:n.href,crossOrigin:n.crossOrigin,integrity:n.integrity,media:n.media,hrefLang:n.hrefLang,referrerPolicy:n.referrerPolicy},Fd.set(e,n),u||(s=c,a=e,o=n,l=d.state,s.querySelector('link[rel="preload"][as="style"]['+a+"]")?l.loading=1:(a=s.createElement("link"),l.preload=a,a.addEventListener("load",function(){return l.loading|=1}),a.addEventListener("error",function(){return l.loading|=2}),hd(a,"link",o),et(a),s.head.appendChild(a))))),t&&null===r)throw Error(i(528,""));return d}if(t&&null!==r)throw Error(i(529,""));return null;case"script":return t=n.async,"string"===typeof(n=n.src)&&t&&"function"!==typeof t&&"symbol"!==typeof t?(t=Yd(n),(r=(n=$e(c).hoistableScripts).get(t))||(r={type:"script",instance:null,count:0,state:null},n.set(t,r)),r):{type:"void",instance:null,count:0,state:null};default:throw Error(i(444,e))}}function Jd(e){return'href="'+yt(e)+'"'}function Qd(e){return'link[rel="stylesheet"]['+e+"]"}function Kd(e){return f({},e,{"data-precedence":e.precedence,precedence:null})}function Yd(e){return'[src="'+yt(e)+'"]'}function qd(e){return"script[async]"+e}function Xd(e,t,n){if(t.count++,null===t.instance)switch(t.type){case"style":var r=e.querySelector('style[data-href~="'+yt(n.href)+'"]');if(r)return t.instance=r,et(r),r;var s=f({},n,{"data-href":n.href,"data-precedence":n.precedence,href:null,precedence:null});return et(r=(e.ownerDocument||e).createElement("style")),hd(r,"style",s),Zd(r,n.precedence,e),t.instance=r;case"stylesheet":s=Jd(n.href);var a=e.querySelector(Qd(s));if(a)return t.state.loading|=4,t.instance=a,et(a),a;r=Kd(n),(s=Fd.get(s))&&$d(r,s),et(a=(e.ownerDocument||e).createElement("link"));var o=a;return o._p=new Promise(function(e,t){o.onload=e,o.onerror=t}),hd(a,"link",r),t.state.loading|=4,Zd(a,n.precedence,e),t.instance=a;case"script":return a=Yd(n.src),(s=e.querySelector(qd(a)))?(t.instance=s,et(s),s):(r=n,(s=Fd.get(a))&&eh(r=f({},n),s),et(s=(e=e.ownerDocument||e).createElement("script")),hd(s,"link",r),e.head.appendChild(s),t.instance=s);case"void":return null;default:throw Error(i(443,t.type))}else"stylesheet"===t.type&&0===(4&t.state.loading)&&(r=t.instance,t.state.loading|=4,Zd(r,n.precedence,e));return t.instance}function Zd(e,t,n){for(var r=n.querySelectorAll('link[rel="stylesheet"][data-precedence],style[data-precedence]'),s=r.length?r[r.length-1]:null,a=s,i=0;i<r.length;i++){var o=r[i];if(o.dataset.precedence===t)a=o;else if(a!==s)break}a?a.parentNode.insertBefore(e,a.nextSibling):(t=9===n.nodeType?n.head:n).insertBefore(e,t.firstChild)}function $d(e,t){null==e.crossOrigin&&(e.crossOrigin=t.crossOrigin),null==e.referrerPolicy&&(e.referrerPolicy=t.referrerPolicy),null==e.title&&(e.title=t.title)}function eh(e,t){null==e.crossOrigin&&(e.crossOrigin=t.crossOrigin),null==e.referrerPolicy&&(e.referrerPolicy=t.referrerPolicy),null==e.integrity&&(e.integrity=t.integrity)}var th=null;function nh(e,t,n){if(null===th){var r=new Map,s=th=new Map;s.set(n,r)}else(r=(s=th).get(n))||(r=new Map,s.set(n,r));if(r.has(e))return r;for(r.set(e,null),n=n.getElementsByTagName(e),s=0;s<n.length;s++){var a=n[s];if(!(a[Ke]||a[We]||"link"===e&&"stylesheet"===a.getAttribute("rel"))&&"http://www.w3.org/2000/svg"!==a.namespaceURI){var i=a.getAttribute(t)||"";i=e+i;var o=r.get(i);o?o.push(a):r.set(i,[a])}}return r}function rh(e,t,n){(e=e.ownerDocument||e).head.insertBefore(n,"title"===t?e.querySelector("head > title"):null)}function sh(e){return"stylesheet"!==e.type||0!==(3&e.state.loading)}var ah=0;function ih(){if(this.count--,0===this.count&&(0===this.imgCount||!this.waitingForImages))if(this.stylesheets)lh(this,this.stylesheets);else if(this.unsuspend){var e=this.unsuspend;this.unsuspend=null,e()}}var oh=null;function lh(e,t){e.stylesheets=null,null!==e.unsuspend&&(e.count++,oh=new Map,t.forEach(ch,e),oh=null,ih.call(e))}function ch(e,t){if(!(4&t.state.loading)){var n=oh.get(e);if(n)var r=n.get(null);else{n=new Map,oh.set(e,n);for(var s=e.querySelectorAll("link[data-precedence],style[data-precedence]"),a=0;a<s.length;a++){var i=s[a];"LINK"!==i.nodeName&&"not all"===i.getAttribute("media")||(n.set(i.dataset.precedence,i),r=i)}r&&n.set(null,r)}i=(s=t.instance).getAttribute("data-precedence"),(a=n.get(i)||r)===r&&n.set(null,s),n.set(i,s),this.count++,r=ih.bind(this),s.addEventListener("load",r),s.addEventListener("error",r),a?a.parentNode.insertBefore(s,a.nextSibling):(e=9===e.nodeType?e.head:e).insertBefore(s,e.firstChild),t.state.loading|=4}}var uh={$$typeof:b,Provider:null,Consumer:null,_currentValue:P,_currentValue2:P,_threadCount:0};function dh(e,t,n,r,s,a,i,o,l){this.tag=1,this.containerInfo=e,this.pingCache=this.current=this.pendingChildren=null,this.timeoutHandle=-1,this.callbackNode=this.next=this.pendingContext=this.context=this.cancelPendingCommit=null,this.callbackPriority=0,this.expirationTimes=Re(-1),this.entangledLanes=this.shellSuspendCounter=this.errorRecoveryDisabledLanes=this.expiredLanes=this.warmLanes=this.pingedLanes=this.suspendedLanes=this.pendingLanes=0,this.entanglements=Re(0),this.hiddenUpdates=Re(null),this.identifierPrefix=r,this.onUncaughtError=s,this.onCaughtError=a,this.onRecoverableError=i,this.pooledCache=null,this.pooledCacheLanes=0,this.formState=l,this.incompleteTransitions=new Map}function hh(e,t,n,r,s,a,i,o,l,c,u,d){return e=new dh(e,t,n,i,l,c,u,d,o),t=1,!0===a&&(t|=24),a=Br(3,null,null,t),e.current=a,a.stateNode=e,(t=Fs()).refCount++,e.pooledCache=t,t.refCount++,a.memoizedState={element:r,isDehydrated:n,cache:t},ga(a),e}function fh(e){return e?e=Pr:Pr}function ph(e,t,n,r,s,a){s=fh(s),null===r.context?r.context=s:r.pendingContext=s,(r=wa(t)).payload={element:n},null!==(a=void 0===a?null:a)&&(r.callback=a),null!==(n=va(e,r,t))&&(Kc(n,0,t),Aa(n,e,t))}function mh(e,t){if(null!==(e=e.memoizedState)&&null!==e.dehydrated){var n=e.retryLane;e.retryLane=0!==n&&n<t?n:t}}function gh(e,t){mh(e,t),(e=e.alternate)&&mh(e,t)}function yh(e){if(13===e.tag||31===e.tag){var t=Dr(e,67108864);null!==t&&Kc(t,0,67108864),gh(e,67108864)}}function wh(e){if(13===e.tag||31===e.tag){var t=Jc(),n=Dr(e,t=Pe(t));null!==n&&Kc(n,0,t),gh(e,t)}}var vh=!0;function Ah(e,t,n,r){var s=j.T;j.T=null;var a=O.p;try{O.p=2,xh(e,t,n,r)}finally{O.p=a,j.T=s}}function bh(e,t,n,r){var s=j.T;j.T=null;var a=O.p;try{O.p=8,xh(e,t,n,r)}finally{O.p=a,j.T=s}}function xh(e,t,n,r){if(vh){var s=Sh(r);if(null===s)td(e,t,r,Ch,n),Oh(e,r);else if(function(e,t,n,r,s){switch(t){case"focusin":return Th=Ph(Th,e,t,n,r,s),!0;case"dragenter":return Ih=Ph(Ih,e,t,n,r,s),!0;case"mouseover":return _h=Ph(_h,e,t,n,r,s),!0;case"pointerover":var a=s.pointerId;return Rh.set(a,Ph(Rh.get(a)||null,e,t,n,r,s)),!0;case"gotpointercapture":return a=s.pointerId,Mh.set(a,Ph(Mh.get(a)||null,e,t,n,r,s)),!0}return!1}(s,e,t,n,r))r.stopPropagation();else if(Oh(e,r),4&t&&-1<jh.indexOf(e)){for(;null!==s;){var a=Xe(s);if(null!==a)switch(a.tag){case 3:if((a=a.stateNode).current.memoizedState.isDehydrated){var i=Ne(a.pendingLanes);if(0!==i){var o=a;for(o.pendingLanes|=2,o.entangledLanes|=2;i;){var l=1<<31-Ae(i);o.entanglements[1]|=l,i&=~l}Ou(a),0===(6&fc)&&(jc=le()+500,Pu(0,!1))}}break;case 31:case 13:null!==(o=Dr(a,2))&&Kc(o,0,2),$c(),gh(a,2)}if(null===(a=Sh(r))&&td(e,t,r,Ch,n),a===s)break;s=a}null!==s&&r.stopPropagation()}else td(e,t,r,null,n)}}function Sh(e){return Eh(e=jt(e))}var Ch=null;function Eh(e){if(Ch=null,null!==(e=qe(e))){var t=l(e);if(null===t)e=null;else{var n=t.tag;if(13===n){if(null!==(e=c(t)))return e;e=null}else if(31===n){if(null!==(e=u(t)))return e;e=null}else if(3===n){if(t.stateNode.current.memoizedState.isDehydrated)return 3===t.tag?t.stateNode.containerInfo:null;e=null}else t!==e&&(e=null)}}return Ch=e,null}function Nh(e){switch(e){case"beforetoggle":case"cancel":case"click":case"close":case"contextmenu":case"copy":case"cut":case"auxclick":case"dblclick":case"dragend":case"dragstart":case"drop":case"focusin":case"focusout":case"input":case"invalid":case"keydown":case"keypress":case"keyup":case"mousedown":case"mouseup":case"paste":case"pause":case"play":case"pointercancel":case"pointerdown":case"pointerup":case"ratechange":case"reset":case"resize":case"seeked":case"submit":case"toggle":case"touchcancel":case"touchend":case"touchstart":case"volumechange":case"change":case"selectionchange":case"textInput":case"compositionstart":case"compositionend":case"compositionupdate":case"beforeblur":case"afterblur":case"beforeinput":case"blur":case"fullscreenchange":case"focus":case"hashchange":case"popstate":case"select":case"selectstart":return 2;case"drag":case"dragenter":case"dragexit":case"dragleave":case"dragover":case"mousemove":case"mouseout":case"mouseover":case"pointermove":case"pointerout":case"pointerover":case"scroll":case"touchmove":case"wheel":case"mouseenter":case"mouseleave":case"pointerenter":case"pointerleave":return 8;case"message":switch(ce()){case ue:return 2;case de:return 8;case he:case fe:return 32;case pe:return 268435456;default:return 32}default:return 32}}var kh=!1,Th=null,Ih=null,_h=null,Rh=new Map,Mh=new Map,Dh=[],jh="mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset".split(" ");function Oh(e,t){switch(e){case"focusin":case"focusout":Th=null;break;case"dragenter":case"dragleave":Ih=null;break;case"mouseover":case"mouseout":_h=null;break;case"pointerover":case"pointerout":Rh.delete(t.pointerId);break;case"gotpointercapture":case"lostpointercapture":Mh.delete(t.pointerId)}}function Ph(e,t,n,r,s,a){return null===e||e.nativeEvent!==a?(e={blockedOn:t,domEventName:n,eventSystemFlags:r,nativeEvent:a,targetContainers:[s]},null!==t&&(null!==(t=Xe(t))&&yh(t)),e):(e.eventSystemFlags|=r,t=e.targetContainers,null!==s&&-1===t.indexOf(s)&&t.push(s),e)}function Lh(e){var t=qe(e.target);if(null!==t){var n=l(t);if(null!==n)if(13===(t=n.tag)){if(null!==(t=c(n)))return e.blockedOn=t,void Fe(e.priority,function(){wh(n)})}else if(31===t){if(null!==(t=u(n)))return e.blockedOn=t,void Fe(e.priority,function(){wh(n)})}else if(3===t&&n.stateNode.current.memoizedState.isDehydrated)return void(e.blockedOn=3===n.tag?n.stateNode.containerInfo:null)}e.blockedOn=null}function Bh(e){if(null!==e.blockedOn)return!1;for(var t=e.targetContainers;0<t.length;){var n=Sh(e.nativeEvent);if(null!==n)return null!==(t=Xe(n))&&yh(t),e.blockedOn=n,!1;var r=new(n=e.nativeEvent).constructor(n.type,n);Dt=r,n.target.dispatchEvent(r),Dt=null,t.shift()}return!0}function Fh(e,t,n){Bh(e)&&n.delete(t)}function Uh(){kh=!1,null!==Th&&Bh(Th)&&(Th=null),null!==Ih&&Bh(Ih)&&(Ih=null),null!==_h&&Bh(_h)&&(_h=null),Rh.forEach(Fh),Mh.forEach(Fh)}function Wh(e,t){e.blockedOn===t&&(e.blockedOn=null,kh||(kh=!0,r.unstable_scheduleCallback(r.unstable_NormalPriority,Uh)))}var zh=null;function Hh(e){zh!==e&&(zh=e,r.unstable_scheduleCallback(r.unstable_NormalPriority,function(){zh===e&&(zh=null);for(var t=0;t<e.length;t+=3){var n=e[t],r=e[t+1],s=e[t+2];if("function"!==typeof r){if(null===Eh(r||n))continue;break}var a=Xe(n);null!==a&&(e.splice(t,3),t-=3,eo(a,{pending:!0,data:s,method:n.method,action:r},r,s))}}))}function Vh(e){function t(t){return Wh(t,e)}null!==Th&&Wh(Th,e),null!==Ih&&Wh(Ih,e),null!==_h&&Wh(_h,e),Rh.forEach(t),Mh.forEach(t);for(var n=0;n<Dh.length;n++){var r=Dh[n];r.blockedOn===e&&(r.blockedOn=null)}for(;0<Dh.length&&null===(n=Dh[0]).blockedOn;)Lh(n),null===n.blockedOn&&Dh.shift();if(null!=(n=(e.ownerDocument||e).$$reactFormReplay))for(r=0;r<n.length;r+=3){var s=n[r],a=n[r+1],i=s[ze]||null;if("function"===typeof a)i||Hh(n);else if(i){var o=null;if(a&&a.hasAttribute("formAction")){if(s=a,i=a[ze]||null)o=i.formAction;else if(null!==Eh(s))continue}else o=i.action;"function"===typeof o?n[r+1]=o:(n.splice(r,3),r-=3),Hh(n)}}}function Gh(){function e(e){e.canIntercept&&"react-transition"===e.info&&e.intercept({handler:function(){return new Promise(function(e){return s=e})},focusReset:"manual",scroll:"manual"})}function t(){null!==s&&(s(),s=null),r||setTimeout(n,20)}function n(){if(!r&&!navigation.transition){var e=navigation.currentEntry;e&&null!=e.url&&navigation.navigate(e.url,{state:e.getState(),info:"react-transition",history:"replace"})}}if("object"===typeof navigation){var r=!1,s=null;return navigation.addEventListener("navigate",e),navigation.addEventListener("navigatesuccess",t),navigation.addEventListener("navigateerror",t),setTimeout(n,100),function(){r=!0,navigation.removeEventListener("navigate",e),navigation.removeEventListener("navigatesuccess",t),navigation.removeEventListener("navigateerror",t),null!==s&&(s(),s=null)}}}function Jh(e){this._internalRoot=e}function Qh(e){this._internalRoot=e}Qh.prototype.render=Jh.prototype.render=function(e){var t=this._internalRoot;if(null===t)throw Error(i(409));ph(t.current,Jc(),e,t,null,null)},Qh.prototype.unmount=Jh.prototype.unmount=function(){var e=this._internalRoot;if(null!==e){this._internalRoot=null;var t=e.containerInfo;ph(e.current,2,null,e,null,null),$c(),t[He]=null}},Qh.prototype.unstable_scheduleHydration=function(e){if(e){var t=Be();e={blockedOn:null,target:e,priority:t};for(var n=0;n<Dh.length&&0!==t&&t<Dh[n].priority;n++);Dh.splice(n,0,e),0===n&&Lh(e)}};var Kh=s.version;if("19.2.0"!==Kh)throw Error(i(527,Kh,"19.2.0"));O.findDOMNode=function(e){var t=e._reactInternals;if(void 0===t){if("function"===typeof e.render)throw Error(i(188));throw e=Object.keys(e).join(","),Error(i(268,e))}return e=function(e){var t=e.alternate;if(!t){if(null===(t=l(e)))throw Error(i(188));return t!==e?null:e}for(var n=e,r=t;;){var s=n.return;if(null===s)break;var a=s.alternate;if(null===a){if(null!==(r=s.return)){n=r;continue}break}if(s.child===a.child){for(a=s.child;a;){if(a===n)return d(s),e;if(a===r)return d(s),t;a=a.sibling}throw Error(i(188))}if(n.return!==r.return)n=s,r=a;else{for(var o=!1,c=s.child;c;){if(c===n){o=!0,n=s,r=a;break}if(c===r){o=!0,r=s,n=a;break}c=c.sibling}if(!o){for(c=a.child;c;){if(c===n){o=!0,n=a,r=s;break}if(c===r){o=!0,r=a,n=s;break}c=c.sibling}if(!o)throw Error(i(189))}}if(n.alternate!==r)throw Error(i(190))}if(3!==n.tag)throw Error(i(188));return n.stateNode.current===n?e:t}(t),e=null===(e=null!==e?h(e):null)?null:e.stateNode};var Yh={bundleType:0,version:"19.2.0",rendererPackageName:"react-dom",currentDispatcherRef:j,reconcilerVersion:"19.2.0"};if("undefined"!==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__){var qh=__REACT_DEVTOOLS_GLOBAL_HOOK__;if(!qh.isDisabled&&qh.supportsFiber)try{ye=qh.inject(Yh),we=qh}catch(Zh){}}t.createRoot=function(e,t){if(!o(e))throw Error(i(299));var n=!1,r="",s=Co,a=Eo,l=No;return null!==t&&void 0!==t&&(!0===t.unstable_strictMode&&(n=!0),void 0!==t.identifierPrefix&&(r=t.identifierPrefix),void 0!==t.onUncaughtError&&(s=t.onUncaughtError),void 0!==t.onCaughtError&&(a=t.onCaughtError),void 0!==t.onRecoverableError&&(l=t.onRecoverableError)),t=hh(e,1,!1,null,0,n,r,null,s,a,l,Gh),e[He]=t.current,$u(e),new Jh(t)},t.hydrateRoot=function(e,t,n){if(!o(e))throw Error(i(299));var r=!1,s="",a=Co,l=Eo,c=No,u=null;return null!==n&&void 0!==n&&(!0===n.unstable_strictMode&&(r=!0),void 0!==n.identifierPrefix&&(s=n.identifierPrefix),void 0!==n.onUncaughtError&&(a=n.onUncaughtError),void 0!==n.onCaughtError&&(l=n.onCaughtError),void 0!==n.onRecoverableError&&(c=n.onRecoverableError),void 0!==n.formState&&(u=n.formState)),(t=hh(e,1,!0,t,0,r,s,u,a,l,c,Gh)).context=fh(null),n=t.current,(s=wa(r=Pe(r=Jc()))).callback=null,va(n,s,r),n=r,t.current.lanes=n,Me(t,n),Ou(t),e[He]=t.current,$u(e),new Qh(t)},t.version="19.2.0"},7703(e,t,n){"use strict";var r=n(8094);function s(e){var t="https://react.dev/errors/"+e;if(1<arguments.length){t+="?args[]="+encodeURIComponent(arguments[1]);for(var n=2;n<arguments.length;n++)t+="&args[]="+encodeURIComponent(arguments[n])}return"Minified React error #"+e+"; visit "+t+" for the full message or use the non-minified dev environment for full errors and additional helpful warnings."}function a(){}var i={d:{f:a,r:function(){throw Error(s(522))},D:a,C:a,L:a,m:a,X:a,S:a,M:a},p:0,findDOMNode:null},o=Symbol.for("react.portal");var l=r.__CLIENT_INTERNALS_DO_NOT_USE_OR_WARN_USERS_THEY_CANNOT_UPGRADE;function c(e,t){return"font"===e?"":"string"===typeof t?"use-credentials"===t?t:"":void 0}t.__DOM_INTERNALS_DO_NOT_USE_OR_WARN_USERS_THEY_CANNOT_UPGRADE=i,t.createPortal=function(e,t){var n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!t||1!==t.nodeType&&9!==t.nodeType&&11!==t.nodeType)throw Error(s(299));return function(e,t,n){var r=3<arguments.length&&void 0!==arguments[3]?arguments[3]:null;return{$$typeof:o,key:null==r?null:""+r,children:e,containerInfo:t,implementation:n}}(e,t,null,n)},t.flushSync=function(e){var t=l.T,n=i.p;try{if(l.T=null,i.p=2,e)return e()}finally{l.T=t,i.p=n,i.d.f()}},t.preconnect=function(e,t){"string"===typeof e&&(t?t="string"===typeof(t=t.crossOrigin)?"use-credentials"===t?t:"":void 0:t=null,i.d.C(e,t))},t.prefetchDNS=function(e){"string"===typeof e&&i.d.D(e)},t.preinit=function(e,t){if("string"===typeof e&&t&&"string"===typeof t.as){var n=t.as,r=c(n,t.crossOrigin),s="string"===typeof t.integrity?t.integrity:void 0,a="string"===typeof t.fetchPriority?t.fetchPriority:void 0;"style"===n?i.d.S(e,"string"===typeof t.precedence?t.precedence:void 0,{crossOrigin:r,integrity:s,fetchPriority:a}):"script"===n&&i.d.X(e,{crossOrigin:r,integrity:s,fetchPriority:a,nonce:"string"===typeof t.nonce?t.nonce:void 0})}},t.preinitModule=function(e,t){if("string"===typeof e)if("object"===typeof t&&null!==t){if(null==t.as||"script"===t.as){var n=c(t.as,t.crossOrigin);i.d.M(e,{crossOrigin:n,integrity:"string"===typeof t.integrity?t.integrity:void 0,nonce:"string"===typeof t.nonce?t.nonce:void 0})}}else null==t&&i.d.M(e)},t.preload=function(e,t){if("string"===typeof e&&"object"===typeof t&&null!==t&&"string"===typeof t.as){var n=t.as,r=c(n,t.crossOrigin);i.d.L(e,n,{crossOrigin:r,integrity:"string"===typeof t.integrity?t.integrity:void 0,nonce:"string"===typeof t.nonce?t.nonce:void 0,type:"string"===typeof t.type?t.type:void 0,fetchPriority:"string"===typeof t.fetchPriority?t.fetchPriority:void 0,referrerPolicy:"string"===typeof t.referrerPolicy?t.referrerPolicy:void 0,imageSrcSet:"string"===typeof t.imageSrcSet?t.imageSrcSet:void 0,imageSizes:"string"===typeof t.imageSizes?t.imageSizes:void 0,media:"string"===typeof t.media?t.media:void 0})}},t.preloadModule=function(e,t){if("string"===typeof e)if(t){var n=c(t.as,t.crossOrigin);i.d.m(e,{as:"string"===typeof t.as&&"script"!==t.as?t.as:void 0,crossOrigin:n,integrity:"string"===typeof t.integrity?t.integrity:void 0})}else i.d.m(e)},t.requestFormReset=function(e){i.d.r(e)},t.unstable_batchedUpdates=function(e,t){return e(t)},t.useFormState=function(e,t,n){return l.H.useFormState(e,t,n)},t.useFormStatus=function(){return l.H.useHostTransitionStatus()},t.version="19.2.0"},5128(e,t,n){"use strict";!function e(){if("undefined"!==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__&&"function"===typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE)try{__REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(e)}catch(t){console.error(t)}}(),e.exports=n(8477)},3775(e,t,n){"use strict";!function e(){if("undefined"!==typeof __REACT_DEVTOOLS_GLOBAL_HOOK__&&"function"===typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE)try{__REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(e)}catch(t){console.error(t)}}(),e.exports=n(7703)},108(e,t){"use strict";var n=Symbol.for("react.transitional.element"),r=Symbol.for("react.fragment");function s(e,t,r){var s=null;if(void 0!==r&&(s=""+r),void 0!==t.key&&(s=""+t.key),"key"in t)for(var a in r={},t)"key"!==a&&(r[a]=t[a]);else r=t;return t=r.ref,{$$typeof:n,type:e,key:s,ref:void 0!==t?t:null,props:r}}t.Fragment=r,t.jsx=s,t.jsxs=s},3967(e,t){"use strict";var n=Symbol.for("react.transitional.element"),r=Symbol.for("react.portal"),s=Symbol.for("react.fragment"),a=Symbol.for("react.strict_mode"),i=Symbol.for("react.profiler"),o=Symbol.for("react.consumer"),l=Symbol.for("react.context"),c=Symbol.for("react.forward_ref"),u=Symbol.for("react.suspense"),d=Symbol.for("react.memo"),h=Symbol.for("react.lazy"),f=Symbol.for("react.activity"),p=Symbol.iterator;var m={isMounted:function(){return!1},enqueueForceUpdate:function(){},enqueueReplaceState:function(){},enqueueSetState:function(){}},g=Object.assign,y={};function w(e,t,n){this.props=e,this.context=t,this.refs=y,this.updater=n||m}function v(){}function A(e,t,n){this.props=e,this.context=t,this.refs=y,this.updater=n||m}w.prototype.isReactComponent={},w.prototype.setState=function(e,t){if("object"!==typeof e&&"function"!==typeof e&&null!=e)throw Error("takes an object of state variables to update or a function which returns an object of state variables.");this.updater.enqueueSetState(this,e,t,"setState")},w.prototype.forceUpdate=function(e){this.updater.enqueueForceUpdate(this,e,"forceUpdate")},v.prototype=w.prototype;var b=A.prototype=new v;b.constructor=A,g(b,w.prototype),b.isPureReactComponent=!0;var x=Array.isArray;function S(){}var C={H:null,A:null,T:null,S:null},E=Object.prototype.hasOwnProperty;function N(e,t,r){var s=r.ref;return{$$typeof:n,type:e,key:t,ref:void 0!==s?s:null,props:r}}function k(e){return"object"===typeof e&&null!==e&&e.$$typeof===n}var T=/\/+/g;function I(e,t){return"object"===typeof e&&null!==e&&null!=e.key?function(e){var t={"=":"=0",":":"=2"};return"$"+e.replace(/[=:]/g,function(e){return t[e]})}(""+e.key):t.toString(36)}function _(e,t,s,a,i){var o=typeof e;"undefined"!==o&&"boolean"!==o||(e=null);var l,c,u=!1;if(null===e)u=!0;else switch(o){case"bigint":case"string":case"number":u=!0;break;case"object":switch(e.$$typeof){case n:case r:u=!0;break;case h:return _((u=e._init)(e._payload),t,s,a,i)}}if(u)return i=i(e),u=""===a?"."+I(e,0):a,x(i)?(s="",null!=u&&(s=u.replace(T,"$&/")+"/"),_(i,t,s,"",function(e){return e})):null!=i&&(k(i)&&(l=i,c=s+(null==i.key||e&&e.key===i.key?"":(""+i.key).replace(T,"$&/")+"/")+u,i=N(l.type,c,l.props)),t.push(i)),1;u=0;var d,f=""===a?".":a+":";if(x(e))for(var m=0;m<e.length;m++)u+=_(a=e[m],t,s,o=f+I(a,m),i);else if("function"===typeof(m=null===(d=e)||"object"!==typeof d?null:"function"===typeof(d=p&&d[p]||d["@@iterator"])?d:null))for(e=m.call(e),m=0;!(a=e.next()).done;)u+=_(a=a.value,t,s,o=f+I(a,m++),i);else if("object"===o){if("function"===typeof e.then)return _(function(e){switch(e.status){case"fulfilled":return e.value;case"rejected":throw e.reason;default:switch("string"===typeof e.status?e.then(S,S):(e.status="pending",e.then(function(t){"pending"===e.status&&(e.status="fulfilled",e.value=t)},function(t){"pending"===e.status&&(e.status="rejected",e.reason=t)})),e.status){case"fulfilled":return e.value;case"rejected":throw e.reason}}throw e}(e),t,s,a,i);throw t=String(e),Error("Objects are not valid as a React child (found: "+("[object Object]"===t?"object with keys {"+Object.keys(e).join(", ")+"}":t)+"). If you meant to render a collection of children, use an array instead.")}return u}function R(e,t,n){if(null==e)return e;var r=[],s=0;return _(e,r,"","",function(e){return t.call(n,e,s++)}),r}function M(e){if(-1===e._status){var t=e._result;(t=t()).then(function(t){0!==e._status&&-1!==e._status||(e._status=1,e._result=t)},function(t){0!==e._status&&-1!==e._status||(e._status=2,e._result=t)}),-1===e._status&&(e._status=0,e._result=t)}if(1===e._status)return e._result.default;throw e._result}var D="function"===typeof reportError?reportError:function(e){if("object"===typeof window&&"function"===typeof window.ErrorEvent){var t=new window.ErrorEvent("error",{bubbles:!0,cancelable:!0,message:"object"===typeof e&&null!==e&&"string"===typeof e.message?String(e.message):String(e),error:e});if(!window.dispatchEvent(t))return}else if("object"===typeof process&&"function"===typeof process.emit)return void process.emit("uncaughtException",e);console.error(e)},j={map:R,forEach:function(e,t,n){R(e,function(){t.apply(this,arguments)},n)},count:function(e){var t=0;return R(e,function(){t++}),t},toArray:function(e){return R(e,function(e){return e})||[]},only:function(e){if(!k(e))throw Error("React.Children.only expected to receive a single React element child.");return e}};t.Activity=f,t.Children=j,t.Component=w,t.Fragment=s,t.Profiler=i,t.PureComponent=A,t.StrictMode=a,t.Suspense=u,t.__CLIENT_INTERNALS_DO_NOT_USE_OR_WARN_USERS_THEY_CANNOT_UPGRADE=C,t.__COMPILER_RUNTIME={__proto__:null,c:function(e){return C.H.useMemoCache(e)}},t.cache=function(e){return function(){return e.apply(null,arguments)}},t.cacheSignal=function(){return null},t.cloneElement=function(e,t,n){if(null===e||void 0===e)throw Error("The argument must be a React element, but you passed "+e+".");var r=g({},e.props),s=e.key;if(null!=t)for(a in void 0!==t.key&&(s=""+t.key),t)!E.call(t,a)||"key"===a||"__self"===a||"__source"===a||"ref"===a&&void 0===t.ref||(r[a]=t[a]);var a=arguments.length-2;if(1===a)r.children=n;else if(1<a){for(var i=Array(a),o=0;o<a;o++)i[o]=arguments[o+2];r.children=i}return N(e.type,s,r)},t.createContext=function(e){return(e={$$typeof:l,_currentValue:e,_currentValue2:e,_threadCount:0,Provider:null,Consumer:null}).Provider=e,e.Consumer={$$typeof:o,_context:e},e},t.createElement=function(e,t,n){var r,s={},a=null;if(null!=t)for(r in void 0!==t.key&&(a=""+t.key),t)E.call(t,r)&&"key"!==r&&"__self"!==r&&"__source"!==r&&(s[r]=t[r]);var i=arguments.length-2;if(1===i)s.children=n;else if(1<i){for(var o=Array(i),l=0;l<i;l++)o[l]=arguments[l+2];s.children=o}if(e&&e.defaultProps)for(r in i=e.defaultProps)void 0===s[r]&&(s[r]=i[r]);return N(e,a,s)},t.createRef=function(){return{current:null}},t.forwardRef=function(e){return{$$typeof:c,render:e}},t.isValidElement=k,t.lazy=function(e){return{$$typeof:h,_payload:{_status:-1,_result:e},_init:M}},t.memo=function(e,t){return{$$typeof:d,type:e,compare:void 0===t?null:t}},t.startTransition=function(e){var t=C.T,n={};C.T=n;try{var r=e(),s=C.S;null!==s&&s(n,r),"object"===typeof r&&null!==r&&"function"===typeof r.then&&r.then(S,D)}catch(a){D(a)}finally{null!==t&&null!==n.types&&(t.types=n.types),C.T=t}},t.unstable_useCacheRefresh=function(){return C.H.useCacheRefresh()},t.use=function(e){return C.H.use(e)},t.useActionState=function(e,t,n){return C.H.useActionState(e,t,n)},t.useCallback=function(e,t){return C.H.useCallback(e,t)},t.useContext=function(e){return C.H.useContext(e)},t.useDebugValue=function(){},t.useDeferredValue=function(e,t){return C.H.useDeferredValue(e,t)},t.useEffect=function(e,t){return C.H.useEffect(e,t)},t.useEffectEvent=function(e){return C.H.useEffectEvent(e)},t.useId=function(){return C.H.useId()},t.useImperativeHandle=function(e,t,n){return C.H.useImperativeHandle(e,t,n)},t.useInsertionEffect=function(e,t){return C.H.useInsertionEffect(e,t)},t.useLayoutEffect=function(e,t){return C.H.useLayoutEffect(e,t)},t.useMemo=function(e,t){return C.H.useMemo(e,t)},t.useOptimistic=function(e,t){return C.H.useOptimistic(e,t)},t.useReducer=function(e,t,n){return C.H.useReducer(e,t,n)},t.useRef=function(e){return C.H.useRef(e)},t.useState=function(e){return C.H.useState(e)},t.useSyncExternalStore=function(e,t,n){return C.H.useSyncExternalStore(e,t,n)},t.useTransition=function(){return C.H.useTransition()},t.version="19.2.0"},8094(e,t,n){"use strict";e.exports=n(3967)},5678(e,t,n){"use strict";e.exports=n(108)},799(e,t){"use strict";function n(e,t){var n=e.length;e.push(t);e:for(;0<n;){var r=n-1>>>1,s=e[r];if(!(0<a(s,t)))break e;e[r]=t,e[n]=s,n=r}}function r(e){return 0===e.length?null:e[0]}function s(e){if(0===e.length)return null;var t=e[0],n=e.pop();if(n!==t){e[0]=n;e:for(var r=0,s=e.length,i=s>>>1;r<i;){var o=2*(r+1)-1,l=e[o],c=o+1,u=e[c];if(0>a(l,n))c<s&&0>a(u,l)?(e[r]=u,e[c]=n,r=c):(e[r]=l,e[o]=n,r=o);else{if(!(c<s&&0>a(u,n)))break e;e[r]=u,e[c]=n,r=c}}}return t}function a(e,t){var n=e.sortIndex-t.sortIndex;return 0!==n?n:e.id-t.id}if(t.unstable_now=void 0,"object"===typeof performance&&"function"===typeof performance.now){var i=performance;t.unstable_now=function(){return i.now()}}else{var o=Date,l=o.now();t.unstable_now=function(){return o.now()-l}}var c=[],u=[],d=1,h=null,f=3,p=!1,m=!1,g=!1,y=!1,w="function"===typeof setTimeout?setTimeout:null,v="function"===typeof clearTimeout?clearTimeout:null,A="undefined"!==typeof setImmediate?setImmediate:null;function b(e){for(var t=r(u);null!==t;){if(null===t.callback)s(u);else{if(!(t.startTime<=e))break;s(u),t.sortIndex=t.expirationTime,n(c,t)}t=r(u)}}function x(e){if(g=!1,b(e),!m)if(null!==r(c))m=!0,C||(C=!0,S());else{var t=r(u);null!==t&&M(x,t.startTime-e)}}var S,C=!1,E=-1,N=5,k=-1;function T(){return!!y||!(t.unstable_now()-k<N)}function I(){if(y=!1,C){var e=t.unstable_now();k=e;var n=!0;try{e:{m=!1,g&&(g=!1,v(E),E=-1),p=!0;var a=f;try{t:{for(b(e),h=r(c);null!==h&&!(h.expirationTime>e&&T());){var i=h.callback;if("function"===typeof i){h.callback=null,f=h.priorityLevel;var o=i(h.expirationTime<=e);if(e=t.unstable_now(),"function"===typeof o){h.callback=o,b(e),n=!0;break t}h===r(c)&&s(c),b(e)}else s(c);h=r(c)}if(null!==h)n=!0;else{var l=r(u);null!==l&&M(x,l.startTime-e),n=!1}}break e}finally{h=null,f=a,p=!1}n=void 0}}finally{n?S():C=!1}}}if("function"===typeof A)S=function(){A(I)};else if("undefined"!==typeof MessageChannel){var _=new MessageChannel,R=_.port2;_.port1.onmessage=I,S=function(){R.postMessage(null)}}else S=function(){w(I,0)};function M(e,n){E=w(function(){e(t.unstable_now())},n)}t.unstable_IdlePriority=5,t.unstable_ImmediatePriority=1,t.unstable_LowPriority=4,t.unstable_NormalPriority=3,t.unstable_Profiling=null,t.unstable_UserBlockingPriority=2,t.unstable_cancelCallback=function(e){e.callback=null},t.unstable_forceFrameRate=function(e){0>e||125<e?console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported"):N=0<e?Math.floor(1e3/e):5},t.unstable_getCurrentPriorityLevel=function(){return f},t.unstable_next=function(e){switch(f){case 1:case 2:case 3:var t=3;break;default:t=f}var n=f;f=t;try{return e()}finally{f=n}},t.unstable_requestPaint=function(){y=!0},t.unstable_runWithPriority=function(e,t){switch(e){case 1:case 2:case 3:case 4:case 5:break;default:e=3}var n=f;f=e;try{return t()}finally{f=n}},t.unstable_scheduleCallback=function(e,s,a){var i=t.unstable_now();switch("object"===typeof a&&null!==a?a="number"===typeof(a=a.delay)&&0<a?i+a:i:a=i,e){case 1:var o=-1;break;case 2:o=250;break;case 5:o=1073741823;break;case 4:o=1e4;break;default:o=5e3}return e={id:d++,callback:s,priorityLevel:e,startTime:a,expirationTime:o=a+o,sortIndex:-1},a>i?(e.sortIndex=a,n(u,e),null===r(c)&&e===r(u)&&(g?(v(E),E=-1):g=!0,M(x,a-i))):(e.sortIndex=o,n(c,e),m||p||(m=!0,C||(C=!0,S()))),e},t.unstable_shouldYield=T,t.unstable_wrapCallback=function(e){var t=f;return function(){var n=f;f=t;try{return e.apply(this,arguments)}finally{f=n}}}},8732(e,t,n){"use strict";e.exports=n(799)},327(e,t,n){var r={"./ar.json":[5310,[310]],"./en.json":[4174,[174]],"./es.json":[6725,[725]],"./fr.json":[4605,[605]],"./ja.json":[7980,[980]],"./ko.json":[9423,[423]],"./ru.json":[4600,[600]],"./zh.json":[9527,[527]]};function s(e){if(!n.o(r,e))return Promise.resolve().then(()=>{var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t});var t=r[e],s=t[0];return n.e(t[1][0]).then(()=>n.t(s,19))}s.keys=()=>Object.keys(r),s.id=327,e.exports=s},477(){},6562(e,t,n){"use strict";function r(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}n.d(t,{A:()=>r})},8195(e,t,n){"use strict";function r(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}n.d(t,{A:()=>r})},8458(e,t,n){"use strict";n.d(t,{A:()=>s});var r=n(6562);function s(e,t){return e.get((0,r.A)(e,t))}},5149(e,t,n){"use strict";n.d(t,{A:()=>s});var r=n(8195);function s(e,t,n){(0,r.A)(e,t),t.set(e,n)}},2177(e,t,n){"use strict";n.d(t,{A:()=>s});var r=n(6562);function s(e,t,n){return e.set((0,r.A)(e,t),n),n}},9790(e,t,n){"use strict";n.d(t,{A:()=>s});var r=n(8195);function s(e,t){(0,r.A)(e,t),t.add(e)}},4705(e,t,n){"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function s(e){var t=function(e,t){if("object"!=r(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var s=n.call(e,t||"default");if("object"!=r(s))return s;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==r(t)?t:t+""}function a(e,t,n){return(t=s(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}n.d(t,{A:()=>a})},9379(e,t,n){"use strict";n.d(t,{A:()=>a});var r=n(4705);function s(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter(function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable})),n.push.apply(n,r)}return n}function a(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?s(Object(n),!0).forEach(function(t){(0,r.A)(e,t,n[t])}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):s(Object(n)).forEach(function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))})}return e}},7952(e,t,n){"use strict";function r(e){if(!Number.isSafeInteger(e)||e<0)throw new Error("Wrong positive integer: ".concat(e))}function s(e){if(!(e instanceof Uint8Array))throw new Error("Expected Uint8Array");for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];if(n.length>0&&!n.includes(e.length))throw new Error("Expected Uint8Array of length ".concat(n,", not of length=").concat(e.length))}function a(e){if("function"!==typeof e||"function"!==typeof e.create)throw new Error("Hash should be wrapped by utils.wrapConstructor");r(e.outputLen),r(e.blockLen)}function i(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(e.destroyed)throw new Error("Hash instance has been destroyed");if(t&&e.finished)throw new Error("Hash#digest() has already been called")}function o(e,t){s(e);const n=t.outputLen;if(e.length<n)throw new Error("digestInto() expects output buffer of length at least ".concat(n))}n.d(t,{CG:()=>o,ai:()=>r,ee:()=>s,t2:()=>i,tW:()=>a})},4814(e,t,n){"use strict";n.d(t,{D:()=>a});var r=n(7952),s=n(5621);class a extends s.Vw{constructor(e,t,n,r){super(),this.blockLen=e,this.outputLen=t,this.padOffset=n,this.isLE=r,this.finished=!1,this.length=0,this.pos=0,this.destroyed=!1,this.buffer=new Uint8Array(e),this.view=(0,s.O8)(this.buffer)}update(e){(0,r.t2)(this);const{view:t,buffer:n,blockLen:a}=this,i=(e=(0,s.ZJ)(e)).length;for(let r=0;r<i;){const o=Math.min(a-this.pos,i-r);if(o===a){const t=(0,s.O8)(e);for(;a<=i-r;r+=a)this.process(t,r);continue}n.set(e.subarray(r,r+o),this.pos),this.pos+=o,r+=o,this.pos===a&&(this.process(t,0),this.pos=0)}return this.length+=e.length,this.roundClean(),this}digestInto(e){(0,r.t2)(this),(0,r.CG)(e,this),this.finished=!0;const{buffer:t,view:n,blockLen:a,isLE:i}=this;let{pos:o}=this;t[o++]=128,this.buffer.subarray(o).fill(0),this.padOffset>a-o&&(this.process(n,0),o=0);for(let r=o;r<a;r++)t[r]=0;!function(e,t,n,r){if("function"===typeof e.setBigUint64)return e.setBigUint64(t,n,r);const s=BigInt(32),a=BigInt(4294967295),i=Number(n>>s&a),o=Number(n&a),l=r?4:0,c=r?0:4;e.setUint32(t+l,i,r),e.setUint32(t+c,o,r)}(n,a-8,BigInt(8*this.length),i),this.process(n,0);const l=(0,s.O8)(e),c=this.outputLen;if(c%4)throw new Error("_sha2: outputLen should be aligned to 32bit");const u=c/4,d=this.get();if(u>d.length)throw new Error("_sha2: outputLen bigger than state");for(let r=0;r<u;r++)l.setUint32(4*r,d[r],i)}digest(){const{buffer:e,outputLen:t}=this;this.digestInto(e);const n=e.slice(0,t);return this.destroy(),n}_cloneInto(e){e||(e=new this.constructor),e.set(...this.get());const{blockLen:t,buffer:n,length:r,finished:s,destroyed:a,pos:i}=this;return e.length=r,e.pos=i,e.finished=s,e.destroyed=a,r%t&&e.buffer.set(n),e}}},4421(e,t,n){"use strict";n.d(t,{Ay:()=>d,B4:()=>l,P5:()=>o,WM:()=>c,im:()=>u,lD:()=>i});const r=BigInt(2**32-1),s=BigInt(32);function a(e){return arguments.length>1&&void 0!==arguments[1]&&arguments[1]?{h:Number(e&r),l:Number(e>>s&r)}:{h:0|Number(e>>s&r),l:0|Number(e&r)}}function i(e){let t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=new Uint32Array(e.length),r=new Uint32Array(e.length);for(let s=0;s<e.length;s++){const{h:i,l:o}=a(e[s],t);[n[s],r[s]]=[i,o]}return[n,r]}const o=(e,t,n)=>e<<n|t>>>32-n,l=(e,t,n)=>t<<n|e>>>32-n,c=(e,t,n)=>t<<n-32|e>>>64-n,u=(e,t,n)=>e<<n-32|t>>>64-n;const d={fromBig:a,split:i,toBig:(e,t)=>BigInt(e>>>0)<<s|BigInt(t>>>0),shrSH:(e,t,n)=>e>>>n,shrSL:(e,t,n)=>e<<32-n|t>>>n,rotrSH:(e,t,n)=>e>>>n|t<<32-n,rotrSL:(e,t,n)=>e<<32-n|t>>>n,rotrBH:(e,t,n)=>e<<64-n|t>>>n-32,rotrBL:(e,t,n)=>e>>>n-32|t<<64-n,rotr32H:(e,t)=>t,rotr32L:(e,t)=>e,rotlSH:o,rotlSL:l,rotlBH:c,rotlBL:u,add:function(e,t,n,r){const s=(t>>>0)+(r>>>0);return{h:e+n+(s/2**32|0)|0,l:0|s}},add3L:(e,t,n)=>(e>>>0)+(t>>>0)+(n>>>0),add3H:(e,t,n,r)=>t+n+r+(e/2**32|0)|0,add4L:(e,t,n,r)=>(e>>>0)+(t>>>0)+(n>>>0)+(r>>>0),add4H:(e,t,n,r,s)=>t+n+r+s+(e/2**32|0)|0,add5H:(e,t,n,r,s,a)=>t+n+r+s+a+(e/2**32|0)|0,add5L:(e,t,n,r,s)=>(e>>>0)+(t>>>0)+(n>>>0)+(r>>>0)+(s>>>0)}},4432(e,t,n){"use strict";n.d(t,{w:()=>i});var r=n(7952),s=n(5621);class a extends s.Vw{constructor(e,t){super(),this.finished=!1,this.destroyed=!1,(0,r.tW)(e);const n=(0,s.ZJ)(t);if(this.iHash=e.create(),"function"!==typeof this.iHash.update)throw new Error("Expected instance of class which extends utils.Hash");this.blockLen=this.iHash.blockLen,this.outputLen=this.iHash.outputLen;const a=this.blockLen,i=new Uint8Array(a);i.set(n.length>a?e.create().update(n).digest():n);for(let r=0;r<i.length;r++)i[r]^=54;this.iHash.update(i),this.oHash=e.create();for(let r=0;r<i.length;r++)i[r]^=106;this.oHash.update(i),i.fill(0)}update(e){return(0,r.t2)(this),this.iHash.update(e),this}digestInto(e){(0,r.t2)(this),(0,r.ee)(e,this.outputLen),this.finished=!0,this.iHash.digestInto(e),this.oHash.update(e),this.oHash.digestInto(e),this.destroy()}digest(){const e=new Uint8Array(this.oHash.outputLen);return this.digestInto(e),e}_cloneInto(e){e||(e=Object.create(Object.getPrototypeOf(this),{}));const{oHash:t,iHash:n,finished:r,destroyed:s,blockLen:a,outputLen:i}=this;return e.finished=r,e.destroyed=s,e.blockLen=a,e.outputLen=i,e.oHash=t._cloneInto(e.oHash),e.iHash=n._cloneInto(e.iHash),e}destroy(){this.destroyed=!0,this.oHash.destroy(),this.iHash.destroy()}}const i=(e,t,n)=>new a(e,t).update(n).digest();i.create=(e,t)=>new a(e,t)},6390(e,t,n){"use strict";n.d(t,{A:()=>l});var r=n(7952),s=n(4432),a=n(5621);function i(e,t,n,i){(0,r.tW)(e);const o=(0,a.tY)({dkLen:32,asyncTick:10},i),{c:l,dkLen:c,asyncTick:u}=o;if((0,r.ai)(l),(0,r.ai)(c),(0,r.ai)(u),l<1)throw new Error("PBKDF2: iterations (c) should be >= 1");const d=(0,a.ZJ)(t),h=(0,a.ZJ)(n),f=new Uint8Array(c),p=s.w.create(e,d),m=p._cloneInto().update(h);return{c:l,dkLen:c,asyncTick:u,DK:f,PRF:p,PRFSalt:m}}function o(e,t,n,r,s){return e.destroy(),t.destroy(),r&&r.destroy(),s.fill(0),n}function l(e,t,n,r){const{c:s,dkLen:l,DK:c,PRF:u,PRFSalt:d}=i(e,t,n,r);let h;const f=new Uint8Array(4),p=(0,a.O8)(f),m=new Uint8Array(u.outputLen);for(let a=1,i=0;i<l;a++,i+=u.outputLen){const e=c.subarray(i,i+u.outputLen);p.setInt32(0,a,!1),(h=d._cloneInto(h)).update(f).digestInto(m),e.set(m.subarray(0,e.length));for(let t=1;t<s;t++){u._cloneInto(h).update(m).digestInto(m);for(let t=0;t<e.length;t++)e[t]^=m[t]}}return o(u,d,c,h,m)}},7804(e,t,n){"use strict";n.d(t,{s:()=>d});var r=n(4814),s=n(5621);const a=(e,t,n)=>e&t^~e&n,i=(e,t,n)=>e&t^e&n^t&n,o=new Uint32Array([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]),l=new Uint32Array([1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225]),c=new Uint32Array(64);class u extends r.D{constructor(){super(64,32,8,!1),this.A=0|l[0],this.B=0|l[1],this.C=0|l[2],this.D=0|l[3],this.E=0|l[4],this.F=0|l[5],this.G=0|l[6],this.H=0|l[7]}get(){const{A:e,B:t,C:n,D:r,E:s,F:a,G:i,H:o}=this;return[e,t,n,r,s,a,i,o]}set(e,t,n,r,s,a,i,o){this.A=0|e,this.B=0|t,this.C=0|n,this.D=0|r,this.E=0|s,this.F=0|a,this.G=0|i,this.H=0|o}process(e,t){for(let s=0;s<16;s++,t+=4)c[s]=e.getUint32(t,!1);for(let a=16;a<64;a++){const e=c[a-15],t=c[a-2],n=(0,s.Ow)(e,7)^(0,s.Ow)(e,18)^e>>>3,r=(0,s.Ow)(t,17)^(0,s.Ow)(t,19)^t>>>10;c[a]=r+c[a-7]+n+c[a-16]|0}let{A:n,B:r,C:l,D:u,E:d,F:h,G:f,H:p}=this;for(let m=0;m<64;m++){const e=p+((0,s.Ow)(d,6)^(0,s.Ow)(d,11)^(0,s.Ow)(d,25))+a(d,h,f)+o[m]+c[m]|0,t=((0,s.Ow)(n,2)^(0,s.Ow)(n,13)^(0,s.Ow)(n,22))+i(n,r,l)|0;p=f,f=h,h=d,d=u+e|0,u=l,l=r,r=n,n=e+t|0}n=n+this.A|0,r=r+this.B|0,l=l+this.C|0,u=u+this.D|0,d=d+this.E|0,h=h+this.F|0,f=f+this.G|0,p=p+this.H|0,this.set(n,r,l,u,d,h,f,p)}roundClean(){c.fill(0)}destroy(){this.set(0,0,0,0,0,0,0,0),this.buffer.fill(0)}}const d=(0,s.ld)(()=>new u)},5621(e,t,n){"use strict";n.d(t,{Vw:()=>h,$h:()=>c,tY:()=>p,Id:()=>d,O8:()=>i,po:()=>g,Ow:()=>o,ZJ:()=>u,DH:()=>a,ld:()=>m});const r="object"===typeof globalThis&&"crypto"in globalThis?globalThis.crypto:void 0,s=e=>e instanceof Uint8Array,a=e=>new Uint32Array(e.buffer,e.byteOffset,Math.floor(e.byteLength/4)),i=e=>new DataView(e.buffer,e.byteOffset,e.byteLength),o=(e,t)=>e<<32-t|e>>>t;if(!(68===new Uint8Array(new Uint32Array([287454020]).buffer)[0]))throw new Error("Non little-endian hardware is not supported");const l=async()=>{};async function c(e,t,n){let r=Date.now();for(let s=0;s<e;s++){n(s);const e=Date.now()-r;e>=0&&e<t||(await l(),r+=e)}}function u(e){if("string"===typeof e&&(e=function(e){if("string"!==typeof e)throw new Error("utf8ToBytes expected string, got ".concat(typeof e));return new Uint8Array((new TextEncoder).encode(e))}(e)),!s(e))throw new Error("expected Uint8Array, got ".concat(typeof e));return e}function d(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];const r=new Uint8Array(t.reduce((e,t)=>e+t.length,0));let a=0;return t.forEach(e=>{if(!s(e))throw new Error("Uint8Array expected");r.set(e,a),a+=e.length}),r}class h{clone(){return this._cloneInto()}}const f={}.toString;function p(e,t){if(void 0!==t&&"[object Object]"!==f.call(t))throw new Error("Options should be object or undefined");return Object.assign(e,t)}function m(e){const t=t=>e().update(u(t)).digest(),n=e();return t.outputLen=n.outputLen,t.blockLen=n.blockLen,t.create=()=>e(),t}function g(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:32;if(r&&"function"===typeof r.getRandomValues)return r.getRandomValues(new Uint8Array(e));throw new Error("crypto.getRandomValues must be defined")}},2473(e,t,n){"use strict";n.d(t,{Xp:()=>R,cf:()=>F,ny:()=>U});var r,s,a,i=function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"===typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)},o=function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"===typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n};const l={16:10,24:12,32:14},c=[1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145],u=[99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22],d=[82,9,106,213,48,54,165,56,191,64,163,158,129,243,215,251,124,227,57,130,155,47,255,135,52,142,67,68,196,222,233,203,84,123,148,50,166,194,35,61,238,76,149,11,66,250,195,78,8,46,161,102,40,217,36,178,118,91,162,73,109,139,209,37,114,248,246,100,134,104,152,22,212,164,92,204,93,101,182,146,108,112,72,80,253,237,185,218,94,21,70,87,167,141,157,132,144,216,171,0,140,188,211,10,247,228,88,5,184,179,69,6,208,44,30,143,202,63,15,2,193,175,189,3,1,19,138,107,58,145,17,65,79,103,220,234,151,242,207,206,240,180,230,115,150,172,116,34,231,173,53,133,226,249,55,232,28,117,223,110,71,241,26,113,29,41,197,137,111,183,98,14,170,24,190,27,252,86,62,75,198,210,121,32,154,219,192,254,120,205,90,244,31,221,168,51,136,7,199,49,177,18,16,89,39,128,236,95,96,81,127,169,25,181,74,13,45,229,122,159,147,201,156,239,160,224,59,77,174,42,245,176,200,235,187,60,131,83,153,97,23,43,4,126,186,119,214,38,225,105,20,99,85,33,12,125],h=[3328402341,4168907908,4000806809,4135287693,4294111757,3597364157,3731845041,2445657428,1613770832,33620227,3462883241,1445669757,3892248089,3050821474,1303096294,3967186586,2412431941,528646813,2311702848,4202528135,4026202645,2992200171,2387036105,4226871307,1101901292,3017069671,1604494077,1169141738,597466303,1403299063,3832705686,2613100635,1974974402,3791519004,1033081774,1277568618,1815492186,2118074177,4126668546,2211236943,1748251740,1369810420,3521504564,4193382664,3799085459,2883115123,1647391059,706024767,134480908,2512897874,1176707941,2646852446,806885416,932615841,168101135,798661301,235341577,605164086,461406363,3756188221,3454790438,1311188841,2142417613,3933566367,302582043,495158174,1479289972,874125870,907746093,3698224818,3025820398,1537253627,2756858614,1983593293,3084310113,2108928974,1378429307,3722699582,1580150641,327451799,2790478837,3117535592,0,3253595436,1075847264,3825007647,2041688520,3059440621,3563743934,2378943302,1740553945,1916352843,2487896798,2555137236,2958579944,2244988746,3151024235,3320835882,1336584933,3992714006,2252555205,2588757463,1714631509,293963156,2319795663,3925473552,67240454,4269768577,2689618160,2017213508,631218106,1269344483,2723238387,1571005438,2151694528,93294474,1066570413,563977660,1882732616,4059428100,1673313503,2008463041,2950355573,1109467491,537923632,3858759450,4260623118,3218264685,2177748300,403442708,638784309,3287084079,3193921505,899127202,2286175436,773265209,2479146071,1437050866,4236148354,2050833735,3362022572,3126681063,840505643,3866325909,3227541664,427917720,2655997905,2749160575,1143087718,1412049534,999329963,193497219,2353415882,3354324521,1807268051,672404540,2816401017,3160301282,369822493,2916866934,3688947771,1681011286,1949973070,336202270,2454276571,201721354,1210328172,3093060836,2680341085,3184776046,1135389935,3294782118,965841320,831886756,3554993207,4068047243,3588745010,2345191491,1849112409,3664604599,26054028,2983581028,2622377682,1235855840,3630984372,2891339514,4092916743,3488279077,3395642799,4101667470,1202630377,268961816,1874508501,4034427016,1243948399,1546530418,941366308,1470539505,1941222599,2546386513,3421038627,2715671932,3899946140,1042226977,2521517021,1639824860,227249030,260737669,3765465232,2084453954,1907733956,3429263018,2420656344,100860677,4160157185,470683154,3261161891,1781871967,2924959737,1773779408,394692241,2579611992,974986535,664706745,3655459128,3958962195,731420851,571543859,3530123707,2849626480,126783113,865375399,765172662,1008606754,361203602,3387549984,2278477385,2857719295,1344809080,2782912378,59542671,1503764984,160008576,437062935,1707065306,3622233649,2218934982,3496503480,2185314755,697932208,1512910199,504303377,2075177163,2824099068,1841019862,739644986],f=[2781242211,2230877308,2582542199,2381740923,234877682,3184946027,2984144751,1418839493,1348481072,50462977,2848876391,2102799147,434634494,1656084439,3863849899,2599188086,1167051466,2636087938,1082771913,2281340285,368048890,3954334041,3381544775,201060592,3963727277,1739838676,4250903202,3930435503,3206782108,4149453988,2531553906,1536934080,3262494647,484572669,2923271059,1783375398,1517041206,1098792767,49674231,1334037708,1550332980,4098991525,886171109,150598129,2481090929,1940642008,1398944049,1059722517,201851908,1385547719,1699095331,1587397571,674240536,2704774806,252314885,3039795866,151914247,908333586,2602270848,1038082786,651029483,1766729511,3447698098,2682942837,454166793,2652734339,1951935532,775166490,758520603,3000790638,4004797018,4217086112,4137964114,1299594043,1639438038,3464344499,2068982057,1054729187,1901997871,2534638724,4121318227,1757008337,0,750906861,1614815264,535035132,3363418545,3988151131,3201591914,1183697867,3647454910,1265776953,3734260298,3566750796,3903871064,1250283471,1807470800,717615087,3847203498,384695291,3313910595,3617213773,1432761139,2484176261,3481945413,283769337,100925954,2180939647,4037038160,1148730428,3123027871,3813386408,4087501137,4267549603,3229630528,2315620239,2906624658,3156319645,1215313976,82966005,3747855548,3245848246,1974459098,1665278241,807407632,451280895,251524083,1841287890,1283575245,337120268,891687699,801369324,3787349855,2721421207,3431482436,959321879,1469301956,4065699751,2197585534,1199193405,2898814052,3887750493,724703513,2514908019,2696962144,2551808385,3516813135,2141445340,1715741218,2119445034,2872807568,2198571144,3398190662,700968686,3547052216,1009259540,2041044702,3803995742,487983883,1991105499,1004265696,1449407026,1316239930,504629770,3683797321,168560134,1816667172,3837287516,1570751170,1857934291,4014189740,2797888098,2822345105,2754712981,936633572,2347923833,852879335,1133234376,1500395319,3084545389,2348912013,1689376213,3533459022,3762923945,3034082412,4205598294,133428468,634383082,2949277029,2398386810,3913789102,403703816,3580869306,2297460856,1867130149,1918643758,607656988,4049053350,3346248884,1368901318,600565992,2090982877,2632479860,557719327,3717614411,3697393085,2249034635,2232388234,2430627952,1115438654,3295786421,2865522278,3633334344,84280067,33027830,303828494,2747425121,1600795957,4188952407,3496589753,2434238086,1486471617,658119965,3106381470,953803233,334231800,3005978776,857870609,3151128937,1890179545,2298973838,2805175444,3056442267,574365214,2450884487,550103529,1233637070,4289353045,2018519080,2057691103,2399374476,4166623649,2148108681,387583245,3664101311,836232934,3330556482,3100665960,3280093505,2955516313,2002398509,287182607,3413881008,4238890068,3597515707,975967766],p=[1671808611,2089089148,2006576759,2072901243,4061003762,1807603307,1873927791,3310653893,810573872,16974337,1739181671,729634347,4263110654,3613570519,2883997099,1989864566,3393556426,2191335298,3376449993,2106063485,4195741690,1508618841,1204391495,4027317232,2917941677,3563566036,2734514082,2951366063,2629772188,2767672228,1922491506,3227229120,3082974647,4246528509,2477669779,644500518,911895606,1061256767,4144166391,3427763148,878471220,2784252325,3845444069,4043897329,1905517169,3631459288,827548209,356461077,67897348,3344078279,593839651,3277757891,405286936,2527147926,84871685,2595565466,118033927,305538066,2157648768,3795705826,3945188843,661212711,2999812018,1973414517,152769033,2208177539,745822252,439235610,455947803,1857215598,1525593178,2700827552,1391895634,994932283,3596728278,3016654259,695947817,3812548067,795958831,2224493444,1408607827,3513301457,0,3979133421,543178784,4229948412,2982705585,1542305371,1790891114,3410398667,3201918910,961245753,1256100938,1289001036,1491644504,3477767631,3496721360,4012557807,2867154858,4212583931,1137018435,1305975373,861234739,2241073541,1171229253,4178635257,33948674,2139225727,1357946960,1011120188,2679776671,2833468328,1374921297,2751356323,1086357568,2408187279,2460827538,2646352285,944271416,4110742005,3168756668,3066132406,3665145818,560153121,271589392,4279952895,4077846003,3530407890,3444343245,202643468,322250259,3962553324,1608629855,2543990167,1154254916,389623319,3294073796,2817676711,2122513534,1028094525,1689045092,1575467613,422261273,1939203699,1621147744,2174228865,1339137615,3699352540,577127458,712922154,2427141008,2290289544,1187679302,3995715566,3100863416,339486740,3732514782,1591917662,186455563,3681988059,3762019296,844522546,978220090,169743370,1239126601,101321734,611076132,1558493276,3260915650,3547250131,2901361580,1655096418,2443721105,2510565781,3828863972,2039214713,3878868455,3359869896,928607799,1840765549,2374762893,3580146133,1322425422,2850048425,1823791212,1459268694,4094161908,3928346602,1706019429,2056189050,2934523822,135794696,3134549946,2022240376,628050469,779246638,472135708,2800834470,3032970164,3327236038,3894660072,3715932637,1956440180,522272287,1272813131,3185336765,2340818315,2323976074,1888542832,1044544574,3049550261,1722469478,1222152264,50660867,4127324150,236067854,1638122081,895445557,1475980887,3117443513,2257655686,3243809217,489110045,2662934430,3778599393,4162055160,2561878936,288563729,1773916777,3648039385,2391345038,2493985684,2612407707,505560094,2274497927,3911240169,3460925390,1442818645,678973480,3749357023,2358182796,2717407649,2306869641,219617805,3218761151,3862026214,1120306242,1756942440,1103331905,2578459033,762796589,252780047,2966125488,1425844308,3151392187,372911126],m=[1667474886,2088535288,2004326894,2071694838,4075949567,1802223062,1869591006,3318043793,808472672,16843522,1734846926,724270422,4278065639,3621216949,2880169549,1987484396,3402253711,2189597983,3385409673,2105378810,4210693615,1499065266,1195886990,4042263547,2913856577,3570689971,2728590687,2947541573,2627518243,2762274643,1920112356,3233831835,3082273397,4261223649,2475929149,640051788,909531756,1061110142,4160160501,3435941763,875846760,2779116625,3857003729,4059105529,1903268834,3638064043,825316194,353713962,67374088,3351728789,589522246,3284360861,404236336,2526454071,84217610,2593830191,117901582,303183396,2155911963,3806477791,3958056653,656894286,2998062463,1970642922,151591698,2206440989,741110872,437923380,454765878,1852748508,1515908788,2694904667,1381168804,993742198,3604373943,3014905469,690584402,3823320797,791638366,2223281939,1398011302,3520161977,0,3991743681,538992704,4244381667,2981218425,1532751286,1785380564,3419096717,3200178535,960056178,1246420628,1280103576,1482221744,3486468741,3503319995,4025428677,2863326543,4227536621,1128514950,1296947098,859002214,2240123921,1162203018,4193849577,33687044,2139062782,1347481760,1010582648,2678045221,2829640523,1364325282,2745433693,1077985408,2408548869,2459086143,2644360225,943212656,4126475505,3166494563,3065430391,3671750063,555836226,269496352,4294908645,4092792573,3537006015,3452783745,202118168,320025894,3974901699,1600119230,2543297077,1145359496,387397934,3301201811,2812801621,2122220284,1027426170,1684319432,1566435258,421079858,1936954854,1616945344,2172753945,1330631070,3705438115,572679748,707427924,2425400123,2290647819,1179044492,4008585671,3099120491,336870440,3739122087,1583276732,185277718,3688593069,3772791771,842159716,976899700,168435220,1229577106,101059084,606366792,1549591736,3267517855,3553849021,2897014595,1650632388,2442242105,2509612081,3840161747,2038008818,3890688725,3368567691,926374254,1835907034,2374863873,3587531953,1313788572,2846482505,1819063512,1448540844,4109633523,3941213647,1701162954,2054852340,2930698567,134748176,3132806511,2021165296,623210314,774795868,471606328,2795958615,3031746419,3334885783,3907527627,3722280097,1953799400,522133822,1263263126,3183336545,2341176845,2324333839,1886425312,1044267644,3048588401,1718004428,1212733584,50529542,4143317495,235803164,1633788866,892690282,1465383342,3115962473,2256965911,3250673817,488449850,2661202215,3789633753,4177007595,2560144171,286339874,1768537042,3654906025,2391705863,2492770099,2610673197,505291324,2273808917,3924369609,3469625735,1431699370,673740880,3755965093,2358021891,2711746649,2307489801,218961690,3217021541,3873845719,1111672452,1751693520,1094828930,2576986153,757954394,252645662,2964376443,1414855848,3149649517,370555436],g=[1374988112,2118214995,437757123,975658646,1001089995,530400753,2902087851,1273168787,540080725,2910219766,2295101073,4110568485,1340463100,3307916247,641025152,3043140495,3736164937,632953703,1172967064,1576976609,3274667266,2169303058,2370213795,1809054150,59727847,361929877,3211623147,2505202138,3569255213,1484005843,1239443753,2395588676,1975683434,4102977912,2572697195,666464733,3202437046,4035489047,3374361702,2110667444,1675577880,3843699074,2538681184,1649639237,2976151520,3144396420,4269907996,4178062228,1883793496,2403728665,2497604743,1383856311,2876494627,1917518562,3810496343,1716890410,3001755655,800440835,2261089178,3543599269,807962610,599762354,33778362,3977675356,2328828971,2809771154,4077384432,1315562145,1708848333,101039829,3509871135,3299278474,875451293,2733856160,92987698,2767645557,193195065,1080094634,1584504582,3178106961,1042385657,2531067453,3711829422,1306967366,2438237621,1908694277,67556463,1615861247,429456164,3602770327,2302690252,1742315127,2968011453,126454664,3877198648,2043211483,2709260871,2084704233,4169408201,0,159417987,841739592,504459436,1817866830,4245618683,260388950,1034867998,908933415,168810852,1750902305,2606453969,607530554,202008497,2472011535,3035535058,463180190,2160117071,1641816226,1517767529,470948374,3801332234,3231722213,1008918595,303765277,235474187,4069246893,766945465,337553864,1475418501,2943682380,4003061179,2743034109,4144047775,1551037884,1147550661,1543208500,2336434550,3408119516,3069049960,3102011747,3610369226,1113818384,328671808,2227573024,2236228733,3535486456,2935566865,3341394285,496906059,3702665459,226906860,2009195472,733156972,2842737049,294930682,1206477858,2835123396,2700099354,1451044056,573804783,2269728455,3644379585,2362090238,2564033334,2801107407,2776292904,3669462566,1068351396,742039012,1350078989,1784663195,1417561698,4136440770,2430122216,775550814,2193862645,2673705150,1775276924,1876241833,3475313331,3366754619,270040487,3902563182,3678124923,3441850377,1851332852,3969562369,2203032232,3868552805,2868897406,566021896,4011190502,3135740889,1248802510,3936291284,699432150,832877231,708780849,3332740144,899835584,1951317047,4236429990,3767586992,866637845,4043610186,1106041591,2144161806,395441711,1984812685,1139781709,3433712980,3835036895,2664543715,1282050075,3240894392,1181045119,2640243204,25965917,4203181171,4211818798,3009879386,2463879762,3910161971,1842759443,2597806476,933301370,1509430414,3943906441,3467192302,3076639029,3776767469,2051518780,2631065433,1441952575,404016761,1942435775,1408749034,1610459739,3745345300,2017778566,3400528769,3110650942,941896748,3265478751,371049330,3168937228,675039627,4279080257,967311729,135050206,3635733660,1683407248,2076935265,3576870512,1215061108,3501741890],y=[1347548327,1400783205,3273267108,2520393566,3409685355,4045380933,2880240216,2471224067,1428173050,4138563181,2441661558,636813900,4233094615,3620022987,2149987652,2411029155,1239331162,1730525723,2554718734,3781033664,46346101,310463728,2743944855,3328955385,3875770207,2501218972,3955191162,3667219033,768917123,3545789473,692707433,1150208456,1786102409,2029293177,1805211710,3710368113,3065962831,401639597,1724457132,3028143674,409198410,2196052529,1620529459,1164071807,3769721975,2226875310,486441376,2499348523,1483753576,428819965,2274680428,3075636216,598438867,3799141122,1474502543,711349675,129166120,53458370,2592523643,2782082824,4063242375,2988687269,3120694122,1559041666,730517276,2460449204,4042459122,2706270690,3446004468,3573941694,533804130,2328143614,2637442643,2695033685,839224033,1973745387,957055980,2856345839,106852767,1371368976,4181598602,1033297158,2933734917,1179510461,3046200461,91341917,1862534868,4284502037,605657339,2547432937,3431546947,2003294622,3182487618,2282195339,954669403,3682191598,1201765386,3917234703,3388507166,0,2198438022,1211247597,2887651696,1315723890,4227665663,1443857720,507358933,657861945,1678381017,560487590,3516619604,975451694,2970356327,261314535,3535072918,2652609425,1333838021,2724322336,1767536459,370938394,182621114,3854606378,1128014560,487725847,185469197,2918353863,3106780840,3356761769,2237133081,1286567175,3152976349,4255350624,2683765030,3160175349,3309594171,878443390,1988838185,3704300486,1756818940,1673061617,3403100636,272786309,1075025698,545572369,2105887268,4174560061,296679730,1841768865,1260232239,4091327024,3960309330,3497509347,1814803222,2578018489,4195456072,575138148,3299409036,446754879,3629546796,4011996048,3347532110,3252238545,4270639778,915985419,3483825537,681933534,651868046,2755636671,3828103837,223377554,2607439820,1649704518,3270937875,3901806776,1580087799,4118987695,3198115200,2087309459,2842678573,3016697106,1003007129,2802849917,1860738147,2077965243,164439672,4100872472,32283319,2827177882,1709610350,2125135846,136428751,3874428392,3652904859,3460984630,3572145929,3593056380,2939266226,824852259,818324884,3224740454,930369212,2801566410,2967507152,355706840,1257309336,4148292826,243256656,790073846,2373340630,1296297904,1422699085,3756299780,3818836405,457992840,3099667487,2135319889,77422314,1560382517,1945798516,788204353,1521706781,1385356242,870912086,325965383,2358957921,2050466060,2388260884,2313884476,4006521127,901210569,3990953189,1014646705,1503449823,1062597235,2031621326,3212035895,3931371469,1533017514,350174575,2256028891,2177544179,1052338372,741876788,1606591296,1914052035,213705253,2334669897,1107234197,1899603969,3725069491,2631447780,2422494913,1635502980,1893020342,1950903388,1120974935],w=[2807058932,1699970625,2764249623,1586903591,1808481195,1173430173,1487645946,59984867,4199882800,1844882806,1989249228,1277555970,3623636965,3419915562,1149249077,2744104290,1514790577,459744698,244860394,3235995134,1963115311,4027744588,2544078150,4190530515,1608975247,2627016082,2062270317,1507497298,2200818878,567498868,1764313568,3359936201,2305455554,2037970062,1047239e3,1910319033,1337376481,2904027272,2892417312,984907214,1243112415,830661914,861968209,2135253587,2011214180,2927934315,2686254721,731183368,1750626376,4246310725,1820824798,4172763771,3542330227,48394827,2404901663,2871682645,671593195,3254988725,2073724613,145085239,2280796200,2779915199,1790575107,2187128086,472615631,3029510009,4075877127,3802222185,4107101658,3201631749,1646252340,4270507174,1402811438,1436590835,3778151818,3950355702,3963161475,4020912224,2667994737,273792366,2331590177,104699613,95345982,3175501286,2377486676,1560637892,3564045318,369057872,4213447064,3919042237,1137477952,2658625497,1119727848,2340947849,1530455833,4007360968,172466556,266959938,516552836,0,2256734592,3980931627,1890328081,1917742170,4294704398,945164165,3575528878,958871085,3647212047,2787207260,1423022939,775562294,1739656202,3876557655,2530391278,2443058075,3310321856,547512796,1265195639,437656594,3121275539,719700128,3762502690,387781147,218828297,3350065803,2830708150,2848461854,428169201,122466165,3720081049,1627235199,648017665,4122762354,1002783846,2117360635,695634755,3336358691,4234721005,4049844452,3704280881,2232435299,574624663,287343814,612205898,1039717051,840019705,2708326185,793451934,821288114,1391201670,3822090177,376187827,3113855344,1224348052,1679968233,2361698556,1058709744,752375421,2431590963,1321699145,3519142200,2734591178,188127444,2177869557,3727205754,2384911031,3215212461,2648976442,2450346104,3432737375,1180849278,331544205,3102249176,4150144569,2952102595,2159976285,2474404304,766078933,313773861,2570832044,2108100632,1668212892,3145456443,2013908262,418672217,3070356634,2594734927,1852171925,3867060991,3473416636,3907448597,2614737639,919489135,164948639,2094410160,2997825956,590424639,2486224549,1723872674,3157750862,3399941250,3501252752,3625268135,2555048196,3673637356,1343127501,4130281361,3599595085,2957853679,1297403050,81781910,3051593425,2283490410,532201772,1367295589,3926170974,895287692,1953757831,1093597963,492483431,3528626907,1446242576,1192455638,1636604631,209336225,344873464,1015671571,669961897,3375740769,3857572124,2973530695,3747192018,1933530610,3464042516,935293895,3454686199,2858115069,1863638845,3683022916,4085369519,3292445032,875313188,1080017571,3279033885,621591778,1233856572,2504130317,24197544,3017672716,3835484340,3247465558,2220981195,3060847922,1551124588,1463996600],v=[4104605777,1097159550,396673818,660510266,2875968315,2638606623,4200115116,3808662347,821712160,1986918061,3430322568,38544885,3856137295,718002117,893681702,1654886325,2975484382,3122358053,3926825029,4274053469,796197571,1290801793,1184342925,3556361835,2405426947,2459735317,1836772287,1381620373,3196267988,1948373848,3764988233,3385345166,3263785589,2390325492,1480485785,3111247143,3780097726,2293045232,548169417,3459953789,3746175075,439452389,1362321559,1400849762,1685577905,1806599355,2174754046,137073913,1214797936,1174215055,3731654548,2079897426,1943217067,1258480242,529487843,1437280870,3945269170,3049390895,3313212038,923313619,679998e3,3215307299,57326082,377642221,3474729866,2041877159,133361907,1776460110,3673476453,96392454,878845905,2801699524,777231668,4082475170,2330014213,4142626212,2213296395,1626319424,1906247262,1846563261,562755902,3708173718,1040559837,3871163981,1418573201,3294430577,114585348,1343618912,2566595609,3186202582,1078185097,3651041127,3896688048,2307622919,425408743,3371096953,2081048481,1108339068,2216610296,0,2156299017,736970802,292596766,1517440620,251657213,2235061775,2933202493,758720310,265905162,1554391400,1532285339,908999204,174567692,1474760595,4002861748,2610011675,3234156416,3693126241,2001430874,303699484,2478443234,2687165888,585122620,454499602,151849742,2345119218,3064510765,514443284,4044981591,1963412655,2581445614,2137062819,19308535,1928707164,1715193156,4219352155,1126790795,600235211,3992742070,3841024952,836553431,1669664834,2535604243,3323011204,1243905413,3141400786,4180808110,698445255,2653899549,2989552604,2253581325,3252932727,3004591147,1891211689,2487810577,3915653703,4237083816,4030667424,2100090966,865136418,1229899655,953270745,3399679628,3557504664,4118925222,2061379749,3079546586,2915017791,983426092,2022837584,1607244650,2118541908,2366882550,3635996816,972512814,3283088770,1568718495,3499326569,3576539503,621982671,2895723464,410887952,2623762152,1002142683,645401037,1494807662,2595684844,1335535747,2507040230,4293295786,3167684641,367585007,3885750714,1865862730,2668221674,2960971305,2763173681,1059270954,2777952454,2724642869,1320957812,2194319100,2429595872,2815956275,77089521,3973773121,3444575871,2448830231,1305906550,4021308739,2857194700,2516901860,3518358430,1787304780,740276417,1699839814,1592394909,2352307457,2272556026,188821243,1729977011,3687994002,274084841,3594982253,3613494426,2701949495,4162096729,322734571,2837966542,1640576439,484830689,1202797690,3537852828,4067639125,349075736,3342319475,4157467219,4255800159,1030690015,1155237496,2951971274,1757691577,607398968,2738905026,499347990,3794078908,1011452712,227885567,2818666809,213114376,3034881240,1455525988,3414450555,850817237,1817998408,3092726480],A=[0,235474187,470948374,303765277,941896748,908933415,607530554,708780849,1883793496,2118214995,1817866830,1649639237,1215061108,1181045119,1417561698,1517767529,3767586992,4003061179,4236429990,4069246893,3635733660,3602770327,3299278474,3400528769,2430122216,2664543715,2362090238,2193862645,2835123396,2801107407,3035535058,3135740889,3678124923,3576870512,3341394285,3374361702,3810496343,3977675356,4279080257,4043610186,2876494627,2776292904,3076639029,3110650942,2472011535,2640243204,2403728665,2169303058,1001089995,899835584,666464733,699432150,59727847,226906860,530400753,294930682,1273168787,1172967064,1475418501,1509430414,1942435775,2110667444,1876241833,1641816226,2910219766,2743034109,2976151520,3211623147,2505202138,2606453969,2302690252,2269728455,3711829422,3543599269,3240894392,3475313331,3843699074,3943906441,4178062228,4144047775,1306967366,1139781709,1374988112,1610459739,1975683434,2076935265,1775276924,1742315127,1034867998,866637845,566021896,800440835,92987698,193195065,429456164,395441711,1984812685,2017778566,1784663195,1683407248,1315562145,1080094634,1383856311,1551037884,101039829,135050206,437757123,337553864,1042385657,807962610,573804783,742039012,2531067453,2564033334,2328828971,2227573024,2935566865,2700099354,3001755655,3168937228,3868552805,3902563182,4203181171,4102977912,3736164937,3501741890,3265478751,3433712980,1106041591,1340463100,1576976609,1408749034,2043211483,2009195472,1708848333,1809054150,832877231,1068351396,766945465,599762354,159417987,126454664,361929877,463180190,2709260871,2943682380,3178106961,3009879386,2572697195,2538681184,2236228733,2336434550,3509871135,3745345300,3441850377,3274667266,3910161971,3877198648,4110568485,4211818798,2597806476,2497604743,2261089178,2295101073,2733856160,2902087851,3202437046,2968011453,3936291284,3835036895,4136440770,4169408201,3535486456,3702665459,3467192302,3231722213,2051518780,1951317047,1716890410,1750902305,1113818384,1282050075,1584504582,1350078989,168810852,67556463,371049330,404016761,841739592,1008918595,775550814,540080725,3969562369,3801332234,4035489047,4269907996,3569255213,3669462566,3366754619,3332740144,2631065433,2463879762,2160117071,2395588676,2767645557,2868897406,3102011747,3069049960,202008497,33778362,270040487,504459436,875451293,975658646,675039627,641025152,2084704233,1917518562,1615861247,1851332852,1147550661,1248802510,1484005843,1451044056,933301370,967311729,733156972,632953703,260388950,25965917,328671808,496906059,1206477858,1239443753,1543208500,1441952575,2144161806,1908694277,1675577880,1842759443,3610369226,3644379585,3408119516,3307916247,4011190502,3776767469,4077384432,4245618683,2809771154,2842737049,3144396420,3043140495,2673705150,2438237621,2203032232,2370213795],b=[0,185469197,370938394,487725847,741876788,657861945,975451694,824852259,1483753576,1400783205,1315723890,1164071807,1950903388,2135319889,1649704518,1767536459,2967507152,3152976349,2801566410,2918353863,2631447780,2547432937,2328143614,2177544179,3901806776,3818836405,4270639778,4118987695,3299409036,3483825537,3535072918,3652904859,2077965243,1893020342,1841768865,1724457132,1474502543,1559041666,1107234197,1257309336,598438867,681933534,901210569,1052338372,261314535,77422314,428819965,310463728,3409685355,3224740454,3710368113,3593056380,3875770207,3960309330,4045380933,4195456072,2471224067,2554718734,2237133081,2388260884,3212035895,3028143674,2842678573,2724322336,4138563181,4255350624,3769721975,3955191162,3667219033,3516619604,3431546947,3347532110,2933734917,2782082824,3099667487,3016697106,2196052529,2313884476,2499348523,2683765030,1179510461,1296297904,1347548327,1533017514,1786102409,1635502980,2087309459,2003294622,507358933,355706840,136428751,53458370,839224033,957055980,605657339,790073846,2373340630,2256028891,2607439820,2422494913,2706270690,2856345839,3075636216,3160175349,3573941694,3725069491,3273267108,3356761769,4181598602,4063242375,4011996048,3828103837,1033297158,915985419,730517276,545572369,296679730,446754879,129166120,213705253,1709610350,1860738147,1945798516,2029293177,1239331162,1120974935,1606591296,1422699085,4148292826,4233094615,3781033664,3931371469,3682191598,3497509347,3446004468,3328955385,2939266226,2755636671,3106780840,2988687269,2198438022,2282195339,2501218972,2652609425,1201765386,1286567175,1371368976,1521706781,1805211710,1620529459,2105887268,1988838185,533804130,350174575,164439672,46346101,870912086,954669403,636813900,788204353,2358957921,2274680428,2592523643,2441661558,2695033685,2880240216,3065962831,3182487618,3572145929,3756299780,3270937875,3388507166,4174560061,4091327024,4006521127,3854606378,1014646705,930369212,711349675,560487590,272786309,457992840,106852767,223377554,1678381017,1862534868,1914052035,2031621326,1211247597,1128014560,1580087799,1428173050,32283319,182621114,401639597,486441376,768917123,651868046,1003007129,818324884,1503449823,1385356242,1333838021,1150208456,1973745387,2125135846,1673061617,1756818940,2970356327,3120694122,2802849917,2887651696,2637442643,2520393566,2334669897,2149987652,3917234703,3799141122,4284502037,4100872472,3309594171,3460984630,3545789473,3629546796,2050466060,1899603969,1814803222,1730525723,1443857720,1560382517,1075025698,1260232239,575138148,692707433,878443390,1062597235,243256656,91341917,409198410,325965383,3403100636,3252238545,3704300486,3620022987,3874428392,3990953189,4042459122,4227665663,2460449204,2578018489,2226875310,2411029155,3198115200,3046200461,2827177882,2743944855],x=[0,218828297,437656594,387781147,875313188,958871085,775562294,590424639,1750626376,1699970625,1917742170,2135253587,1551124588,1367295589,1180849278,1265195639,3501252752,3720081049,3399941250,3350065803,3835484340,3919042237,4270507174,4085369519,3102249176,3051593425,2734591178,2952102595,2361698556,2177869557,2530391278,2614737639,3145456443,3060847922,2708326185,2892417312,2404901663,2187128086,2504130317,2555048196,3542330227,3727205754,3375740769,3292445032,3876557655,3926170974,4246310725,4027744588,1808481195,1723872674,1910319033,2094410160,1608975247,1391201670,1173430173,1224348052,59984867,244860394,428169201,344873464,935293895,984907214,766078933,547512796,1844882806,1627235199,2011214180,2062270317,1507497298,1423022939,1137477952,1321699145,95345982,145085239,532201772,313773861,830661914,1015671571,731183368,648017665,3175501286,2957853679,2807058932,2858115069,2305455554,2220981195,2474404304,2658625497,3575528878,3625268135,3473416636,3254988725,3778151818,3963161475,4213447064,4130281361,3599595085,3683022916,3432737375,3247465558,3802222185,4020912224,4172763771,4122762354,3201631749,3017672716,2764249623,2848461854,2331590177,2280796200,2431590963,2648976442,104699613,188127444,472615631,287343814,840019705,1058709744,671593195,621591778,1852171925,1668212892,1953757831,2037970062,1514790577,1463996600,1080017571,1297403050,3673637356,3623636965,3235995134,3454686199,4007360968,3822090177,4107101658,4190530515,2997825956,3215212461,2830708150,2779915199,2256734592,2340947849,2627016082,2443058075,172466556,122466165,273792366,492483431,1047239e3,861968209,612205898,695634755,1646252340,1863638845,2013908262,1963115311,1446242576,1530455833,1277555970,1093597963,1636604631,1820824798,2073724613,1989249228,1436590835,1487645946,1337376481,1119727848,164948639,81781910,331544205,516552836,1039717051,821288114,669961897,719700128,2973530695,3157750862,2871682645,2787207260,2232435299,2283490410,2667994737,2450346104,3647212047,3564045318,3279033885,3464042516,3980931627,3762502690,4150144569,4199882800,3070356634,3121275539,2904027272,2686254721,2200818878,2384911031,2570832044,2486224549,3747192018,3528626907,3310321856,3359936201,3950355702,3867060991,4049844452,4234721005,1739656202,1790575107,2108100632,1890328081,1402811438,1586903591,1233856572,1149249077,266959938,48394827,369057872,418672217,1002783846,919489135,567498868,752375421,209336225,24197544,376187827,459744698,945164165,895287692,574624663,793451934,1679968233,1764313568,2117360635,1933530610,1343127501,1560637892,1243112415,1192455638,3704280881,3519142200,3336358691,3419915562,3907448597,3857572124,4075877127,4294704398,3029510009,3113855344,2927934315,2744104290,2159976285,2377486676,2594734927,2544078150],S=[0,151849742,303699484,454499602,607398968,758720310,908999204,1059270954,1214797936,1097159550,1517440620,1400849762,1817998408,1699839814,2118541908,2001430874,2429595872,2581445614,2194319100,2345119218,3034881240,3186202582,2801699524,2951971274,3635996816,3518358430,3399679628,3283088770,4237083816,4118925222,4002861748,3885750714,1002142683,850817237,698445255,548169417,529487843,377642221,227885567,77089521,1943217067,2061379749,1640576439,1757691577,1474760595,1592394909,1174215055,1290801793,2875968315,2724642869,3111247143,2960971305,2405426947,2253581325,2638606623,2487810577,3808662347,3926825029,4044981591,4162096729,3342319475,3459953789,3576539503,3693126241,1986918061,2137062819,1685577905,1836772287,1381620373,1532285339,1078185097,1229899655,1040559837,923313619,740276417,621982671,439452389,322734571,137073913,19308535,3871163981,4021308739,4104605777,4255800159,3263785589,3414450555,3499326569,3651041127,2933202493,2815956275,3167684641,3049390895,2330014213,2213296395,2566595609,2448830231,1305906550,1155237496,1607244650,1455525988,1776460110,1626319424,2079897426,1928707164,96392454,213114376,396673818,514443284,562755902,679998e3,865136418,983426092,3708173718,3557504664,3474729866,3323011204,4180808110,4030667424,3945269170,3794078908,2507040230,2623762152,2272556026,2390325492,2975484382,3092726480,2738905026,2857194700,3973773121,3856137295,4274053469,4157467219,3371096953,3252932727,3673476453,3556361835,2763173681,2915017791,3064510765,3215307299,2156299017,2307622919,2459735317,2610011675,2081048481,1963412655,1846563261,1729977011,1480485785,1362321559,1243905413,1126790795,878845905,1030690015,645401037,796197571,274084841,425408743,38544885,188821243,3613494426,3731654548,3313212038,3430322568,4082475170,4200115116,3780097726,3896688048,2668221674,2516901860,2366882550,2216610296,3141400786,2989552604,2837966542,2687165888,1202797690,1320957812,1437280870,1554391400,1669664834,1787304780,1906247262,2022837584,265905162,114585348,499347990,349075736,736970802,585122620,972512814,821712160,2595684844,2478443234,2293045232,2174754046,3196267988,3079546586,2895723464,2777952454,3537852828,3687994002,3234156416,3385345166,4142626212,4293295786,3841024952,3992742070,174567692,57326082,410887952,292596766,777231668,660510266,1011452712,893681702,1108339068,1258480242,1343618912,1494807662,1715193156,1865862730,1948373848,2100090966,2701949495,2818666809,3004591147,3122358053,2235061775,2352307457,2535604243,2653899549,3915653703,3764988233,4219352155,4067639125,3444575871,3294430577,3746175075,3594982253,836553431,953270745,600235211,718002117,367585007,484830689,133361907,251657213,2041877159,1891211689,1806599355,1654886325,1568718495,1418573201,1335535747,1184342925];function C(e){const t=[];for(let n=0;n<e.length;n+=4)t.push(e[n]<<24|e[n+1]<<16|e[n+2]<<8|e[n+3]);return t}class E{get key(){return i(this,r,"f").slice()}constructor(e){if(r.set(this,void 0),s.set(this,void 0),a.set(this,void 0),!(this instanceof E))throw Error("AES must be instanitated with `new`");o(this,r,new Uint8Array(e),"f");const t=l[this.key.length];if(null==t)throw new TypeError("invalid key size (must be 16, 24 or 32 bytes)");o(this,a,[],"f"),o(this,s,[],"f");for(let r=0;r<=t;r++)i(this,a,"f").push([0,0,0,0]),i(this,s,"f").push([0,0,0,0]);const n=4*(t+1),d=this.key.length/4,h=C(this.key);let f;for(let r=0;r<d;r++)f=r>>2,i(this,a,"f")[f][r%4]=h[r],i(this,s,"f")[t-f][r%4]=h[r];let p,m=0,g=d;for(;g<n;){if(p=h[d-1],h[0]^=u[p>>16&255]<<24^u[p>>8&255]<<16^u[255&p]<<8^u[p>>24&255]^c[m]<<24,m+=1,8!=d)for(let t=1;t<d;t++)h[t]^=h[t-1];else{for(let e=1;e<d/2;e++)h[e]^=h[e-1];p=h[d/2-1],h[d/2]^=u[255&p]^u[p>>8&255]<<8^u[p>>16&255]<<16^u[p>>24&255]<<24;for(let e=d/2+1;e<d;e++)h[e]^=h[e-1]}let e,r,o=0;for(;o<d&&g<n;)e=g>>2,r=g%4,i(this,a,"f")[e][r]=h[o],i(this,s,"f")[t-e][r]=h[o++],g++}for(let r=1;r<t;r++)for(let e=0;e<4;e++)p=i(this,s,"f")[r][e],i(this,s,"f")[r][e]=A[p>>24&255]^b[p>>16&255]^x[p>>8&255]^S[255&p]}encrypt(e){if(16!=e.length)throw new TypeError("invalid plaintext size (must be 16 bytes)");const t=i(this,a,"f").length-1,n=[0,0,0,0];let r=C(e);for(let l=0;l<4;l++)r[l]^=i(this,a,"f")[0][l];for(let l=1;l<t;l++){for(let e=0;e<4;e++)n[e]=h[r[e]>>24&255]^f[r[(e+1)%4]>>16&255]^p[r[(e+2)%4]>>8&255]^m[255&r[(e+3)%4]]^i(this,a,"f")[l][e];r=n.slice()}const s=new Uint8Array(16);let o=0;for(let l=0;l<4;l++)o=i(this,a,"f")[t][l],s[4*l]=255&(u[r[l]>>24&255]^o>>24),s[4*l+1]=255&(u[r[(l+1)%4]>>16&255]^o>>16),s[4*l+2]=255&(u[r[(l+2)%4]>>8&255]^o>>8),s[4*l+3]=255&(u[255&r[(l+3)%4]]^o);return s}decrypt(e){if(16!=e.length)throw new TypeError("invalid ciphertext size (must be 16 bytes)");const t=i(this,s,"f").length-1,n=[0,0,0,0];let r=C(e);for(let l=0;l<4;l++)r[l]^=i(this,s,"f")[0][l];for(let l=1;l<t;l++){for(let e=0;e<4;e++)n[e]=g[r[e]>>24&255]^y[r[(e+3)%4]>>16&255]^w[r[(e+2)%4]>>8&255]^v[255&r[(e+1)%4]]^i(this,s,"f")[l][e];r=n.slice()}const a=new Uint8Array(16);let o=0;for(let l=0;l<4;l++)o=i(this,s,"f")[t][l],a[4*l]=255&(d[r[l]>>24&255]^o>>24),a[4*l+1]=255&(d[r[(l+3)%4]>>16&255]^o>>16),a[4*l+2]=255&(d[r[(l+2)%4]>>8&255]^o>>8),a[4*l+3]=255&(d[255&r[(l+1)%4]]^o);return a}}r=new WeakMap,s=new WeakMap,a=new WeakMap;class N{constructor(e,t,n){if(n&&!(this instanceof n))throw new Error("".concat(e,' must be instantiated with "new"'));Object.defineProperties(this,{aes:{enumerable:!0,value:new E(t)},name:{enumerable:!0,value:e}})}}var k,T,I=function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"===typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},_=function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"===typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};class R extends N{constructor(e,t){if(super("ECC",e,R),k.set(this,void 0),T.set(this,void 0),t){if(t.length%16)throw new TypeError("invalid iv size (must be 16 bytes)");I(this,k,new Uint8Array(t),"f")}else I(this,k,new Uint8Array(16),"f");I(this,T,this.iv,"f")}get iv(){return new Uint8Array(_(this,k,"f"))}encrypt(e){if(e.length%16)throw new TypeError("invalid plaintext size (must be multiple of 16 bytes)");const t=new Uint8Array(e.length);for(let n=0;n<e.length;n+=16){for(let t=0;t<16;t++)_(this,T,"f")[t]^=e[n+t];I(this,T,this.aes.encrypt(_(this,T,"f")),"f"),t.set(_(this,T,"f"),n)}return t}decrypt(e){if(e.length%16)throw new TypeError("invalid ciphertext size (must be multiple of 16 bytes)");const t=new Uint8Array(e.length);for(let n=0;n<e.length;n+=16){const r=this.aes.decrypt(e.subarray(n,n+16));for(let s=0;s<16;s++)t[n+s]=r[s]^_(this,T,"f")[s],_(this,T,"f")[s]=e[n+s]}return t}}k=new WeakMap,T=new WeakMap;var M,D=function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"===typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};new WeakMap,M=new WeakMap,new WeakSet;var j,O,P,L=function(e,t,n,r,s){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!s)throw new TypeError("Private accessor was defined without a setter");if("function"===typeof t?e!==t||!s:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?s.call(e,n):s?s.value=n:t.set(e,n),n},B=function(e,t,n,r){if("a"===n&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"===typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===n?r:"a"===n?r.call(e):r?r.value:t.get(e)};class F extends N{constructor(e,t){super("CTR",e,F),j.set(this,void 0),O.set(this,void 0),P.set(this,void 0),L(this,P,new Uint8Array(16),"f"),B(this,P,"f").fill(0),L(this,j,B(this,P,"f"),"f"),L(this,O,16,"f"),null==t&&(t=1),"number"===typeof t?this.setCounterValue(t):this.setCounterBytes(t)}get counter(){return new Uint8Array(B(this,P,"f"))}setCounterValue(e){if(!Number.isInteger(e)||e<0||e>Number.MAX_SAFE_INTEGER)throw new TypeError("invalid counter initial integer value");for(let t=15;t>=0;--t)B(this,P,"f")[t]=e%256,e=Math.floor(e/256)}setCounterBytes(e){if(16!==e.length)throw new TypeError("invalid counter initial Uint8Array value length");B(this,P,"f").set(e)}increment(){for(let e=15;e>=0;e--){if(255!==B(this,P,"f")[e]){B(this,P,"f")[e]++;break}B(this,P,"f")[e]=0}}encrypt(e){var t,n;const r=new Uint8Array(e);for(let s=0;s<r.length;s++)16===B(this,O,"f")&&(L(this,j,this.aes.encrypt(B(this,P,"f")),"f"),L(this,O,0,"f"),this.increment()),r[s]^=B(this,j,"f")[(L(this,O,(n=B(this,O,"f"),t=n++,n),"f"),t)];return r}decrypt(e){return this.encrypt(e)}}j=new WeakMap,O=new WeakMap,P=new WeakMap;function U(e){if(e.length<16)throw new TypeError("PKCS#7 invalid length");const t=e[e.length-1];if(t>16)throw new TypeError("PKCS#7 padding byte out of range");const n=e.length-t;for(let r=0;r<t;r++)if(e[n+r]!==t)throw new TypeError("PKCS#7 invalid padding byte");return new Uint8Array(e.subarray(0,n))}new WeakMap,new WeakMap,new WeakMap},8051(e,t,n){"use strict";n.d(t,{r:()=>r});const r="6.15.0"},9873(e,t,n){"use strict";n.d(t,{y:()=>B});var r=n(9790),s=n(6562),a=n(5977),i=n(2194),o=n(1009),l=n(2731),c=n(2551);class u extends i.Ue{constructor(e){super("address","address",e,!1)}defaultValue(){return"0x0000000000000000000000000000000000000000"}encode(e,t){let n=c.V.dereference(t,"string");try{n=(0,o.b)(n)}catch(r){return this._throwError(r.message,t)}return e.writeValue(n)}decode(e){return(0,o.b)((0,l.up)(e.readValue(),20))}}var d=n(4705),h=n(3451);class f extends i.Ue{constructor(e){super(e.name,e.type,"_",e.dynamic),(0,d.A)(this,"coder",void 0),this.coder=e}defaultValue(){return this.coder.defaultValue()}encode(e,t){return this.coder.encode(e,t)}decode(e){return this.coder.decode(e)}}function p(e,t,n){let r=[];if(Array.isArray(n))r=n;else if(n&&"object"===typeof n){let e={};r=t.map(t=>{const r=t.localName;return(0,a.vA)(r,"cannot encode object for signature with missing names","INVALID_ARGUMENT",{argument:"values",info:{coder:t},value:n}),(0,a.vA)(!e[r],"cannot encode object for signature with duplicate names","INVALID_ARGUMENT",{argument:"values",info:{coder:t},value:n}),e[r]=!0,n[r]})}else(0,a.MR)(!1,"invalid tuple value","tuple",n);(0,a.MR)(t.length===r.length,"types/value length mismatch","tuple",n);let s=new i.AU,o=new i.AU,l=[];t.forEach((e,t)=>{let n=r[t];if(e.dynamic){let t=o.length;e.encode(o,n);let r=s.writeUpdatableValue();l.push(e=>{r(e+t)})}else e.encode(s,n)}),l.forEach(e=>{e(s.length)});let c=e.appendWriter(s);return c+=e.appendWriter(o),c}function m(e,t){let n=[],r=[],s=e.subReader(0);return t.forEach(t=>{let i=null;if(t.dynamic){let n=e.readIndex(),r=s.subReader(n);try{i=t.decode(r)}catch(o){if((0,a.bJ)(o,"BUFFER_OVERRUN"))throw o;i=o,i.baseType=t.name,i.name=t.localName,i.type=t.type}}else try{i=t.decode(e)}catch(o){if((0,a.bJ)(o,"BUFFER_OVERRUN"))throw o;i=o,i.baseType=t.name,i.name=t.localName,i.type=t.type}if(void 0==i)throw new Error("investigate");n.push(i),r.push(t.localName||null)}),i.Q7.fromItems(n,r)}class g extends i.Ue{constructor(e,t,n){super("array",e.type+"["+(t>=0?t:"")+"]",n,-1===t||e.dynamic),(0,d.A)(this,"coder",void 0),(0,d.A)(this,"length",void 0),(0,h.n)(this,{coder:e,length:t})}defaultValue(){const e=this.coder.defaultValue(),t=[];for(let n=0;n<this.length;n++)t.push(e);return t}encode(e,t){const n=c.V.dereference(t,"array");Array.isArray(n)||this._throwError("expected array value",n);let r=this.length;-1===r&&(r=n.length,e.writeValue(n.length)),(0,a.dd)(n.length,r,"coder array"+(this.localName?" "+this.localName:""));let s=[];for(let a=0;a<n.length;a++)s.push(this.coder);return p(e,s,n)}decode(e){let t=this.length;-1===t&&(t=e.readIndex(),(0,a.vA)(t*i.Yx<=e.dataLength,"insufficient data length","BUFFER_OVERRUN",{buffer:e.bytes,offset:t*i.Yx,length:e.dataLength}));let n=[];for(let r=0;r<t;r++)n.push(new f(this.coder));return m(e,n)}}class y extends i.Ue{constructor(e){super("bool","bool",e,!1)}defaultValue(){return!1}encode(e,t){const n=c.V.dereference(t,"bool");return e.writeValue(n?1:0)}decode(e){return!!e.readValue()}}var w=n(686);class v extends i.Ue{constructor(e,t){super(e,e,t,!0)}defaultValue(){return"0x"}encode(e,t){t=(0,w.Lm)(t);let n=e.writeValue(t.length);return n+=e.writeBytes(t),n}decode(e){return e.readBytes(e.readIndex(),!0)}}class A extends v{constructor(e){super("bytes",e)}decode(e){return(0,w.c$)(super.decode(e))}}class b extends i.Ue{constructor(e,t){let n="bytes"+String(e);super(n,n,t,!1),(0,d.A)(this,"size",void 0),(0,h.n)(this,{size:e},{size:"number"})}defaultValue(){return"0x0000000000000000000000000000000000000000000000000000000000000000".substring(0,2+2*this.size)}encode(e,t){let n=(0,w.Lm)(c.V.dereference(t,this.type));return n.length!==this.size&&this._throwError("incorrect data length",t),e.writeBytes(n)}decode(e){return(0,w.c$)(e.readBytes(this.size))}}const x=new Uint8Array([]);class S extends i.Ue{constructor(e){super("null","",e,!1)}defaultValue(){return null}encode(e,t){return null!=t&&this._throwError("not null",t),e.writeBytes(x)}decode(e){return e.readBytes(0),null}}const C=BigInt(0),E=BigInt(1),N=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");class k extends i.Ue{constructor(e,t,n){const r=(t?"int":"uint")+8*e;super(r,r,n,!1),(0,d.A)(this,"size",void 0),(0,d.A)(this,"signed",void 0),(0,h.n)(this,{size:e,signed:t},{size:"number",signed:"boolean"})}defaultValue(){return 0}encode(e,t){let n=(0,l.Ab)(c.V.dereference(t,this.type)),r=(0,l.dK)(N,8*i.Yx);if(this.signed){let e=(0,l.dK)(r,8*this.size-1);(n>e||n<-(e+E))&&this._throwError("value out-of-bounds",t),n=(0,l.JJ)(n,8*i.Yx)}else(n<C||n>(0,l.dK)(r,8*this.size))&&this._throwError("value out-of-bounds",t);return e.writeValue(n)}decode(e){let t=(0,l.dK)(e.readValue(),8*this.size);return this.signed&&(t=(0,l.ST)(t,8*this.size)),t}}var T=n(85);class I extends v{constructor(e){super("string",e)}defaultValue(){return""}encode(e,t){return super.encode(e,(0,T.YW)(c.V.dereference(t,"string")))}decode(e){return(0,T._v)(super.decode(e))}}class _ extends i.Ue{constructor(e,t){let n=!1;const r=[];e.forEach(e=>{e.dynamic&&(n=!0),r.push(e.type)});super("tuple","tuple("+r.join(",")+")",t,n),(0,d.A)(this,"coders",void 0),(0,h.n)(this,{coders:Object.freeze(e.slice())})}defaultValue(){const e=[];this.coders.forEach(t=>{e.push(t.defaultValue())});const t=this.coders.reduce((e,t)=>{const n=t.localName;return n&&(e[n]||(e[n]=0),e[n]++),e},{});return this.coders.forEach((n,r)=>{let s=n.localName;s&&1===t[s]&&("length"===s&&(s="_length"),null==e[s]&&(e[s]=e[r]))}),Object.freeze(e)}encode(e,t){const n=c.V.dereference(t,"tuple");return p(e,this.coders,n)}decode(e){return m(e,this.coders)}}var R=n(7758);const M=new Map;M.set(0,"GENERIC_PANIC"),M.set(1,"ASSERT_FALSE"),M.set(17,"OVERFLOW"),M.set(18,"DIVIDE_BY_ZERO"),M.set(33,"ENUM_RANGE_ERROR"),M.set(34,"BAD_STORAGE_DATA"),M.set(49,"STACK_UNDERFLOW"),M.set(50,"ARRAY_RANGE_ERROR"),M.set(65,"OUT_OF_MEMORY"),M.set(81,"UNINITIALIZED_FUNCTION_CALL");const D=new RegExp(/^bytes([0-9]*)$/),j=new RegExp(/^(u?int)([0-9]*)$/);let O=null,P=1024;var L=new WeakSet;class B{constructor(){(0,r.A)(this,L)}getDefaultValue(e){const t=e.map(e=>(0,s.A)(L,this,F).call(this,R.aX.from(e)));return new _(t,"_").defaultValue()}encode(e,t){(0,a.dd)(t.length,e.length,"types/values length mismatch");const n=e.map(e=>(0,s.A)(L,this,F).call(this,R.aX.from(e))),r=new _(n,"_"),o=new i.AU;return r.encode(o,t),o.data}decode(e,t,n){const r=e.map(e=>(0,s.A)(L,this,F).call(this,R.aX.from(e)));return new _(r,"_").decode(new i.mP(t,n,P))}static _setDefaultMaxInflation(e){(0,a.MR)("number"===typeof e&&Number.isInteger(e),"invalid defaultMaxInflation factor","value",e),P=e}static defaultAbiCoder(){return null==O&&(O=new B),O}static getBuiltinCallException(e,t,n){return function(e,t,n,r){let s="missing revert data",i=null,l=null;if(n){s="execution reverted";const e=(0,w.q5)(n);if(n=(0,w.c$)(n),0===e.length)s+=" (no data present; likely require(false) occurred",i="require(false)";else if(e.length%32!==4)s+=" (could not decode reason; invalid data length)";else if("0x08c379a0"===(0,w.c$)(e.slice(0,4)))try{i=r.decode(["string"],e.slice(4))[0],l={signature:"Error(string)",name:"Error",args:[i]},s+=": ".concat(JSON.stringify(i))}catch(u){s+=" (could not decode reason; invalid string data)"}else if("0x4e487b71"===(0,w.c$)(e.slice(0,4)))try{const t=Number(r.decode(["uint256"],e.slice(4))[0]);l={signature:"Panic(uint256)",name:"Panic",args:[t]},i="Panic due to ".concat(M.get(t)||"UNKNOWN","(").concat(t,")"),s+=": ".concat(i)}catch(u){s+=" (could not decode panic code)"}else s+=" (unknown custom error)"}const c={to:t.to?(0,o.b)(t.to):null,data:t.data||"0x"};return t.from&&(c.from=(0,o.b)(t.from)),(0,a.xz)(s,"CALL_EXCEPTION",{action:e,data:n,reason:i,transaction:c,invocation:null,revert:l})}(e,t,n,B.defaultAbiCoder())}}function F(e){if(e.isArray())return new g((0,s.A)(L,this,F).call(this,e.arrayChildren),e.arrayLength,e.name);if(e.isTuple())return new _(e.components.map(e=>(0,s.A)(L,this,F).call(this,e)),e.name);switch(e.baseType){case"address":return new u(e.name);case"bool":return new y(e.name);case"string":return new I(e.name);case"bytes":return new A(e.name);case"":return new S(e.name)}let t=e.type.match(j);if(t){let n=parseInt(t[2]||"256");return(0,a.MR)(0!==n&&n<=256&&n%8===0,"invalid "+t[1]+" bit length","param",e),new k(n/8,"int"===t[1],e.name)}if(t=e.type.match(D),t){let n=parseInt(t[1]);return(0,a.MR)(0!==n&&n<=32,"invalid bytes length","param",e),new b(n,e.name)}(0,a.MR)(!1,"invalid type","type",e.type)}},2194(e,t,n){"use strict";n.d(t,{$v:()=>C,AU:()=>_,Q7:()=>S,Ue:()=>N,Yx:()=>f,mP:()=>B});var r=n(9790),s=n(6562),a=n(4705),i=n(5149),o=n(8458),l=n(2177),c=n(686),u=n(5977),d=n(2731),h=n(3451);const f=32,p=new Uint8Array(f),m=["then"],g={},y=new WeakMap;function w(e){return y.get(e)}function v(e,t){y.set(e,t)}function A(e,t){const n=new Error("deferred error during ABI decoding triggered accessing ".concat(e));throw n.error=t,n}function b(e,t,n){return e.indexOf(null)>=0?t.map((e,t)=>e instanceof S?b(w(e),e,n):e):e.reduce((e,r,s)=>{let a=t.getValue(r);return r in e||(n&&a instanceof S&&(a=b(w(a),a,n)),e[r]=a),e},{})}var x=new WeakMap;class S extends Array{constructor(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];const r=t[0];let s=t[1],a=(t[2]||[]).slice(),c=!0;r!==g&&(s=t,a=[],c=!1),super(s.length),(0,i.A)(this,x,void 0),s.forEach((e,t)=>{this[t]=e});const u=a.reduce((e,t)=>("string"===typeof t&&e.set(t,(e.get(t)||0)+1),e),new Map);if(v(this,Object.freeze(s.map((e,t)=>{const n=a[t];return null!=n&&1===u.get(n)?n:null}))),(0,l.A)(x,this,[]),null==(0,o.A)(x,this)&&(0,o.A)(x,this),!c)return;Object.freeze(this);const h=new Proxy(this,{get:(e,t,n)=>{if("string"===typeof t){if(t.match(/^[0-9]+$/)){const n=(0,d.WZ)(t,"%index");if(n<0||n>=this.length)throw new RangeError("out of result range");const r=e[n];return r instanceof Error&&A("index ".concat(n),r),r}if(m.indexOf(t)>=0)return Reflect.get(e,t,n);const r=e[t];if(r instanceof Function)return function(){for(var t=arguments.length,s=new Array(t),a=0;a<t;a++)s[a]=arguments[a];return r.apply(this===n?e:this,s)};if(!(t in e))return e.getValue.apply(this===n?e:this,[t])}return Reflect.get(e,t,n)}});return v(h,w(this)),h}toArray(e){const t=[];return this.forEach((n,r)=>{n instanceof Error&&A("index ".concat(r),n),e&&n instanceof S&&(n=n.toArray(e)),t.push(n)}),t}toObject(e){const t=w(this);return t.reduce((n,r,s)=>((0,u.vA)(null!=r,"value at index ".concat(s," unnamed"),"UNSUPPORTED_OPERATION",{operation:"toObject()"}),b(t,this,e)),{})}slice(e,t){null==e&&(e=0),e<0&&(e+=this.length)<0&&(e=0),null==t&&(t=this.length),t<0&&(t+=this.length)<0&&(t=0),t>this.length&&(t=this.length);const n=w(this),r=[],s=[];for(let a=e;a<t;a++)r.push(this[a]),s.push(n[a]);return new S(g,r,s)}filter(e,t){const n=w(this),r=[],s=[];for(let a=0;a<this.length;a++){const i=this[a];i instanceof Error&&A("index ".concat(a),i),e.call(t,i,a,this)&&(r.push(i),s.push(n[a]))}return new S(g,r,s)}map(e,t){const n=[];for(let r=0;r<this.length;r++){const s=this[r];s instanceof Error&&A("index ".concat(r),s),n.push(e.call(t,s,r,this))}return n}getValue(e){const t=w(this).indexOf(e);if(-1===t)return;const n=this[t];return n instanceof Error&&A("property ".concat(JSON.stringify(e)),n.error),n}static fromItems(e,t){return new S(g,e,t)}}function C(e){const t=[],n=function(e,r){if(Array.isArray(r))for(let a in r){const i=e.slice();i.push(a);try{n(i,r[a])}catch(s){t.push({path:i,error:s})}}};return n([],e),t}function E(e){let t=(0,d.c4)(e);return(0,u.vA)(t.length<=f,"value out-of-bounds","BUFFER_OVERRUN",{buffer:t,length:f,offset:t.length}),t.length!==f&&(t=(0,c.Lm)((0,c.xW)([p.slice(t.length%f),t]))),t}class N{constructor(e,t,n,r){(0,a.A)(this,"name",void 0),(0,a.A)(this,"type",void 0),(0,a.A)(this,"localName",void 0),(0,a.A)(this,"dynamic",void 0),(0,h.n)(this,{name:e,type:t,localName:n,dynamic:r},{name:"string",type:"string",localName:"string",dynamic:"boolean"})}_throwError(e,t){(0,u.MR)(!1,e,this.localName,t)}}var k=new WeakMap,T=new WeakMap,I=new WeakSet;class _{constructor(){(0,r.A)(this,I),(0,i.A)(this,k,void 0),(0,i.A)(this,T,void 0),(0,l.A)(k,this,[]),(0,l.A)(T,this,0)}get data(){return(0,c.xW)((0,o.A)(k,this))}get length(){return(0,o.A)(T,this)}appendWriter(e){return(0,s.A)(I,this,R).call(this,(0,c.Lm)(e.data))}writeBytes(e){let t=(0,c.Lm)(e);const n=t.length%f;return n&&(t=(0,c.Lm)((0,c.xW)([t,p.slice(n)]))),(0,s.A)(I,this,R).call(this,t)}writeValue(e){return(0,s.A)(I,this,R).call(this,E(e))}writeUpdatableValue(){const e=(0,o.A)(k,this).length;return(0,o.A)(k,this).push(p),(0,l.A)(T,this,(0,o.A)(T,this)+f),t=>{(0,o.A)(k,this)[e]=E(t)}}}function R(e){return(0,o.A)(k,this).push(e),(0,l.A)(T,this,(0,o.A)(T,this)+e.length),e.length}var M=new WeakMap,D=new WeakMap,j=new WeakMap,O=new WeakMap,P=new WeakMap,L=new WeakSet;class B{constructor(e,t,n){(0,r.A)(this,L),(0,a.A)(this,"allowLoose",void 0),(0,i.A)(this,M,void 0),(0,i.A)(this,D,void 0),(0,i.A)(this,j,void 0),(0,i.A)(this,O,void 0),(0,i.A)(this,P,void 0),(0,h.n)(this,{allowLoose:!!t}),(0,l.A)(M,this,(0,c.Lm)(e)),(0,l.A)(j,this,0),(0,l.A)(O,this,null),(0,l.A)(P,this,null!=n?n:1024),(0,l.A)(D,this,0)}get data(){return(0,c.c$)((0,o.A)(M,this))}get dataLength(){return(0,o.A)(M,this).length}get consumed(){return(0,o.A)(D,this)}get bytes(){return new Uint8Array((0,o.A)(M,this))}subReader(e){const t=new B((0,o.A)(M,this).slice((0,o.A)(D,this)+e),this.allowLoose,(0,o.A)(P,this));return(0,l.A)(O,t,this),t}readBytes(e,t){let n=(0,s.A)(L,this,U).call(this,0,e,!!t);return(0,s.A)(L,this,F).call(this,e),(0,l.A)(D,this,(0,o.A)(D,this)+n.length),n.slice(0,e)}readValue(){return(0,d.Dg)(this.readBytes(f))}readIndex(){return(0,d.Ro)(this.readBytes(f))}}function F(e){var t;if((0,o.A)(O,this))return(0,s.A)(L,t=(0,o.A)(O,this),F).call(t,e);(0,l.A)(j,this,(0,o.A)(j,this)+e),(0,u.vA)((0,o.A)(P,this)<1||(0,o.A)(j,this)<=(0,o.A)(P,this)*this.dataLength,"compressed ABI data exceeds inflation ratio of ".concat((0,o.A)(P,this)," ( see: https://github.com/ethers-io/ethers.js/issues/4537 )"),"BUFFER_OVERRUN",{buffer:(0,c.Lm)((0,o.A)(M,this)),offset:(0,o.A)(D,this),length:e,info:{bytesRead:(0,o.A)(j,this),dataLength:this.dataLength}})}function U(e,t,n){let r=Math.ceil(t/f)*f;return(0,o.A)(D,this)+r>(0,o.A)(M,this).length&&(this.allowLoose&&n&&(0,o.A)(D,this)+t<=(0,o.A)(M,this).length?r=t:(0,u.vA)(!1,"data out-of-bounds","BUFFER_OVERRUN",{buffer:(0,c.Lm)((0,o.A)(M,this)),length:(0,o.A)(M,this).length,offset:(0,o.A)(D,this)+r})),(0,o.A)(M,this).slice((0,o.A)(D,this),(0,o.A)(D,this)+r)}},7758(e,t,n){"use strict";n.d(t,{FK:()=>ne,Pw:()=>oe,Zp:()=>ie,aX:()=>ee,bp:()=>ae,hc:()=>ce,pd:()=>le,sn:()=>ue,u9:()=>re});var r,s=n(4705),a=n(9790),i=n(5149),o=n(6562),l=n(2177),c=n(8458),u=n(5977),d=n(2731),h=n(3451),f=n(254);function p(e){const t=new Set;return e.forEach(e=>t.add(e)),Object.freeze(t)}const m=p("external public payable override".split(" ")),g="constant external internal payable private public pure view override",y=p(g.split(" ")),w="constructor error event fallback function receive struct",v=p(w.split(" ")),A="calldata memory storage payable indexed",b=p(A.split(" ")),x=p([w,A,"tuple returns",g].join(" ").split(" ")),S={"(":"OPEN_PAREN",")":"CLOSE_PAREN","[":"OPEN_BRACKET","]":"CLOSE_BRACKET",",":"COMMA","@":"AT"},C=new RegExp("^(\\s*)"),E=new RegExp("^([0-9]+)"),N=new RegExp("^([a-zA-Z$_][a-zA-Z0-9$_]*)"),k=new RegExp("^([a-zA-Z$_][a-zA-Z0-9$_]*)$"),T=new RegExp("^(address|bool|bytes([0-9]*)|string|u?int([0-9]*))$");var I=new WeakMap,_=new WeakMap,R=new WeakSet;class M{get offset(){return(0,c.A)(I,this)}get length(){return(0,c.A)(_,this).length-(0,c.A)(I,this)}constructor(e){(0,a.A)(this,R),(0,i.A)(this,I,void 0),(0,i.A)(this,_,void 0),(0,l.A)(I,this,0),(0,l.A)(_,this,e.slice())}clone(){return new M((0,c.A)(_,this))}reset(){(0,l.A)(I,this,0)}popKeyword(e){const t=this.peek();if("KEYWORD"!==t.type||!e.has(t.text))throw new Error("expected keyword ".concat(t.text));return this.pop().text}popType(e){if(this.peek().type!==e){const t=this.peek();throw new Error("expected ".concat(e,"; got ").concat(t.type," ").concat(JSON.stringify(t.text)))}return this.pop().text}popParen(){const e=this.peek();if("OPEN_PAREN"!==e.type)throw new Error("bad start");const t=(0,o.A)(R,this,D).call(this,(0,c.A)(I,this)+1,e.match+1);return(0,l.A)(I,this,e.match+1),t}popParams(){const e=this.peek();if("OPEN_PAREN"!==e.type)throw new Error("bad start");const t=[];for(;(0,c.A)(I,this)<e.match-1;){const e=this.peek().linkNext;t.push((0,o.A)(R,this,D).call(this,(0,c.A)(I,this)+1,e)),(0,l.A)(I,this,e)}return(0,l.A)(I,this,e.match+1),t}peek(){if((0,c.A)(I,this)>=(0,c.A)(_,this).length)throw new Error("out-of-bounds");return(0,c.A)(_,this)[(0,c.A)(I,this)]}peekKeyword(e){const t=this.peekType("KEYWORD");return null!=t&&e.has(t)?t:null}peekType(e){if(0===this.length)return null;const t=this.peek();return t.type===e?t.text:null}pop(){var e;const t=this.peek();return(0,l.A)(I,this,(e=(0,c.A)(I,this),e++,e)),t}toString(){const e=[];for(let t=(0,c.A)(I,this);t<(0,c.A)(_,this).length;t++){const n=(0,c.A)(_,this)[t];e.push("".concat(n.type,":").concat(n.text))}return"<TokenString ".concat(e.join(" "),">")}}function D(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return new r((0,c.A)(_,this).slice(e,t).map(t=>Object.freeze(Object.assign({},t,{match:t.match-e,linkBack:t.linkBack-e,linkNext:t.linkNext-e}))))}function j(e){const t=[],n=t=>{const n=a<e.length?JSON.stringify(e[a]):"$EOI";throw new Error("invalid token ".concat(n," at ").concat(a,": ").concat(t))};let r=[],s=[],a=0;for(;a<e.length;){let i=e.substring(a),o=i.match(C);o&&(a+=o[1].length,i=e.substring(a));const l={depth:r.length,linkBack:-1,linkNext:-1,match:-1,type:"",text:"",offset:a,value:-1};t.push(l);let c=S[i[0]]||"";if(c){if(l.type=c,l.text=i[0],a++,"OPEN_PAREN"===c)r.push(t.length-1),s.push(t.length-1);else if("CLOSE_PAREN"==c)0===r.length&&n("no matching open bracket"),l.match=r.pop(),t[l.match].match=t.length-1,l.depth--,l.linkBack=s.pop(),t[l.linkBack].linkNext=t.length-1;else if("COMMA"===c)l.linkBack=s.pop(),t[l.linkBack].linkNext=t.length-1,s.push(t.length-1);else if("OPEN_BRACKET"===c)l.type="BRACKET";else if("CLOSE_BRACKET"===c){let e=t.pop().text;if(t.length>0&&"NUMBER"===t[t.length-1].type){const n=t.pop().text;e=n+e,t[t.length-1].value=(0,d.WZ)(n)}if(0===t.length||"BRACKET"!==t[t.length-1].type)throw new Error("missing opening bracket");t[t.length-1].text+=e}}else if(o=i.match(N),o){if(l.text=o[1],a+=l.text.length,x.has(l.text)){l.type="KEYWORD";continue}if(l.text.match(T)){l.type="TYPE";continue}l.type="ID"}else{if(o=i.match(E),!o)throw new Error("unexpected token ".concat(JSON.stringify(i[0])," at position ").concat(a));l.text=o[1],l.type="NUMBER",a+=l.text.length}}return new M(t.map(e=>Object.freeze(e)))}function O(e,t){let n=[];for(const r in t.keys())e.has(r)&&n.push(r);if(n.length>1)throw new Error("conflicting types: ".concat(n.join(", ")))}function P(e,t){if(t.peekKeyword(v)){const n=t.pop().text;if(n!==e)throw new Error("expected ".concat(e,", got ").concat(n))}return t.popType("ID")}function L(e,t){const n=new Set;for(;;){const r=e.peekType("KEYWORD");if(null==r||t&&!t.has(r))break;if(e.pop(),n.has(r))throw new Error("duplicate keywords: ".concat(JSON.stringify(r)));n.add(r)}return Object.freeze(n)}function B(e){let t=L(e,y);return O(t,p("constant payable nonpayable".split(" "))),O(t,p("pure view payable nonpayable".split(" "))),t.has("view")?"view":t.has("pure")?"pure":t.has("payable")?"payable":t.has("nonpayable")?"nonpayable":t.has("constant")?"view":"nonpayable"}function F(e,t){return e.popParams().map(e=>ee.from(e,t))}function U(e){if(e.peekType("AT")){if(e.pop(),e.peekType("NUMBER"))return(0,d.Ab)(e.pop().text);throw new Error("invalid gas")}return null}function W(e){if(e.length)throw new Error("unexpected tokens at offset ".concat(e.offset,": ").concat(e.toString()))}r=M;const z=new RegExp(/^(.*)\[([0-9]*)\]$/);function H(e){const t=e.match(T);if((0,u.MR)(t,"invalid type","type",e),"uint"===e)return"uint256";if("int"===e)return"int256";if(t[2]){const n=parseInt(t[2]);(0,u.MR)(0!==n&&n<=32,"invalid bytes length","type",e)}else if(t[3]){const n=parseInt(t[3]);(0,u.MR)(0!==n&&n<=256&&n%8===0,"invalid numeric width","type",e)}return e}const V={},G=Symbol.for("_ethers_internal"),J="_ParamTypeInternal",Q="_ErrorInternal",K="_EventInternal",Y="_ConstructorInternal",q="_FallbackInternal",X="_FunctionInternal",Z="_StructInternal";var $=new WeakSet;class ee{constructor(e,t,n,r,i,o,l,c){if((0,a.A)(this,$),(0,s.A)(this,"name",void 0),(0,s.A)(this,"type",void 0),(0,s.A)(this,"baseType",void 0),(0,s.A)(this,"indexed",void 0),(0,s.A)(this,"components",void 0),(0,s.A)(this,"arrayLength",void 0),(0,s.A)(this,"arrayChildren",void 0),(0,u.gk)(e,V,"ParamType"),Object.defineProperty(this,G,{value:J}),o&&(o=Object.freeze(o.slice())),"array"===r){if(null==l||null==c)throw new Error("")}else if(null!=l||null!=c)throw new Error("");if("tuple"===r){if(null==o)throw new Error("")}else if(null!=o)throw new Error("");(0,h.n)(this,{name:t,type:n,baseType:r,indexed:i,components:o,arrayLength:l,arrayChildren:c})}format(e){if(null==e&&(e="sighash"),"json"===e){const t=this.name||"";if(this.isArray()){const e=JSON.parse(this.arrayChildren.format("json"));return e.name=t,e.type+="[".concat(this.arrayLength<0?"":String(this.arrayLength),"]"),JSON.stringify(e)}const n={type:"tuple"===this.baseType?"tuple":this.type,name:t};return"boolean"===typeof this.indexed&&(n.indexed=this.indexed),this.isTuple()&&(n.components=this.components.map(t=>JSON.parse(t.format(e)))),JSON.stringify(n)}let t="";return this.isArray()?(t+=this.arrayChildren.format(e),t+="[".concat(this.arrayLength<0?"":String(this.arrayLength),"]")):this.isTuple()?t+="("+this.components.map(t=>t.format(e)).join("full"===e?", ":",")+")":t+=this.type,"sighash"!==e&&(!0===this.indexed&&(t+=" indexed"),"full"===e&&this.name&&(t+=" "+this.name)),t}isArray(){return"array"===this.baseType}isTuple(){return"tuple"===this.baseType}isIndexable(){return null!=this.indexed}walk(e,t){if(this.isArray()){if(!Array.isArray(e))throw new Error("invalid array value");if(-1!==this.arrayLength&&e.length!==this.arrayLength)throw new Error("array is wrong length");const n=this;return e.map(e=>n.arrayChildren.walk(e,t))}if(this.isTuple()){if(!Array.isArray(e))throw new Error("invalid tuple value");if(e.length!==this.components.length)throw new Error("array is wrong length");const n=this;return e.map((e,r)=>n.components[r].walk(e,t))}return t(this.type,e)}async walkAsync(e,t){const n=[],r=[e];return(0,o.A)($,this,te).call(this,n,e,t,e=>{r[0]=e}),n.length&&await Promise.all(n),r[0]}static from(e,t){if(ee.isParamType(e))return e;if("string"===typeof e)try{return ee.from(j(e),t)}catch(i){(0,u.MR)(!1,"invalid param type","obj",e)}else if(e instanceof M){let n="",r="",s=null;L(e,p(["tuple"])).has("tuple")||e.peekType("OPEN_PAREN")?(r="tuple",s=e.popParams().map(e=>ee.from(e)),n="tuple(".concat(s.map(e=>e.format()).join(","),")")):(n=H(e.popType("TYPE")),r=n);let a=null,i=null;for(;e.length&&e.peekType("BRACKET");){const t=e.pop();a=new ee(V,"",n,r,null,s,i,a),i=t.value,n+=t.text,r="array",s=null}let o=null;if(L(e,b).has("indexed")){if(!t)throw new Error("");o=!0}const l=e.peekType("ID")?e.pop().text:"";if(e.length)throw new Error("leftover tokens");return new ee(V,l,n,r,o,s,i,a)}const n=e.name;(0,u.MR)(!n||"string"===typeof n&&n.match(k),"invalid name","obj.name",n);let r=e.indexed;null!=r&&((0,u.MR)(t,"parameter cannot be indexed","obj.indexed",e.indexed),r=!!r);let s=e.type,a=s.match(z);if(a){const t=parseInt(a[2]||"-1"),i=ee.from({type:a[1],components:e.components});return new ee(V,n||"",s,"array",r,null,t,i)}if("tuple"===s||s.startsWith("tuple(")||s.startsWith("(")){const t=null!=e.components?e.components.map(e=>ee.from(e)):null;return new ee(V,n||"",s,"tuple",r,t,null,null)}return s=H(e.type),new ee(V,n||"",s,s,r,null,null,null)}static isParamType(e){return e&&e[G]===J}}function te(e,t,n,r){if(this.isArray()){if(!Array.isArray(t))throw new Error("invalid array value");if(-1!==this.arrayLength&&t.length!==this.arrayLength)throw new Error("array is wrong length");const s=this.arrayChildren,a=t.slice();return a.forEach((t,r)=>{(0,o.A)($,s,te).call(s,e,t,n,e=>{a[r]=e})}),void r(a)}if(this.isTuple()){const s=this.components;let a;if(Array.isArray(t))a=t.slice();else{if(null==t||"object"!==typeof t)throw new Error("invalid tuple value");a=s.map(e=>{if(!e.name)throw new Error("cannot use object value with unnamed components");if(!(e.name in t))throw new Error("missing value for component ".concat(e.name));return t[e.name]})}if(a.length!==this.components.length)throw new Error("array is wrong length");return a.forEach((t,r)=>{var i;(0,o.A)($,i=s[r],te).call(i,e,t,n,e=>{a[r]=e})}),void r(a)}const s=n(this.type,t);s.then?e.push(async function(){r(await s)}()):r(s)}class ne{constructor(e,t,n){(0,s.A)(this,"type",void 0),(0,s.A)(this,"inputs",void 0),(0,u.gk)(e,V,"Fragment"),n=Object.freeze(n.slice()),(0,h.n)(this,{type:t,inputs:n})}static from(e){if("string"===typeof e){try{ne.from(JSON.parse(e))}catch(t){}return ne.from(j(e))}if(e instanceof M){switch(e.peekKeyword(v)){case"constructor":return oe.from(e);case"error":return ae.from(e);case"event":return ie.from(e);case"fallback":case"receive":return le.from(e);case"function":return ce.from(e);case"struct":return ue.from(e)}}else if("object"===typeof e){switch(e.type){case"constructor":return oe.from(e);case"error":return ae.from(e);case"event":return ie.from(e);case"fallback":case"receive":return le.from(e);case"function":return ce.from(e);case"struct":return ue.from(e)}(0,u.vA)(!1,"unsupported type: ".concat(e.type),"UNSUPPORTED_OPERATION",{operation:"Fragment.from"})}(0,u.MR)(!1,"unsupported frgament object","obj",e)}static isConstructor(e){return oe.isFragment(e)}static isError(e){return ae.isFragment(e)}static isEvent(e){return ie.isFragment(e)}static isFunction(e){return ce.isFragment(e)}static isStruct(e){return ue.isFragment(e)}}class re extends ne{constructor(e,t,n,r){super(e,t,r),(0,s.A)(this,"name",void 0),(0,u.MR)("string"===typeof n&&n.match(k),"invalid identifier","name",n),r=Object.freeze(r.slice()),(0,h.n)(this,{name:n})}}function se(e,t){return"("+t.map(t=>t.format(e)).join("full"===e?", ":",")+")"}class ae extends re{constructor(e,t,n){super(e,"error",t,n),Object.defineProperty(this,G,{value:Q})}get selector(){return(0,f.id)(this.format("sighash")).substring(0,10)}format(e){if(null==e&&(e="sighash"),"json"===e)return JSON.stringify({type:"error",name:this.name,inputs:this.inputs.map(t=>JSON.parse(t.format(e)))});const t=[];return"sighash"!==e&&t.push("error"),t.push(this.name+se(e,this.inputs)),t.join(" ")}static from(e){if(ae.isFragment(e))return e;if("string"===typeof e)return ae.from(j(e));if(e instanceof M){const t=P("error",e),n=F(e);return W(e),new ae(V,t,n)}return new ae(V,e.name,e.inputs?e.inputs.map(ee.from):[])}static isFragment(e){return e&&e[G]===Q}}class ie extends re{constructor(e,t,n,r){super(e,"event",t,n),(0,s.A)(this,"anonymous",void 0),Object.defineProperty(this,G,{value:K}),(0,h.n)(this,{anonymous:r})}get topicHash(){return(0,f.id)(this.format("sighash"))}format(e){if(null==e&&(e="sighash"),"json"===e)return JSON.stringify({type:"event",anonymous:this.anonymous,name:this.name,inputs:this.inputs.map(t=>JSON.parse(t.format(e)))});const t=[];return"sighash"!==e&&t.push("event"),t.push(this.name+se(e,this.inputs)),"sighash"!==e&&this.anonymous&&t.push("anonymous"),t.join(" ")}static getTopicHash(e,t){t=(t||[]).map(e=>ee.from(e));return new ie(V,e,t,!1).topicHash}static from(e){if(ie.isFragment(e))return e;if("string"===typeof e)try{return ie.from(j(e))}catch(t){(0,u.MR)(!1,"invalid event fragment","obj",e)}else if(e instanceof M){const t=P("event",e),n=F(e,!0),r=!!L(e,p(["anonymous"])).has("anonymous");return W(e),new ie(V,t,n,r)}return new ie(V,e.name,e.inputs?e.inputs.map(e=>ee.from(e,!0)):[],!!e.anonymous)}static isFragment(e){return e&&e[G]===K}}class oe extends ne{constructor(e,t,n,r,a){super(e,t,n),(0,s.A)(this,"payable",void 0),(0,s.A)(this,"gas",void 0),Object.defineProperty(this,G,{value:Y}),(0,h.n)(this,{payable:r,gas:a})}format(e){if((0,u.vA)(null!=e&&"sighash"!==e,"cannot format a constructor for sighash","UNSUPPORTED_OPERATION",{operation:"format(sighash)"}),"json"===e)return JSON.stringify({type:"constructor",stateMutability:this.payable?"payable":"undefined",payable:this.payable,gas:null!=this.gas?this.gas:void 0,inputs:this.inputs.map(t=>JSON.parse(t.format(e)))});const t=["constructor".concat(se(e,this.inputs))];return this.payable&&t.push("payable"),null!=this.gas&&t.push("@".concat(this.gas.toString())),t.join(" ")}static from(e){if(oe.isFragment(e))return e;if("string"===typeof e)try{return oe.from(j(e))}catch(t){(0,u.MR)(!1,"invalid constuctor fragment","obj",e)}else if(e instanceof M){L(e,p(["constructor"]));const t=F(e),n=!!L(e,m).has("payable"),r=U(e);return W(e),new oe(V,"constructor",t,n,r)}return new oe(V,"constructor",e.inputs?e.inputs.map(ee.from):[],!!e.payable,null!=e.gas?e.gas:null)}static isFragment(e){return e&&e[G]===Y}}class le extends ne{constructor(e,t,n){super(e,"fallback",t),(0,s.A)(this,"payable",void 0),Object.defineProperty(this,G,{value:q}),(0,h.n)(this,{payable:n})}format(e){const t=0===this.inputs.length?"receive":"fallback";if("json"===e){const e=this.payable?"payable":"nonpayable";return JSON.stringify({type:t,stateMutability:e})}return"".concat(t,"()").concat(this.payable?" payable":"")}static from(e){if(le.isFragment(e))return e;if("string"===typeof e)try{return le.from(j(e))}catch(t){(0,u.MR)(!1,"invalid fallback fragment","obj",e)}else if(e instanceof M){const t=e.toString(),n=e.peekKeyword(p(["fallback","receive"]));(0,u.MR)(n,"type must be fallback or receive","obj",t);if("receive"===e.popKeyword(p(["fallback","receive"]))){const t=F(e);return(0,u.MR)(0===t.length,"receive cannot have arguments","obj.inputs",t),L(e,p(["payable"])),W(e),new le(V,[],!0)}let r=F(e);r.length?(0,u.MR)(1===r.length&&"bytes"===r[0].type,"invalid fallback inputs","obj.inputs",r.map(e=>e.format("minimal")).join(", ")):r=[ee.from("bytes")];const s=B(e);if((0,u.MR)("nonpayable"===s||"payable"===s,"fallback cannot be constants","obj.stateMutability",s),L(e,p(["returns"])).has("returns")){const t=F(e);(0,u.MR)(1===t.length&&"bytes"===t[0].type,"invalid fallback outputs","obj.outputs",t.map(e=>e.format("minimal")).join(", "))}return W(e),new le(V,r,"payable"===s)}if("receive"===e.type)return new le(V,[],!0);if("fallback"===e.type){const t=[ee.from("bytes")],n="payable"===e.stateMutability;return new le(V,t,n)}(0,u.MR)(!1,"invalid fallback description","obj",e)}static isFragment(e){return e&&e[G]===q}}class ce extends re{constructor(e,t,n,r,a,i){super(e,"function",t,r),(0,s.A)(this,"constant",void 0),(0,s.A)(this,"outputs",void 0),(0,s.A)(this,"stateMutability",void 0),(0,s.A)(this,"payable",void 0),(0,s.A)(this,"gas",void 0),Object.defineProperty(this,G,{value:X}),a=Object.freeze(a.slice());const o="view"===n||"pure"===n,l="payable"===n;(0,h.n)(this,{constant:o,gas:i,outputs:a,payable:l,stateMutability:n})}get selector(){return(0,f.id)(this.format("sighash")).substring(0,10)}format(e){if(null==e&&(e="sighash"),"json"===e)return JSON.stringify({type:"function",name:this.name,constant:this.constant,stateMutability:"nonpayable"!==this.stateMutability?this.stateMutability:void 0,payable:this.payable,gas:null!=this.gas?this.gas:void 0,inputs:this.inputs.map(t=>JSON.parse(t.format(e))),outputs:this.outputs.map(t=>JSON.parse(t.format(e)))});const t=[];return"sighash"!==e&&t.push("function"),t.push(this.name+se(e,this.inputs)),"sighash"!==e&&("nonpayable"!==this.stateMutability&&t.push(this.stateMutability),this.outputs&&this.outputs.length&&(t.push("returns"),t.push(se(e,this.outputs))),null!=this.gas&&t.push("@".concat(this.gas.toString()))),t.join(" ")}static getSelector(e,t){t=(t||[]).map(e=>ee.from(e));return new ce(V,e,"view",t,[],null).selector}static from(e){if(ce.isFragment(e))return e;if("string"===typeof e)try{return ce.from(j(e))}catch(n){(0,u.MR)(!1,"invalid function fragment","obj",e)}else if(e instanceof M){const t=P("function",e),n=F(e),r=B(e);let s=[];L(e,p(["returns"])).has("returns")&&(s=F(e));const a=U(e);return W(e),new ce(V,t,r,n,s,a)}let t=e.stateMutability;return null==t&&(t="payable","boolean"===typeof e.constant?(t="view",e.constant||(t="payable","boolean"!==typeof e.payable||e.payable||(t="nonpayable"))):"boolean"!==typeof e.payable||e.payable||(t="nonpayable")),new ce(V,e.name,t,e.inputs?e.inputs.map(ee.from):[],e.outputs?e.outputs.map(ee.from):[],null!=e.gas?e.gas:null)}static isFragment(e){return e&&e[G]===X}}class ue extends re{constructor(e,t,n){super(e,"struct",t,n),Object.defineProperty(this,G,{value:Z})}format(){throw new Error("@TODO")}static from(e){if("string"===typeof e)try{return ue.from(j(e))}catch(t){(0,u.MR)(!1,"invalid struct fragment","obj",e)}else if(e instanceof M){const t=P("struct",e),n=F(e);return W(e),new ue(V,t,n)}return new ue(V,e.name,e.inputs?e.inputs.map(ee.from):[])}static isFragment(e){return e&&e[G]===Z}}},6852(e,t,n){"use strict";n.d(t,{FW:()=>v,KA:()=>_,dJ:()=>A,fN:()=>b,wu:()=>x});var r=n(9790),s=n(5149),a=n(6562),i=n(8458),o=n(2177),l=n(4705),c=n(4248),u=n(254),d=n(686),h=n(5977),f=n(2731),p=n(3451),m=n(9873),g=n(2194),y=n(7758),w=n(2551);class v{constructor(e,t,n){(0,l.A)(this,"fragment",void 0),(0,l.A)(this,"name",void 0),(0,l.A)(this,"signature",void 0),(0,l.A)(this,"topic",void 0),(0,l.A)(this,"args",void 0);const r=e.name,s=e.format();(0,p.n)(this,{fragment:e,name:r,signature:s,topic:t,args:n})}}class A{constructor(e,t,n,r){(0,l.A)(this,"fragment",void 0),(0,l.A)(this,"name",void 0),(0,l.A)(this,"args",void 0),(0,l.A)(this,"signature",void 0),(0,l.A)(this,"selector",void 0),(0,l.A)(this,"value",void 0);const s=e.name,a=e.format();(0,p.n)(this,{fragment:e,name:s,args:n,signature:a,selector:t,value:r})}}class b{constructor(e,t,n){(0,l.A)(this,"fragment",void 0),(0,l.A)(this,"name",void 0),(0,l.A)(this,"args",void 0),(0,l.A)(this,"signature",void 0),(0,l.A)(this,"selector",void 0);const r=e.name,s=e.format();(0,p.n)(this,{fragment:e,name:r,args:n,signature:s,selector:t})}}class x{static isIndexed(e){return!(!e||!e._isIndexed)}constructor(e){(0,l.A)(this,"hash",void 0),(0,l.A)(this,"_isIndexed",void 0),(0,p.n)(this,{hash:e,_isIndexed:!0})}}const S={0:"generic panic",1:"assert(false)",17:"arithmetic overflow",18:"division or modulo by zero",33:"enum overflow",34:"invalid encoded storage byte array accessed",49:"out-of-bounds array access; popping on an empty array",50:"out-of-bounds access of an array or bytesN",65:"out of memory",81:"uninitialized function"},C={"0x08c379a0":{signature:"Error(string)",name:"Error",inputs:["string"],reason:e=>"reverted with reason string ".concat(JSON.stringify(e))},"0x4e487b71":{signature:"Panic(uint256)",name:"Panic",inputs:["uint256"],reason:e=>{let t="unknown panic code";return e>=0&&e<=255&&S[e.toString()]&&(t=S[e.toString()]),"reverted with panic code 0x".concat(e.toString(16)," (").concat(t,")")}}};var E=new WeakMap,N=new WeakMap,k=new WeakMap,T=new WeakMap,I=new WeakSet;class _{constructor(e){(0,r.A)(this,I),(0,l.A)(this,"fragments",void 0),(0,l.A)(this,"deploy",void 0),(0,l.A)(this,"fallback",void 0),(0,l.A)(this,"receive",void 0),(0,s.A)(this,E,void 0),(0,s.A)(this,N,void 0),(0,s.A)(this,k,void 0),(0,s.A)(this,T,void 0);let t=[];t="string"===typeof e?JSON.parse(e):e,(0,o.A)(k,this,new Map),(0,o.A)(E,this,new Map),(0,o.A)(N,this,new Map);const n=[];for(const r of t)try{n.push(y.FK.from(r))}catch(u){console.log("[Warning] Invalid Fragment ".concat(JSON.stringify(r),":"),u.message)}(0,p.n)(this,{fragments:Object.freeze(n)});let a=null,c=!1;(0,o.A)(T,this,this.getAbiCoder()),this.fragments.forEach((e,t)=>{let n;switch(e.type){case"constructor":return this.deploy?void console.log("duplicate definition - constructor"):void(0,p.n)(this,{deploy:e});case"fallback":return void(0===e.inputs.length?c=!0:((0,h.MR)(!a||e.payable!==a.payable,"conflicting fallback fragments","fragments[".concat(t,"]"),e),a=e,c=a.payable));case"function":n=(0,i.A)(k,this);break;case"event":n=(0,i.A)(N,this);break;case"error":n=(0,i.A)(E,this);break;default:return}const r=e.format();n.has(r)||n.set(r,e)}),this.deploy||(0,p.n)(this,{deploy:y.Pw.from("constructor()")}),(0,p.n)(this,{fallback:a,receive:c})}format(e){const t=e?"minimal":"full";return this.fragments.map(e=>e.format(t))}formatJson(){const e=this.fragments.map(e=>e.format("json"));return JSON.stringify(e.map(e=>JSON.parse(e)))}getAbiCoder(){return m.y.defaultAbiCoder()}getFunctionName(e){const t=(0,a.A)(I,this,R).call(this,e,null,!1);return(0,h.MR)(t,"no matching function","key",e),t.name}hasFunction(e){return!!(0,a.A)(I,this,R).call(this,e,null,!1)}getFunction(e,t){return(0,a.A)(I,this,R).call(this,e,t||null,!0)}forEachFunction(e){const t=Array.from((0,i.A)(k,this).keys());t.sort((e,t)=>e.localeCompare(t));for(let n=0;n<t.length;n++){const r=t[n];e((0,i.A)(k,this).get(r),n)}}getEventName(e){const t=(0,a.A)(I,this,M).call(this,e,null,!1);return(0,h.MR)(t,"no matching event","key",e),t.name}hasEvent(e){return!!(0,a.A)(I,this,M).call(this,e,null,!1)}getEvent(e,t){return(0,a.A)(I,this,M).call(this,e,t||null,!0)}forEachEvent(e){const t=Array.from((0,i.A)(N,this).keys());t.sort((e,t)=>e.localeCompare(t));for(let n=0;n<t.length;n++){const r=t[n];e((0,i.A)(N,this).get(r),n)}}getError(e,t){if((0,d.Lo)(e)){const t=e.toLowerCase();if(C[t])return y.bp.from(C[t].signature);for(const e of(0,i.A)(E,this).values())if(t===e.selector)return e;return null}if(-1===e.indexOf("(")){const t=[];for(const[n,r]of(0,i.A)(E,this))n.split("(")[0]===e&&t.push(r);if(0===t.length)return"Error"===e?y.bp.from("error Error(string)"):"Panic"===e?y.bp.from("error Panic(uint256)"):null;if(t.length>1){const n=t.map(e=>JSON.stringify(e.format())).join(", ");(0,h.MR)(!1,"ambiguous error description (i.e. ".concat(n,")"),"name",e)}return t[0]}if("Error(string)"===(e=y.bp.from(e).format()))return y.bp.from("error Error(string)");if("Panic(uint256)"===e)return y.bp.from("error Panic(uint256)");const n=(0,i.A)(E,this).get(e);return n||null}forEachError(e){const t=Array.from((0,i.A)(E,this).keys());t.sort((e,t)=>e.localeCompare(t));for(let n=0;n<t.length;n++){const r=t[n];e((0,i.A)(E,this).get(r),n)}}_decodeParams(e,t){return(0,i.A)(T,this).decode(e,t)}_encodeParams(e,t){return(0,i.A)(T,this).encode(e,t)}encodeDeploy(e){return this._encodeParams(this.deploy.inputs,e||[])}decodeErrorResult(e,t){if("string"===typeof e){const t=this.getError(e);(0,h.MR)(t,"unknown error","fragment",e),e=t}return(0,h.MR)((0,d.ZG)(t,0,4)===e.selector,"data signature does not match error ".concat(e.name,"."),"data",t),this._decodeParams(e.inputs,(0,d.ZG)(t,4))}encodeErrorResult(e,t){if("string"===typeof e){const t=this.getError(e);(0,h.MR)(t,"unknown error","fragment",e),e=t}return(0,d.xW)([e.selector,this._encodeParams(e.inputs,t||[])])}decodeFunctionData(e,t){if("string"===typeof e){const t=this.getFunction(e);(0,h.MR)(t,"unknown function","fragment",e),e=t}return(0,h.MR)((0,d.ZG)(t,0,4)===e.selector,"data signature does not match function ".concat(e.name,"."),"data",t),this._decodeParams(e.inputs,(0,d.ZG)(t,4))}encodeFunctionData(e,t){if("string"===typeof e){const t=this.getFunction(e);(0,h.MR)(t,"unknown function","fragment",e),e=t}return(0,d.xW)([e.selector,this._encodeParams(e.inputs,t||[])])}decodeFunctionResult(e,t){if("string"===typeof e){const t=this.getFunction(e);(0,h.MR)(t,"unknown function","fragment",e),e=t}let n="invalid length for result data";const r=(0,d.Lm)(t);if(r.length%32===0)try{return(0,i.A)(T,this).decode(e.outputs,r)}catch(s){n="could not decode result data"}(0,h.vA)(!1,n,"BAD_DATA",{value:(0,d.c$)(r),info:{method:e.name,signature:e.format()}})}makeError(e,t){const n=(0,d.q5)(e,"data"),r=m.y.getBuiltinCallException("call",t,n);if(r.message.startsWith("execution reverted (unknown custom error)")){const e=(0,d.c$)(n.slice(0,4)),t=this.getError(e);if(t)try{const e=(0,i.A)(T,this).decode(t.inputs,n.slice(4));r.revert={name:t.name,signature:t.format(),args:e},r.reason=r.revert.signature,r.message="execution reverted: ".concat(r.reason)}catch(a){r.message="execution reverted (coult not decode custom error)"}}const s=this.parseTransaction(t);return s&&(r.invocation={method:s.name,signature:s.signature,args:s.args}),r}encodeFunctionResult(e,t){if("string"===typeof e){const t=this.getFunction(e);(0,h.MR)(t,"unknown function","fragment",e),e=t}return(0,d.c$)((0,i.A)(T,this).encode(e.outputs,t||[]))}encodeFilterTopics(e,t){if("string"===typeof e){const t=this.getEvent(e);(0,h.MR)(t,"unknown event","eventFragment",e),e=t}(0,h.vA)(t.length<=e.inputs.length,"too many arguments for ".concat(e.format()),"UNEXPECTED_ARGUMENT",{count:t.length,expectedCount:e.inputs.length});const n=[];e.anonymous||n.push(e.topicHash);const r=(e,t)=>"string"===e.type?(0,u.id)(t):"bytes"===e.type?(0,c.S)((0,d.c$)(t)):("bool"===e.type&&"boolean"===typeof t?t=t?"0x01":"0x00":e.type.match(/^u?int/)?t=(0,f.up)(t):e.type.match(/^bytes/)?t=(0,d.X_)(t,32):"address"===e.type&&(0,i.A)(T,this).encode(["address"],[t]),(0,d.nx)((0,d.c$)(t),32));for(t.forEach((t,s)=>{const a=e.inputs[s];a.indexed?null==t?n.push(null):"array"===a.baseType||"tuple"===a.baseType?(0,h.MR)(!1,"filtering with tuples or arrays not supported","contract."+a.name,t):Array.isArray(t)?n.push(t.map(e=>r(a,e))):n.push(r(a,t)):(0,h.MR)(null==t,"cannot filter non-indexed parameters; must be null","contract."+a.name,t)});n.length&&null===n[n.length-1];)n.pop();return n}encodeEventLog(e,t){if("string"===typeof e){const t=this.getEvent(e);(0,h.MR)(t,"unknown event","eventFragment",e),e=t}const n=[],r=[],s=[];return e.anonymous||n.push(e.topicHash),(0,h.MR)(t.length===e.inputs.length,"event arguments/values mismatch","values",t),e.inputs.forEach((e,a)=>{const o=t[a];if(e.indexed)if("string"===e.type)n.push((0,u.id)(o));else if("bytes"===e.type)n.push((0,c.S)(o));else{if("tuple"===e.baseType||"array"===e.baseType)throw new Error("not implemented");n.push((0,i.A)(T,this).encode([e.type],[o]))}else r.push(e),s.push(o)}),{data:(0,i.A)(T,this).encode(r,s),topics:n}}decodeEventLog(e,t,n){if("string"===typeof e){const t=this.getEvent(e);(0,h.MR)(t,"unknown event","eventFragment",e),e=t}if(null!=n&&!e.anonymous){const t=e.topicHash;(0,h.MR)((0,d.Lo)(n[0],32)&&n[0].toLowerCase()===t,"fragment/topic mismatch","topics[0]",n[0]),n=n.slice(1)}const r=[],s=[],a=[];e.inputs.forEach((e,t)=>{e.indexed?"string"===e.type||"bytes"===e.type||"tuple"===e.baseType||"array"===e.baseType?(r.push(y.aX.from({type:"bytes32",name:e.name})),a.push(!0)):(r.push(e),a.push(!1)):(s.push(e),a.push(!1))});const o=null!=n?(0,i.A)(T,this).decode(r,(0,d.xW)(n)):null,l=(0,i.A)(T,this).decode(s,t,!0),c=[],u=[];let f=0,p=0;return e.inputs.forEach((e,t)=>{let n=null;if(e.indexed)if(null==o)n=new x(null);else if(a[t])n=new x(o[p++]);else try{n=o[p++]}catch(r){n=r}else try{n=l[f++]}catch(r){n=r}c.push(n),u.push(e.name||null)}),g.Q7.fromItems(c,u)}parseTransaction(e){const t=(0,d.q5)(e.data,"tx.data"),n=(0,f.Ab)(null!=e.value?e.value:0,"tx.value"),r=this.getFunction((0,d.c$)(t.slice(0,4)));if(!r)return null;const s=(0,i.A)(T,this).decode(r.inputs,t.slice(4));return new A(r,r.selector,s,n)}parseCallResult(e){throw new Error("@TODO")}parseLog(e){const t=this.getEvent(e.topics[0]);return!t||t.anonymous?null:new v(t,t.topicHash,this.decodeEventLog(t,e.data,e.topics))}parseError(e){const t=(0,d.c$)(e),n=this.getError((0,d.ZG)(t,0,4));if(!n)return null;const r=(0,i.A)(T,this).decode(n.inputs,(0,d.ZG)(t,4));return new b(n,n.selector,r)}static from(e){return e instanceof _?e:"string"===typeof e?new _(JSON.parse(e)):"function"===typeof e.formatJson?new _(e.formatJson()):"function"===typeof e.format?new _(e.format("json")):new _(e)}}function R(e,t,n){if((0,d.Lo)(e)){const t=e.toLowerCase();for(const e of(0,i.A)(k,this).values())if(t===e.selector)return e;return null}if(-1===e.indexOf("(")){const r=[];for(const[t,n]of(0,i.A)(k,this))t.split("(")[0]===e&&r.push(n);if(t){const e=t.length>0?t[t.length-1]:null;let n=t.length,s=!0;w.V.isTyped(e)&&"overrides"===e.type&&(s=!1,n--);for(let t=r.length-1;t>=0;t--){const e=r[t].inputs.length;e===n||s&&e===n-1||r.splice(t,1)}for(let a=r.length-1;a>=0;a--){const e=r[a].inputs;for(let n=0;n<t.length;n++)if(w.V.isTyped(t[n])){if(n>=e.length){if("overrides"===t[n].type)continue;r.splice(a,1);break}if(t[n].type!==e[n].baseType){r.splice(a,1);break}}}}if(1===r.length&&t&&t.length!==r[0].inputs.length){const e=t[t.length-1];(null==e||Array.isArray(e)||"object"!==typeof e)&&r.splice(0,1)}if(0===r.length)return null;if(r.length>1&&n){const t=r.map(e=>JSON.stringify(e.format())).join(", ");(0,h.MR)(!1,"ambiguous function description (i.e. matches ".concat(t,")"),"key",e)}return r[0]}const r=(0,i.A)(k,this).get(y.hc.from(e).format());return r||null}function M(e,t,n){if((0,d.Lo)(e)){const t=e.toLowerCase();for(const e of(0,i.A)(N,this).values())if(t===e.topicHash)return e;return null}if(-1===e.indexOf("(")){const r=[];for(const[t,n]of(0,i.A)(N,this))t.split("(")[0]===e&&r.push(n);if(t){for(let e=r.length-1;e>=0;e--)r[e].inputs.length<t.length&&r.splice(e,1);for(let e=r.length-1;e>=0;e--){const n=r[e].inputs;for(let s=0;s<t.length;s++)if(w.V.isTyped(t[s])&&t[s].type!==n[s].baseType){r.splice(e,1);break}}}if(0===r.length)return null;if(r.length>1&&n){const t=r.map(e=>JSON.stringify(e.format())).join(", ");(0,h.MR)(!1,"ambiguous event description (i.e. matches ".concat(t,")"),"key",e)}return r[0]}const r=(0,i.A)(N,this).get(y.Zp.from(e).format());return r||null}},2551(e,t,n){"use strict";n.d(t,{V:()=>p});var r=n(5149),s=n(4705),a=n(8458),i=n(2177),o=n(5977),l=n(3451);const c={};function u(e,t){let n=!1;return t<0&&(n=!0,t*=-1),new p(c,"".concat(n?"":"u","int").concat(t),e,{signed:n,width:t})}function d(e,t){return new p(c,"bytes".concat(t||""),e,{size:t})}const h=Symbol.for("_ethers_typed");var f=new WeakMap;class p{constructor(e,t,n,a){(0,s.A)(this,"type",void 0),(0,s.A)(this,"value",void 0),(0,r.A)(this,f,void 0),(0,s.A)(this,"_typedSymbol",void 0),null==a&&(a=null),(0,o.gk)(c,e,"Typed"),(0,l.n)(this,{_typedSymbol:h,type:t,value:n}),(0,i.A)(f,this,a),this.format()}format(){if("array"===this.type)throw new Error("");if("dynamicArray"===this.type)throw new Error("");return"tuple"===this.type?"tuple(".concat(this.value.map(e=>e.format()).join(","),")"):this.type}defaultValue(){return 0}minValue(){return 0}maxValue(){return 0}isBigInt(){return!!this.type.match(/^u?int[0-9]+$/)}isData(){return this.type.startsWith("bytes")}isString(){return"string"===this.type}get tupleName(){if("tuple"!==this.type)throw TypeError("not a tuple");return(0,a.A)(f,this)}get arrayLength(){if("array"!==this.type)throw TypeError("not an array");return!0===(0,a.A)(f,this)?-1:!1===(0,a.A)(f,this)?this.value.length:null}static from(e,t){return new p(c,e,t)}static uint8(e){return u(e,8)}static uint16(e){return u(e,16)}static uint24(e){return u(e,24)}static uint32(e){return u(e,32)}static uint40(e){return u(e,40)}static uint48(e){return u(e,48)}static uint56(e){return u(e,56)}static uint64(e){return u(e,64)}static uint72(e){return u(e,72)}static uint80(e){return u(e,80)}static uint88(e){return u(e,88)}static uint96(e){return u(e,96)}static uint104(e){return u(e,104)}static uint112(e){return u(e,112)}static uint120(e){return u(e,120)}static uint128(e){return u(e,128)}static uint136(e){return u(e,136)}static uint144(e){return u(e,144)}static uint152(e){return u(e,152)}static uint160(e){return u(e,160)}static uint168(e){return u(e,168)}static uint176(e){return u(e,176)}static uint184(e){return u(e,184)}static uint192(e){return u(e,192)}static uint200(e){return u(e,200)}static uint208(e){return u(e,208)}static uint216(e){return u(e,216)}static uint224(e){return u(e,224)}static uint232(e){return u(e,232)}static uint240(e){return u(e,240)}static uint248(e){return u(e,248)}static uint256(e){return u(e,256)}static uint(e){return u(e,256)}static int8(e){return u(e,-8)}static int16(e){return u(e,-16)}static int24(e){return u(e,-24)}static int32(e){return u(e,-32)}static int40(e){return u(e,-40)}static int48(e){return u(e,-48)}static int56(e){return u(e,-56)}static int64(e){return u(e,-64)}static int72(e){return u(e,-72)}static int80(e){return u(e,-80)}static int88(e){return u(e,-88)}static int96(e){return u(e,-96)}static int104(e){return u(e,-104)}static int112(e){return u(e,-112)}static int120(e){return u(e,-120)}static int128(e){return u(e,-128)}static int136(e){return u(e,-136)}static int144(e){return u(e,-144)}static int152(e){return u(e,-152)}static int160(e){return u(e,-160)}static int168(e){return u(e,-168)}static int176(e){return u(e,-176)}static int184(e){return u(e,-184)}static int192(e){return u(e,-192)}static int200(e){return u(e,-200)}static int208(e){return u(e,-208)}static int216(e){return u(e,-216)}static int224(e){return u(e,-224)}static int232(e){return u(e,-232)}static int240(e){return u(e,-240)}static int248(e){return u(e,-248)}static int256(e){return u(e,-256)}static int(e){return u(e,-256)}static bytes1(e){return d(e,1)}static bytes2(e){return d(e,2)}static bytes3(e){return d(e,3)}static bytes4(e){return d(e,4)}static bytes5(e){return d(e,5)}static bytes6(e){return d(e,6)}static bytes7(e){return d(e,7)}static bytes8(e){return d(e,8)}static bytes9(e){return d(e,9)}static bytes10(e){return d(e,10)}static bytes11(e){return d(e,11)}static bytes12(e){return d(e,12)}static bytes13(e){return d(e,13)}static bytes14(e){return d(e,14)}static bytes15(e){return d(e,15)}static bytes16(e){return d(e,16)}static bytes17(e){return d(e,17)}static bytes18(e){return d(e,18)}static bytes19(e){return d(e,19)}static bytes20(e){return d(e,20)}static bytes21(e){return d(e,21)}static bytes22(e){return d(e,22)}static bytes23(e){return d(e,23)}static bytes24(e){return d(e,24)}static bytes25(e){return d(e,25)}static bytes26(e){return d(e,26)}static bytes27(e){return d(e,27)}static bytes28(e){return d(e,28)}static bytes29(e){return d(e,29)}static bytes30(e){return d(e,30)}static bytes31(e){return d(e,31)}static bytes32(e){return d(e,32)}static address(e){return new p(c,"address",e)}static bool(e){return new p(c,"bool",!!e)}static bytes(e){return new p(c,"bytes",e)}static string(e){return new p(c,"string",e)}static array(e,t){throw new Error("not implemented yet")}static tuple(e,t){throw new Error("not implemented yet")}static overrides(e){return new p(c,"overrides",Object.assign({},e))}static isTyped(e){return e&&"object"===typeof e&&"_typedSymbol"in e&&e._typedSymbol===h}static dereference(e,t){if(p.isTyped(e)){if(e.type!==t)throw new Error("invalid type: expecetd ".concat(t,", got ").concat(e.type));return e.value}return e}}},1009(e,t,n){"use strict";n.d(t,{O:()=>f,b:()=>h});var r=n(4248),s=n(686),a=n(5977);const i=BigInt(0),o=BigInt(36);function l(e){const t=(e=e.toLowerCase()).substring(2).split(""),n=new Uint8Array(40);for(let r=0;r<40;r++)n[r]=t[r].charCodeAt(0);const a=(0,s.q5)((0,r.S)(n));for(let r=0;r<40;r+=2)a[r>>1]>>4>=8&&(t[r]=t[r].toUpperCase()),(15&a[r>>1])>=8&&(t[r+1]=t[r+1].toUpperCase());return"0x"+t.join("")}const c={};for(let p=0;p<10;p++)c[String(p)]=String(p);for(let p=0;p<26;p++)c[String.fromCharCode(65+p)]=String(10+p);function u(e){let t=(e=(e=e.toUpperCase()).substring(4)+e.substring(0,2)+"00").split("").map(e=>c[e]).join("");for(;t.length>=15;){let e=t.substring(0,15);t=parseInt(e,10)%97+t.substring(e.length)}let n=String(98-parseInt(t,10)%97);for(;n.length<2;)n="0"+n;return n}const d=function(){const e={};for(let t=0;t<36;t++){e["0123456789abcdefghijklmnopqrstuvwxyz"[t]]=BigInt(t)}return e}();function h(e){if((0,a.MR)("string"===typeof e,"invalid address","address",e),e.match(/^(0x)?[0-9a-fA-F]{40}$/)){e.startsWith("0x")||(e="0x"+e);const t=l(e);return(0,a.MR)(!e.match(/([A-F].*[a-f])|([a-f].*[A-F])/)||t===e,"bad address checksum","address",e),t}if(e.match(/^XE[0-9]{2}[0-9A-Za-z]{30,31}$/)){(0,a.MR)(e.substring(2,4)===u(e),"bad icap checksum","address",e);let t=function(e){e=e.toLowerCase();let t=i;for(let n=0;n<e.length;n++)t=t*o+d[e[n]];return t}(e.substring(4)).toString(16);for(;t.length<40;)t="0"+t;return l("0x"+t)}(0,a.MR)(!1,"invalid address","address",e)}function f(e){let t=BigInt(h(e)).toString(36).toUpperCase();for(;t.length<30;)t="0"+t;return"XE"+u("XE00"+t)+t}},1132(e,t,n){"use strict";n.d(t,{$C:()=>a,PW:()=>i,tG:()=>l});var r=n(5977),s=n(1009);function a(e){return e&&"function"===typeof e.getAddress}function i(e){try{return(0,s.b)(e),!0}catch(t){}return!1}async function o(e,t){const n=await t;return null!=n&&"0x0000000000000000000000000000000000000000"!==n||((0,r.vA)("string"!==typeof e,"unconfigured name","UNCONFIGURED_NAME",{value:e}),(0,r.MR)(!1,"invalid AddressLike value; did not resolve to a value address","target",e)),(0,s.b)(n)}function l(e,t){return"string"===typeof e?e.match(/^0x[0-9a-f]{40}$/i)?(0,s.b)(e):((0,r.vA)(null!=t,"ENS resolution requires a provider","UNSUPPORTED_OPERATION",{operation:"resolveName"}),o(e,t.resolveName(e))):a(e)?o(e,e.getAddress()):e&&"function"===typeof e.then?o(e,e):void(0,r.MR)(!1,"unsupported addressable value","target",e)}},4410(e,t,n){"use strict";n.d(t,{N:()=>u,t:()=>c});var r=n(4248),s=n(686),a=n(5977),i=n(2731),o=n(5889),l=n(1009);function c(e){const t=(0,l.b)(e.from);let n=(0,i.Ab)(e.nonce,"tx.nonce").toString(16);return n="0"===n?"0x":n.length%2?"0x0"+n:"0x"+n,(0,l.b)((0,s.ZG)((0,r.S)((0,o.R)([t,n])),12))}function u(e,t,n){const i=(0,l.b)(e),o=(0,s.q5)(t,"salt"),c=(0,s.q5)(n,"initCodeHash");return(0,a.MR)(32===o.length,"salt must be 32 bytes","salt",t),(0,a.MR)(32===c.length,"initCodeHash must be 32 bytes","initCodeHash",n),(0,l.b)((0,s.ZG)((0,r.S)((0,s.xW)(["0xff",i,o,c])),12))}},8152(e,t,n){"use strict";n.d(t,{j:()=>r});const r="0x0000000000000000000000000000000000000000"},2078(e,t,n){"use strict";n.d(t,{p:()=>r});const r="0x0000000000000000000000000000000000000000000000000000000000000000"},7234(e,t,n){"use strict";n.d(t,{L:()=>r,M:()=>s});const r="\u039e",s="\x19Ethereum Signed Message:\n"},4759(e,t,n){"use strict";n.d(t,{FC:()=>N,NZ:()=>F,Uq:()=>B,yN:()=>k});var r=n(4705),s=n(5149),a=n(8458),i=n(2177),o=n(6852),l=n(2551),c=n(1132),u=n(7750),d=n(686),h=n(5977),f=n(2731),p=n(3451),m=n(3629);const g=BigInt(0);function y(e){return e&&"function"===typeof e.call}function w(e){return e&&"function"===typeof e.estimateGas}function v(e){return e&&"function"===typeof e.resolveName}function A(e){return e&&"function"===typeof e.sendTransaction}function b(e){if(null!=e){if(v(e))return e;if(e.provider)return e.provider}}var x=new WeakMap;class S{constructor(e,t,n){if((0,s.A)(this,x,void 0),(0,r.A)(this,"fragment",void 0),(0,p.n)(this,{fragment:t}),t.inputs.length<n.length)throw new Error("too many arguments");const a=C(e.runner,"resolveName"),o=v(a)?a:null;(0,i.A)(x,this,async function(){const r=await Promise.all(t.inputs.map((e,t)=>null==n[t]?null:e.walkAsync(n[t],(e,t)=>"address"===e?Array.isArray(t)?Promise.all(t.map(e=>(0,c.tG)(e,o))):(0,c.tG)(t,o):t)));return e.interface.encodeFilterTopics(t,r)}())}getTopicFilter(){return(0,a.A)(x,this)}}function C(e,t){return null==e?null:"function"===typeof e[t]?e:e.provider&&"function"===typeof e.provider[t]?e.provider:null}function E(e){return null==e?null:e.provider||null}async function N(e,t){const n=l.V.dereference(e,"overrides");(0,h.MR)("object"===typeof n,"invalid overrides parameter","overrides",e);const r=(0,u.VS)(n);return(0,h.MR)(null==r.to||(t||[]).indexOf("to")>=0,"cannot override to","overrides.to",r.to),(0,h.MR)(null==r.data||(t||[]).indexOf("data")>=0,"cannot override data","overrides.data",r.data),r.from&&(r.from=r.from),r}async function k(e,t,n){const r=C(e,"resolveName"),s=v(r)?r:null;return await Promise.all(t.map((e,t)=>e.walkAsync(n[t],(e,t)=>(t=l.V.dereference(t,e),"address"===e?(0,c.tG)(t,s):t))))}function T(e){const t=async function(t){const n=await N(t,["data"]);n.to=await e.getAddress(),n.from&&(n.from=await(0,c.tG)(n.from,b(e.runner)));const r=e.interface,s=(0,f.Ab)(n.value||g,"overrides.value")===g,a="0x"===(n.data||"0x");!r.fallback||r.fallback.payable||!r.receive||a||s||(0,h.MR)(!1,"cannot send data to receive or send value to non-payable fallback","overrides",t),(0,h.MR)(r.fallback||a,"cannot send data to receive-only contract","overrides.data",n.data);const i=r.receive||r.fallback&&r.fallback.payable;return(0,h.MR)(i||s,"cannot send value to non-payable fallback","overrides.value",n.value),(0,h.MR)(r.fallback||a,"cannot send data to receive-only contract","overrides.data",n.data),n},n=async function(n){const r=e.runner;(0,h.vA)(A(r),"contract runner does not support sending transactions","UNSUPPORTED_OPERATION",{operation:"sendTransaction"});const s=await r.sendTransaction(await t(n)),a=E(e.runner);return new m.Cn(e.interface,a,s)},r=async e=>await n(e);return(0,p.n)(r,{_contract:e,estimateGas:async function(n){const r=C(e.runner,"estimateGas");return(0,h.vA)(w(r),"contract runner does not support gas estimation","UNSUPPORTED_OPERATION",{operation:"estimateGas"}),await r.estimateGas(await t(n))},populateTransaction:t,send:n,staticCall:async function(n){const r=C(e.runner,"call");(0,h.vA)(y(r),"contract runner does not support calling","UNSUPPORTED_OPERATION",{operation:"call"});const s=await t(n);try{return await r.call(s)}catch(a){if((0,h.E)(a)&&a.data)throw e.interface.makeError(a.data,s);throw a}}}),r}const I=Symbol.for("_ethersInternal_contract"),_=new WeakMap;function R(e){return _.get(e[I])}async function M(e,t){let n,r=null;if(Array.isArray(t)){const r=function(t){if((0,d.Lo)(t,32))return t;const n=e.interface.getEvent(t);return(0,h.MR)(n,"unknown fragment","name",t),n.topicHash};n=t.map(e=>null==e?null:Array.isArray(e)?e.map(r):r(e))}else"*"===t?n=[null]:"string"===typeof t?(0,d.Lo)(t,32)?n=[t]:(r=e.interface.getEvent(t),(0,h.MR)(r,"unknown fragment","event",t),n=[r.topicHash]):(s=t)&&"object"===typeof s&&"getTopicFilter"in s&&"function"===typeof s.getTopicFilter&&s.fragment?n=await t.getTopicFilter():"fragment"in t?(r=t.fragment,n=[r.topicHash]):(0,h.MR)(!1,"unknown event name","event",t);var s;n=n.map(e=>{if(null==e)return null;if(Array.isArray(e)){const t=Array.from(new Set(e.map(e=>e.toLowerCase())).values());return 1===t.length?t[0]:(t.sort(),t)}return e.toLowerCase()});return{fragment:r,tag:n.map(e=>null==e?"null":Array.isArray(e)?e.join("|"):e).join("&"),topics:n}}async function D(e,t){const{subs:n}=R(e);return n.get((await M(e,t)).tag)||null}async function j(e,t,n){const r=E(e.runner);(0,h.vA)(r,"contract runner does not support subscribing","UNSUPPORTED_OPERATION",{operation:t});const{fragment:s,tag:a,topics:i}=await M(e,n),{addr:o,subs:l}=R(e);let c=l.get(a);if(!c){const t={address:o||e,topics:i},u=t=>{let r=s;if(null==r)try{r=e.interface.getEvent(t.topics[0])}catch(a){}if(r){const a=r,i=s?e.interface.decodeEventLog(s,t.data,t.topics):[];P(e,n,i,r=>new m.HZ(e,r,n,a,t))}else P(e,n,[],r=>new m._k(e,r,n,t))};let d=[];c={tag:a,listeners:[],start:()=>{d.length||d.push(r.on(t,u))},stop:async()=>{if(0==d.length)return;let e=d;d=[],await Promise.all(e),r.off(t,u)}},l.set(a,c)}return c}let O=Promise.resolve();async function P(e,t,n,r){try{await O}catch(a){}const s=async function(e,t,n,r){await O;const s=await D(e,t);if(!s)return!1;const i=s.listeners.length;return s.listeners=s.listeners.filter(t=>{let{listener:s,once:i}=t;const o=Array.from(n);r&&o.push(r(i?null:s));try{s.call(e,...o)}catch(a){}return!i}),0===s.listeners.length&&(s.stop(),R(e).subs.delete(s.tag)),i>0}(e,t,n,r);return O=s,await s}const L=["then"];class B{constructor(e,t,n,s){(0,r.A)(this,"target",void 0),(0,r.A)(this,"interface",void 0),(0,r.A)(this,"runner",void 0),(0,r.A)(this,"filters",void 0),(0,r.A)(this,I,void 0),(0,r.A)(this,"fallback",void 0),(0,h.MR)("string"===typeof e||(0,c.$C)(e),"invalid value for Contract target","target",e),null==n&&(n=null);const a=o.KA.from(t);let i;(0,p.n)(this,{target:e,runner:n,interface:a}),Object.defineProperty(this,I,{value:{}});let l=null,u=null;if(s){const e=E(n);u=new m.Cn(this.interface,e,s)}let f=new Map;if("string"===typeof e)if((0,d.Lo)(e))l=e,i=Promise.resolve(e);else{const t=C(n,"resolveName");if(!v(t))throw(0,h.xz)("contract runner does not support name resolution","UNSUPPORTED_OPERATION",{operation:"resolveName"});i=t.resolveName(e).then(t=>{if(null==t)throw(0,h.xz)("an ENS name used for a contract target must be correctly configured","UNCONFIGURED_NAME",{value:e});return R(this).addr=t,t})}else i=e.getAddress().then(e=>{if(null==e)throw new Error("TODO");return R(this).addr=e,e});var g,y;g=this,y={addrPromise:i,addr:l,deployTx:u,subs:f},_.set(g[I],y);const w=new Proxy({},{get:(e,t,n)=>{if("symbol"===typeof t||L.indexOf(t)>=0)return Reflect.get(e,t,n);try{return this.getEvent(t)}catch(r){if(!(0,h.bJ)(r,"INVALID_ARGUMENT")||"key"!==r.argument)throw r}},has:(e,t)=>L.indexOf(t)>=0?Reflect.has(e,t):Reflect.has(e,t)||this.interface.hasEvent(String(t))});return(0,p.n)(this,{filters:w}),(0,p.n)(this,{fallback:a.receive||a.fallback?T(this):null}),new Proxy(this,{get:(e,t,n)=>{if("symbol"===typeof t||t in e||L.indexOf(t)>=0)return Reflect.get(e,t,n);try{return e.getFunction(t)}catch(r){if(!(0,h.bJ)(r,"INVALID_ARGUMENT")||"key"!==r.argument)throw r}},has:(e,t)=>"symbol"===typeof t||t in e||L.indexOf(t)>=0?Reflect.has(e,t):e.interface.hasFunction(t)})}connect(e){return new B(this.target,this.interface,e)}attach(e){return new B(e,this.interface,this.runner)}async getAddress(){return await R(this).addrPromise}async getDeployedCode(){const e=E(this.runner);(0,h.vA)(e,"runner does not support .provider","UNSUPPORTED_OPERATION",{operation:"getDeployedCode"});const t=await e.getCode(await this.getAddress());return"0x"===t?null:t}async waitForDeployment(){const e=this.deploymentTransaction();if(e)return await e.wait(),this;if(null!=await this.getDeployedCode())return this;const t=E(this.runner);return(0,h.vA)(null!=t,"contract runner does not support .provider","UNSUPPORTED_OPERATION",{operation:"waitForDeployment"}),new Promise((e,n)=>{const r=async()=>{try{if(null!=await this.getDeployedCode())return e(this);t.once("block",r)}catch(s){n(s)}};r()})}deploymentTransaction(){return R(this).deployTx}getFunction(e){"string"!==typeof e&&(e=e.format());const t=function(e,t){const n=function(){for(var n=arguments.length,r=new Array(n),s=0;s<n;s++)r[s]=arguments[s];const a=e.interface.getFunction(t,r);return(0,h.vA)(a,"no matching fragment","UNSUPPORTED_OPERATION",{operation:"fragment",info:{key:t,args:r}}),a},r=async function(){for(var t=arguments.length,r=new Array(t),s=0;s<t;s++)r[s]=arguments[s];const a=n(...r);let i={};if(a.inputs.length+1===r.length&&(i=await N(r.pop()),i.from&&(i.from=await(0,c.tG)(i.from,b(e.runner)))),a.inputs.length!==r.length)throw new Error("internal error: fragment inputs doesn't match arguments; should not happen");const o=await k(e.runner,a.inputs,r);return Object.assign({},i,await(0,p.k)({to:e.getAddress(),data:e.interface.encodeFunctionData(a,o)}))},s=async function(){const e=await i(...arguments);return 1===e.length?e[0]:e},a=async function(){const t=e.runner;(0,h.vA)(A(t),"contract runner does not support sending transactions","UNSUPPORTED_OPERATION",{operation:"sendTransaction"});const n=await t.sendTransaction(await r(...arguments)),s=E(e.runner);return new m.Cn(e.interface,s,n)},i=async function(){const t=C(e.runner,"call");(0,h.vA)(y(t),"contract runner does not support calling","UNSUPPORTED_OPERATION",{operation:"call"});const s=await r(...arguments);let a="0x";try{a=await t.call(s)}catch(o){if((0,h.E)(o)&&o.data)throw e.interface.makeError(o.data,s);throw o}const i=n(...arguments);return e.interface.decodeFunctionResult(i,a)},o=async function(){return n(...arguments).constant?await s(...arguments):await a(...arguments)};return(0,p.n)(o,{name:e.interface.getFunctionName(t),_contract:e,_key:t,getFragment:n,estimateGas:async function(){const t=C(e.runner,"estimateGas");return(0,h.vA)(w(t),"contract runner does not support gas estimation","UNSUPPORTED_OPERATION",{operation:"estimateGas"}),await t.estimateGas(await r(...arguments))},populateTransaction:r,send:a,staticCall:s,staticCallResult:i}),Object.defineProperty(o,"fragment",{configurable:!1,enumerable:!0,get:()=>{const n=e.interface.getFunction(t);return(0,h.vA)(n,"no matching fragment","UNSUPPORTED_OPERATION",{operation:"fragment",info:{key:t}}),n}}),o}(this,e);return t}getEvent(e){return"string"!==typeof e&&(e=e.format()),function(e,t){const n=function(){for(var n=arguments.length,r=new Array(n),s=0;s<n;s++)r[s]=arguments[s];const a=e.interface.getEvent(t,r);return(0,h.vA)(a,"no matching fragment","UNSUPPORTED_OPERATION",{operation:"fragment",info:{key:t,args:r}}),a},r=function(){for(var t=arguments.length,r=new Array(t),s=0;s<t;s++)r[s]=arguments[s];return new S(e,n(...r),r)};return(0,p.n)(r,{name:e.interface.getEventName(t),_contract:e,_key:t,getFragment:n}),Object.defineProperty(r,"fragment",{configurable:!1,enumerable:!0,get:()=>{const n=e.interface.getEvent(t);return(0,h.vA)(n,"no matching fragment","UNSUPPORTED_OPERATION",{operation:"fragment",info:{key:t}}),n}}),r}(this,e)}async queryTransaction(e){throw new Error("@TODO")}async queryFilter(e,t,n){null==t&&(t=0),null==n&&(n="latest");const{addr:r,addrPromise:s}=R(this),a=r||await s,{fragment:i,topics:o}=await M(this,e),l={address:a,topics:o,fromBlock:t,toBlock:n},c=E(this.runner);return(0,h.vA)(c,"contract runner does not have a provider","UNSUPPORTED_OPERATION",{operation:"queryFilter"}),(await c.getLogs(l)).map(e=>{let t=i;if(null==t)try{t=this.interface.getEvent(e.topics[0])}catch(n){}if(t)try{return new m.vu(e,this.interface,t)}catch(n){return new m.AA(e,n)}return new u.tG(e,c)})}async on(e,t){const n=await j(this,"on",e);return n.listeners.push({listener:t,once:!1}),n.start(),this}async once(e,t){const n=await j(this,"once",e);return n.listeners.push({listener:t,once:!0}),n.start(),this}async emit(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];return await P(this,e,n,null)}async listenerCount(e){if(e){const t=await D(this,e);return t?t.listeners.length:0}const{subs:t}=R(this);let n=0;for(const{listeners:r}of t.values())n+=r.length;return n}async listeners(e){if(e){const t=await D(this,e);return t?t.listeners.map(e=>{let{listener:t}=e;return t}):[]}const{subs:t}=R(this);let n=[];for(const{listeners:r}of t.values())n=n.concat(r.map(e=>{let{listener:t}=e;return t}));return n}async off(e,t){const n=await D(this,e);if(!n)return this;if(t){const e=n.listeners.map(e=>{let{listener:t}=e;return t}).indexOf(t);e>=0&&n.listeners.splice(e,1)}return null!=t&&0!==n.listeners.length||(n.stop(),R(this).subs.delete(n.tag)),this}async removeAllListeners(e){if(e){const t=await D(this,e);if(!t)return this;t.stop(),R(this).subs.delete(t.tag)}else{const{subs:e}=R(this);for(const{tag:t,stop:n}of e.values())n(),e.delete(t)}return this}async addListener(e,t){return await this.on(e,t)}async removeListener(e,t){return await this.off(e,t)}static buildClass(e){return class extends B{constructor(t){super(t,e,arguments.length>1&&void 0!==arguments[1]?arguments[1]:null)}}}static from(e,t,n){null==n&&(n=null);return new this(e,t,n)}}class F extends(function(){return B}()){}},3629(e,t,n){"use strict";n.d(t,{AA:()=>d,Cn:()=>m,Dk:()=>f,HZ:()=>y,_k:()=>g,vu:()=>u});var r=n(5149),s=n(8458),a=n(2177),i=n(4705),o=n(7750),l=n(7867),c=n(3451);class u extends o.tG{constructor(e,t,n){super(e,e.provider),(0,i.A)(this,"interface",void 0),(0,i.A)(this,"fragment",void 0),(0,i.A)(this,"args",void 0);const r=t.decodeEventLog(n,e.data,e.topics);(0,c.n)(this,{args:r,fragment:n,interface:t})}get eventName(){return this.fragment.name}get eventSignature(){return this.fragment.format()}}class d extends o.tG{constructor(e,t){super(e,e.provider),(0,i.A)(this,"error",void 0),(0,c.n)(this,{error:t})}}var h=new WeakMap;class f extends o.z5{constructor(e,t,n){super(n,t),(0,r.A)(this,h,void 0),(0,a.A)(h,this,e)}get logs(){return super.logs.map(e=>{const t=e.topics.length?(0,s.A)(h,this).getEvent(e.topics[0]):null;if(t)try{return new u(e,(0,s.A)(h,this),t)}catch(n){return new d(e,n)}return e})}}var p=new WeakMap;class m extends o.uI{constructor(e,t,n){super(n,t),(0,r.A)(this,p,void 0),(0,a.A)(p,this,e)}async wait(e,t){const n=await super.wait(e,t);return null==n?null:new f((0,s.A)(p,this),this.provider,n)}}class g extends l.z{constructor(e,t,n,r){super(e,t,n),(0,i.A)(this,"log",void 0),(0,c.n)(this,{log:r})}async getBlock(){return await this.log.getBlock()}async getTransaction(){return await this.log.getTransaction()}async getTransactionReceipt(){return await this.log.getTransactionReceipt()}}class y extends g{constructor(e,t,n,r,s){super(e,t,n,new u(s,e.interface,r));const a=e.interface.decodeEventLog(r,this.log.data,this.log.topics);(0,c.n)(this,{args:a,fragment:r})}get eventName(){return this.fragment.name}get eventSignature(){return this.fragment.format()}}},1373(e,t,n){"use strict";n.d(t,{n1:()=>w,Gz:()=>v,T_:()=>A,po:()=>b});var r=n(4432),s=n(6390),a=n(7804),i=n(4814),o=n(4421),l=n(5621);const[c,u]=(()=>o.Ay.split(["0x428a2f98d728ae22","0x7137449123ef65cd","0xb5c0fbcfec4d3b2f","0xe9b5dba58189dbbc","0x3956c25bf348b538","0x59f111f1b605d019","0x923f82a4af194f9b","0xab1c5ed5da6d8118","0xd807aa98a3030242","0x12835b0145706fbe","0x243185be4ee4b28c","0x550c7dc3d5ffb4e2","0x72be5d74f27b896f","0x80deb1fe3b1696b1","0x9bdc06a725c71235","0xc19bf174cf692694","0xe49b69c19ef14ad2","0xefbe4786384f25e3","0x0fc19dc68b8cd5b5","0x240ca1cc77ac9c65","0x2de92c6f592b0275","0x4a7484aa6ea6e483","0x5cb0a9dcbd41fbd4","0x76f988da831153b5","0x983e5152ee66dfab","0xa831c66d2db43210","0xb00327c898fb213f","0xbf597fc7beef0ee4","0xc6e00bf33da88fc2","0xd5a79147930aa725","0x06ca6351e003826f","0x142929670a0e6e70","0x27b70a8546d22ffc","0x2e1b21385c26c926","0x4d2c6dfc5ac42aed","0x53380d139d95b3df","0x650a73548baf63de","0x766a0abb3c77b2a8","0x81c2c92e47edaee6","0x92722c851482353b","0xa2bfe8a14cf10364","0xa81a664bbc423001","0xc24b8b70d0f89791","0xc76c51a30654be30","0xd192e819d6ef5218","0xd69906245565a910","0xf40e35855771202a","0x106aa07032bbd1b8","0x19a4c116b8d2d0c8","0x1e376c085141ab53","0x2748774cdf8eeb99","0x34b0bcb5e19b48a8","0x391c0cb3c5c95a63","0x4ed8aa4ae3418acb","0x5b9cca4f7763e373","0x682e6ff3d6b2b8a3","0x748f82ee5defb2fc","0x78a5636f43172f60","0x84c87814a1f0ab72","0x8cc702081a6439ec","0x90befffa23631e28","0xa4506cebde82bde9","0xbef9a3f7b2c67915","0xc67178f2e372532b","0xca273eceea26619c","0xd186b8c721c0c207","0xeada7dd6cde0eb1e","0xf57d4f7fee6ed178","0x06f067aa72176fba","0x0a637dc5a2c898a6","0x113f9804bef90dae","0x1b710b35131c471b","0x28db77f523047d84","0x32caab7b40c72493","0x3c9ebe0a15c9bebc","0x431d67c49c100d4c","0x4cc5d4becb3e42b6","0x597f299cfc657e2a","0x5fcb6fab3ad6faec","0x6c44198c4a475817"].map(e=>BigInt(e))))(),d=new Uint32Array(80),h=new Uint32Array(80);class f extends i.D{constructor(){super(128,64,16,!1),this.Ah=1779033703,this.Al=-205731576,this.Bh=-1150833019,this.Bl=-2067093701,this.Ch=1013904242,this.Cl=-23791573,this.Dh=-1521486534,this.Dl=1595750129,this.Eh=1359893119,this.El=-1377402159,this.Fh=-1694144372,this.Fl=725511199,this.Gh=528734635,this.Gl=-79577749,this.Hh=1541459225,this.Hl=327033209}get(){const{Ah:e,Al:t,Bh:n,Bl:r,Ch:s,Cl:a,Dh:i,Dl:o,Eh:l,El:c,Fh:u,Fl:d,Gh:h,Gl:f,Hh:p,Hl:m}=this;return[e,t,n,r,s,a,i,o,l,c,u,d,h,f,p,m]}set(e,t,n,r,s,a,i,o,l,c,u,d,h,f,p,m){this.Ah=0|e,this.Al=0|t,this.Bh=0|n,this.Bl=0|r,this.Ch=0|s,this.Cl=0|a,this.Dh=0|i,this.Dl=0|o,this.Eh=0|l,this.El=0|c,this.Fh=0|u,this.Fl=0|d,this.Gh=0|h,this.Gl=0|f,this.Hh=0|p,this.Hl=0|m}process(e,t){for(let o=0;o<16;o++,t+=4)d[o]=e.getUint32(t),h[o]=e.getUint32(t+=4);for(let c=16;c<80;c++){const e=0|d[c-15],t=0|h[c-15],n=o.Ay.rotrSH(e,t,1)^o.Ay.rotrSH(e,t,8)^o.Ay.shrSH(e,t,7),r=o.Ay.rotrSL(e,t,1)^o.Ay.rotrSL(e,t,8)^o.Ay.shrSL(e,t,7),s=0|d[c-2],a=0|h[c-2],i=o.Ay.rotrSH(s,a,19)^o.Ay.rotrBH(s,a,61)^o.Ay.shrSH(s,a,6),l=o.Ay.rotrSL(s,a,19)^o.Ay.rotrBL(s,a,61)^o.Ay.shrSL(s,a,6),u=o.Ay.add4L(r,l,h[c-7],h[c-16]),f=o.Ay.add4H(u,n,i,d[c-7],d[c-16]);d[c]=0|f,h[c]=0|u}let{Ah:n,Al:r,Bh:s,Bl:a,Ch:i,Cl:l,Dh:f,Dl:p,Eh:m,El:g,Fh:y,Fl:w,Gh:v,Gl:A,Hh:b,Hl:x}=this;for(let S=0;S<80;S++){const e=o.Ay.rotrSH(m,g,14)^o.Ay.rotrSH(m,g,18)^o.Ay.rotrBH(m,g,41),t=o.Ay.rotrSL(m,g,14)^o.Ay.rotrSL(m,g,18)^o.Ay.rotrBL(m,g,41),C=m&y^~m&v,E=g&w^~g&A,N=o.Ay.add5L(x,t,E,u[S],h[S]),k=o.Ay.add5H(N,b,e,C,c[S],d[S]),T=0|N,I=o.Ay.rotrSH(n,r,28)^o.Ay.rotrBH(n,r,34)^o.Ay.rotrBH(n,r,39),_=o.Ay.rotrSL(n,r,28)^o.Ay.rotrBL(n,r,34)^o.Ay.rotrBL(n,r,39),R=n&s^n&i^s&i,M=r&a^r&l^a&l;b=0|v,x=0|A,v=0|y,A=0|w,y=0|m,w=0|g,({h:m,l:g}=o.Ay.add(0|f,0|p,0|k,0|T)),f=0|i,p=0|l,i=0|s,l=0|a,s=0|n,a=0|r;const D=o.Ay.add3L(T,_,M);n=o.Ay.add3H(D,k,I,R),r=0|D}({h:n,l:r}=o.Ay.add(0|this.Ah,0|this.Al,0|n,0|r)),({h:s,l:a}=o.Ay.add(0|this.Bh,0|this.Bl,0|s,0|a)),({h:i,l:l}=o.Ay.add(0|this.Ch,0|this.Cl,0|i,0|l)),({h:f,l:p}=o.Ay.add(0|this.Dh,0|this.Dl,0|f,0|p)),({h:m,l:g}=o.Ay.add(0|this.Eh,0|this.El,0|m,0|g)),({h:y,l:w}=o.Ay.add(0|this.Fh,0|this.Fl,0|y,0|w)),({h:v,l:A}=o.Ay.add(0|this.Gh,0|this.Gl,0|v,0|A)),({h:b,l:x}=o.Ay.add(0|this.Hh,0|this.Hl,0|b,0|x)),this.set(n,r,s,a,i,l,f,p,m,g,y,w,v,A,b,x)}roundClean(){d.fill(0),h.fill(0)}destroy(){this.buffer.fill(0),this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)}}const p=(0,l.ld)(()=>new f);var m=n(5977);const g=function(){if("undefined"!==typeof self)return self;if("undefined"!==typeof window)return window;if("undefined"!==typeof n.g)return n.g;throw new Error("unable to locate global object")}(),y=g.crypto||g.msCrypto;function w(e){switch(e){case"sha256":return a.s.create();case"sha512":return p.create()}(0,m.MR)(!1,"invalid hashing algorithm name","algorithm",e)}function v(e,t){const n={sha256:a.s,sha512:p}[e];return(0,m.MR)(null!=n,"invalid hmac algorithm","algorithm",e),r.w.create(n,t)}function A(e,t,n,r,i){const o={sha256:a.s,sha512:p}[i];return(0,m.MR)(null!=o,"invalid pbkdf2 algorithm","algorithm",i),(0,s.A)(o,e,t,{c:n,dkLen:r})}function b(e){(0,m.vA)(null!=y,"platform does not support secure random numbers","UNSUPPORTED_OPERATION",{operation:"randomBytes"}),(0,m.MR)(Number.isInteger(e)&&e>0&&e<=1024,"invalid length","length",e);const t=new Uint8Array(e);return y.getRandomValues(t),t}},4827(e,t,n){"use strict";n.d(t,{L:()=>l});var r=n(1373),s=n(686);let a=!1;const i=function(e,t,n){return(0,r.Gz)(e,t).update(n).digest()};let o=i;function l(e,t,n){const r=(0,s.q5)(t,"key"),a=(0,s.q5)(n,"data");return(0,s.c$)(o(e,r,a))}l._=i,l.lock=function(){a=!0},l.register=function(e){if(a)throw new Error("computeHmac is locked");o=e},Object.freeze(l)},4248(e,t,n){"use strict";n.d(t,{S:()=>N});var r=n(7952),s=n(4421),a=n(5621);const[i,o,l]=[[],[],[]],c=BigInt(0),u=BigInt(1),d=BigInt(2),h=BigInt(7),f=BigInt(256),p=BigInt(113);for(let k=0,T=u,I=1,_=0;k<24;k++){[I,_]=[_,(2*I+3*_)%5],i.push(2*(5*_+I)),o.push((k+1)*(k+2)/2%64);let e=c;for(let t=0;t<7;t++)T=(T<<u^(T>>h)*p)%f,T&d&&(e^=u<<(u<<BigInt(t))-u);l.push(e)}const[m,g]=(0,s.lD)(l,!0),y=(e,t,n)=>n>32?(0,s.WM)(e,t,n):(0,s.P5)(e,t,n),w=(e,t,n)=>n>32?(0,s.im)(e,t,n):(0,s.B4)(e,t,n);class v extends a.Vw{constructor(e,t,n){let s=arguments.length>3&&void 0!==arguments[3]&&arguments[3],i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:24;if(super(),this.blockLen=e,this.suffix=t,this.outputLen=n,this.enableXOF=s,this.rounds=i,this.pos=0,this.posOut=0,this.finished=!1,this.destroyed=!1,(0,r.ai)(n),0>=this.blockLen||this.blockLen>=200)throw new Error("Sha3 supports only keccak-f1600 function");this.state=new Uint8Array(200),this.state32=(0,a.DH)(this.state)}keccak(){!function(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:24;const n=new Uint32Array(10);for(let r=24-t;r<24;r++){for(let r=0;r<10;r++)n[r]=e[r]^e[r+10]^e[r+20]^e[r+30]^e[r+40];for(let r=0;r<10;r+=2){const t=(r+8)%10,s=(r+2)%10,a=n[s],i=n[s+1],o=y(a,i,1)^n[t],l=w(a,i,1)^n[t+1];for(let n=0;n<50;n+=10)e[r+n]^=o,e[r+n+1]^=l}let t=e[2],s=e[3];for(let n=0;n<24;n++){const r=o[n],a=y(t,s,r),l=w(t,s,r),c=i[n];t=e[c],s=e[c+1],e[c]=a,e[c+1]=l}for(let r=0;r<50;r+=10){for(let t=0;t<10;t++)n[t]=e[r+t];for(let t=0;t<10;t++)e[r+t]^=~n[(t+2)%10]&n[(t+4)%10]}e[0]^=m[r],e[1]^=g[r]}n.fill(0)}(this.state32,this.rounds),this.posOut=0,this.pos=0}update(e){(0,r.t2)(this);const{blockLen:t,state:n}=this,s=(e=(0,a.ZJ)(e)).length;for(let r=0;r<s;){const a=Math.min(t-this.pos,s-r);for(let t=0;t<a;t++)n[this.pos++]^=e[r++];this.pos===t&&this.keccak()}return this}finish(){if(this.finished)return;this.finished=!0;const{state:e,suffix:t,pos:n,blockLen:r}=this;e[n]^=t,0!==(128&t)&&n===r-1&&this.keccak(),e[r-1]^=128,this.keccak()}writeInto(e){(0,r.t2)(this,!1),(0,r.ee)(e),this.finish();const t=this.state,{blockLen:n}=this;for(let r=0,s=e.length;r<s;){this.posOut>=n&&this.keccak();const a=Math.min(n-this.posOut,s-r);e.set(t.subarray(this.posOut,this.posOut+a),r),this.posOut+=a,r+=a}return e}xofInto(e){if(!this.enableXOF)throw new Error("XOF is not possible for this instance");return this.writeInto(e)}xof(e){return(0,r.ai)(e),this.xofInto(new Uint8Array(e))}digestInto(e){if((0,r.CG)(e,this),this.finished)throw new Error("digest() was already called");return this.writeInto(e),this.destroy(),e}digest(){return this.digestInto(new Uint8Array(this.outputLen))}destroy(){this.destroyed=!0,this.state.fill(0)}_cloneInto(e){const{blockLen:t,suffix:n,outputLen:r,rounds:s,enableXOF:a}=this;return e||(e=new v(t,n,r,a,s)),e.state32.set(this.state32),e.pos=this.pos,e.posOut=this.posOut,e.finished=this.finished,e.rounds=s,e.suffix=n,e.outputLen=r,e.enableXOF=a,e.destroyed=this.destroyed,e}}const A=(e,t,n)=>(0,a.ld)(()=>new v(t,e,n)),b=A(1,136,32);var x=n(686);let S=!1;const C=function(e){return b(e)};let E=C;function N(e){const t=(0,x.q5)(e,"data");return(0,x.c$)(E(t))}N._=C,N.lock=function(){S=!0},N.register=function(e){if(S)throw new TypeError("keccak256 is locked");E=e},Object.freeze(N)},8465(e,t,n){"use strict";n.d(t,{A:()=>l});var r=n(1373),s=n(686);let a=!1;const i=function(e,t,n,s,a){return(0,r.T_)(e,t,n,s,a)};let o=i;function l(e,t,n,r,a){const i=(0,s.q5)(e,"password"),l=(0,s.q5)(t,"salt");return(0,s.c$)(o(i,l,n,r,a))}l._=i,l.lock=function(){a=!0},l.register=function(e){if(a)throw new Error("pbkdf2 is locked");o=e},Object.freeze(l)},5955(e,t,n){"use strict";n.d(t,{p:()=>o});var r=n(1373);let s=!1;const a=function(e){return new Uint8Array((0,r.po)(e))};let i=a;function o(e){return i(e)}o._=a,o.lock=function(){s=!0},o.register=function(e){if(s)throw new Error("randomBytes is locked");i=e},Object.freeze(o)},738(e,t,n){"use strict";n.d(t,{H:()=>S});var r=n(4814),s=n(5621);const a=new Uint8Array([7,4,13,1,10,6,15,3,12,0,9,5,2,14,11,8]),i=Uint8Array.from({length:16},(e,t)=>t);let o=[i],l=[i.map(e=>(9*e+5)%16)];for(let C=0;C<4;C++)for(let e of[o,l])e.push(e[C].map(e=>a[e]));const c=[[11,14,15,12,5,8,7,9,11,13,14,15,6,7,9,8],[12,13,11,15,6,9,9,7,12,15,11,13,7,8,7,7],[13,15,14,11,7,7,6,8,13,14,13,12,5,5,6,9],[14,11,12,14,8,6,5,5,15,12,15,14,9,9,8,6],[15,12,13,13,9,5,8,6,14,11,12,11,8,6,5,5]].map(e=>new Uint8Array(e)),u=o.map((e,t)=>e.map(e=>c[t][e])),d=l.map((e,t)=>e.map(e=>c[t][e])),h=new Uint32Array([0,1518500249,1859775393,2400959708,2840853838]),f=new Uint32Array([1352829926,1548603684,1836072691,2053994217,0]),p=(e,t)=>e<<t|e>>>32-t;function m(e,t,n,r){return 0===e?t^n^r:1===e?t&n|~t&r:2===e?(t|~n)^r:3===e?t&r|n&~r:t^(n|~r)}const g=new Uint32Array(16);class y extends r.D{constructor(){super(64,20,8,!0),this.h0=1732584193,this.h1=-271733879,this.h2=-1732584194,this.h3=271733878,this.h4=-1009589776}get(){const{h0:e,h1:t,h2:n,h3:r,h4:s}=this;return[e,t,n,r,s]}set(e,t,n,r,s){this.h0=0|e,this.h1=0|t,this.h2=0|n,this.h3=0|r,this.h4=0|s}process(e,t){for(let o=0;o<16;o++,t+=4)g[o]=e.getUint32(t,!0);let n=0|this.h0,r=n,s=0|this.h1,a=s,i=0|this.h2,c=i,y=0|this.h3,w=y,v=0|this.h4,A=v;for(let b=0;b<5;b++){const e=4-b,t=h[b],x=f[b],S=o[b],C=l[b],E=u[b],N=d[b];for(let r=0;r<16;r++){const e=p(n+m(b,s,i,y)+g[S[r]]+t,E[r])+v|0;n=v,v=y,y=0|p(i,10),i=s,s=e}for(let n=0;n<16;n++){const t=p(r+m(e,a,c,w)+g[C[n]]+x,N[n])+A|0;r=A,A=w,w=0|p(c,10),c=a,a=t}}this.set(this.h1+i+w|0,this.h2+y+A|0,this.h3+v+r|0,this.h4+n+a|0,this.h0+s+c|0)}roundClean(){g.fill(0)}destroy(){this.destroyed=!0,this.buffer.fill(0),this.set(0,0,0,0,0)}}const w=(0,s.ld)(()=>new y);var v=n(686);let A=!1;const b=function(e){return w(e)};let x=b;function S(e){const t=(0,v.q5)(e,"data");return(0,v.c$)(x(t))}S._=b,S.lock=function(){A=!0},S.register=function(e){if(A)throw new TypeError("ripemd160 is locked");x=e},Object.freeze(S)},5231(e,t,n){"use strict";n.d(t,{s:()=>v,d:()=>A});var r=n(7952),s=n(7804),a=n(6390),i=n(5621);const o=(e,t)=>e<<t|e>>>32-t;function l(e,t,n,r,s,a){let i=e[t++]^n[r++],l=e[t++]^n[r++],c=e[t++]^n[r++],u=e[t++]^n[r++],d=e[t++]^n[r++],h=e[t++]^n[r++],f=e[t++]^n[r++],p=e[t++]^n[r++],m=e[t++]^n[r++],g=e[t++]^n[r++],y=e[t++]^n[r++],w=e[t++]^n[r++],v=e[t++]^n[r++],A=e[t++]^n[r++],b=e[t++]^n[r++],x=e[t++]^n[r++],S=i,C=l,E=c,N=u,k=d,T=h,I=f,_=p,R=m,M=g,D=y,j=w,O=v,P=A,L=b,B=x;for(let F=0;F<8;F+=2)k^=o(S+O|0,7),R^=o(k+S|0,9),O^=o(R+k|0,13),S^=o(O+R|0,18),M^=o(T+C|0,7),P^=o(M+T|0,9),C^=o(P+M|0,13),T^=o(C+P|0,18),L^=o(D+I|0,7),E^=o(L+D|0,9),I^=o(E+L|0,13),D^=o(I+E|0,18),N^=o(B+j|0,7),_^=o(N+B|0,9),j^=o(_+N|0,13),B^=o(j+_|0,18),C^=o(S+N|0,7),E^=o(C+S|0,9),N^=o(E+C|0,13),S^=o(N+E|0,18),I^=o(T+k|0,7),_^=o(I+T|0,9),k^=o(_+I|0,13),T^=o(k+_|0,18),j^=o(D+M|0,7),R^=o(j+D|0,9),M^=o(R+j|0,13),D^=o(M+R|0,18),O^=o(B+L|0,7),P^=o(O+B|0,9),L^=o(P+O|0,13),B^=o(L+P|0,18);s[a++]=i+S|0,s[a++]=l+C|0,s[a++]=c+E|0,s[a++]=u+N|0,s[a++]=d+k|0,s[a++]=h+T|0,s[a++]=f+I|0,s[a++]=p+_|0,s[a++]=m+R|0,s[a++]=g+M|0,s[a++]=y+D|0,s[a++]=w+j|0,s[a++]=v+O|0,s[a++]=A+P|0,s[a++]=b+L|0,s[a++]=x+B|0}function c(e,t,n,r,s){let a=r+0,i=r+16*s;for(let o=0;o<16;o++)n[i+o]=e[t+16*(2*s-1)+o];for(let o=0;o<s;o++,a+=16,t+=16)l(n,i,e,t,n,a),o>0&&(i+=16),l(n,a,e,t+=16,n,i)}function u(e,t,n){const o=(0,i.tY)({dkLen:32,asyncTick:10,maxmem:1073742848},n),{N:l,r:c,p:u,dkLen:d,asyncTick:h,maxmem:f,onProgress:p}=o;if((0,r.ai)(l),(0,r.ai)(c),(0,r.ai)(u),(0,r.ai)(d),(0,r.ai)(h),(0,r.ai)(f),void 0!==p&&"function"!==typeof p)throw new Error("progressCb should be function");const m=128*c,g=m/4;if(l<=1||0!==(l&l-1)||l>=2**(m/8)||l>2**32)throw new Error("Scrypt: N must be larger than 1, a power of 2, less than 2^(128 * r / 8) and less than 2^32");if(u<0||u>137438953440/m)throw new Error("Scrypt: p must be a positive integer less than or equal to ((2^32 - 1) * 32) / (128 * r)");if(d<0||d>137438953440)throw new Error("Scrypt: dkLen should be positive integer less than or equal to (2^32 - 1) * 32");const y=m*(l+u);if(y>f)throw new Error("Scrypt: parameters too large, ".concat(y," (128 * r * (N + p)) > ").concat(f," (maxmem)"));const w=(0,a.A)(s.s,e,t,{c:1,dkLen:m*u}),v=(0,i.DH)(w),A=(0,i.DH)(new Uint8Array(m*l)),b=(0,i.DH)(new Uint8Array(m));let x=()=>{};if(p){const e=2*l*u,t=Math.max(Math.floor(e/1e4),1);let n=0;x=()=>{n++,!p||n%t&&n!==e||p(n/e)}}return{N:l,r:c,p:u,dkLen:d,blockSize32:g,V:A,B32:v,B:w,tmp:b,blockMixCb:x,asyncTick:h}}function d(e,t,n,r,i){const o=(0,a.A)(s.s,e,n,{c:1,dkLen:t});return n.fill(0),r.fill(0),i.fill(0),o}var h=n(686);let f=!1,p=!1;const m=async function(e,t,n,r,s,a,o){return await async function(e,t,n){const{N:r,r:s,p:a,dkLen:o,blockSize32:l,V:h,B32:f,B:p,tmp:m,blockMixCb:g,asyncTick:y}=u(e,t,n);for(let u=0;u<a;u++){const e=l*u;for(let n=0;n<l;n++)h[n]=f[e+n];let t=0;await(0,i.$h)(r-1,y,()=>{c(h,t,h,t+=l,s),g()}),c(h,(r-1)*l,f,e,s),g(),await(0,i.$h)(r,y,()=>{const t=f[e+l-16]%r;for(let n=0;n<l;n++)m[n]=f[e+n]^h[t*l+n];c(m,0,f,e,s),g()})}return d(e,o,p,h,m)}(e,t,{N:n,r:r,p:s,dkLen:a,onProgress:o})},g=function(e,t,n,r,s,a){return function(e,t,n){const{N:r,r:s,p:a,dkLen:i,blockSize32:o,V:l,B32:h,B:f,tmp:p,blockMixCb:m}=u(e,t,n);for(let u=0;u<a;u++){const e=o*u;for(let t=0;t<o;t++)l[t]=h[e+t];for(let t=0,n=0;t<r-1;t++)c(l,n,l,n+=o,s),m();c(l,(r-1)*o,h,e,s),m();for(let t=0;t<r;t++){const t=h[e+o-16]%r;for(let n=0;n<o;n++)p[n]=h[e+n]^l[t*o+n];c(p,0,h,e,s),m()}}return d(e,i,f,l,p)}(e,t,{N:n,r:r,p:s,dkLen:a})};let y=m,w=g;async function v(e,t,n,r,s,a,i){const o=(0,h.q5)(e,"passwd"),l=(0,h.q5)(t,"salt");return(0,h.c$)(await y(o,l,n,r,s,a,i))}function A(e,t,n,r,s,a){const i=(0,h.q5)(e,"passwd"),o=(0,h.q5)(t,"salt");return(0,h.c$)(w(i,o,n,r,s,a))}v._=m,v.lock=function(){p=!0},v.register=function(e){if(p)throw new Error("scrypt is locked");y=e},Object.freeze(v),A._=g,A.lock=function(){f=!0},A.register=function(e){if(f)throw new Error("scryptSync is locked");w=e},Object.freeze(A)},536(e,t,n){"use strict";n.d(t,{Z:()=>h,s:()=>d});var r=n(1373),s=n(686);const a=function(e){return(0,r.n1)("sha256").update(e).digest()},i=function(e){return(0,r.n1)("sha512").update(e).digest()};let o=a,l=i,c=!1,u=!1;function d(e){const t=(0,s.q5)(e,"data");return(0,s.c$)(o(t))}function h(e){const t=(0,s.q5)(e,"data");return(0,s.c$)(l(t))}d._=a,d.lock=function(){c=!0},d.register=function(e){if(c)throw new Error("sha256 is locked");o=e},Object.freeze(d),h._=i,h.lock=function(){u=!0},h.register=function(e){if(u)throw new Error("sha512 is locked");l=e},Object.freeze(d)},2876(e,t,n){"use strict";n.d(t,{t:()=>x});var r=n(5149),s=n(2177),a=n(8458),i=n(2078),o=n(686),l=n(5977),c=n(2731);const u=BigInt(0),d=BigInt(1),h=BigInt(2),f=BigInt(27),p=BigInt(28),m=BigInt(35),g={};function y(e){return(0,o.nx)((0,c.c4)(e),32)}var w=new WeakMap,v=new WeakMap,A=new WeakMap,b=new WeakMap;class x{get r(){return(0,a.A)(w,this)}set r(e){(0,l.MR)(32===(0,o.pO)(e),"invalid r","value",e),(0,s.A)(w,this,(0,o.c$)(e))}get s(){return(0,l.MR)(parseInt((0,a.A)(v,this).substring(0,3))<8,"non-canonical s; use ._s","s",(0,a.A)(v,this)),(0,a.A)(v,this)}set s(e){(0,l.MR)(32===(0,o.pO)(e),"invalid s","value",e),(0,s.A)(v,this,(0,o.c$)(e))}get _s(){return(0,a.A)(v,this)}isValid(){return parseInt((0,a.A)(v,this).substring(0,3))<8}get v(){return(0,a.A)(A,this)}set v(e){const t=(0,c.WZ)(e,"value");(0,l.MR)(27===t||28===t,"invalid v","v",e),(0,s.A)(A,this,t)}get networkV(){return(0,a.A)(b,this)}get legacyChainId(){const e=this.networkV;return null==e?null:x.getChainId(e)}get yParity(){return 27===this.v?0:1}get yParityAndS(){const e=(0,o.q5)(this.s);return this.yParity&&(e[0]|=128),(0,o.c$)(e)}get compactSerialized(){return(0,o.xW)([this.r,this.yParityAndS])}get serialized(){return(0,o.xW)([this.r,this.s,this.yParity?"0x1c":"0x1b"])}constructor(e,t,n,a){(0,r.A)(this,w,void 0),(0,r.A)(this,v,void 0),(0,r.A)(this,A,void 0),(0,r.A)(this,b,void 0),(0,l.gk)(e,g,"Signature"),(0,s.A)(w,this,t),(0,s.A)(v,this,n),(0,s.A)(A,this,a),(0,s.A)(b,this,null)}[Symbol.for("nodejs.util.inspect.custom")](){return'Signature { r: "'.concat(this.r,'", s: "').concat(this._s,'"').concat(this.isValid()?"":', valid: "false"',", yParity: ").concat(this.yParity,", networkV: ").concat(this.networkV," }")}clone(){const e=new x(g,this.r,this._s,this.v);return this.networkV&&(0,s.A)(b,e,this.networkV),e}toJSON(){const e=this.networkV;return{_type:"signature",networkV:null!=e?e.toString():null,r:this.r,s:this._s,v:this.v}}static getChainId(e){const t=(0,c.Ab)(e,"v");return t==f||t==p?u:((0,l.MR)(t>=m,"invalid EIP-155 v","v",e),(t-m)/h)}static getChainIdV(e,t){return(0,c.Ab)(e)*h+BigInt(35+t-27)}static getNormalizedV(e){const t=(0,c.Ab)(e);return t===u||t===f?27:t===d||t===p?28:((0,l.MR)(t>=m,"invalid v","v",e),t&d?27:28)}static from(e){function t(t,n){(0,l.MR)(t,n,"signature",e)}if(null==e)return new x(g,i.p,i.p,27);if("string"===typeof e){const n=(0,o.q5)(e,"signature");if(64===n.length){const e=(0,o.c$)(n.slice(0,32)),t=n.slice(32,64),r=128&t[0]?28:27;return t[0]&=127,new x(g,e,(0,o.c$)(t),r)}if(65===n.length){const e=(0,o.c$)(n.slice(0,32)),t=(0,o.c$)(n.slice(32,64)),r=x.getNormalizedV(n[64]);return new x(g,e,t,r)}t(!1,"invalid raw signature length")}if(e instanceof x)return e.clone();const n=e.r;t(null!=n,"missing r");const r=y(n),a=function(e,n){if(null!=e)return y(e);if(null!=n){t((0,o.Lo)(n,32),"invalid yParityAndS");const e=(0,o.q5)(n);return e[0]&=127,(0,o.c$)(e)}t(!1,"missing s")}(e.s,e.yParityAndS),{networkV:u,v:d}=function(e,n,r){if(null!=e){const t=(0,c.Ab)(e);return{networkV:t>=m?t:void 0,v:x.getNormalizedV(t)}}if(null!=n)return t((0,o.Lo)(n,32),"invalid yParityAndS"),{v:128&(0,o.q5)(n)[0]?28:27};if(null!=r){switch((0,c.WZ)(r,"sig.yParity")){case 0:return{v:27};case 1:return{v:28}}t(!1,"invalid yParity")}t(!1,"missing v")}(e.v,e.yParityAndS,e.yParity),h=new x(g,r,a,d);return u&&(0,s.A)(b,h,u),t(null==e.yParity||(0,c.WZ)(e.yParity,"sig.yParity")===h.yParity,"yParity mismatch"),t(null==e.yParityAndS||e.yParityAndS===h.yParityAndS,"yParityAndS mismatch"),h}}},3508(e,t,n){"use strict";n.d(t,{h:()=>ge});var r={};n.r(r),n.d(r,{OG:()=>b,My:()=>h,Ph:()=>m,lX:()=>g,Id:()=>A,fg:()=>C,qj:()=>v,aT:()=>p,lq:()=>y,z:()=>w,Q5:()=>N});var s=n(5149),a=n(8458),i=n(2177),o=n(7804);BigInt(0);const l=BigInt(1),c=BigInt(2),u=e=>e instanceof Uint8Array,d=Array.from({length:256},(e,t)=>t.toString(16).padStart(2,"0"));function h(e){if(!u(e))throw new Error("Uint8Array expected");let t="";for(let n=0;n<e.length;n++)t+=d[e[n]];return t}function f(e){if("string"!==typeof e)throw new Error("hex string expected, got "+typeof e);return BigInt(""===e?"0":"0x".concat(e))}function p(e){if("string"!==typeof e)throw new Error("hex string expected, got "+typeof e);const t=e.length;if(t%2)throw new Error("padded hex string expected, got unpadded hex of length "+t);const n=new Uint8Array(t/2);for(let r=0;r<n.length;r++){const t=2*r,s=e.slice(t,t+2),a=Number.parseInt(s,16);if(Number.isNaN(a)||a<0)throw new Error("Invalid byte sequence");n[r]=a}return n}function m(e){return f(h(e))}function g(e){if(!u(e))throw new Error("Uint8Array expected");return f(h(Uint8Array.from(e).reverse()))}function y(e,t){return p(e.toString(16).padStart(2*t,"0"))}function w(e,t){return y(e,t).reverse()}function v(e,t,n){let r;if("string"===typeof t)try{r=p(t)}catch(a){throw new Error("".concat(e,' must be valid hex string, got "').concat(t,'". Cause: ').concat(a))}else{if(!u(t))throw new Error("".concat(e," must be hex string or Uint8Array"));r=Uint8Array.from(t)}const s=r.length;if("number"===typeof n&&s!==n)throw new Error("".concat(e," expected ").concat(n," bytes, got ").concat(s));return r}function A(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];const r=new Uint8Array(t.reduce((e,t)=>e+t.length,0));let s=0;return t.forEach(e=>{if(!u(e))throw new Error("Uint8Array expected");r.set(e,s),s+=e.length}),r}const b=e=>(c<<BigInt(e-1))-l,x=e=>new Uint8Array(e),S=e=>Uint8Array.from(e);function C(e,t,n){if("number"!==typeof e||e<2)throw new Error("hashLen must be a number");if("number"!==typeof t||t<2)throw new Error("qByteLen must be a number");if("function"!==typeof n)throw new Error("hmacFn must be a function");let r=x(e),s=x(e),a=0;const i=()=>{r.fill(1),s.fill(0),a=0},o=function(){for(var e=arguments.length,t=new Array(e),a=0;a<e;a++)t[a]=arguments[a];return n(s,r,...t)},l=function(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:x();s=o(S([0]),e),r=o(),0!==e.length&&(s=o(S([1]),e),r=o())},c=()=>{if(a++>=1e3)throw new Error("drbg: tried 1000 values");let e=0;const n=[];for(;e<t;){r=o();const t=r.slice();n.push(t),e+=r.length}return A(...n)};return(e,t)=>{let n;for(i(),l(e);!(n=t(c()));)l();return i(),n}}const E={bigint:e=>"bigint"===typeof e,function:e=>"function"===typeof e,boolean:e=>"boolean"===typeof e,string:e=>"string"===typeof e,stringOrUint8Array:e=>"string"===typeof e||e instanceof Uint8Array,isSafeInteger:e=>Number.isSafeInteger(e),array:e=>Array.isArray(e),field:(e,t)=>t.Fp.isValid(e),hash:e=>"function"===typeof e&&Number.isSafeInteger(e.outputLen)};function N(e,t){let n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const r=(t,n,r)=>{const s=E[n];if("function"!==typeof s)throw new Error('Invalid validator "'.concat(n,'", expected function'));const a=e[t];if((!r||void 0!==a)&&!s(a,e))throw new Error("Invalid param ".concat(String(t),"=").concat(a," (").concat(typeof a,"), expected ").concat(n))};for(const[s,a]of Object.entries(t))r(s,a,!1);for(const[s,a]of Object.entries(n))r(s,a,!0);return e}const k=BigInt(0),T=BigInt(1),I=BigInt(2),_=BigInt(3),R=BigInt(4),M=BigInt(5),D=BigInt(8);BigInt(9),BigInt(16);function j(e,t){const n=e%t;return n>=k?n:t+n}function O(e,t,n){if(n<=k||t<k)throw new Error("Expected power/modulo > 0");if(n===T)return k;let r=T;for(;t>k;)t&T&&(r=r*e%n),e=e*e%n,t>>=T;return r}function P(e,t,n){let r=e;for(;t-- >k;)r*=r,r%=n;return r}function L(e,t){if(e===k||t<=k)throw new Error("invert: expected positive integers, got n=".concat(e," mod=").concat(t));let n=j(e,t),r=t,s=k,a=T,i=T,o=k;for(;n!==k;){const e=r/n,t=r%n,l=s-i*e,c=a-o*e;r=n,n=t,s=i,a=o,i=l,o=c}if(r!==T)throw new Error("invert: does not exist");return j(s,t)}function B(e){if(e%R===_){const t=(e+T)/R;return function(e,n){const r=e.pow(n,t);if(!e.eql(e.sqr(r),n))throw new Error("Cannot find square root");return r}}if(e%D===M){const t=(e-M)/D;return function(e,n){const r=e.mul(n,I),s=e.pow(r,t),a=e.mul(n,s),i=e.mul(e.mul(a,I),s),o=e.mul(a,e.sub(i,e.ONE));if(!e.eql(e.sqr(o),n))throw new Error("Cannot find square root");return o}}return function(e){const t=(e-T)/I;let n,r,s;for(n=e-T,r=0;n%I===k;n/=I,r++);for(s=I;s<e&&O(s,t,e)!==e-T;s++);if(1===r){const t=(e+T)/R;return function(e,n){const r=e.pow(n,t);if(!e.eql(e.sqr(r),n))throw new Error("Cannot find square root");return r}}const a=(n+T)/I;return function(e,i){if(e.pow(i,t)===e.neg(e.ONE))throw new Error("Cannot find square root");let o=r,l=e.pow(e.mul(e.ONE,s),n),c=e.pow(i,a),u=e.pow(i,n);for(;!e.eql(u,e.ONE);){if(e.eql(u,e.ZERO))return e.ZERO;let t=1;for(let r=e.sqr(u);t<o&&!e.eql(r,e.ONE);t++)r=e.sqr(r);const n=e.pow(l,T<<BigInt(o-t-1));l=e.sqr(n),c=e.mul(c,n),u=e.mul(u,l),o=t}return c}}(e)}const F=["create","isValid","is0","neg","inv","sqrt","sqr","eql","add","sub","mul","pow","div","addN","subN","mulN","sqrN"];function U(e,t){const n=void 0!==t?t:e.toString(2).length;return{nBitLength:n,nByteLength:Math.ceil(n/8)}}function W(e){if("bigint"!==typeof e)throw new Error("field order must be bigint");const t=e.toString(2).length;return Math.ceil(t/8)}function z(e){const t=W(e);return t+Math.ceil(t/2)}var H=n(9379),V=n(4432),G=n(5621);const J=BigInt(0),Q=BigInt(1);function K(e){return N(e.Fp,F.reduce((e,t)=>(e[t]="function",e),{ORDER:"bigint",MASK:"bigint",BYTES:"isSafeInteger",BITS:"isSafeInteger"})),N(e,{n:"bigint",h:"bigint",Gx:"field",Gy:"field"},{nBitLength:"isSafeInteger",nByteLength:"isSafeInteger"}),Object.freeze((0,H.A)((0,H.A)((0,H.A)({},U(e.n,e.nBitLength)),e),{p:e.Fp.ORDER}))}const{Ph:Y,aT:q}=r,X={Err:class extends Error{constructor(){super(arguments.length>0&&void 0!==arguments[0]?arguments[0]:"")}},_parseInt(e){const{Err:t}=X;if(e.length<2||2!==e[0])throw new t("Invalid signature integer tag");const n=e[1],r=e.subarray(2,n+2);if(!n||r.length!==n)throw new t("Invalid signature integer: wrong length");if(128&r[0])throw new t("Invalid signature integer: negative");if(0===r[0]&&!(128&r[1]))throw new t("Invalid signature integer: unnecessary leading zero");return{d:Y(r),l:e.subarray(n+2)}},toSig(e){const{Err:t}=X,n="string"===typeof e?q(e):e;if(!(n instanceof Uint8Array))throw new Error("ui8a expected");let r=n.length;if(r<2||48!=n[0])throw new t("Invalid signature tag");if(n[1]!==r-2)throw new t("Invalid signature: incorrect length");const{d:s,l:a}=X._parseInt(n.subarray(2)),{d:i,l:o}=X._parseInt(a);if(o.length)throw new t("Invalid signature: left bytes after parsing");return{r:s,s:i}},hexFromSig(e){const t=e=>8&Number.parseInt(e[0],16)?"00"+e:e,n=e=>{const t=e.toString(16);return 1&t.length?"0".concat(t):t},r=t(n(e.s)),s=t(n(e.r)),a=r.length/2,i=s.length/2,o=n(a),l=n(i);return"30".concat(n(i+a+4),"02").concat(l).concat(s,"02").concat(o).concat(r)}},Z=BigInt(0),$=BigInt(1),ee=(BigInt(2),BigInt(3));BigInt(4);function te(e){const t=function(e){const t=K(e);N(t,{a:"field",b:"field"},{allowedPrivateKeyLengths:"array",wrapPrivateKey:"boolean",isTorsionFree:"function",clearCofactor:"function",allowInfinityPoint:"boolean",fromBytes:"function",toBytes:"function"});const{endo:n,Fp:r,a:s}=t;if(n){if(!r.eql(s,r.ZERO))throw new Error("Endomorphism can only be defined for Koblitz curves that have a=0");if("object"!==typeof n||"bigint"!==typeof n.beta||"function"!==typeof n.splitScalar)throw new Error("Expected endomorphism with beta: bigint and splitScalar: function")}return Object.freeze((0,H.A)({},t))}(e),{Fp:n}=t,r=t.toBytes||((e,t,r)=>{const s=t.toAffine();return A(Uint8Array.from([4]),n.toBytes(s.x),n.toBytes(s.y))}),s=t.fromBytes||(e=>{const t=e.subarray(1);return{x:n.fromBytes(t.subarray(0,n.BYTES)),y:n.fromBytes(t.subarray(n.BYTES,2*n.BYTES))}});function a(e){const{a:r,b:s}=t,a=n.sqr(e),i=n.mul(a,e);return n.add(n.add(i,n.mul(e,r)),s)}if(!n.eql(n.sqr(t.Gy),a(t.Gx)))throw new Error("bad generator point: equation left != right");function i(e){return"bigint"===typeof e&&Z<e&&e<t.n}function o(e){if(!i(e))throw new Error("Expected valid bigint: 0 < bigint < curve.n")}function l(e){const{allowedPrivateKeyLengths:n,nByteLength:r,wrapPrivateKey:s,n:a}=t;if(n&&"bigint"!==typeof e){if(e instanceof Uint8Array&&(e=h(e)),"string"!==typeof e||!n.includes(e.length))throw new Error("Invalid key");e=e.padStart(2*r,"0")}let i;try{i="bigint"===typeof e?e:m(v("private key",e,r))}catch(l){throw new Error("private key must be ".concat(r," bytes, hex or bigint, not ").concat(typeof e))}return s&&(i=j(i,a)),o(i),i}const c=new Map;function u(e){if(!(e instanceof d))throw new Error("ProjectivePoint expected")}class d{constructor(e,t,r){if(this.px=e,this.py=t,this.pz=r,null==e||!n.isValid(e))throw new Error("x required");if(null==t||!n.isValid(t))throw new Error("y required");if(null==r||!n.isValid(r))throw new Error("z required")}static fromAffine(e){const{x:t,y:r}=e||{};if(!e||!n.isValid(t)||!n.isValid(r))throw new Error("invalid affine point");if(e instanceof d)throw new Error("projective point not allowed");const s=e=>n.eql(e,n.ZERO);return s(t)&&s(r)?d.ZERO:new d(t,r,n.ONE)}get x(){return this.toAffine().x}get y(){return this.toAffine().y}static normalizeZ(e){const t=n.invertBatch(e.map(e=>e.pz));return e.map((e,n)=>e.toAffine(t[n])).map(d.fromAffine)}static fromHex(e){const t=d.fromAffine(s(v("pointHex",e)));return t.assertValidity(),t}static fromPrivateKey(e){return d.BASE.multiply(l(e))}_setWindowSize(e){this._WINDOW_SIZE=e,c.delete(this)}assertValidity(){if(this.is0()){if(t.allowInfinityPoint&&!n.is0(this.py))return;throw new Error("bad point: ZERO")}const{x:e,y:r}=this.toAffine();if(!n.isValid(e)||!n.isValid(r))throw new Error("bad point: x or y not FE");const s=n.sqr(r),i=a(e);if(!n.eql(s,i))throw new Error("bad point: equation left != right");if(!this.isTorsionFree())throw new Error("bad point: not in prime-order subgroup")}hasEvenY(){const{y:e}=this.toAffine();if(n.isOdd)return!n.isOdd(e);throw new Error("Field doesn't support isOdd")}equals(e){u(e);const{px:t,py:r,pz:s}=this,{px:a,py:i,pz:o}=e,l=n.eql(n.mul(t,o),n.mul(a,s)),c=n.eql(n.mul(r,o),n.mul(i,s));return l&&c}negate(){return new d(this.px,n.neg(this.py),this.pz)}double(){const{a:e,b:r}=t,s=n.mul(r,ee),{px:a,py:i,pz:o}=this;let l=n.ZERO,c=n.ZERO,u=n.ZERO,h=n.mul(a,a),f=n.mul(i,i),p=n.mul(o,o),m=n.mul(a,i);return m=n.add(m,m),u=n.mul(a,o),u=n.add(u,u),l=n.mul(e,u),c=n.mul(s,p),c=n.add(l,c),l=n.sub(f,c),c=n.add(f,c),c=n.mul(l,c),l=n.mul(m,l),u=n.mul(s,u),p=n.mul(e,p),m=n.sub(h,p),m=n.mul(e,m),m=n.add(m,u),u=n.add(h,h),h=n.add(u,h),h=n.add(h,p),h=n.mul(h,m),c=n.add(c,h),p=n.mul(i,o),p=n.add(p,p),h=n.mul(p,m),l=n.sub(l,h),u=n.mul(p,f),u=n.add(u,u),u=n.add(u,u),new d(l,c,u)}add(e){u(e);const{px:r,py:s,pz:a}=this,{px:i,py:o,pz:l}=e;let c=n.ZERO,h=n.ZERO,f=n.ZERO;const p=t.a,m=n.mul(t.b,ee);let g=n.mul(r,i),y=n.mul(s,o),w=n.mul(a,l),v=n.add(r,s),A=n.add(i,o);v=n.mul(v,A),A=n.add(g,y),v=n.sub(v,A),A=n.add(r,a);let b=n.add(i,l);return A=n.mul(A,b),b=n.add(g,w),A=n.sub(A,b),b=n.add(s,a),c=n.add(o,l),b=n.mul(b,c),c=n.add(y,w),b=n.sub(b,c),f=n.mul(p,A),c=n.mul(m,w),f=n.add(c,f),c=n.sub(y,f),f=n.add(y,f),h=n.mul(c,f),y=n.add(g,g),y=n.add(y,g),w=n.mul(p,w),A=n.mul(m,A),y=n.add(y,w),w=n.sub(g,w),w=n.mul(p,w),A=n.add(A,w),g=n.mul(y,A),h=n.add(h,g),g=n.mul(b,A),c=n.mul(v,c),c=n.sub(c,g),g=n.mul(v,y),f=n.mul(b,f),f=n.add(f,g),new d(c,h,f)}subtract(e){return this.add(e.negate())}is0(){return this.equals(d.ZERO)}wNAF(e){return p.wNAFCached(this,c,e,e=>{const t=n.invertBatch(e.map(e=>e.pz));return e.map((e,n)=>e.toAffine(t[n])).map(d.fromAffine)})}multiplyUnsafe(e){const r=d.ZERO;if(e===Z)return r;if(o(e),e===$)return this;const{endo:s}=t;if(!s)return p.unsafeLadder(this,e);let{k1neg:a,k1:i,k2neg:l,k2:c}=s.splitScalar(e),u=r,h=r,f=this;for(;i>Z||c>Z;)i&$&&(u=u.add(f)),c&$&&(h=h.add(f)),f=f.double(),i>>=$,c>>=$;return a&&(u=u.negate()),l&&(h=h.negate()),h=new d(n.mul(h.px,s.beta),h.py,h.pz),u.add(h)}multiply(e){o(e);let r,s,a=e;const{endo:i}=t;if(i){const{k1neg:e,k1:t,k2neg:o,k2:l}=i.splitScalar(a);let{p:c,f:u}=this.wNAF(t),{p:h,f:f}=this.wNAF(l);c=p.constTimeNegate(e,c),h=p.constTimeNegate(o,h),h=new d(n.mul(h.px,i.beta),h.py,h.pz),r=c.add(h),s=u.add(f)}else{const{p:e,f:t}=this.wNAF(a);r=e,s=t}return d.normalizeZ([r,s])[0]}multiplyAndAddUnsafe(e,t,n){const r=d.BASE,s=(e,t)=>t!==Z&&t!==$&&e.equals(r)?e.multiply(t):e.multiplyUnsafe(t),a=s(this,t).add(s(e,n));return a.is0()?void 0:a}toAffine(e){const{px:t,py:r,pz:s}=this,a=this.is0();null==e&&(e=a?n.ONE:n.inv(s));const i=n.mul(t,e),o=n.mul(r,e),l=n.mul(s,e);if(a)return{x:n.ZERO,y:n.ZERO};if(!n.eql(l,n.ONE))throw new Error("invZ was invalid");return{x:i,y:o}}isTorsionFree(){const{h:e,isTorsionFree:n}=t;if(e===$)return!0;if(n)return n(d,this);throw new Error("isTorsionFree() has not been declared for the elliptic curve")}clearCofactor(){const{h:e,clearCofactor:n}=t;return e===$?this:n?n(d,this):this.multiplyUnsafe(t.h)}toRawBytes(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];return this.assertValidity(),r(d,this,e)}toHex(){let e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];return h(this.toRawBytes(e))}}d.BASE=new d(t.Gx,t.Gy,n.ONE),d.ZERO=new d(n.ZERO,n.ONE,n.ZERO);const f=t.nBitLength,p=function(e,t){const n=(e,t)=>{const n=t.negate();return e?n:t},r=e=>({windows:Math.ceil(t/e)+1,windowSize:2**(e-1)});return{constTimeNegate:n,unsafeLadder(t,n){let r=e.ZERO,s=t;for(;n>J;)n&Q&&(r=r.add(s)),s=s.double(),n>>=Q;return r},precomputeWindow(e,t){const{windows:n,windowSize:s}=r(t),a=[];let i=e,o=i;for(let r=0;r<n;r++){o=i,a.push(o);for(let e=1;e<s;e++)o=o.add(i),a.push(o);i=o.double()}return a},wNAF(t,s,a){const{windows:i,windowSize:o}=r(t);let l=e.ZERO,c=e.BASE;const u=BigInt(2**t-1),d=2**t,h=BigInt(t);for(let e=0;e<i;e++){const t=e*o;let r=Number(a&u);a>>=h,r>o&&(r-=d,a+=Q);const i=t,f=t+Math.abs(r)-1,p=e%2!==0,m=r<0;0===r?c=c.add(n(p,s[i])):l=l.add(n(m,s[f]))}return{p:l,f:c}},wNAFCached(e,t,n,r){const s=e._WINDOW_SIZE||1;let a=t.get(e);return a||(a=this.precomputeWindow(e,s),1!==s&&t.set(e,r(a))),this.wNAF(s,a,n)}}}(d,t.endo?Math.ceil(f/2):f);return{CURVE:t,ProjectivePoint:d,normPrivateKeyToScalar:l,weierstrassEquation:a,isWithinCurveOrder:i}}function ne(e){const t=function(e){const t=K(e);return N(t,{hash:"hash",hmac:"function",randomBytes:"function"},{bits2int:"function",bits2int_modN:"function",lowS:"boolean"}),Object.freeze((0,H.A)({lowS:!0},t))}(e),{Fp:n,n:r}=t,s=n.BYTES+1,a=2*n.BYTES+1;function i(e){return j(e,r)}function o(e){return L(e,r)}const{ProjectivePoint:l,normPrivateKeyToScalar:c,weierstrassEquation:u,isWithinCurveOrder:d}=te((0,H.A)((0,H.A)({},t),{},{toBytes(e,t,r){const s=t.toAffine(),a=n.toBytes(s.x),i=A;return r?i(Uint8Array.from([t.hasEvenY()?2:3]),a):i(Uint8Array.from([4]),a,n.toBytes(s.y))},fromBytes(e){const t=e.length,r=e[0],i=e.subarray(1);if(t!==s||2!==r&&3!==r){if(t===a&&4===r){return{x:n.fromBytes(i.subarray(0,n.BYTES)),y:n.fromBytes(i.subarray(n.BYTES,2*n.BYTES))}}throw new Error("Point of length ".concat(t," was invalid. Expected ").concat(s," compressed bytes or ").concat(a," uncompressed bytes"))}{const e=m(i);if(!(Z<(o=e)&&o<n.ORDER))throw new Error("Point is not on curve");const t=u(e);let s=n.sqrt(t);return 1===(1&r)!==((s&$)===$)&&(s=n.neg(s)),{x:e,y:s}}var o}})),f=e=>h(y(e,t.nByteLength));function x(e){return e>r>>$}const S=(e,t,n)=>m(e.slice(t,n));class E{constructor(e,t,n){this.r=e,this.s=t,this.recovery=n,this.assertValidity()}static fromCompact(e){const n=t.nByteLength;return e=v("compactSignature",e,2*n),new E(S(e,0,n),S(e,n,2*n))}static fromDER(e){const{r:t,s:n}=X.toSig(v("DER",e));return new E(t,n)}assertValidity(){if(!d(this.r))throw new Error("r must be 0 < r < CURVE.n");if(!d(this.s))throw new Error("s must be 0 < s < CURVE.n")}addRecoveryBit(e){return new E(this.r,this.s,e)}recoverPublicKey(e){const{r:r,s:s,recovery:a}=this,c=R(v("msgHash",e));if(null==a||![0,1,2,3].includes(a))throw new Error("recovery id invalid");const u=2===a||3===a?r+t.n:r;if(u>=n.ORDER)throw new Error("recovery id 2 or 3 invalid");const d=0===(1&a)?"02":"03",h=l.fromHex(d+f(u)),p=o(u),m=i(-c*p),g=i(s*p),y=l.BASE.multiplyAndAddUnsafe(h,m,g);if(!y)throw new Error("point at infinify");return y.assertValidity(),y}hasHighS(){return x(this.s)}normalizeS(){return this.hasHighS()?new E(this.r,i(-this.s),this.recovery):this}toDERRawBytes(){return p(this.toDERHex())}toDERHex(){return X.hexFromSig({r:this.r,s:this.s})}toCompactRawBytes(){return p(this.toCompactHex())}toCompactHex(){return f(this.r)+f(this.s)}}const k={isValidPrivateKey(e){try{return c(e),!0}catch(t){return!1}},normPrivateKeyToScalar:c,randomPrivateKey:()=>{const e=z(t.n);return function(e,t){let n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const r=e.length,s=W(t),a=z(t);if(r<16||r<a||r>1024)throw new Error("expected ".concat(a,"-1024 bytes of input, got ").concat(r));const i=j(n?m(e):g(e),t-T)+T;return n?w(i,s):y(i,s)}(t.randomBytes(e),t.n)},precompute(){let e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:8,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:l.BASE;return t._setWindowSize(e),t.multiply(BigInt(3)),t}};function I(e){const t=e instanceof Uint8Array,n="string"===typeof e,r=(t||n)&&e.length;return t?r===s||r===a:n?r===2*s||r===2*a:e instanceof l}const _=t.bits2int||function(e){const n=m(e),r=8*e.length-t.nBitLength;return r>0?n>>BigInt(r):n},R=t.bits2int_modN||function(e){return i(_(e))},M=b(t.nBitLength);function D(e){if("bigint"!==typeof e)throw new Error("bigint expected");if(!(Z<=e&&e<M))throw new Error("bigint expected < 2^".concat(t.nBitLength));return y(e,t.nByteLength)}function O(e,r){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:P;if(["recovered","canonical"].some(e=>e in s))throw new Error("sign() legacy options not supported");const{hash:a,randomBytes:u}=t;let{lowS:h,prehash:f,extraEntropy:p}=s;null==h&&(h=!0),e=v("msgHash",e),f&&(e=v("prehashed msgHash",a(e)));const m=R(e),g=c(r),y=[D(g),D(m)];if(null!=p){const e=!0===p?u(n.BYTES):p;y.push(v("extraEntropy",e))}const w=A(...y),b=m;return{seed:w,k2sig:function(e){const t=_(e);if(!d(t))return;const n=o(t),r=l.BASE.multiply(t).toAffine(),s=i(r.x);if(s===Z)return;const a=i(n*i(b+s*g));if(a===Z)return;let c=(r.x===s?0:2)|Number(r.y&$),u=a;return h&&x(a)&&(u=function(e){return x(e)?i(-e):e}(a),c^=1),new E(s,u,c)}}}const P={lowS:t.lowS,prehash:!1},B={lowS:t.lowS,prehash:!1};return l.BASE._setWindowSize(8),{CURVE:t,getPublicKey:function(e){let t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return l.fromPrivateKey(e).toRawBytes(t)},getSharedSecret:function(e,t){let n=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];if(I(e))throw new Error("first arg must be private key");if(!I(t))throw new Error("second arg must be public key");return l.fromHex(t).multiply(c(e)).toRawBytes(n)},sign:function(e,n){let r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:P;const{seed:s,k2sig:a}=O(e,n,r),i=t;return C(i.hash.outputLen,i.nByteLength,i.hmac)(s,a)},verify:function(e,n,r){var s;let a=arguments.length>3&&void 0!==arguments[3]?arguments[3]:B;const c=e;if(n=v("msgHash",n),r=v("publicKey",r),"strict"in a)throw new Error("options.strict was renamed to lowS");const{lowS:u,prehash:d}=a;let h,f;try{if("string"===typeof c||c instanceof Uint8Array)try{h=E.fromDER(c)}catch(x){if(!(x instanceof X.Err))throw x;h=E.fromCompact(c)}else{if("object"!==typeof c||"bigint"!==typeof c.r||"bigint"!==typeof c.s)throw new Error("PARSE");{const{r:e,s:t}=c;h=new E(e,t)}}f=l.fromHex(r)}catch(S){if("PARSE"===S.message)throw new Error("signature must be Signature instance, Uint8Array or hex string");return!1}if(u&&h.hasHighS())return!1;d&&(n=t.hash(n));const{r:p,s:m}=h,g=R(n),y=o(m),w=i(g*y),A=i(p*y),b=null===(s=l.BASE.multiplyAndAddUnsafe(f,w,A))||void 0===s?void 0:s.toAffine();return!!b&&i(b.x)===p},ProjectivePoint:l,Signature:E,utils:k}}const re=BigInt("0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffefffffc2f"),se=BigInt("0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141"),ae=BigInt(1),ie=BigInt(2),oe=(e,t)=>(e+t/ie)/t;function le(e){const t=re,n=BigInt(3),r=BigInt(6),s=BigInt(11),a=BigInt(22),i=BigInt(23),o=BigInt(44),l=BigInt(88),c=e*e*e%t,u=c*c*e%t,d=P(u,n,t)*u%t,h=P(d,n,t)*u%t,f=P(h,ie,t)*c%t,p=P(f,s,t)*f%t,m=P(p,a,t)*p%t,g=P(m,o,t)*m%t,y=P(g,l,t)*g%t,w=P(y,o,t)*m%t,v=P(w,n,t)*u%t,A=P(v,i,t)*p%t,b=P(A,r,t)*c%t,x=P(b,ie,t);if(!ce.eql(ce.sqr(x),e))throw new Error("Cannot find square root");return x}const ce=function(e,t){let n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};if(e<=k)throw new Error("Expected Field ORDER > 0, got ".concat(e));const{nBitLength:s,nByteLength:a}=U(e,t);if(a>2048)throw new Error("Field lengths over 2048 bytes are not supported");const i=B(e),o=Object.freeze({ORDER:e,BITS:s,BYTES:a,MASK:b(s),ZERO:k,ONE:T,create:t=>j(t,e),isValid:t=>{if("bigint"!==typeof t)throw new Error("Invalid field element: expected bigint, got ".concat(typeof t));return k<=t&&t<e},is0:e=>e===k,isOdd:e=>(e&T)===T,neg:t=>j(-t,e),eql:(e,t)=>e===t,sqr:t=>j(t*t,e),add:(t,n)=>j(t+n,e),sub:(t,n)=>j(t-n,e),mul:(t,n)=>j(t*n,e),pow:(e,t)=>function(e,t,n){if(n<k)throw new Error("Expected power > 0");if(n===k)return e.ONE;if(n===T)return t;let r=e.ONE,s=t;for(;n>k;)n&T&&(r=e.mul(r,s)),s=e.sqr(s),n>>=T;return r}(o,e,t),div:(t,n)=>j(t*L(n,e),e),sqrN:e=>e*e,addN:(e,t)=>e+t,subN:(e,t)=>e-t,mulN:(e,t)=>e*t,inv:t=>L(t,e),sqrt:r.sqrt||(e=>i(o,e)),invertBatch:e=>function(e,t){const n=new Array(t.length),r=t.reduce((t,r,s)=>e.is0(r)?t:(n[s]=t,e.mul(t,r)),e.ONE),s=e.inv(r);return t.reduceRight((t,r,s)=>e.is0(r)?t:(n[s]=e.mul(t,n[s]),e.mul(t,r)),s),n}(o,e),cmov:(e,t,n)=>n?t:e,toBytes:e=>n?w(e,a):y(e,a),fromBytes:e=>{if(e.length!==a)throw new Error("Fp.fromBytes: expected ".concat(a,", got ").concat(e.length));return n?g(e):m(e)}});return Object.freeze(o)}(re,void 0,void 0,{sqrt:le}),ue=function(e,t){const n=t=>ne((0,H.A)((0,H.A)({},e),function(e){return{hash:e,hmac:function(t){for(var n=arguments.length,r=new Array(n>1?n-1:0),s=1;s<n;s++)r[s-1]=arguments[s];return(0,V.w)(e,t,(0,G.Id)(...r))},randomBytes:G.po}}(t)));return Object.freeze((0,H.A)((0,H.A)({},n(t)),{},{create:n}))}({a:BigInt(0),b:BigInt(7),Fp:ce,n:se,Gx:BigInt("55066263022277343669578718895168534326250603453777594175500187360389116729240"),Gy:BigInt("32670510020758816978083085130507043184471273380659243275938904335757337482424"),h:BigInt(1),lowS:!0,endo:{beta:BigInt("0x7ae96a2b657c07106e64479eac3434e99cf0497512f58995c1396c28719501ee"),splitScalar:e=>{const t=se,n=BigInt("0x3086d221a7d46bcde86c90e49284eb15"),r=-ae*BigInt("0xe4437ed6010e88286f547fa90abfe4c3"),s=BigInt("0x114ca50f7a8e2f3f657c1108d9d44cfd8"),a=n,i=BigInt("0x100000000000000000000000000000000"),o=oe(a*e,t),l=oe(-r*e,t);let c=j(e-o*n-l*s,t),u=j(-o*r-l*a,t);const d=c>i,h=u>i;if(d&&(c=t-c),h&&(u=t-u),c>i||u>i)throw new Error("splitScalar: Endomorphism failed, k="+e);return{k1neg:d,k1:c,k2neg:h,k2:u}}}},o.s);BigInt(0);ue.ProjectivePoint;var de=n(5977),he=n(686),fe=n(2731),pe=n(2876),me=new WeakMap;class ge{constructor(e){(0,s.A)(this,me,void 0),(0,de.MR)(32===(0,he.pO)(e),"invalid private key","privateKey","[REDACTED]"),(0,i.A)(me,this,(0,he.c$)(e))}get privateKey(){return(0,a.A)(me,this)}get publicKey(){return ge.computePublicKey((0,a.A)(me,this))}get compressedPublicKey(){return ge.computePublicKey((0,a.A)(me,this),!0)}sign(e){(0,de.MR)(32===(0,he.pO)(e),"invalid digest length","digest",e);const t=ue.sign((0,he.Lm)(e),(0,he.Lm)((0,a.A)(me,this)),{lowS:!0});return pe.t.from({r:(0,fe.up)(t.r,32),s:(0,fe.up)(t.s,32),v:t.recovery?28:27})}computeSharedSecret(e){const t=ge.computePublicKey(e);return(0,he.c$)(ue.getSharedSecret((0,he.Lm)((0,a.A)(me,this)),(0,he.q5)(t),!1))}static computePublicKey(e,t){let n=(0,he.q5)(e,"key");if(32===n.length){const e=ue.getPublicKey(n,!!t);return(0,he.c$)(e)}if(64===n.length){const e=new Uint8Array(65);e[0]=4,e.set(n,1),n=e}const r=ue.ProjectivePoint.fromHex(n);return(0,he.c$)(r.toRawBytes(t))}static recoverPublicKey(e,t){(0,de.MR)(32===(0,he.pO)(e),"invalid digest length","digest",e);const n=pe.t.from(t);let r=ue.Signature.fromCompact((0,he.Lm)((0,he.xW)([n.r,n.s])));r=r.addRecoveryBit(n.yParity);const s=r.recoverPublicKey((0,he.Lm)(e));return(0,de.MR)(null!=s,"invalid signature for digest","signature",t),"0x"+s.toHex(!1)}static addPoints(e,t,n){const r=ue.ProjectivePoint.fromHex(ge.computePublicKey(e).substring(2)),s=ue.ProjectivePoint.fromHex(ge.computePublicKey(t).substring(2));return"0x"+r.add(s).toHex(!!n)}}},6338(e,t,n){"use strict";n.d(t,{C:()=>u,z:()=>d});var r=n(1009),s=n(4248),a=n(5981),i=n(686),o=n(5977),l=n(2731),c=n(5889);function u(e){return(0,o.MR)("string"===typeof e.address,"invalid address for hashAuthorization","auth.address",e),(0,s.S)((0,i.xW)(["0x05",(0,c.R)([null!=e.chainId?(0,l.c4)(e.chainId):"0x",(0,r.b)(e.address),null!=e.nonce?(0,l.c4)(e.nonce):"0x"])]))}function d(e,t){return(0,a.x)(u(e),t)}},254(e,t,n){"use strict";n.d(t,{id:()=>a});var r=n(4248),s=n(85);function a(e){return(0,r.S)((0,s.YW)(e))}},1300(e,t,n){"use strict";n.d(t,{A:()=>l,l:()=>c});var r=n(4248),s=n(7234),a=n(5981),i=n(686),o=n(85);function l(e){return"string"===typeof e&&(e=(0,o.YW)(e)),(0,r.S)((0,i.xW)([(0,o.YW)(s.M),(0,o.YW)(String(e.length)),e]))}function c(e,t){const n=l(e);return(0,a.x)(n,t)}},3040(e,t,n){"use strict";n.d(t,{Wh:()=>Ae,Q8:()=>ye,uV:()=>we,kM:()=>ve});var r=n(4248),s=n(5977),a=n(85),i=n(686);const o=new Map([[8217,"apostrophe"],[8260,"fraction slash"],[12539,"middle dot"]]);function l(e){return function(e){let t=0;return()=>e[t++]}(function(e){let t=0;function n(){return e[t++]<<8|e[t++]}let r=n(),s=1,a=[0,1];for(let A=1;A<r;A++)a.push(s+=n());let i=n(),o=t;t+=i;let l=0,c=0;function u(){return 0==l&&(c=c<<8|e[t++],l=8),c>>--l&1}const d=2**31,h=d>>>1,f=h>>1,p=d-1;let m=0;for(let A=0;A<31;A++)m=m<<1|u();let g=[],y=0,w=d;for(;;){let e=Math.floor(((m-y+1)*s-1)/w),t=0,n=r;for(;n-t>1;){let r=t+n>>>1;e<a[r]?n=r:t=r}if(0==t)break;g.push(t);let i=y+Math.floor(w*a[t]/s),o=y+Math.floor(w*a[t+1]/s)-1;for(;0==((i^o)&h);)m=m<<1&p|u(),i=i<<1&p,o=o<<1&p|1;for(;i&~o&f;)m=m&h|m<<1&p>>>1|u(),i=i<<1^h,o=(o^h)<<1|h|1;y=i,w=1+o-i}let v=r-4;return g.map(t=>{switch(t-v){case 3:return v+65792+(e[o++]<<16|e[o++]<<8|e[o++]);case 2:return v+256+(e[o++]<<8|e[o++]);case 1:return v+e[o++];default:return t-1}})}(function(e){let t=[];[..."ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"].forEach((e,n)=>t[e.charCodeAt(0)]=n);let n=e.length,r=new Uint8Array(6*n>>3);for(let s=0,a=0,i=0,o=0;s<n;s++)o=o<<6|t[e.charCodeAt(s)],i+=6,i>=8&&(r[a++]=o>>(i-=8));return r}(e)))}function c(e){return 1&e?~e>>1:e>>1}function u(e,t){let n=Array(e);for(let r=0,s=0;r<e;r++)n[r]=s+=c(t());return n}function d(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,n=[];for(;;){let r=e(),s=e();if(!s)break;t+=r;for(let e=0;e<s;e++)n.push(t+e);t+=s+1}return n}function h(e){return p(()=>{let t=d(e);if(t.length)return t})}function f(e){let t=[];for(;;){let n=e();if(0==n)break;t.push(g(n,e))}for(;;){let n=e()-1;if(n<0)break;t.push(y(n,e))}return t.flat()}function p(e){let t=[];for(;;){let n=e(t.length);if(!n)break;t.push(n)}return t}function m(e,t,n){let r=Array(e).fill().map(()=>[]);for(let s=0;s<t;s++)u(e,n).forEach((e,t)=>r[t].push(e));return r}function g(e,t){let n=1+t(),r=t(),s=p(t);return m(s.length,1+e,t).flatMap((e,t)=>{let[a,...i]=e;return Array(s[t]).fill().map((e,t)=>{let s=t*r;return[a+t*n,i.map(e=>e+s)]})})}function y(e,t){return m(1+t(),1+e,t).map(e=>[e[0],e.slice(1)])}function w(e){return"{".concat(function(e){return e.toString(16).toUpperCase().padStart(2,"0")}(e),"}")}function v(e){let t=[];for(let n=0,r=e.length;n<r;){let r=e.codePointAt(n);n+=r<65536?1:2,t.push(r)}return t}function A(e){let t=e.length;if(t<4096)return String.fromCodePoint(...e);let n=[];for(let r=0;r<t;)n.push(String.fromCodePoint(...e.slice(r,r+=4096)));return n.join("")}function b(e,t){let n=e.length,r=n-t.length;for(let s=0;0==r&&s<n;s++)r=e[s]-t[s];return r}const x=44032,S=4352,C=4449,E=4519,N=28,k=588;function T(e){return e>>24&255}function I(e){return 16777215&e}let _,R,M,D;function j(e){return e>=x&&e<55204}function O(e,t){if(e>=S&&e<4371&&t>=C&&t<4470)return x+(e-S)*k+(t-C)*N;if(j(e)&&t>E&&t<4547&&(e-x)%N==0)return e+(t-E);{let n=D.get(e);return n&&(n=n.get(t),n)?n:-1}}function P(e){_||function(){let e=l("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");_=new Map(h(e).flatMap((e,t)=>e.map(e=>[e,t+1<<24]))),R=new Set(d(e)),M=new Map,D=new Map;for(let[t,n]of f(e)){if(!R.has(t)&&2==n.length){let[e,r]=n,s=D.get(e);s||(s=new Map,D.set(e,s)),s.set(r,t)}M.set(t,n.reverse())}}();let t=[],n=[],r=!1;function s(e){let n=_.get(e);n&&(r=!0,e|=n),t.push(e)}for(let a of e)for(;;){if(a<128)t.push(a);else if(j(a)){let e=a-x,t=e%k/N|0,n=e%N;s(S+(e/k|0)),s(C+t),n>0&&s(E+n)}else{let e=M.get(a);e?n.push(...e):s(a)}if(!n.length)break;a=n.pop()}if(r&&t.length>1){let e=T(t[0]);for(let n=1;n<t.length;n++){let r=T(t[n]);if(0==r||e<=r){e=r;continue}let s=n-1;for(;;){let n=t[s+1];if(t[s+1]=t[s],t[s]=n,!s)break;if(e=T(t[--s]),e<=r)break}e=T(t[n])}}return t}function L(e){return P(e).map(I)}function B(e){return function(e){let t=[],n=[],r=-1,s=0;for(let a of e){let e=T(a),i=I(a);if(-1==r)0==e?r=i:t.push(i);else if(s>0&&s>=e)0==e?(t.push(r,...n),n.length=0,r=i):n.push(i),s=e;else{let a=O(r,i);a>=0?r=a:0==s&&0==e?(t.push(r),r=i):(n.push(i),s=e)}}return r>=0&&t.push(r,...n),t}(P(e))}const F=".",U=e=>Array.from(e);function W(e,t){return e.P.has(t)||e.Q.has(t)}class z extends Array{get is_emoji(){return!0}}let H,V,G,J,Q,K,Y,q,X,Z,$,ee;function te(){if(H)return;let e=l("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");const t=()=>d(e),n=()=>new Set(t()),r=(e,t)=>t.forEach(t=>e.add(t));H=new Map(f(e)),V=n(),G=t(),J=new Set(t().map(e=>G[e])),G=new Set(G),Q=n(),K=n();let s=h(e),a=e();const i=()=>{let e=new Set;return t().forEach(t=>r(e,s[t])),r(e,t()),e};Y=p(t=>{let n=p(e).map(e=>e+96);if(n.length){let r=t>=a;return n[0]-=32,n=A(n),r&&(n="Restricted[".concat(n,"]")),{N:n,P:i(),Q:i(),M:!e(),R:r}}}),q=n(),X=new Map;let o=t().concat(U(q)).sort((e,t)=>e-t);o.forEach((t,n)=>{let r=e(),s=o[n]=r?o[n-r]:{V:[],M:new Map};s.V.push(t),q.has(t)||X.set(t,s)});for(let{V:l,M:d}of new Set(X.values())){let e=[];for(let n of l){let t=Y.filter(e=>W(e,n)),s=e.find(e=>{let{G:n}=e;return t.some(e=>n.has(e))});s||(s={G:new Set,V:[]},e.push(s)),s.V.push(n),r(s.G,t)}let t=e.flatMap(e=>U(e.G));for(let{G:n,V:r}of e){let e=new Set(t.filter(e=>!n.has(e)));for(let t of r)d.set(t,e)}}Z=new Set;let c=new Set;const u=e=>Z.has(e)?c.add(e):Z.add(e);for(let l of Y){for(let e of l.P)u(e);for(let e of l.Q)u(e)}for(let l of Z)X.has(l)||c.has(l)||X.set(l,1);r(Z,L(Z)),$=function(e){let t=[],n=d(e);return function e(n,r,s){let{S:a,B:i}=n;if(!(4&a&&s===r[r.length-1])){2&a&&(s=r[r.length-1]),1&a&&t.push(r);for(let t of i)for(let n of t.Q)e(t,[...r,n],s)}}(function t(r){return{S:e(),B:p(()=>{let r=d(e).map(e=>n[e]);if(r.length)return t(r)}),Q:r}}([]),[]),t}(e).map(e=>z.from(e)).sort(b),ee=new Map;for(let l of $){let e=[ee];for(let t of l){let n=e.map(e=>{let n=e.get(t);return n||(n=new Map,e.set(t,n)),n});65039===t?e.push(...n):e=n}for(let t of e)t.V=l}}function ne(e){return(ae(e)?"":"".concat(re(se([e]))," "))+w(e)}function re(e){return'"'.concat(e,'"\u200e')}function se(e){let t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1/0,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:w,r=[];var s;s=e[0],te(),G.has(s)&&r.push("\u25cc"),e.length>t&&(t>>=1,e=[...e.slice(0,t),8230,...e.slice(-t)]);let a=0,i=e.length;for(let o=0;o<i;o++){let t=e[o];ae(t)&&(r.push(A(e.slice(a,o))),r.push(n(t)),a=o+1)}return r.push(A(e.slice(a,i))),r.join("")}function ae(e){return te(),Q.has(e)}function ie(e,t,n){if(!e)return[];te();let r=0;return e.split(F).map(e=>{let s=v(e),a={input:s,offset:r};r+=s.length+1;try{let e,r=a.tokens=de(s,t,n),i=r.length;if(!i)throw new Error("empty label");let l=a.output=r.flat();if(function(e){for(let t=e.lastIndexOf(95);t>0;)if(95!==e[--t])throw new Error("underscore allowed only at start")}(l),!(a.emoji=i>1||r[0].is_emoji)&&l.every(e=>e<128))!function(e){if(e.length>=4&&45==e[2]&&45==e[3])throw new Error('invalid label extension: "'.concat(A(e.slice(0,4)),'"'))}(l),e="ASCII";else{let t=r.flatMap(e=>e.is_emoji?[]:e);if(t.length){if(G.has(l[0]))throw ue("leading combining mark");for(let e=1;e<i;e++){let t=r[e];if(!t.is_emoji&&G.has(t[0]))throw ue('emoji + combining mark: "'.concat(A(r[e-1])," + ").concat(se([t[0]]),'"'))}!function(e){let t=e[0],n=o.get(t);if(n)throw ue("leading ".concat(n));let r=e.length,s=-1;for(let a=1;a<r;a++){t=e[a];let r=o.get(t);if(r){if(s==a)throw ue("".concat(n," + ").concat(r));s=a+1,n=r}}if(s==r)throw ue("trailing ".concat(n))}(l);let n=U(new Set(t)),[s]=function(e){let t=Y;for(let n of e){let e=t.filter(e=>W(e,n));if(!e.length)throw Y.some(e=>W(e,n))?ce(t[0],n):le(n);if(t=e,1==e.length)break}return t}(n);!function(e,t){for(let n of t)if(!W(e,n))throw ce(e,n);if(e.M){let e=L(t);for(let t=1,n=e.length;t<n;t++)if(J.has(e[t])){let r=t+1;for(let s;r<n&&J.has(s=e[r]);r++)for(let n=t;n<r;n++)if(e[n]==s)throw new Error("duplicate non-spacing marks: ".concat(ne(s)));if(r-t>4)throw new Error("excessive non-spacing marks: ".concat(re(se(e.slice(t-1,r)))," (").concat(r-t,"/").concat(4,")"));t=r}}}(s,t),function(e,t){let n,r=[];for(let s of t){let e=X.get(s);if(1===e)return;if(e){let t=e.M.get(s);if(n=n?n.filter(e=>t.has(e)):U(t),!n.length)return}else r.push(s)}if(n)for(let s of n)if(r.every(e=>W(s,e)))throw new Error("whole-script confusable: ".concat(e.N,"/").concat(s.N))}(s,n),e=s.N}else e="Emoji"}a.type=e}catch(i){a.error=i}return a})}function oe(e){return e.map(t=>{let{input:n,error:r,output:s}=t;if(r){let t=r.message;throw new Error(1==e.length?t:"Invalid label ".concat(re(se(n,63)),": ").concat(t))}return A(s)}).join(F)}function le(e){return new Error("disallowed character: ".concat(ne(e)))}function ce(e,t){let n=ne(t),r=Y.find(e=>e.P.has(t));return r&&(n="".concat(r.N," ").concat(n)),new Error("illegal mixture: ".concat(e.N," + ").concat(n))}function ue(e){return new Error("illegal placement: ".concat(e))}function de(e,t,n){let r=[],s=[];for(e=e.slice().reverse();e.length;){let a=fe(e);if(a)s.length&&(r.push(t(s)),s=[]),r.push(n(a));else{let t=e.pop();if(Z.has(t))s.push(t);else{let e=H.get(t);if(e)s.push(...e);else if(!V.has(t))throw le(t)}}}return s.length&&r.push(t(s)),r}function he(e){return e.filter(e=>65039!=e)}function fe(e,t){let n,r=ee,s=e.length;for(;s&&(r=r.get(e[--s]),r);){let{V:a}=r;a&&(n=a,t&&t.push(...e.slice(s).reverse()),e.length=s)}return n}const pe=new Uint8Array(32);function me(e){return(0,s.MR)(0!==e.length,"invalid ENS name; empty component","comp",e),e}function ge(e){const t=(0,a.YW)(ye(e)),n=[];if(0===e.length)return n;let r=0;for(let s=0;s<t.length;s++){46===t[s]&&(n.push(me(t.slice(r,s))),r=s+1)}return(0,s.MR)(r<t.length,"invalid ENS name; empty component","name",e),n.push(me(t.slice(r))),n}function ye(e){try{if(0===e.length)throw new Error("empty label");return function(e){return oe(ie(e,B,he))}(e)}catch(t){(0,s.MR)(!1,"invalid ENS name (".concat(t.message,")"),"name",e)}}function we(e){try{return 0!==ge(e).length}catch(t){}return!1}function ve(e){(0,s.MR)("string"===typeof e,"invalid ENS name; not a string","name",e),(0,s.MR)(e.length,"invalid ENS name (empty label)","name",e);let t=pe;const n=ge(e);for(;n.length;)t=(0,r.S)((0,i.xW)([t,(0,r.S)(n.pop())]));return(0,i.c$)(t)}function Ae(e,t){const n=null!=t?t:63;return(0,s.MR)(n<=255,"DNS encoded label cannot exceed 255","length",n),(0,i.c$)((0,i.xW)(ge(e).map(t=>{(0,s.MR)(t.length<=n,"label ".concat(JSON.stringify(e)," exceeds ").concat(n," bytes"),"name",e);const r=new Uint8Array(t.length+1);return r.set(t,1),r[0]=r.length-1,r})))+"00"}pe.fill(0)},5424(e,t,n){"use strict";n.d(t,{w:()=>L,z:()=>O});var r=n(9790),s=n(5149),a=n(4705),i=n(6562),o=n(2177),l=n(8458),c=n(1009),u=n(4248),d=n(5981),h=n(686),f=n(5977),p=n(2731),m=n(3451),g=n(254);const y=new Uint8Array(32);y.fill(0);const w=BigInt(-1),v=BigInt(0),A=BigInt(1),b=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff");const x=(0,p.up)(A,32),S=(0,p.up)(v,32),C={name:"string",version:"string",chainId:"uint256",verifyingContract:"address",salt:"bytes32"},E=["name","version","chainId","verifyingContract","salt"];function N(e){return function(t){return(0,f.MR)("string"===typeof t,"invalid domain value for ".concat(JSON.stringify(e)),"domain.".concat(e),t),t}}const k={name:N("name"),version:N("version"),chainId:function(e){const t=(0,p.Ab)(e,"domain.chainId");return(0,f.MR)(t>=0,"invalid chain ID","domain.chainId",e),Number.isSafeInteger(t)?Number(t):(0,p.nD)(t)},verifyingContract:function(e){try{return(0,c.b)(e).toLowerCase()}catch(t){}(0,f.MR)(!1,'invalid domain value "verifyingContract"',"domain.verifyingContract",e)},salt:function(e){const t=(0,h.q5)(e,"domain.salt");return(0,f.MR)(32===t.length,'invalid domain value "salt"',"domain.salt",e),(0,h.c$)(t)}};function T(e){{const t=e.match(/^(u?)int(\d+)$/);if(t){const n=""===t[1],r=parseInt(t[2]);(0,f.MR)(r%8===0&&0!==r&&r<=256&&t[2]===String(r),"invalid numeric width","type",e);const s=(0,p.dK)(b,n?r-1:r),a=n?(s+A)*w:v;return function(t){const r=(0,p.Ab)(t,"value");return(0,f.MR)(r>=a&&r<=s,"value out-of-bounds for ".concat(e),"value",r),(0,p.up)(n?(0,p.JJ)(r,256):r,32)}}}{const t=e.match(/^bytes(\d+)$/);if(t){const n=parseInt(t[1]);return(0,f.MR)(0!==n&&n<=32&&t[1]===String(n),"invalid bytes width","type",e),function(t){const r=(0,h.q5)(t);return(0,f.MR)(r.length===n,"invalid length for ".concat(e),"value",t),function(e){const t=(0,h.q5)(e),n=t.length%32;return n?(0,h.xW)([t,y.slice(n)]):(0,h.c$)(t)}(t)}}}switch(e){case"address":return function(e){return(0,h.nx)((0,c.b)(e),32)};case"bool":return function(e){return e?x:S};case"bytes":return function(e){return(0,u.S)(e)};case"string":return function(e){return(0,g.id)(e)}}return null}function I(e,t){return"".concat(e,"(").concat(t.map(e=>{let{name:t,type:n}=e;return n+" "+t}).join(","),")")}function _(e){const t=e.match(/^([^\x5b]*)((\x5b\d*\x5d)*)(\x5b(\d*)\x5d)$/);return t?{base:t[1],index:t[2]+t[4],array:{base:t[1],prefix:t[1]+t[2],count:t[5]?parseInt(t[5]):-1}}:{base:e}}var R=new WeakMap,M=new WeakMap,D=new WeakMap,j=new WeakSet;class O{get types(){return JSON.parse((0,l.A)(R,this))}constructor(e){(0,r.A)(this,j),(0,a.A)(this,"primaryType",void 0),(0,s.A)(this,R,void 0),(0,s.A)(this,M,void 0),(0,s.A)(this,D,void 0),(0,o.A)(M,this,new Map),(0,o.A)(D,this,new Map);const t=new Map,n=new Map,i=new Map,c={};Object.keys(e).forEach(r=>{c[r]=e[r].map(t=>{let{name:n,type:r}=t,{base:s,index:a}=_(r);return"int"!==s||e.int||(s="int256"),"uint"!==s||e.uint||(s="uint256"),{name:n,type:s+(a||"")}}),t.set(r,new Set),n.set(r,[]),i.set(r,new Set)}),(0,o.A)(R,this,JSON.stringify(c));for(const r in c){const s=new Set;for(const a of c[r]){(0,f.MR)(!s.has(a.name),"duplicate variable name ".concat(JSON.stringify(a.name)," in ").concat(JSON.stringify(r)),"types",e),s.add(a.name);const i=_(a.type).base;(0,f.MR)(i!==r,"circular type reference to ".concat(JSON.stringify(i)),"types",e);T(i)||((0,f.MR)(n.has(i),"unknown type ".concat(JSON.stringify(i)),"types",e),n.get(i).push(r),t.get(r).add(i))}}const u=Array.from(n.keys()).filter(e=>0===n.get(e).length);(0,f.MR)(0!==u.length,"missing primary type","types",e),(0,f.MR)(1===u.length,"ambiguous primary types or unused types: ".concat(u.map(e=>JSON.stringify(e)).join(", ")),"types",e),(0,m.n)(this,{primaryType:u[0]}),function r(s,a){(0,f.MR)(!a.has(s),"circular type reference to ".concat(JSON.stringify(s)),"types",e),a.add(s);for(const e of t.get(s))if(n.has(e)){r(e,a);for(const t of a)i.get(t).add(e)}a.delete(s)}(this.primaryType,new Set);for(const[r,s]of i){const e=Array.from(s);e.sort(),(0,l.A)(M,this).set(r,I(r,c[r])+e.map(e=>I(e,c[e])).join(""))}}getEncoder(e){let t=(0,l.A)(D,this).get(e);return t||(t=(0,i.A)(j,this,P).call(this,e),(0,l.A)(D,this).set(e,t)),t}encodeType(e){const t=(0,l.A)(M,this).get(e);return(0,f.MR)(t,"unknown type: ".concat(JSON.stringify(e)),"name",e),t}encodeData(e,t){return this.getEncoder(e)(t)}hashStruct(e,t){return(0,u.S)(this.encodeData(e,t))}encode(e){return this.encodeData(this.primaryType,e)}hash(e){return this.hashStruct(this.primaryType,e)}_visit(e,t,n){if(T(e))return n(e,t);const r=_(e).array;if(r)return(0,f.MR)(-1===r.count||r.count===t.length,"array length mismatch; expected length ".concat(r.count),"value",t),t.map(e=>this._visit(r.prefix,e,n));const s=this.types[e];if(s)return s.reduce((e,r)=>{let{name:s,type:a}=r;return e[s]=this._visit(a,t[s],n),e},{});(0,f.MR)(!1,"unknown type: ".concat(e),"type",e)}visit(e,t){return this._visit(this.primaryType,e,t)}static from(e){return new O(e)}static getPrimaryType(e){return O.from(e).primaryType}static hashStruct(e,t,n){return O.from(t).hashStruct(e,n)}static hashDomain(e){const t=[];for(const n in e){if(null==e[n])continue;const r=C[n];(0,f.MR)(r,"invalid typed-data domain key: ".concat(JSON.stringify(n)),"domain",e),t.push({name:n,type:r})}return t.sort((e,t)=>E.indexOf(e.name)-E.indexOf(t.name)),O.hashStruct("EIP712Domain",{EIP712Domain:t},e)}static encode(e,t,n){return(0,h.xW)(["0x1901",O.hashDomain(e),O.from(t).hash(n)])}static hash(e,t,n){return(0,u.S)(O.encode(e,t,n))}static async resolveNames(e,t,n,r){e=Object.assign({},e);for(const i in e)null==e[i]&&delete e[i];const s={};e.verifyingContract&&!(0,h.Lo)(e.verifyingContract,20)&&(s[e.verifyingContract]="0x");const a=O.from(t);a.visit(n,(e,t)=>("address"!==e||(0,h.Lo)(t,20)||(s[t]="0x"),t));for(const i in s)s[i]=await r(i);return e.verifyingContract&&s[e.verifyingContract]&&(e.verifyingContract=s[e.verifyingContract]),{domain:e,value:n=a.visit(n,(e,t)=>"address"===e&&s[t]?s[t]:t)}}static getPayload(e,t,n){O.hashDomain(e);const r={},s=[];E.forEach(t=>{const n=e[t];null!=n&&(r[t]=k[t](n),s.push({name:t,type:C[t]}))});const a=O.from(t);t=a.types;const i=Object.assign({},t);return(0,f.MR)(null==i.EIP712Domain,"types must not contain EIP712Domain type","types.EIP712Domain",t),i.EIP712Domain=s,a.encode(n),{types:i,domain:r,primaryType:a.primaryType,message:a.visit(n,(e,t)=>{if(e.match(/^bytes(\d*)/))return(0,h.c$)((0,h.q5)(t));if(e.match(/^u?int/))return(0,p.Ab)(t).toString();switch(e){case"address":return t.toLowerCase();case"bool":return!!t;case"string":return(0,f.MR)("string"===typeof t,"invalid string","value",t),t}(0,f.MR)(!1,"unsupported type","type",e)})}}}function P(e){{const t=T(e);if(t)return t}const t=_(e).array;if(t){const e=t.prefix,n=this.getEncoder(e);return r=>{(0,f.MR)(-1===t.count||t.count===r.length,"array length mismatch; expected length ".concat(t.count),"value",r);let s=r.map(n);return(0,l.A)(M,this).has(e)&&(s=s.map(u.S)),(0,u.S)((0,h.xW)(s))}}const n=this.types[e];if(n){const t=(0,g.id)((0,l.A)(M,this).get(e));return e=>{const r=n.map(t=>{let{name:n,type:r}=t;const s=this.getEncoder(r)(e[n]);return(0,l.A)(M,this).has(r)?(0,u.S)(s):s});return r.unshift(t),(0,h.xW)(r)}}(0,f.MR)(!1,"unknown type: ".concat(e),"type",e)}function L(e,t,n,r){return(0,d.x)(O.hash(e,t,n),r)}},3404(e,t,n){"use strict";n.d(t,{Q:()=>oe,J:()=>H});var r=n(9790),s=n(5149),a=n(6562),i=n(8458),o=n(2177),l=n(4705),c=n(1132),u=n(1009),d=n(8152),h=n(4759),f=n(3040),p=n(4681),m=n(3451),g=n(686),y=n(5977),w=n(9197),v=n(2731),A=n(7867),b=n(85),x=n(4170),S=n(4410),C=n(2876),E=n(1963);const N=BigInt(0);function k(e,t){return function(n){return null==n?t:e(n)}}function T(e,t){return n=>{if(t&&null==n)return null;if(!Array.isArray(n))throw new Error("not an array");return n.map(t=>e(t))}}function I(e,t){return n=>{const r={};for(const a in e){let i=a;if(t&&a in t&&!(i in n))for(const e of t[a])if(e in n){i=e;break}try{const t=e[a](n[i]);void 0!==t&&(r[a]=t)}catch(s){const e=s instanceof Error?s.message:"not-an-error";(0,y.vA)(!1,"invalid value for value.".concat(a," (").concat(e,")"),"BAD_DATA",{value:n})}}return r}}function _(e){return(0,y.MR)((0,g.Lo)(e,!0),"invalid data","value",e),e}function R(e){return(0,y.MR)((0,g.Lo)(e,32),"invalid hash","value",e),e}const M=I({address:u.b,blockHash:R,blockNumber:v.WZ,data:_,index:v.WZ,removed:k(function(e){switch(e){case!0:case"true":return!0;case!1:case"false":return!1}(0,y.MR)(!1,"invalid boolean; ".concat(JSON.stringify(e)),"value",e)},!1),topics:T(R),transactionHash:R,transactionIndex:v.WZ},{index:["logIndex"]});const D=I({hash:k(R),parentHash:R,parentBeaconBlockRoot:k(R,null),number:v.WZ,timestamp:v.WZ,nonce:k(_),difficulty:v.Ab,gasLimit:v.Ab,gasUsed:v.Ab,stateRoot:k(R,null),receiptsRoot:k(R,null),blobGasUsed:k(v.Ab,null),excessBlobGas:k(v.Ab,null),miner:k(u.b),prevRandao:k(R,null),extraData:_,baseFeePerGas:k(v.Ab)},{prevRandao:["mixHash"]});const j=I({transactionIndex:v.WZ,blockNumber:v.WZ,transactionHash:R,address:u.b,topics:T(R),data:_,index:v.WZ,blockHash:R},{index:["logIndex"]});const O=I({to:k(u.b,null),from:k(u.b,null),contractAddress:k(u.b,null),index:v.WZ,root:k(g.c$),gasUsed:v.Ab,blobGasUsed:k(v.Ab,null),logsBloom:k(_),blockHash:R,hash:R,logs:T(function(e){return j(e)}),blockNumber:v.WZ,cumulativeGasUsed:v.Ab,effectiveGasPrice:k(v.Ab),blobGasPrice:k(v.Ab,null),status:k(v.WZ),type:k(v.WZ,0)},{effectiveGasPrice:["gasPrice"],hash:["transactionHash"],index:["transactionIndex"]});function P(e){e.to&&(0,v.Ab)(e.to)===N&&(e.to="0x0000000000000000000000000000000000000000");const t=I({hash:R,index:k(v.WZ,void 0),type:e=>"0x"===e||null==e?0:(0,v.WZ)(e),accessList:k(E.$,null),blobVersionedHashes:k(T(R,!0),null),authorizationList:k(T(e=>{let t;if(e.signature)t=e.signature;else{let n=e.yParity;"0x1b"===n?n=0:"0x1c"===n&&(n=1),t=Object.assign({},e,{yParity:n})}return{address:(0,u.b)(e.address),chainId:(0,v.Ab)(e.chainId),nonce:(0,v.Ab)(e.nonce),signature:C.t.from(t)}},!1),null),blockHash:k(R,null),blockNumber:k(v.WZ,null),transactionIndex:k(v.WZ,null),from:u.b,gasPrice:k(v.Ab),maxPriorityFeePerGas:k(v.Ab),maxFeePerGas:k(v.Ab),maxFeePerBlobGas:k(v.Ab,null),gasLimit:v.Ab,to:k(u.b,null),value:v.Ab,nonce:v.WZ,data:_,creates:k(u.b,null),chainId:k(v.Ab,null)},{data:["input"],gasLimit:["gas"],index:["transactionIndex"]})(e);if(null==t.to&&null==t.creates&&(t.creates=(0,S.t)(t)),1!==e.type&&2!==e.type||null!=e.accessList||(t.accessList=[]),e.signature?t.signature=C.t.from(e.signature):t.signature=C.t.from(e),null==t.chainId){const e=t.signature.legacyChainId;null!=e&&(t.chainId=e)}return t.blockHash&&(0,v.Ab)(t.blockHash)===N&&(t.blockHash=null),t}var L=n(4105),B=n(7750),F=n(9123);const U=BigInt(2);function W(e){return e&&"function"===typeof e.then}function z(e,t){return e+":"+JSON.stringify(t,(e,t)=>{if(null==t)return"null";if("bigint"===typeof t)return"bigint:".concat(t.toString());if("string"===typeof t)return t.toLowerCase();if("object"===typeof t&&!Array.isArray(t)){const e=Object.keys(t);return e.sort(),e.reduce((e,n)=>(e[n]=t[n],e),{})}return t})}class H{constructor(e){(0,l.A)(this,"name",void 0),(0,m.n)(this,{name:e})}start(){}stop(){}pause(e){}resume(){}}function V(e){return(e=Array.from(new Set(e).values())).sort(),e}async function G(e,t){if(null==e)throw new Error("invalid event");if(Array.isArray(e)&&(e={topics:e}),"string"===typeof e)switch(e){case"block":case"debug":case"error":case"finalized":case"network":case"pending":case"safe":return{type:e,tag:e}}if((0,g.Lo)(e,32)){const t=e.toLowerCase();return{type:"transaction",tag:z("tx",{hash:t}),hash:t}}if(e.orphan){const t=e;return{type:"orphan",tag:z("orphan",t),filter:(n=t,JSON.parse(JSON.stringify(n)))}}var n;if(e.address||e.topics){const n=e,r={topics:(n.topics||[]).map(e=>null==e?null:Array.isArray(e)?V(e.map(e=>e.toLowerCase())):e.toLowerCase())};if(n.address){const e=[],s=[],a=n=>{(0,g.Lo)(n)?e.push(n):s.push((async()=>{e.push(await(0,c.tG)(n,t))})())};Array.isArray(n.address)?n.address.forEach(a):a(n.address),s.length&&await Promise.all(s),r.address=V(e.map(e=>e.toLowerCase()))}return{filter:r,tag:z("event",r),type:"event"}}(0,y.MR)(!1,"unknown ProviderEvent","event",e)}function J(){return(new Date).getTime()}const Q={cacheTimeout:250,pollingInterval:4e3};var K=new WeakMap,Y=new WeakMap,q=new WeakMap,X=new WeakMap,Z=new WeakMap,$=new WeakMap,ee=new WeakMap,te=new WeakMap,ne=new WeakMap,re=new WeakMap,se=new WeakMap,ae=new WeakMap,ie=new WeakSet;class oe{constructor(e,t){if((0,r.A)(this,ie),(0,s.A)(this,K,void 0),(0,s.A)(this,Y,void 0),(0,s.A)(this,q,void 0),(0,s.A)(this,X,void 0),(0,s.A)(this,Z,void 0),(0,s.A)(this,$,void 0),(0,s.A)(this,ee,void 0),(0,s.A)(this,te,void 0),(0,s.A)(this,ne,void 0),(0,s.A)(this,re,void 0),(0,s.A)(this,se,void 0),(0,s.A)(this,ae,void 0),(0,o.A)(ae,this,Object.assign({},Q,t||{})),"any"===e)(0,o.A)($,this,!0),(0,o.A)(Z,this,null);else if(e){const t=L.l.from(e);(0,o.A)($,this,!1),(0,o.A)(Z,this,Promise.resolve(t)),setTimeout(()=>{this.emit("network",t,null)},0)}else(0,o.A)($,this,!1),(0,o.A)(Z,this,null);(0,o.A)(te,this,-1),(0,o.A)(ee,this,new Map),(0,o.A)(K,this,new Map),(0,o.A)(Y,this,new Map),(0,o.A)(q,this,null),(0,o.A)(X,this,!1),(0,o.A)(ne,this,1),(0,o.A)(re,this,new Map),(0,o.A)(se,this,!1)}get pollingInterval(){return(0,i.A)(ae,this).pollingInterval}get provider(){return this}get plugins(){return Array.from((0,i.A)(Y,this).values())}attachPlugin(e){if((0,i.A)(Y,this).get(e.name))throw new Error("cannot replace existing plugin: ".concat(e.name," "));return(0,i.A)(Y,this).set(e.name,e.connect(this)),this}getPlugin(e){return(0,i.A)(Y,this).get(e)||null}get disableCcipRead(){return(0,i.A)(se,this)}set disableCcipRead(e){(0,o.A)(se,this,!!e)}async ccipReadFetch(e,t,n){if(this.disableCcipRead||0===n.length||null==e.to)return null;const r=e.to.toLowerCase(),s=t.toLowerCase(),a=[];for(let o=0;o<n.length;o++){const t=n[o],l=t.replace("{sender}",r).replace("{data}",s),c=new w.ui(l);-1===t.indexOf("{data}")&&(c.body={data:s,sender:r}),this.emit("debug",{action:"sendCcipReadFetchRequest",request:c,index:o,urls:n});let u,d="unknown error";try{u=await c.send()}catch(i){a.push(i.message),this.emit("debug",{action:"receiveCcipReadFetchError",request:c,result:{error:i}});continue}try{const e=u.bodyJson;if(e.data)return this.emit("debug",{action:"receiveCcipReadFetchResult",request:c,result:e}),e.data;e.message&&(d=e.message),this.emit("debug",{action:"receiveCcipReadFetchError",request:c,result:e})}catch(i){}(0,y.vA)(u.statusCode<400||u.statusCode>=500,"response not found during CCIP fetch: ".concat(d),"OFFCHAIN_FAULT",{reason:"404_MISSING_RESOURCE",transaction:e,info:{url:t,errorMessage:d}}),a.push(d)}(0,y.vA)(!1,"error encountered during CCIP fetch: ".concat(a.map(e=>JSON.stringify(e)).join(", ")),"OFFCHAIN_FAULT",{reason:"500_SERVER_ERROR",transaction:e,info:{urls:n,errorMessages:a}})}_wrapBlock(e,t){return new B.eB(function(e){const t=D(e);return t.transactions=e.transactions.map(e=>"string"===typeof e?e:P(e)),t}(e),this)}_wrapLog(e,t){return new B.tG(function(e){return M(e)}(e),this)}_wrapTransactionReceipt(e,t){return new B.z5(function(e){return O(e)}(e),this)}_wrapTransactionResponse(e,t){return new B.uI(P(e),this)}_detectNetwork(){(0,y.vA)(!1,"sub-classes must implement this","UNSUPPORTED_OPERATION",{operation:"_detectNetwork"})}async _perform(e){(0,y.vA)(!1,"unsupported method: ".concat(e.method),"UNSUPPORTED_OPERATION",{operation:e.method,info:e})}async getBlockNumber(){const e=(0,v.WZ)(await(0,a.A)(ie,this,le).call(this,{method:"getBlockNumber"}),"%response");return(0,i.A)(te,this)>=0&&(0,o.A)(te,this,e),e}_getAddress(e){return(0,c.tG)(e,this)}_getBlockTag(e){if(null==e)return"latest";switch(e){case"earliest":return"0x0";case"finalized":case"latest":case"pending":case"safe":return e}return(0,g.Lo)(e)?(0,g.Lo)(e,32)?e:(0,v.nD)(e):("bigint"===typeof e&&(e=(0,v.WZ)(e,"blockTag")),"number"===typeof e?e>=0?(0,v.nD)(e):(0,i.A)(te,this)>=0?(0,v.nD)((0,i.A)(te,this)+e):this.getBlockNumber().then(t=>(0,v.nD)(t+e)):void(0,y.MR)(!1,"invalid blockTag","blockTag",e))}_getFilter(e){const t=(e.topics||[]).map(e=>null==e?null:Array.isArray(e)?V(e.map(e=>e.toLowerCase())):e.toLowerCase()),n="blockHash"in e?e.blockHash:void 0,r=(e,r,s)=>{let a;switch(e.length){case 0:break;case 1:a=e[0];break;default:e.sort(),a=e}if(n&&(null!=r||null!=s))throw new Error("invalid filter");const i={};return a&&(i.address=a),t.length&&(i.topics=t),r&&(i.fromBlock=r),s&&(i.toBlock=s),n&&(i.blockHash=n),i};let s,a,i=[];if(e.address)if(Array.isArray(e.address))for(const o of e.address)i.push(this._getAddress(o));else i.push(this._getAddress(e.address));return"fromBlock"in e&&(s=this._getBlockTag(e.fromBlock)),"toBlock"in e&&(a=this._getBlockTag(e.toBlock)),i.filter(e=>"string"!==typeof e).length||null!=s&&"string"!==typeof s||null!=a&&"string"!==typeof a?Promise.all([Promise.all(i),s,a]).then(e=>r(e[0],e[1],e[2])):r(i,s,a)}_getTransactionRequest(e){const t=(0,B.VS)(e),n=[];if(["to","from"].forEach(e=>{if(null==t[e])return;const r=(0,c.tG)(t[e],this);W(r)?n.push(async function(){t[e]=await r}()):t[e]=r}),null!=t.blockTag){const e=this._getBlockTag(t.blockTag);W(e)?n.push(async function(){t.blockTag=await e}()):t.blockTag=e}return n.length?async function(){return await Promise.all(n),t}():t}async getNetwork(){if(null==(0,i.A)(Z,this)){const e=(async()=>{try{const e=await this._detectNetwork();return this.emit("network",e,null),e}catch(t){throw(0,i.A)(Z,this)===e&&(0,o.A)(Z,this,null),t}})();return(0,o.A)(Z,this,e),(await e).clone()}const e=(0,i.A)(Z,this),[t,n]=await Promise.all([e,this._detectNetwork()]);return t.chainId!==n.chainId&&((0,i.A)($,this)?(this.emit("network",n,t),(0,i.A)(Z,this)===e&&(0,o.A)(Z,this,Promise.resolve(n))):(0,y.vA)(!1,"network changed: ".concat(t.chainId," => ").concat(n.chainId," "),"NETWORK_ERROR",{event:"changed"})),t.clone()}async getFeeData(){const e=await this.getNetwork(),t=async()=>{const{_block:t,gasPrice:n,priorityFee:r}=await(0,m.k)({_block:(0,a.A)(ie,this,he).call(this,"latest",!1),gasPrice:(async()=>{try{const e=await(0,a.A)(ie,this,le).call(this,{method:"getGasPrice"});return(0,v.Ab)(e,"%response")}catch(e){}return null})(),priorityFee:(async()=>{try{const e=await(0,a.A)(ie,this,le).call(this,{method:"getPriorityFee"});return(0,v.Ab)(e,"%response")}catch(e){}return null})()});let s=null,i=null;const o=this._wrapBlock(t,e);return o&&o.baseFeePerGas&&(i=null!=r?r:BigInt("1000000000"),s=o.baseFeePerGas*U+i),new B.J9(n,s,i)},n=e.getPlugin("org.ethers.plugins.network.FetchUrlFeeDataPlugin");if(n){const e=new w.ui(n.url),r=await n.processFunc(t,this,e);return new B.J9(r.gasPrice,r.maxFeePerGas,r.maxPriorityFeePerGas)}return await t()}async estimateGas(e){let t=this._getTransactionRequest(e);return W(t)&&(t=await t),(0,v.Ab)(await(0,a.A)(ie,this,le).call(this,{method:"estimateGas",transaction:t}),"%response")}async call(e){const{tx:t,blockTag:n}=await(0,m.k)({tx:this._getTransactionRequest(e),blockTag:this._getBlockTag(e.blockTag)});return await(0,a.A)(ie,this,ue).call(this,(0,a.A)(ie,this,ce).call(this,t,n,e.enableCcipRead?0:-1))}async getBalance(e,t){return(0,v.Ab)(await(0,a.A)(ie,this,de).call(this,{method:"getBalance"},e,t),"%response")}async getTransactionCount(e,t){return(0,v.WZ)(await(0,a.A)(ie,this,de).call(this,{method:"getTransactionCount"},e,t),"%response")}async getCode(e,t){return(0,g.c$)(await(0,a.A)(ie,this,de).call(this,{method:"getCode"},e,t))}async getStorage(e,t,n){const r=(0,v.Ab)(t,"position");return(0,g.c$)(await(0,a.A)(ie,this,de).call(this,{method:"getStorage",position:r},e,n))}async broadcastTransaction(e){const{blockNumber:t,hash:n,network:r}=await(0,m.k)({blockNumber:this.getBlockNumber(),hash:this._perform({method:"broadcastTransaction",signedTransaction:e}),network:this.getNetwork()}),s=p.Z.from(e);if(s.hash!==n)throw new Error("@TODO: the returned hash did not match");return this._wrapTransactionResponse(s,r).replaceableTransaction(t)}async getBlock(e,t){const{network:n,params:r}=await(0,m.k)({network:this.getNetwork(),params:(0,a.A)(ie,this,he).call(this,e,!!t)});return null==r?null:this._wrapBlock(r,n)}async getTransaction(e){const{network:t,params:n}=await(0,m.k)({network:this.getNetwork(),params:(0,a.A)(ie,this,le).call(this,{method:"getTransaction",hash:e})});return null==n?null:this._wrapTransactionResponse(n,t)}async getTransactionReceipt(e){const{network:t,params:n}=await(0,m.k)({network:this.getNetwork(),params:(0,a.A)(ie,this,le).call(this,{method:"getTransactionReceipt",hash:e})});if(null==n)return null;if(null==n.gasPrice&&null==n.effectiveGasPrice){const t=await(0,a.A)(ie,this,le).call(this,{method:"getTransaction",hash:e});if(null==t)throw new Error("report this; could not find tx or effectiveGasPrice");n.effectiveGasPrice=t.gasPrice}return this._wrapTransactionReceipt(n,t)}async getTransactionResult(e){const{result:t}=await(0,m.k)({network:this.getNetwork(),result:(0,a.A)(ie,this,le).call(this,{method:"getTransactionResult",hash:e})});return null==t?null:(0,g.c$)(t)}async getLogs(e){let t=this._getFilter(e);W(t)&&(t=await t);const{network:n,params:r}=await(0,m.k)({network:this.getNetwork(),params:(0,a.A)(ie,this,le).call(this,{method:"getLogs",filter:t})});return r.map(e=>this._wrapLog(e,n))}_getProvider(e){(0,y.vA)(!1,"provider cannot connect to target network","UNSUPPORTED_OPERATION",{operation:"_getProvider()"})}async getResolver(e){return await x.Pz.fromName(this,e)}async getAvatar(e){const t=await this.getResolver(e);return t?await t.getAvatar():null}async resolveName(e){const t=await this.getResolver(e);return t?await t.getAddress():null}async lookupAddress(e){e=(0,u.b)(e);const t=(0,f.kM)(e.substring(2).toLowerCase()+".addr.reverse");try{const n=await x.Pz.getEnsAddress(this),r=new h.NZ(n,["function resolver(bytes32) view returns (address)"],this),s=await r.resolver(t);if(null==s||s===d.j)return null;const a=new h.NZ(s,["function name(bytes32) view returns (string)"],this),i=await a.name(t);return await this.resolveName(i)!==e?null:i}catch(n){if((0,y.bJ)(n,"BAD_DATA")&&"0x"===n.value)return null;if((0,y.bJ)(n,"CALL_EXCEPTION"))return null;throw n}}async waitForTransaction(e,t,n){const r=null!=t?t:1;return 0===r?this.getTransactionReceipt(e):new Promise(async(t,s)=>{let a=null;const i=async n=>{try{const s=await this.getTransactionReceipt(e);if(null!=s&&n-s.blockNumber+1>=r)return t(s),void(a&&(clearTimeout(a),a=null))}catch(s){console.log("EEE",s)}this.once("block",i)};null!=n&&(a=setTimeout(()=>{null!=a&&(a=null,this.off("block",i),s((0,y.xz)("timeout","TIMEOUT",{reason:"timeout"})))},n)),i(await this.getBlockNumber())})}async waitForBlock(e){(0,y.vA)(!1,"not implemented yet","NOT_IMPLEMENTED",{operation:"waitForBlock"})}_clearTimeout(e){const t=(0,i.A)(re,this).get(e);t&&(t.timer&&clearTimeout(t.timer),(0,i.A)(re,this).delete(e))}_setTimeout(e,t){var n,r;null==t&&(t=0);const s=((0,o.A)(ne,this,(n=(0,i.A)(ne,this),r=n++,n)),r),a=()=>{(0,i.A)(re,this).delete(s),e()};if(this.paused)(0,i.A)(re,this).set(s,{timer:null,func:a,time:t});else{const e=setTimeout(a,t);(0,i.A)(re,this).set(s,{timer:e,func:a,time:J()})}return s}_forEachSubscriber(e){for(const t of(0,i.A)(K,this).values())e(t.subscriber)}_getSubscriber(e){switch(e.type){case"debug":case"error":case"network":return new H(e.type);case"block":{const e=new F.bs(this);return e.pollingInterval=this.pollingInterval,e}case"safe":case"finalized":return new F.l8(this,e.type);case"event":return new F.MY(this,e.filter);case"transaction":return new F.AC(this,e.hash);case"orphan":return new F.wF(this,e.filter)}throw new Error("unsupported event: ".concat(e.type))}_recoverSubscriber(e,t){for(const n of(0,i.A)(K,this).values())if(n.subscriber===e){n.started&&n.subscriber.stop(),n.subscriber=t,n.started&&t.start(),null!=(0,i.A)(q,this)&&t.pause((0,i.A)(q,this));break}}async on(e,t){const n=await(0,a.A)(ie,this,pe).call(this,e);return n.listeners.push({listener:t,once:!1}),n.started||(n.subscriber.start(),n.started=!0,null!=(0,i.A)(q,this)&&n.subscriber.pause((0,i.A)(q,this))),this}async once(e,t){const n=await(0,a.A)(ie,this,pe).call(this,e);return n.listeners.push({listener:t,once:!0}),n.started||(n.subscriber.start(),n.started=!0,null!=(0,i.A)(q,this)&&n.subscriber.pause((0,i.A)(q,this))),this}async emit(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];const s=await(0,a.A)(ie,this,fe).call(this,e,n);if(!s||0===s.listeners.length)return!1;const o=s.listeners.length;return s.listeners=s.listeners.filter(t=>{let{listener:r,once:s}=t;const a=new A.z(this,s?null:r,e);try{r.call(this,...n,a)}catch(i){}return!s}),0===s.listeners.length&&(s.started&&s.subscriber.stop(),(0,i.A)(K,this).delete(s.tag)),o>0}async listenerCount(e){if(e){const t=await(0,a.A)(ie,this,fe).call(this,e);return t?t.listeners.length:0}let t=0;for(const{listeners:n}of(0,i.A)(K,this).values())t+=n.length;return t}async listeners(e){if(e){const t=await(0,a.A)(ie,this,fe).call(this,e);return t?t.listeners.map(e=>{let{listener:t}=e;return t}):[]}let t=[];for(const{listeners:n}of(0,i.A)(K,this).values())t=t.concat(n.map(e=>{let{listener:t}=e;return t}));return t}async off(e,t){const n=await(0,a.A)(ie,this,fe).call(this,e);if(!n)return this;if(t){const e=n.listeners.map(e=>{let{listener:t}=e;return t}).indexOf(t);e>=0&&n.listeners.splice(e,1)}return t&&0!==n.listeners.length||(n.started&&n.subscriber.stop(),(0,i.A)(K,this).delete(n.tag)),this}async removeAllListeners(e){if(e){const{tag:t,started:n,subscriber:r}=await(0,a.A)(ie,this,pe).call(this,e);n&&r.stop(),(0,i.A)(K,this).delete(t)}else for(const[t,{started:n,subscriber:r}]of(0,i.A)(K,this))n&&r.stop(),(0,i.A)(K,this).delete(t);return this}async addListener(e,t){return await this.on(e,t)}async removeListener(e,t){return this.off(e,t)}get destroyed(){return(0,i.A)(X,this)}destroy(){this.removeAllListeners();for(const e of(0,i.A)(re,this).keys())this._clearTimeout(e);(0,o.A)(X,this,!0)}get paused(){return null!=(0,i.A)(q,this)}set paused(e){!!e!==this.paused&&(this.paused?this.resume():this.pause(!1))}pause(e){if((0,o.A)(te,this,-1),null!=(0,i.A)(q,this)){if((0,i.A)(q,this)==!!e)return;(0,y.vA)(!1,"cannot change pause type; resume first","UNSUPPORTED_OPERATION",{operation:"pause"})}this._forEachSubscriber(t=>t.pause(e)),(0,o.A)(q,this,!!e);for(const t of(0,i.A)(re,this).values())t.timer&&clearTimeout(t.timer),t.time=J()-t.time}resume(){if(null!=(0,i.A)(q,this)){this._forEachSubscriber(e=>e.resume()),(0,o.A)(q,this,null);for(const e of(0,i.A)(re,this).values()){let t=e.time;t<0&&(t=0),e.time=J(),setTimeout(e.func,t)}}}}async function le(e){const t=(0,i.A)(ae,this).cacheTimeout;if(t<0)return await this._perform(e);const n=z(e.method,e);let r=(0,i.A)(ee,this).get(n);return r||(r=this._perform(e),(0,i.A)(ee,this).set(n,r),setTimeout(()=>{(0,i.A)(ee,this).get(n)===r&&(0,i.A)(ee,this).delete(n)},t)),await r}async function ce(e,t,n){(0,y.vA)(n<10,"CCIP read exceeded maximum redirections","OFFCHAIN_FAULT",{reason:"TOO_MANY_REDIRECTS",transaction:Object.assign({},e,{blockTag:t,enableCcipRead:!0})});const r=(0,B.VS)(e);try{return(0,g.c$)(await this._perform({method:"call",transaction:r,blockTag:t}))}catch(s){if(!this.disableCcipRead&&(0,y.E)(s)&&s.data&&n>=0&&"latest"===t&&null!=r.to&&"0x556f1830"===(0,g.ZG)(s.data,0,4)){const e=s.data,i=await(0,c.tG)(r.to,this);let o;try{o=function(e){const t={sender:"",urls:[],calldata:"",selector:"",extraData:"",errorArgs:[]};(0,y.vA)((0,g.pO)(e)>=160,"insufficient OffchainLookup data","OFFCHAIN_FAULT",{reason:"insufficient OffchainLookup data"});const n=(0,g.ZG)(e,0,32);(0,y.vA)((0,g.ZG)(n,0,12)===(0,g.ZG)(be,0,12),"corrupt OffchainLookup sender","OFFCHAIN_FAULT",{reason:"corrupt OffchainLookup sender"}),t.sender=(0,g.ZG)(n,12);try{const n=[],r=(0,v.WZ)((0,g.ZG)(e,32,64)),s=(0,v.WZ)((0,g.ZG)(e,r,r+32)),a=(0,g.ZG)(e,r+32);for(let e=0;e<s;e++){const t=me(a,32*e);if(null==t)throw new Error("abort");n.push(t)}t.urls=n}catch(s){(0,y.vA)(!1,"corrupt OffchainLookup urls","OFFCHAIN_FAULT",{reason:"corrupt OffchainLookup urls"})}try{const n=ge(e,64);if(null==n)throw new Error("abort");t.calldata=n}catch(s){(0,y.vA)(!1,"corrupt OffchainLookup calldata","OFFCHAIN_FAULT",{reason:"corrupt OffchainLookup calldata"})}(0,y.vA)((0,g.ZG)(e,100,128)===(0,g.ZG)(be,0,28),"corrupt OffchainLookup callbaackSelector","OFFCHAIN_FAULT",{reason:"corrupt OffchainLookup callbaackSelector"}),t.selector=(0,g.ZG)(e,96,100);try{const n=ge(e,128);if(null==n)throw new Error("abort");t.extraData=n}catch(s){(0,y.vA)(!1,"corrupt OffchainLookup extraData","OFFCHAIN_FAULT",{reason:"corrupt OffchainLookup extraData"})}return t.errorArgs="sender,urls,calldata,selector,extraData".split(/,/).map(e=>t[e]),t}((0,g.ZG)(s.data,4))}catch(s){(0,y.vA)(!1,s.message,"OFFCHAIN_FAULT",{reason:"BAD_DATA",transaction:r,info:{data:e}})}(0,y.vA)(o.sender.toLowerCase()===i.toLowerCase(),"CCIP Read sender mismatch","CALL_EXCEPTION",{action:"call",data:e,reason:"OffchainLookup",transaction:r,invocation:null,revert:{signature:"OffchainLookup(address,string[],bytes,bytes4,bytes)",name:"OffchainLookup",args:o.errorArgs}});const l=await this.ccipReadFetch(r,o.calldata,o.urls);(0,y.vA)(null!=l,"CCIP Read failed to fetch data","OFFCHAIN_FAULT",{reason:"FETCH_FAILED",transaction:r,info:{data:s.data,errorArgs:o.errorArgs}});const u={to:i,data:(0,g.xW)([o.selector,Ae([l,o.extraData])])};this.emit("debug",{action:"sendCcipReadCall",transaction:u});try{const e=await(0,a.A)(ie,this,ce).call(this,u,t,n+1);return this.emit("debug",{action:"receiveCcipReadCallResult",transaction:Object.assign({},u),result:e}),e}catch(s){throw this.emit("debug",{action:"receiveCcipReadCallError",transaction:Object.assign({},u),error:s}),s}}throw s}}async function ue(e){const{value:t}=await(0,m.k)({network:this.getNetwork(),value:e});return t}async function de(e,t,n){let r=this._getAddress(t),s=this._getBlockTag(n);return"string"===typeof r&&"string"===typeof s||([r,s]=await Promise.all([r,s])),await(0,a.A)(ie,this,ue).call(this,(0,a.A)(ie,this,le).call(this,Object.assign(e,{address:r,blockTag:s})))}async function he(e,t){if((0,g.Lo)(e,32))return await(0,a.A)(ie,this,le).call(this,{method:"getBlock",blockHash:e,includeTransactions:t});let n=this._getBlockTag(e);return"string"!==typeof n&&(n=await n),await(0,a.A)(ie,this,le).call(this,{method:"getBlock",blockTag:n,includeTransactions:t})}async function fe(e,t){let n=await G(e,this);return"event"===n.type&&t&&t.length>0&&!0===t[0].removed&&(n=await G({orphan:"drop-log",log:t[0]},this)),(0,i.A)(K,this).get(n.tag)||null}async function pe(e){const t=await G(e,this),n=t.tag;let r=(0,i.A)(K,this).get(n);if(!r){r={subscriber:this._getSubscriber(t),tag:n,addressableMap:new WeakMap,nameMap:new Map,started:!1,listeners:[]},(0,i.A)(K,this).set(n,r)}return r}function me(e,t){try{const n=ge(e,t);if(n)return(0,b._v)(n)}catch(n){}return null}function ge(e,t){if("0x"===e)return null;try{const n=(0,v.WZ)((0,g.ZG)(e,t,t+32)),r=(0,v.WZ)((0,g.ZG)(e,n,n+32));return(0,g.ZG)(e,n+32,n+32+r)}catch(n){}return null}function ye(e){const t=(0,v.c4)(e);if(t.length>32)throw new Error("internal; should not happen");const n=new Uint8Array(32);return n.set(t,32-t.length),n}function we(e){if(e.length%32===0)return e;const t=new Uint8Array(32*Math.ceil(e.length/32));return t.set(e),t}const ve=new Uint8Array([]);function Ae(e){const t=[];let n=0;for(let r=0;r<e.length;r++)t.push(ve),n+=32;for(let r=0;r<e.length;r++){const s=(0,g.q5)(e[r]);t[r]=ye(n),t.push(ye(s.length)),t.push(we(s)),n+=32+32*Math.ceil(s.length/32)}return(0,g.xW)(t)}const be="0x0000000000000000000000000000000000000000000000000000000000000000"},1028(e,t,n){"use strict";n.d(t,{J:()=>g,Z:()=>p});var r=n(9790),s=n(6562),a=n(4705),i=n(1132),o=n(4681),l=n(5977),c=n(2731),u=n(3451),d=n(7750);function h(e,t){if(e.provider)return e.provider;(0,l.vA)(!1,"missing provider","UNSUPPORTED_OPERATION",{operation:t})}async function f(e,t){let n=(0,d.VS)(t);if(null!=n.to&&(n.to=(0,i.tG)(n.to,e)),null!=n.from){const t=n.from;n.from=Promise.all([e.getAddress(),(0,i.tG)(t,e)]).then(e=>{let[t,n]=e;return(0,l.MR)(t.toLowerCase()===n.toLowerCase(),"transaction from mismatch","tx.from",n),t})}else n.from=e.getAddress();return await(0,u.k)(n)}class p{constructor(e){(0,a.A)(this,"provider",void 0),(0,u.n)(this,{provider:e||null})}async getNonce(e){return h(this,"getTransactionCount").getTransactionCount(await this.getAddress(),e)}async populateCall(e){return await f(this,e)}async populateTransaction(e){const t=h(this,"populateTransaction"),n=await f(this,e);null==n.nonce&&(n.nonce=await this.getNonce("pending")),null==n.gasLimit&&(n.gasLimit=await this.estimateGas(n));const r=await this.provider.getNetwork();if(null!=n.chainId){const t=(0,c.Ab)(n.chainId);(0,l.MR)(t===r.chainId,"transaction chainId mismatch","tx.chainId",e.chainId)}else n.chainId=r.chainId;const s=null!=n.maxFeePerGas||null!=n.maxPriorityFeePerGas;if(null==n.gasPrice||2!==n.type&&!s?0!==n.type&&1!==n.type||!s||(0,l.MR)(!1,"pre-eip-1559 transaction do not support maxFeePerGas/maxPriorityFeePerGas","tx",e):(0,l.MR)(!1,"eip-1559 transaction do not support gasPrice","tx",e),2!==n.type&&null!=n.type||null==n.maxFeePerGas||null==n.maxPriorityFeePerGas)if(0===n.type||1===n.type){const e=await t.getFeeData();(0,l.vA)(null!=e.gasPrice,"network does not support gasPrice","UNSUPPORTED_OPERATION",{operation:"getGasPrice"}),null==n.gasPrice&&(n.gasPrice=e.gasPrice)}else{const e=await t.getFeeData();if(null==n.type)if(null!=e.maxFeePerGas&&null!=e.maxPriorityFeePerGas)if(n.authorizationList&&n.authorizationList.length?n.type=4:n.type=2,null!=n.gasPrice){const e=n.gasPrice;delete n.gasPrice,n.maxFeePerGas=e,n.maxPriorityFeePerGas=e}else null==n.maxFeePerGas&&(n.maxFeePerGas=e.maxFeePerGas),null==n.maxPriorityFeePerGas&&(n.maxPriorityFeePerGas=e.maxPriorityFeePerGas);else null!=e.gasPrice?((0,l.vA)(!s,"network does not support EIP-1559","UNSUPPORTED_OPERATION",{operation:"populateTransaction"}),null==n.gasPrice&&(n.gasPrice=e.gasPrice),n.type=0):(0,l.vA)(!1,"failed to get consistent fee data","UNSUPPORTED_OPERATION",{operation:"signer.getFeeData"});else 2!==n.type&&3!==n.type&&4!==n.type||(null==n.maxFeePerGas&&(n.maxFeePerGas=e.maxFeePerGas),null==n.maxPriorityFeePerGas&&(n.maxPriorityFeePerGas=e.maxPriorityFeePerGas))}else n.type=2;return await(0,u.k)(n)}async populateAuthorization(e){const t=Object.assign({},e);return null==t.chainId&&(t.chainId=(await h(this,"getNetwork").getNetwork()).chainId),null==t.nonce&&(t.nonce=await this.getNonce()),t}async estimateGas(e){return h(this,"estimateGas").estimateGas(await this.populateCall(e))}async call(e){return h(this,"call").call(await this.populateCall(e))}async resolveName(e){const t=h(this,"resolveName");return await t.resolveName(e)}async sendTransaction(e){const t=h(this,"sendTransaction"),n=await this.populateTransaction(e);delete n.from;const r=o.Z.from(n);return await t.broadcastTransaction(await this.signTransaction(r))}authorize(e){(0,l.vA)(!1,"authorization not implemented for this signer","UNSUPPORTED_OPERATION",{operation:"authorize"})}}var m=new WeakSet;class g extends p{constructor(e,t){super(t),(0,r.A)(this,m),(0,a.A)(this,"address",void 0),(0,u.n)(this,{address:e})}async getAddress(){return this.address}connect(e){return new g(this.address,e)}async signTransaction(e){(0,s.A)(m,this,y).call(this,"transactions","signTransaction")}async signMessage(e){(0,s.A)(m,this,y).call(this,"messages","signMessage")}async signTypedData(e,t,n){(0,s.A)(m,this,y).call(this,"typed-data","signTypedData")}}function y(e,t){(0,l.vA)(!1,"VoidSigner cannot sign ".concat(e),"UNSUPPORTED_OPERATION",{operation:t})}},4170(e,t,n){"use strict";n.d(t,{Lh:()=>b,Pz:()=>k});var r,s=n(9790),a=n(5149),i=n(6562),o=n(8458),l=n(2177),c=n(4705),u=n(1009),d=n(8152),h=n(4759),f=n(3040),p=n(70),m=n(686),g=n(5977),y=n(9197),w=n(2731),v=n(3451);function A(e){return e.match(/^ipfs:\/\/ipfs\//i)?e=e.substring(12):e.match(/^ipfs:\/\//i)?e=e.substring(7):(0,g.MR)(!1,"unsupported IPFS format","link",e),"https://gateway.ipfs.io/ipfs/".concat(e)}class b{constructor(e){(0,c.A)(this,"name",void 0),(0,v.n)(this,{name:e})}connect(e){return this}supportsCoinType(e){return!1}async encodeAddress(e,t){throw new Error("unsupported coin")}async decodeAddress(e,t){throw new Error("unsupported coin")}}const x=new RegExp("^(ipfs)://(.*)$","i"),S=[new RegExp("^(https)://(.*)$","i"),new RegExp("^(data):(.*)$","i"),x,new RegExp("^eip155:[0-9]+/(erc[0-9]+):(.*)$","i")];var C=new WeakMap,E=new WeakMap,N=new WeakSet;class k{constructor(e,t,n){(0,s.A)(this,N),(0,c.A)(this,"provider",void 0),(0,c.A)(this,"address",void 0),(0,c.A)(this,"name",void 0),(0,a.A)(this,C,void 0),(0,a.A)(this,E,void 0),(0,v.n)(this,{provider:e,address:t,name:n}),(0,l.A)(C,this,null),(0,l.A)(E,this,new h.NZ(t,["function supportsInterface(bytes4) view returns (bool)","function resolve(bytes, bytes) view returns (bytes)","function addr(bytes32) view returns (address)","function addr(bytes32, uint) view returns (bytes)","function text(bytes32, string) view returns (string)","function contenthash(bytes32) view returns (bytes)"],e))}async supportsWildcard(){return null==(0,o.A)(C,this)&&(0,l.A)(C,this,(async()=>{try{return await(0,o.A)(E,this).supportsInterface("0x9061b923")}catch(e){if((0,g.bJ)(e,"CALL_EXCEPTION"))return!1;throw(0,l.A)(C,this,null),e}})()),await(0,o.A)(C,this)}async getAddress(e){if(null==e&&(e=60),60===e)try{const e=await(0,i.A)(N,this,T).call(this,"addr(bytes32)");return null==e||e===d.j?null:e}catch(s){if((0,g.bJ)(s,"CALL_EXCEPTION"))return null;throw s}if(e>=0&&e<2147483648){let t=e+2147483648;const n=await(0,i.A)(N,this,T).call(this,"addr(bytes32,uint)",[t]);if((0,m.Lo)(n,20))return(0,u.b)(n)}let t=null;for(const a of this.provider.plugins)if(a instanceof b&&a.supportsCoinType(e)){t=a;break}if(null==t)return null;const n=await(0,i.A)(N,this,T).call(this,"addr(bytes32,uint)",[e]);if(null==n||"0x"===n)return null;const r=await t.decodeAddress(e,n);if(null!=r)return r;(0,g.vA)(!1,"invalid coin data","UNSUPPORTED_OPERATION",{operation:"getAddress(".concat(e,")"),info:{coinType:e,data:n}})}async getText(e){const t=await(0,i.A)(N,this,T).call(this,"text(bytes32,string)",[e]);return null==t||"0x"===t?null:t}async getContentHash(){const e=await(0,i.A)(N,this,T).call(this,"contenthash(bytes32)");if(null==e||"0x"===e)return null;const t=e.match(/^0x(e3010170|e5010172)(([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f]*))$/);if(t){const e="e3010170"===t[1]?"ipfs":"ipns",n=parseInt(t[4],16);if(t[5].length===2*n)return"".concat(e,"://").concat((0,p.R)("0x"+t[2]))}const n=e.match(/^0xe40101fa011b20([0-9a-f]*)$/);if(n&&64===n[1].length)return"bzz://".concat(n[1]);(0,g.vA)(!1,"invalid or unsupported content hash data","UNSUPPORTED_OPERATION",{operation:"getContentHash()",info:{data:e}})}async getAvatar(){return(await this._getAvatar()).url}async _getAvatar(){const e=[{type:"name",value:this.name}];try{const n=await this.getText("avatar");if(null==n)return e.push({type:"!avatar",value:""}),{url:null,linkage:e};e.push({type:"avatar",value:n});for(let r=0;r<S.length;r++){const s=n.match(S[r]);if(null==s)continue;const a=s[1].toLowerCase();switch(a){case"https":case"data":return e.push({type:"url",value:n}),{linkage:e,url:n};case"ipfs":{const t=A(n);return e.push({type:"ipfs",value:n}),e.push({type:"url",value:t}),{linkage:e,url:t}}case"erc721":case"erc1155":{const r="erc721"===a?"tokenURI(uint256)":"uri(uint256)";e.push({type:a,value:n});const i=await this.getAddress();if(null==i)return e.push({type:"!owner",value:""}),{url:null,linkage:e};const o=(s[2]||"").split("/");if(2!==o.length)return e.push({type:"!".concat(a,"caip"),value:s[2]||""}),{url:null,linkage:e};const l=o[1],c=new h.NZ(o[0],["function tokenURI(uint) view returns (string)","function ownerOf(uint) view returns (address)","function uri(uint) view returns (string)","function balanceOf(address, uint256) view returns (uint)"],this.provider);if("erc721"===a){const t=await c.ownerOf(l);if(i!==t)return e.push({type:"!owner",value:t}),{url:null,linkage:e};e.push({type:"owner",value:t})}else if("erc1155"===a){const t=await c.balanceOf(i,l);if(!t)return e.push({type:"!balance",value:"0"}),{url:null,linkage:e};e.push({type:"balance",value:t.toString()})}let u=await c[r](l);if(null==u||"0x"===u)return e.push({type:"!metadata-url",value:""}),{url:null,linkage:e};e.push({type:"metadata-url-base",value:u}),"erc1155"===a&&(u=u.replace("{id}",(0,w.up)(l,32).substring(2)),e.push({type:"metadata-url-expanded",value:u})),u.match(/^ipfs:/i)&&(u=A(u)),e.push({type:"metadata-url",value:u});let d={};const f=await new y.ui(u).send();f.assertOk();try{d=f.bodyJson}catch(t){try{e.push({type:"!metadata",value:f.bodyText})}catch(t){const n=f.body;return n&&e.push({type:"!metadata",value:(0,m.c$)(n)}),{url:null,linkage:e}}return{url:null,linkage:e}}if(!d)return e.push({type:"!metadata",value:""}),{url:null,linkage:e};e.push({type:"metadata",value:JSON.stringify(d)});let p=d.image;if("string"!==typeof p)return e.push({type:"!imageUrl",value:""}),{url:null,linkage:e};if(p.match(/^(https:\/\/|data:)/i));else{if(null==p.match(x))return e.push({type:"!imageUrl-ipfs",value:p}),{url:null,linkage:e};e.push({type:"imageUrl-ipfs",value:p}),p=A(p)}return e.push({type:"url",value:p}),{linkage:e,url:p}}}}}catch(t){}return{linkage:e,url:null}}static async getEnsAddress(e){const t=await e.getNetwork(),n=t.getPlugin("org.ethers.plugins.network.Ens");return(0,g.vA)(n,"network does not support ENS","UNSUPPORTED_OPERATION",{operation:"getEnsAddress",info:{network:t}}),n.address}static async fromName(e,t){let n=t;for(;;){if(""===n||"."===n)return null;if("eth"!==t&&"eth"===n)return null;const r=await I.call(k,e,n);if(null!=r){const s=new k(e,r,t);return n===t||await s.supportsWildcard()?s:null}n=n.split(".").slice(1).join(".")}}}async function T(e,t){t=(t||[]).slice();const n=(0,o.A)(E,this).interface;t.unshift((0,f.kM)(this.name));let r=null;await this.supportsWildcard()&&(r=n.getFunction(e),(0,g.vA)(r,"missing fragment","UNKNOWN_ERROR",{info:{funcName:e}}),t=[(0,f.Wh)(this.name,255),n.encodeFunctionData(r,t)],e="resolve(bytes,bytes)"),t.push({enableCcipRead:!0});try{const s=await(0,o.A)(E,this)[e](...t);return r?n.decodeFunctionResult(r,s)[0]:s}catch(s){if(!(0,g.bJ)(s,"CALL_EXCEPTION"))throw s}return null}async function I(e,t){const n=await r.getEnsAddress(e);try{const r=new h.NZ(n,["function resolver(bytes32) view returns (address)"],e),s=await r.resolver((0,f.kM)(t),{enableCcipRead:!0});return s===d.j?null:s}catch(s){throw s}}r=k},4105(e,t,n){"use strict";n.d(t,{l:()=>p});var r=n(5149),s=n(8458),a=n(2177),i=n(1963),o=n(5977),l=n(2731),c=n(8508);const u=new Map;var d=new WeakMap,h=new WeakMap,f=new WeakMap;class p{constructor(e,t){(0,r.A)(this,d,void 0),(0,r.A)(this,h,void 0),(0,r.A)(this,f,void 0),(0,a.A)(d,this,e),(0,a.A)(h,this,(0,l.Ab)(t)),(0,a.A)(f,this,new Map)}toJSON(){return{name:this.name,chainId:String(this.chainId)}}get name(){return(0,s.A)(d,this)}set name(e){(0,a.A)(d,this,e)}get chainId(){return(0,s.A)(h,this)}set chainId(e){(0,a.A)(h,this,(0,l.Ab)(e,"chainId"))}matches(e){if(null==e)return!1;if("string"===typeof e){try{return this.chainId===(0,l.Ab)(e)}catch(t){}return this.name===e}if("number"===typeof e||"bigint"===typeof e){try{return this.chainId===(0,l.Ab)(e)}catch(t){}return!1}if("object"===typeof e){if(null!=e.chainId){try{return this.chainId===(0,l.Ab)(e.chainId)}catch(t){}return!1}return null!=e.name&&this.name===e.name}return!1}get plugins(){return Array.from((0,s.A)(f,this).values())}attachPlugin(e){if((0,s.A)(f,this).get(e.name))throw new Error("cannot replace existing plugin: ".concat(e.name," "));return(0,s.A)(f,this).set(e.name,e.clone()),this}getPlugin(e){return(0,s.A)(f,this).get(e)||null}getPlugins(e){return this.plugins.filter(t=>t.name.split("#")[0]===e)}clone(){const e=new p(this.name,this.chainId);return this.plugins.forEach(t=>{e.attachPlugin(t.clone())}),e}computeIntrinsicGas(e){const t=this.getPlugin("org.ethers.plugins.network.GasCost")||new c.O;let n=t.txBase;if(null==e.to&&(n+=t.txCreate),e.data)for(let r=2;r<e.data.length;r+=2)"00"===e.data.substring(r,r+2)?n+=t.txDataZero:n+=t.txDataNonzero;if(e.accessList){const r=(0,i.$)(e.accessList);for(const e in r)n+=t.txAccessListAddress+t.txAccessListStorageKey*r[e].storageKeys.length}return n}static from(e){if(function(){if(y)return;function e(e,t,n){const r=function(){const r=new p(e,t);return null!=n.ensNetwork&&r.attachPlugin(new c.us(null,n.ensNetwork)),r.attachPlugin(new c.O),(n.plugins||[]).forEach(e=>{r.attachPlugin(e)}),r};p.register(e,r),p.register(t,r),n.altNames&&n.altNames.forEach(e=>{p.register(e,r)})}y=!0,e("mainnet",1,{ensNetwork:1,altNames:["homestead"]}),e("ropsten",3,{ensNetwork:3}),e("rinkeby",4,{ensNetwork:4}),e("goerli",5,{ensNetwork:5}),e("kovan",42,{ensNetwork:42}),e("sepolia",11155111,{ensNetwork:11155111}),e("holesky",17e3,{ensNetwork:17e3}),e("classic",61,{}),e("classicKotti",6,{}),e("arbitrum",42161,{ensNetwork:1}),e("arbitrum-goerli",421613,{}),e("arbitrum-sepolia",421614,{}),e("base",8453,{ensNetwork:1}),e("base-goerli",84531,{}),e("base-sepolia",84532,{}),e("bnb",56,{ensNetwork:1}),e("bnbt",97,{}),e("linea",59144,{ensNetwork:1}),e("linea-goerli",59140,{}),e("linea-sepolia",59141,{}),e("matic",137,{ensNetwork:1,plugins:[g("https://gasstation.polygon.technology/v2")]}),e("matic-amoy",80002,{}),e("matic-mumbai",80001,{altNames:["maticMumbai","maticmum"],plugins:[g("https://gasstation-testnet.polygon.technology/v2")]}),e("optimism",10,{ensNetwork:1,plugins:[]}),e("optimism-goerli",420,{}),e("optimism-sepolia",11155420,{}),e("xdai",100,{ensNetwork:1})}(),null==e)return p.from("mainnet");if("number"===typeof e&&(e=BigInt(e)),"string"===typeof e||"bigint"===typeof e){const t=u.get(e);if(t)return t();if("bigint"===typeof e)return new p("unknown",e);(0,o.MR)(!1,"unknown network","network",e)}if("function"===typeof e.clone){return e.clone()}if("object"===typeof e){(0,o.MR)("string"===typeof e.name&&"number"===typeof e.chainId,"invalid network object name or chainId","network",e);const t=new p(e.name,e.chainId);return(e.ensAddress||null!=e.ensNetwork)&&t.attachPlugin(new c.us(e.ensAddress,e.ensNetwork)),t}(0,o.MR)(!1,"invalid network","network",e)}static register(e,t){"number"===typeof e&&(e=BigInt(e));const n=u.get(e);n&&(0,o.MR)(!1,"conflicting network for ".concat(JSON.stringify(n.name)),"nameOrChainId",e),u.set(e,t)}}function m(e,t){const n=String(e);if(!n.match(/^[0-9.]+$/))throw new Error("invalid gwei value: ".concat(e));const r=n.split(".");if(1===r.length&&r.push(""),2!==r.length)throw new Error("invalid gwei value: ".concat(e));for(;r[1].length<t;)r[1]+="0";if(r[1].length>9){let e=BigInt(r[1].substring(0,9));r[1].substring(9).match(/^0+$/)||e++,r[1]=e.toString()}return BigInt(r[0]+r[1])}function g(e){return new c.VC(e,async(e,t,n)=>{let r;n.setHeader("User-Agent","ethers");try{const[t,s]=await Promise.all([n.send(),e()]);r=t;const a=r.bodyJson.standard;return{gasPrice:s.gasPrice,maxFeePerGas:m(a.maxFee,9),maxPriorityFeePerGas:m(a.maxPriorityFee,9)}}catch(s){(0,o.vA)(!1,"error encountered with polygon gas station (".concat(JSON.stringify(n.url),")"),"SERVER_ERROR",{request:n,response:r,error:s})}})}let y=!1},8508(e,t,n){"use strict";n.d(t,{O:()=>u,QE:()=>c,VC:()=>g,s5:()=>f,us:()=>d});var r=n(5149),s=n(2177),a=n(8458),i=n(4705),o=n(3451),l=n(5977);class c{constructor(e){(0,i.A)(this,"name",void 0),(0,o.n)(this,{name:e})}clone(){return new c(this.name)}}class u extends c{constructor(e,t){null==e&&(e=0),super("org.ethers.network.plugins.GasCost#".concat(e||0)),(0,i.A)(this,"effectiveBlock",void 0),(0,i.A)(this,"txBase",void 0),(0,i.A)(this,"txCreate",void 0),(0,i.A)(this,"txDataZero",void 0),(0,i.A)(this,"txDataNonzero",void 0),(0,i.A)(this,"txAccessListStorageKey",void 0),(0,i.A)(this,"txAccessListAddress",void 0);const n={effectiveBlock:e};function r(e,r){let s=(t||{})[e];null==s&&(s=r),(0,l.MR)("number"===typeof s,"invalud value for ".concat(e),"costs",t),n[e]=s}r("txBase",21e3),r("txCreate",32e3),r("txDataZero",4),r("txDataNonzero",16),r("txAccessListStorageKey",1900),r("txAccessListAddress",2400),(0,o.n)(this,n)}clone(){return new u(this.effectiveBlock,this)}}class d extends c{constructor(e,t){super("org.ethers.plugins.network.Ens"),(0,i.A)(this,"address",void 0),(0,i.A)(this,"targetNetwork",void 0),(0,o.n)(this,{address:e||"0x00000000000C2E074eC69A0dFb2997BA6C7d2e1e",targetNetwork:null==t?1:t})}clone(){return new d(this.address,this.targetNetwork)}}var h=new WeakMap;class f extends c{get feeDataFunc(){return(0,a.A)(h,this)}constructor(e){super("org.ethers.plugins.network.FeeData"),(0,r.A)(this,h,void 0),(0,s.A)(h,this,e)}async getFeeData(e){return await(0,a.A)(h,this).call(this,e)}clone(){return new f((0,a.A)(h,this))}}var p=new WeakMap,m=new WeakMap;class g extends c{get url(){return(0,a.A)(p,this)}get processFunc(){return(0,a.A)(m,this)}constructor(e,t){super("org.ethers.plugins.network.FetchUrlFeeDataPlugin"),(0,r.A)(this,p,void 0),(0,r.A)(this,m,void 0),(0,s.A)(p,this,e),(0,s.A)(m,this,t)}clone(){return this}}},5967(e,t,n){"use strict";n.d(t,{_y:()=>re,R$:()=>ee,FR:()=>ae,cP:()=>G});var r=n(9790),s=n(5149),a=n(6562),i=n(2177),o=n(8458),l=n(9379),c=n(4705),u=n(9873),d=n(1009),h=n(1132),f=n(5424),p=n(1963),m=n(7848),g=n(3451),y=n(5977),w=n(85),v=n(686),A=n(2731),b=n(9197),x=n(3404),S=n(1028),C=n(4105),E=n(9123);var N=new WeakMap,k=new WeakMap,T=new WeakMap,I=new WeakMap,_=new WeakMap,R=new WeakMap,M=new WeakSet;class D{constructor(e){(0,r.A)(this,M),(0,s.A)(this,N,void 0),(0,s.A)(this,k,void 0),(0,s.A)(this,T,void 0),(0,s.A)(this,I,void 0),(0,s.A)(this,_,void 0),(0,s.A)(this,R,void 0),(0,i.A)(N,this,e),(0,i.A)(k,this,null),(0,i.A)(T,this,(0,a.A)(M,this,j).bind(this)),(0,i.A)(I,this,!1),(0,i.A)(_,this,null),(0,i.A)(R,this,!1)}_subscribe(e){throw new Error("subclasses must override this")}_emitResults(e,t){throw new Error("subclasses must override this")}_recover(e){throw new Error("subclasses must override this")}start(){(0,o.A)(I,this)||((0,i.A)(I,this,!0),(0,a.A)(M,this,j).call(this,-2))}stop(){(0,o.A)(I,this)&&((0,i.A)(I,this,!1),(0,i.A)(R,this,!0),(0,a.A)(M,this,O).call(this),(0,o.A)(N,this).off("block",(0,o.A)(T,this)))}pause(e){e&&(0,a.A)(M,this,O).call(this),(0,o.A)(N,this).off("block",(0,o.A)(T,this))}resume(){this.start()}}async function j(e){try{null==(0,o.A)(k,this)&&(0,i.A)(k,this,this._subscribe((0,o.A)(N,this)));let e=null;try{e=await(0,o.A)(k,this)}catch(t){if(!(0,y.bJ)(t,"UNSUPPORTED_OPERATION")||"eth_newFilter"!==t.operation)throw t}if(null==e)return(0,i.A)(k,this,null),void(0,o.A)(N,this)._recoverSubscriber(this,this._recover((0,o.A)(N,this)));const n=await(0,o.A)(N,this).getNetwork();if((0,o.A)(_,this)||(0,i.A)(_,this,n),(0,o.A)(_,this).chainId!==n.chainId)throw new Error("chaid changed");if((0,o.A)(R,this))return;const r=await(0,o.A)(N,this).send("eth_getFilterChanges",[e]);await this._emitResults((0,o.A)(N,this),r)}catch(t){console.log("@TODO",t)}(0,o.A)(N,this).once("block",(0,o.A)(T,this))}function O(){const e=(0,o.A)(k,this);e&&((0,i.A)(k,this,null),e.then(e=>{(0,o.A)(N,this).destroyed||(0,o.A)(N,this).send("eth_uninstallFilter",[e])}))}var P=new WeakMap;class L extends D{constructor(e,t){var n;super(e),(0,s.A)(this,P,void 0),(0,i.A)(P,this,(n=t,JSON.parse(JSON.stringify(n))))}_recover(e){return new E.MY(e,(0,o.A)(P,this))}async _subscribe(e){return await e.send("eth_newFilter",[(0,o.A)(P,this)])}async _emitResults(e,t){for(const n of t)e.emit((0,o.A)(P,this),e._wrapLog(n,e._network))}}class B extends D{async _subscribe(e){return await e.send("eth_newPendingTransactionFilter",[])}async _emitResults(e,t){for(const n of t)e.emit("pending",n)}}const F="bigint,boolean,function,number,string,symbol".split(/,/g);function U(e){if(null==e||F.indexOf(typeof e)>=0)return e;if("function"===typeof e.getAddress)return e;if(Array.isArray(e))return e.map(U);if("object"===typeof e)return Object.keys(e).reduce((t,n)=>(t[n]=e[n],t),{});throw new Error("should not happen: ".concat(e," (").concat(typeof e,")"))}function W(e){return new Promise(t=>{setTimeout(t,e)})}function z(e){return e?e.toLowerCase():e}function H(e){return e&&"number"===typeof e.pollingInterval}const V={polling:!1,staticNetwork:null,batchStallTime:10,batchMaxSize:1<<20,batchMaxCount:100,cacheTimeout:250,pollingInterval:4e3};class G extends S.Z{constructor(e,t){super(e),(0,c.A)(this,"address",void 0),t=(0,d.b)(t),(0,g.n)(this,{address:t})}connect(e){(0,y.vA)(!1,"cannot reconnect JsonRpcSigner","UNSUPPORTED_OPERATION",{operation:"signer.connect"})}async getAddress(){return this.address}async populateTransaction(e){return await this.populateCall(e)}async sendUncheckedTransaction(e){const t=U(e),n=[];if(t.from){const r=t.from;n.push((async()=>{const n=await(0,h.tG)(r,this.provider);(0,y.MR)(null!=n&&n.toLowerCase()===this.address.toLowerCase(),"from address mismatch","transaction",e),t.from=n})())}else t.from=this.address;if(null==t.gasLimit&&n.push((async()=>{t.gasLimit=await this.provider.estimateGas((0,l.A)((0,l.A)({},t),{},{from:this.address}))})()),null!=t.to){const e=t.to;n.push((async()=>{t.to=await(0,h.tG)(e,this.provider)})())}n.length&&await Promise.all(n);const r=this.provider.getRpcTransaction(t);return this.provider.send("eth_sendTransaction",[r])}async sendTransaction(e){const t=await this.provider.getBlockNumber(),n=await this.sendUncheckedTransaction(e);return await new Promise((e,r)=>{const s=[1e3,100];let a=0;const i=async()=>{try{const r=await this.provider.getTransaction(n);if(null!=r)return void e(r.replaceableTransaction(t))}catch(o){if((0,y.bJ)(o,"CANCELLED")||(0,y.bJ)(o,"BAD_DATA")||(0,y.bJ)(o,"NETWORK_ERROR")||(0,y.bJ)(o,"UNSUPPORTED_OPERATION"))return null==o.info&&(o.info={}),o.info.sendTransactionHash=n,void r(o);if((0,y.bJ)(o,"INVALID_ARGUMENT")&&(a++,null==o.info&&(o.info={}),o.info.sendTransactionHash=n,a>10))return void r(o);this.provider.emit("error",(0,y.xz)("failed to fetch transation after sending (will try again)","UNKNOWN_ERROR",{error:o}))}this.provider._setTimeout(()=>{i()},s.pop()||4e3)};i()})}async signTransaction(e){const t=U(e);if(t.from){const n=await(0,h.tG)(t.from,this.provider);(0,y.MR)(null!=n&&n.toLowerCase()===this.address.toLowerCase(),"from address mismatch","transaction",e),t.from=n}else t.from=this.address;const n=this.provider.getRpcTransaction(t);return await this.provider.send("eth_signTransaction",[n])}async signMessage(e){const t="string"===typeof e?(0,w.YW)(e):e;return await this.provider.send("personal_sign",[(0,v.c$)(t),this.address.toLowerCase()])}async signTypedData(e,t,n){const r=U(n),s=await f.z.resolveNames(e,t,r,async e=>{const t=await(0,h.tG)(e);return(0,y.MR)(null!=t,"TypedData does not support null address","value",e),t});return await this.provider.send("eth_signTypedData_v4",[this.address.toLowerCase(),JSON.stringify(f.z.getPayload(s.domain,t,s.value))])}async unlock(e){return this.provider.send("personal_unlockAccount",[this.address.toLowerCase(),e,null])}async _legacySignMessage(e){const t="string"===typeof e?(0,w.YW)(e):e;return await this.provider.send("eth_sign",[this.address.toLowerCase(),(0,v.c$)(t)])}}var J=new WeakMap,Q=new WeakMap,K=new WeakMap,Y=new WeakMap,q=new WeakMap,X=new WeakMap,Z=new WeakMap,$=new WeakSet;class ee extends x.Q{constructor(e,t){super(e,t),(0,r.A)(this,$),(0,s.A)(this,J,void 0),(0,s.A)(this,Q,void 0),(0,s.A)(this,K,void 0),(0,s.A)(this,Y,void 0),(0,s.A)(this,q,void 0),(0,s.A)(this,X,void 0),(0,s.A)(this,Z,void 0),(0,i.A)(Q,this,1),(0,i.A)(J,this,Object.assign({},V,t||{})),(0,i.A)(K,this,[]),(0,i.A)(Y,this,null),(0,i.A)(X,this,null),(0,i.A)(Z,this,null);{let e=null;const t=new Promise(t=>{e=t});(0,i.A)(q,this,{promise:t,resolve:e})}const n=this._getOption("staticNetwork");"boolean"===typeof n?((0,y.MR)(!n||"any"!==e,"staticNetwork cannot be used on special network 'any'","options",t),n&&null!=e&&(0,i.A)(X,this,C.l.from(e))):n&&((0,y.MR)(null==e||n.matches(e),"staticNetwork MUST match network object","options",t),(0,i.A)(X,this,n))}_getOption(e){return(0,o.A)(J,this)[e]}get _network(){return(0,y.vA)((0,o.A)(X,this),"network is not available yet","NETWORK_ERROR"),(0,o.A)(X,this)}async _perform(e){if("call"===e.method||"estimateGas"===e.method){let t=e.transaction;if(t&&null!=t.type&&(0,A.Ab)(t.type)&&null==t.maxFeePerGas&&null==t.maxPriorityFeePerGas){const n=await this.getFeeData();null==n.maxFeePerGas&&null==n.maxPriorityFeePerGas&&(e=Object.assign({},e,{transaction:Object.assign({},t,{type:void 0})}))}}const t=this.getRpcRequest(e);return null!=t?await this.send(t.method,t.args):super._perform(e)}async _detectNetwork(){const e=this._getOption("staticNetwork");if(e){if(!0!==e)return e;if((0,o.A)(X,this))return(0,o.A)(X,this)}return(0,o.A)(Z,this)?await(0,o.A)(Z,this):this.ready?((0,i.A)(Z,this,(async()=>{try{const e=C.l.from((0,A.Ab)(await this.send("eth_chainId",[])));return(0,i.A)(Z,this,null),e}catch(e){throw(0,i.A)(Z,this,null),e}})()),await(0,o.A)(Z,this)):((0,i.A)(Z,this,(async(e,t)=>{const n={id:((0,i.A)(Q,this,(e=(0,o.A)(Q,this),t=e++,e)),t),method:"eth_chainId",params:[],jsonrpc:"2.0"};let r;this.emit("debug",{action:"sendRpcPayload",payload:n});try{r=(await this._send(n))[0],(0,i.A)(Z,this,null)}catch(s){throw(0,i.A)(Z,this,null),this.emit("debug",{action:"receiveRpcError",error:s}),s}if(this.emit("debug",{action:"receiveRpcResult",result:r}),"result"in r)return C.l.from((0,A.Ab)(r.result));throw this.getRpcError(n,r)})()),await(0,o.A)(Z,this))}_start(){null!=(0,o.A)(q,this)&&null!=(0,o.A)(q,this).resolve&&((0,o.A)(q,this).resolve(),(0,i.A)(q,this,null),(async()=>{for(;null==(0,o.A)(X,this)&&!this.destroyed;)try{(0,i.A)(X,this,await this._detectNetwork())}catch(e){if(this.destroyed)break;console.log("JsonRpcProvider failed to detect network and cannot start up; retry in 1s (perhaps the URL is wrong or the node is not started)"),this.emit("error",(0,y.xz)("failed to bootstrap network detection","NETWORK_ERROR",{event:"initial-network-discovery",info:{error:e}})),await W(1e3)}(0,a.A)($,this,te).call(this)})())}async _waitUntilReady(){if(null!=(0,o.A)(q,this))return await(0,o.A)(q,this).promise}_getSubscriber(e){return"pending"===e.type?new B(this):"event"===e.type?this._getOption("polling")?new E.MY(this,e.filter):new L(this,e.filter):"orphan"===e.type&&"drop-log"===e.filter.orphan?new x.J("orphan"):super._getSubscriber(e)}get ready(){return null==(0,o.A)(q,this)}getRpcTransaction(e){const t={};return["chainId","gasLimit","gasPrice","type","maxFeePerGas","maxPriorityFeePerGas","nonce","value"].forEach(n=>{if(null==e[n])return;let r=n;"gasLimit"===n&&(r="gas"),t[r]=(0,A.nD)((0,A.Ab)(e[n],"tx.".concat(n)))}),["from","to","data"].forEach(n=>{null!=e[n]&&(t[n]=(0,v.c$)(e[n]))}),e.accessList&&(t.accessList=(0,p.$)(e.accessList)),e.blobVersionedHashes&&(t.blobVersionedHashes=e.blobVersionedHashes.map(e=>e.toLowerCase())),e.authorizationList&&(t.authorizationList=e.authorizationList.map(e=>{const t=(0,m.M)(e);return{address:t.address,nonce:(0,A.nD)(t.nonce),chainId:(0,A.nD)(t.chainId),yParity:(0,A.nD)(t.signature.yParity),r:(0,A.nD)(t.signature.r),s:(0,A.nD)(t.signature.s)}})),t}getRpcRequest(e){switch(e.method){case"chainId":return{method:"eth_chainId",args:[]};case"getBlockNumber":return{method:"eth_blockNumber",args:[]};case"getGasPrice":return{method:"eth_gasPrice",args:[]};case"getPriorityFee":return{method:"eth_maxPriorityFeePerGas",args:[]};case"getBalance":return{method:"eth_getBalance",args:[z(e.address),e.blockTag]};case"getTransactionCount":return{method:"eth_getTransactionCount",args:[z(e.address),e.blockTag]};case"getCode":return{method:"eth_getCode",args:[z(e.address),e.blockTag]};case"getStorage":return{method:"eth_getStorageAt",args:[z(e.address),"0x"+e.position.toString(16),e.blockTag]};case"broadcastTransaction":return{method:"eth_sendRawTransaction",args:[e.signedTransaction]};case"getBlock":if("blockTag"in e)return{method:"eth_getBlockByNumber",args:[e.blockTag,!!e.includeTransactions]};if("blockHash"in e)return{method:"eth_getBlockByHash",args:[e.blockHash,!!e.includeTransactions]};break;case"getTransaction":return{method:"eth_getTransactionByHash",args:[e.hash]};case"getTransactionReceipt":return{method:"eth_getTransactionReceipt",args:[e.hash]};case"call":return{method:"eth_call",args:[this.getRpcTransaction(e.transaction),e.blockTag]};case"estimateGas":return{method:"eth_estimateGas",args:[this.getRpcTransaction(e.transaction)]};case"getLogs":return e.filter&&null!=e.filter.address&&(Array.isArray(e.filter.address)?e.filter.address=e.filter.address.map(z):e.filter.address=z(e.filter.address)),{method:"eth_getLogs",args:[e.filter]}}return null}getRpcError(e,t){const{method:n}=e,{error:r}=t;if("eth_estimateGas"===n&&r.message){const t=r.message;if(!t.match(/revert/i)&&t.match(/insufficient funds/i))return(0,y.xz)("insufficient funds","INSUFFICIENT_FUNDS",{transaction:e.params[0],info:{payload:e,error:r}});if(t.match(/nonce/i)&&t.match(/too low/i))return(0,y.xz)("nonce has already been used","NONCE_EXPIRED",{transaction:e.params[0],info:{payload:e,error:r}})}if("eth_call"===n||"eth_estimateGas"===n){const t=ie(r),s=u.y.getBuiltinCallException("eth_call"===n?"call":"estimateGas",e.params[0],t?t.data:null);return s.info={error:r,payload:e},s}const s=JSON.stringify(function(e){const t=[];return oe(e,t),t}(r));if("string"===typeof r.message&&r.message.match(/user denied|ethers-user-denied/i)){const t={eth_sign:"signMessage",personal_sign:"signMessage",eth_signTypedData_v4:"signTypedData",eth_signTransaction:"signTransaction",eth_sendTransaction:"sendTransaction",eth_requestAccounts:"requestAccess",wallet_requestAccounts:"requestAccess"};return(0,y.xz)("user rejected action","ACTION_REJECTED",{action:t[n]||"unknown",reason:"rejected",info:{payload:e,error:r}})}if("eth_sendRawTransaction"===n||"eth_sendTransaction"===n){const t=e.params[0];if(s.match(/insufficient funds|base fee exceeds gas limit/i))return(0,y.xz)("insufficient funds for intrinsic transaction cost","INSUFFICIENT_FUNDS",{transaction:t,info:{error:r}});if(s.match(/nonce/i)&&s.match(/too low/i))return(0,y.xz)("nonce has already been used","NONCE_EXPIRED",{transaction:t,info:{error:r}});if(s.match(/replacement transaction/i)&&s.match(/underpriced/i))return(0,y.xz)("replacement fee too low","REPLACEMENT_UNDERPRICED",{transaction:t,info:{error:r}});if(s.match(/only replay-protected/i))return(0,y.xz)("legacy pre-eip-155 transactions not supported","UNSUPPORTED_OPERATION",{operation:n,info:{transaction:t,info:{error:r}}})}let a=!!s.match(/the method .* does not exist/i);return a||r&&r.details&&r.details.startsWith("Unauthorized method:")&&(a=!0),a?(0,y.xz)("unsupported operation","UNSUPPORTED_OPERATION",{operation:e.method,info:{error:r,payload:e}}):(0,y.xz)("could not coalesce error","UNKNOWN_ERROR",{error:r,payload:e})}send(e,t){var n,r;if(this.destroyed)return Promise.reject((0,y.xz)("provider destroyed; cancelled request","UNSUPPORTED_OPERATION",{operation:e}));const s=((0,i.A)(Q,this,(n=(0,o.A)(Q,this),r=n++,n)),r),l=new Promise((n,r)=>{(0,o.A)(K,this).push({resolve:n,reject:r,payload:{method:e,params:t,id:s,jsonrpc:"2.0"}})});return(0,a.A)($,this,te).call(this),l}async getSigner(e){null==e&&(e=0);const t=this.send("eth_accounts",[]);if("number"===typeof e){const n=await t;if(e>=n.length)throw new Error("no such account");return new G(this,n[e])}const{accounts:n}=await(0,g.k)({network:this.getNetwork(),accounts:t});e=(0,d.b)(e);for(const r of n)if((0,d.b)(r)===e)return new G(this,e);throw new Error("invalid account")}async listAccounts(){return(await this.send("eth_accounts",[])).map(e=>new G(this,e))}destroy(){(0,o.A)(Y,this)&&(clearTimeout((0,o.A)(Y,this)),(0,i.A)(Y,this,null));for(const{payload:e,reject:t}of(0,o.A)(K,this))t((0,y.xz)("provider destroyed; cancelled request","UNSUPPORTED_OPERATION",{operation:e.method}));(0,i.A)(K,this,[]),super.destroy()}}function te(){if((0,o.A)(Y,this))return;const e=1===this._getOption("batchMaxCount")?0:this._getOption("batchStallTime");(0,i.A)(Y,this,setTimeout(()=>{(0,i.A)(Y,this,null);const e=(0,o.A)(K,this);for((0,i.A)(K,this,[]);e.length;){const t=[e.shift()];for(;e.length&&t.length!==(0,o.A)(J,this).batchMaxCount;){t.push(e.shift());if(JSON.stringify(t.map(e=>e.payload)).length>(0,o.A)(J,this).batchMaxSize){e.unshift(t.pop());break}}(async()=>{const e=1===t.length?t[0].payload:t.map(e=>e.payload);this.emit("debug",{action:"sendRpcPayload",payload:e});try{const n=await this._send(e);this.emit("debug",{action:"receiveRpcResult",result:n});for(const{resolve:e,reject:r,payload:s}of t){if(this.destroyed){r((0,y.xz)("provider destroyed; cancelled request","UNSUPPORTED_OPERATION",{operation:s.method}));continue}const t=n.filter(e=>e.id===s.id)[0];if(null==t){const e=(0,y.xz)("missing response for request","BAD_DATA",{value:n,info:{payload:s}});this.emit("error",e),r(e);continue}"error"in t?r(this.getRpcError(s,t)):e(t.result)}}catch(n){this.emit("debug",{action:"receiveRpcError",error:n});for(const{reject:e}of t)e(n)}})()}},e))}var ne=new WeakMap;class re extends ee{constructor(e,t){super(e,t),(0,s.A)(this,ne,void 0);let n=this._getOption("pollingInterval");null==n&&(n=V.pollingInterval),(0,i.A)(ne,this,n)}_getSubscriber(e){const t=super._getSubscriber(e);return H(t)&&(t.pollingInterval=(0,o.A)(ne,this)),t}get pollingInterval(){return(0,o.A)(ne,this)}set pollingInterval(e){if(!Number.isInteger(e)||e<0)throw new Error("invalid interval");(0,i.A)(ne,this,e),this._forEachSubscriber(e=>{H(e)&&(e.pollingInterval=(0,o.A)(ne,this))})}}var se=new WeakMap;class ae extends re{constructor(e,t,n){null==e&&(e="http://localhost:8545"),super(t,n),(0,s.A)(this,se,void 0),"string"===typeof e?(0,i.A)(se,this,new b.ui(e)):(0,i.A)(se,this,e.clone())}_getConnection(){return(0,o.A)(se,this).clone()}async send(e,t){return await this._start(),await super.send(e,t)}async _send(e){const t=this._getConnection();t.body=JSON.stringify(e),t.setHeader("content-type","application/json");const n=await t.send();n.assertOk();let r=n.bodyJson;return Array.isArray(r)||(r=[r]),r}}function ie(e){if(null==e)return null;if("string"===typeof e.message&&e.message.match(/revert/i)&&(0,v.Lo)(e.data))return{message:e.message,data:e.data};if("object"===typeof e){for(const t in e){const n=ie(e[t]);if(n)return n}return null}if("string"===typeof e)try{return ie(JSON.parse(e))}catch(t){}return null}function oe(e,t){if(null!=e){if("string"===typeof e.message&&t.push(e.message),"object"===typeof e)for(const n in e)oe(e[n],t);if("string"===typeof e)try{return oe(JSON.parse(e),t)}catch(n){}}}},7750(e,t,n){"use strict";n.d(t,{J9:()=>m,VS:()=>g,eB:()=>w,tG:()=>v,uI:()=>S,z5:()=>b});var r=n(5149),s=n(8458),a=n(2177),i=n(4705),o=n(686),l=n(5977),c=n(2731),u=n(3451),d=n(1963);const h=BigInt(0);function f(e){return null==e?null:e}function p(e){return null==e?null:e.toString()}class m{constructor(e,t,n){(0,i.A)(this,"gasPrice",void 0),(0,i.A)(this,"maxFeePerGas",void 0),(0,i.A)(this,"maxPriorityFeePerGas",void 0),(0,u.n)(this,{gasPrice:f(e),maxFeePerGas:f(t),maxPriorityFeePerGas:f(n)})}toJSON(){const{gasPrice:e,maxFeePerGas:t,maxPriorityFeePerGas:n}=this;return{_type:"FeeData",gasPrice:p(e),maxFeePerGas:p(t),maxPriorityFeePerGas:p(n)}}}function g(e){const t={};e.to&&(t.to=e.to),e.from&&(t.from=e.from),e.data&&(t.data=(0,o.c$)(e.data));const n="chainId,gasLimit,gasPrice,maxFeePerBlobGas,maxFeePerGas,maxPriorityFeePerGas,value".split(/,/);for(const s of n)s in e&&null!=e[s]&&(t[s]=(0,c.Ab)(e[s],"request.".concat(s)));const r="type,nonce".split(/,/);for(const s of r)s in e&&null!=e[s]&&(t[s]=(0,c.WZ)(e[s],"request.".concat(s)));return e.accessList&&(t.accessList=(0,d.$)(e.accessList)),e.authorizationList&&(t.authorizationList=e.authorizationList.slice()),"blockTag"in e&&(t.blockTag=e.blockTag),"enableCcipRead"in e&&(t.enableCcipRead=!!e.enableCcipRead),"customData"in e&&(t.customData=e.customData),"blobVersionedHashes"in e&&e.blobVersionedHashes&&(t.blobVersionedHashes=e.blobVersionedHashes.slice()),"kzg"in e&&(t.kzg=e.kzg),"blobs"in e&&e.blobs&&(t.blobs=e.blobs.map(e=>(0,o.f)(e)?(0,o.c$)(e):Object.assign({},e))),t}var y=new WeakMap;class w{constructor(e,t){(0,i.A)(this,"provider",void 0),(0,i.A)(this,"number",void 0),(0,i.A)(this,"hash",void 0),(0,i.A)(this,"timestamp",void 0),(0,i.A)(this,"parentHash",void 0),(0,i.A)(this,"parentBeaconBlockRoot",void 0),(0,i.A)(this,"nonce",void 0),(0,i.A)(this,"difficulty",void 0),(0,i.A)(this,"gasLimit",void 0),(0,i.A)(this,"gasUsed",void 0),(0,i.A)(this,"stateRoot",void 0),(0,i.A)(this,"receiptsRoot",void 0),(0,i.A)(this,"blobGasUsed",void 0),(0,i.A)(this,"excessBlobGas",void 0),(0,i.A)(this,"miner",void 0),(0,i.A)(this,"prevRandao",void 0),(0,i.A)(this,"extraData",void 0),(0,i.A)(this,"baseFeePerGas",void 0),(0,r.A)(this,y,void 0),(0,a.A)(y,this,e.transactions.map(e=>"string"!==typeof e?new S(e,t):e)),(0,u.n)(this,{provider:t,hash:f(e.hash),number:e.number,timestamp:e.timestamp,parentHash:e.parentHash,parentBeaconBlockRoot:e.parentBeaconBlockRoot,nonce:e.nonce,difficulty:e.difficulty,gasLimit:e.gasLimit,gasUsed:e.gasUsed,blobGasUsed:e.blobGasUsed,excessBlobGas:e.excessBlobGas,miner:e.miner,prevRandao:f(e.prevRandao),extraData:e.extraData,baseFeePerGas:f(e.baseFeePerGas),stateRoot:e.stateRoot,receiptsRoot:e.receiptsRoot})}get transactions(){return(0,s.A)(y,this).map(e=>"string"===typeof e?e:e.hash)}get prefetchedTransactions(){const e=(0,s.A)(y,this).slice();return 0===e.length?[]:((0,l.vA)("object"===typeof e[0],"transactions were not prefetched with block request","UNSUPPORTED_OPERATION",{operation:"transactionResponses()"}),e)}toJSON(){const{baseFeePerGas:e,difficulty:t,extraData:n,gasLimit:r,gasUsed:s,hash:a,miner:i,prevRandao:o,nonce:l,number:c,parentHash:u,parentBeaconBlockRoot:d,stateRoot:h,receiptsRoot:f,timestamp:m,transactions:g}=this;return{_type:"Block",baseFeePerGas:p(e),difficulty:p(t),extraData:n,gasLimit:p(r),gasUsed:p(s),blobGasUsed:p(this.blobGasUsed),excessBlobGas:p(this.excessBlobGas),hash:a,miner:i,prevRandao:o,nonce:l,number:c,parentHash:u,timestamp:m,parentBeaconBlockRoot:d,stateRoot:h,receiptsRoot:f,transactions:g}}[Symbol.iterator](){let e=0;const t=this.transactions;return{next:()=>e<this.length?{value:t[e++],done:!1}:{value:void 0,done:!0}}}get length(){return(0,s.A)(y,this).length}get date(){return null==this.timestamp?null:new Date(1e3*this.timestamp)}async getTransaction(e){let t;if("number"===typeof e)t=(0,s.A)(y,this)[e];else{const n=e.toLowerCase();for(const e of(0,s.A)(y,this)){if("string"===typeof e){if(e!==n)continue;t=e;break}if(e.hash===n){t=e;break}}}if(null==t)throw new Error("no such tx");return"string"===typeof t?await this.provider.getTransaction(t):t}getPrefetchedTransaction(e){const t=this.prefetchedTransactions;if("number"===typeof e)return t[e];e=e.toLowerCase();for(const n of t)if(n.hash===e)return n;(0,l.MR)(!1,"no matching transaction","indexOrHash",e)}isMined(){return!!this.hash}isLondon(){return!!this.baseFeePerGas}orphanedEvent(){if(!this.isMined())throw new Error("");return{orphan:"drop-block",hash:(e=this).hash,number:e.number};var e}}class v{constructor(e,t){(0,i.A)(this,"provider",void 0),(0,i.A)(this,"transactionHash",void 0),(0,i.A)(this,"blockHash",void 0),(0,i.A)(this,"blockNumber",void 0),(0,i.A)(this,"removed",void 0),(0,i.A)(this,"address",void 0),(0,i.A)(this,"data",void 0),(0,i.A)(this,"topics",void 0),(0,i.A)(this,"index",void 0),(0,i.A)(this,"transactionIndex",void 0),this.provider=t;const n=Object.freeze(e.topics.slice());(0,u.n)(this,{transactionHash:e.transactionHash,blockHash:e.blockHash,blockNumber:e.blockNumber,removed:e.removed,address:e.address,data:e.data,topics:n,index:e.index,transactionIndex:e.transactionIndex})}toJSON(){const{address:e,blockHash:t,blockNumber:n,data:r,index:s,removed:a,topics:i,transactionHash:o,transactionIndex:l}=this;return{_type:"log",address:e,blockHash:t,blockNumber:n,data:r,index:s,removed:a,topics:i,transactionHash:o,transactionIndex:l}}async getBlock(){const e=await this.provider.getBlock(this.blockHash);return(0,l.vA)(!!e,"failed to find transaction","UNKNOWN_ERROR",{}),e}async getTransaction(){const e=await this.provider.getTransaction(this.transactionHash);return(0,l.vA)(!!e,"failed to find transaction","UNKNOWN_ERROR",{}),e}async getTransactionReceipt(){const e=await this.provider.getTransactionReceipt(this.transactionHash);return(0,l.vA)(!!e,"failed to find transaction receipt","UNKNOWN_ERROR",{}),e}removedEvent(){return{orphan:"drop-log",log:{transactionHash:(e=this).transactionHash,blockHash:e.blockHash,blockNumber:e.blockNumber,address:e.address,data:e.data,topics:Object.freeze(e.topics.slice()),index:e.index}};var e}}var A=new WeakMap;class b{constructor(e,t){(0,i.A)(this,"provider",void 0),(0,i.A)(this,"to",void 0),(0,i.A)(this,"from",void 0),(0,i.A)(this,"contractAddress",void 0),(0,i.A)(this,"hash",void 0),(0,i.A)(this,"index",void 0),(0,i.A)(this,"blockHash",void 0),(0,i.A)(this,"blockNumber",void 0),(0,i.A)(this,"logsBloom",void 0),(0,i.A)(this,"gasUsed",void 0),(0,i.A)(this,"blobGasUsed",void 0),(0,i.A)(this,"cumulativeGasUsed",void 0),(0,i.A)(this,"gasPrice",void 0),(0,i.A)(this,"blobGasPrice",void 0),(0,i.A)(this,"type",void 0),(0,i.A)(this,"status",void 0),(0,i.A)(this,"root",void 0),(0,r.A)(this,A,void 0),(0,a.A)(A,this,Object.freeze(e.logs.map(e=>new v(e,t))));let n=h;null!=e.effectiveGasPrice?n=e.effectiveGasPrice:null!=e.gasPrice&&(n=e.gasPrice),(0,u.n)(this,{provider:t,to:e.to,from:e.from,contractAddress:e.contractAddress,hash:e.hash,index:e.index,blockHash:e.blockHash,blockNumber:e.blockNumber,logsBloom:e.logsBloom,gasUsed:e.gasUsed,cumulativeGasUsed:e.cumulativeGasUsed,blobGasUsed:e.blobGasUsed,gasPrice:n,blobGasPrice:e.blobGasPrice,type:e.type,status:e.status,root:e.root})}get logs(){return(0,s.A)(A,this)}toJSON(){const{to:e,from:t,contractAddress:n,hash:r,index:s,blockHash:a,blockNumber:i,logsBloom:o,logs:l,status:c,root:u}=this;return{_type:"TransactionReceipt",blockHash:a,blockNumber:i,contractAddress:n,cumulativeGasUsed:p(this.cumulativeGasUsed),from:t,gasPrice:p(this.gasPrice),blobGasUsed:p(this.blobGasUsed),blobGasPrice:p(this.blobGasPrice),gasUsed:p(this.gasUsed),hash:r,index:s,logs:l,logsBloom:o,root:u,status:c,to:e}}get length(){return this.logs.length}[Symbol.iterator](){let e=0;return{next:()=>e<this.length?{value:this.logs[e++],done:!1}:{value:void 0,done:!0}}}get fee(){return this.gasUsed*this.gasPrice}async getBlock(){const e=await this.provider.getBlock(this.blockHash);if(null==e)throw new Error("TODO");return e}async getTransaction(){const e=await this.provider.getTransaction(this.hash);if(null==e)throw new Error("TODO");return e}async getResult(){return await this.provider.getTransactionResult(this.hash)}async confirmations(){return await this.provider.getBlockNumber()-this.blockNumber+1}removedEvent(){return E(this)}reorderedEvent(e){return(0,l.vA)(!e||e.isMined(),"unmined 'other' transction cannot be orphaned","UNSUPPORTED_OPERATION",{operation:"reorderedEvent(other)"}),C(this,e)}}var x=new WeakMap;class S{constructor(e,t){(0,i.A)(this,"provider",void 0),(0,i.A)(this,"blockNumber",void 0),(0,i.A)(this,"blockHash",void 0),(0,i.A)(this,"index",void 0),(0,i.A)(this,"hash",void 0),(0,i.A)(this,"type",void 0),(0,i.A)(this,"to",void 0),(0,i.A)(this,"from",void 0),(0,i.A)(this,"nonce",void 0),(0,i.A)(this,"gasLimit",void 0),(0,i.A)(this,"gasPrice",void 0),(0,i.A)(this,"maxPriorityFeePerGas",void 0),(0,i.A)(this,"maxFeePerGas",void 0),(0,i.A)(this,"maxFeePerBlobGas",void 0),(0,i.A)(this,"data",void 0),(0,i.A)(this,"value",void 0),(0,i.A)(this,"chainId",void 0),(0,i.A)(this,"signature",void 0),(0,i.A)(this,"accessList",void 0),(0,i.A)(this,"blobVersionedHashes",void 0),(0,i.A)(this,"authorizationList",void 0),(0,r.A)(this,x,void 0),this.provider=t,this.blockNumber=null!=e.blockNumber?e.blockNumber:null,this.blockHash=null!=e.blockHash?e.blockHash:null,this.hash=e.hash,this.index=e.index,this.type=e.type,this.from=e.from,this.to=e.to||null,this.gasLimit=e.gasLimit,this.nonce=e.nonce,this.data=e.data,this.value=e.value,this.gasPrice=e.gasPrice,this.maxPriorityFeePerGas=null!=e.maxPriorityFeePerGas?e.maxPriorityFeePerGas:null,this.maxFeePerGas=null!=e.maxFeePerGas?e.maxFeePerGas:null,this.maxFeePerBlobGas=null!=e.maxFeePerBlobGas?e.maxFeePerBlobGas:null,this.chainId=e.chainId,this.signature=e.signature,this.accessList=null!=e.accessList?e.accessList:null,this.blobVersionedHashes=null!=e.blobVersionedHashes?e.blobVersionedHashes:null,this.authorizationList=null!=e.authorizationList?e.authorizationList:null,(0,a.A)(x,this,-1)}toJSON(){const{blockNumber:e,blockHash:t,index:n,hash:r,type:s,to:a,from:i,nonce:o,data:l,signature:c,accessList:u,blobVersionedHashes:d}=this;return{_type:"TransactionResponse",accessList:u,blockNumber:e,blockHash:t,blobVersionedHashes:d,chainId:p(this.chainId),data:l,from:i,gasLimit:p(this.gasLimit),gasPrice:p(this.gasPrice),hash:r,maxFeePerGas:p(this.maxFeePerGas),maxPriorityFeePerGas:p(this.maxPriorityFeePerGas),maxFeePerBlobGas:p(this.maxFeePerBlobGas),nonce:o,signature:c,to:a,index:n,type:s,value:p(this.value)}}async getBlock(){let e=this.blockNumber;if(null==e){const t=await this.getTransaction();t&&(e=t.blockNumber)}if(null==e)return null;const t=this.provider.getBlock(e);if(null==t)throw new Error("TODO");return t}async getTransaction(){return this.provider.getTransaction(this.hash)}async confirmations(){if(null==this.blockNumber){const{tx:e,blockNumber:t}=await(0,u.k)({tx:this.getTransaction(),blockNumber:this.provider.getBlockNumber()});return null==e||null==e.blockNumber?0:t-e.blockNumber+1}return await this.provider.getBlockNumber()-this.blockNumber+1}async wait(e,t){const n=null==e?1:e,r=null==t?0:t;let a=(0,s.A)(x,this),i=-1,o=-1===a;const c=async()=>{if(o)return null;const{blockNumber:e,nonce:t}=await(0,u.k)({blockNumber:this.provider.getBlockNumber(),nonce:this.provider.getTransactionCount(this.from)});if(t<this.nonce)return void(a=e);if(o)return null;const r=await this.getTransaction();if(!r||null==r.blockNumber)for(-1===i&&(i=a-3,i<(0,s.A)(x,this)&&(i=(0,s.A)(x,this)));i<=e;){if(o)return null;const t=await this.provider.getBlock(i,!0);if(null==t)return;for(const e of t)if(e===this.hash)return;for(let r=0;r<t.length;r++){const s=await t.getTransaction(r);if(s.from===this.from&&s.nonce===this.nonce){if(o)return null;const t=await this.provider.getTransactionReceipt(s.hash);if(null==t)return;if(e-t.blockNumber+1<n)return;let r="replaced";s.data===this.data&&s.to===this.to&&s.value===this.value?r="repriced":"0x"===s.data&&s.from===s.to&&s.value===h&&(r="cancelled"),(0,l.vA)(!1,"transaction was replaced","TRANSACTION_REPLACED",{cancelled:"replaced"===r||"cancelled"===r,reason:r,replacement:s.replaceableTransaction(a),hash:s.hash,receipt:t})}}i++}},d=e=>{if(null==e||0!==e.status)return e;(0,l.vA)(!1,"transaction execution reverted","CALL_EXCEPTION",{action:"sendTransaction",data:null,reason:null,invocation:null,revert:null,transaction:{to:e.to,from:e.from,data:""},receipt:e})},f=await this.provider.getTransactionReceipt(this.hash);if(0===n)return d(f);if(f){if(1===n||await f.confirmations()>=n)return d(f)}else if(await c(),0===n)return null;const p=new Promise((e,t)=>{const s=[],i=()=>{s.forEach(e=>e())};if(s.push(()=>{o=!0}),r>0){const e=setTimeout(()=>{i(),t((0,l.xz)("wait for transaction timeout","TIMEOUT"))},r);s.push(()=>{clearTimeout(e)})}const u=async r=>{if(await r.confirmations()>=n){i();try{e(d(r))}catch(s){t(s)}}};if(s.push(()=>{this.provider.off(this.hash,u)}),this.provider.on(this.hash,u),a>=0){const e=async()=>{try{await c()}catch(n){if((0,l.bJ)(n,"TRANSACTION_REPLACED"))return i(),void t(n)}o||this.provider.once("block",e)};s.push(()=>{this.provider.off("block",e)}),this.provider.once("block",e)}});return await p}isMined(){return null!=this.blockHash}isLegacy(){return 0===this.type}isBerlin(){return 1===this.type}isLondon(){return 2===this.type}isCancun(){return 3===this.type}removedEvent(){return(0,l.vA)(this.isMined(),"unmined transaction canot be orphaned","UNSUPPORTED_OPERATION",{operation:"removeEvent()"}),E(this)}reorderedEvent(e){return(0,l.vA)(this.isMined(),"unmined transaction canot be orphaned","UNSUPPORTED_OPERATION",{operation:"removeEvent()"}),(0,l.vA)(!e||e.isMined(),"unmined 'other' transaction canot be orphaned","UNSUPPORTED_OPERATION",{operation:"removeEvent()"}),C(this,e)}replaceableTransaction(e){(0,l.MR)(Number.isInteger(e)&&e>=0,"invalid startBlock","startBlock",e);const t=new S(this,this.provider);return(0,a.A)(x,t,e),t}}function C(e,t){return{orphan:"reorder-transaction",tx:e,other:t}}function E(e){return{orphan:"drop-transaction",tx:e}}},9123(e,t,n){"use strict";n.d(t,{AC:()=>N,MY:()=>D,bs:()=>p,l8:()=>x,wF:()=>C});var r=n(9790),s=n(5149),a=n(6562),i=n(8458),o=n(2177);function l(e){return JSON.parse(JSON.stringify(e))}var c=new WeakMap,u=new WeakMap,d=new WeakMap,h=new WeakMap,f=new WeakSet;class p{constructor(e){(0,r.A)(this,f),(0,s.A)(this,c,void 0),(0,s.A)(this,u,void 0),(0,s.A)(this,d,void 0),(0,s.A)(this,h,void 0),(0,o.A)(c,this,e),(0,o.A)(u,this,null),(0,o.A)(d,this,4e3),(0,o.A)(h,this,-2)}get pollingInterval(){return(0,i.A)(d,this)}set pollingInterval(e){(0,o.A)(d,this,e)}start(){(0,i.A)(u,this)||((0,o.A)(u,this,(0,i.A)(c,this)._setTimeout((0,a.A)(f,this,m).bind(this),(0,i.A)(d,this))),(0,a.A)(f,this,m).call(this))}stop(){(0,i.A)(u,this)&&((0,i.A)(c,this)._clearTimeout((0,i.A)(u,this)),(0,o.A)(u,this,null))}pause(e){this.stop(),e&&(0,o.A)(h,this,-2)}resume(){this.start()}}async function m(){try{const e=await(0,i.A)(c,this).getBlockNumber();if(-2===(0,i.A)(h,this))return void(0,o.A)(h,this,e);if(e!==(0,i.A)(h,this)){for(let t=(0,i.A)(h,this)+1;t<=e;t++){if(null==(0,i.A)(u,this))return;await(0,i.A)(c,this).emit("block",t)}(0,o.A)(h,this,e)}}catch(e){}null!=(0,i.A)(u,this)&&(0,o.A)(u,this,(0,i.A)(c,this)._setTimeout((0,a.A)(f,this,m).bind(this),(0,i.A)(d,this)))}var g=new WeakMap,y=new WeakMap,w=new WeakMap;class v{constructor(e){(0,s.A)(this,g,void 0),(0,s.A)(this,y,void 0),(0,s.A)(this,w,void 0),(0,o.A)(g,this,e),(0,o.A)(w,this,!1),(0,o.A)(y,this,e=>{this._poll(e,(0,i.A)(g,this))})}async _poll(e,t){throw new Error("sub-classes must override this")}start(){(0,i.A)(w,this)||((0,o.A)(w,this,!0),(0,i.A)(y,this).call(this,-2),(0,i.A)(g,this).on("block",(0,i.A)(y,this)))}stop(){(0,i.A)(w,this)&&((0,o.A)(w,this,!1),(0,i.A)(g,this).off("block",(0,i.A)(y,this)))}pause(e){this.stop()}resume(){this.start()}}var A=new WeakMap,b=new WeakMap;class x extends v{constructor(e,t){super(e),(0,s.A)(this,A,void 0),(0,s.A)(this,b,void 0),(0,o.A)(A,this,t),(0,o.A)(b,this,-2)}pause(e){e&&(0,o.A)(b,this,-2),super.pause(e)}async _poll(e,t){const n=await t.getBlock((0,i.A)(A,this));null!=n&&(-2===(0,i.A)(b,this)?(0,o.A)(b,this,n.number):n.number>(0,i.A)(b,this)&&(t.emit((0,i.A)(A,this),n.number),(0,o.A)(b,this,n.number)))}}var S=new WeakMap;class C extends v{constructor(e,t){super(e),(0,s.A)(this,S,void 0),(0,o.A)(S,this,l(t))}async _poll(e,t){throw new Error("@TODO")}}var E=new WeakMap;class N extends v{constructor(e,t){super(e),(0,s.A)(this,E,void 0),(0,o.A)(E,this,t)}async _poll(e,t){const n=await t.getTransactionReceipt((0,i.A)(E,this));n&&t.emit((0,i.A)(E,this),n)}}var k=new WeakMap,T=new WeakMap,I=new WeakMap,_=new WeakMap,R=new WeakMap,M=new WeakSet;class D{constructor(e,t){(0,r.A)(this,M),(0,s.A)(this,k,void 0),(0,s.A)(this,T,void 0),(0,s.A)(this,I,void 0),(0,s.A)(this,_,void 0),(0,s.A)(this,R,void 0),(0,o.A)(k,this,e),(0,o.A)(T,this,l(t)),(0,o.A)(I,this,(0,a.A)(M,this,j).bind(this)),(0,o.A)(_,this,!1),(0,o.A)(R,this,-2)}start(){(0,i.A)(_,this)||((0,o.A)(_,this,!0),-2===(0,i.A)(R,this)&&(0,i.A)(k,this).getBlockNumber().then(e=>{(0,o.A)(R,this,e)}),(0,i.A)(k,this).on("block",(0,i.A)(I,this)))}stop(){(0,i.A)(_,this)&&((0,o.A)(_,this,!1),(0,i.A)(k,this).off("block",(0,i.A)(I,this)))}pause(e){this.stop(),e&&(0,o.A)(R,this,-2)}resume(){this.start()}}async function j(e){if(-2===(0,i.A)(R,this))return;const t=l((0,i.A)(T,this));t.fromBlock=(0,i.A)(R,this)+1,t.toBlock=e;const n=await(0,i.A)(k,this).getLogs(t);if(0!==n.length)for(const r of n)(0,i.A)(k,this).emit((0,i.A)(T,this),r),(0,o.A)(R,this,r.blockNumber);else(0,i.A)(R,this)<e-60&&(0,o.A)(R,this,e-60)}},1963(e,t,n){"use strict";n.d(t,{$:()=>o});var r=n(1009),s=n(686),a=n(5977);function i(e,t){return{address:(0,r.b)(e),storageKeys:t.map((e,t)=>((0,a.MR)((0,s.Lo)(e,32),"invalid slot","storageKeys[".concat(t,"]"),e),e.toLowerCase()))}}function o(e){if(Array.isArray(e))return e.map((t,n)=>Array.isArray(t)?((0,a.MR)(2===t.length,"invalid slot set","value[".concat(n,"]"),t),i(t[0],t[1])):((0,a.MR)(null!=t&&"object"===typeof t,"invalid address-slot set","value",e),i(t.address,t.storageKeys)));(0,a.MR)(null!=e&&"object"===typeof e,"invalid access list","value",e);const t=Object.keys(e).map(t=>{const n=e[t].reduce((e,t)=>(e[t]=!0,e),{});return i(t,Object.keys(n).sort())});return t.sort((e,t)=>e.address.localeCompare(t.address)),t}},5981(e,t,n){"use strict";n.d(t,{K:()=>i,x:()=>o});var r=n(1009),s=n(4248),a=n(3508);function i(e){let t;return t="string"===typeof e?a.h.computePublicKey(e,!1):e.publicKey,(0,r.b)((0,s.S)("0x"+t.substring(4)).substring(26))}function o(e,t){return i(a.h.recoverPublicKey(e,t))}},7848(e,t,n){"use strict";n.d(t,{M:()=>i});var r=n(1009),s=n(2876),a=n(2731);function i(e){return{address:(0,r.b)(e.address),nonce:(0,a.Ab)(null!=e.nonce?e.nonce:0),chainId:(0,a.Ab)(null!=e.chainId?e.chainId:0),signature:s.t.from(e.signature)}}},4681(e,t,n){"use strict";n.d(t,{Z:()=>re});var r=n(9790),s=n(5149),a=n(6562),i=n(2177),o=n(8458),l=n(1009),c=n(8152),u=n(4248),d=n(536),h=n(3508),f=n(2876),p=n(686),m=n(5977),g=n(2731),y=n(537),w=n(5889),v=n(1963),A=n(7848),b=n(5981);const x=BigInt(0),S=BigInt(2),C=BigInt(27),E=BigInt(28),N=BigInt(35),k=BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),T=131072;function I(e,t){let n=e.toString(16);for(;n.length<2;)n="0"+n;return n+=(0,d.s)(t).substring(4),"0x"+n}function _(e){return"0x"===e?null:(0,l.b)(e)}function R(e,t){try{return(0,v.$)(e)}catch(n){(0,m.MR)(!1,n.message,t,e)}}function M(e,t){try{if(!Array.isArray(e))throw new Error("authorizationList: invalid array");const t=[];for(let n=0;n<e.length;n++){const r=e[n];if(!Array.isArray(r))throw new Error("authorization[".concat(n,"]: invalid array"));if(6!==r.length)throw new Error("authorization[".concat(n,"]: wrong length"));if(!r[1])throw new Error("authorization[".concat(n,"]: null address"));t.push({address:_(r[1]),nonce:j(r[2],"nonce"),chainId:j(r[0],"chainId"),signature:f.t.from({yParity:D(r[3],"yParity"),r:(0,p.nx)(r[4],32),s:(0,p.nx)(r[5],32)})})}return t}catch(n){(0,m.MR)(!1,n.message,t,e)}}function D(e,t){return"0x"===e?0:(0,g.WZ)(e,t)}function j(e,t){if("0x"===e)return x;const n=(0,g.Ab)(e,t);return(0,m.MR)(n<=k,"value exceeds uint size",t,n),n}function O(e,t){const n=(0,g.Ab)(e,"value"),r=(0,g.c4)(n);return(0,m.MR)(r.length<=32,"value too large","tx.".concat(t),n),r}function P(e){return(0,v.$)(e).map(e=>[e.address,e.storageKeys])}function L(e,t){(0,m.MR)(Array.isArray(e),"invalid ".concat(t),"value",e);for(let n=0;n<e.length;n++)(0,m.MR)((0,p.Lo)(e[n],32),"invalid ${ param } hash","value[".concat(n,"]"),e[n]);return e}function B(e,t){let n;try{if(n=D(t[0],"yParity"),0!==n&&1!==n)throw new Error("bad yParity")}catch(i){(0,m.MR)(!1,"invalid yParity","yParity",t[0])}const r=(0,p.nx)(t[1],32),s=(0,p.nx)(t[2],32),a=f.t.from({r:r,s:s,yParity:n});e.signature=a}var F=new WeakMap,U=new WeakMap,W=new WeakMap,z=new WeakMap,H=new WeakMap,V=new WeakMap,G=new WeakMap,J=new WeakMap,Q=new WeakMap,K=new WeakMap,Y=new WeakMap,q=new WeakMap,X=new WeakMap,Z=new WeakMap,$=new WeakMap,ee=new WeakMap,te=new WeakMap,ne=new WeakSet;class re{get type(){return(0,o.A)(F,this)}set type(e){switch(e){case null:(0,i.A)(F,this,null);break;case 0:case"legacy":(0,i.A)(F,this,0);break;case 1:case"berlin":case"eip-2930":(0,i.A)(F,this,1);break;case 2:case"london":case"eip-1559":(0,i.A)(F,this,2);break;case 3:case"cancun":case"eip-4844":(0,i.A)(F,this,3);break;case 4:case"pectra":case"eip-7702":(0,i.A)(F,this,4);break;default:(0,m.MR)(!1,"unsupported transaction type","type",e)}}get typeName(){switch(this.type){case 0:return"legacy";case 1:return"eip-2930";case 2:return"eip-1559";case 3:return"eip-4844";case 4:return"eip-7702"}return null}get to(){const e=(0,o.A)(U,this);return null==e&&3===this.type?c.j:e}set to(e){(0,i.A)(U,this,null==e?null:(0,l.b)(e))}get nonce(){return(0,o.A)(z,this)}set nonce(e){(0,i.A)(z,this,(0,g.WZ)(e,"value"))}get gasLimit(){return(0,o.A)(H,this)}set gasLimit(e){(0,i.A)(H,this,(0,g.Ab)(e))}get gasPrice(){const e=(0,o.A)(V,this);return null!=e||0!==this.type&&1!==this.type?e:x}set gasPrice(e){(0,i.A)(V,this,null==e?null:(0,g.Ab)(e,"gasPrice"))}get maxPriorityFeePerGas(){const e=(0,o.A)(G,this);return null==e?2===this.type||3===this.type?x:null:e}set maxPriorityFeePerGas(e){(0,i.A)(G,this,null==e?null:(0,g.Ab)(e,"maxPriorityFeePerGas"))}get maxFeePerGas(){const e=(0,o.A)(J,this);return null==e?2===this.type||3===this.type?x:null:e}set maxFeePerGas(e){(0,i.A)(J,this,null==e?null:(0,g.Ab)(e,"maxFeePerGas"))}get data(){return(0,o.A)(W,this)}set data(e){(0,i.A)(W,this,(0,p.c$)(e))}get value(){return(0,o.A)(Q,this)}set value(e){(0,i.A)(Q,this,(0,g.Ab)(e,"value"))}get chainId(){return(0,o.A)(K,this)}set chainId(e){(0,i.A)(K,this,(0,g.Ab)(e))}get signature(){return(0,o.A)(Y,this)||null}set signature(e){(0,i.A)(Y,this,null==e?null:f.t.from(e))}get accessList(){const e=(0,o.A)(q,this)||null;return null==e?1===this.type||2===this.type||3===this.type?[]:null:e}set accessList(e){(0,i.A)(q,this,null==e?null:(0,v.$)(e))}get authorizationList(){const e=(0,o.A)(te,this)||null;return null==e&&4===this.type?[]:e}set authorizationList(e){(0,i.A)(te,this,null==e?null:e.map(e=>(0,A.M)(e)))}get maxFeePerBlobGas(){const e=(0,o.A)(X,this);return null==e&&3===this.type?x:e}set maxFeePerBlobGas(e){(0,i.A)(X,this,null==e?null:(0,g.Ab)(e,"maxFeePerBlobGas"))}get blobVersionedHashes(){let e=(0,o.A)(Z,this);return null==e&&3===this.type?[]:e}set blobVersionedHashes(e){if(null!=e){(0,m.MR)(Array.isArray(e),"blobVersionedHashes must be an Array","value",e),e=e.slice();for(let t=0;t<e.length;t++)(0,m.MR)((0,p.Lo)(e[t],32),"invalid blobVersionedHash","value[".concat(t,"]"),e[t])}(0,i.A)(Z,this,e)}get blobs(){return null==(0,o.A)(ee,this)?null:(0,o.A)(ee,this).map(e=>Object.assign({},e))}set blobs(e){if(null==e)return void(0,i.A)(ee,this,null);const t=[],n=[];for(let r=0;r<e.length;r++){const s=e[r];if((0,p.f)(s)){(0,m.vA)((0,o.A)($,this),"adding a raw blob requires a KZG library","UNSUPPORTED_OPERATION",{operation:"set blobs()"});let e=(0,p.q5)(s);if((0,m.MR)(e.length<=T,"blob is too large","blobs[".concat(r,"]"),s),e.length!==T){const t=new Uint8Array(T);t.set(e),e=t}const a=(0,o.A)($,this).blobToKzgCommitment(e),i=(0,p.c$)((0,o.A)($,this).computeBlobKzgProof(e,a));t.push({data:(0,p.c$)(e),commitment:(0,p.c$)(a),proof:i}),n.push(I(1,a))}else{const e=(0,p.c$)(s.commitment);t.push({data:(0,p.c$)(s.data),commitment:e,proof:(0,p.c$)(s.proof)}),n.push(I(1,e))}}(0,i.A)(ee,this,t),(0,i.A)(Z,this,n)}get kzg(){return(0,o.A)($,this)}set kzg(e){null==e?(0,i.A)($,this,null):(0,i.A)($,this,function(e){return{blobToKzgCommitment:t=>{if("computeBlobProof"in e){if("blobToKzgCommitment"in e&&"function"===typeof e.blobToKzgCommitment)return(0,p.q5)(e.blobToKzgCommitment((0,p.c$)(t)))}else if("blobToKzgCommitment"in e&&"function"===typeof e.blobToKzgCommitment)return(0,p.q5)(e.blobToKzgCommitment(t));if("blobToKZGCommitment"in e&&"function"===typeof e.blobToKZGCommitment)return(0,p.q5)(e.blobToKZGCommitment((0,p.c$)(t)));(0,m.MR)(!1,"unsupported KZG library","kzg",e)},computeBlobKzgProof:(t,n)=>"computeBlobProof"in e&&"function"===typeof e.computeBlobProof?(0,p.q5)(e.computeBlobProof((0,p.c$)(t),(0,p.c$)(n))):"computeBlobKzgProof"in e&&"function"===typeof e.computeBlobKzgProof?e.computeBlobKzgProof(t,n):"computeBlobKZGProof"in e&&"function"===typeof e.computeBlobKZGProof?(0,p.q5)(e.computeBlobKZGProof((0,p.c$)(t),(0,p.c$)(n))):void(0,m.MR)(!1,"unsupported KZG library","kzg",e)}}(e))}constructor(){(0,r.A)(this,ne),(0,s.A)(this,F,void 0),(0,s.A)(this,U,void 0),(0,s.A)(this,W,void 0),(0,s.A)(this,z,void 0),(0,s.A)(this,H,void 0),(0,s.A)(this,V,void 0),(0,s.A)(this,G,void 0),(0,s.A)(this,J,void 0),(0,s.A)(this,Q,void 0),(0,s.A)(this,K,void 0),(0,s.A)(this,Y,void 0),(0,s.A)(this,q,void 0),(0,s.A)(this,X,void 0),(0,s.A)(this,Z,void 0),(0,s.A)(this,$,void 0),(0,s.A)(this,ee,void 0),(0,s.A)(this,te,void 0),(0,i.A)(F,this,null),(0,i.A)(U,this,null),(0,i.A)(z,this,0),(0,i.A)(H,this,x),(0,i.A)(V,this,null),(0,i.A)(G,this,null),(0,i.A)(J,this,null),(0,i.A)(W,this,"0x"),(0,i.A)(Q,this,x),(0,i.A)(K,this,x),(0,i.A)(Y,this,null),(0,i.A)(q,this,null),(0,i.A)(X,this,null),(0,i.A)(Z,this,null),(0,i.A)($,this,null),(0,i.A)(ee,this,null),(0,i.A)(te,this,null)}get hash(){return null==this.signature?null:(0,u.S)((0,a.A)(ne,this,se).call(this,!0,!1))}get unsignedHash(){return(0,u.S)(this.unsignedSerialized)}get from(){return null==this.signature?null:(0,b.x)(this.unsignedHash,this.signature)}get fromPublicKey(){return null==this.signature?null:h.h.recoverPublicKey(this.unsignedHash,this.signature)}isSigned(){return null!=this.signature}get serialized(){return(0,a.A)(ne,this,se).call(this,!0,!0)}get unsignedSerialized(){return(0,a.A)(ne,this,se).call(this,!1,!1)}inferType(){const e=this.inferTypes();return e.indexOf(2)>=0?2:e.pop()}inferTypes(){const e=null!=this.gasPrice,t=null!=this.maxFeePerGas||null!=this.maxPriorityFeePerGas,n=null!=this.accessList,r=null!=(0,o.A)(X,this)||(0,o.A)(Z,this);null!=this.maxFeePerGas&&null!=this.maxPriorityFeePerGas&&(0,m.vA)(this.maxFeePerGas>=this.maxPriorityFeePerGas,"priorityFee cannot be more than maxFee","BAD_DATA",{value:this}),(0,m.vA)(!t||0!==this.type&&1!==this.type,"transaction type cannot have maxFeePerGas or maxPriorityFeePerGas","BAD_DATA",{value:this}),(0,m.vA)(0!==this.type||!n,"legacy transaction cannot have accessList","BAD_DATA",{value:this});const s=[];return null!=this.type?s.push(this.type):this.authorizationList&&this.authorizationList.length?s.push(4):t?s.push(2):e?(s.push(1),n||s.push(0)):n?(s.push(1),s.push(2)):(r&&this.to||(s.push(0),s.push(1),s.push(2)),s.push(3)),s.sort(),s}isLegacy(){return 0===this.type}isBerlin(){return 1===this.type}isLondon(){return 2===this.type}isCancun(){return 3===this.type}clone(){return re.from(this)}toJSON(){const e=e=>null==e?null:e.toString();return{type:this.type,to:this.to,data:this.data,nonce:this.nonce,gasLimit:e(this.gasLimit),gasPrice:e(this.gasPrice),maxPriorityFeePerGas:e(this.maxPriorityFeePerGas),maxFeePerGas:e(this.maxFeePerGas),value:e(this.value),chainId:e(this.chainId),sig:this.signature?this.signature.toJSON():null,accessList:this.accessList}}static from(e){if(null==e)return new re;if("string"===typeof e){const t=(0,p.q5)(e);if(t[0]>=127)return re.from(function(e){const t=(0,y.J)(e);(0,m.MR)(Array.isArray(t)&&(9===t.length||6===t.length),"invalid field count for legacy transaction","data",e);const n={type:0,nonce:D(t[0],"nonce"),gasPrice:j(t[1],"gasPrice"),gasLimit:j(t[2],"gasLimit"),to:_(t[3]),value:j(t[4],"value"),data:(0,p.c$)(t[5]),chainId:x};if(6===t.length)return n;const r=j(t[6],"v"),s=j(t[7],"r"),a=j(t[8],"s");if(s===x&&a===x)n.chainId=r;else{let e=(r-N)/S;e<x&&(e=x),n.chainId=e,(0,m.MR)(e!==x||r===C||r===E,"non-canonical legacy v","v",t[6]),n.signature=f.t.from({r:(0,p.nx)(t[7],32),s:(0,p.nx)(t[8],32),v:r})}return n}(t));switch(t[0]){case 1:return re.from(function(e){const t=(0,y.J)((0,p.q5)(e).slice(1));(0,m.MR)(Array.isArray(t)&&(8===t.length||11===t.length),"invalid field count for transaction type: 1","data",(0,p.c$)(e));const n={type:1,chainId:j(t[0],"chainId"),nonce:D(t[1],"nonce"),gasPrice:j(t[2],"gasPrice"),gasLimit:j(t[3],"gasLimit"),to:_(t[4]),value:j(t[5],"value"),data:(0,p.c$)(t[6]),accessList:R(t[7],"accessList")};return 8===t.length||B(n,t.slice(8)),n}(t));case 2:return re.from(function(e){const t=(0,y.J)((0,p.q5)(e).slice(1));(0,m.MR)(Array.isArray(t)&&(9===t.length||12===t.length),"invalid field count for transaction type: 2","data",(0,p.c$)(e));const n={type:2,chainId:j(t[0],"chainId"),nonce:D(t[1],"nonce"),maxPriorityFeePerGas:j(t[2],"maxPriorityFeePerGas"),maxFeePerGas:j(t[3],"maxFeePerGas"),gasPrice:null,gasLimit:j(t[4],"gasLimit"),to:_(t[5]),value:j(t[6],"value"),data:(0,p.c$)(t[7]),accessList:R(t[8],"accessList")};return 9===t.length||B(n,t.slice(9)),n}(t));case 3:return re.from(function(e){let t=(0,y.J)((0,p.q5)(e).slice(1)),n="3",r=null;if(4===t.length&&Array.isArray(t[0])){n="3 (network format)";const e=t[1],s=t[2],a=t[3];(0,m.MR)(Array.isArray(e),"invalid network format: blobs not an array","fields[1]",e),(0,m.MR)(Array.isArray(s),"invalid network format: commitments not an array","fields[2]",s),(0,m.MR)(Array.isArray(a),"invalid network format: proofs not an array","fields[3]",a),(0,m.MR)(e.length===s.length,"invalid network format: blobs/commitments length mismatch","fields",t),(0,m.MR)(e.length===a.length,"invalid network format: blobs/proofs length mismatch","fields",t),r=[];for(let n=0;n<t[1].length;n++)r.push({data:e[n],commitment:s[n],proof:a[n]});t=t[0]}(0,m.MR)(Array.isArray(t)&&(11===t.length||14===t.length),"invalid field count for transaction type: ".concat(n),"data",(0,p.c$)(e));const s={type:3,chainId:j(t[0],"chainId"),nonce:D(t[1],"nonce"),maxPriorityFeePerGas:j(t[2],"maxPriorityFeePerGas"),maxFeePerGas:j(t[3],"maxFeePerGas"),gasPrice:null,gasLimit:j(t[4],"gasLimit"),to:_(t[5]),value:j(t[6],"value"),data:(0,p.c$)(t[7]),accessList:R(t[8],"accessList"),maxFeePerBlobGas:j(t[9],"maxFeePerBlobGas"),blobVersionedHashes:t[10]};r&&(s.blobs=r),(0,m.MR)(null!=s.to,"invalid address for transaction type: ".concat(n),"data",e),(0,m.MR)(Array.isArray(s.blobVersionedHashes),"invalid blobVersionedHashes: must be an array","data",e);for(let a=0;a<s.blobVersionedHashes.length;a++)(0,m.MR)((0,p.Lo)(s.blobVersionedHashes[a],32),"invalid blobVersionedHash at index ".concat(a,": must be length 32"),"data",e);return 11===t.length||B(s,t.slice(11)),s}(t));case 4:return re.from(function(e){const t=(0,y.J)((0,p.q5)(e).slice(1));(0,m.MR)(Array.isArray(t)&&(10===t.length||13===t.length),"invalid field count for transaction type: 4","data",(0,p.c$)(e));const n={type:4,chainId:j(t[0],"chainId"),nonce:D(t[1],"nonce"),maxPriorityFeePerGas:j(t[2],"maxPriorityFeePerGas"),maxFeePerGas:j(t[3],"maxFeePerGas"),gasPrice:null,gasLimit:j(t[4],"gasLimit"),to:_(t[5]),value:j(t[6],"value"),data:(0,p.c$)(t[7]),accessList:R(t[8],"accessList"),authorizationList:M(t[9],"authorizationList")};return 10===t.length||B(n,t.slice(10)),n}(t))}(0,m.vA)(!1,"unsupported transaction type","UNSUPPORTED_OPERATION",{operation:"from"})}const t=new re;return null!=e.type&&(t.type=e.type),null!=e.to&&(t.to=e.to),null!=e.nonce&&(t.nonce=e.nonce),null!=e.gasLimit&&(t.gasLimit=e.gasLimit),null!=e.gasPrice&&(t.gasPrice=e.gasPrice),null!=e.maxPriorityFeePerGas&&(t.maxPriorityFeePerGas=e.maxPriorityFeePerGas),null!=e.maxFeePerGas&&(t.maxFeePerGas=e.maxFeePerGas),null!=e.maxFeePerBlobGas&&(t.maxFeePerBlobGas=e.maxFeePerBlobGas),null!=e.data&&(t.data=e.data),null!=e.value&&(t.value=e.value),null!=e.chainId&&(t.chainId=e.chainId),null!=e.signature&&(t.signature=f.t.from(e.signature)),null!=e.accessList&&(t.accessList=e.accessList),null!=e.authorizationList&&(t.authorizationList=e.authorizationList),null!=e.blobVersionedHashes&&(t.blobVersionedHashes=e.blobVersionedHashes),null!=e.kzg&&(t.kzg=e.kzg),null!=e.blobs&&(t.blobs=e.blobs),null!=e.hash&&((0,m.MR)(t.isSigned(),"unsigned transaction cannot define '.hash'","tx",e),(0,m.MR)(t.hash===e.hash,"hash mismatch","tx",e)),null!=e.from&&((0,m.MR)(t.isSigned(),"unsigned transaction cannot define '.from'","tx",e),(0,m.MR)(t.from.toLowerCase()===(e.from||"").toLowerCase(),"from mismatch","tx",e)),t}}function se(e,t){(0,m.vA)(!e||null!=this.signature,"cannot serialize unsigned transaction; maybe you meant .unsignedSerialized","UNSUPPORTED_OPERATION",{operation:".serialized"});const n=e?this.signature:null;switch(this.inferType()){case 0:return function(e,t){const n=[O(e.nonce,"nonce"),O(e.gasPrice||0,"gasPrice"),O(e.gasLimit,"gasLimit"),e.to||"0x",O(e.value,"value"),e.data];let r=x;if(e.chainId!=x)r=(0,g.Ab)(e.chainId,"tx.chainId"),(0,m.MR)(!t||null==t.networkV||t.legacyChainId===r,"tx.chainId/sig.v mismatch","sig",t);else if(e.signature){const t=e.signature.legacyChainId;null!=t&&(r=t)}if(!t)return r!==x&&(n.push((0,g.c4)(r)),n.push("0x"),n.push("0x")),(0,w.R)(n);let s=BigInt(27+t.yParity);return r!==x?s=f.t.getChainIdV(r,t.v):BigInt(t.v)!==s&&(0,m.MR)(!1,"tx.chainId/sig.v mismatch","sig",t),n.push((0,g.c4)(s)),n.push((0,g.c4)(t.r)),n.push((0,g.c4)(t.s)),(0,w.R)(n)}(this,n);case 1:return function(e,t){const n=[O(e.chainId,"chainId"),O(e.nonce,"nonce"),O(e.gasPrice||0,"gasPrice"),O(e.gasLimit,"gasLimit"),e.to||"0x",O(e.value,"value"),e.data,P(e.accessList||[])];return t&&(n.push(O(t.yParity,"recoveryParam")),n.push((0,g.c4)(t.r)),n.push((0,g.c4)(t.s))),(0,p.xW)(["0x01",(0,w.R)(n)])}(this,n);case 2:return function(e,t){const n=[O(e.chainId,"chainId"),O(e.nonce,"nonce"),O(e.maxPriorityFeePerGas||0,"maxPriorityFeePerGas"),O(e.maxFeePerGas||0,"maxFeePerGas"),O(e.gasLimit,"gasLimit"),e.to||"0x",O(e.value,"value"),e.data,P(e.accessList||[])];return t&&(n.push(O(t.yParity,"yParity")),n.push((0,g.c4)(t.r)),n.push((0,g.c4)(t.s))),(0,p.xW)(["0x02",(0,w.R)(n)])}(this,n);case 3:return function(e,t,n){const r=[O(e.chainId,"chainId"),O(e.nonce,"nonce"),O(e.maxPriorityFeePerGas||0,"maxPriorityFeePerGas"),O(e.maxFeePerGas||0,"maxFeePerGas"),O(e.gasLimit,"gasLimit"),e.to||c.j,O(e.value,"value"),e.data,P(e.accessList||[]),O(e.maxFeePerBlobGas||0,"maxFeePerBlobGas"),L(e.blobVersionedHashes||[],"blobVersionedHashes")];return t&&(r.push(O(t.yParity,"yParity")),r.push((0,g.c4)(t.r)),r.push((0,g.c4)(t.s)),n)?(0,p.xW)(["0x03",(0,w.R)([r,n.map(e=>e.data),n.map(e=>e.commitment),n.map(e=>e.proof)])]):(0,p.xW)(["0x03",(0,w.R)(r)])}(this,n,t?this.blobs:null);case 4:return function(e,t){const n=[O(e.chainId,"chainId"),O(e.nonce,"nonce"),O(e.maxPriorityFeePerGas||0,"maxPriorityFeePerGas"),O(e.maxFeePerGas||0,"maxFeePerGas"),O(e.gasLimit,"gasLimit"),e.to||"0x",O(e.value,"value"),e.data,P(e.accessList||[]),(r=e.authorizationList||[],r.map(e=>[O(e.chainId,"chainId"),e.address,O(e.nonce,"nonce"),O(e.signature.yParity,"yParity"),(0,g.c4)(e.signature.r),(0,g.c4)(e.signature.s)]))];var r;return t&&(n.push(O(t.yParity,"yParity")),n.push((0,g.c4)(t.r)),n.push((0,g.c4)(t.s))),(0,p.xW)(["0x04",(0,w.R)(n)])}(this,n)}(0,m.vA)(!1,"unsupported transaction type","UNSUPPORTED_OPERATION",{operation:".serialized"})}},70(e,t,n){"use strict";n.d(t,{H:()=>h,R:()=>d});var r=n(686),s=n(5977),a=n(2731);const i="123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";let o=null;function l(e){if(null==o){o={};for(let e=0;e<58;e++)o[i[e]]=BigInt(e)}const t=o[e];return(0,s.MR)(null!=t,"invalid base58 value","letter",e),t}const c=BigInt(0),u=BigInt(58);function d(e){const t=(0,r.q5)(e);let n=(0,a.Dg)(t),s="";for(;n;)s=i[Number(n%u)]+s,n/=u;for(let r=0;r<t.length&&!t[r];r++)s=i[0]+s;return s}function h(e){let t=c;for(let n=0;n<e.length;n++)t*=u,t+=l(e[n]);return t}},1612(e,t,n){"use strict";n.d(t,{W:()=>a,y:()=>s});var r=n(686);function s(e){e=atob(e);const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)t[n]=e.charCodeAt(n);return(0,r.q5)(t)}function a(e){const t=(0,r.q5)(e);let n="";for(let r=0;r<t.length;r++)n+=String.fromCharCode(t[r]);return btoa(n)}},686(e,t,n){"use strict";n.d(t,{Lm:()=>i,Lo:()=>o,X_:()=>y,ZG:()=>f,c$:()=>u,f:()=>l,nx:()=>g,pO:()=>h,q5:()=>a,xW:()=>d,zX:()=>p});var r=n(5977);function s(e,t,n){if(e instanceof Uint8Array)return n?new Uint8Array(e):e;if("string"===typeof e&&e.match(/^0x(?:[0-9a-f][0-9a-f])*$/i)){const t=new Uint8Array((e.length-2)/2);let n=2;for(let r=0;r<t.length;r++)t[r]=parseInt(e.substring(n,n+2),16),n+=2;return t}(0,r.MR)(!1,"invalid BytesLike value",t||"value",e)}function a(e,t){return s(e,t,!1)}function i(e,t){return s(e,t,!0)}function o(e,t){return!("string"!==typeof e||!e.match(/^0x[0-9A-Fa-f]*$/))&&(("number"!==typeof t||e.length===2+2*t)&&(!0!==t||e.length%2===0))}function l(e){return o(e,!0)||e instanceof Uint8Array}const c="0123456789abcdef";function u(e){const t=a(e);let n="0x";for(let r=0;r<t.length;r++){const e=t[r];n+=c[(240&e)>>4]+c[15&e]}return n}function d(e){return"0x"+e.map(e=>u(e).substring(2)).join("")}function h(e){return o(e,!0)?(e.length-2)/2:a(e).length}function f(e,t,n){const s=a(e);return null!=n&&n>s.length&&(0,r.vA)(!1,"cannot slice beyond data bounds","BUFFER_OVERRUN",{buffer:s,length:s.length,offset:n}),u(s.slice(null==t?0:t,null==n?s.length:n))}function p(e){let t=u(e).substring(2);for(;t.startsWith("00");)t=t.substring(2);return"0x"+t}function m(e,t,n){const s=a(e);(0,r.vA)(t>=s.length,"padding exceeds data length","BUFFER_OVERRUN",{buffer:new Uint8Array(s),length:t,offset:t+1});const i=new Uint8Array(t);return i.fill(0),n?i.set(s,t-s.length):i.set(s,0),u(i)}function g(e,t){return m(e,t,!0)}function y(e,t){return m(e,t,!1)}},5977(e,t,n){"use strict";n.d(t,{E:()=>o,MR:()=>u,SP:()=>f,bJ:()=>i,dd:()=>d,gk:()=>p,vA:()=>c,xz:()=>l});var r=n(8051),s=n(3451);function a(e,t){if(null==e)return"null";if(null==t&&(t=new Set),"object"===typeof e){if(t.has(e))return"[Circular]";t.add(e)}if(Array.isArray(e))return"[ "+e.map(e=>a(e,t)).join(", ")+" ]";if(e instanceof Uint8Array){const t="0123456789abcdef";let n="0x";for(let r=0;r<e.length;r++)n+=t[e[r]>>4],n+=t[15&e[r]];return n}if("object"===typeof e&&"function"===typeof e.toJSON)return a(e.toJSON(),t);switch(typeof e){case"boolean":case"number":case"symbol":return e.toString();case"bigint":return BigInt(e).toString();case"string":return JSON.stringify(e);case"object":{const n=Object.keys(e);return n.sort(),"{ "+n.map(n=>"".concat(a(n,t),": ").concat(a(e[n],t))).join(", ")+" }"}}return"[ COULD NOT SERIALIZE ]"}function i(e,t){return e&&e.code===t}function o(e){return i(e,"CALL_EXCEPTION")}function l(e,t,n){let i,o=e;{const s=[];if(n){if("message"in n||"code"in n||"name"in n)throw new Error("value will overwrite populated values: ".concat(a(n)));for(const e in n){if("shortMessage"===e)continue;const t=n[e];s.push(e+"="+a(t))}}s.push("code=".concat(t)),s.push("version=".concat(r.r)),s.length&&(e+=" ("+s.join(", ")+")")}switch(t){case"INVALID_ARGUMENT":i=new TypeError(e);break;case"NUMERIC_FAULT":case"BUFFER_OVERRUN":i=new RangeError(e);break;default:i=new Error(e)}return(0,s.n)(i,{code:t}),n&&Object.assign(i,n),null==i.shortMessage&&(0,s.n)(i,{shortMessage:o}),i}function c(e,t,n,r){if(!e)throw l(t,n,r)}function u(e,t,n,r){c(e,t,"INVALID_ARGUMENT",{argument:n,value:r})}function d(e,t,n){null==n&&(n=""),n&&(n=": "+n),c(e>=t,"missing argument"+n,"MISSING_ARGUMENT",{count:e,expectedCount:t}),c(e<=t,"too many arguments"+n,"UNEXPECTED_ARGUMENT",{count:e,expectedCount:t})}const h=["NFD","NFC","NFKD","NFKC"].reduce((e,t)=>{try{if("test"!=="test".normalize(t))throw new Error("bad");if("NFD"===t){const e=String.fromCharCode(233).normalize("NFD");if(e!==String.fromCharCode(101,769))throw new Error("broken")}e.push(t)}catch(n){}return e},[]);function f(e){c(h.indexOf(e)>=0,"platform missing String.prototype.normalize","UNSUPPORTED_OPERATION",{operation:"String.prototype.normalize",info:{form:e}})}function p(e,t,n){if(null==n&&(n=""),e!==t){let e=n,t="new";n&&(e+=".",t+=" "+n),c(!1,"private constructor; use ".concat(e,"from* methods"),"UNSUPPORTED_OPERATION",{operation:t})}}},7867(e,t,n){"use strict";n.d(t,{z:()=>c});var r=n(5149),s=n(4705),a=n(8458),i=n(2177),o=n(3451),l=new WeakMap;class c{constructor(e,t,n){(0,s.A)(this,"filter",void 0),(0,s.A)(this,"emitter",void 0),(0,r.A)(this,l,void 0),(0,i.A)(l,this,t),(0,o.n)(this,{emitter:e,filter:n})}async removeListener(){null!=(0,a.A)(l,this)&&await this.emitter.off(this.filter,(0,a.A)(l,this))}}},9197(e,t,n){"use strict";n.d(t,{Tf:()=>C,ui:()=>z,Aj:()=>q});var r=n(9790),s=n(6562),a=n(5149),i=n(8458),o=n(2177),l=n(1612),c=n(686),u=n(5977),d=n(3451),h=n(85);function f(e){return async function(t,n){(0,u.vA)(null==n||!n.cancelled,"request cancelled before sending","CANCELLED");const r=t.url.split(":")[0].toLowerCase();(0,u.vA)("http"===r||"https"===r,"unsupported protocol ".concat(r),"UNSUPPORTED_OPERATION",{info:{protocol:r},operation:"request"}),(0,u.vA)("https"===r||!t.credentials||t.allowInsecureAuthentication,"insecure authorized connections unsupported","UNSUPPORTED_OPERATION",{operation:"request"});let s=null;const a=new AbortController,i=setTimeout(()=>{s=(0,u.xz)("request timeout","TIMEOUT"),a.abort()},t.timeout);n&&n.addListener(()=>{s=(0,u.xz)("request cancelled","CANCELLED"),a.abort()});const o=Object.assign({},e,{method:t.method,headers:new Headers(Array.from(t)),body:t.body||void 0,signal:a.signal});let l;try{l=await fetch(t.url,o)}catch(Y){if(clearTimeout(i),s)throw s;throw Y}clearTimeout(i);const c={};l.headers.forEach((e,t)=>{c[t.toLowerCase()]=e});const d=await l.arrayBuffer(),h=null==d?null:new Uint8Array(d);return{statusCode:l.status,statusMessage:l.statusText,headers:c,body:h}}}f({});let p=f();const m=new RegExp("^data:([^;:]*)?(;base64)?,(.*)$","i"),g=new RegExp("^ipfs://(ipfs/)?(.*)$","i");let y=!1;async function w(e,t){try{const t=e.match(m);if(!t)throw new Error("invalid data");return new q(200,"OK",{"content-type":t[1]||"text/plain"},t[2]?(0,l.y)(t[3]):(n=t[3],(0,h.YW)(n.replace(/%([0-9a-f][0-9a-f])/gi,(e,t)=>String.fromCharCode(parseInt(t,16))))))}catch(r){return new q(599,"BAD REQUEST (invalid data: URI)",{},null,new z(e))}var n}function v(e){return async function(t,n){try{const n=t.match(g);if(!n)throw new Error("invalid link");return new z("".concat(e).concat(n[2]))}catch(r){return new q(599,"BAD REQUEST (invalid IPFS URI)",{},null,new z(t))}}}const A={data:w,ipfs:v("https://gateway.ipfs.io/ipfs/")},b=new WeakMap;var x=new WeakMap,S=new WeakMap;class C{constructor(e){(0,a.A)(this,x,void 0),(0,a.A)(this,S,void 0),(0,o.A)(x,this,[]),(0,o.A)(S,this,!1),b.set(e,()=>{if(!(0,i.A)(S,this)){(0,o.A)(S,this,!0);for(const e of(0,i.A)(x,this))setTimeout(()=>{e()},0);(0,o.A)(x,this,[])}})}addListener(e){(0,u.vA)(!(0,i.A)(S,this),"singal already cancelled","UNSUPPORTED_OPERATION",{operation:"fetchCancelSignal.addCancelListener"}),(0,i.A)(x,this).push(e)}get cancelled(){return(0,i.A)(S,this)}checkSignal(){(0,u.vA)(!this.cancelled,"cancelled","CANCELLED",{})}}function E(e){if(null==e)throw new Error("missing signal; should not happen");return e.checkSignal(),e}var N=new WeakMap,k=new WeakMap,T=new WeakMap,I=new WeakMap,_=new WeakMap,R=new WeakMap,M=new WeakMap,D=new WeakMap,j=new WeakMap,O=new WeakMap,P=new WeakMap,L=new WeakMap,B=new WeakMap,F=new WeakMap,U=new WeakMap,W=new WeakSet;class z{get url(){return(0,i.A)(R,this)}set url(e){(0,o.A)(R,this,String(e))}get body(){return null==(0,i.A)(M,this)?null:new Uint8Array((0,i.A)(M,this))}set body(e){if(null==e)(0,o.A)(M,this,void 0),(0,o.A)(D,this,void 0);else if("string"===typeof e)(0,o.A)(M,this,(0,h.YW)(e)),(0,o.A)(D,this,"text/plain");else if(e instanceof Uint8Array)(0,o.A)(M,this,e),(0,o.A)(D,this,"application/octet-stream");else{if("object"!==typeof e)throw new Error("invalid body");(0,o.A)(M,this,(0,h.YW)(JSON.stringify(e))),(0,o.A)(D,this,"application/json")}}hasBody(){return null!=(0,i.A)(M,this)}get method(){return(0,i.A)(I,this)?(0,i.A)(I,this):this.hasBody()?"POST":"GET"}set method(e){null==e&&(e=""),(0,o.A)(I,this,String(e).toUpperCase())}get headers(){const e=Object.assign({},(0,i.A)(T,this));return(0,i.A)(j,this)&&(e.authorization="Basic ".concat((0,l.W)((0,h.YW)((0,i.A)(j,this))))),this.allowGzip&&(e["accept-encoding"]="gzip"),null==e["content-type"]&&(0,i.A)(D,this)&&(e["content-type"]=(0,i.A)(D,this)),this.body&&(e["content-length"]=String(this.body.length)),e}getHeader(e){return this.headers[e.toLowerCase()]}setHeader(e,t){(0,i.A)(T,this)[String(e).toLowerCase()]=String(t)}clearHeaders(){(0,o.A)(T,this,{})}[Symbol.iterator](){const e=this.headers,t=Object.keys(e);let n=0;return{next:()=>{if(n<t.length){const r=t[n++];return{value:[r,e[r]],done:!1}}return{value:void 0,done:!0}}}}get credentials(){return(0,i.A)(j,this)||null}setCredentials(e,t){(0,u.MR)(!e.match(/:/),"invalid basic authentication username","username","[REDACTED]"),(0,o.A)(j,this,"".concat(e,":").concat(t))}get allowGzip(){return(0,i.A)(k,this)}set allowGzip(e){(0,o.A)(k,this,!!e)}get allowInsecureAuthentication(){return!!(0,i.A)(N,this)}set allowInsecureAuthentication(e){(0,o.A)(N,this,!!e)}get timeout(){return(0,i.A)(_,this)}set timeout(e){(0,u.MR)(e>=0,"timeout must be non-zero","timeout",e),(0,o.A)(_,this,e)}get preflightFunc(){return(0,i.A)(O,this)||null}set preflightFunc(e){(0,o.A)(O,this,e)}get processFunc(){return(0,i.A)(P,this)||null}set processFunc(e){(0,o.A)(P,this,e)}get retryFunc(){return(0,i.A)(L,this)||null}set retryFunc(e){(0,o.A)(L,this,e)}get getUrlFunc(){return(0,i.A)(U,this)||p}set getUrlFunc(e){(0,o.A)(U,this,e)}constructor(e){(0,r.A)(this,W),(0,a.A)(this,N,void 0),(0,a.A)(this,k,void 0),(0,a.A)(this,T,void 0),(0,a.A)(this,I,void 0),(0,a.A)(this,_,void 0),(0,a.A)(this,R,void 0),(0,a.A)(this,M,void 0),(0,a.A)(this,D,void 0),(0,a.A)(this,j,void 0),(0,a.A)(this,O,void 0),(0,a.A)(this,P,void 0),(0,a.A)(this,L,void 0),(0,a.A)(this,B,void 0),(0,a.A)(this,F,void 0),(0,a.A)(this,U,void 0),(0,o.A)(R,this,String(e)),(0,o.A)(N,this,!1),(0,o.A)(k,this,!0),(0,o.A)(T,this,{}),(0,o.A)(I,this,""),(0,o.A)(_,this,3e5),(0,o.A)(F,this,{slotInterval:250,maxAttempts:12}),(0,o.A)(U,this,null)}toString(){return"<FetchRequest method=".concat(JSON.stringify(this.method)," url=").concat(JSON.stringify(this.url)," headers=").concat(JSON.stringify(this.headers)," body=").concat((0,i.A)(M,this)?(0,c.c$)((0,i.A)(M,this)):"null",">")}setThrottleParams(e){null!=e.slotInterval&&((0,i.A)(F,this).slotInterval=e.slotInterval),null!=e.maxAttempts&&((0,i.A)(F,this).maxAttempts=e.maxAttempts)}send(){return(0,u.vA)(null==(0,i.A)(B,this),"request already sent","UNSUPPORTED_OPERATION",{operation:"fetchRequest.send"}),(0,o.A)(B,this,new C(this)),(0,s.A)(W,this,H).call(this,0,X()+this.timeout,0,this,new q(0,"",{},null,this))}cancel(){(0,u.vA)(null!=(0,i.A)(B,this),"request has not been sent","UNSUPPORTED_OPERATION",{operation:"fetchRequest.cancel"});const e=b.get(this);if(!e)throw new Error("missing signal; should not happen");e()}redirect(e){const t=this.url.split(":")[0].toLowerCase(),n=e.split(":")[0].toLowerCase();(0,u.vA)("GET"===this.method&&("https"!==t||"http"!==n)&&e.match(/^https?:/),"unsupported redirect","UNSUPPORTED_OPERATION",{operation:"redirect(".concat(this.method," ").concat(JSON.stringify(this.url)," => ").concat(JSON.stringify(e),")")});const r=new z(e);return r.method="GET",r.allowGzip=this.allowGzip,r.timeout=this.timeout,(0,o.A)(T,r,Object.assign({},(0,i.A)(T,this))),(0,i.A)(M,this)&&(0,o.A)(M,r,new Uint8Array((0,i.A)(M,this))),(0,o.A)(D,r,(0,i.A)(D,this)),r}clone(){const e=new z(this.url);return(0,o.A)(I,e,(0,i.A)(I,this)),(0,i.A)(M,this)&&(0,o.A)(M,e,(0,i.A)(M,this)),(0,o.A)(D,e,(0,i.A)(D,this)),(0,o.A)(T,e,Object.assign({},(0,i.A)(T,this))),(0,o.A)(j,e,(0,i.A)(j,this)),this.allowGzip&&(e.allowGzip=!0),e.timeout=this.timeout,this.allowInsecureAuthentication&&(e.allowInsecureAuthentication=!0),(0,o.A)(O,e,(0,i.A)(O,this)),(0,o.A)(P,e,(0,i.A)(P,this)),(0,o.A)(L,e,(0,i.A)(L,this)),(0,o.A)(F,e,Object.assign({},(0,i.A)(F,this))),(0,o.A)(U,e,(0,i.A)(U,this)),e}static lockConfig(){y=!0}static getGateway(e){return A[e.toLowerCase()]||null}static registerGateway(e,t){if("http"===(e=e.toLowerCase())||"https"===e)throw new Error("cannot intercept ".concat(e,"; use registerGetUrl"));if(y)throw new Error("gateways locked");A[e]=t}static registerGetUrl(e){if(y)throw new Error("gateways locked");p=e}static createGetUrlFunc(e){return f(e)}static createDataGateway(){return w}static createIpfsGatewayFunc(e){return v(e)}}async function H(e,t,n,r,a){if(e>=(0,i.A)(F,this).maxAttempts)return a.makeServerError("exceeded maximum retry limit");(0,u.vA)(X()<=t,"timeout","TIMEOUT",{operation:"request.send",reason:"timeout",request:r}),n>0&&await function(e){return new Promise(t=>setTimeout(t,e))}(n);let o=this.clone();const l=(o.url.split(":")[0]||"").toLowerCase();if(l in A){const e=await A[l](o.url,E((0,i.A)(B,r)));if(e instanceof q){let t=e;if(this.processFunc){E((0,i.A)(B,r));try{t=await this.processFunc(o,t)}catch(m){null!=m.throttle&&"number"===typeof m.stall||t.makeServerError("error in post-processing function",m).assertOk()}}return t}o=e}this.preflightFunc&&(o=await this.preflightFunc(o));const c=await this.getUrlFunc(o,E((0,i.A)(B,r)));let d=new q(c.statusCode,c.statusMessage,c.headers,c.body,r);if(301===d.statusCode||302===d.statusCode){try{var h;const n=d.headers.location||"";return(0,s.A)(W,h=o.redirect(n),H).call(h,e+1,t,0,r,d)}catch(m){}return d}if(429===d.statusCode&&(null==this.retryFunc||await this.retryFunc(o,d,e))){var f;const n=d.headers["retry-after"];let a=(0,i.A)(F,this).slotInterval*Math.trunc(Math.random()*Math.pow(2,e));return"string"===typeof n&&n.match(/^[1-9][0-9]*$/)&&(a=parseInt(n)),(0,s.A)(W,f=o.clone(),H).call(f,e+1,t,a,r,d)}if(this.processFunc){E((0,i.A)(B,r));try{d=await this.processFunc(o,d)}catch(m){var p;null!=m.throttle&&"number"===typeof m.stall||d.makeServerError("error in post-processing function",m).assertOk();let n=(0,i.A)(F,this).slotInterval*Math.trunc(Math.random()*Math.pow(2,e));return m.stall>=0&&(n=m.stall),(0,s.A)(W,p=o.clone(),H).call(p,e+1,t,n,r,d)}}return d}var V=new WeakMap,G=new WeakMap,J=new WeakMap,Q=new WeakMap,K=new WeakMap,Y=new WeakMap;class q{toString(){return"<FetchResponse status=".concat(this.statusCode," body=").concat((0,i.A)(Q,this)?(0,c.c$)((0,i.A)(Q,this)):"null",">")}get statusCode(){return(0,i.A)(V,this)}get statusMessage(){return(0,i.A)(G,this)}get headers(){return Object.assign({},(0,i.A)(J,this))}get body(){return null==(0,i.A)(Q,this)?null:new Uint8Array((0,i.A)(Q,this))}get bodyText(){try{return null==(0,i.A)(Q,this)?"":(0,h._v)((0,i.A)(Q,this))}catch(e){(0,u.vA)(!1,"response body is not valid UTF-8 data","UNSUPPORTED_OPERATION",{operation:"bodyText",info:{response:this}})}}get bodyJson(){try{return JSON.parse(this.bodyText)}catch(e){(0,u.vA)(!1,"response body is not valid JSON","UNSUPPORTED_OPERATION",{operation:"bodyJson",info:{response:this}})}}[Symbol.iterator](){const e=this.headers,t=Object.keys(e);let n=0;return{next:()=>{if(n<t.length){const r=t[n++];return{value:[r,e[r]],done:!1}}return{value:void 0,done:!0}}}}constructor(e,t,n,r,s){(0,a.A)(this,V,void 0),(0,a.A)(this,G,void 0),(0,a.A)(this,J,void 0),(0,a.A)(this,Q,void 0),(0,a.A)(this,K,void 0),(0,a.A)(this,Y,void 0),(0,o.A)(V,this,e),(0,o.A)(G,this,t),(0,o.A)(J,this,Object.keys(n).reduce((e,t)=>(e[t.toLowerCase()]=String(n[t]),e),{})),(0,o.A)(Q,this,null==r?null:new Uint8Array(r)),(0,o.A)(K,this,s||null),(0,o.A)(Y,this,{message:""})}makeServerError(e,t){let n;e?n="CLIENT ESCALATED SERVER ERROR (".concat(this.statusCode," ").concat(this.statusMessage,"; ").concat(e,")"):(e="".concat(this.statusCode," ").concat(this.statusMessage),n="CLIENT ESCALATED SERVER ERROR (".concat(e,")"));const r=new q(599,n,this.headers,this.body,(0,i.A)(K,this)||void 0);return(0,o.A)(Y,r,{message:e,error:t}),r}throwThrottleError(e,t){null==t?t=-1:(0,u.MR)(Number.isInteger(t)&&t>=0,"invalid stall timeout","stall",t);const n=new Error(e||"throttling requests");throw(0,d.n)(n,{stall:t,throttle:!0}),n}getHeader(e){return this.headers[e.toLowerCase()]}hasBody(){return null!=(0,i.A)(Q,this)}get request(){return(0,i.A)(K,this)}ok(){return""===(0,i.A)(Y,this).message&&this.statusCode>=200&&this.statusCode<300}assertOk(){if(this.ok())return;let{message:e,error:t}=(0,i.A)(Y,this);""===e&&(e="server response ".concat(this.statusCode," ").concat(this.statusMessage));let n=null;this.request&&(n=this.request.url);let r=null;try{(0,i.A)(Q,this)&&(r=(0,h._v)((0,i.A)(Q,this)))}catch(s){}(0,u.vA)(!1,e,"SERVER_ERROR",{request:this.request||"unknown request",response:this,error:t,info:{requestUrl:n,responseBody:r,responseStatus:"".concat(this.statusCode," ").concat(this.statusMessage)}})}}function X(){return(new Date).getTime()}},8755(e,t,n){"use strict";n.d(t,{I:()=>k});var r,s=n(9790),a=n(5149),i=n(4705),o=n(6562),l=n(8458),c=n(2177),u=n(686),d=n(5977),h=n(2731),f=n(3451);const p=BigInt(-1),m=BigInt(0),g=BigInt(1),y=BigInt(5),w={};let v="0000";for(;v.length<80;)v+=v;function A(e){let t=v;for(;t.length<e;)t+=t;return BigInt("1"+t.substring(0,e))}function b(e,t,n){const r=BigInt(t.width);if(t.signed){const t=g<<r-g;(0,d.vA)(null==n||e>=-t&&e<t,"overflow","NUMERIC_FAULT",{operation:n,fault:"overflow",value:e}),e=e>m?(0,h.ST)((0,h.dK)(e,r),r):-(0,h.ST)((0,h.dK)(-e,r),r)}else{const t=g<<r;(0,d.vA)(null==n||e>=0&&e<t,"overflow","NUMERIC_FAULT",{operation:n,fault:"overflow",value:e}),e=(e%t+t)%t&t-g}return e}function x(e){"number"===typeof e&&(e="fixed128x".concat(e));let t=!0,n=128,r=18;if("string"===typeof e)if("fixed"===e);else if("ufixed"===e)t=!1;else{const s=e.match(/^(u?)fixed([0-9]+)x([0-9]+)$/);(0,d.MR)(s,"invalid fixed format","format",e),t="u"!==s[1],n=parseInt(s[2]),r=parseInt(s[3])}else if(e){const s=e,a=(e,t,n)=>null==s[e]?n:((0,d.MR)(typeof s[e]===t,"invalid fixed format ("+e+" not "+t+")","format."+e,s[e]),s[e]);t=a("signed","boolean",t),n=a("width","number",n),r=a("decimals","number",r)}(0,d.MR)(n%8===0,"invalid FixedNumber width (not byte aligned)","format.width",n),(0,d.MR)(r<=80,"invalid FixedNumber decimals (too large)","format.decimals",r);return{signed:t,width:n,decimals:r,name:(t?"":"u")+"fixed"+String(n)+"x"+String(r)}}var S=new WeakMap,C=new WeakMap,E=new WeakMap,N=new WeakSet;class k{constructor(e,t,n){(0,s.A)(this,N),(0,i.A)(this,"format",void 0),(0,a.A)(this,S,void 0),(0,a.A)(this,C,void 0),(0,a.A)(this,E,void 0),(0,i.A)(this,"_value",void 0),(0,d.gk)(e,w,"FixedNumber"),(0,c.A)(C,this,t),(0,c.A)(S,this,n);const r=function(e,t){let n="";e<m&&(n="-",e*=p);let r=e.toString();if(0===t)return n+r;for(;r.length<=t;)r=v+r;const s=r.length-t;for(r=r.substring(0,s)+"."+r.substring(s);"0"===r[0]&&"."!==r[1];)r=r.substring(1);for(;"0"===r[r.length-1]&&"."!==r[r.length-2];)r=r.substring(0,r.length-1);return n+r}(t,n.decimals);(0,f.n)(this,{format:n.name,_value:r}),(0,c.A)(E,this,A(n.decimals))}get signed(){return(0,l.A)(S,this).signed}get width(){return(0,l.A)(S,this).width}get decimals(){return(0,l.A)(S,this).decimals}get value(){return(0,l.A)(C,this)}addUnsafe(e){return(0,o.A)(N,this,_).call(this,e)}add(e){return(0,o.A)(N,this,_).call(this,e,"add")}subUnsafe(e){return(0,o.A)(N,this,R).call(this,e)}sub(e){return(0,o.A)(N,this,R).call(this,e,"sub")}mulUnsafe(e){return(0,o.A)(N,this,M).call(this,e)}mul(e){return(0,o.A)(N,this,M).call(this,e,"mul")}mulSignal(e){(0,o.A)(N,this,T).call(this,e);const t=(0,l.A)(C,this)*(0,l.A)(C,e);return(0,d.vA)(t%(0,l.A)(E,this)===m,"precision lost during signalling mul","NUMERIC_FAULT",{operation:"mulSignal",fault:"underflow",value:this}),(0,o.A)(N,this,I).call(this,t/(0,l.A)(E,this),"mulSignal")}divUnsafe(e){return(0,o.A)(N,this,D).call(this,e)}div(e){return(0,o.A)(N,this,D).call(this,e,"div")}divSignal(e){(0,d.vA)((0,l.A)(C,e)!==m,"division by zero","NUMERIC_FAULT",{operation:"div",fault:"divide-by-zero",value:this}),(0,o.A)(N,this,T).call(this,e);const t=(0,l.A)(C,this)*(0,l.A)(E,this);return(0,d.vA)(t%(0,l.A)(C,e)===m,"precision lost during signalling div","NUMERIC_FAULT",{operation:"divSignal",fault:"underflow",value:this}),(0,o.A)(N,this,I).call(this,t/(0,l.A)(C,e),"divSignal")}cmp(e){let t=this.value,n=e.value;const r=this.decimals-e.decimals;return r>0?n*=A(r):r<0&&(t*=A(-r)),t<n?-1:t>n?1:0}eq(e){return 0===this.cmp(e)}lt(e){return this.cmp(e)<0}lte(e){return this.cmp(e)<=0}gt(e){return this.cmp(e)>0}gte(e){return this.cmp(e)>=0}floor(){let e=(0,l.A)(C,this);return(0,l.A)(C,this)<m&&(e-=(0,l.A)(E,this)-g),e=(0,l.A)(C,this)/(0,l.A)(E,this)*(0,l.A)(E,this),(0,o.A)(N,this,I).call(this,e,"floor")}ceiling(){let e=(0,l.A)(C,this);return(0,l.A)(C,this)>m&&(e+=(0,l.A)(E,this)-g),e=(0,l.A)(C,this)/(0,l.A)(E,this)*(0,l.A)(E,this),(0,o.A)(N,this,I).call(this,e,"ceiling")}round(e){if(null==e&&(e=0),e>=this.decimals)return this;const t=this.decimals-e,n=y*A(t-1);let r=this.value+n;const s=A(t);return r=r/s*s,b(r,(0,l.A)(S,this),"round"),new k(w,r,(0,l.A)(S,this))}isZero(){return(0,l.A)(C,this)===m}isNegative(){return(0,l.A)(C,this)<m}toString(){return this._value}toUnsafeFloat(){return parseFloat(this.toString())}toFormat(e){return k.fromString(this.toString(),e)}static fromValue(e,t,n){const r=null==t?0:(0,h.WZ)(t),s=x(n);let a=(0,h.Ab)(e,"value");const i=r-s.decimals;if(i>0){const t=A(i);(0,d.vA)(a%t===m,"value loses precision for format","NUMERIC_FAULT",{operation:"fromValue",fault:"underflow",value:e}),a/=t}else i<0&&(a*=A(-i));return b(a,s,"fromValue"),new k(w,a,s)}static fromString(e,t){const n=e.match(/^(-?)([0-9]*)\.?([0-9]*)$/);(0,d.MR)(n&&n[2].length+n[3].length>0,"invalid FixedNumber string value","value",e);const r=x(t);let s=n[2]||"0",a=n[3]||"";for(;a.length<r.decimals;)a+=v;(0,d.vA)(a.substring(r.decimals).match(/^0*$/),"too many decimals for format","NUMERIC_FAULT",{operation:"fromString",fault:"underflow",value:e}),a=a.substring(0,r.decimals);const i=BigInt(n[1]+s+a);return b(i,r,"fromString"),new k(w,i,r)}static fromBytes(e,t){let n=(0,h.Dg)((0,u.q5)(e,"value"));const r=x(t);return r.signed&&(n=(0,h.ST)(n,r.width)),b(n,r,"fromBytes"),new k(w,n,r)}}function T(e){(0,d.MR)(this.format===e.format,"incompatible format; use fixedNumber.toFormat","other",e)}function I(e,t){return e=b(e,(0,l.A)(S,this),t),new r(w,e,(0,l.A)(S,this))}function _(e,t){return(0,o.A)(N,this,T).call(this,e),(0,o.A)(N,this,I).call(this,(0,l.A)(C,this)+(0,l.A)(C,e),t)}function R(e,t){return(0,o.A)(N,this,T).call(this,e),(0,o.A)(N,this,I).call(this,(0,l.A)(C,this)-(0,l.A)(C,e),t)}function M(e,t){return(0,o.A)(N,this,T).call(this,e),(0,o.A)(N,this,I).call(this,(0,l.A)(C,this)*(0,l.A)(C,e)/(0,l.A)(E,this),t)}function D(e,t){return(0,d.vA)((0,l.A)(C,e)!==m,"division by zero","NUMERIC_FAULT",{operation:"div",fault:"divide-by-zero",value:this}),(0,o.A)(N,this,T).call(this,e),(0,o.A)(N,this,I).call(this,(0,l.A)(C,this)*(0,l.A)(E,this)/(0,l.A)(C,e),t)}r=k},2731(e,t,n){"use strict";n.d(t,{Ab:()=>d,Dg:()=>p,JJ:()=>c,Ro:()=>g,ST:()=>l,WZ:()=>m,c4:()=>w,dK:()=>u,nD:()=>v,nm:()=>h,up:()=>y});var r=n(686),s=n(5977);const a=BigInt(0),i=BigInt(1),o=9007199254740991;function l(e,t){const n=h(e,"value"),r=BigInt(m(t,"width"));if((0,s.vA)(n>>r===a,"overflow","NUMERIC_FAULT",{operation:"fromTwos",fault:"overflow",value:e}),n>>r-i){return-((~n&(i<<r)-i)+i)}return n}function c(e,t){let n=d(e,"value");const r=BigInt(m(t,"width")),o=i<<r-i;if(n<a){n=-n,(0,s.vA)(n<=o,"too low","NUMERIC_FAULT",{operation:"toTwos",fault:"overflow",value:e});return(~n&(i<<r)-i)+i}return(0,s.vA)(n<o,"too high","NUMERIC_FAULT",{operation:"toTwos",fault:"overflow",value:e}),n}function u(e,t){const n=h(e,"value"),r=BigInt(m(t,"bits"));return n&(i<<r)-i}function d(e,t){switch(typeof e){case"bigint":return e;case"number":return(0,s.MR)(Number.isInteger(e),"underflow",t||"value",e),(0,s.MR)(e>=-o&&e<=o,"overflow",t||"value",e),BigInt(e);case"string":try{if(""===e)throw new Error("empty string");return"-"===e[0]&&"-"!==e[1]?-BigInt(e.substring(1)):BigInt(e)}catch(n){(0,s.MR)(!1,"invalid BigNumberish string: ".concat(n.message),t||"value",e)}}(0,s.MR)(!1,"invalid BigNumberish value",t||"value",e)}function h(e,t){const n=d(e,t);return(0,s.vA)(n>=a,"unsigned value cannot be negative","NUMERIC_FAULT",{fault:"overflow",operation:"getUint",value:e}),n}const f="0123456789abcdef";function p(e){if(e instanceof Uint8Array){let t="0x0";for(const n of e)t+=f[n>>4],t+=f[15&n];return BigInt(t)}return d(e)}function m(e,t){switch(typeof e){case"bigint":return(0,s.MR)(e>=-o&&e<=o,"overflow",t||"value",e),Number(e);case"number":return(0,s.MR)(Number.isInteger(e),"underflow",t||"value",e),(0,s.MR)(e>=-o&&e<=o,"overflow",t||"value",e),e;case"string":try{if(""===e)throw new Error("empty string");return m(BigInt(e),t)}catch(n){(0,s.MR)(!1,"invalid numeric string: ".concat(n.message),t||"value",e)}}(0,s.MR)(!1,"invalid numeric value",t||"value",e)}function g(e){return m(p(e))}function y(e,t){let n=h(e,"value").toString(16);if(null==t)n.length%2&&(n="0"+n);else{const r=m(t,"width");for((0,s.vA)(2*r>=n.length,"value exceeds width (".concat(r," bytes)"),"NUMERIC_FAULT",{operation:"toBeHex",fault:"overflow",value:e});n.length<2*r;)n="0"+n}return"0x"+n}function w(e){const t=h(e,"value");if(t===a)return new Uint8Array([]);let n=t.toString(16);n.length%2&&(n="0"+n);const r=new Uint8Array(n.length/2);for(let s=0;s<r.length;s++){const e=2*s;r[s]=parseInt(n.substring(e,e+2),16)}return r}function v(e){let t=(0,r.c$)((0,r.f)(e)?e:w(e)).substring(2);for(;t.startsWith("0");)t=t.substring(1);return""===t&&(t="0"),"0x"+t}},3451(e,t,n){"use strict";function r(e,t,n){const r=t.split("|").map(e=>e.trim());for(let a=0;a<r.length;a++)switch(t){case"any":return;case"bigint":case"boolean":case"number":case"string":if(typeof e===t)return}const s=new Error("invalid value for type ".concat(t));throw s.code="INVALID_ARGUMENT",s.argument="value.".concat(n),s.value=e,s}async function s(e){const t=Object.keys(e);return(await Promise.all(t.map(t=>Promise.resolve(e[t])))).reduce((e,n,r)=>(e[t[r]]=n,e),{})}function a(e,t,n){for(let s in t){let a=t[s];const i=n?n[s]:null;i&&r(a,i,s),Object.defineProperty(e,s,{enumerable:!0,value:a,writable:!1})}}n.d(t,{k:()=>s,n:()=>a})},537(e,t,n){"use strict";n.d(t,{J:()=>c});var r=n(686),s=n(5977);function a(e){let t=e.toString(16);for(;t.length<2;)t="0"+t;return"0x"+t}function i(e,t,n){let r=0;for(let s=0;s<n;s++)r=256*r+e[t+s];return r}function o(e,t,n,r){const a=[];for(;n<t+1+r;){const i=l(e,n);a.push(i.result),n+=i.consumed,(0,s.vA)(n<=t+1+r,"child data too short","BUFFER_OVERRUN",{buffer:e,length:r,offset:t})}return{consumed:1+r,result:a}}function l(e,t){(0,s.vA)(0!==e.length,"data too short","BUFFER_OVERRUN",{buffer:e,length:0,offset:1});const n=t=>{(0,s.vA)(t<=e.length,"data short segment too short","BUFFER_OVERRUN",{buffer:e,length:e.length,offset:t})};if(e[t]>=248){const r=e[t]-247;n(t+1+r);const s=i(e,t+1,r);return n(t+1+r+s),o(e,t,t+1+r,r+s)}if(e[t]>=192){const r=e[t]-192;return n(t+1+r),o(e,t,t+1,r)}if(e[t]>=184){const s=e[t]-183;n(t+1+s);const a=i(e,t+1,s);n(t+1+s+a);return{consumed:1+s+a,result:(0,r.c$)(e.slice(t+1+s,t+1+s+a))}}if(e[t]>=128){const s=e[t]-128;n(t+1+s);return{consumed:1+s,result:(0,r.c$)(e.slice(t+1,t+1+s))}}return{consumed:1,result:a(e[t])}}function c(e){const t=(0,r.q5)(e,"data"),n=l(t,0);return(0,s.MR)(n.consumed===t.length,"unexpected junk after rlp payload","data",e),n.result}},5889(e,t,n){"use strict";n.d(t,{R:()=>o});var r=n(686);function s(e){const t=[];for(;e;)t.unshift(255&e),e>>=8;return t}function a(e){if(Array.isArray(e)){let t=[];if(e.forEach(function(e){t=t.concat(a(e))}),t.length<=55)return t.unshift(192+t.length),t;const n=s(t.length);return n.unshift(247+n.length),n.concat(t)}const t=Array.prototype.slice.call((0,r.q5)(e,"object"));if(1===t.length&&t[0]<=127)return t;if(t.length<=55)return t.unshift(128+t.length),t;const n=s(t.length);return n.unshift(183+n.length),n.concat(t)}const i="0123456789abcdef";function o(e){let t="0x";for(const n of a(e))t+=i[n>>4],t+=i[15&n];return t}},2443(e,t,n){"use strict";n.d(t,{Js:()=>o,XS:()=>l,ck:()=>c,g5:()=>u});var r=n(5977),s=n(8755),a=n(2731);const i=["wei","kwei","mwei","gwei","szabo","finney","ether"];function o(e,t){let n=18;if("string"===typeof t){const e=i.indexOf(t);(0,r.MR)(e>=0,"invalid unit","unit",t),n=3*e}else null!=t&&(n=(0,a.WZ)(t,"unit"));return s.I.fromValue(e,n,{decimals:n,width:512}).toString()}function l(e,t){(0,r.MR)("string"===typeof e,"value must be a string","value",e);let n=18;if("string"===typeof t){const e=i.indexOf(t);(0,r.MR)(e>=0,"invalid unit","unit",t),n=3*e}else null!=t&&(n=(0,a.WZ)(t,"unit"));return s.I.fromString(e,{decimals:n,width:512}).value}function c(e){return o(e,18)}function u(e){return l(e,18)}},85(e,t,n){"use strict";n.d(t,{YW:()=>l,_v:()=>c,d5:()=>i,dg:()=>u});var r=n(686),s=n(5977);function a(e,t,n,r,s){if("BAD_PREFIX"===e||"UNEXPECTED_CONTINUE"===e){let e=0;for(let r=t+1;r<n.length&&n[r]>>6===2;r++)e++;return e}return"OVERRUN"===e?n.length-t-1:0}const i=Object.freeze({error:function(e,t,n,r,a){(0,s.MR)(!1,"invalid codepoint at offset ".concat(t,"; ").concat(e),"bytes",n)},ignore:a,replace:function(e,t,n,r,i){return"OVERLONG"===e?((0,s.MR)("number"===typeof i,"invalid bad code point for replacement","badCodepoint",i),r.push(i),0):(r.push(65533),a(e,t,n))}});function o(e,t){null==t&&(t=i.error);const n=(0,r.q5)(e,"bytes"),s=[];let a=0;for(;a<n.length;){const e=n[a++];if(e>>7===0){s.push(e);continue}let r=null,i=null;if(192===(224&e))r=1,i=127;else if(224===(240&e))r=2,i=2047;else{if(240!==(248&e)){a+=t(128===(192&e)?"UNEXPECTED_CONTINUE":"BAD_PREFIX",a-1,n,s);continue}r=3,i=65535}if(a-1+r>=n.length){a+=t("OVERRUN",a-1,n,s);continue}let o=e&(1<<8-r-1)-1;for(let l=0;l<r;l++){let e=n[a];if(128!=(192&e)){a+=t("MISSING_CONTINUE",a,n,s),o=null;break}o=o<<6|63&e,a++}null!==o&&(o>1114111?a+=t("OUT_OF_RANGE",a-1-r,n,s,o):o>=55296&&o<=57343?a+=t("UTF16_SURROGATE",a-1-r,n,s,o):o<=i?a+=t("OVERLONG",a-1-r,n,s,o):s.push(o))}return s}function l(e,t){(0,s.MR)("string"===typeof e,"invalid string value","str",e),null!=t&&((0,s.SP)(t),e=e.normalize(t));let n=[];for(let r=0;r<e.length;r++){const t=e.charCodeAt(r);if(t<128)n.push(t);else if(t<2048)n.push(t>>6|192),n.push(63&t|128);else if(55296==(64512&t)){r++;const a=e.charCodeAt(r);(0,s.MR)(r<e.length&&56320===(64512&a),"invalid surrogate pair","str",e);const i=65536+((1023&t)<<10)+(1023&a);n.push(i>>18|240),n.push(i>>12&63|128),n.push(i>>6&63|128),n.push(63&i|128)}else n.push(t>>12|224),n.push(t>>6&63|128),n.push(63&t|128)}return new Uint8Array(n)}function c(e,t){return o(e,t).map(e=>e<=65535?String.fromCharCode(e):(e-=65536,String.fromCharCode(55296+(e>>10&1023),56320+(1023&e)))).join("")}function u(e,t){return o(l(e,t))}},821(e,t,n){"use strict";n.d(t,{Q:()=>s});var r=n(686);function s(e){const t=(0,r.q5)(e,"randomBytes");t[6]=15&t[6]|64,t[8]=63&t[8]|128;const n=(0,r.c$)(t);return[n.substring(2,10),n.substring(10,14),n.substring(14,18),n.substring(18,22),n.substring(22,34)].join("-")}},4411(e,t,n){"use strict";n.d(t,{L:()=>A});var r=n(5149),s=n(4705),a=n(8458),i=n(2177),o=n(1009),l=n(1132),c=n(6338),u=n(1300),d=n(5424),h=n(1028),f=n(7750),p=n(5981),m=n(4681),g=n(5977),y=n(2731),w=n(3451),v=new WeakMap;class A extends h.Z{constructor(e,t){super(t),(0,s.A)(this,"address",void 0),(0,r.A)(this,v,void 0),(0,g.MR)(e&&"function"===typeof e.sign,"invalid private key","privateKey","[ REDACTED ]"),(0,i.A)(v,this,e);const n=(0,p.K)(this.signingKey.publicKey);(0,w.n)(this,{address:n})}get signingKey(){return(0,a.A)(v,this)}get privateKey(){return this.signingKey.privateKey}async getAddress(){return this.address}connect(e){return new A((0,a.A)(v,this),e)}async signTransaction(e){e=(0,f.VS)(e);const{to:t,from:n}=await(0,w.k)({to:e.to?(0,l.tG)(e.to,this):void 0,from:e.from?(0,l.tG)(e.from,this):void 0});null!=t&&(e.to=t),null!=n&&(e.from=n),null!=e.from&&((0,g.MR)((0,o.b)(e.from)===this.address,"transaction from address mismatch","tx.from",e.from),delete e.from);const r=m.Z.from(e);return r.signature=this.signingKey.sign(r.unsignedHash),r.serialized}async signMessage(e){return this.signMessageSync(e)}signMessageSync(e){return this.signingKey.sign((0,u.A)(e)).serialized}authorizeSync(e){(0,g.MR)("string"===typeof e.address,"invalid address for authorizeSync","auth.address",e);const t=this.signingKey.sign((0,c.C)(e));return Object.assign({},{address:(0,o.b)(e.address),nonce:(0,y.Ab)(e.nonce||0),chainId:(0,y.Ab)(e.chainId||0)},{signature:t})}async authorize(e){return e=Object.assign({},e,{address:await(0,l.tG)(e.address,this)}),this.authorizeSync(await this.populateAuthorization(e))}async signTypedData(e,t,n){const r=await d.z.resolveNames(e,t,n,async e=>{(0,g.vA)(null!=this.provider,"cannot resolve ENS names without a provider","UNSUPPORTED_OPERATION",{operation:"resolveName",info:{name:e}});const t=await this.provider.resolveName(e);return(0,g.vA)(null!=t,"unconfigured ENS name","UNCONFIGURED_NAME",{value:e}),t});return this.signingKey.sign(d.z.hash(r.domain,t,r.value)).serialized}}},177(e,t,n){"use strict";n.d(t,{C8:()=>B,LL:()=>L,QX:()=>D,WZ:()=>P,jb:()=>S});var r,s=n(9790),a=n(4705),i=n(6562),o=n(4827),l=n(738),c=n(5955),u=n(536),d=n(3508),h=n(1028),f=n(5981),p=n(70),m=n(686),g=n(5977),y=n(2731),w=n(3451),v=n(3008),A=n(4411),b=n(5936),x=n(3431);const S="m/44'/60'/0'/0/0",C=new Uint8Array([66,105,116,99,111,105,110,32,115,101,101,100]),E=2147483648,N=BigInt("0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141");function k(e,t){let n="";for(;e;)n="0123456789abcdef"[e%16]+n,e=Math.trunc(e/16);for(;n.length<2*t;)n="0"+n;return"0x"+n}function T(e){const t=(0,m.q5)(e),n=(0,m.ZG)((0,u.s)((0,u.s)(t)),0,4),r=(0,m.xW)([t,n]);return(0,p.R)(r)}const I={};function _(e,t,n,r){const s=new Uint8Array(37);e&E?((0,g.vA)(null!=r,"cannot derive child of neutered node","UNSUPPORTED_OPERATION",{operation:"deriveChild"}),s.set((0,m.q5)(r),1)):s.set((0,m.q5)(n));for(let i=24;i>=0;i-=8)s[33+(i>>3)]=e>>24-i&255;const a=(0,m.q5)((0,o.L)("sha512",t,s));return{IL:a.slice(0,32),IR:a.slice(32)}}function R(e,t){const n=t.split("/");(0,g.MR)(n.length>0,"invalid path","path",t),"m"===n[0]&&((0,g.MR)(0===e.depth,'cannot derive root path (i.e. path starting with "m/") for a node at non-zero depth '.concat(e.depth),"path",t),n.shift());let r=e;for(let s=0;s<n.length;s++){const e=n[s];if(e.match(/^[0-9]+'$/)){const t=parseInt(e.substring(0,e.length-1));(0,g.MR)(t<E,"invalid path index","path[".concat(s,"]"),e),r=r.deriveChild(E+t)}else if(e.match(/^[0-9]+$/)){const t=parseInt(e);(0,g.MR)(t<E,"invalid path index","path[".concat(s,"]"),e),r=r.deriveChild(t)}else(0,g.MR)(!1,"invalid path component","path[".concat(s,"]"),e)}return r}var M=new WeakSet;class D extends A.L{constructor(e,t,n,r,i,o,c,d,h){super(t,h),(0,s.A)(this,M),(0,a.A)(this,"publicKey",void 0),(0,a.A)(this,"fingerprint",void 0),(0,a.A)(this,"parentFingerprint",void 0),(0,a.A)(this,"mnemonic",void 0),(0,a.A)(this,"chainCode",void 0),(0,a.A)(this,"path",void 0),(0,a.A)(this,"index",void 0),(0,a.A)(this,"depth",void 0),(0,g.gk)(e,I,"HDNodeWallet"),(0,w.n)(this,{publicKey:t.compressedPublicKey});const f=(0,m.ZG)((0,l.H)((0,u.s)(this.publicKey)),0,4);(0,w.n)(this,{parentFingerprint:n,fingerprint:f,chainCode:r,path:i,index:o,depth:c}),(0,w.n)(this,{mnemonic:d})}connect(e){return new D(I,this.signingKey,this.parentFingerprint,this.chainCode,this.path,this.index,this.depth,this.mnemonic,e)}async encrypt(e,t){return await(0,x.Ej)((0,i.A)(M,this,j).call(this),e,{progressCallback:t})}encryptSync(e){return(0,x.pv)((0,i.A)(M,this,j).call(this),e)}get extendedKey(){return(0,g.vA)(this.depth<256,"Depth too deep","UNSUPPORTED_OPERATION",{operation:"extendedKey"}),T((0,m.xW)(["0x0488ADE4",k(this.depth,1),this.parentFingerprint,k(this.index,4),this.chainCode,(0,m.xW)(["0x00",this.privateKey])]))}hasPath(){return null!=this.path}neuter(){return new P(I,this.address,this.publicKey,this.parentFingerprint,this.chainCode,this.path,this.index,this.depth,this.provider)}deriveChild(e){const t=(0,y.WZ)(e,"index");(0,g.MR)(t<=4294967295,"invalid index","index",t);let n=this.path;n&&(n+="/"+(2147483647&t),t&E&&(n+="'"));const{IR:r,IL:s}=_(t,this.chainCode,this.publicKey,this.privateKey),a=new d.h((0,y.up)(((0,y.Dg)(s)+BigInt(this.privateKey))%N,32));return new D(I,a,this.fingerprint,(0,m.c$)(r),n,t,this.depth+1,this.mnemonic,this.provider)}derivePath(e){return R(this,e)}static fromExtendedKey(e){const t=(0,y.c4)((0,p.H)(e));(0,g.MR)(82===t.length||T(t.slice(0,78))===e,"invalid extended key","extendedKey","[ REDACTED ]");const n=t[4],r=(0,m.c$)(t.slice(5,9)),s=parseInt((0,m.c$)(t.slice(9,13)).substring(2),16),a=(0,m.c$)(t.slice(13,45)),i=t.slice(45,78);switch((0,m.c$)(t.slice(0,4))){case"0x0488b21e":case"0x043587cf":{const e=(0,m.c$)(i);return new P(I,(0,f.K)(e),e,r,a,null,s,n,null)}case"0x0488ade4":case"0x04358394 ":if(0!==i[0])break;return new D(I,new d.h(i.slice(1)),r,a,null,s,n,null,null)}(0,g.MR)(!1,"invalid extended key prefix","extendedKey","[ REDACTED ]")}static createRandom(e,t,n){null==e&&(e=""),null==t&&(t=S),null==n&&(n=v.U.wordlist());const r=b.v.fromEntropy((0,c.p)(16),e,n);return O.call(D,r.computeSeed(),r).derivePath(t)}static fromMnemonic(e,t){return t||(t=S),O.call(D,e.computeSeed(),e).derivePath(t)}static fromPhrase(e,t,n,r){null==t&&(t=""),null==n&&(n=S),null==r&&(r=v.U.wordlist());const s=b.v.fromPhrase(e,t,r);return O.call(D,s.computeSeed(),s).derivePath(n)}static fromSeed(e){return O.call(D,e,null)}}function j(){const e={address:this.address,privateKey:this.privateKey},t=this.mnemonic;return this.path&&t&&"en"===t.wordlist.locale&&""===t.password&&(e.mnemonic={path:this.path,locale:"en",entropy:t.entropy}),e}function O(e,t){(0,g.MR)((0,m.f)(e),"invalid seed","seed","[REDACTED]");const n=(0,m.q5)(e,"seed");(0,g.MR)(n.length>=16&&n.length<=64,"invalid seed","seed","[REDACTED]");const s=(0,m.q5)((0,o.L)("sha512",C,n)),a=new d.h((0,m.c$)(s.slice(0,32)));return new r(I,a,"0x00000000",(0,m.c$)(s.slice(32)),"m",0,0,t,null)}r=D;class P extends h.J{constructor(e,t,n,r,s,i,o,c,d){super(t,d),(0,a.A)(this,"publicKey",void 0),(0,a.A)(this,"fingerprint",void 0),(0,a.A)(this,"parentFingerprint",void 0),(0,a.A)(this,"chainCode",void 0),(0,a.A)(this,"path",void 0),(0,a.A)(this,"index",void 0),(0,a.A)(this,"depth",void 0),(0,g.gk)(e,I,"HDNodeVoidWallet"),(0,w.n)(this,{publicKey:n});const h=(0,m.ZG)((0,l.H)((0,u.s)(n)),0,4);(0,w.n)(this,{publicKey:n,fingerprint:h,parentFingerprint:r,chainCode:s,path:i,index:o,depth:c})}connect(e){return new P(I,this.address,this.publicKey,this.parentFingerprint,this.chainCode,this.path,this.index,this.depth,e)}get extendedKey(){return(0,g.vA)(this.depth<256,"Depth too deep","UNSUPPORTED_OPERATION",{operation:"extendedKey"}),T((0,m.xW)(["0x0488B21E",k(this.depth,1),this.parentFingerprint,k(this.index,4),this.chainCode,this.publicKey]))}hasPath(){return null!=this.path}deriveChild(e){const t=(0,y.WZ)(e,"index");(0,g.MR)(t<=4294967295,"invalid index","index",t);let n=this.path;n&&(n+="/"+(2147483647&t),t&E&&(n+="'"));const{IR:r,IL:s}=_(t,this.chainCode,this.publicKey,null),a=d.h.addPoints(s,this.publicKey,!0),i=(0,f.K)(a);return new P(I,i,a,this.fingerprint,(0,m.c$)(r),n,t,this.depth+1,this.provider)}derivePath(e){return R(this,e)}}function L(e){const t=(0,y.WZ)(e,"index");return(0,g.MR)(t>=0&&t<E,"invalid account index","index",t),"m/44'/60'/".concat(t,"'/0/0")}function B(e){const t=(0,y.WZ)(e,"index");return(0,g.MR)(t>=0&&t<E,"invalid ac