// security-init.js — CSP 호환 보안 스크립트 (inline에서 분리)

// CSP 위반 보고
document.addEventListener('securitypolicyviolation', function (e) {
    console.error('CSP 위반 감지:', {
        violatedDirective: e.violatedDirective,
        blockedURI: e.blockedURI,
        documentURI: e.documentURI,
        lineNumber: e.lineNumber
    });
});

// 개발자 도구 감지 (간단한 방법)
var devtools = { open: false };
setInterval(function () {
    if (window.outerHeight - window.innerHeight > 160 ||
        window.outerWidth - window.innerWidth > 160) {
        if (!devtools.open) {
            devtools.open = true;
            console.warn('⚠️ 개발자 도구가 감지되었습니다.');
        }
    } else {
        devtools.open = false;
    }
}, 500);

// 콘솔 보안 경고
console.log('%c🛡️ 보안 경고', 'color: red; font-size: 20px; font-weight: bold;');
console.log('%c이 콘솔은 개발자를 위한 브라우저 기능입니다.', 'color: red; font-size: 14px;');

// 전역 오류 처리
window.addEventListener('error', function (e) {
    console.error('전역 오류 감지:', e.error);
});
window.addEventListener('unhandledrejection', function (e) {
    console.error('처리되지 않은 Promise 거부:', e.reason);
});
