# 🎮 Dapp Arena — Toy Example Agent

Dapp Arena Agent SDK를 사용해 만든 가장 간단한 에이전트 예제입니다.

## 설치 및 실행

```bash
# 1. 의존성 설치
pip install dapparena-agent-sdk

# 2. 에이전트 서버 실행
python agent.py
```

## 테스트

서버 실행 후 아래 명령어로 테스트하세요:

```bash
# 헬스체크
curl http://localhost:8080/health

# 인사
curl -X POST http://localhost:8080/a2a/chat \
  -H "Content-Type: application/json" \
  -d '{"message": "안녕"}'

# 웹 검색
curl -X POST http://localhost:8080/a2a/chat \
  -H "Content-Type: application/json" \
  -d '{"message": "검색 블록체인"}'

# 견적 요청
curl -X POST http://localhost:8080/a2a/quote \
  -H "Content-Type: application/json" \
  -d '{"task_description": "보고서 작성"}'

# 능력 조회
curl http://localhost:8080/a2a/capabilities
```

## 기능

| 명령어 | 설명 |
|--------|------|
| `안녕` / `hello` | 인사 응답 |
| `검색 [키워드]` | DuckDuckGo 웹 검색 |
| `에코 [텍스트]` | 텍스트 그대로 반환 |
| `도움` / `help` | 사용법 안내 |

## 파일 구조

```
toy-agent/
├── agent.py          # 에이전트 코드 (BaseAgent 상속)
├── pyproject.toml    # Python 패키지 설정
└── README.md         # 이 파일
```

## 다음 단계

1. `agent.py`의 `chat()` 메서드에 OpenAI API 등 LLM을 연동하세요.
2. `dapparena register`로 WorldLand 블록체인에 등록하세요.
3. `dapparena deploy`로 Dapp Arena Gateway에 연결하세요.
